% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_bsvarSIGN}
\alias{specify_bsvarSIGN}
\title{R6 Class representing the specification of the BSVARSIGN model}
\description{
The class BSVARSIGN presents complete specification for the Bayesian Structural VAR model with sign and narrative restrictions.
}
\examples{
# specify a model with the optimism data and 4 lags

data(optimism)
specification = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)


## ------------------------------------------------
## Method `specify_bsvarSIGN$get_data_matrices`
## ------------------------------------------------

# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the data matrices
spec$get_data_matrices()


## ------------------------------------------------
## Method `specify_bsvarSIGN$get_identification`
## ------------------------------------------------

# specify a model with the optimism data and 4 lags
data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the identifying restrictions
spec$get_identification()


## ------------------------------------------------
## Method `specify_bsvarSIGN$get_prior`
## ------------------------------------------------

# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the prior specification
spec$get_prior()


## ------------------------------------------------
## Method `specify_bsvarSIGN$get_starting_values`
## ------------------------------------------------

# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the starting values
spec$get_starting_values()

}
\seealso{
\code{\link{estimate.BSVARSIGN}}, \code{\link{specify_posterior_bsvarSIGN}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a non-negative integer specifying the autoregressive lag order of the model.}

\item{\code{identification}}{an object IdentificationBSVARSIGN with the identifying restrictions.}

\item{\code{prior}}{an object PriorBSVARSIGN with the prior specification.}

\item{\code{data_matrices}}{an object DataMatricesBSVARSIGN with the data matrices.}

\item{\code{starting_values}}{an object StartingValuesBSVARSIGN with the starting values.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BSVARSIGN-new}{\code{specify_bsvarSIGN$new()}}
\item \href{#method-BSVARSIGN-get_data_matrices}{\code{specify_bsvarSIGN$get_data_matrices()}}
\item \href{#method-BSVARSIGN-get_identification}{\code{specify_bsvarSIGN$get_identification()}}
\item \href{#method-BSVARSIGN-get_prior}{\code{specify_bsvarSIGN$get_prior()}}
\item \href{#method-BSVARSIGN-get_starting_values}{\code{specify_bsvarSIGN$get_starting_values()}}
\item \href{#method-BSVARSIGN-clone}{\code{specify_bsvarSIGN$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-new"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification of the Bayesian Structural VAR model with sign and narrative restrictions BSVARSIGN.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$new(
  data,
  p = 1L,
  sign_irf,
  sign_narrative,
  sign_structural,
  max_tries = Inf,
  exogenous = NULL,
  stationary = rep(FALSE, ncol(data))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{(T+p)xN} matrix with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{sign_irf}}{a \code{NxNxH} array - sign and zero restrictions 
on the impulse response functions, ±1 for positive/negative sign restriction
0 for zero restrictions and NA for no restrictions,
the \code{h}-th slice \code{NxN} matrix contains the
restrictions on the \code{h-1} horizon.}

\item{\code{sign_narrative}}{a list of objects of class "narrative" - narrative sign restrictions.}

\item{\code{sign_structural}}{a \code{NxN} matrix with entries ±1 or NA - sign restrictions on the
contemporaneous relations \code{B} between reduced-form errors \code{E} and
structural shocks \code{U} where \code{BE=U}.}

\item{\code{max_tries}}{a positive integer with the maximum number of iterations
for finding a rotation matrix \eqn{Q} that would satisfy sign restrictions}

\item{\code{exogenous}}{a \code{(T+p)xd} matrix of exogenous variables.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to \code{FALSE} sets
the prior mean for the autoregressive parameters of the \code{N}th equation to the white noise process,
otherwise to random walk.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new complete specification for the Bayesian Structural VAR model BSVARSIGN.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-get_data_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-get_data_matrices}{}}}
\subsection{Method \code{get_data_matrices()}}{
Returns the data matrices as the DataMatricesBSVAR object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$get_data_matrices()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the data matrices
spec$get_data_matrices()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-get_identification"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-get_identification}{}}}
\subsection{Method \code{get_identification()}}{
Returns the identifying restrictions as the IdentificationBSVARSIGN object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$get_identification()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# specify a model with the optimism data and 4 lags
data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the identifying restrictions
spec$get_identification()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-get_prior"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-get_prior}{}}}
\subsection{Method \code{get_prior()}}{
Returns the prior specification as the PriorBSVAR object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$get_prior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the prior specification
spec$get_prior()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the starting values as the StartingValuesBSVAR object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# specify a model with the optimism data and 4 lags

data(optimism)
spec = specify_bsvarSIGN$new(
   data = optimism,
   p = 4
)

# get the starting values
spec$get_starting_values()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARSIGN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARSIGN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvarSIGN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
