% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_msh.R
\name{specify_bsvar_msh}
\alias{specify_bsvar_msh}
\title{R6 Class representing the specification of the BSVAR model with Markov Switching Heteroskedasticity.}
\description{
The class BSVARMSH presents complete specification for the BSVAR model with Markov Switching Heteroskedasticity.
}
\examples{
data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)


## ------------------------------------------------
## Method `specify_bsvar_msh$get_data_matrices`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_data_matrices()


## ------------------------------------------------
## Method `specify_bsvar_msh$get_identification`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_identification()


## ------------------------------------------------
## Method `specify_bsvar_msh$get_prior`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_prior()


## ------------------------------------------------
## Method `specify_bsvar_msh$get_starting_values`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_starting_values()

}
\seealso{
\code{\link{estimate}}, \code{\link{specify_posterior_bsvar_msh}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a non-negative integer specifying the autoregressive lag order of the model.}

\item{\code{identification}}{an object IdentificationBSVARs with the identifying restrictions.}

\item{\code{prior}}{an object PriorBSVARMSH with the prior specification.}

\item{\code{data_matrices}}{an object DataMatricesBSVAR with the data matrices.}

\item{\code{starting_values}}{an object StartingValuesBSVARMSH with the starting values.}

\item{\code{finiteM}}{a logical value - if true a stationary Markov switching model is estimated. Otherwise, a sparse Markov switching model is estimated in which \code{M=20} and the number of visited states is estimated.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BSVARMSH-new}{\code{specify_bsvar_msh$new()}}
\item \href{#method-BSVARMSH-get_data_matrices}{\code{specify_bsvar_msh$get_data_matrices()}}
\item \href{#method-BSVARMSH-get_identification}{\code{specify_bsvar_msh$get_identification()}}
\item \href{#method-BSVARMSH-get_prior}{\code{specify_bsvar_msh$get_prior()}}
\item \href{#method-BSVARMSH-get_starting_values}{\code{specify_bsvar_msh$get_starting_values()}}
\item \href{#method-BSVARMSH-clone}{\code{specify_bsvar_msh$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-new"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification of the BSVAR model with Markov Switching Heteroskedasticity, BSVARMSH.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$new(
  data,
  p = 1L,
  M = 2L,
  B,
  exogenous = NULL,
  stationary = rep(FALSE, ncol(data)),
  finiteM = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{(T+p)xN} matrix with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{M}}{an integer greater than 1 - the number of Markov process' heteroskedastic regimes.}

\item{\code{B}}{a logical \code{NxN} matrix containing value \code{TRUE} for the elements of the structural matrix \eqn{B} to be estimated and value \code{FALSE} for exclusion restrictions to be set to zero.}

\item{\code{exogenous}}{a \code{(T+p)xd} matrix of exogenous variables.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to \code{FALSE} sets the prior mean for the autoregressive parameters of the \code{N}th equation to the white noise process, otherwise to random walk.}

\item{\code{finiteM}}{a logical value - if true a stationary Markov switching model is estimated. Otherwise, a sparse Markov switching model is estimated in which \code{M=20} and the number of visited states is estimated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new complete specification for the bsvar model with Markov Switching Heteroskedasticity, BSVARMSH.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-get_data_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-get_data_matrices}{}}}
\subsection{Method \code{get_data_matrices()}}{
Returns the data matrices as the DataMatricesBSVAR object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$get_data_matrices()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_data_matrices()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-get_identification"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-get_identification}{}}}
\subsection{Method \code{get_identification()}}{
Returns the identifying restrictions as the IdentificationBSVARs object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$get_identification()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_identification()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-get_prior"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-get_prior}{}}}
\subsection{Method \code{get_prior()}}{
Returns the prior specification as the PriorBSVARMSH object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$get_prior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_prior()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the starting values as the StartingValuesBSVARMSH object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_msh$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)
spec$get_starting_values()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMSH-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMSH-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_msh$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
