% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRidMSH}
\alias{summary.SDDRidMSH}
\title{Provides summary of verifying homoskedasticity}
\usage{
\method{summary}{SDDRidMSH}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRidMSH} obtained using the
\code{\link{verify_identification.PosteriorBSVARMSH}} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the logarithm of Bayes factors of homoskedastic to
heteroskedastic posterior odds \code{"log(SDDR)"} for each structural shock, 
their numerical standard errors \code{"NSE"}, and the implied posterior 
probability of the homoskedasticity and heteroskedasticity hypothesis, 
\code{"Pr[homoskedasticity|data]"} and \code{"Pr[heteroskedasticity|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of structural shocks homoskedasticity. The outcomes can be
used to make probabilistic statements about identification through 
heteroskedasticity closely following ideas by Lütkepohl& Woźniak (2020).
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, M = 2)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_msh$new(M = 2) |>
  estimate(S = 10) |> 
  verify_identification() |> 
  summary() -> sddr_summary

}
\references{
Lütkepohl, H., and Woźniak, T., (2020) Bayesian Inference for Structural Vector Autoregressions Identified by Markov-Switching Heteroskedasticity. \emph{Journal of Economic Dynamics and Control} \bold{113}, 103862, \doi{10.1016/j.jedc.2020.103862}.
}
\seealso{
\code{\link{verify_identification.PosteriorBSVARMSH}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
