% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{handleMissings}
\alias{handleMissings}
\title{Handle missing data in matrices}
\usage{
handleMissings(mat, na = NA, method = "remove", logical = FALSE)
}
\arguments{
\item{mat}{A matrix object.}

\item{na}{The value that missing data are coded as. Usually \code{NA},
sometimes \code{9} or \code{10}.}

\item{method}{What should be done with the missing data? If
\code{method = "remove"} is set, the function determines how many missing
entries are in each row and column and iteratively removes rows or columns
with the largest amount of missing data until no missing data are left in
the matrix. If \code{method = "fillmode"} is set, the modal value of the
matrix is identified (usually \code{0} in network matrices) and missing
cells are imputed by filling in this modal value. \code{method = "zero"}
replaces NAs by 0s.}

\item{logical}{Return a matrix with logical values indicating which cells
should be removed? By default the manipulated matrix is returned.}
}
\value{
Either a matrix in which missing data were taken care of or a matrix
  indicating where missing data are located.
}
\description{
Process \code{NA} values (= remove nodes with \code{NA}s iteratively).
}
\details{
This function deals with missing data in matrices or network objects used for
inferential network analysis. It can either remove missing rows and/or
columns iteratively (rows and columns with more \code{NA} values first, then
successively rows and columns with fewer \code{NA} entries) or replace
missing values by the modal value of the matrix or by \code{0}. The function
can return either the manipulated matrix or a matrix with logical values
indicating which of the cells should be removed.
}
\seealso{
\code{\link{adjust}}
}
