% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventlog.R
\name{eventlog}
\alias{eventlog}
\alias{ieventlog}
\title{Eventlog}
\usage{
eventlog(eventlog, case_id = NULL, activity_id = NULL,
  activity_instance_id = NULL, lifecycle_id = NULL, timestamp = NULL,
  resource_id = NULL, order = "auto", validate = TRUE)

ieventlog(eventlog)
}
\arguments{
\item{eventlog}{The data object to be used as event log. This can be a
\code{data.frame} or \code{tbl_df}.}

\item{case_id}{The case classifier of the event log. A character vector containing variable names of length 1 or more.}

\item{activity_id}{The activity classifier of the event log. A character vector containing variable names of length 1 or more.}

\item{activity_instance_id}{The activity instance classifier of the event log.}

\item{lifecycle_id}{The life cycle classifier of the event log.}

\item{timestamp}{The timestamp of the event log. Should refer to a Date or POSIXct field.}

\item{resource_id}{The resource identifier of the event log. A character vector containing variable names of length 1 or more.}

\item{order}{Configure how to handle sort events with equal timestamps:
auto will use the order in the original data,
alphabetical will sort the activity labels by alphabet,
sorted will assume that the data frame is already correctly sorted and has a column '.order',
providing a column name will use this column for ordering (can be numeric of character).
The latter will never overrule timestamp orderings.}

\item{validate}{When `TRUE` some basic checks are run on the contents of the event log such as that activity instances are
not connected to more than one case or activity. Using `FALSE` improves the performance by skipping those checks.}
}
\description{
A function to instantiate an object of class \code{eventlog} by specifying a
\code{data.frame} or \code{tbl_df} and appropriate case, activity and
timestamp classifiers.
}
\examples{
\dontrun{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
activity_instance_id = 1:5,
lifecycle_id = rep("complete",5),
timestamp = 1:5,
resource = rep("resource 1", 5))
eventlog(data,case_id = "case",
activity_id = "activity_id",
activity_instance_id = "activity_instance_id",
lifecycle_id = "lifecycle_id",
timestamp = "timestamp",
resource_id = "resource")
}
}
\seealso{
\code{\link{case_id}}, \code{\link{activity_id}},
\code{\link{activity_instance_id}},\code{\link{lifecycle_id}},
 \code{\link{timestamp}}
}
