% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_model_fit.R
\name{axe-nested_model_fit}
\alias{axe-nested_model_fit}
\alias{axe_call.nested_model_fit}
\alias{axe_ctrl.nested_model_fit}
\alias{axe_data.nested_model_fit}
\alias{axe_env.nested_model_fit}
\alias{axe_fitted.nested_model_fit}
\title{Axing a nested_model_fit.}
\usage{
\method{axe_call}{nested_model_fit}(x, verbose = FALSE, ...)

\method{axe_ctrl}{nested_model_fit}(x, verbose = FALSE, ...)

\method{axe_data}{nested_model_fit}(x, verbose = FALSE, ...)

\method{axe_env}{nested_model_fit}(x, verbose = FALSE, ...)

\method{axe_fitted}{nested_model_fit}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed nested_model_fit object.
}
\description{
nested_model_fit objects are created from the \pkg{nestedmodels}
package, which allows parsnip models to be fitted on nested data. Axing a
nested_model_fit object involves axing all the inner model_fit objects.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "nestedmodels"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(nestedmodels)
library(parsnip)

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

nested_data <- tidyr::nest(example_nested_data, data = -id)

fit <- fit(model, z ~ x + y + a + b, nested_data)

# Reduce the model size
butcher(fit)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{axe-model_fit}
}
