% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bvec.R, R/print.summary.bvec.R
\name{summary.bvec}
\alias{summary.bvec}
\alias{print.summary.bvec}
\title{Summarising Bayesian VEC Coefficients}
\usage{
\method{summary}{bvec}(object, ci = 0.95, ...)

\method{print}{summary.bvec}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of class \code{"bvec"}, usually, a result of a call to
\code{\link{bvec}}.}

\item{ci}{a numeric between 0 and 1 specifying the probability of the credible band.
Defaults to 0.95.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.bvec"}, usually, a result of a call to
\code{\link{summary.bvec}}.}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
\code{summary.bvec} returns a list of class \code{"summary.bvec"},
which contains the following components:
\item{coefficients}{A list of various summary statistics of the posterior
draws of the VAR coefficients.}
\item{sigma}{A list of various summary statistics of the posterior
draws of the variance-covariance matrix.}
\item{specifications}{a list containing information on the model specification.}
}
\description{
summary method for class \code{"bvec"}.
}
