% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c14_date_list_convert.R
\name{as.sf}
\alias{as.sf}
\alias{as.sf.default}
\alias{as.sf.c14_date_list}
\title{Convert a \strong{c14_date_list} to a sf object}
\usage{
as.sf(x)

\method{as.sf}{default}(x)

\method{as.sf}{c14_date_list}(x)
}
\arguments{
\item{x}{an object of class c14_date_list}
}
\value{
an object of class sf
}
\description{
Most 14C dates have point position information in
the coordinates columns \strong{lat} and \strong{lon}. This allows
them to be converted to a spatial simple feature collection as provided
by the \code{sf} package. This simplifies for example mapping of the
dates.
}
\examples{
sf_c14 <- as.sf(example_c14_date_list)

\dontrun{
library(mapview)
mapview(sf_c14$geom)
}

}
