% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c14_date_list_classify_material.R
\name{classify_material}
\alias{classify_material}
\alias{classify_material.default}
\alias{classify_material.c14_date_list}
\title{Apply material classification on a \strong{c14_date_list}}
\usage{
classify_material(
  x,
  material_thesaurus = c14bazAAR::get_material_thesaurus(),
  quiet = FALSE
)

\method{classify_material}{default}(
  x,
  material_thesaurus = c14bazAAR::get_material_thesaurus(),
  quiet = FALSE
)

\method{classify_material}{c14_date_list}(
  x,
  material_thesaurus = c14bazAAR::get_material_thesaurus(),
  quiet = FALSE
)
}
\arguments{
\item{x}{an object of class c14_date_list}

\item{material_thesaurus}{a thesaurus table}

\item{quiet}{suppress decision log output}
}
\value{
an object of class c14_date_list with the additional column \strong{material_thes}
}
\description{
Add column \strong{material_thes} with simplified and unified terms for
material categories. The classification is manually curated and therefore maybe not
up-to-date. It's stored in a
\href{https://github.com/ropensci/c14bazAAR/blob/master/data-raw/material_thesaurus.csv}{material_thesaurus}
list, and downloaded directly from github with \code{c14bazAAR::get_material_thesaurus()}.
With this setup you can also easily apply own thesaurus tables.
}
\examples{
classify_material(
  example_c14_date_list,
  quiet = TRUE
)

}
