% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\docType{package}
\name{c2d4u.tools}
\alias{c2d4u.tools}
\alias{c2d4u}
\alias{config}
\alias{update}
\alias{find}
\alias{show}
\alias{install}
\title{c2d4u Utilities}
\usage{
config(sources.list, lists, cache)

update(...)

find(pkg, ...)

show(pkg, ...)

install(pkg, ..., target = .libPaths()[1])
}
\arguments{
\item{sources.list}{The debian \code{sources.list} file with the URL of the PPA.}

\item{lists}{A directory to store apt listings.}

\item{cache}{A directory to cache apt operations.}

\item{...}{options for \code{config}.}

\item{pkg}{a package name. Note: Ubuntu packages typically have a "r-cran-" prefix.}

\item{target}{the library to install in to.}
}
\value{
\code{config} - a set of CLI flags for apt.

\code{update}, \code{show} and \code{find} - a conventional UNIX return code (0 for success), invisibly.

\code{install} - a logical for each file copied, invisibly (like \code{file.copy}).
}
\description{
c2d4u is a repository of precompiled R packages for Ubuntu. Using it through
the operating system commands typically installs packages to the host's site
library, which may require root. Instead, these functions can be run from and
packages installed to the user library.
}
\section{Future Work}{

\itemize{
\item Resolve dependencies.
}
}

\examples{

\dontrun{
  # Only relevant to Ubuntu users
  c2d4u.tools::update()
  c2d4u.tools::find("randomizr")
  c2d4u.tools::show("r-cran-randomizr")
  c2d4u.tools::install("r-cran-randomizr")
}


}
\seealso{
\url{https://launchpad.net/~c2d4u.team}
}
