% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cristin.R
\name{Cristin}
\alias{Cristin}
\title{Search Cristin API}
\usage{
Cristin(
  id = NULL,
  doi = NULL,
  title = NULL,
  contributor = NULL,
  issn = NULL,
  unit = NULL,
  institution = NULL,
  user = NULL,
  category = NULL,
  published_since = NULL,
  published_before = NULL,
  created_since = NULL,
  created_before = NULL,
  modified_since = NULL,
  modified_before = NULL,
  year_reported = NULL,
  project_code = NULL,
  funding_source = NULL,
  funding = NULL,
  lang = NULL,
  page = 1,
  per_page = 1000,
  max.results = NULL,
  no.results = FALSE,
  sort = NULL,
  filter = NULL,
  fields = "all",
  open.query = NULL,
  all.results = TRUE,
  force = FALSE,
  debug = FALSE,
  silent = FALSE,
  base.url = "https://api.cristin.no/v2/results",
  custom.url = NULL,
  use.identifiers = TRUE,
  crossref.search = FALSE,
  autosearch = TRUE,
  zotero = NULL,
  zotero.import = TRUE,
  zotero.check = TRUE,
  remove.na = TRUE,
  replace.na = "book",
  force.type = NULL,
  override = FALSE,
  polite = TRUE,
  log = list()
)
}
\arguments{
\item{id}{The Cristin id of the result, Default: NULL}

\item{doi}{DOI name (e.g. doi=10.1000/123456), Default: NULL}

\item{title}{The title of the result, Default: NULL}

\item{contributor}{Author's name or Cristin person id, Default: NULL}

\item{issn}{The issn of the result, Default: NULL}

\item{unit}{Id (e.g. unit=185.53.18.10), Default: NULL}

\item{institution}{Id (one number, e.g. institution=185), name or acronym of
the institution the contributors belong to, Default: NULL}

\item{user}{A person's username in Cristin together with the institution id
separated by colon (e.g., `askeladd:185`), Default: NULL}

\item{category}{Categories. See
\href{https://api.cristin.no/v2/doc/index.html#}{category codes}, Default:
NULL}

\item{published_since}{Results published since and inclusive the given year,
(yyyy), Default: NULL}

\item{published_before}{Results published before and inclusive the given
year, (yyyy), Default: NULL}

\item{created_since}{Results created since and inclusive the given date,
(yyyy-mm-dd), Default: NULL}

\item{created_before}{Results created before and inclusive the given date,
(yyyy-mm-dd), Default: NULL}

\item{modified_since}{Results modified since and inclusive the given date,
(yyyy-mm-dd), Default: NULL}

\item{modified_before}{Results modified before and inclusive the given date,
(yyyy-mm-dd), Default: NULL}

\item{year_reported}{The year a result was reported, Default: NULL}

\item{project_code}{Project code is the internal reference number used by
funding source, Default: NULL}

\item{funding_source}{Funding source code e.g: NFR, Default: NULL}

\item{funding}{Funding source code e.g: NFR, and project_code together
separated by colon (e.g., NFR:1234), Default: NULL}

\item{lang}{Two letter
\href{https://api.cristin.no/v2/doc/index.html#lang}{language code},
Default: NULL}

\item{page}{Page number. See
\href{https://api.cristin.no/v2/doc/index.html#pagination}{pagination},
Default: 1}

\item{per_page}{Number of items per page (1000 is max). See
\href{https://api.cristin.no/v2/doc/index.html#pagination}{pagination},
Default: 1000}

\item{max.results}{Do you need a limit?, Default: NULL}

\item{no.results}{Do you need only the number of results?, Default: FALSE}

\item{sort}{Sorts on `category` and/or `year_published`. See
\href{https://api.cristin.no/v2/doc/index.html#search}{search and sort}.
Default sort order is on `cristin_result_id` in ascending order, Default:
NULL}

\item{filter}{Vector of cateogries to include in results. See
\href{https://api.cristin.no/v2/results/categories}{category code},
Default: NULL}

\item{fields}{`fields = all` gives a list of result objects with all
available fields. If this parameter is omitted, a list of result summaries
with fewer fields will be returned, Default: all}

\item{open.query}{Define your own query terms, Default: NULL}

\item{all.results}{Find all results in query, Default: TRUE}

\item{force}{Force is seldom wise, but sometimes..., Default: FALSE}

\item{debug}{Let you test the Cristin API for errors, Default: FALSE}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}

\item{base.url}{The base url for the Cristin API, Default:
https://api.cristin.no/v2/results}

\item{custom.url}{Define your own Cristin API url, Default: NULL}

\item{use.identifiers}{Use if ISBN/DOI identifiers if enabled, Default: TRUE}

\item{crossref.search}{Query Crossref database based on title, authors, and
date if enabled, Default: FALSE}

\item{autosearch}{Results could be automatically evaluated (based on some
logic) or you could inspect them manually if set to FALSE, Default: TRUE}

\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items), Default: NULL}

\item{zotero.import}{Use \code{\link{CristinWrangler}} to wrangle metadata
into an acceptable format for Zotero, Default: TRUE}

\item{zotero.check}{Check for Cristin references already stored in Zotero,
Default: TRUE}

\item{remove.na}{Cristin contains many, more or less, obscure categories, and
not all are (yet) supported. By default these are removed, however, if this
option is set to FALSE unsupported categories are treated according to
replace.na, Default: TRUE}

\item{replace.na}{May the odds be in your favor and replace unsupported
categories with a predefined itemType if remove.na is set to false,
Default: 'book'}

\item{force.type}{Force all items to a predefined itemType, Default: NULL}

\item{override}{Put your faith in the algorithms and the identifiers (i.e.,
DOI/ISBN) and override what is reported in Cristin, Default: FALSE}

\item{polite}{Please store you email in `.Renviron` to query Crossref,
Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A list with (exported) items from Cristin
}
\description{
Use search parameters for the Cristin API and return the results
  as a tibble. See \code{\link{CristinWrangler}}
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Simple `Cristin` search by id
  example <- Cristin(id = "840998")

  # Print index using `ZoteroIndex`
  ZoteroIndex(example$results) |>
    dplyr::select(name) |>
    print(width = 80)
}
}
\seealso{
\code{\link[httr]{http_error}}, \code{\link[httr]{GET}},
 \code{\link[httr]{RETRY}}
 \code{\link[utils]{tail}}, \code{\link[utils]{head}}
 \code{\link[dplyr]{slice}}
}
