% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{c3d_convert}
\alias{c3d_convert}
\title{Convert between c3d point data formats}
\usage{
c3d_convert(data, format)
}
\arguments{
\item{data}{A data frame of class \code{c3d_data} as generated by \code{\link[=c3d_data]{c3d_data()}}.
The data can have any of the three data formats (see Data Formats section
below).}

\item{format}{Either \code{"wide"} (default), \code{"long"}, or \code{"longest"} to
determine the format of the resulting data frame. See the Data Formats
section for more details.}
}
\value{
A data frame of class \code{c3d_data} in the format specified by the
\code{format} argument.
}
\description{
Convert between different representations of point data in c3d files.
}
\section{Data Formats}{
\subsection{Wide}{

The wide format has three numeric columns per point (x, y, z). The column
names have the structure \code{pointname_type}, so for example the x-coordinate of
a point named \code{C7} has the name \code{C7_x}. Each row corresponds to one recording
frame.
}

\subsection{Long}{

The long format has one column per point. The column names correspond to the
names of the points. Each recording frame corresponds to three rows of data
(x, y, z). In additional to the point columns containing numeric data there
are two additional columns: One that indicates the frame number (\code{frame},
numeric) and one that indicates the coordinate type (\code{type}, either x, y, or
z, as a character).
}

\subsection{Longest}{

The longest format has one data column (\code{value}, numeric). The other columns
indicate the frame number (\code{frame}, numeric), the coordinate type (\code{type},
either x, y, or z, as a character), and the point name (\code{point}, character).
Thus, each row of the data frame corresponds to one data entry.
}
}

\examples{
# Import example data
d <- c3d_read(c3d_example())
# get point data in wide format
w <- c3d_data(d, format = "wide")
# convert to long data
l <- c3d_convert(w, "long")
head(l)
}
