% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_db}
\alias{get_db}
\title{Get cRegulome.db file}
\usage{
get_db(test = FALSE, destfile, ...)
}
\arguments{
\item{test}{A \code{logical}, default \code{FALSE}. When \code{TRUE}
downloads a database file with the same structure with a subset of
the data for speed.}

\item{destfile}{A character vector for the desired path for the database 
file. By default, when not specified, is constructed by using 
\code{\link{tempdir}} as a directory and the string \code{cRegulome.db.gz}}

\item{...}{Optional arguments passed to \code{\link[utils]{download.file}}}
}
\value{
Downloads a compressed \code{sqlite} file to the current working
directory. The file is named \code{cRegulome.db.gz} by default and it's
not advised to change the name to avoid breaking the other functions
that calls the database.
}
\description{
This function calls \code{\link[utils]{download.file}} to download the
pre-build database file of cRegulome. Additionally, the function checks
the validity of the pre-defined URL and whether the database file exists
in the current working directory to avoid redownloading it. Typically,
users would run this function once at the first time the use the package
or to update the database to the latest version.
}
\examples{
\dontrun{
# download a test set of the database
get_db(test = TRUE)

# download the full database file
get_db(test = FALSE)
}


# load the test db file from shipped with the pacakge
db_file <- system.file("extdata", "cRegulome.db", package = "cRegulome")
file.info(db_file)

}
