% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{PoliticalDemocracy}
\alias{PoliticalDemocracy}
\title{Data: political democracy}
\format{A data frame of 75 observations of 11 variables.
\describe{
\item{\code{y1}}{Expert ratings of the freedom of the press in 1960}
\item{\code{y2}}{The freedom of political opposition in 1960}
\item{\code{y3}}{The fairness of elections in 1960}
\item{\code{y4}}{The effectiveness of the elected legislature in 1960}
\item{\code{y5}}{Expert ratings of the freedom of the press in 1965}
\item{\code{y6}}{The freedom of political opposition in 1965}
\item{\code{y7}}{The fairness of elections in 1965}
\item{\code{y8}}{The effectiveness of the elected legislature in 1965}
\item{\code{x1}}{The gross national product (GNP) per capita in 1960}
\item{\code{x2}}{The inanimate energy consumption per capita in 1960}
\item{\code{x3}}{The percentage of the labor force in industry in 1960}
}}
\source{
The \href{http://lavaan.ugent.be/}{lavaan} package (version 0.6-3).
}
\usage{
PoliticalDemocracy
}
\description{
The Industrialization and Political Democracy dataset. This dataset is
used throughout Bollen's 1989 book (see pages 12, 17, 36 in chapter 2, pages
228 and following in chapter 7, pages 321 and following in chapter 8;
\insertCite{Bollen1989;textual}{cSEM}).
The dataset contains various measures of political democracy and
industrialization in developing countries.
}
\examples{
#============================================================================
# Example is taken from the lavaan website
#============================================================================
# Note: example is modified. Across-block correlations are removed
model <- "
# Measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  
# Regressions / Path model
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  
# residual correlations
  y2 ~~ y4
  y6 ~~ y8
"

aa <- csem(PoliticalDemocracy, model)
}
\references{
\insertAllCited{}
}
\keyword{datasets}
