% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsGSCA}
\alias{calculateWeightsGSCA}
\title{Calculate composite weights using GSCA}
\usage{
calculateWeightsGSCA(
  .X                           = args_default()$.X,
  .S                           = args_default()$.S,
  .csem_model                  = args_default()$.csem_model,
  .conv_criterion              = args_default()$.conv_criterion,
  .iter_max                    = args_default()$.iter_max,
  .starting_values             = args_default()$.starting_values,
  .tolerance                   = args_default()$.tolerance
   )
}
\arguments{
\item{.X}{A matrix of processed data (scaled, cleaned and ordered).}

\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\value{
A named list. J stands for the number of constructs and K for the number
of indicators.
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$E}}{\code{NULL}}
\item{\verb{$Modes}}{A named vector of Modes used for the outer estimation, for GSCA
the mode is automatically set to "gsca".}
\item{\verb{$Conv_status}}{The convergence status. \code{TRUE} if the algorithm has converged
and \code{FALSE} otherwise.}
\item{\verb{$Iterations}}{The number of iterations required.}
}
}
\description{
Calculate composite weights using generalized structure component analysis (GSCA).
The first version of this approach was presented in \insertCite{Hwang2004;textual}{cSEM}.
Since then, several advancements have been proposed. The latest version
of GSCA can been found in \insertCite{Hwang2014;textual}{cSEM}. This is the version
\pkg{cSEM}s implementation is based on.
}
\references{
\insertAllCited{}
}
