% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateDf}
\alias{calculateDf}
\title{Degrees of freedom}
\usage{
calculateDf(
  .object     = NULL,
  .null_model = FALSE,
  ...
  )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.null_model}{Logical. Should the degrees of freedom for the null model
be computed? Defaults to \code{FALSE}.}

\item{...}{Ignored.}
}
\value{
A single numeric value.
}
\description{
Calculate the degrees of freedom for a given model from a \link{cSEMResults} object.
}
\details{
Although, composite-based estimators always retrieve parameters of the
postulated models via the estimation of a composite model,
the computation of the degrees of freedom depends on the postulated model.

See: \href{https://m-e-rademaker.github.io/cSEM/articles/Using-assess.html}{cSEM website}
for details on how the degrees of freedom are calculated.

To compute the degrees of freedom of the null model use \code{.null_model = TRUE}.
The degrees of freedom of the null model are identical to the number of
non-redundant off-diagonal elements of the empirical indicator correlation matrix.
This implicitly assumes a null model with model-implied indicator correlation
matrix equal to the identity matrix.
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
