% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_effect.R
\name{main_effect}
\alias{main_effect}
\title{Main effect}
\usage{
main_effect(cacc_matrix, iv, value, summary = TRUE)
}
\arguments{
\item{cacc_matrix}{A tibble. The output of the \code{cacc} function.}

\item{iv}{A single variable name contained in a \code{cacc_matrix}.}

\item{value}{A single numeric or character value the \code{iv} specified can take.}

\item{summary}{Logical. Defaults to \code{TRUE}. Whether or not to return the summary statistics for the main effect.}
}
\value{
When \code{summary = TRUE}, returns a tibble with summary stats for the main effect. If \code{summary = FALSE}, returns a tibble containing a single numeric variable, ranging from 0 to 1, containing the main effects of the \code{value} of the selected \code{iv} on the probability of outcome.
}
\description{
Computes the main effect that a specific value of a variable produces on the outcome probability in a \code{cacc_matrix}.
}
\examples{
main_effect(
  cacc_matrix = cacc(onharassment, ivs = sex:privacy, dv = rep_victim),
  iv = age,
  value = "15-17"
)
main_effect(
  cacc_matrix = cacc(onharassment, ivs = sex:privacy, dv = rep_victim),
  iv = age,
  value = "15-17",
  summary = FALSE
)
}
\references{
Hart, T. C., Rennison, C. M., & Miethe, T. D. (2017). Identifying Patterns of Situational Clustering and Contextual Variability in Criminological Data: An Overview of Conjunctive Analysis of  Case  Configurations. \emph{Journal  of  Contemporary Criminal  Justice, 33}(2),  112–120. https://doi.org/10.1177/1043986216689746
}
