% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_helpers.R
\name{get_optimizer_opts}
\alias{get_optimizer_opts}
\title{Get optimizer options}
\usage{
get_optimizer_opts(
  model_pars,
  initial_pars = rep(NA, length(model_pars)),
  ll = rep(NA, length(model_pars)),
  ul = rep(NA, length(model_pars)),
  optimizer = NULL,
  family = NULL
)
}
\arguments{
\item{model_pars}{A character vector specifying the name of
the parameters to fit.}

\item{initial_pars}{A numeric vector specifying the initial
parameter values to #' evaluate the model at (required by \code{optim}).
Defaults to 0 for each parameter.}

\item{ll, ul}{A numeric vector specifying the lower and upper
limits of the parameters to fit, respectively}

\item{optimizer}{A string specifying the optimizer to use.
One from \code{c("optim", "ga")}}

\item{family}{A string specifying the family function to
generate responses (and calculate the likelihood function with).
One from \code{c("identity", "normal", "poisson")}.}
}
\value{
A list with optimizer options.
}
\description{
Get optimizer options
}
\note{
Whenever a family function other than the identity is used,
the family-specific parameters will always be appended to
the end of the relevant lists.
}
\seealso{
\code{\link[=fit_model]{fit_model()}}
}
