% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calpassapi.R
\name{calpass_create_isk}
\alias{calpass_create_isk}
\title{Create interSegmentKey's for students}
\usage{
calpass_create_isk(first_name, last_name, gender, birthdate)
}
\arguments{
\item{first_name}{a character vector of students' first names.}

\item{last_name}{a character vector of students' last names.}

\item{gender}{a character vector of students' genders.  The first character will be used (uppercase'd automatically), and should take on values \code{'M'}, \code{'F'}, or \code{'X'} (use \code{'X'} for unknown or did not disclosed).}

\item{birthdate}{a character or numeric vector of birthdates of the form \code{'yyyymmdd'}.}
}
\value{
a vector of interSegmentKey's
}
\description{
Create interSegmentKey's from students' first names, last names, genders, and birthdates
}
\examples{
## single
calpass_create_isk(first_name='Jane', last_name='Doe'
 , gender='F', birthdate=20001231)
## data frame
\dontrun{
firstname <- c('Tom', 'Jane', 'Jo')
lastname <- c('Ng', 'Doe', 'Smith')
gender <- c('Male', 'Female', 'X')
birthdate <- c(2001231, 19990101, 19981111)
df <- data.frame(firstname, lastname
  , gender, birthdate, stringsAsFactors=FALSE)
library(dplyr)
df \%>\%
  mutate(isk=calpass_create_isk(first_name=firstname
    , last_name=lastname
    , gender=gender
    , birthdate
  ))
}
}
\author{
Vinh Nguyen
}
