% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keypad-convert.R
\name{keypad_convert}
\alias{keypad_convert}
\title{Convert letters or numbers to their keypad counterpart}
\usage{
keypad_convert(x, ext = FALSE)
}
\arguments{
\item{x}{A vector of characters or letters.}

\item{ext}{logical; Should extension text be converted to numbers. Defaults to
\code{FALSE} and matches x, ext, and extension followed by a space or number.}
}
\value{
If a character vector is supplied, a vector of each elements numeric
counterpart is returned. If a numeric vector (or a completely coercible
character vector) is supplied, then a \strong{list} is returned, each element of
which contacts a vector of letters for each number.
}
\description{
This function works best when converting numbers to letters, as each number
only has a single possible letter. For each letter, there are 3 or 4 possible
letters, resulting in a number of possible conversions. This function was
intended to convert phonetic telephone numbers to their valid numeric
equivalent; when used in this manner, each letter in a string can be lazily
replaced without changing the rest of the string.
}
\details{
When replacing letters, this function relies on the feature of
\code{\link[stringr:str_replace]{stringr::str_replace_all()}} to work with named vectors (\code{c("A" = "2")}).
}
\examples{
keypad_convert("1-800-CASH-NOW ext123")
keypad_convert(c("abc", "123"))
keypad_convert(letters)
}
