% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{count_na}
\alias{count_na}
\title{Count missing}
\usage{
count_na(x)
}
\arguments{
\item{x}{A vector to check.}
}
\value{
The sum of \code{x} that are \code{NA}
}
\description{
Count the total values of \code{x} that are \code{NA}.
}
\details{
\code{sum(is.na(x))}
}
\examples{
count_na(c("VT", "NH", NA, "ME"))
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
