% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess-delims.R
\name{guess_delim}
\alias{guess_delim}
\title{Guess the delimiter of a text file}
\source{
\url{https://github.com/r-lib/vroom/blob/master/R/vroom.R#L248}
}
\usage{
guess_delim(file, delims = c(",", "\\t", " ", "|", ":", ";"))
}
\arguments{
\item{file}{Either a path to a file or character string (with at least one
newline character).}

\item{delims}{The single characters to guess from.}
}
\value{
The single character guessed as a delimiter.
}
\description{
Taken from code used in \href{https://github.com/r-lib/vroom/blob/master/R/vroom.R#L248}{vroom::vroom()} with automatic reading.
}
\examples{
guess_delim(system.file("extdata", "vt_contribs.csv", package = "campfin"))
guess_delim("
a|b|c
1|2|3
")
}
