% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{list_census_vectors}
\alias{list_census_vectors}
\title{Query the CensusMapper API for available vectors for a given dataset.}
\usage{
list_census_vectors(dataset, use_cache = FALSE, quiet = TRUE)
}
\arguments{
\item{dataset}{The dataset to query for available vectors, e.g.
\code{"CA16"}.}

\item{use_cache}{If set to TRUE, data will be read from a local cache, if
available. If set to FALSE (the default), query the API for the data, and
refresh the local cache with the result.}

\item{quiet}{When FALSE, shows messages and warnings. Set to TRUE by default.}
}
\value{
Returns a data frame detailing the available Census vectors (i.e. variables) for a given Census
dataset. This data frame has columns \code{vector} containing the short code for the
variable, \code{type} describing whether it's a female, male, or total aggregate, \code{label}
indicating the name of the variable, \code{units} indicating whether the value represents a
numeric integer, percentage, dollar figure, or ratio, \code{parent_vector} to show hierarchical
relationship, \code{aggregation} indicating whether the value is additive or a transformation,
and a column \code{details} with a detailed description of the variable generated by traversing
all labels within its hierarchical structure.
}
\description{
Query the CensusMapper API for available vectors for a given dataset.
}
\examples{

# List all vectors for a given Census dataset in CensusMapper
list_census_vectors('CA16')
}
