% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{get_census}
\alias{get_census}
\title{Access to Canadian census data through the CensusMapper API}
\source{
Census data and boundary geographies are reproduced and distributed on
an "as is" basis with the permission of Statistics Canada (Statistics Canada 1996; 2001; 2006; 2011; 2016).
}
\usage{
get_census(
  dataset,
  regions,
  level = NA,
  vectors = c(),
  geo_format = NA,
  labels = "detailed",
  use_cache = TRUE,
  quiet = FALSE,
  api_key = Sys.getenv("CM_API_KEY")
)
}
\arguments{
\item{dataset}{A CensusMapper dataset identifier.}

\item{regions}{A named list of census regions to retrieve. Names must be valid census aggregation levels.}

\item{level}{The census aggregation level to retrieve, defaults to \code{"Regions"}. One of \code{"Regions"}, \code{"PR"}, \code{"CMA"}, \code{"CD"}, \code{"CSD"}, \code{"CT"}, \code{"DA"}, \code{"EA"} (for 1996), or \code{"DB"} (for 2001-2016).}

\item{vectors}{An R vector containing the CensusMapper variable names of the census variables to download. If no vectors are specified only geographic data will get downloaded.}

\item{geo_format}{By default is set to \code{NA} and appends no geographic information. To include geographic information with census data, specify one of either \code{"sf"} to return an \code{\link[sf]{sf}} object (requires the \code{sf} package) or \code{"sp"} to return a \code{\link[sp]{SpatialPolygonsDataFrame-class}} object (requires the \code{rgdal} package).}

\item{labels}{Set to "detailed" by default, but truncated Census variable names can be selected by setting labels = "short". Use \code{label_vectors(...)} to return variable label information in detail.}

\item{use_cache}{If set to TRUE (the default) data will be read from the local cache if available.}

\item{quiet}{When TRUE, suppress messages and warnings.}

\item{api_key}{An API key for the CensusMapper API. Defaults to \code{options()} and then the \code{CM_API_KEY} environment variable.}
}
\description{
This function allows convenient access to Canadian census data and boundary
files through the CensusMapper API. An API key is required to retrieve data.
}
\details{
For help selecting regions and vectors, see \code{\link{list_census_regions}}
and \code{\link{list_census_vectors}}, or check out the interactive selection
tool at \url{https://censusmapper.ca/api} by calling \code{explore_census_vectors()}
}
\examples{
# Query the API for data on dwellings in Vancouver, at the census subdivision
# level:
\dontrun{
census_data <- get_census(dataset='CA16', regions=list(CMA="59933"),
                          vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"),
                          level='CSD')

# Query the API for data on dwellings in Vancouver, at the census subdivision
# level, and return the associated geography files in \code{sf} format:
census_data <- get_census(dataset='CA16', regions=list(CMA="59933"),
                          vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"),
                          level='CSD', geo_format = "sf")

# Make the same query, but this time drop descriptive vector names:
census_data <- get_census(dataset='CA16', regions=list(CMA="59933"),
                          vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"),
                          level='CSD', geo_format = "sf", labels="short")

# Get details for truncated vectors:
label_vectors(census_data)
}
}
