/**
 * 
 * CanvasXpress 27.6 - JavaScript Canvas Library
 * 
 * Copyright (c) 2009-2020 - canvasxpress@gmail.com
 * 
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *  
 * CanvasXpress is licensed under the terms of the Open Source
 * GPL version 3.0 license.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * Please see a copy of the GNU General Public License at
 * http://www.gnu.org/licenses.
 * 
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission.
 * 
 */
/**
 * 
 * canvas.text.js
 * @projectDescription An cross-browser implementation of the HTML5 <canvas> text methods 
 * @author Fabien M�nager 
 * @version $Revision: 1.4 $ 
 * @license MIT License <http://www.opensource.org/licenses/mit-license.php> 
 * 
 * Known issues: 
 * - The 'light' font weight is not supported, neither is the 'oblique' font style. 
 * - Optimize the different hacks (for Opera9) 
 * 
 ****
 *
 * ngraph
 * 
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2019 Andrei Kashcha
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 ****
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * canvas_wrapper.js
 * Canvas doesn't support getCoords() which I really need....
 * So I made a wrapper, code mostly taken from excanvas.js by Google - http://code.google.com/p/explorercanvas/
 * alias some functions to make (compiled) code shorter
 *
 ****
 *
 * conrec.js
 * Copyright (c) 2010, Jason Davies.
 *
 * All rights reserved.  This code is based on Bradley White's Java version,
 * which is in turn based on Nicholas Yue's C++ version, which in turn is based
 * on Paul D. Bourke's original Fortran version.  See below for the respective
 * copyright notices.
 *
 * See http://paulbourke.net/papers/conrec for the original
 * paper by Paul D. Bourke.
 *
 * The vector conversion code is based on http://apptree.net/conrec.htm by
 * Graham Cox.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * conrec.js
 * Copyright (c) 1996-1997 Nicholas Yue
 *
 * This software is copyrighted by Nicholas Yue. This code is based on Paul D.
 * Bourke's CONREC.F routine.
 *
 * The authors hereby grant permission to use, copy, and distribute this
 * software and its documentation for any purpose, provided that existing
 * copyright notices are retained in all copies and that this notice is
 * included verbatim in any distributions. Additionally, the authors grant
 * permission to modify this software and its documentation for any purpose,
 * provided that such modifications are not distributed without the explicit
 * consent of the authors and that existing copyright notices are retained in
 * all copies. Some of the algorithms implemented by this software are
 * patented, observe all applicable patent law.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
 * EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS
 * PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 **** 
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{if(typeof define==="function"&&define.amd){define(["exports"],a)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}}(this,(function(b){var c,a;if(this){c=this.window;a=this.document}CanvasXpress=function(h,f,e,l,d,i,g,k,j){this.init(h,f,e,l,d,i,g,k,j)}})));CanvasXpress.instances=[];CanvasXpress.config=[];CanvasXpress.transitions={};CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.fonts=false;CanvasXpress.vocabulary={};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.resizing=false;CanvasXpress.geo=false;CanvasXpress.leaflet=0;CanvasXpress.system={};CanvasXpress.ready=false;CanvasXpress.factory={version:27.6,buildDate:"03-13-2020",client:"",siteSrc:false,valid:null,href:window.location.href};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){console.log("canvasXpress JS ready");a=true;for(var g=0;g<f.length;g++){f[g].fn.call(window,f[g].ctx)}f=[];CanvasXpress.system.isShiny=window.Shiny?true:false;CanvasXpress.system.isjQuery=typeof $==="function";CanvasXpress.system.isReveal=typeof Reveal!="undefined";CanvasXpress.system.isZoom=typeof zoom!="undefined"}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadScripts=function(){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.className=="CanvasXpress"&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.className=="CanvasXpress"&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.className=="CanvasXpress"&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress({data:f,renderTo:f})}}}};CanvasXpress.getObject=function(f,b){if(f){for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f,hidden:true})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(a)}};CanvasXpress.prototype.init=function(e,c,b,i,a,f,d,h,g){if(!e){return}else{if(typeof(e)=="object"&&e.renderTo){c=e.data||false;b=e.config||false;if(e.version){b.createVersion=e.version}if(e.factory){b.createFactory=e.factory}if(e.geo){b.createGeo=e.geo}i=e.events||false;a=e.info||false;f=e.afterRender||false;d=e.hidden||false;h=e.callback||false;g=e.uploadFile||false;e=e.renderTo}}this.setInit=function(){this.target=e;this.events=i;this.info=a;this.userId=1;this.registered=false;this.url={};this.meta={ids:{},time:{start:new Date().getTime(),elapsed:null,end:null,draw:[],render:[]},data:false,canvas:{},config:{user:b,orig:{},vals:{},remote:false},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1],last:{translate:[0,0],rotate:[0],scale:[1,1]}},stack:[],def:{}}};this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo();this.validateAfterRender()};this.validateData=function(){this.dataURL=false;this.dataString=false;if(typeof(c)=="string"){var l=window.document.getElementById(c);if(l&&l.tagName.toLowerCase()=="table"&&l.className=="CanvasXpress"&&l.id){var m=c;c=this.parseHTMLTable(l,true);b=c.config;c=c.data;l.parentNode.removeChild(l);var j=window.document.getElementById("temp-table-id-"+m);if(j){j.id=m}else{alert("Dude! What did you do?")}}else{var l=this.isValidString(c);switch(l.type){case"URL":this.dataURL=c;c=false;break;case"XML":this.dataString=l.data;c=false;break;case"JSON":c=l.data;break;case"DELIM":c=l.data.data;if(!b){b:l.data.config}break;default:alert("Not a valid data string\n");break}}}else{try{this.stringifyJSON(c)}catch(k){alert("Data object malformed:\n"+k)}}};this.validateConfig=function(){if(b){try{this.stringifyJSON(b)}catch(j){alert("Config object malformed:\n"+j)}}};this.validateEvents=function(){};this.validateInfo=function(){if(!a){a=""}};this.validateAfterRender=function(){if(f){try{this.stringifyJSON(f)}catch(j){alert("AfterRender object malformed:\n"+j)}}};this.isOneTimeFunctionInConfig=function(j){if(!j){j=this}if(j.transposeData){return true}if(j.asSampleFactors&&j.asSampleFactors.length){return true}if(j.asVariableFactors&&j.asVariableFactors.length){return true}if(j.stringSampleFactors&&j.stringSampleFactors.length){return true}if(j.stringVariableFactors&&j.stringVariableFactors.length){return true}if(j.asHistogram){return true}if(j.sortData&&j.sortData.length){return true}return false};this.afterRender=function(s){if(!s){s=[]}var u=this.meta.time.start;if(this.graphType!="Map"){if(this.asHistogram){if(this.asHistogram===true){s.unshift(["createHistogram",[],{},u])}else{s.unshift(["createHistogram",[this.asHistogram],{},u])}this.asHistogram=false}if(this.stringVariableFactors.length){for(var m=0;m<this.stringVariableFactors.length;m++){s.unshift(["switchNumericToString",[this.stringVariableFactors[m]],{},u])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var m=0;m<this.stringSampleFactors.length;m++){s.unshift(["switchNumericToString",[this.stringSampleFactors[m],true],{},u])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var m=0;m<this.asVariableFactors.length;m++){s.unshift(["switchVarToAnnotation",[this.asVariableFactors[m]],{},u])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var m=0;m<this.asSampleFactors.length;m++){s.unshift(["switchSmpToAnnotation",[this.asSampleFactors[m]],{},u])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){s.unshift(["transpose",[false,true],{},u]);this.transposeData=false}if(this.sortData){for(var m=0;m<this.sortData.length;m++){s.push(["modifySort",[this.sortData[m][0],this.sortData[m][1],this.sortData[m][2]],{},u])}this.sortData=[]}if(this.selectedDataPoints.length){var r=false;for(var m=0;m<this.selectedDataPoints.length;m++){var l=this.getVariableIndices(this.selectedDataPoints[m]);if(l>=0){this.setSelectObject(false,[l,this.xAxisIndices[0],this.yAxisIndices[0],false]);r=true}}this.selectedDataPoints=[];if(r){s.unshift(["broadcastDraw",[],{},u])}}var n=s.length-1;for(var m=0;m<s.length;m++){var k=s[m];var p=k.shift();var j=k.length>0?k.shift():[];var q=k.length>0?k.shift():{};if(this.showFunctionNamesAfterRender){this.flashInfoSpan(20,20,p)}this.skipRender=!this.showTransition&&m<n?true:this.view=="table"?true:false;for(var o in q){this[o]=q[o]}this[p].apply(this,j)}if(this.view=="table"){this.view="canvas";this.clickView()}this.triggerDataLoaded("afterRender")}else{this.deferedAfterRender=s}};this.setURL=function(){if(window.location.search!=""){var l=location.search.substring(1).split("&");for(var k=0;k<l.length;k++){var j=l[k].split("=");if(!j[0]){continue}if(j[0].match(/^cX/)){this.url[j[0]]=j[1]||true}else{this.url[j[0]]=j[1]=="false"?false:j[1]=="true"?true:j[1]}}}};this.createThumbnail=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var k=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var j=this;setTimeout(function(){j.print(false,k);setTimeout(function(){window.close()},1000)},1)}};this.setFunctionNames=function(k){var l=function(m){return m&&{}.toString.call(m)==="[object Function]"};for(var j in this){if(this[j]&&!this[j].fname&&l(this[j])){this[j].fname=j;this[j].pname=k||"CanvasXpress"}}};this.setFonts=function(){(function(){if(window.navigator.onLine&&!CanvasXpress.instances[0].offline&&!CanvasXpress.fonts){var k=window.document.createElement("link");k.type="text/css";k.rel="stylesheet";k.href="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic";var j=window.document.getElementsByTagName("head")[0];j.appendChild(k);var l=new Image();l.onerror=function(){var o=window.document.createElement("canvas");var n=o.getContext("2d",{willReadFrequently:true});var m="10px Ubuntu";n.font=m;n.fillText("css loaded",100,100);m="10px Indie Flower";n.font=m;n.fillText("css loaded",100,100);m="10px Architects Daughter";n.font=m;n.fillText("css loaded",100,100);m="10px Roboto";n.font=m;n.fillText("css loaded",100,100)};l.src="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic";CanvasXpress.fonts=true}}())};this.triggerDataLoaded=function(l){var k=this;var j=function(){if(h){h();h=undefined}k.logConsole("canvasXpress data ready - "+l);k.createThumbnail();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(l=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.dataURL&&!this.dataString&&!g&&!this.isUpdateRemoteData&&!d){j()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){j()}}else{if(!this.isTransitionOn){j()}}}}};this.saveFirstState=function(){CanvasXpress.stack[this.target].state.push(this.getConfigState())};this.continueInitialization=function(){var j=CanvasXpress.stack[this.target];this.initGraph(this.isOneTimeFunctionInConfig());this.afterRender(j.afterRenderInit);this.getDataFromURLOrString(this.target,j.config,j.events,j.info);this.saveFirstState();CanvasXpress.current=this.target;this.meta.time.end=new Date().getTime();this.meta.time.elapsed=this.meta.time.end-this.meta.time.start;this.hideMask()};this.pauseInitialization=function(){if(!this.lazyLoad||(!this.loaded&&this.isInViewport(this.meta.canvas.ctx.canvas))){this.continueInitialization()}};this.initialize=function(){if(b&&b.graphType=="Map"&&b.topoJSON&&b.leafletId&&b.leafletLayer){this.initializeL()}else{this.initializeNoL()}};this.initializeNoL=function(){CanvasXpress.instances.push(this);this.setInit();this.setURL();this.initDOM();this.initSVG();this.initInterface();this.initSave();this.validateParameters();this.initConfig(b);this.initDate();this.setFonts();this.initViewport(d);this.initPrimitives();this.initUtils();this.initNumeric();this.initjLouvain();this.initConrec();this.initMathUtils();this.initLegendUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initVocabulary();this.initDataUtils();this.initRandom();this.initData(c);this.initValidity();this.initLayout();this.initEvents();this.initTooltip();this.initToolbar();this.initMenus();this.initLinks();this.initConfigurator();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initDataExplorer();this.initAnimation();this.initRemote();this.initStack(c,b,i,a,f);this.initTransitions();this.pauseInitialization()};this.initializeL=function(){if(window.L){this.initializeNoL()}else{var m=this;var l=window.navigator.onLine?"https://www.canvasxpress.org/":"http://localhost:8000/";var j=document.createElement("script");j.type="text/javascript";j.src=l+"assets/leaflet/leaflet.js";var k=document.createElement("link");k.type="text/css";k.rel="stylesheet";k.href=l+"assets/leaflet/leaflet.css";var n=setTimeout(function(){m.initializeNoL()},++CanvasXpress.leaflet*50);CanvasXpress.loadScripts([j,k],n,this)}};this.initialize();this.setFunctionNames("init")};CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia"],ALA:["Aland Islands","Europe","North Europe"],ALB:["Albania","Europe","South Europe"],DZA:["Algeria","Africa","North Africa"],ASM:["American Samoa","Oceania","Polynesia"],AND:["Andorra","Europe","South Europe"],AGO:["Angola","Africa","Middle Africa"],AIA:["Anguilla","America","Caribbean"],ATA:["Antarctica","",""],ATG:["Antigua and Barbuda","America","Caribbean"],ARG:["Argentina","America","South America"],ARM:["Armenia","Asia","West Asia"],ABW:["Aruba","America","Caribbean"],AUS:["Australia","Oceania","Australia and New Zealand"],AUT:["Austria","Europe","West Europe"],AZE:["Azerbaijan","Asia","West Asia"],BHS:["Bahamas","America","Caribbean"],BHR:["Bahrain","Asia","West Asia"],BGD:["Bangladesh","Asia","South Asia"],BRB:["Barbados","America","Caribbean"],BLR:["Belarus","Europe","East Europe"],BEL:["Belgium","Europe","West Europe"],BLZ:["Belize","America","Central America"],BEN:["Benin","Africa","West Africa"],BMU:["Bermuda","America","North America"],BTN:["Bhutan","Asia","South Asia"],BOL:["Bolivia","America","South America"],BES:["Bonaire","America","Caribbean"],BIH:["Bosnia and Herzegovina","Europe","South Europe"],BWA:["Botswana","Africa","South Africa"],BVT:["Bouvet Island","",""],BRA:["Brazil","America","South America"],IOT:["British Indian Ocean Territory","",""],BRN:["Brunei Darussalam","Asia","South-East Asia"],BGR:["Bulgaria","Europe","East Europe"],BFA:["Burkina Faso","Africa","West Africa"],BDI:["Burundi","Africa","East Africa"],KHM:["Cambodia","Asia","South-East Asia"],CMR:["Cameroon","Africa","Middle Africa"],CAN:["Canada","America","North America"],CPV:["Cabo Verde","Africa","West Africa"],CYM:["Cayman Islands","America","Caribbean"],CAF:["Central African Republic","Africa","Middle Africa"],TCD:["Chad","Africa","Middle Africa"],CHL:["Chile","America","South America"],CHN:["China","Asia","East Asia"],CXR:["Christmas Island","",""],CCK:["Cocos (Keeling) Islands","",""],COL:["Colombia","America","South America"],COM:["Comoros","Africa","East Africa"],COG:["Congo","Africa","Middle Africa"],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa"],COK:["Cook Islands","Oceania","Polynesia"],CRI:["Costa Rica","America","Central America"],CIV:["Cote d'Ivoire","Africa","West Africa"],HRV:["Croatia","Europe","South Europe"],CUB:["Cuba","America","Caribbean"],CUW:["Curaçao","America","Caribbean"],CYP:["Cyprus","Asia","West Asia"],CZE:["Czech Republic","Europe","East Europe"],DNK:["Denmark","Europe","North Europe"],DJI:["Djibouti","Africa","East Africa"],DMA:["Dominica","America","Caribbean"],DOM:["Dominican Republic","America","Caribbean"],ECU:["Ecuador","America","South America"],EGY:["Egypt","Africa","North Africa"],SLV:["El Salvador","America","Central America"],GNQ:["Equatorial Guinea","Africa","Middle Africa"],ERI:["Eritrea","Africa","East Africa"],EST:["Estonia","Europe","North Europe"],ETH:["Ethiopia","Africa","East Africa"],FLK:["Falkland Islands","America","South America"],FRO:["Faroe Islands","Europe","North Europe"],FJI:["Fiji","Oceania","Melanesia"],FIN:["Finland","Europe","North Europe"],FRA:["France","Europe","West Europe"],GUF:["French Guiana","America","South America"],PYF:["French Polynesia","Oceania","Polynesia"],ATF:["French Southern Territories","",""],GAB:["Gabon","Africa","Middle Africa"],GMB:["Gambia","Africa","West Africa"],GEO:["Georgia","Asia","West Asia"],DEU:["Germany","Europe","West Europe"],GHA:["Ghana","Africa","West Africa"],GIB:["Gibraltar","Europe","South Europe"],GRC:["Greece","Europe","South Europe"],GRL:["Greenland","America","North America"],GRD:["Grenada","America","Caribbean"],GLP:["Guadeloupe","America","Caribbean"],GUM:["Guam","Oceania","Micronesia"],GTM:["Guatemala","America","Central America"],GGY:["Guernsey","Europe","North Europe"],GIN:["Guinea","Africa","West Africa"],GNB:["Guinea-Bissau","Africa","West Africa"],GUY:["Guyana","America","South America"],HTI:["Haiti","America","Caribbean"],HMD:["Heard Island and McDonald Islands","",""],VAT:["Holy See","Europe","South Europe"],HND:["Honduras","America","Central America"],HKG:["Hong Kong","Asia","East Asia"],HUN:["Hungary","Europe","East Europe"],ISL:["Iceland","Europe","North Europe"],IND:["India","Asia","South Asia"],IDN:["Indonesia","Asia","South-East Asia"],IRN:["Iran","Asia","South Asia"],IRQ:["Iraq","Asia","West Asia"],IRL:["Ireland","Europe","North Europe"],IMN:["Isle of Man","Europe","North Europe"],ISR:["Israel","Asia","West Asia"],ITA:["Italy","Europe","South Europe"],JAM:["Jamaica","America","Caribbean"],JPN:["Japan","Asia","East Asia"],JEY:["Jersey","Europe","North Europe"],JOR:["Jordan","Asia","West Asia"],KAZ:["Kazakhstan","Asia","Central Asia"],KEN:["Kenya","Africa","East Africa"],KIR:["Kiribati","Oceania","Micronesia"],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia"],KOR:["Korea (Republic of)","Asia","East Asia"],KWT:["Kuwait","Asia","West Asia"],KGZ:["Kyrgyzstan","Asia","Central Asia"],LAO:["Lao People's Democratic Republic","Asia","South-East Asia"],LVA:["Latvia","Europe","North Europe"],LBN:["Lebanon","Asia","West Asia"],LSO:["Lesotho","Africa","South Africa"],LBR:["Liberia","Africa","West Africa"],LBY:["Libya","Africa","North Africa"],LIE:["Liechtenstein","Europe","West Europe"],LTU:["Lithuania","Europe","North Europe"],LUX:["Luxembourg","Europe","West Europe"],MAC:["Macao","Asia","East Asia"],MKD:["Macedonia","Europe","South Europe"],MDG:["Madagascar","Africa","East Africa"],MWI:["Malawi","Africa","East Africa"],MYS:["Malaysia","Asia","South-East Asia"],MDV:["Maldives","Asia","South Asia"],MLI:["Mali","Africa","West Africa"],MLT:["Malta","Europe","South Europe"],MHL:["Marshall Islands","Oceania","Micronesia"],MTQ:["Martinique","America","Caribbean"],MRT:["Mauritania","Africa","West Africa"],MUS:["Mauritius","Africa","East Africa"],MYT:["Mayotte","Africa","East Africa"],MEX:["Mexico","America","Central America"],FSM:["Micronesia","Oceania","Micronesia"],MDA:["Moldova","Europe","East Europe"],MCO:["Monaco","Europe","West Europe"],MNG:["Mongolia","Asia","East Asia"],MNE:["Montenegro","Europe","South Europe"],MSR:["Montserrat","America","Caribbean"],MAR:["Morocco","Africa","North Africa"],MOZ:["Mozambique","Africa","East Africa"],MMR:["Myanmar","Asia","South-East Asia"],NAM:["Namibia","Africa","South Africa"],NRU:["Nauru","Oceania","Micronesia"],NPL:["Nepal","Asia","South Asia"],NLD:["Netherlands","Europe","West Europe"],NCL:["New Caledonia","Oceania","Melanesia"],NZL:["New Zealand","Oceania","Australia and New Zealand"],NIC:["Nicaragua","America","Central America"],NER:["Niger","Africa","West Africa"],NGA:["Nigeria","Africa","West Africa"],NIU:["Niue","Oceania","Polynesia"],NFK:["Norfolk Island","Oceania","Australia and New Zealand"],MNP:["West Mariana Islands","Oceania","Micronesia"],NOR:["Norway","Europe","North Europe"],OMN:["Oman","Asia","West Asia"],PAK:["Pakistan","Asia","South Asia"],PLW:["Palau","Oceania","Micronesia"],PSE:["Palestine","Asia","West Asia"],PAN:["Panama","America","Central America"],PNG:["Papua New Guinea","Oceania","Melanesia"],PRY:["Paraguay","America","South America"],PER:["Peru","America","South America"],PHL:["Philippines","Asia","South-East Asia"],PCN:["Pitcairn","Oceania","Polynesia"],POL:["Poland","Europe","East Europe"],PRT:["Portugal","Europe","South Europe"],PRI:["Puerto Rico","America","Caribbean"],QAT:["Qatar","Asia","West Asia"],REU:["Réunion","Africa","East Africa"],ROU:["Romania","Europe","East Europe"],RUS:["Russian Federation","Europe","East Europe"],RWA:["Rwanda","Africa","East Africa"],BLM:["Saint Barthelemy","America","Caribbean"],SHN:["Saint Helena","Africa","West Africa"],KNA:["Saint Kitts and Nevis","America","Caribbean"],LCA:["Saint Lucia","America","Caribbean"],MAF:["Saint Martin","America","Caribbean"],SPM:["Saint Pierre and Miquelon","America","North America"],VCT:["Saint Vincent and the Grenadines","America","Caribbean"],WSM:["Samoa","Oceania","Polynesia"],SMR:["San Marino","Europe","South Europe"],STP:["Sao Tome and Principe","Africa","Middle Africa"],SAU:["Saudi Arabia","Asia","West Asia"],SEN:["Senegal","Africa","West Africa"],SRB:["Serbia","Europe","South Europe"],SYC:["Seychelles","Africa","East Africa"],SLE:["Sierra Leone","Africa","West Africa"],SGP:["Singapore","Asia","South-East Asia"],SXM:["Sint Maarten","America","Caribbean"],SVK:["Slovakia","Europe","East Europe"],SVN:["Slovenia","Europe","South Europe"],SLB:["Solomon Islands","Oceania","Melanesia"],SOM:["Somalia","Africa","East Africa"],ZAF:["South Africa","Africa","South Africa"],SGS:["South Georgia and the South Sandwich Islands","",""],SSD:["South Sudan","Africa","East Africa"],ESP:["Spain","Europe","South Europe"],LKA:["Sri Lanka","Asia","South Asia"],SDN:["Sudan","Africa","North Africa"],SUR:["Suriname","America","South America"],SJM:["Svalbard and Jan Mayen","Europe","North Europe"],SWZ:["Swaziland","Africa","South Africa"],SWE:["Sweden","Europe","North Europe"],CHE:["Switzerland","Europe","West Europe"],SYR:["Syrian Arab Republic","Asia","West Asia"],TWN:["Taiwan","Asia","East Asia"],TJK:["Tajikistan","Asia","Central Asia"],TZA:["Tanzania","Africa","East Africa"],THA:["Thailand","Asia","South-East Asia"],TLS:["Timor-Leste","Asia","South-East Asia"],TGO:["Togo","Africa","West Africa"],TKL:["Tokelau","Oceania","Polynesia"],TON:["Tonga","Oceania","Polynesia"],TTO:["Trinidad and Tobago","America","Caribbean"],TUN:["Tunisia","Africa","North Africa"],TUR:["Turkey","Asia","West Asia"],TKM:["Turkmenistan","Asia","Central Asia"],TCA:["Turks and Caicos Islands","America","Caribbean"],TUV:["Tuvalu","Oceania","Polynesia"],UGA:["Uganda","Africa","East Africa"],UKR:["Ukraine","Europe","East Europe"],ARE:["United Arab Emirates","Asia","West Asia"],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe"],USA:["United States of America","America","North America"],UMI:["United States Minor Outlying Islands","",""],URY:["Uruguay","America","South America"],UZB:["Uzbekistan","Asia","Central Asia"],VUT:["Vanuatu","Oceania","Melanesia"],VEN:["Venezuela","America","South America"],VNM:["Vietnam","Asia","South-East Asia"],VGB:["Virgin Islands (British)","America","Caribbean"],VIR:["Virgin Islands (U.S.)","America","Caribbean"],WLF:["Wallis and Futuna","Oceania","Polynesia"],ESH:["Western Sahara","Africa","North Africa"],YEM:["Yemen","Asia","West Asia"],ZMB:["Zambia","Africa","East Africa"],ZWE:["Zimbabwe","Africa","East Africa"]};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9200000,"p36.23","gpos25"],[9200000,12600000,"p36.22","gneg"],[12600000,16100000,"p36.21","gpos50"],[16100000,20300000,"p36.13","gneg"],[20300000,23800000,"p36.12","gpos25"],[23800000,27800000,"p36.11","gneg"],[27800000,30000000,"p35.3","gpos25"],[30000000,32200000,"p35.2","gneg"],[32200000,34400000,"p35.1","gpos25"],[34400000,39600000,"p34.3","gneg"],[39600000,43900000,"p34.2","gpos25"],[43900000,46500000,"p34.1","gneg"],[46500000,51300000,"p33","gpos75"],[51300000,56200000,"p32.3","gneg"],[56200000,58700000,"p32.2","gpos50"],[58700000,60900000,"p32.1","gneg"],[60900000,68700000,"p31.3","gpos50"],[68700000,69500000,"p31.2","gneg"],[69500000,84700000,"p31.1","gpos100"],[84700000,88100000,"p22.3","gneg"],[88100000,92000000,"p22.2","gpos75"],[92000000,94500000,"p22.1","gneg"],[94500000,99400000,"p21.3","gpos75"],[99400000,102000000,"p21.2","gneg"],[102000000,107000000,"p21.1","gpos100"],[107000000,111600000,"p13.3","gneg"],[111600000,115900000,"p13.2","gpos50"],[115900000,117600000,"p13.1","gneg"],[117600000,120700000,"p12","gpos50"],[120700000,121100000,"p11.2","gneg"],[121100000,124300000,"p11.1","acen"],[124300000,128000000,"q11","acen"],[128000000,142400000,"q12","gvar"],[142400000,148000000,"q21.1","gneg"],[148000000,149600000,"q21.2","gpos50"],[149600000,153300000,"q21.3","gneg"],[153300000,154800000,"q22","gpos50"],[154800000,157300000,"q23.1","gneg"],[157300000,158800000,"q23.2","gpos50"],[158800000,163800000,"q23.3","gneg"],[163800000,165500000,"q24.1","gpos50"],[165500000,169100000,"q24.2","gneg"],[169100000,171200000,"q24.3","gpos75"],[171200000,174300000,"q25.1","gneg"],[174300000,178600000,"q25.2","gpos50"],[178600000,184000000,"q25.3","gneg"],[184000000,189000000,"q31.1","gpos100"],[189000000,192100000,"q31.2","gneg"],[192100000,197500000,"q31.3","gpos100"],[197500000,205300000,"q32.1","gneg"],[205300000,209500000,"q32.2","gpos25"],[209500000,212100000,"q32.3","gneg"],[212100000,222100000,"q41","gpos100"],[222100000,222700000,"q42.11","gneg"],[222700000,225100000,"q42.12","gpos25"],[225100000,228800000,"q42.13","gneg"],[228800000,232700000,"q42.2","gpos50"],[232700000,234600000,"q42.3","gneg"],[234600000,241700000,"q43","gpos75"],[241700000,247249719,"q44","gneg"]],2:[[0,4300000,"p25.3","gneg"],[4300000,7000000,"p25.2","gpos50"],[7000000,12800000,"p25.1","gneg"],[12800000,17000000,"p24.3","gpos75"],[17000000,19100000,"p24.2","gneg"],[19100000,23900000,"p24.1","gpos75"],[23900000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31900000,"p23.1","gneg"],[31900000,36400000,"p22.3","gpos75"],[36400000,38400000,"p22.2","gneg"],[38400000,41600000,"p22.1","gpos50"],[41600000,47600000,"p21","gneg"],[47600000,52700000,"p16.3","gpos100"],[52700000,54800000,"p16.2","gneg"],[54800000,61100000,"p16.1","gpos100"],[61100000,64000000,"p15","gneg"],[64000000,70500000,"p14","gpos50"],[70500000,72600000,"p13.3","gneg"],[72600000,73900000,"p13.2","gpos50"],[73900000,75400000,"p13.1","gneg"],[75400000,83700000,"p12","gpos100"],[83700000,91000000,"p11.2","gneg"],[91000000,93300000,"p11.1","acen"],[93300000,95700000,"q11.1","acen"],[95700000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108600000,"q12.3","gpos25"],[108600000,113800000,"q13","gneg"],[113800000,118600000,"q14.1","gpos50"],[118600000,122100000,"q14.2","gneg"],[122100000,129600000,"q14.3","gpos50"],[129600000,132200000,"q21.1","gneg"],[132200000,134800000,"q21.2","gpos25"],[134800000,136600000,"q21.3","gneg"],[136600000,142400000,"q22.1","gpos100"],[142400000,144700000,"q22.2","gneg"],[144700000,148400000,"q22.3","gpos100"],[148400000,149600000,"q23.1","gneg"],[149600000,150300000,"q23.2","gpos25"],[150300000,154600000,"q23.3","gneg"],[154600000,159600000,"q24.1","gpos75"],[159600000,163500000,"q24.2","gneg"],[163500000,169500000,"q24.3","gpos75"],[169500000,177700000,"q31.1","gneg"],[177700000,180400000,"q31.2","gpos50"],[180400000,182700000,"q31.3","gneg"],[182700000,189100000,"q32.1","gpos75"],[189100000,191600000,"q32.2","gneg"],[191600000,197100000,"q32.3","gpos75"],[197100000,203500000,"q33.1","gneg"],[203500000,205600000,"q33.2","gpos50"],[205600000,209100000,"q33.3","gneg"],[209100000,215100000,"q34","gpos100"],[215100000,221300000,"q35","gneg"],[221300000,224900000,"q36.1","gpos75"],[224900000,225800000,"q36.2","gneg"],[225800000,230700000,"q36.3","gpos100"],[230700000,235300000,"q37.1","gneg"],[235300000,237000000,"q37.2","gpos50"],[237000000,242951149,"q37.3","gneg"]],3:[[0,3500000,"p26.3","gpos50"],[3500000,5500000,"p26.2","gneg"],[5500000,8700000,"p26.1","gpos50"],[8700000,11500000,"p25.3","gneg"],[11500000,12400000,"p25.2","gpos25"],[12400000,14700000,"p25.1","gneg"],[14700000,23800000,"p24.3","gpos100"],[23800000,26400000,"p24.2","gneg"],[26400000,30800000,"p24.1","gpos75"],[30800000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44400000,"p21.33","gneg"],[44400000,44700000,"p21.32","gpos50"],[44700000,51400000,"p21.31","gneg"],[51400000,51700000,"p21.2","gpos25"],[51700000,54400000,"p21.1","gneg"],[54400000,58500000,"p14.3","gpos50"],[58500000,63700000,"p14.2","gneg"],[63700000,71800000,"p14.1","gpos50"],[71800000,74200000,"p13","gneg"],[74200000,81800000,"p12.3","gpos75"],[81800000,83700000,"p12.2","gneg"],[83700000,87200000,"p12.1","gpos75"],[87200000,89400000,"p11.2","gneg"],[89400000,91700000,"p11.1","acen"],[91700000,93200000,"q11.1","acen"],[93200000,99800000,"q11.2","gvar"],[99800000,101500000,"q12.1","gneg"],[101500000,102500000,"q12.2","gpos25"],[102500000,104400000,"q12.3","gneg"],[104400000,107800000,"q13.11","gpos75"],[107800000,109500000,"q13.12","gneg"],[109500000,112800000,"q13.13","gpos50"],[112800000,115000000,"q13.2","gneg"],[115000000,118800000,"q13.31","gpos75"],[118800000,120500000,"q13.32","gneg"],[120500000,123400000,"q13.33","gpos75"],[123400000,125400000,"q21.1","gneg"],[125400000,127700000,"q21.2","gpos25"],[127700000,131500000,"q21.3","gneg"],[131500000,135700000,"q22.1","gpos25"],[135700000,137400000,"q22.2","gneg"],[137400000,140400000,"q22.3","gpos25"],[140400000,144400000,"q23","gneg"],[144400000,150400000,"q24","gpos100"],[150400000,153500000,"q25.1","gneg"],[153500000,156300000,"q25.2","gpos50"],[156300000,158100000,"q25.31","gneg"],[158100000,159900000,"q25.32","gpos50"],[159900000,161200000,"q25.33","gneg"],[161200000,169200000,"q26.1","gpos100"],[169200000,172500000,"q26.2","gneg"],[172500000,177300000,"q26.31","gpos75"],[177300000,180600000,"q26.32","gneg"],[180600000,184200000,"q26.33","gpos75"],[184200000,186000000,"q27.1","gneg"],[186000000,187500000,"q27.2","gpos25"],[187500000,189400000,"q27.3","gneg"],[189400000,193800000,"q28","gpos75"],[193800000,199501827,"q29","gneg"]],4:[[0,3100000,"p16.3","gneg"],[3100000,5200000,"p16.2","gpos25"],[5200000,10900000,"p16.1","gneg"],[10900000,15300000,"p15.33","gpos50"],[15300000,18500000,"p15.32","gneg"],[18500000,23100000,"p15.31","gpos75"],[23100000,27900000,"p15.2","gneg"],[27900000,35500000,"p15.1","gpos100"],[35500000,40900000,"p14","gneg"],[40900000,45600000,"p13","gpos50"],[45600000,48700000,"p12","gneg"],[48700000,50700000,"p11","acen"],[50700000,52400000,"q11","acen"],[52400000,59200000,"q12","gneg"],[59200000,66300000,"q13.1","gpos100"],[66300000,70400000,"q13.2","gneg"],[70400000,76500000,"q13.3","gpos75"],[76500000,79200000,"q21.1","gneg"],[79200000,82600000,"q21.21","gpos50"],[82600000,84300000,"q21.22","gneg"],[84300000,87100000,"q21.23","gpos25"],[87100000,88200000,"q21.3","gneg"],[88200000,94000000,"q22.1","gpos75"],[94000000,95400000,"q22.2","gneg"],[95400000,99100000,"q22.3","gpos75"],[99100000,102500000,"q23","gneg"],[102500000,107900000,"q24","gpos50"],[107900000,114100000,"q25","gneg"],[114100000,120600000,"q26","gpos75"],[120600000,124000000,"q27","gneg"],[124000000,129100000,"q28.1","gpos50"],[129100000,131300000,"q28.2","gneg"],[131300000,139500000,"q28.3","gpos100"],[139500000,141700000,"q31.1","gneg"],[141700000,145000000,"q31.21","gpos25"],[145000000,147700000,"q31.22","gneg"],[147700000,151000000,"q31.23","gpos25"],[151000000,155100000,"q31.3","gneg"],[155100000,161500000,"q32.1","gpos100"],[161500000,164500000,"q32.2","gneg"],[164500000,170400000,"q32.3","gpos100"],[170400000,172200000,"q33","gneg"],[172200000,176600000,"q34.1","gpos75"],[176600000,177800000,"q34.2","gneg"],[177800000,182600000,"q34.3","gpos100"],[182600000,187300000,"q35.1","gneg"],[187300000,191273063,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6000000,"p15.32","gpos25"],[6000000,8200000,"p15.31","gneg"],[8200000,15100000,"p15.2","gpos50"],[15100000,18500000,"p15.1","gneg"],[18500000,23300000,"p14.3","gpos100"],[23300000,24700000,"p14.2","gneg"],[24700000,29300000,"p14.1","gpos100"],[29300000,34400000,"p13.3","gneg"],[34400000,38500000,"p13.2","gpos25"],[38500000,42400000,"p13.1","gneg"],[42400000,45800000,"p12","gpos50"],[45800000,47700000,"p11","acen"],[47700000,50500000,"q11.1","acen"],[50500000,58900000,"q11.2","gneg"],[58900000,63000000,"q12.1","gpos75"],[63000000,63700000,"q12.2","gneg"],[63700000,66500000,"q12.3","gpos75"],[66500000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76400000,"q13.3","gneg"],[76400000,81300000,"q14.1","gpos50"],[81300000,82800000,"q14.2","gneg"],[82800000,91900000,"q14.3","gpos100"],[91900000,97300000,"q15","gneg"],[97300000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121500000,"q23.1","gpos100"],[121500000,127300000,"q23.2","gneg"],[127300000,130400000,"q23.3","gpos100"],[130400000,135400000,"q31.1","gneg"],[135400000,139000000,"q31.2","gpos25"],[139000000,143100000,"q31.3","gneg"],[143100000,147200000,"q32","gpos75"],[147200000,152100000,"q33.1","gneg"],[152100000,155600000,"q33.2","gpos50"],[155600000,159900000,"q33.3","gneg"],[159900000,167400000,"q34","gpos100"],[167400000,172200000,"q35.1","gneg"],[172200000,176500000,"q35.2","gpos25"],[176500000,180857866,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4100000,"p25.2","gpos25"],[4100000,7000000,"p25.1","gneg"],[7000000,10600000,"p24.3","gpos50"],[10600000,11200000,"p24.2","gneg"],[11200000,13500000,"p24.1","gpos25"],[13500000,15500000,"p23","gneg"],[15500000,23500000,"p22.3","gpos75"],[23500000,26100000,"p22.2","gneg"],[26100000,29900000,"p22.1","gpos50"],[29900000,31900000,"p21.33","gneg"],[31900000,33600000,"p21.32","gpos25"],[33600000,36800000,"p21.31","gneg"],[36800000,40600000,"p21.2","gpos25"],[40600000,45200000,"p21.1","gneg"],[45200000,51100000,"p12.3","gpos100"],[51100000,52600000,"p12.2","gneg"],[52600000,57200000,"p12.1","gpos100"],[57200000,58400000,"p11.2","gneg"],[58400000,60500000,"p11.1","acen"],[60500000,63400000,"q11.1","acen"],[63400000,63500000,"q11.2","gneg"],[63500000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84700000,"q14.2","gneg"],[84700000,87500000,"q14.3","gpos50"],[87500000,92100000,"q15","gneg"],[92100000,98700000,"q16.1","gpos100"],[98700000,99900000,"q16.2","gneg"],[99900000,104800000,"q16.3","gpos100"],[104800000,113900000,"q21","gneg"],[113900000,117100000,"q22.1","gpos75"],[117100000,118600000,"q22.2","gneg"],[118600000,126200000,"q22.31","gpos100"],[126200000,127300000,"q22.32","gneg"],[127300000,130400000,"q22.33","gpos75"],[130400000,131300000,"q23.1","gneg"],[131300000,135200000,"q23.2","gpos50"],[135200000,139100000,"q23.3","gneg"],[139100000,142900000,"q24.1","gpos75"],[142900000,145700000,"q24.2","gneg"],[145700000,149100000,"q24.3","gpos75"],[149100000,152600000,"q25.1","gneg"],[152600000,155600000,"q25.2","gpos50"],[155600000,160900000,"q25.3","gneg"],[160900000,164400000,"q26","gpos50"],[164400000,170899992,"q27","gneg"]],7:[[0,2100000,"p22.3","gneg"],[2100000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13300000,"p21.3","gpos100"],[13300000,15200000,"p21.2","gneg"],[15200000,19500000,"p21.1","gpos100"],[19500000,24900000,"p15.3","gneg"],[24900000,28000000,"p15.2","gpos50"],[28000000,31800000,"p15.1","gneg"],[31800000,35600000,"p14.3","gpos75"],[35600000,37500000,"p14.2","gneg"],[37500000,43300000,"p14.1","gpos75"],[43300000,46600000,"p13","gneg"],[46600000,49800000,"p12.3","gpos75"],[49800000,50900000,"p12.2","gneg"],[50900000,53900000,"p12.1","gpos75"],[53900000,57400000,"p11.2","gneg"],[57400000,59100000,"p11.1","acen"],[59100000,61100000,"q11.1","acen"],[61100000,66100000,"q11.21","gneg"],[66100000,71800000,"q11.22","gpos50"],[71800000,77400000,"q11.23","gneg"],[77400000,86200000,"q21.11","gpos100"],[86200000,88000000,"q21.12","gneg"],[88000000,90900000,"q21.13","gpos75"],[90900000,92600000,"q21.2","gneg"],[92600000,97900000,"q21.3","gpos75"],[97900000,104400000,"q22.1","gneg"],[104400000,105900000,"q22.2","gpos50"],[105900000,107200000,"q22.3","gneg"],[107200000,114400000,"q31.1","gpos75"],[114400000,117200000,"q31.2","gneg"],[117200000,120900000,"q31.31","gpos75"],[120900000,123600000,"q31.32","gneg"],[123600000,126900000,"q31.33","gpos75"],[126900000,129000000,"q32.1","gneg"],[129000000,130100000,"q32.2","gpos25"],[130100000,132400000,"q32.3","gneg"],[132400000,137300000,"q33","gpos50"],[137300000,142800000,"q34","gneg"],[142800000,147500000,"q35","gpos75"],[147500000,152200000,"q36.1","gneg"],[152200000,154700000,"q36.2","gpos25"],[154700000,158821424,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19100000,"p22","gpos100"],[19100000,23400000,"p21.3","gneg"],[23400000,27400000,"p21.2","gpos50"],[27400000,29700000,"p21.1","gneg"],[29700000,38500000,"p12","gpos75"],[38500000,39500000,"p11.23","gneg"],[39500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,48100000,"q11.1","acen"],[48100000,50400000,"q11.21","gneg"],[50400000,52800000,"q11.22","gpos75"],[52800000,55600000,"q11.23","gneg"],[55600000,61700000,"q12.1","gpos50"],[61700000,62400000,"q12.2","gneg"],[62400000,66100000,"q12.3","gpos50"],[66100000,68100000,"q13.1","gneg"],[68100000,70600000,"q13.2","gpos50"],[70600000,74000000,"q13.3","gneg"],[74000000,78500000,"q21.11","gpos100"],[78500000,80300000,"q21.12","gneg"],[80300000,84900000,"q21.13","gpos75"],[84900000,87200000,"q21.2","gneg"],[87200000,93500000,"q21.3","gpos100"],[93500000,99100000,"q22.1","gneg"],[99100000,101600000,"q22.2","gpos25"],[101600000,106100000,"q22.3","gneg"],[106100000,110600000,"q23.1","gpos75"],[110600000,112200000,"q23.2","gneg"],[112200000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136500000,"q24.22","gneg"],[136500000,140000000,"q24.23","gpos75"],[140000000,146274826,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14100000,"p23","gpos75"],[14100000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25500000,"p21.3","gpos100"],[25500000,28100000,"p21.2","gneg"],[28100000,32800000,"p21.1","gpos100"],[32800000,36300000,"p13.3","gneg"],[36300000,38000000,"p13.2","gpos25"],[38000000,40200000,"p13.1","gneg"],[40200000,42400000,"p12","gpos50"],[42400000,46700000,"p11.2","gneg"],[46700000,51800000,"p11.1","acen"],[51800000,60300000,"q11","acen"],[60300000,70000000,"q12","gvar"],[70000000,70500000,"q13","gneg"],[70500000,72700000,"q21.11","gpos25"],[72700000,73100000,"q21.12","gneg"],[73100000,79300000,"q21.13","gpos50"],[79300000,80300000,"q21.2","gneg"],[80300000,83400000,"q21.31","gpos50"],[83400000,86100000,"q21.32","gneg"],[86100000,89600000,"q21.33","gpos50"],[89600000,91000000,"q22.1","gneg"],[91000000,93000000,"q22.2","gpos25"],[93000000,95600000,"q22.31","gneg"],[95600000,98200000,"q22.32","gpos25"],[98200000,101600000,"q22.33","gneg"],[101600000,107200000,"q31.1","gpos100"],[107200000,110300000,"q31.2","gneg"],[110300000,113900000,"q31.3","gpos25"],[113900000,116700000,"q32","gneg"],[116700000,122000000,"q33.1","gpos75"],[122000000,125800000,"q33.2","gneg"],[125800000,129300000,"q33.3","gpos25"],[129300000,132500000,"q34.11","gneg"],[132500000,132800000,"q34.12","gpos25"],[132800000,134900000,"q34.13","gneg"],[134900000,136600000,"q34.2","gpos25"],[136600000,140273252,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6700000,"p15.1","gneg"],[6700000,12300000,"p14","gpos75"],[12300000,17300000,"p13","gneg"],[17300000,19900000,"p12.33","gpos75"],[19900000,20500000,"p12.32","gneg"],[20500000,22800000,"p12.31","gpos75"],[22800000,24100000,"p12.2","gneg"],[24100000,28300000,"p12.1","gpos50"],[28300000,31400000,"p11.23","gneg"],[31400000,34500000,"p11.22","gpos25"],[34500000,38800000,"p11.21","gneg"],[38800000,40300000,"p11.1","acen"],[40300000,42100000,"q11.1","acen"],[42100000,46100000,"q11.21","gneg"],[46100000,50100000,"q11.22","gpos25"],[50100000,53300000,"q11.23","gneg"],[53300000,61200000,"q21.1","gpos100"],[61200000,64800000,"q21.2","gneg"],[64800000,71300000,"q21.3","gpos100"],[71300000,74600000,"q22.1","gneg"],[74600000,77400000,"q22.2","gpos50"],[77400000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89600000,"q23.2","gneg"],[89600000,92900000,"q23.31","gpos75"],[92900000,94200000,"q23.32","gneg"],[94200000,98000000,"q23.33","gpos50"],[98000000,99400000,"q24.1","gneg"],[99400000,102000000,"q24.2","gpos50"],[102000000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105700000,"q24.33","gneg"],[105700000,111800000,"q25.1","gpos100"],[111800000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127400000,"q26.13","gneg"],[127400000,130500000,"q26.2","gpos50"],[130500000,135374737,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12600000,"p15.3","gneg"],[12600000,16100000,"p15.2","gpos50"],[16100000,21600000,"p15.1","gneg"],[21600000,26000000,"p14.3","gpos100"],[26000000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51400000,"p11.12","gpos75"],[51400000,52900000,"p11.11","acen"],[52900000,56400000,"q11","acen"],[56400000,59700000,"q12.1","gpos75"],[59700000,61400000,"q12.2","gneg"],[61400000,63100000,"q12.3","gpos25"],[63100000,67100000,"q13.1","gneg"],[67100000,69200000,"q13.2","gpos25"],[69200000,70700000,"q13.3","gneg"],[70700000,74900000,"q13.4","gpos50"],[74900000,76700000,"q13.5","gneg"],[76700000,85300000,"q14.1","gpos100"],[85300000,87900000,"q14.2","gneg"],[87900000,92300000,"q14.3","gpos100"],[92300000,96700000,"q21","gneg"],[96700000,101600000,"q22.1","gpos100"],[101600000,102400000,"q22.2","gneg"],[102400000,110000000,"q22.3","gpos100"],[110000000,112800000,"q23.1","gneg"],[112800000,115400000,"q23.2","gpos50"],[115400000,120700000,"q23.3","gneg"],[120700000,123500000,"q24.1","gpos50"],[123500000,127400000,"q24.2","gneg"],[127400000,130300000,"q24.3","gpos50"],[130300000,134452384,"q25","gneg"]],12:[[0,3100000,"p13.33","gneg"],[3100000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14800000,"p13.1","gneg"],[14800000,19900000,"p12.3","gpos100"],[19900000,21200000,"p12.2","gneg"],[21200000,26300000,"p12.1","gpos100"],[26300000,27700000,"p11.23","gneg"],[27700000,30600000,"p11.22","gpos50"],[30600000,33200000,"p11.21","gneg"],[33200000,35400000,"p11.1","acen"],[35400000,36500000,"q11","acen"],[36500000,44600000,"q12","gpos100"],[44600000,47400000,"q13.11","gneg"],[47400000,48400000,"q13.12","gpos25"],[48400000,53100000,"q13.13","gneg"],[53100000,55200000,"q13.2","gpos25"],[55200000,56300000,"q13.3","gneg"],[56300000,61400000,"q14.1","gpos75"],[61400000,63400000,"q14.2","gneg"],[63400000,66000000,"q14.3","gpos50"],[66000000,69800000,"q15","gneg"],[69800000,74100000,"q21.1","gpos75"],[74100000,78700000,"q21.2","gneg"],[78700000,85100000,"q21.31","gpos100"],[85100000,87500000,"q21.32","gneg"],[87500000,91200000,"q21.33","gpos100"],[91200000,94800000,"q22","gneg"],[94800000,100000000,"q23.1","gpos75"],[100000000,102400000,"q23.2","gneg"],[102400000,107500000,"q23.3","gpos50"],[107500000,110200000,"q24.11","gneg"],[110200000,110800000,"q24.12","gpos25"],[110800000,112800000,"q24.13","gneg"],[112800000,115300000,"q24.21","gpos50"],[115300000,116700000,"q24.22","gneg"],[116700000,119100000,"q24.23","gpos50"],[119100000,124500000,"q24.31","gneg"],[124500000,128700000,"q24.32","gpos50"],[128700000,132349534,"q24.33","gneg"]],13:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,13500000,"p11.2","gvar"],[13500000,16000000,"p11.1","acen"],[16000000,18400000,"q11","acen"],[18400000,22200000,"q12.11","gneg"],[22200000,24400000,"q12.12","gpos25"],[24400000,26700000,"q12.13","gneg"],[26700000,27800000,"q12.2","gpos25"],[27800000,31100000,"q12.3","gneg"],[31100000,32900000,"q13.1","gpos50"],[32900000,34700000,"q13.2","gneg"],[34700000,39500000,"q13.3","gpos75"],[39500000,44300000,"q14.11","gneg"],[44300000,45900000,"q14.12","gpos25"],[45900000,46200000,"q14.13","gneg"],[46200000,48900000,"q14.2","gpos50"],[48900000,52200000,"q14.3","gneg"],[52200000,57600000,"q21.1","gpos100"],[57600000,60500000,"q21.2","gneg"],[60500000,64100000,"q21.31","gpos75"],[64100000,67200000,"q21.32","gneg"],[67200000,72100000,"q21.33","gpos100"],[72100000,74200000,"q22.1","gneg"],[74200000,76000000,"q22.2","gpos50"],[76000000,77800000,"q22.3","gneg"],[77800000,86500000,"q31.1","gpos100"],[86500000,88800000,"q31.2","gneg"],[88800000,93800000,"q31.3","gpos100"],[93800000,97000000,"q32.1","gneg"],[97000000,98100000,"q32.2","gpos25"],[98100000,100500000,"q32.3","gneg"],[100500000,103700000,"q33.1","gpos100"],[103700000,105800000,"q33.2","gneg"],[105800000,109100000,"q33.3","gpos100"],[109100000,114142980,"q34","gneg"]],14:[[0,3100000,"p13","gvar"],[3100000,6700000,"p12","stalk"],[6700000,13600000,"p11.2","gvar"],[13600000,15600000,"p11.1","acen"],[15600000,19100000,"q11.1","acen"],[19100000,23600000,"q11.2","gneg"],[23600000,31800000,"q12","gpos100"],[31800000,34100000,"q13.1","gneg"],[34100000,35600000,"q13.2","gpos50"],[35600000,36900000,"q13.3","gneg"],[36900000,41000000,"q21.1","gpos100"],[41000000,43200000,"q21.2","gneg"],[43200000,48300000,"q21.3","gpos100"],[48300000,52300000,"q22.1","gneg"],[52300000,54400000,"q22.2","gpos25"],[54400000,55800000,"q22.3","gneg"],[55800000,61200000,"q23.1","gpos75"],[61200000,64000000,"q23.2","gneg"],[64000000,67000000,"q23.3","gpos50"],[67000000,69300000,"q24.1","gneg"],[69300000,72900000,"q24.2","gpos50"],[72900000,78400000,"q24.3","gneg"],[78400000,82600000,"q31.1","gpos100"],[82600000,84000000,"q31.2","gneg"],[84000000,88900000,"q31.3","gpos100"],[88900000,90500000,"q32.11","gneg"],[90500000,92800000,"q32.12","gpos25"],[92800000,95400000,"q32.13","gneg"],[95400000,100400000,"q32.2","gpos50"],[100400000,102200000,"q32.31","gneg"],[102200000,103000000,"q32.32","gpos50"],[103000000,106368585,"q32.33","gneg"]],15:[[0,3500000,"p13","gvar"],[3500000,7900000,"p12","stalk"],[7900000,14100000,"p11.2","gvar"],[14100000,17000000,"p11.1","acen"],[17000000,18400000,"q11.1","acen"],[18400000,23300000,"q11.2","gneg"],[23300000,25700000,"q12","gpos50"],[25700000,28000000,"q13.1","gneg"],[28000000,29000000,"q13.2","gpos50"],[29000000,31400000,"q13.3","gneg"],[31400000,37900000,"q14","gpos75"],[37900000,40700000,"q15.1","gneg"],[40700000,41400000,"q15.2","gpos25"],[41400000,42700000,"q15.3","gneg"],[42700000,47600000,"q21.1","gpos75"],[47600000,51100000,"q21.2","gneg"],[51100000,55800000,"q21.3","gpos75"],[55800000,57100000,"q22.1","gneg"],[57100000,61500000,"q22.2","gpos25"],[61500000,64900000,"q22.31","gneg"],[64900000,65000000,"q22.32","gpos25"],[65000000,65300000,"q22.33","gneg"],[65300000,70400000,"q23","gpos25"],[70400000,73100000,"q24.1","gneg"],[73100000,74400000,"q24.2","gpos25"],[74400000,76100000,"q24.3","gneg"],[76100000,79500000,"q25.1","gpos50"],[79500000,83000000,"q25.2","gneg"],[83000000,86900000,"q25.3","gpos50"],[86900000,92100000,"q26.1","gneg"],[92100000,96300000,"q26.2","gpos50"],[96300000,100338915,"q26.3","gneg"]],16:[[0,6300000,"p13.3","gneg"],[6300000,10300000,"p13.2","gpos50"],[10300000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,20500000,"p12.3","gpos50"],[20500000,21700000,"p12.2","gneg"],[21700000,27600000,"p12.1","gpos50"],[27600000,34400000,"p11.2","gneg"],[34400000,38200000,"p11.1","acen"],[38200000,40700000,"q11.1","acen"],[40700000,45500000,"q11.2","gvar"],[45500000,51200000,"q12.1","gneg"],[51200000,54500000,"q12.2","gpos50"],[54500000,56700000,"q13","gneg"],[56700000,65200000,"q21","gpos100"],[65200000,69400000,"q22.1","gneg"],[69400000,69800000,"q22.2","gpos50"],[69800000,73300000,"q22.3","gneg"],[73300000,78200000,"q23.1","gpos75"],[78200000,80500000,"q23.2","gneg"],[80500000,82700000,"q23.3","gpos50"],[82700000,85600000,"q24.1","gneg"],[85600000,87200000,"q24.2","gpos25"],[87200000,88827254,"q24.3","gneg"]],17:[[0,3600000,"p13.3","gneg"],[3600000,6800000,"p13.2","gpos50"],[6800000,11200000,"p13.1","gneg"],[11200000,15900000,"p12","gpos75"],[15900000,22100000,"p11.2","gneg"],[22100000,22200000,"p11.1","acen"],[22200000,23200000,"q11.1","acen"],[23200000,28800000,"q11.2","gneg"],[28800000,35400000,"q12","gpos50"],[35400000,35600000,"q21.1","gneg"],[35600000,37800000,"q21.2","gpos25"],[37800000,41900000,"q21.31","gneg"],[41900000,44800000,"q21.32","gpos25"],[44800000,47600000,"q21.33","gneg"],[47600000,54900000,"q22","gpos75"],[54900000,55600000,"q23.1","gneg"],[55600000,58400000,"q23.2","gpos75"],[58400000,59900000,"q23.3","gneg"],[59900000,61600000,"q24.1","gpos50"],[61600000,64600000,"q24.2","gneg"],[64600000,68400000,"q24.3","gpos75"],[68400000,72200000,"q25.1","gneg"],[72200000,72900000,"q25.2","gpos25"],[72900000,78774742,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,16100000,"p11.1","acen"],[16100000,17300000,"q11.1","acen"],[17300000,23300000,"q11.2","gneg"],[23300000,31000000,"q12.1","gpos100"],[31000000,35500000,"q12.2","gneg"],[35500000,41800000,"q12.3","gpos75"],[41800000,46400000,"q21.1","gneg"],[46400000,52000000,"q21.2","gpos75"],[52000000,54400000,"q21.31","gneg"],[54400000,57100000,"q21.32","gpos50"],[57100000,59800000,"q21.33","gneg"],[59800000,64900000,"q22.1","gpos100"],[64900000,66900000,"q22.2","gneg"],[66900000,71300000,"q22.3","gpos25"],[71300000,76117153,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19800000,"p13.11","gneg"],[19800000,26700000,"p12","gvar"],[26700000,28500000,"p11","acen"],[28500000,30200000,"q11","acen"],[30200000,37100000,"q12","gvar"],[37100000,40300000,"q13.11","gneg"],[40300000,43000000,"q13.12","gpos25"],[43000000,43400000,"q13.13","gneg"],[43400000,47800000,"q13.2","gpos25"],[47800000,50000000,"q13.31","gneg"],[50000000,53800000,"q13.32","gpos25"],[53800000,57600000,"q13.33","gneg"],[57600000,59100000,"q13.41","gpos25"],[59100000,61400000,"q13.42","gneg"],[61400000,63811651,"q13.43","gpos25"]],20:[[0,5000000,"p13","gneg"],[5000000,9000000,"p12.3","gpos75"],[9000000,11900000,"p12.2","gneg"],[11900000,17800000,"p12.1","gpos75"],[17800000,21200000,"p11.23","gneg"],[21200000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,27100000,"p11.1","acen"],[27100000,28400000,"q11.1","acen"],[28400000,31500000,"q11.21","gneg"],[31500000,33900000,"q11.22","gpos25"],[33900000,37100000,"q11.23","gneg"],[37100000,41100000,"q12","gpos75"],[41100000,41600000,"q13.11","gneg"],[41600000,45800000,"q13.12","gpos25"],[45800000,49200000,"q13.13","gneg"],[49200000,54400000,"q13.2","gpos75"],[54400000,55900000,"q13.31","gneg"],[55900000,57900000,"q13.32","gpos50"],[57900000,62435964,"q13.33","gneg"]],21:[[0,2900000,"p13","gvar"],[2900000,6300000,"p12","stalk"],[6300000,10000000,"p11.2","gvar"],[10000000,12300000,"p11.1","acen"],[12300000,13200000,"q11.1","acen"],[13200000,15300000,"q11.2","gneg"],[15300000,22900000,"q21.1","gpos100"],[22900000,25800000,"q21.2","gneg"],[25800000,30500000,"q21.3","gpos75"],[30500000,34700000,"q22.11","gneg"],[34700000,36700000,"q22.12","gpos50"],[36700000,38600000,"q22.13","gneg"],[38600000,41400000,"q22.2","gpos50"],[41400000,46944323,"q22.3","gneg"]],22:[[0,3000000,"p13","gvar"],[3000000,6600000,"p12","stalk"],[6600000,9600000,"p11.2","gvar"],[9600000,11800000,"p11.1","acen"],[11800000,16300000,"q11.1","acen"],[16300000,20500000,"q11.21","gneg"],[20500000,21800000,"q11.22","gpos25"],[21800000,24300000,"q11.23","gneg"],[24300000,27900000,"q12.1","gpos50"],[27900000,30500000,"q12.2","gneg"],[30500000,35900000,"q12.3","gpos50"],[35900000,39300000,"q13.1","gneg"],[39300000,42600000,"q13.2","gpos50"],[42600000,47000000,"q13.31","gneg"],[47000000,48200000,"q13.32","gpos50"],[48200000,49691432,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19200000,"p22.13","gneg"],[19200000,21800000,"p22.12","gpos50"],[21800000,24900000,"p22.11","gneg"],[24900000,29400000,"p21.3","gpos100"],[29400000,31500000,"p21.2","gneg"],[31500000,37500000,"p21.1","gpos100"],[37500000,42300000,"p11.4","gneg"],[42300000,47300000,"p11.3","gpos75"],[47300000,49700000,"p11.23","gneg"],[49700000,54700000,"p11.22","gpos25"],[54700000,56600000,"p11.21","gneg"],[56600000,59500000,"p11.1","acen"],[59500000,65000000,"q11.1","acen"],[65000000,65100000,"q11.2","gneg"],[65100000,67700000,"q12","gpos50"],[67700000,72200000,"q13.1","gneg"],[72200000,73800000,"q13.2","gpos50"],[73800000,76000000,"q13.3","gneg"],[76000000,84500000,"q21.1","gpos100"],[84500000,86200000,"q21.2","gneg"],[86200000,91900000,"q21.31","gpos100"],[91900000,93500000,"q21.32","gneg"],[93500000,98200000,"q21.33","gpos75"],[98200000,102500000,"q22.1","gneg"],[102500000,103600000,"q22.2","gpos50"],[103600000,110500000,"q22.3","gneg"],[110500000,116800000,"q23","gpos75"],[116800000,120700000,"q24","gneg"],[120700000,129800000,"q25","gpos100"],[129800000,130300000,"q26.1","gneg"],[130300000,133500000,"q26.2","gpos25"],[133500000,137800000,"q26.3","gneg"],[137800000,140100000,"q27.1","gpos75"],[140100000,141900000,"q27.2","gneg"],[141900000,146900000,"q27.3","gpos100"],[146900000,154913754,"q28","gneg"]],Y:[[0,1700000,"p11.32","gneg"],[1700000,3300000,"p11.31","gpos50"],[3300000,11200000,"p11.2","gneg"],[11200000,11300000,"p11.1","acen"],[11300000,12500000,"q11.1","acen"],[12500000,14300000,"q11.21","gneg"],[14300000,19000000,"q11.221","gpos50"],[19000000,21300000,"q11.222","gneg"],[21300000,25400000,"q11.223","gpos50"],[25400000,27200000,"q11.23","gneg"],[27200000,57772954,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Gantt:["Gantt"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],AttGraphs:["Bar","Boxplot","Dotplot","Treemap","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","ParallelCoordinates","Line","Sankey","Tree","TagCloud","Gantt"],NoneDGraphs:["Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn"],NonSegregatable:["Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Circular","Gantt"]};CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Pastel1:{3:"fbb4aeb3cde3ccebc5",4:"fbb4aeb3cde3ccebc5decbe4",5:"fbb4aeb3cde3ccebc5decbe4fed9a6",6:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcc",7:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bd",8:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaec",9:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},Pastel2:{3:"b3e2cdfdcdaccbd5e8",4:"b3e2cdfdcdaccbd5e8f4cae4",5:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9",6:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2ae",7:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cc",8:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},Set1:{3:"e41a1c377eb84daf4a",4:"e41a1c377eb84daf4a984ea3",5:"e41a1c377eb84daf4a984ea3ff7f00",6:"e41a1c377eb84daf4a984ea3ff7f00ffff33",7:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628",8:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf",9:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},Set2:{3:"66c2a5fc8d628da0cb",4:"66c2a5fc8d628da0cbe78ac3",5:"66c2a5fc8d628da0cbe78ac3a6d854",6:"66c2a5fc8d628da0cbe78ac3a6d854ffd92f",7:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494",8:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},Set3:{3:"8dd3c7ffffb3bebada",4:"8dd3c7ffffb3bebadafb8072",5:"8dd3c7ffffb3bebadafb807280b1d3",6:"8dd3c7ffffb3bebadafb807280b1d3fdb462",7:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69",8:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5",9:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9",10:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bd",11:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5",12:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Pastel:{24:"b5b5ffffb5cbffedb5d7ffb5e5b5ffffd7b5ffffb5b5ffffffb5b5fff2b5c7b5ffb5ffb5ffb5ffffdfb5f2ffb5b5dfffd5b5ffffcab5fff8b5b5ffdfffb5dfffe6b5e6ffb5b5cbff"},Balanced:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676"},Rpalette:{8:"000000ff000000cd000000ff00ffffff00ffffff00bebebe"},RlatticeBackground:{7:"ffe5ccccffccccffffcce6ffffccffffccccffffcc"},RlatticeShingle:{7:"ff7f0000ff0000ffff0080ffff00ffff0000ffff00"},RlatticeLine:{7:"0080ffff00ff006400ff0000ffa50000ff00a52a2a"},RlatticePolygon:{7:"ccffffffccffccffccffe5cccce6ffffffccffcccc"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{1:""},White:{1:"ffffff"},Black:{1:"000000"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"f8766d",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},CanvasXpress:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressTraditional:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"}};for(var c in CanvasXpress.colorSchemes){for(var d in CanvasXpress.colorSchemes[c]){var b=CanvasXpress.colorSchemes[c][d].match(/.{6}/g);CanvasXpress.colorSchemes[c][d]=b?b.map(function(a){return"#"+a}):[]}}}();CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themes={economist:{backgroundType:"solid",backgroundWindow:"#D5E4EB",background:"#D5E4EB",colorScheme:"Economist",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#D5E4EB",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:false,yAxis2Show:true,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},excel:{backgroundType:"window",backgroundWindow:"#C0C0C0",background:"#FFFFFF",colorScheme:"Excel",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#000000",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},tableau:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"TableauMedium",legendColor:"#000000",legendBox:true,legendBoxColor:"#E5E5E5",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},stata:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#EAF2F3",colorScheme:"Stata",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:4,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"line",xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#EAF2F3",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},igray:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"GGPlot",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},solarized:{backgroundType:"solid",backgroundWindow:"#FDF6E3",background:"#FDF6E3",colorScheme:"Solarized",legendColor:"#93A1A1",legendBox:true,legendBoxColor:"#93A1A1",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#93A1A1",axisTitleColor:"#93A1A1",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#93A1A1",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#93A1A1",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#93A1A1",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#93A1A1",titleAlign:"left",titleColor:"#93A1A1",subtitleAlign:"left",subtitleColor:"#93A1A1"},paulTol:{backgroundType:"solid",backgroundWindow:"#FFFFFF",background:"#FFFFFF",colorScheme:"PaulTol",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},ggplot:{backgroundType:"window",backgroundWindow:"#E5E5E5",background:"#FFFFFF",colorScheme:"GGPlot",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E5E5E5",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#FFFFFF",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#FFFFFF",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},wallStreetJournal:{backgroundType:"solid",backgroundWindow:"#F8F2E4",background:"#F8F2E4",colorScheme:"WallStreetJournal3",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#F8F2E4",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"dotted",xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"dotted",yAxisTickColor:"#000000",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},cx:{backgroundType:"window",backgroundWindow:"#E8E8E8",background:"#FFFFFF",colorScheme:"CanvasXpress",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E8E8E8",axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#337AB7",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#337AB7",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},none:{backgroundType:"solid",backgroundWindow:"rgb(244,244,244)",background:"rgb(255,255,255)",colorScheme:"User",colors:CanvasXpress.colorSchemes.Default[20],legendColor:"rgb(0,0,0)",legendBox:true,legendBoxColor:"rgb(204,204,204)",legendBackgroundColor:"rgb(255,255,255)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(0,0,0)",axisTitleColor:"rgb(0,0,0)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"rgb(204,204,204)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(204,204,204)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"rgb(204,204,204)",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(204,204,204)",titleAlign:"center",titleColor:"rgb(0,0,0)",subtitleAlign:"center",subtitleColor:"rgb(0,0,0)"}};CanvasXpress.themes.CanvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasxpress=CanvasXpress.themes.cx;CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e;e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.setPixelImage=function(){if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.images.canvasXpress)})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.createNewTarget=function(){var cn=this.$cX("canvas").setAttribute("id",this.newId("canvasXpress"));window.document.body.appendChild(cn);return cn.id};this.newId=function(t){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return i};this.insertTarget=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.castCanvasAttributes(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.castCanvasAttributes=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(c,e)};this.removeTarget=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.getWindowSize=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.getWindowScroll=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.isInViewport=function(el,d){var w=this.getWindowSize();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.hasClass=function(e,n){return e.classList.contains(n)};this.addClass=function(e,n){e.classList.add(n)};this.removeClass=function(e,n){e.classList.remove(n)};this.getComputedCSS=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.getPropertyValue(o[i])+";"}return s};this.cancelEvent=function(e){if(!e){return}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.stopEvent=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.normalizeEvtName=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.copyEvent=function(e){var ce={};for(var i in e){ce[i]=e[i]}return ce};this.addEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.normalizeEvtName(e),c)}else{if(e=="touchstart"){o.addEventListener(e,c,f)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}}};this.removeEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.normalizeEvtName(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.getKeys(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.addRemoveEvtListener=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.purgeEventListeners=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.removeEvtListener(o,e,m[i][0],m[i][1])}}};this.preventSelection=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(e){var obj=e.target||e.srcElement;if(typeof(obj)!="object"){obj=this.$(obj)}return obj};this.dispatchEvent=function(el,e){el.dispatchEvent(e)};this.requestAnimationFrame=function(callback,time){if(callback){raf=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(raf){raf(callback)}else{if(!time){time=1000/60}window.setTimeout(callback,time)}}};this.setTimeout=function(callback,time){if(this.isR){setTimeout(callback,time)}else{var that=this;var wait=function(t){return new Promise(function(resolve,reject){if(t){setTimeout(resolve,t)}else{setTimeout(resolve,1000)}})};wait(time).then(function(){callback.apply(that)})}};this.setInterval=function(c,d){this.logConsole("canvasXpress setInterval ready - "+arguments.callee.caller.name+" - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}this.isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};this.initializeBrowser=function(){var getBrowserVersion=function(){var ua=window.navigator.userAgent;var tem;var m=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(m[1])){tem=/\brv[ :]+(\d+)/g.exec(ua)||[];return"IE "+(tem[1]||"")}if(m[1]==="Chrome"){tem=ua.match(/\b(OPR|Edge)\/(\d+)/);if(tem!=null){return tem.slice(1).join(" ").replace("OPR","Opera")}}m=m[2]?[m[1],m[2]]:[window.navigator.appName,window.navigator.appVersion,"-?"];if((tem=ua.match(/version\/(\d+)/i))!=null){m.splice(1,1,tem[1])}return m.join(" ")};var getOS=function(){var userAgent=window.navigator.userAgent;var platform=window.navigator.platform;var macosPlatforms=["Macintosh","MacIntel","MacPPC","Mac68K"];var windowsPlatforms=["Win32","Win64","Windows","WinCE"];var iosPlatforms=["iPhone","iPad","iPod"];var os=null;if(macosPlatforms.indexOf(platform)!==-1){os="Mac OS"}else{if(iosPlatforms.indexOf(platform)!==-1){os="iOS"}else{if(windowsPlatforms.indexOf(platform)!==-1){os="Windows"}else{if(/Android/.test(userAgent)){os="Android"}else{if(!os&&/Linux/.test(platform)){os="Linux"}}}}}return os};var str=getBrowserVersion().split(" ");var os=getOS();CanvasXpress.system={browser:str[0],browserVersion:str[1],os:os,alt:(os=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(os=="Mac OS"?"&#8963;":"Ctrl"),shift:(os=="Mac OS"?"&#8679;":"Shift"),isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(str[0].match(/safari/i)?true:this.isInIframe()),isTouchScreen:("ontouchstart" in window||"onmsgesturechange" in window||window.navigator.maxTouchPoints)}};this.setFunctionNames("initDOM");this.initializeBrowser()};CanvasXpress.prototype.initSVG=function(){
/*!!
	 *  Canvas 2 Svg v1.0.19
	 *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
	 *
	 *  Licensed under the MIT license:
	 *  http://www.opensource.org/licenses/mit-license.php
	 *
	 *  Author:
	 *  Kerry Liu
	 *
	 *  Copyright (c) 2014 Gliffy Inc.
	 */
;function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.canvasToSVG=k;this.setFunctionNames("initSVG")};CanvasXpress.prototype.initInterface=function(){this.parseJSON=function(s,r){if(s.match(/<!DOCTYPE/)){return undefined}else{if(r){return JSON.parse(s,r)}else{return JSON.parse(s,function(k,v){if(typeof v==="string"&&v.startsWith&&v.startsWith("/Function(")&&v.endsWith&&v.endsWith(")/")){v=v.substring(10,v.length-2);return eval("("+v+")")}else{return v}})}}};this.stringifyJSON=function(js,r,s){if(r){return JSON.stringify(js,r,s||null)}else{return JSON.stringify(js,function(k,v){if(typeof v==="function"){return"/Function("+v.toString()+")/"}else{if(k=="state"||k=="stateIndex"||k=="gantt"){return undefined}else{if(v instanceof Array){for(var p in v){if(Array.isArray(v[p])||v[p] instanceof Object){return v}}return JSON.stringify(v)}else{return v}}}},s||null).replace(/\\n/g,"").replace(/\\/g,"").replace(/\"\[/g,"[").replace(/\]\"/g,"]").replace(/\"\{/g,"{").replace(/\}\"/g,"}")}};this.isValidURL=function(str){var pattern=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return pattern.test(str)};this.stringToXML=function(str){var test=false;if(window.DOMParser){test=(new DOMParser()).parseFromString(str,"text/xml")}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){test=new window.ActiveXObject("Microsoft.XMLDOM");test.async="false";test.loadXML(str)}}return test};this.isValidXML=function(str){var test=this.stringToXML(str);return test!=null&&test.getElementsByTagName("parsererror").length==0};this.isValidJSON=function(str){try{JSON.parse(str)}catch(e){return false}return true};this.isValidDelimitedFile=function(str){var test=this.delimitedToArray(str);return this.isArray(test)&&this.isArray(test[0])};this.isValidString=function(str){var obj={type:false,data:false};if(this.isValidURL(str)){obj.type="URL";obj.data=str}else{if(this.isValidXML(str)){obj.type="XML";obj.data=this.stringToXML(str)}else{if(this.isValidJSON(str)){obj.type="JSON";obj.data=JSON.parse(str)}else{if(this.isValidDelimitedFile(str)){obj.type="DELIM";obj.data=this.delimitedToArray(str,false,true,this.graphType=="Network")}}}}return obj};this.loadParamsFile=function(t){return function(e){t.removeMenus();t.resetConfigurator(e);var file=e.target.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw()}}catch(e){alert("Oooops! Not a valid CanvasXpress json parameter file")}};reader.readAsText(file)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.parseDataFromPNG=function(p){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};var dv=new DataView(p);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");return this.parseJSON(res)}else{alert("Oooops! Not a valid CanvasXpress Image")}};this.loadFile=function(t){return function(e,jr,callback,f){t.removeMenus();t.resetConfigurator(e);t.showMask();var file=f?f:e.target?e.target.files[0]:e.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();if(type=="image/png"){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};reader.onload=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");var data=t.parseJSON(res);if(jr){return data}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{t.hideMask();alert("Oooops! Not a valid CanvasXpress Image")}};reader.readAsArrayBuffer(file)}else{var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);if(data.data||(data&&data.config&&data.config.graphType&&data.config.graphType=="Map")){data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.config){t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw()}}else{var foo=data.error.error}}}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="svg"){reader.onload=function(){try{var data=t.SVGtoCX(reader.result);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="txt"||ext=="csv"||ext=="tsv"||ext=="tab"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=ext=="csv"&&tc>tt?",":"\t";var data;if(t.graphType=="Network"){data=t.delimitedToArray(str,dl,false,true);if(data&&!t.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}alert(data.rows+" "+data.type+" records added to network data\n"+fail);if(data.type=="node"){t.appendNodeData(data.data)}else{t.appendEdgeData(data.data)}t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}else{data=t.isMetaDataFile(t.delimitedToArray(str,dl));if(data&&!t.isArray(data)){if(data.addt){alert(data.recs+" records added as an additional data set\n")}else{alert(data.recs+" records added to meta data\n")}t.appendMetaData(data.data,data.addt);t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="esv"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=tc>tt?",":"\t";var data=t.delimitedToArray(str,dl,false,true,"edge");data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="gml"){reader.onload=function(){try{var data=t.parseGML(reader.result);data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(ext.match(/ml$/)){reader.onload=function(){try{var xml=t.parseXML(reader.result);t.loadXML(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}}}}}}reader.readAsText(file)}}}(this);this.loadXML=function(xml,target,config,events){this.remoteServiceType="file";var ts1=xml.childNodes[0];var ts2=xml.childNodes[2]||xml.childNodes[1];if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){this.metabaseToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){this.cytoscapeToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){this.wikipathwayToCX(xml,target,config,events)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){this.keggToCX(xml,target,config,events)}}}}};this.editJSFiddle=function(t){return function(e,f){if(t.editable||f){t.removeMenus();var js="onReady(function () {\n"+t.getCodeJSONJS()+"})";var ht="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";ht+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";ht+="<canvas id='"+t.target+"' width='540' height='540'></canvas>";var rs="https://www.canvasxpress.org/dist/canvasXpress.css,https://www.canvasxpress.org/dist/canvasXpress.min.js";var form=t.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(form);var tatt=t.$cX("textarea",{name:"title",value:"CanvasXpress"});var taht=t.$cX("textarea",{name:"html",value:ht});var tajs=t.$cX("textarea",{name:"js",value:js});var tars=t.$cX("textarea",{name:"resources",value:rs});var btsb=t.$cX("button",{type:"submit"});form.appendChild(tatt);form.appendChild(taht);form.appendChild(tajs);form.appendChild(tars);form.appendChild(btsb);btsb.click();document.body.removeChild(form)}}}(this);this.save=function(t){return function(e,f,p){t.removeMenus();t.resetConfigurator(e);var flnm=f?f+".json":t.saveFilename?t.saveFilename+".json":"cX-"+t.target+".json";flnm=flnm.replace(/.json.json$/,".json");CanvasXpress.stack[t.target].client=CanvasXpress.factory.client;CanvasXpress.stack[t.target].clientIP=CanvasXpress.geo;var obj;if(p){obj=t.prettyJSON({config:CanvasXpress.stack[t.target].config,afterRender:CanvasXpress.stack[t.target].afterRender||[]})}else{obj=t.prettyJSON(CanvasXpress.stack[t.target])}var blob=new Blob([obj],{type:"text/plain;charset="+window.document.characterSet});t.saveAs(blob,flnm)}}(this);this.saveSVG=function(t){return function(e,f){t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].client=CanvasXpress.factory.client;CanvasXpress.stack[t.target].clientIP=CanvasXpress.geo;t.isSVG=true;var tr=t.showTransition;t.showTransition=false;t.meta.canvas.ctx5=new this.canvasToSVG({width:t.width,height:t.height,desc:t.isReproducibleResearch?t.stringifyJSON(CanvasXpress.stack[t.target]):""});t.renderGraph(true);var svg=t.meta.canvas.ctx5.getSerializedSvg();if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var flnm=f?f+".svg":t.saveFilename?t.saveFilename+".svg":"cX-"+t.target+".svg";flnm=flnm.replace(/.svg.svg$/,".svg");var blob=new Blob([svg],{type:"image/svg+xml;charset="+window.document.characterSet});t.saveAs(blob,flnm);t.showTransition=tr;delete (t.meta.canvas.ctx5);t.isSVG=false}}(this);this.parseXML=function(xml){var dom=null;if(window.DOMParser){try{dom=(new DOMParser()).parseFromString(xml,"text/xml")}catch(e){dom=null}}else{if(window.ActiveXObject){try{dom=new ActiveXObject("Microsoft.XMLDOM");dom.async=false;if(!dom.loadXML(xml)){window.alert(dom.parseError.reason+dom.parseError.srcText)}}catch(e){dom=null}}else{alert("cannot parse xml string!")}}return dom};this.parseHTMLTable=function(table,cx){var ar=[];for(var i=0;i<table.rows.length;i++){var ln=[];for(var j=0;j<table.rows.item(i).cells.length;j++){ln.push(table.rows.item(i).cells.item(j).innerHTML)}ar.push(ln)}if(cx){cx=this.arrayToCanvasXpress(ar);CanvasXpress.transferDatasetAttributes(table,cx.config,true);return cx}else{return ar}};this.SVGtoCX=function(xml){var dom=this.parseXML(xml);var svg=dom.childNodes[0];if(svg.tagName.match(/svg/i)){var desc=svg.getAttribute("desc");if(desc){return this.parseJSON(desc)}}};this.print=function(t){return function(e,f,c){var wn=window;var ow=t.width;var oh=t.height;var pm=t.printMagnification;var as=t.autoScaleFont;var st=t.showTransition;var ss=t.skipStack;var pr=["outlineWidth","lineThickness","axisTickThickness","axisMinMaxTickThickness","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(t.target)){t=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var adjustDPI=function(reset){if(reset&&pm!=1){for(var i=0;i<pr.length;i++){t[pr[i]]/=pm}t.autoScaleFont=as;t.showTransition=st;t.setDimensions(ow,oh,true);t.skipStack=ss}else{if(pm!=1){t.skipStack=true;t.showTransition=false;for(var i=0;i<pr.length;i++){t[pr[i]]*=pm}t.autoScaleFont=true;t.setDimensions(ow*pm,oh*pm,true)}}};var makeCRCTable=function(){var cn;var crcTable=[];for(var n=0;n<256;n++){cn=n;for(var k=0;k<8;k++){cn=((cn&1)?(3988292384^(cn>>>1)):(cn>>>1))}crcTable[n]=cn}return crcTable};var crc32=function(str){var crcTable=wn.crcTable||(wn.crcTable=makeCRCTable());var crc=0^(-1);for(var i=0;i<str.length;i++){crc=(crc>>>8)^crcTable[(crc^str.charCodeAt(i))&255]}return(crc^(-1))>>>0};var appendBuffer=function(buffer1,buffer2){var tmp=new Uint8Array(buffer1.byteLength+buffer2.byteLength);tmp.set(new Uint8Array(buffer1),0);tmp.set(new Uint8Array(buffer2),buffer1.byteLength);return tmp.buffer};var getArrayBuffer=function(string){var ztxt="tEXt";var len=string.length;var crc=crc32(ztxt+string);var mab=new ArrayBuffer(12+len);var ndv=new DataView(mab);ndv.setUint32(0,len);for(var i=0;i<ztxt.length;i++){ndv.setUint8(4+i,ztxt.charCodeAt(i))}for(var i=0;i<string.length;i++){ndv.setUint8(8+i,string.charCodeAt(i))}ndv.setUint32(4+4+len,crc);return mab};var cleanStack=function(){if(t.isReproducibleResearch){if(t.printMagnification!=1){delete (CanvasXpress.stack[t.target].config.showTransition)}return t.stringifyJSON(CanvasXpress.stack[t.target])}else{var stk=t.parseJSON(t.stringifyJSON(CanvasXpress.stack[t.target]));stk.afterRender=[stk.afterRender[0]];return t.stringifyJSON(stk)}};var collectArrayBuffers=function(hab,sab,rab,dab){var nab=appendBuffer(hab,sab);nab=appendBuffer(nab,rab);nab=appendBuffer(nab,dab);return nab};var toDataUrl=function(blb){var fr=new FileReader();var tx="";if(t.isReproducibleResearch){tx+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{tx+="<h2>Right click to save image</h2>"}fr.onload=function(evt){tx+="<img width="+t.width+" height="+t.height+" src= '"+evt.target.result+"'/>";t.showTooltipDiv(e,tx,t.getTargetEvent(e),{maxWidth:t.width+"px",whiteSpace:"normal"},40,40)};fr.readAsDataURL(blb)};adjustDPI();t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].geo=CanvasXpress.geo;var cnv=t.isMap&&t.leafletLayer?t.getLeafletCanvas():t.meta.canvas.ctx.canvas;cnv.toBlob(function(blob){var fr=new FileReader();var fn=f?f+".png":t.saveFilename?t.saveFilename+".png":"cX-"+t.target+".png";fn=fn.replace(/.png.png$/,".png");fr.onloadend=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var idat=8+4+4+ihdr+4;var hab=this.result.slice(0,idat);var dab=this.result.slice(idat);var sab=getArrayBuffer("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var rab=getArrayBuffer("ReproducibleResearch\0"+cleanStack());var nab=collectArrayBuffers(hab,sab,rab,dab);var blb=new Blob([nab],{type:"image/png"});if(c){return c(blb,fn)}else{if(t.printType=="download"){if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}t.saveAs(blb,fn)}else{toDataUrl(blb)}}adjustDPI(true)};fr.readAsArrayBuffer(blob)},"image/png");if(t.maximized){t.clickGraphMaxMin(e)}}}(this);this.exportToSVG=function(t){return function(e){var ctx=t.meta.canvas.ctx;t.meta.canvas.ctx=new this.canvasToSVG({width:t.width,height:t.height});t.draw();var svg=t.prettyXML(t.meta.canvas.ctx.getSerializedSvg());var win=window.open("",t.target+"-SVG");win.document.write(svg);t.meta.canvas.ctx=ctx;t.draw();return false}}(this);this.exportToExcel=function(d){return this.exportToTabDelimited(d);var table=this.exportToHTML(d,true);var uri="data:application/vnd.ms-excel;base64,";var template='<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="https://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>';var base64=function(s){return window.btoa(unescape(encodeURIComponent(s)))};var format=function(s,c){return s.replace(/{(\w+)}/g,function(m,p){return c[p]})};var ctx={worksheet:"Worksheet",table:table};var link=this.$(this.target+"-cX-linkExcel");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkExcel"},{display:"none"});window.document.body.appendChild(link)}link.href=uri+base64(format(template,ctx));link.download=this.target+".xls";link.click()};this.exportToHTML=function(d,t){var str="<table>";for(var i=0;i<d.length;i++){str+="<tr><td>";str+=d[i].join("</td><td>");str+="</td></tr>"}str+="</table>";return t?str:window.open().document.write(str)};this.exportToTabDelimited=function(d){var str="";for(var i=0;i<d.length;i++){str+=d[i].join("\t")+"\n"}var link=this.$(this.target+"-cX-linkTab");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(link)}link.download=this.target+".tsv";link.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(str);link.click()};this.arrayToHTML=function(d){var str="";str+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';str+='<table class="CanvasXpressDataTable" style="position:inherit;">';str+="<tbody>";str+="<tr>";for(var i=0;i<d[0][0].length;i++){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][0][i];str+="</div>";str+="</th>"}str+="</tr>";for(var i=1;i<d[0].length;i++){str+="<tr>";for(var j=0;j<d[0][i].length;j++){if(j==0){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</th>"}else{if(d[2]&&d[2][i]&&d[2][i][j]){str+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+d[2][i][j]+'">'}else{str+='<td class="CanvasXpressTableCell" style="height:18px">'}str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</td>"}}str+="</tr>"}str+="</tbody>";str+="</table>";str+="</div>";return str};this.rToPrettyR=function(s){var nice=[];var lines=s.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var funcs=["header","quote","row.names","fill","check.names","stringsAsFactors"];var call=false;for(var i=0;i<lines.length;i++){var l=lines[i];if(l.match(/library\(canvasXpress\)/)){nice.push(l.replace("library(canvasXpress)",'library(<span class="json-value">canvasXpress</span>)'))}else{if(l.match(/canvasXpress\(/)){nice.push(l.replace("canvasXpress(",'<span class="json-value">canvasXpress</span>('));call=true}else{if(l.match(/\"http.+\"/)){l=l.replace(/(\"http.+?\")/,'<span class="json-string">$1</span>');for(var j=0;j<funcs.length;j++){l=l.replace(funcs[j],'<span class="json-key">'+funcs[j]+"</span>")}l=l.replace('""','<span class="json-string">""</span>,');l=l.replace(/\"\t\"/,'<span class="json-string">"&#92;t"</span>');l=l.replace("=1,",'=<span class="json-number">1</span>,');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>');nice.push(l)}else{if(call){if(l.match(/\".+?\"/)){l=l.replace(/(\".+?\")/g,'<span class="json-string">$1</span>')}else{if(l.match(/[^xis][\d\.]+/)){l=l.replace(/([\d\.]+)/,'<span class="json-number">$1</span>')}}l=l.replace(/\n/,"&#92;n");l=l.replace(/(\w+)?=/,'<span class="json-key">$1=</span>');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>')}nice.push(l)}}}}return'<pre class="CanvasXpressCodeContent">\n<code>'+nice.join("</code>\n<code>")+"</code>\n</pre>"};this.prettyColoredR=function(o,r,c){var json=this.stringifyJSON(o,r?r:null,2);if(c){json=json.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}json=json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){match=match.replace(/"/g,"").replace(":"," =");cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){match=match.replace("false","FALSE").replace("true","TRUE");cls="boolean"}else{if(/null/.test(match)){cls="null"}}}return c?('<span class="json-'+cls+'">'+match+"</span>"):match});return json.replace(/\[/g,"c(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")};this.dataToR=function(){var arr=[];var prp=[];var vls,vrs,sps,dat,nod,edg,cod;var scr="";var ini="<span class=json-value>canvasXpress</span>(\n";if(this.meta.config.remote){scr+='data = "'+this.meta.config.remote.data+'"\n';ini+="  <span class=json-key>data</span> = data,\n"}else{if(this.graphType=="Map"){scr+="";ini+="  <span class=json-key>data</span> = <span class=json-value>FALSE</span>,\n"}else{if(this.data.y){for(var i=0;i<this.data.y.vars.length;i++){arr=arr.concat(this.data.y.data[i])}vls="vals = c(<span class=json-number>"+arr.join("</span>,<span class=json-number>")+"</span>)\n";vrs='vars = c(<span class=json-string>"'+this.data.y.vars.join('"</span>,<span class=json-string>"')+'"</span>)\n';sps='smps = c(<span class=json-string>"'+this.data.y.smps.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="data = as.data.frame(matrix(vals, <span class=json-key>nrow</span> = <span class=json-number>"+this.data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+this.data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(vars, smps)))\n";scr+=vls+vrs+sps+dat;ini+="  <span class=json-key>data</span> = data,\n"}if(this.data.x){arr=[];prp=[];vls="";for(var i in this.data.x){if(this.meta.data.x[i].type=="Numeric"){vls+="<span class=json-number>"+this.data.x[i].join("</span>,<span class=json-number>")+"</span>,"}else{vls+='<span class=json-string>"'+this.data.x[i].join('"</span>,<span class=json-string>"')+'"</span>,'}prp.push(i)}vls="valx = c("+vls.replace(/,$/,")\n");vrs='varx = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datx = as.data.frame(matrix(valx, <span class=json-key>nrow</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+this.data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(varx, smps)))\n";scr+=vls+vrs+dat;ini+="  <span class=json-key>smpAnnot</span> = datx,\n"}if(this.data.z){arr=[];prp=[];vls="";for(var i in this.data.z){if(this.meta.data.z[i].type=="Numeric"){vls+="<span class=json-number>"+this.data.z[i].join("</span>,<span class=json-number>")+"</span>,"}else{vls+='<span class=json-string>"'+this.data.z[i].join('"</span>,<span class=json-string>"')+'"</span>,'}prp.push(i)}vls="valz = c("+vls.replace(/,$/,")\n");sps='smpz = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datz = as.data.frame(matrix(valz, <span class=json-key>nrow</span> = <span class=json-number>"+this.data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>FALSE</span>, <span class=json-key>dimnames</span> = list(vars, smpz)))\n";scr+=vls+sps+dat;ini+="  <span class=json-key>varAnnot</span> = datz,\n"}if(this.data.nodes){scr+="nodes = list(\n"+this.prettyColoredR(this.data.nodes,false,true)+")\n";ini+="  <span class=json-key>nodeData</span> = nodes,\n"}if(this.data.edges){scr+="edges = list(\n"+this.prettyColoredR(this.data.edges,false,true)+")\n";ini+="  <span class=json-key>edgeData</span> = edges,\n"}if(this.data.venn){scr+="venn = data.frame(\n"+this.prettyColoredR(this.data.venn.data,false,true)+")\n";ini+="  <span class=json-key>vennData</span> = venn,\n";if(this.data.venn.legend){scr+="legn = data.frame(\n"+this.prettyColoredR(this.data.venn.legend,false,true)+")\n";ini+="  <span class=json-key>vennLegend</span> = legn,\n"}}}}ini+=this.prettyColoredR(this.meta.config.remote?this.meta.config.remote.config:this.meta.config.user,false,true)+")";cod="library(<span class=json-value>canvasXpress</span>)\n"+scr+ini;return"<code> "+cod.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.prettyJSON=function(o,r,c,i){return c?this.prettyColoredJSON(o,r):this.stringifyJSON(o,r,i||2)};this.prettyColoredJSON=function(o,r){var json=this.stringifyJSON(o,r?r:null,2).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){cls="boolean"}else{if(/null/.test(match)){cls="null"}}}return'<span class="json-'+cls+'">'+match+"</span>"})};this.prettyXML=function(str){var reg=/(>)\s*(<)(\/*)/g;var wsexp=/ *(.*) +\n/g;var contexp=/(<.+>)(.+\n)/g;var xml=str.replace(reg,"$1\n$2$3").replace(wsexp,"$1\n").replace(contexp,"$1\n$2");var pad=0;var formatted="";var lines=xml.split("\n");var indent=0;var lastType="other";var transitions={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var i=0;i<lines.length;i++){var ln=lines[i];var single=Boolean(ln.match(/<.+\/>/));var closing=Boolean(ln.match(/<\/.+>/));var opening=Boolean(ln.match(/<[^!].*>/));var type=single?"single":closing?"closing":opening?"opening":"other";var fromTo=lastType+"->"+type;lastType=type;var padding="";indent+=transitions[fromTo];for(var j=0;j<indent;j++){padding+="  "}formatted+=padding+ln+"\n"}return formatted};this.delimitedToArrayOrig=function(str,delim,cx){delim=delim||",";var pat=new RegExp(("(\\"+delim+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+delim+"\\r\\n]*))"),"gi");var arr=[[]];var arrM=null;while(arrM=pat.exec(str)){var strM=arrM[1];if(strM.length&&strM!==delim){arr.push([])}var strV;if(arrM[2]){strV=arrM[2].replace(new RegExp('""',"g"),'"')}else{strV=arrM[3]}arr[arr.length-1].push(this.isNumber(strV)?Number(strV):strV!=this.missingDataValue?strV:null)}return cx?this.arrayToCanvasXpress(arr):arr};this.delimitedToArray=function(str,delim,cx,net,nwt){var nl=/\r\n|\r|\n/g;var ar=str.split(nl);var setDelim=function(){var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}delim=tc>tt?",":"\t"};if(!delim){setDelim()}for(var i=0;i<ar.length;i++){if(ar[i].match(/^#/)){ar.splice(i,1);i--;continue}var f=ar[i].split(delim);for(var x=f.length-1;x>=0;x--){if(f[x].replace(/"\s+$/,'"').charAt(f[x].length-1)=='"'){var tl=f[x].replace(/^\s+"/,'"');if(tl.length>1&&tl.charAt(0)=='"'){f[x]=f[x].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(x){f.splice(x-1,2,[f[x-1],f[x]].join(delim))}else{f=f.shift().split(delim).concat(f)}}}else{f[x].replace(/""/g,'"')}}for(var j=0;j<f.length;j++){if(this.isNumber(f[j])){f[j]=Number(f[j])}else{if(f[j]==this.missingDataValue){f[j]=null}else{if(f[j].match(/^\[.+\]$/)||f[j].match(/^\{.+\}$/)){f[j]=this.parseJSON(f[j])}}}}if(f.length==1&&f[0]==""){ar.splice(i,1);i--;continue}ar[i]=f}return cx&&!nwt?this.arrayToCanvasXpress(ar):net?this.isNetworkFile(ar,nwt):ar};this.isMetaDataFile=function(arr){if(this.varIndices.length&&this.smpIndices.length){var that=this;var getObject=function(t){if(t=="s"){return{y:{smps:that.cloneObject(that.data.y.smps)},x:{}}}else{return{y:{vars:that.cloneObject(that.data.y.vars)},z:{}}}};var rows={s:[],v:[]};var cols={s:[],v:[]};var idx;var min=2;var add=false;for(var i=1;i<arr.length;i++){idx=this.getSampleIndices(arr[i][0]);if(idx>-1){rows.s.push([i,idx]);continue}idx=this.getVariableIndices(arr[i][0]);if(idx>-1){rows.v.push([i,idx]);continue}}for(var i=1;i<arr[0].length;i++){idx=this.getVariableIndices(arr[0][i]);if(idx>-1){cols.v.push([i,idx]);continue}idx=this.getSampleIndices(arr[0][i]);if(idx>-1){cols.s.push([i,idx]);continue}}var rs=rows.s.length>min?rows.s.length:0;var rv=rows.v.length>min?rows.v.length:0;var cs=cols.s.length>min?cols.s.length:0;var cv=cols.v.length>min?cols.v.length:0;var sl=this.data.y.smps.length;var vl=this.data.y.vars.length;if(rs||rv||cs||cv){var n=0;if(rs==sl&&cv==vl){var data=[];for(var i=0;i<cols.v.length;i++){var ii=cols.v[i][0];var ix=cols.v[i][1];data[ix]=[];for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data[ix][jx]=arr[jj][ii];n++}}add=true}else{if(cs==sl&&rv==vl){var data=[];for(var i=0;i<rows.v.length;i++){var ii=rows.v[i][0];var ix=rows.v[i][1];data[ix]=[];for(var j=0;j<cols.s.length;j++){var jj=cols.s[j][0];var jx=cols.s[j][1];data[ix][jx]=arr[ii][jj];n++}}add=true}else{if(rs>=rv&&rs>=cs&&rs>=cv){var data=getObject("s");for(var i=1;i<arr[0].length;i++){data.x[arr[0][i]]=[];var m=0;for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data.x[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.x[arr[0][i]]}}}else{if(rv>=rs&&rv>=cs&&rv>=cv){var data=getObject("v");for(var i=1;i<arr[0].length;i++){data.z[arr[0][i]]=[];var m=0;for(var j=0;j<rows.v.length;j++){var jj=rows.v[j][0];var jx=rows.v[j][1];data.z[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.z[arr[0][i]]}}}else{if(cs>rs&&cs>=rv&&cs>=cv){var data=getObject("s");for(var i=0;i<cols.s.length;i++){var ii=cols.s[i][0];var ix=cols.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.x[arr[j][0]]=[]}data.x[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.x[arr[j][0]]}}}else{if(cv>rs&&cv>=rv&&cv>=cs){var data=getObject("v");for(var i=0;i<rows.s.length;i++){var ii=rows.s[i][0];var ix=rows.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.z[arr[j][0]]=[]}data.z[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.z[arr[j][0]]}}}}}}}}return{data:data,recs:n,addt:add}}else{return arr}}return arr};this.isNetworkFile=function(arr,nwt){var obj={};var cols=arr[0];var nodes=0;var edges=0;var fail=0;var type=nwt||false;if(type=="node"){}else{if(type=="edge"){nodes={};obj.data={nodes:[],edges:[]};for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(n&&m){var e={id1:n,id2:m};for(var j=2;j<arr[i].length;j++){e[arr[0][j]]=arr[i][j]}obj.data.edges.push(e)}nodes[n]=true;nodes[m]=true}for(var i in nodes){obj.data.nodes.push({id:i,shape:"sphere"})}obj.config={graphType:"Network"};return obj}else{var map={};for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++}else{if(this.data.nodeIndices.hasOwnProperty(n)){nodes++}else{fail++}}map[n]=i}if(!nodes&&!edges){for(var i=0;i<this.data.nodes.length;i++){var n=this.data.nodes[i];if(n.hasOwnProperty("extId")&&map.hasOwnProperty(n.extId)){arr[map[n.extId]][0]=n.id;nodes++}}}if(edges>nodes){nodes=0;edges=0;fail=0;type="edge";for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++;obj[n+":"+m]={};for(var j=2;j<cols.length;j++){obj[n+":"+m][cols[j]]=arr[i][j]}}else{fail++}}}else{if(nodes>8){nodes=0;edges=0;fail=0;type="node";for(var i=1;i<arr.length;i++){var n=arr[i][0];if(this.data.nodeIndices.hasOwnProperty(n)){nodes++;obj[n]={};for(var j=1;j<cols.length;j++){obj[n][cols[j]]=arr[i][j]}}else{fail++}}}else{return arr}}if((type=="edge"&&(edges>5||edges>=arr.length-1))||(type=="node"&&(nodes>5||nodes>=arr.length-1))){return{data:obj,rows:Math.max(nodes,edges),fail:fail,type:type}}else{return arr}}}};this.XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p){json[p].push(j)}}else{if(p=="alt"){json[p].push(xml.textContent.replace(/\"/g,"'").replace(/\[/g,"&#91").replace(/\]/g,"&#93"))}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();this.XMLToJSON(n,json,p)}}}}}return json};this.cytoscapeToCX=function(xml,target,config,events){var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var nodes=[];var edges=[];var title="";var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="graph"){var ob=this.XMLToJSON(pw,false,false,true);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();var js=this.XMLToJSON(el);switch(nn){case"node":if(js.graphics&&js.id){var gr=js.graphics[0];var node={id:js.id,x:Number(gr.x),y:Number(gr.y),z:Number(gr.z),width:Number(gr.w),height:Number(gr.h),shape:(sp[gr.type]||gr.type),color:gr.fill,outline:gr.outline,outlineWidth:Number(gr.width)};if(js.label){node.name=js.label}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/NODE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.name=="COMMON"&&at.value){node.label=at.value}else{if(at.value){node[at.name]=at.value}}break;case"Double":case"Integer":if(at.value!=null){node[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){node[at.name]=at.value==0?false:true}break}}}}nodes.push(node)}break;case"edge":if(js.source&&js.target){var edge={id1:js.source,id2:js.target};if(js.id){edge.intId=js.id}if(js.label){edge.label=js.label}if(js.directed){edge.directed=js.directed}if(js.graphics){edge.color=js.graphics[0].fill;edge.width=js.graphics[0].width}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/EDGE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.value){edge[at.name]=at.value}break;case"Double":case"Integer":if(at.value!=null){edge[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){edge[at.name]=at.value==0?false:true}break}}}}edges.push(edge)}break;case"att":if(js.name&&js.value&&js.name=="Dataset Name"){title=js.value}break}}}}else{alert("Ooops! Not a cytoscape xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Cytoscape"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.keggToCX=function(xml,target,config,events){var that=this;var pw=xml.childNodes[2]||xml.childNodes[1];var nodes=[];var edges=[];var title,image,link,width,height;var addAnchors=function(){nodes.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:width,y:height,hideLabel:true})};if(pw.tagName.toLowerCase()=="pathway"){var ob=this.XMLToJSON(pw,false,false,true);title=ob.title;image=ob.image;link=ob.link;var img=new Image();img.onload=function(){width=this.width;height=this.height;var res="Number of Nodes: "+nodes.length+"\n";res+="Number of Edges: "+edges.length+"\n";addAnchors();that.remoteServiceType="file";that.networkFreeze=false;var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,networkFreeze:false,showNodeNameThreshold:20000,preScaleNetwork:false,title:title,backgroundType:"image",backgroundImage:image,networkVendor:"Kegg"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=that.cloneObject(that.meta.config.user);if(that.graphType=="Network"){for(var p in that.meta.config.user){data.config[p]=that.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}that.updateRemoteData(data,clbk);that.hideMask()};if((CanvasXpress.system.isR&&!CanvasXpress.system.isInIframe)||!CanvasXpress.system.isR){img.crossOrigin="anonymous"}img.src=ob.image;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"entry":var ob=this.XMLToJSON(el);if(ob.graphics[0].type=="roundrectangle"){ob.graphics[0].type="roundrect";ob.graphics[0].fgcolor="rgba(0,0,0,0)"}if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type!="line"){var ext=ob.type=="group"?5:0;var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:ob.graphics[0].type,color:"rgba(0,0,0,0)",outline:that.validateColor(ob.graphics[0].fgcolor)||"rgb(0,0,0)",width:parseInt(ob.graphics[0].width)+ext,height:parseInt(ob.graphics[0].height)+ext,x:parseInt(ob.graphics[0].x),y:parseInt(ob.graphics[0].y),hideLabel:true,fixed:true};if(ob.type=="group"){nodes.unshift(node)}else{nodes.push(node)}}else{if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type=="line"){var coords=ob.graphics[0].coords.split(",");if(coords.length==4){var x=[];var y=[];var w,h,r;while(coords.length>1){x.push(parseInt(coords.shift()));y.push(parseInt(coords.shift()))}var mx=parseInt(this.mean(x));var my=parseInt(this.mean(y));if(x[0]==x[1]){mx+=1;w=2;h=y[1]-y[0];r=0}else{if(y[0]==y[1]){my+=1;w=x[1]-x[0];h=2;r=0}else{h=this.lineLength(x[0],y[0],x[1],y[1]);w=2;r=this.getAngle(x[0],y[0],x[1],y[1])}}var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:mx,y:my,width:w,height:h,rotate:r,hideLabel:true,fixed:true};nodes.push(node)}}}break;case"relation":case"reaction":var ob=this.XMLToJSON(el);ob.id1=this.cloneObject(ob.entry1);ob.id2=this.cloneObject(ob.entry2);delete (ob.entry1);delete (ob.entry2);ob.color="rgba(0,0,0,0)";edges.push(ob);break}}}}else{alert("Ooops! Not a kgml file!")}};this.wikipathwayToCX=function(xml,target,config,events){var pw=xml.childNodes[0];var nodes={};var edges=[];var state={};var groups={};var anchors={};var order={};var cntp=1;var cntn=0;var sord=[];var groupRef={};var groupGref={};var groupId={};var wrn="\nWarnings:\n";var htt=false;var title,subtitle;var arrowTypes={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":"arrow","mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var createNodeFromGroup=function(grp,id){var mnx=Number.MAX_VALUE;var mny=Number.MAX_VALUE;var mxx=-Number.MAX_VALUE;var mxy=-Number.MAX_VALUE;var ids=[];var ord=[];var shw=false;for(var i=0;i<grp.length;i++){mnx=Math.min(mnx,grp[i][1]-(grp[i][3]/2));mny=Math.min(mny,grp[i][2]-(grp[i][4]/2));mxx=Math.max(mxx,grp[i][1]+(grp[i][3]/2));mxy=Math.max(mxy,grp[i][2]+(grp[i][4]/2));ids.push(grp[i][0]);nodes[grp[i][0]].parentNode=id;ord.push(nodes[grp[i][0]].zorder);if(nodes[grp[i][0]].nodeName!="label"){shw=true}ord.sort(function(a,b){return a-b})}var w=mxx-mnx;var h=mxy-mny;var ob={id:id,x:(mnx+mxx)/2,y:(mny+mxy)/2,width:w+(grp.length>1&&w>10?5:0),height:h+(grp.length>1&&h>10?5:0),group:ids,hideLabel:true,hideTooltip:htt,type:"Group",color:(shw?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(shw?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:ord[0]};order[id]=cntn--;nodes[id]=ob;sord.push(id)};var createNodeFromPoint=function(p,id){var ob={id:id,x:Math.round(p.x*10)/10,y:Math.round(p.y*10)/10,width:p.width?Math.round(p.width):1,height:p.height?Math.round(p.height):1,hideLabel:p.show?false:true,hideTooltip:!htt?false:p.show?false:true,eventless:p.show?false:true,type:p.type||"Anchor",color:p.color||"rgba(0,0,0,0)",outline:p.outline||"rgba(0,0,0,0)",shape:p.shape||"circle",label:p.label||"",zorder:p.zorder||0};order[id]=cntp++;nodes[id]=ob;sord.push(id)};var getDirection=function(s){switch(s){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var getSide=function(p){if(parseInt(p.relx)==1){return"r"}else{if(parseInt(p.relx)==-1){return"l"}else{if(parseInt(p.rely)==1){return"b"}else{if(parseInt(p.rely)==-1){return"t"}else{if(Math.abs(p.relx)>Math.abs(p.rely)){if(parseFloat(p.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(p.rely)>0){return"b"}else{if(parseFloat(p.rely)<0){return"t"}else{return"c"}}}}}}}};var getNumberOfLines=function(s,t){var findExtra=function(sd,p1,p2){switch(sd){case"r":if(parseFloat(p1.x)>=parseFloat(p2.x)){return 2}break;case"l":if(parseFloat(p1.x)<=parseFloat(p2.x)){return 2}break;case"t":case"c":if(parseFloat(p1.y)<=parseFloat(p2.y)){return 2}break;case"b":if(parseFloat(p1.y)>=parseFloat(p2.y)){return 2}break}return 0};var ss=getSide(s);var ts=getSide(t);var ls=2;if(getDirection(ss)==getDirection(ts)){ls++}if(ss!=ts){ls+=findExtra(ss,s,t);ls+=findExtra(ts,t,s)}return ls};var getPoint=function(s,a,f){if(f){switch(s){case"r":return[a[0]+20,a[1]];case"l":return[a[0]-20,a[1]];case"t":case"c":return[a[0],a[1]-20];case"b":return[a[0],a[1]+20]}}else{switch(s){case"r":case"l":return[a[0][0],a[1][1]];case"t":case"b":case"c":return[a[1][0],a[0][1]]}}};var getCoords=function(d,a){var r=[a[0]];var l=a[0];for(var i=1;i<a.length;i++){var c=a[i];switch(d){case"rl":r.push([c[0],l[1]]);break;case"tb":r.push([l[0],c[1]]);break}l=r[i];d=d=="rl"?"tb":"rl"}r.push(a[a.length-1]);return r};var to2DArray=function(edg){var ps=edg.point;var a=[];for(var i=0;i<ps.length;i++){a.push([Math.round(ps[i].x*10)/10,Math.round(ps[i].y*10)/10])}return a};var getElbowPoints=function(edg){var ps=edg.point;var n1=ps.length-1;var ls=getNumberOfLines(ps[0],ps[n1]);var s=getSide(ps[0]);var t=getSide(ps[n1]);var d=getDirection(s);var a=to2DArray(edg);if(ls==ps.length){a=getCoords(d,a)}else{if(ps.length==2){a.splice(1,0,getPoint(s,a[0],true));if(ls>3){if(ls>3){a.splice(2,0,getPoint(t,a[2],true))}if(ls>4){if(ls>4){a.splice(3,0,[(a[1][0]+a[2][0])/2,(a[1][1]+a[2][1])/2])}if(ls>5){a=to2DArray(edg);a=getCoords(d,a)}}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}else{if((a[0][0]==a[1][0]&&a[1][0]==a[2][0])||(a[0][1]==a[1][1]&&a[1][1]==a[2][1])){a.splice(1,1)}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}}else{if(ps.length>ls){a=getCoords(d,a)}else{for(var i=0;i<n1;i++){var j=i*2;if(d=="tb"){d="rl";a.splice(j+1,0,[a[j][0],a[j+1][1]])}else{d="tb";a.splice(j+1,0,[a[j+1][0],a[j][1]])}}}}}var b=[[a[0][0],a[0][1]]];for(var i=1;i<a.length;i++){if(a[i][0]==a[i-1][0]&&a[i][1]==a[i-1][1]){continue}b.push([a[i][0],a[i][1]])}return b};var getBezierPoints=function(edg,sn,tn){var ps=edg.point;var n1=ps.length-1;var s=getSide(ps[0]);var t=getSide(ps[n1]);var ds=getDirection(s);var dt=getDirection(t);var ar=to2DArray(edg);var segs=[];var p0,p1,mx,my;if(n1==1){p0=ar[0];p1=ar[1];if(sn&&tn){if(ds==dt){mx=(p0[0]+p1[0])/2;my=(p0[1]+p1[1])/2;if(ds=="tb"){if(t=="t"){if(my>tn.y-tn.height){my-=tn.height}}else{if(t=="b"){if(my<tn.y+tn.height){my+=tn.height}}}segs.push([p0[0],p0[1],p0[0],my,mx,my]);segs.push([mx,my,p1[0],my,p1[0],p1[1]])}else{if(t=="l"){if(mx>tn.x-tn.width){mx-=tn.width*0.5}}else{if(t=="r"){if(mx<tn.x+tn.width){mx+=tn.width*0.5}}}segs.push([p0[0],p0[1],mx,p0[1],mx,my]);segs.push([mx,my,mx,p1[1],p1[0],p1[1]])}}else{if(s=="t"||s=="b"){mx=t=="l"?-tn.width*0.5:t=="r"?tn.width*0.5:-tn.width*0.5;my=(p1[1]-p0[1])/3;if((t=="l"&&p0[0]>tn.x-tn.width)||(t=="r"&&p0[0]<tn.x+tn.width)){segs.push([p0[0],p0[1],p0[0],p0[1]+my,p1[0],p0[1]+my]);segs.push([p1[0],p0[1]+my,p1[0]+mx,p0[1]+my,p1[0]+mx,p0[1]+my+my]);segs.push([p1[0]+mx,p0[1]+my+my,p1[0]+mx,p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}else{mx=(p1[0]-p0[0])/3;my=t=="t"?-tn.height:t=="b"?tn.height:-tn.height;if((t=="t"&&p0[1]>tn.y-tn.height)||(t=="b"&&p0[1]<tn.y+tn.height)){segs.push([p0[0],p0[1],p0[0]+mx,p0[1],p0[0]+mx,p1[1]]);segs.push([p0[0]+mx,p1[1],p0[0]+mx,p1[1]+my,p0[0]+mx+mx,p1[1]+my]);segs.push([p0[0]+mx+mx,p1[1]+my,p1[0],p1[1]+my,p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}}}}else{p0=ar[0];if(s=="t"||s=="b"){for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}else{for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}}return segs};var getStatePosition=function(n,s){var x=parseFloat(s.relx);var y=parseFloat(s.rely);var w=n.width/2;var h=n.height/2;return[n.x+(x*w),n.y+(y*h)]};var XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&(p=="point"||p=="anchor")&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p&&(p=="point"||p=="anchor")){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p&&(p=="point"||p=="anchor")){json[p].push(j)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();XMLToJSON(n,json,p)}}}}}return json};if(pw.tagName.toLowerCase()=="pathway"){var ob=XMLToJSON(pw,false,false,true);title=ob.name;subtitle=ob.organism;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"comment":break;case"graphics":break;case"state":var ob=XMLToJSON(el);ob.nodeName=nn;state[ob.graphid]=ob;break;case"datanode":case"label":case"shape":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.centerx){ob.x=Math.round(ob.centerx*10)/10;delete (ob.centerx)}if(ob.centery){ob.y=Math.round(ob.centery*10)/10;delete (ob.centery)}if(ob.width){ob.width=parseInt(ob.width)}if(ob.height){ob.height=parseInt(ob.height)}if(ob.textlabel){ob.label=ob.textlabel;delete (ob.textlabel)}if(ob.database&&ob.id){ob.database+=" : "+ob.id}if(ob.graphid){ob.id=ob.graphid}if(ob.fontsize){ob.labelSize=parseInt(ob.fontsize)}if(ob.rotation){ob.rotate=(parseFloat(ob.rotation)*180/Math.PI)+180}if(ob.shapetype){if(ob.shapetype=="RoundedRectangle"){ob.shapetype=ob.value&&ob.value=="Double"?"roundrectd":"roundrect"}if(ob.shapetype=="Arc"){ob.shapetype="arc3"}if(ob.shapetype=="Mitochondria"){ob.shapetype="image";ob.imagePath="https://www.canvasxpress.org/assets/images/mit.png"}if(this.isValidShape(ob.shapetype.toLowerCase())){ob.shape=ob.shapetype.toLowerCase()}else{if(ob.shapetype=="None"){ob.shape="rectangle"}else{wrn+=ob.id+" has an unkown shape: "+ob.shapetype+"\n";ob.shape=ob.shapetype}}if(ob.shape=="oval"&&ob.value&&ob.value=="Double"){ob.shape="ovald"}delete (ob.shapetype)}if(!ob.shape){ob.shape="rectangle"}if(nn=="shape"){ob.labelColor=ob.color?this.validateColor(ob.color):"rgb(0,0,0)"}else{if(ob.color){ob.labelColor=this.validateColor(ob.color)}else{ob.labelColor="rgb(0,0,0)"}}if(ob.fillcolor){ob.color=this.validateColor(ob.fillcolor);delete (ob.fillcolor)}else{ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(0,0,0)"){ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(255,255,255)"){ob.color="rgba(255,255,255,0)"}if(nn=="label"){if(!ob.label||ob.label==""){ob.hideLabel=true;ob.hideTooltip=htt;ob.eventless=true}ob.outline="rgba(0,0,0,0)";ob.color="rgba(0,0,0,0)"}else{ob.outline=ob.labelColor}if(nn=="shape"&&(!ob.label||ob.label=="")){ob.hideLabel=true;ob.hideTooltip=htt;ob.outline=ob.labelColor}if(ob.groupref){if(!groupRef.hasOwnProperty(ob.groupref)){groupRef[ob.groupref]=[]}groupRef[ob.groupref].push([ob.id,ob.x,ob.y,ob.width,ob.height]);ob.parentNode=ob.groupref}order[ob.id]=cntp++;nodes[ob.id]=ob;sord.push(ob.id);break;case"interaction":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.anchor){for(var j=0;j<ob.anchor.length;j++){anchors[ob.anchor[j].graphid]=true}delete (ob.anchor)}var n1=ob.point.length-1;if(ob.point[0].graphref&&ob.point[n1].graphref){ob.id1=ob.point[0].graphref;ob.id2=ob.point[n1].graphref}var type="solid";if(ob.linestyle&&ob.linestyle=="Broken"){type="dashed"}if(ob.connectortype&&ob.connectortype=="Curved"){type+="Bezier"}ob.type=type;if(ob.point[0].arrowhead){if(arrowTypes[ob.point[0].arrowhead]){ob.startArrow=arrowTypes[ob.point[0].arrowhead]}}if(ob.point[n1].arrowhead){if(arrowTypes[ob.point[n1].arrowhead]){ob.endArrow=arrowTypes[ob.point[n1].arrowhead]}}if(ob.linethickness){ob.thickness=parseInt(ob.linethickness*10)/10;delete (ob.linethickness)}if(ob.point[0].relx&&ob.point[0].rely){ob.startX=parseFloat(ob.point[0].relx);ob.startY=parseFloat(ob.point[0].rely)}if(ob.point[n1].relx&&ob.point[n1].rely){ob.endX=parseFloat(ob.point[n1].relx);ob.endY=parseFloat(ob.point[n1].rely)}delete (ob.id);edges.push(ob);break;case"group":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.groupref&&ob.groupid){if(!groups.hasOwnProperty(ob.groupref)){groups[ob.groupref]=[]}groups[ob.groupref].push(ob.groupid);groupGref[ob.graphid]=ob.groupref}else{groupId[ob.graphid]=ob.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var s in state){var g=state[s].graphref;if(nodes[g]){var c=getStatePosition(nodes[g],state[s]);var p={id:g,x:c[0],y:c[1],width:state[s].width,height:state[s].height,label:state[s].textlabel==""?" ":state[s].textlabel,type:"State",color:state[s].textlabel==""?"rgb(255,255,255)":this.validateColor(state[s].fillcolor),outline:"rgb(0,0,0)",shape:"oval",show:true};createNodeFromPoint(p,s)}}for(var g in groupRef){createNodeFromGroup(groupRef[g],g)}for(var g in groups){if(groupRef.hasOwnProperty(g)){for(var i=0;i<groups[g].length;i++){var ob=nodes[groups[g][i]];groupRef[g].push([ob.id,ob.x,ob.y,ob.width,ob.height])}createNodeFromGroup(groupRef[g],g)}}var edgs=[];var fail=[];for(var i=0;i<edges.length;i++){var ob=edges[i];var n1=ob.point.length-1;if(!ob.point[0].graphref&&!ob.point[n1].graphref){ob.exact=true}for(var j=0;j<ob.point.length;j++){var pt=ob.point[j];if(pt.graphref){if(!nodes.hasOwnProperty(pt.graphref)){if(j==0){if(groupId[pt.graphref]){ob.id1=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactStart=anchors[pt.graphref]?true:false;ob.id1=pt.graphref}}else{if(j==ob.point.length-1){if(groupId[pt.graphref]){ob.id2=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactEnd=anchors[pt.graphref]?true:false;ob.id2=pt.graphref}}}}}else{if(j==0||j==ob.point.length-1){var id=j==0?ob.graphid+".1":ob.graphid+".2";var ni=j==0?ob.point.length-1:0;createNodeFromPoint(pt,id);if(j==0){ob.id1=id;ob.exactStart=true}else{ob.id2=id;ob.exactEnd=true}ob.hideTooltip=htt;if(ob.point[ni].graphref){if(!nodes.hasOwnProperty(ob.point[ni].graphref)&&groupId[ob.point[ni].graphref]){if(j==0){ob.id2=groupId[ob.point[ni].graphref]}else{ob.id1=groupId[ob.point[ni].graphref]}}else{if(j==0){ob.id2=ob.point[ni].graphref}else{ob.id1=ob.point[ni].graphref}}}}}}if(ob.connectortype){if(ob.connectortype=="Elbow"){ob.elbows=getElbowPoints(ob)}else{if(ob.connectortype=="Curved"){ob.elbows=getBezierPoints(ob,nodes[ob.id1],nodes[ob.id2])}else{if(ob.connectortype=="Segmented"){ob.elbows=to2DArray(ob)}}}}if(nodes[ob.id1]&&nodes[ob.id2]){edgs.push(ob)}else{fail.push(ob)}}sord.sort(function(a,b){if(nodes[a].zorder&&nodes[b].zorder){if(parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)==0){return order[a]-order[b]}else{return parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)}}else{return order[a]-order[b]}});var nods=[];for(var i=0;i<sord.length;i++){nods.push(nodes[sord[i]])}var res="Number of Nodes: "+nods.length+"\n";res+="Number of Edges: "+edgs.length+"\n";if(fail.length>0){res+="Number of Failed Edges: "+fail.length+"\n";for(var i=0;i<fail.length;i++){res+="\t"+(i+1)+". "+fail[i].graphid+"\n"}}if(wrn!="\nWarnings:\n"){res+=wrn}res=res.replace(/\n/g,"<br>");var data={data:{nodes:nods,edges:edgs},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,networkVendor:"Wikipathways"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.metabaseToCX=function(xml,target,config,events){var that=this;var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var loc={3:"microsome",13:"epr",21:"lysosome",43:"nucleus",67:"golgi",1287:"mitochondria",1312:"peroxisome"};var getMembrane=function(node){var getNode=function(){return{shape:"rectangle",color:"rgba(255,255,255,0)",outline:"rgba(0,0,0,0)",outlineWidth:0,hideLabel:true,immutable:true,eventless:true,type:node.type,zorder:node.zorder+1,width:32,height:32}};var getNodeTL=function(){var nd=getNode();nd.id=node.id+"-membraneTL";nd.pattern="membraneTL";nd.x=node.x-(node.width*0.5);nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeTR=function(){var nd=getNode();nd.id=node.id+"-membraneTR";nd.pattern="membraneTR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeBL=function(){var nd=getNode();nd.id=node.id+"-membraneBL";nd.pattern="membraneBL";nd.x=node.x-(node.width*0.5);nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeBR=function(){var nd=getNode();nd.id=node.id+"-membraneBR";nd.pattern="membraneBR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeTop=function(s){var nd=getNode();nd.id=node.id+"-membraneT";nd.pattern="membraneTop";nd.x=node.x+(s==0?0:s==1?-16:s==2?16:0);nd.y=node.y-(node.height*0.5);nd.width=node.width-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeBottom=function(s){var nd=getNodeTop(s);nd.id=node.id+"-membraneB";nd.pattern="membraneBottom";nd.y=node.y+(node.height*0.5)-16;return nd};var getNodeRight=function(s){var nd=getNode();nd.id=node.id+"-membraneR";nd.pattern="membraneRight";nd.x=node.x+(node.width*0.5)-16;nd.y=node.y+(s==0?0:s==1?-16:s==2?16:0);nd.height=node.height-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeLeft=function(s){var nd=getNodeRight(s);nd.id=node.id+"-membraneL";nd.pattern="membraneLeft";nd.x=node.x-(node.width*0.5);return nd};switch(node.type){case 1:node.shape="rectangle";return[getNodeTop(0)];case 2:node.shape="rectangle";return[getNodeRight(0)];case 3:node.shape="roundrecttr";return[getNodeTop(1),getNodeRight(2),getNodeTR()];case 4:node.shape="rectangle";return[getNodeBottom(0)];case 5:node.shape="rectangle";return[getNodeTop(0),getNodeBottom(0)];case 6:node.shape="roundrectbr";return[getNodeBottom(1),getNodeRight(1),getNodeBR()];case 7:node.shape="roundrectr";return[getNodeTop(1),getNodeBottom(1),getNodeRight(3),getNodeBR(),getNodeTR()];case 8:node.shape="rectangle";return[getNodeLeft(0)];case 9:node.shape="roundrecttl";return[getNodeTop(2),getNodeLeft(2),getNodeTL()];case 10:node.shape="rectangle";return[getNodeRight(0),getNodeLeft(0)];case 11:node.shape="roundrectt";return[getNodeTop(3),getNodeRight(2),getNodeLeft(2),getNodeTR(),getNodeTL()];case 12:node.shape="roundrectbl";return[getNodeBottom(2),getNodeLeft(1),getNodeBL()];case 13:node.shape="roundrectl";return[getNodeTop(2),getNodeBottom(2),getNodeLeft(3),getNodeTL(),getNodeBL()];case 14:node.shape="roundrectb";return[getNodeBottom(3),getNodeRight(1),getNodeLeft(1),getNodeBR(),getNodeBL()];case 15:if(node.width<64||node.height<64){node.shape="rectangle";delete node.gradient;delete node.color1;delete node.color2;delete node.color3;return[getNodeTop(0)]}node.shape="roundrect2";return[getNodeTop(3),getNodeBottom(3),getNodeRight(3),getNodeLeft(3),getNodeTR(),getNodeTL(),getNodeBR(),getNodeBL()]}return[]};var getLengthToNodeBoundary=function(x0,y0,x1,y1,node){var wi=node.width;var he=node.height;var cl=that.clip("line",[x0,y0,x1,y1],[x0-(node.width/2),y0-(node.height/2),node.width+(x0-(node.width/2)),node.height+(y0-(node.height/2))]);return that.lineLength(cl[0],cl[1],cl[2],cl[3])+2};var nodes=[];var edges=[];var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="map"){var seen={};var sord=[];var n=0;var ob=this.XMLToJSON(pw,false,false,true);nodes.push({id:"__background__",type:"background",shape:"rectangle",color:"rgb(220,231,232)",outline:"rgb(29,154,195)",outlineWidth:3,width:Number(ob.width),height:Number(ob.height),x:Number(ob.width)*0.5,y:Number(ob.height)*0.5,hideLabel:true,immutable:true,eventless:true,zorder:1});sord.push(n++);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"localizations":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="loc"){var js=this.XMLToJSON(nd);var shp=loc.hasOwnProperty(js.id)?"image":js.id=="16"?"roundrect2":"roundrect";var node={id:"loc"+(j+1),shape:shp,hideLabel:true,immutable:true,eventless:true,x:Number(js.x)+(Number(js.width)*0.5),y:Number(js.y)+(Number(js.height)*0.5),width:Number(js.width),height:Number(js.height),type:Number(js.type),zorder:js.appearance&&js.appearance[0].zorder?Number(js.appearance[0].zorder.replace("Integer: ","")):2};if(shp!="image"){node.color="rgba(0,0,0,0)";node.outline=js.id=="16"?"rgba(0,0,0,0)":"rgb(83,158,188)";node.outlineWidth=js.id!="16"?3:0;if(js.id!="16"){node.width-=6;node.height-=6}}if(js.appearance&&js.appearance[0].rotateangle){node.rotate=Number(js.appearance&&js.appearance[0].rotateangle.split(": ")[1]);if(!node.rotate){delete node.rotate}else{node.widthTMP=node.width;node.width=node.height;node.height=node.widthTMP;delete node.widthTMP}}if(js.id=="16"){node.gradient="linear";node.color1="rgb(122,194,226)";node.color2="rgb(223,237,248)";node.color3="rgb(223,237,248)"}if(shp=="image"){if(js.id=="1287"){node.imagePath=js.type=="1"?CanvasXpress.images.mitochondria2:CanvasXpress.images.mitochondria}else{node.imagePath=CanvasXpress.images[loc[js.id]]}}for(var p in js){if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(": ");switch(vk[0]){case"String":node[a]=vk[1];break;case"Integer":case"Double":node[a]=Number(vk[1]);break;case"Boolean":node[a]=vk[1]=="true"?true:false;break}}}}nodes.push(node);sord.push(n++);if(Number(js.id)==16){var mem=getMembrane(node);if(mem.length){for(var k=0;k<mem.length;k++){nodes.push(mem[k]);sord.push(n++)}}}}}break;case"nodes":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(nd);var node={};for(var p in js){if(p.toLowerCase()=="alt"){if(js[p][0].match(/\w/)){node.tooltip=js[p][0].replace(/\"/g,"'");node.tooltip=js[p][0].replace(/\[/g,"&#91");node.tooltip=js[p][0].replace(/\]/g,"&#93")}}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(":");switch(vk[0]){case"String":node[a]=vk[1].replace(/\s/g,"");break;case"Integer":case"Double":node[a]=Number(vk[1].replace(/\s/g,""));break;case"Boolean":node[a]=vk[1].replace(/\s/g,"")=="true"?true:false;break;case"Rectangle":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"Color":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);node[a][3]=Math.round(node[a][3]/255*10)/10;node[a]="rgba("+node[a].join(",")+")";break;case"Font":node[a]=vk[1].replace(/\s/g,"").split(",");break}}}node[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}node.extId=js.id;node.id=js.nodeid.toString();node.x=Number(js.x)+(Number(js.width)*0.5);node.y=Number(js.y)+(Number(js.height)*0.5);node.width=Number(js.width);node.height=Number(js.height);if(node.iconarea){node.width=node.iconarea[2];node.height=node.iconarea[3];node.x=node.iconarea[0]+(node.width*0.5);node.y=node.iconarea[1]+(node.height*0.5);delete node.iconarea}if(js.icontype&&(js.type==0||js.type==16)){if(isNaN(js.icontype)){js.icontype=1000}if(Number(js.icontype)<10){js.icontype="0"+js.icontype}if(CanvasXpress.images.hasOwnProperty(js.icontype)){node.zoomX=50/node.width;node.zoomY=50/node.height;node.shape="image";node.imagePath=CanvasXpress.images[js.icontype];node.immutable=false}else{node.shape="roundrect";node.immutable=true}}else{if(js.icontype){switch(js.type){case"-10":node.width-=5;node.height-=5;node.x+=2.5;node.y+=2.5;node.shape=node.arcwidth>40?"roundrecto":"roundrect";break;case"21":case"61":case"63":case"91":case"-11":case"-12":node.width-=4;node.height-=4;node.x+=2;node.y+=2;node.shape="roundrect";break;default:break}node.immutable=true}else{node.shape="roundrect";node.immutable=true}}if(node.name==""){node.hideLabel=true}else{node.name=node.name.toString().replace(/\[/g,"&#91").replace(/\]/g,"&#93").replace(/\"/g,"&quot")}if(node.textarea){var lines=1;if(node.font){lines=Math.floor(node.textarea[3]/(Number(node.font[2])+(Number(node.font[2])>12?1:0)));node.labelSize=node.font[2]==14?1.1:1;if(node.font[0].match(/Bold Italic/i)){node.labelStyle="Bold Italic"}else{if(node.font[0].match(/Bold/i)){node.labelStyle="Bold"}else{if(node.font[0].match(/Italic/i)){node.labelStyle="Italic"}}}}if(lines>1&&!node.name.toString().match(/\n/)){var fnt=this.nodeFontStyle+" "+Math.floor(10*node.labelSize)+"px "+this.fontName;var tst=Math.floor(node.textarea[2]/5.5);var wrp=tst>0?this.wrapText(node.name.toString(),tst):node.name.toString();var lns=wrp.split(/\n/);var max=this.measureTextMultiple(wrp,fnt);if(lns.length>lines){while(lns.length>lines&&tst<node.name.toString().length){wrp=this.wrapText(node.name.toString(),tst++);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}if(max>node.textarea[2]){wrp=wrp.replace("(","\n(");lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt);while((max>node.textarea[2]||lns.length*fnt>node.textarea[3]||lns.length<lines)&&tst>3){wrp=this.wrapText(node.name,tst--);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}node.name=wrp}else{if(lines==0){node.hideLabel=true}}node.labelX=node.textarea[0]+(node.textarea[2]*0.5);node.labelY=node.textarea[1]+(node.textarea[3]*0.5)}if(node.textalignment!=null){if(node.textalignment==0){node.labelAlign="left";node.labelX-=(node.textarea[2]*0.45)}else{if(node.textalignment==1){node.labelAlign="center"}else{if(node.textalignment==2){node.labelAlign="right";node.labelX+=(node.textarea[2]*0.45)}}}}delete node.textarea;if(node.fontcolor){node.labelColor=node.fontcolor;delete node.fontcolor}if(node.backgroundcolor){node.color=node.backgroundcolor;delete node.backgroundcolor}if(node.bordercolor){node.outline=node.bordercolor;delete node.bordercolor}if(node.rotateangle){node.rotate=node.shape=="image"?-node.rotateangle:270-node.rotateangle;if(node.shape!="image"){node.labelRotate=-node.rotateangle}delete node.rotateangle}if(node.borderwidth){node.outlineWidth=Number(node.borderwidth)-1;delete node.borderwidth}seen[node.id]=n;delete node.appearance;delete node.icontype;nodes.push(node);sord.push(n++);if(node.complex){nodes.push({id:node.id+"-complex",x:node.x,y:node.y,width:14,height:14,shape:"star",color:"rgb(255,255,255)",hideLabel:true,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-complex"]=n;sord.push(n++);delete node.complex}if(node.pathstart){var rot=0;var ptx=0;var pty=0;switch(node.sideofpathstarteditor){case 0:rot=90;pty=-(40+node.pathstartarrowmargin);break;case 1:rot=180;ptx=(40+node.pathstartarrowmargin);break;case 2:rot=270;pty=(40+node.pathstartarrowmargin);break;case 3:rot=0;ptx=-(40+node.pathstartarrowmargin);break}nodes.push({id:node.id+"-pathstart",x:node.x+ptx,y:node.y+pty,width:40,height:40,shape:"image",imagePath:CanvasXpress.images["99"],hideLabel:true,immutable:true,rotate:rot,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-pathstart"]=n;sord.push(n++);delete node.sideofpathstarteditor;delete node.pathstartarrowmargin;delete node.pathstart}if(node.organismspecificobject){nodes.push({id:node.id+"-organism",x:node.x,y:node.y,width:60,height:60,shape:"circle",color:"rgba(0,0,0,0.1)",outline:"rgb(255,255,0)",outlineWidth:3,hideLabel:true,zorder:node.zorder-1,parentNode:node.id});seen[node.id+"-organism"]=n;sord.push(n++);delete node.organismspecificobject}}}break;case"edges":for(var j=0;j<el.childNodes.length;j++){var ed=el.childNodes[j];if(ed.nodeName&&ed.nodeName.toLowerCase()=="edge"){var js=this.XMLToJSON(ed);var edge={};for(var p in js){if(p.toLowerCase()=="alt"){continue}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){if(a=="linkhighlighting"){vk=js[p][0][a].split(":");if(vk[1]=="Color"&&vk[2]){vk[2]=vk[2].split(",");vk[2].pop();edge.highlight="rgb("+vk[2].join(",")+")"}}else{vk=js[p][0][a].split(": ");switch(vk[0]){case"String":edge[a]=vk[1];break;case"Integer":case"Double":edge[a]=Number(vk[1]);break;case"Boolean":edge[a]=vk[1]=="true"?true:false;break;case"Rectangle":edge[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"PointArray":var cp=[];vk[1]=vk[1].replace(/\s/g,"").split(";");for(var k=0;k<vk[1].length-1;k++){cp.push(vk[1][k].split(",").map(Number))}edge[a]=cp;break}}}}edge[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}edge.id1=js.src;edge.id2=js.dst;if(edge.type){edge.EdgeType=edge.type;delete edge.type}if(edge.directed){edge.endArrow="arrow";delete edge.directed}edge.color="grey";edge.type=edge.enhances?"dashed":"solid";if(edge.visualization=="Round"){edge.type="quadratic";edge.angle=edge.angle}else{if(edge.visualization=="Bezier"){if(!edge.controlpoints){edge.type="solid";edge.linksourcepointindex=0;edge.linktargetpointindex=0}else{edge.type="bezier";edge.angle=edge.angle}}}if(edge.hasOwnProperty("effect")){if(edge.effect>=0){switch(edge.effect){case 0:edge.color="rgb(152,156,158)";break;case 1:edge.color="rgb(0,128,0)";break;case 2:edge.color="rgb(170,0,0)";break}}if(edge.mech!=null){var dec={};if(edge.showhexagon){var col=edge.hexagoncustomcolor||edge.color;var idx=edge.hexagonindex||0;var pos=edge.hexagoncoordinate||0.5;var cll=edge.effect==0?"black":"rgb(242,216,0)";var getDec=function(lbl){return{label:lbl,labelColor:cll,shape:"hexagon",color:col,index:idx,pos:pos}};switch(edge.mech){case -1:dec=getDec("");break;case 0:dec=getDec("?");break;case 2:dec=getDec("CM");break;case 3:dec=getDec("+P");break;case 4:dec=getDec("-P");break;case 5:dec=getDec("B");break;case 6:dec=getDec("Cn");break;case 7:dec=getDec("T");break;case 8:dec=getDec("C");break;case 9:dec=getDec("TR");break;case 10:dec=getDec("GR");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 11:dec=getDec("CR");break;case 12:dec=getDec("IE");break;case 14:dec=getDec("CS");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 15:dec=getDec("Z");break;case 16:dec=getDec("Tn");break;case 20:dec=getDec("cRT");break;case 21:dec=getDec("PE");break;case 22:dec=getDec("TE");break;case 24:dec=getDec("M");break;case 31:dec=getDec("SR");break;case 44:dec=getDec("RG");break;default:dec=getDec("");break}if(dec.label!=""){edge.decoration=[dec]}}delete edge.effect;delete edge.mech;delete edge.hexagonindex;delete edge.hexagoncoordinate;delete edge.showhexagon;delete edge.hexagoncustomcolor}}if(edge.broken){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"X",labelColor:"purple",fontSize:20,shape:"square",color:"rgba(0,0,0,0)",index:(edge.brokenindex||0),pos:(edge.brokencoordinate||0.5)});delete edge.broken;delete edge.brokenindex;delete edge.brokencoordinate}if(edge.weakens){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"-x-",labelColor:"purple",fontSize:12,shape:"square",color:"rgba(0,0,0,0)",index:(edge.weakensindex||0),pos:(edge.weakenscoordinate||0.5)});delete edge.weakens;delete edge.weakensindex;delete edge.weakenscoordinate}if(edge.disease){edge.color="purple";edge.thickness=2;delete edge.disease}if(edge.enhances){edge.color="purple";edge.thickness=2;delete edge.enhances}delete edge.appearance;delete edge.src;delete edge.dst;if(seen.hasOwnProperty(edge.id1)&&seen.hasOwnProperty(edge.id2)){var src=nodes[seen[edge.id1]];var dst=nodes[seen[edge.id2]];var sx=src.x;var sy=src.y;var sw=src.width*0.5;var sh=src.height*0.5;var ex=0;var ey=0;var dx=dst.x;var dy=dst.y;var dw=dst.width*0.5;var dh=dst.height*0.5;var ss,sd,sq,ds,dd,dq,xy,cx,cy,rd,frs,lst,n1;if(edge.visualization&&edge.visualization=="Right angle polyline"){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(edge.firstleg&&edge.firstleg=="Vertical"){frs=edge.controlpoints?edge.controlpoints[0][1]:false;sy=frs&&frs[1]>0?sy+sh:src.y>dst.y?sy-sh:frs&&frs<0?sy-sh:sy+sh;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{if(ss==1){sx=sx+sw}else{if(ss==3){sx=sx-sw}}}sq="tb"}else{frs=edge.controlpoints?edge.controlpoints[0][0]:false;sx=frs&&frs>0?sx+sw:src.x>dst.x?sx-sw:frs&&frs<0?sx-sw:sx+sw;if(ss==1||ss==3){sy=(sy-sh)+(src.height*sd)}else{if(ss==0){sy=sy-sh}else{if(ss==2){sy=sy+sh}}}sq="lr"}ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(!edge.controlpoints){if(edge.firstleg&&edge.firstleg=="Vertical"){dx=src.x>dst.x?dx+dw:dx-dw;if(ds==1||ds==3){dy=(dy-dh)+(dst.height*dd)}}else{dy=src.y>dst.y?dy+dh:dy-dh;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}}}else{dq=edge.controlpoints.length%2?sq:sq=="tb"?"lr":"tb";n1=edge.controlpoints.length-1;lst=edge.controlpoints[n1];if(edge.linktargetpointindex){if(ds==1||ds==3){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}dy=(dy-dh)+(dst.height*dd)}else{if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd);if(src.y+lst[1]>dst.y){dy+=dh}else{dy-=dh}}}}else{if(edge.controlpoints.length%2){if(sq==dq&&sq=="lr"){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}}}else{dx=src.x+lst[0]>dst.x?dx+dw:dx-dw}if(edge.controlpoints.length%2){if(sq!=dq||sq!="lr"){dy=src.y+lst[1]>dst.y?dy+dh:dy-dh}}else{if(src.y+lst[1]>dst.y){dy=dy+dh}}}}if(edge.controlpoints){edge.elbows=[[sx,sy]];cx=sx;cy=sy;if(edge.firstleg&&edge.firstleg=="Vertical"){for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cx=sx+edge.controlpoints[k][0]}else{cy=sy+edge.controlpoints[k][1]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([dx,cy])}else{edge.elbows.push([cx,dy])}}else{for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cy=sy+edge.controlpoints[k][1]}else{cx=sx+edge.controlpoints[k][0]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([cx,dy])}else{edge.elbows.push([dx,cy])}}edge.elbows.push([dx,dy])}else{if(edge.firstleg&&edge.firstleg=="Vertical"){edge.elbows=[[sx,sy],[sx,dy],[dx,dy]]}else{edge.elbows=[[sx,sy],[dx,sy],[dx,dy]]}}}else{if(edge.controlpoints&&edge.linksourcepointindex!=null&&edge.linktargetpointindex!=null&&edge.id1!=edge.id2){if(edge.linksourcepointindex||edge.controlpoints){frs=edge.controlpoints?edge.controlpoints[0]:[0,0];if(edge.linksourcepointindex==0){ds=getLengthToNodeBoundary(sx,sy,sx+frs[0],sy+frs[1],src);xy=this.getCoordinateAtDistance(sx,sy,sx+frs[0],sy+frs[1],ds);rd=this.getRadians(sx,sy,sx+frs[0],sy+frs[1]);sx=xy[0];sy=xy[1];ex=(-ds*-Math.cos(rd));ey=ds*Math.sin(rd)}else{ss=Math.floor((edge.linksourcepointindex-1)/src.linkpointcount);sd=(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1);switch(ss){case 0:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy-sh;break;case 1:ex=0;ey=(src.height*sd);sx=sx+sw;sy=ey+sy-sh;break;case 2:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy+sh;break;case 3:ex=0;ey=(src.height*sd);sx=sx-sw;sy=ey+sy-sh;break}}}if(edge.linktargetpointindex||edge.controlpoints){lst=edge.controlpoints?this.cloneObject(edge.controlpoints[edge.controlpoints.length-1]):[0,0];if(edge.linktargetpointindex==0){if(edge.controlpoints){lst[0]=dx-(sx+lst[0]);lst[1]=dy-(sy+lst[1])}ds=getLengthToNodeBoundary(dx,dy,dx+lst[0],dy+lst[1],dst);xy=this.getCoordinateAtDistance(dx,dy,dx+lst[0],dy+lst[1],-ds);rd=this.getRadians(dx,dy,dx+lst[0],dy+lst[1]);dx=xy[0];dy=xy[1]}else{ds=Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount);dd=(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1);switch(ds){case 0:dx=(dst.width*dd)+dx-dw;dy=dy-dh;break;case 1:dx=dx+dw;dy=(dst.height*dd)+dy-dh;break;case 2:dx=(dst.width*dd)+dx-dw;dy=dy+dh;break;case 3:dx=dx-dw;dy=(dst.height*dd)+dy-dh;break}}}edge.elbows=[];for(var k=0;k<edge.controlpoints.length;k++){edge.elbows.push([sx+edge.controlpoints[k][0]+5,sy+edge.controlpoints[k][1]])}edge.elbows.unshift([sx,sy]);edge.elbows.push([dx,dy])}else{if(edge.id1==edge.id2){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;if(ss==ds){edge.self={dir:edge.angle>0,pos:(ss==0?"top":ss==1?"right":ss=2?"bottom":"left"),size:20,end:"arrow"}}else{if(ss>ds||(ss==0&&ds==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topLeft":ss=1?"topRight":ss==2?"bottomRight":"bottomLeft"),size:20,end:"arrow"}}else{if(ds>ss||(ds==0&&ss==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topRight":ss==1?"bottomRight":ss==2?"bottomLeft":"topLeft"),size:20,end:"arrow"}}}}}else{if(edge.linksourcepointindex){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{sy=(sy-sh)+(src.height*sd)}}if(edge.linktargetpointindex){ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}else{dy=(dy-dh)+(dst.height*dd)}}if(edge.linksourcepointindex||edge.linktargetpointindex){if(edge.linksourcepointindex){switch(ss){case 0:sy-=sh;break;case 1:sx+=sw;break;case 2:sy+=sh;break;case 3:sx-=sw;break}if(!edge.linktargetpointindex){ds=getLengthToNodeBoundary(dx,dy,sx,sy,dst);xy=this.getCoordinateAtDistance(dx,dy,sx,sy,ds);dx=xy[0];dy=xy[1]}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}}}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}ds=getLengthToNodeBoundary(sx,sy,dx,dy,src);xy=this.getCoordinateAtDistance(sx,sy,dx,dy,ds);sx=xy[0];sy=xy[1]}edge.elbows=[[sx,sy],[dx,dy]]}}}}delete edge.linksourcepointindex;delete edge.linktargetpointindex;delete edge.controlpoints;delete edge.visualization;delete edge.firstleg;edges.push(edge)}}}break}}}sord.sort(function(a,b){if(nodes[a].zorder-nodes[b].zorder==0){return a-b}else{return nodes[a].zorder-nodes[b].zorder}});var tmp=[];for(var i=0;i<sord.length;i++){tmp.push(nodes[sord[i]])}nodes=tmp}else{alert("Ooops! Not a Metabase xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Metabase"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.parseGML=function(gml){var forIn=function(object,callback){Object.keys(object).forEach(function(key){callback(key,object[key])})};var json=("{\n"+gml+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var graph={};var nodes=[];var edges=[];var i=0;json=json.replace(/^(\s*)"node"/gm,function(all,indent){return(indent+'"node['+(i++)+']"')});i=0;json=json.replace(/^(\s*)"edge"/gm,function(all,indent){return(indent+'"edge['+(i++)+']"')});try{json=this.parseJSON(json)}catch(err){throw new SyntaxError("bad format")}if(!this.isObject(json.graph)){throw new SyntaxError("no graph tag")}forIn(json.graph,function(key,value){var matches=key.match(/^(\w+)\[(\d+)\]$/);var name;var i;if(matches){name=matches[1];i=parseInt(matches[2],10);if(name==="node"){nodes[i]=value}else{if(name==="edge"){edges[i]=value;edges[i].id1=edges[i].source;edges[i].id2=edges[i].target;delete (edges[i].source);delete (edges[i].target)}else{graph[key]=value}}}else{graph[key]=value}});graph.nodes=nodes;graph.edges=edges;return{data:graph,config:{graphType:"Network"}}};this.arrayToCanvasXpress=function(arr){var unique=function(a){return a.filter(function(x,i){return a.indexOf(x)===i})};var data={y:{vars:[],smps:[],data:[]}};var g="Scatter2D";var cols=arr[0].filter(Number);if(cols.length==0){cols=arr.shift()}else{cols=[];for(var i=0;i<arr[0].length;i++){cols.push("C"+(i+1))}}var rows=[];for(var i=0;i<arr.length;i++){rows.push(arr[i][0].toString())}var urow=unique(rows);if(urow.length==rows.length){for(var i=0;i<arr.length;i++){arr[i].shift(arr[i][0])}}else{rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}if(cols.length>arr[0].length){cols.shift();if(!cols.length==arr[0].length){return false}}if(arr[0].length!=arr[arr.length-1].length){arr.pop();rows.pop();if(arr[0].length!=arr[arr.length-1].length){return false}}var types=[];for(var i=0;i<cols.length;i++){types[i]=false;for(var j=0;j<rows.length;j++){if(isNaN(arr[j][i])){types[i]=true;break}}if(!types[i]){for(var j=0;j<rows.length;j++){arr[j][i]=arr[j][i]!=null?Number(arr[j][i]):null}}else{data.z={}}}for(var i=0;i<rows.length;i++){data.y.data[i]=[];data.y.vars.push(rows[i])}for(var i=0;i<cols.length;i++){if(types[i]){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}}if(data.y.smps.length==0){var n=data.y.data.length;data.y.data=[[]];for(var i=0;i<n;i++){data.y.data[0].push(1)}data.y.smps=data.y.vars;data.y.vars=["counts"];data.x=data.z;delete (data.z);g="Bar"}else{if(data.y.smps.length==1){var trp=function(mat){return mat[0].map(function(_,c){return mat.map(function(r){return r[c]})})};data.y.data=trp(data.y.data);data.y.vars=data.y.smps;data.y.smps=rows;data.x=data.z;delete (data.z);g="Bar"}}return{data:data,config:{graphType:g}}};this.getRDatasets=function(){var setRDataSets=function(t){return function(r){t.Rdatasets=t.parseJSON(r)}}(this);var url=this.RdatasetsURL+"datasets.json";this.ajaxRequest(url,false,setRDataSets)};this.getRLibraryDataSets=function(s){this.getDataSetListFromURL(this.RdatasetsURL+"json/"+s+"/datasets.json")};this.appendNetworkDataFromURL=function(){var that=this;var url=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var appendDelimitedData=function(r){var tc=0;var tt=0;if(r.match(/,/g)){tc=r.match(/,/g).length}if(r.match(/\t/g)){tt=r.match(/\t/g).length}var dl=url.match(/\.csv$/)&&tc>tt?",":"\t";var data=that.delimitedToArray(r,dl,false,true);if(data&&!that.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}that.flashInfoSpan(100,150,data.rows+" "+data.type+" records added to network data\n"+fail,5000);var cn=that.meta.config.user;var at=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var i=0;i<at.length;i++){var a=at[i];if(cn.hasOwnProperty(a)){that[a]=cn[a]}}if(data.type=="node"){that.appendNodeData(data.data)}else{that.appendEdgeData(data.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw();that.hideMask()}}};var appendJSONData=function(r){if(r.type=="node"){that.appendNodeData(r.data)}else{that.appendEdgeData(r.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw();that.hideMask()}};var appendDataURL=function(t){return function(r){if(url.match(/\.txt$/)||url.match(/\.csv$/)||url.match(/\.tsv$/)||url.match(/\.tab$/)){appendDelimitedData(r)}else{t.hideMask();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(url){if(typeof(url)=="string"){var obj=this.isValidString(url);switch(obj.type){case"URL":this.ajaxRequest(url,false,appendDataURL);break;case"XML":alert("XML not supported!");break;case"JSON":appendJSONData(obj.data);case"DELIM":appendDelimitedData(url);break}}else{appendJSONData(url)}}};this.getDataFromURLOrString=function(target,config,events,info,callback){if(this.dataURL){var that=this;var isJSON=function(s){try{return that.isObject(that.parseJSON(s))}catch(e){return false}};var format=this.dataURL.match(/\.png$/)?"arraybuffer":false;var setData=function(t){return function(r){var data;t.remoteService=t.dataURL;t.remoteServiceType="file";if(isJSON(r)){data=t.parseJSON(r);if(Array.isArray(data)){return t.setDataSetsFromURL(r)}}else{if(t.dataURL.match(/\.png$/)){data=t.parseDataFromPNG(r)}else{if(t.dataURL.match(/\.svg$/)){data=t.SVGtoCX(r)}else{if(t.dataURL.match(/\.txt$/)||t.dataURL.match(/\.csv$/)||t.dataURL.match(/\.tsv$/)||t.dataURL.match(/\.tab$/)){data=t.delimitedToArray(r,false,true)}else{if(t.dataURL.match(/\ml$/)){var xml=t.parseXML(r);var ts1=xml.childNodes[0];var ts2=xml.childNodes[2];var trg=target?target:t.newId("cX-data-url-");if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){return t.metabaseToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){return t.cytoscapeToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){return t.wikipathwayToCX(xml,trg)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){return t.keggToCX(xml,trg)}}}}}}}}}data.records=0;data.renderTo=target?target:data.renderTo?data.renderTo:t.newId("cX-data-url-");data.config=config?config:data.config?data.config:{graphType:"Scatter2D"};if(data.config.graphType=="Network"){data.config.appendNetworkData=t.appendNetworkData}data.events=events?events:data.events?data.events:false;data.info=info?info:data.info?data.info:false;if(!data.afterRender){data.afterRender=[]}if(data.config.graphType=="Network"){data.afterRender.push(["appendNetworkDataFromURL",[]])}var rurl=t.dataURL;var cnfg=t.cloneObject(t.meta.config.user);t.updateRemoteData(data,function(that){that.meta.config.remote={data:rurl,config:cnfg};if(callback){callback()}})}}(this);this.ajaxRequest(this.dataURL,false,setData,format)}else{if(this.dataString){this.loadXML(this.dataString,target,config,events)}}};this.getDataSetListFromURL=function(u){this.remoteService=u;this.ajaxRequest(u,false,this.setDataSetsFromURL)};this.setDataSetsFromURL=function(t){return function(r){var setDataSetsFromURLRemote=function(t){return function(r){var obj=n.parseJSON(r);n.updateRemoteData({data:obj,ids:n.remoteIds,records:n.remoteIds.length})}}(n);var getParentId=function(){var par=t.$("container-"+t.target).parentNode;while(par.id.match("canvasXpressRemoteWindow")){par=par.parentNode}if(!par.id){par.id=t.newId("-cX-data-sets-url-container-")}return par.id};var obj=t.parseJSON(r);var url=obj[0][1];var ids=[];for(var i=0;i<obj.length;i++){ids.push(obj[i][0])}var pid=getParentId();var par=t.$("container-"+t.target).parentNode;var cid=t.newId("cX-data-sets-");var cnv=t.$cX("canvas",{id:cid,width:t.originalWidth,height:t.originalHeight});t.castCanvasAttributes(cnv);par.appendChild(cnv);var n=new CanvasXpress(cid,false,{remoteService:t.remoteService});t.remoteIds=ids;t.destroy(t.target);n.remoteData=obj;n.remoteParentId=pid;n.remoteIds=ids;n.remoteServiceType="file";n.ajaxRequest(url,false,setDataSetsFromURLRemote)}}(this);this.logConsole=function(o){if(this.verbose){console.log(this.target,this.prettyJSON(o))}};this.initVocabulary=function(){if(!CanvasXpress.vocabulary){CanvasXpress.vocabulary={}}if(!CanvasXpress.vocabulary.n){CanvasXpress.vocabulary.n=0;CanvasXpress.vocabulary.byId=[];CanvasXpress.vocabulary.byStr={}}};this.getLeafletCanvas=function(){if(this.isMap){var c=this.meta.leaflet.ctx;var w=this.width;var h=this.height;var cw=c.canvas.width;var ch=c.canvas.height;var dw=parseInt((cw-w)/2);var dh=parseInt((ch-h)/2);var img=c.getImageData(dw,dh,w,h);var cnv=this.$cX("canvas");cnv.width=w;cnv.height=h;var ctx=this.get2DCanvasContext(cnv);ctx.putImageData(img,0,0);return cnv}};this.initStack=function(data,config,events,info,afterRender){if(!CanvasXpress.stack){CanvasXpress.stack={}}if(window.navigator.onLine&&!CanvasXpress.geo){}var cnv=this.$(this.target);if(cnv){if(this.graphType=="Map"&&config.leafletInit){config.leafletInitString=config.leafletInit.toString()}CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:data?this.parseJSON(this.stringifyJSON(data)):false,config:config?this.parseJSON(this.stringifyJSON(config)):false,events:events?this.parseJSON(this.stringifyJSON(events)):false,info:info?info.toString():false,afterRenderInit:afterRender?afterRender:false,afterRender:[["setDimensions",[cnv.originalWidth,cnv.originalHeight,true]]],state:[],stateIndex:0}}};this.getStack=function(){return CanvasXpress.stack[this.target].afterRender};this.diffConfigState=function(idx1,idx2){var s={};var d={idx1:{},idx2:{}};var c1=CanvasXpress.stack[this.target].state[idx1];var c2=CanvasXpress.stack[this.target].state[idx2];for(var c in c1){if(c2.hasOwnProperty(c)){if(!this.isSameObject(c1[c],c2[c])){d.idx1[c]=c1[c]}else{s[c]=true}}else{d.idx1[c]=c1[c]}}for(var c in c2){if(!s.hasOwnProperty(c)){if(c1.hasOwnProperty(c)){if(!this.isSameObject(c1[c],c2[c])){d.idx2[c]=c2[c]}}else{d.idx2[c]=c2[c]}}}return d};this.getConfigState=function(){var skip={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functionCaller:true,functionCallerDraw:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankey:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,touchEvent:true,touches:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"){skip.data=true}var config={};for(var c in this){if(!this.isFunction(this[c])&&!skip.hasOwnProperty(c)){config[c]=this.isObject(this[c])?this.cloneObject(this[c],true):this[c]}}return config};this.setConfigState=function(idx){if(!idx){idx=0}var config=CanvasXpress.stack[this.target].state[idx];for(var c in config){this[c]=config[c]}var tmp={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.draw();this.skipStack=false;for(var c in tmp){this[c]=tmp[c]}};this.stack=function(){if(!this.skipStack){var d=arguments.callee.caller.caller;var f=d.fname;var s=this.getConfigState();var t=new Date().getTime();if(d&&f){var a=this.cleanEventInArguments(Array.from(d.arguments));var n=CanvasXpress.stack[this.target].afterRender.length;switch(f){case"setDimensions":if(a&&a[0]==this.width&&a[1]==this.height){return}if(a&&a[4]){f="clickGraphMaxMin";a=[false,this.maximized]}CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"sortSamples":case"sortSamplesByCategory":case"sortSamplesByVariable":case"sortVariables":case"sortVariablesByCategory":case"sortVariablesBySample":CanvasXpress.stack[this.target].afterRender.push([f,a,{sortDir:this.sortDir},t]);break;case"desegregate":CanvasXpress.stack[this.target].afterRender.push([f,a,{segregateSamplesBy:this.segregateSamplesBy,segregateVariablesBy:this.segregateVariablesBy},t]);break;case"broadcastDraw":case"segregateSamplesVariables":d=d.caller;if(d){f=d.fname;a=this.cleanEventInArguments(Array.from(d.arguments));CanvasXpress.stack[this.target].afterRender.push([f,a,{},t])}break;case"updateDataFilter":CanvasXpress.stack[this.target].afterRender.push([f,[true],{toDoFilter:this.toDoFilter},t]);break;case"endCanvasResizer":CanvasXpress.stack[this.target].afterRender.push(["setDimensions",Array.from(arguments.callee.caller.arguments),{},t]);break;case"drawIndicesAfterWheelEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawIndicesAfterWheelEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},t]);break;case"drawRangesAfterWheelEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawRangesAfterWheelEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"drawIndicesAfterPannEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawIndicesAfterPannEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},t]);break;case"updateDragScatter":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragScatter"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveLegendCurX:this.moveLegendCurX,moveLegendCurY:this.moveLegendCurY},t]);break;case"updateDragGenome":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragGenome"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveGenome:this.moveGenome,setMinX:this.setMinX,setMaxX:this.setMaxX,xMouseDown:this.xMouseDown},t]);break;case"updateDragNetwork":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragNetwork"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveEdge:this.moveEdge,moveEdgeIndex:this.moveEdgeIndex,moveEdgeElbow:this.moveEdgeElbow,moveNode:this.moveNode,moveNodeIndex:this.moveNodeIndex,moveNodeLab:this.moveNodeLab,moveNodeDec:this.moveNodeDec,moveNodeW:this.moveNodeW,moveNodeH:this.moveNodeH,moveNodeX:this.moveNodeX,moveNodeY:this.moveNodeY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},t]);break;case"handleDragEventOneDimension":CanvasXpress.stack[this.target].afterRender.push([f,a,{moveDendrogram:this.moveDendrogram,moveVarOverlay:this.moveVarOverlay,varOverlayInfo:this.varOverlayInfo,moveVar:this.moveVar,varInfo:this.varInfo,moveSmpOverlay:this.moveSmpOverlay,smpOverlayInfo:this.smpOverlayInfo,moveSmp:this.moveSmp,smpInfo:this.smpInfo},t]);break;case"updateDragCircular":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragCircular"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{circularRotate:this.circularRotate,moveCircular:this.moveCircular,panningX:this.panningX,panningY:this.panningY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},t]);break;case"updateDragMap":CanvasXpress.stack[this.target].afterRender.push([f,a,{moveMap:this.moveMap,panningX:this.panningX,panningY:this.panningY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},t]);break;case"handleWheelEvent":CanvasXpress.stack[this.target].afterRender.push([f,a,{panningX:this.panningX,panningY:this.panningY},t]);break;case"resortSankey":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="resortSankey"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveSankey:this.moveSankey,moveSankeyY:this.moveSankeyY,moveSankeyMin:this.moveSankeyMin,moveSankeyOrder:this.moveSankeyOrder},t]);break;default:CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break}if(CanvasXpress.stack[this.target].stateIndex<CanvasXpress.stack[this.target].state.length-1){CanvasXpress.stack[this.target].state.splice(CanvasXpress.stack[this.target].stateIndex,CanvasXpress.stack[this.target].state.length-1)}this.meta.stack.push([f,this.meta.time.start,this.meta.time.elapsed]);CanvasXpress.stack[this.target].state.push(s);CanvasXpress.stack[this.target].stateIndex=CanvasXpress.stack[this.target].state.length-1}}};this.reproduce=function(t){return function(e,p,d){t.skipStack=true;t.reproducing=true;t.resetMenus();t.resetLinks();if(d){t.setMotionObject();t.clickMotion(e,true,true)}else{t.addMotionDiv(e);if((e&&e.shiftKey)||p){t.clickMotion(e,true)}}}}(this);this.setFunctionNames("initInterface")};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.saveAs=a;this.setFunctionNames("initSave")};CanvasXpress.prototype.initConfig=function(a){this.setConfigDefaults=function(){var b=CanvasXpress.config;this.graphType="Bar";b.push("graphType");this.graphOrientation="horizontal";b.push("graphOrientation");this.transparency=null;b.push("transparency");this.transparencyHidden=0.1;b.push("transparencyHidden");this.canvasBox=false;b.push("canvasBox");this.canvasBoxColor="rgb(204,204,204)";b.push("canvasBoxColor");this.plotBox=false;b.push("plotBox");this.plotBoxColor="rgb(204,204,204)";b.push("plotBoxColor");this.invertGraph=false;b.push("invertGraph");this.loadImagesTimeOut=100;b.push("loadImagesTimeOut");this.view="canvas";b.push("view");this.isR=false;b.push("isR");this.isReproducibleResearch=true;b.push("isReproducibleResearch");this.reproduceTime=50;b.push("reproduceTime");this.printType="download";b.push("printType");this.printMagnification=1;b.push("printMagnification");this.printThumbnail=false;b.push("printThumbnail");this.editable=true;b.push("editable");this.higlightGreyOut=false;b.push("higlightGreyOut");this.higlightGreyOutTransparency=0.67;b.push("higlightGreyOutTransparency");this.theme="none";b.push("theme");this.useVocabulary=false;b.push("useVocabulary");this.useRawLines=false;b.push("useRawLines");this.fullTextMeasureCheck=500;b.push("fullTextMeasureCheck");this.showFunctionNamesAfterRender=false;b.push("showFunctionNamesAfterRender");this.saveFilename=false;b.push("saveFilename");this.skipRender=false;b.push("skipRender");this.tags=[];b.push("tags");this.createVersion=false;b.push("createVersion");this.createFactory=false;b.push("createFactory");this.createGeo=false;b.push("createGeo");this.functions=[];this.gradient=false;b.push("gradient");this.gradientType="radial";b.push("gradientType");this.gradientOrientation="vertical";b.push("gradientOrientation");this.gradientRatio=1.3;b.push("gradientRatio");this.adjustAspectRatio=true;b.push("adjustAspectRatio");this.percentAspectRatioPlotArea=0.5;b.push("percentAspectRatioPlotArea");this.variableSpaceFactor=2;b.push("variableSpaceFactor");this.sampleSpaceFactor=1;b.push("sampleSpaceFactor");this.widthFactor=1;b.push("widthFactor");this.dataPointSize=28;b.push("dataPointSize");this.adjustAspectRatioMax=3;this.adjustAspectRatioYTries=0;this.adjustAspectRatioXTries=0;this.foreground="rgb(0,0,0)";b.push("foreground");this.background="rgb(255,255,255)";b.push("background");this.backgroundWindow="rgb(244,244,244)";b.push("backgroundWindow");this.backgroundType="solid";b.push("backgroundType");this.backgroundImage=false;b.push("backgroundImage");this.backgroundGradient1Color="rgb(0,0,200)";b.push("backgroundGradient1Color");this.backgroundGradient2Color="rgb(0,0,36)";b.push("backgroundGradient2Color");this.margin=5;b.push("margin");this.marginLeft=5;b.push("marginLeft");this.marginTop=5;b.push("marginTop");this.marginBottom=5;b.push("marginBottom");this.marginRight=5;b.push("marginRight");this.showShadow=false;b.push("showShadow");this.showTextShadow=false;b.push("showTextShadow");this.shadowOffsetX=1;b.push("shadowOffsetX");this.shadowOffsetY=1;b.push("shadowOffsetY");this.shadowBlur=2;b.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";b.push("shadowColor");this.topoJSON=false;b.push("topoJSON");this.leafletLayer=false;b.push("leafletLayer");this.leafletInit=false;b.push("leafletInit");this.leafletInitString=false;b.push("leafletInitString");this.leafletId=false;b.push("leafletId");this.leafletConfig=false;b.push("leafletConfig");this.isMap=false;this.fontName="Arial";b.push("fontName");this.fontStyle="";b.push("fontStyle");this.fontSize=12;b.push("fontSize");this.fontScaleFontFactor=1;b.push("fontScaleFontFactor");this.align="center";b.push("align");this.baseline="middle";b.push("baseline");this.maxTextSize=40;b.push("maxTextSize");this.minTextSize=4;b.push("minTextSize");this.autoScaleFont=true;b.push("autoScaleFont");this.scaleTextConstantMult=30;this.scaleTextConstantAdd=2;this.title=false;b.push("title");this.titleAlign="center";b.push("titleAlign");this.titleFontSize=16;b.push("titleFontSize");this.titleColor="rgb(0,0,0)";b.push("titleColor");this.titleScaleFontFactor=1;b.push("titleScaleFontFactor");this.titleFontStyle="";b.push("titleFontStyle");this.subtitle=false;b.push("subtitle");this.subtitleAlign="center";b.push("subtitleAlign");this.subtitleFontSize=14;b.push("subtitleFontSize");this.subtitleColor="rgb(0,0,0)";b.push("subtitleColor");this.subtitleScaleFontFactor=1;b.push("subtitleScaleFontFactor");this.subtitleFontStyle="";b.push("subtitleFontStyle");this.citation=false;b.push("citation");this.citationColor="rgb(0,0,0)";b.push("citationColor");this.citationFontStyle="";b.push("citationFontStyle");this.citationFontSize=7;b.push("citationFontSize");this.citationScaleFontFactor=1;b.push("citationScaleFontFactor");this.dashLength=8;b.push("dashLength");this.dotLength=1;b.push("dotLength");this.arrowPointSize=9;b.push("arrowPointSize");this.arrowQuadraticFactor=2.3;b.push("arrowQuadraticFactor");this.capType="butt";b.push("capType");this.joinType="mitter";b.push("joinType");this.lineWidthEvent=2;this.outlineWidth=1;b.push("outlineWidth");this.lineThickness=1;b.push("lineThickness");this.adjustBezier=false;b.push("adjustBezier");this.lines=["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC","blank","dashed","dotted","dotdash","longdash","twodash"];this.arrows=["arrow","square","round"];this.colorScheme="User";b.push("colorScheme");this.colors=["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"];b.push("colors");this.colorHSV=[0,0,1];this.colorRGB=[1,1,1];this.colorSpectrum=["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"];b.push("colorSpectrum");this.colorSpectrumBreaks=[];b.push("colorSpectrumBreaks");this.colorSpectrumZeroValue=null;b.push("colorSpectrumZeroValue");this.colorSpectrumNumber=100;b.push("colorSpectrumNumber");this.colorSpectrumTarget=10;b.push("colorSpectrumTarget");this.oddColor=this.background;b.push("oddColor");this.evenColor="rgb(245,245,245)";b.push("evenColor");this.blindnessType=false;b.push("blindnessType");this.roundedPolygonRadius=5;b.push("roundedPolygonRadius");this.useRoundRectangles=false;b.push("useRoundRectangles");this.useOpenShapes=false;b.push("useOpenShapes");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"];b.push("shapes");this.sizes=[16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46];b.push("sizes");this.images=[];b.push("images");this.patterns=["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"];b.push("patterns");this.maxSmpStringLen=30;b.push("maxSmpStringLen");this.smpLabelDescription=false;b.push("smpLabelDescription");this.smpTitle=false;b.push("smpTitle");this.smpTitleFontStyle="";b.push("smpTitleFontStyle");this.smpTitleFontSize=12;b.push("smpTitleFontSize");this.smpTitleFontColor=this.foreground;b.push("smpTitleFontColor");this.smpTitleScaleFontFactor=1;b.push("smpTitleScaleFontFactor");this.smpLabelFontStyle="";b.push("smpLabelFontStyle");this.smpLabelFontSize=12;b.push("smpLabelFontSize");this.smpLabelFontColor=this.foreground;b.push("smpLabelFontColor");this.smpLabelScaleFontFactor=1;b.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;b.push("smpLabelRotate");this.smpLabelInterval=1;b.push("smpLabelInterval");this.showSampleNames=true;b.push("showSampleNames");this.highlightSmp=[];b.push("highlightSmp");this.smpHighlightColor="rgb(255,0,0)";b.push("smpHighlightColor");this.maxVarStringLen=30;b.push("maxVarStringLen");this.varLabelDescription=false;b.push("varLabelDescription");this.varTitle=false;b.push("varTitle");this.varTitleFontStyle="";b.push("varTitleFontStyle");this.varTitleFontSize=12;b.push("varTitleFontSize");this.varTitleFontColor=this.foreground;b.push("varTitleFontColor");this.varTitleScaleFontFactor=1;b.push("varTitleScaleFontFactor");this.varLabelFontStyle="";b.push("varLabelFontStyle");this.varLabelFontSize=12;b.push("varLabelFontSize");this.varLabelFontColor=this.foreground;b.push("varLabelFontColor");this.varLabelScaleFontFactor=1;b.push("varLabelScaleFontFactor");this.varLabelRotate=0;b.push("varLabelRotate");this.varLabelInterval=1;b.push("varLabelInterval");this.showVariableNames=true;b.push("showVariableNames");this.highlightVar=[];b.push("highlightVar");this.varHighlightColor="rgb(255,0,0)";b.push("varHighlightColor");this.binConfigurations={};b.push("binConfigurations");this.maxOverlayStringLen=30;b.push("maxOverlayStringLen");this.overlaysThickness=18;b.push("overlaysThickness");this.smpOverlays=[];b.push("smpOverlays");this.smpOverlayProperties={};b.push("smpOverlayProperties");this.smpOverlaysLegendColumns=1;b.push("smpOverlaysLegendColumns");this.showSmpOverlaysLegend=false;b.push("showSmpOverlaysLegend");this.varOverlays=[];b.push("varOverlays");this.varOverlayProperties={};b.push("varOverlayProperties");this.varOverlaysLegendColumns=1;b.push("varOverlaysLegendColumns");this.showVarOverlaysLegend=false;b.push("showVarOverlaysLegend");this.overlaysLegendPosition="topRight";b.push("overlaysLegendPosition");this.showOverlays=true;b.push("showOverlays");this.showLevelOverlays=true;b.push("showLevelOverlays");this.overlayFontStyle="";b.push("overlayFontStyle");this.overlayFontSize=12;b.push("overlayFontSize");this.overlayFontColor=this.foreground;b.push("overlayFontColor");this.overlayScaleFontFactor=1;b.push("overlayScaleFontFactor");this.showLegend=true;b.push("showLegend");this.showLegendTitle=true;b.push("showLegendTitle");this.legendColumns=1;b.push("legendColumns");this.legendPosition="right";b.push("legendPosition");this.legendPositionAuto=false;b.push("legendPositionAuto");this.legendInside=false;b.push("legendInside");this.legendColor=this.foreground;b.push("legendColor");this.legendBox=false;b.push("legendBox");this.legendBoxColor="rgb(204,204,204)";b.push("legendBoxColor");this.legendBackgroundColor="rgba(255,255,255,0)";b.push("legendBackgroundColor");this.legendFontStyle="";b.push("legendFontStyle");this.legendFontSize=12;b.push("legendFontSize");this.legendScaleFontFactor=1;b.push("legendScaleFontFactor");this.legendOrder=false;b.push("legendOrder");this.legend=[];b.push("legend");this.showDecorations=true;b.push("showDecorations");this.showDecorationsLegend=true;b.push("showDecorationsLegend");this.decorationsPosition="bottom";b.push("decorationsPosition");this.decorationsColor=this.foreground;b.push("decorationsColor");this.decorationsBox=false;b.push("decorationsBox");this.decorationsBoxColor="rgb(204,204,204)";b.push("decorationsBoxColor");this.decorationsBackgroundColor="rgba(255,255,255,0)";b.push("decorationsBackgroundColor");this.decorationFontStyle="";b.push("decorationFontStyle");this.decorationFontSize=12;b.push("decorationFontSize");this.decorationScaleFontFactor=1;b.push("decorationScaleFontFactor");this.decorationsWidth=20;b.push("decorationsWidth");this.decorationsHeight=40;b.push("decorationsHeight");this.decorationsType="bar";b.push("decorationsType");this.decorations=false;b.push("decorations");this.decorationsColors=[];b.push("decorationsColors");this.decorationsProperties={};b.push("decorationsProperties");this.isGroupedData=false;this.isBoxplotCalc=false;this.groupingFactors=[];b.push("groupingFactors");this.segregateSamplesBy=[];b.push("segregateSamplesBy");this.segregateVariablesBy=[];b.push("segregateVariablesBy");this.summaryType=false;b.push("summaryType");this.isTransformedData=false;this.transformBase=10;this.transformedData=false;b.push("transformedData");this.transformType=false;b.push("transformType");this.transformAxis="samples";b.push("transformAxis");this.ratioReference=0;b.push("ratioReference");this.ratioSampleReference=false;b.push("ratioSampleReference");this.ratioGroupReference=false;b.push("ratioGroupReference");this.ratioLevelReference="";b.push("ratioLevelReference");this.transposeData=false;b.push("transposeData");this.asSampleFactors=[];b.push("asSampleFactors");this.asVariableFactors=[];b.push("asVariableFactors");this.stringSampleFactors=[];b.push("stringSampleFactors");this.stringVariableFactors=[];b.push("stringVariableFactors");this.asHistogram=false;b.push("asHistogram");this.appendNetworkData=[];b.push("appendNetworkData");this.timeFormat="isoDate";b.push("timeFormat");this.isGraphTime=false;b.push("isGraphTime");this.timeValues=[];this.timeValueIndices=[];this.timeTicksFirst=false;b.push("timeTicksFirst");this.sortDir="ascending";b.push("sortDir");this.sortCaseSensitive=false;b.push("sortCaseSensitive");this.sortData=[];b.push("sortData");this.missingDataColor="rgb(204,204,204)";b.push("missingDataColor");this.missingDataValue="NA";b.push("missingDataValue");this.showErrorBars=true;b.push("showErrorBars");this.errorBarsType="confidenceInterval95";b.push("errorBarsType");this.errorBarsColor="rgb(0,0,0)";b.push("errorBarsColor");this.errorBarsThickness=3;b.push("errorBarsThickness");this.errorBarsWidth=2;b.push("errorBarsWidth");this.standardDeviationType="unbiased";b.push("standardDeviationType");this.showRegressionFullRange=false;b.push("showRegressionFullRange");this.regressionType="linear";b.push("regressionType");this.regressionOrder=2;b.push("regressionOrder");this.showConfidenceIntervals=true;b.push("showConfidenceIntervals");this.confidenceLevel=0.95;b.push("confidenceLevel");this.confidenceIntervalType="log";b.push("confidenceIntervalType");this.confidenceIntervalColor="rgb(50,50,50)";b.push("confidenceIntervalColor");this.invertCensored=false;b.push("invertCensored");this.kaplanMeierBy=false;b.push("kaplanMeierBy");this.fitLineColor="rgb(255,215,0)";b.push("fitLineColor");this.fitLineStyle="solid";b.push("fitLineStyle");this.randomSeed=8;b.push("randomSeed");this.pseudoRandom=true;b.push("pseudoRandom");this.randomMethod="numericalRecipes";b.push("randomMethod");this.randomData=false;this.randomDataDistribution="biased";b.push("randomDataDistribution");this.randomDataTime=false;b.push("randomDataTime");this.randomDataMin=1;b.push("randomDataMin");this.randomDataMax=100;b.push("randomDataMax");this.randomDataMean=0;b.push("randomDataMean");this.randomDataSigma=1;b.push("randomDataSigma");this.randomDataVariables=3;b.push("randomDataVariables");this.randomDataSamples=36;b.push("randomDataSamples");this.randomDataVariableAnnotations=2;b.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=2;b.push("randomDataSampleAnnotations");this.randomMissingDataPercentage=0;b.push("randomMissingDataPercentage");this.randomNetworkReduce=true;b.push("randomNetworkReduce");this.randomNetworkNodes=40;b.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;b.push("randomNetworkNodeEdgesMax");this.randomNetworkAll=true;b.push("randomNetworkAll");this.randomNetworkLayout="forceLayout";b.push("randomNetworkLayout");this.zoom=1;b.push("zoom");this.zoomGlobal=1;this.zoomStep=0.2;b.push("zoomStep");this.zoomScale=true;b.push("zoomScale");this.zoomVariablesDisable=false;b.push("zoomVariablesDisable");this.zoomSamplesDisable=false;b.push("zoomSamplesDisable");this.zoomDisable=false;b.push("zoomDisable");this.panningX=0;b.push("panningX");this.panningY=0;b.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.2;b.push("panningStep");this.resizerBackgroundColor=CanvasXpress.system.isIE?"rgb(204,204,204)":"rgba(204,204,204,0.7)";b.push("resizerBackgroundColor");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxisMaxStrLength=false;this.setMaxX=null;b.push("setMaxX");this.setMinX=null;b.push("setMinX");this.xAxisCurrent=0;b.push("xAxisCurrent");this.xAxisTitle=false;b.push("xAxisTitle");this.xAxis=[];b.push("xAxis");this.xAxisTickStyle="solid";b.push("xAxisTickStyle");this.xAxisTickFormat=false;b.push("xAxisTickFormat");this.xAxisTickColor="rgb(204,204,204)";b.push("xAxisTickColor");this.xAxisExact=false;b.push("xAxisExact");this.xAxisValues=[];this.xAxisValuesRaw=[];this.xAxisMinorValues=[];this.xAxisTransform=false;b.push("xAxisTransform");this.xAxisCeilValue=null;b.push("xAxisCeilValue");this.xAxisFloorValue=null;b.push("xAxisFloorValue");this.xAxisTransformTicks=true;b.push("xAxisTransformTicks");this.xAxisShow=true;b.push("xAxisShow");this.xAxisS2Show=false;b.push("xAxisS2Show");this.xAxisTicks=5;b.push("xAxisTicks");this.xAxisMinorTicks=true;b.push("xAxisMinorTicks");this.xAxisMajorTicks=true;b.push("xAxisMajorTicks");this.xAxisLeftMajorTick=true;b.push("xAxisLeftMajorTick");this.xAxisRightMajorTick=true;b.push("xAxisRightMajorTick");this.xAxisLeftRightTickColor="rgb(204,204,204)";b.push("xAxisLeftRightTickColor");this.xAxisHistogramShow=false;b.push("xAxisHistogramShow");this.xAxisHistogramHeight=80;b.push("xAxisHistogramHeight");this.xAxisRugShow=false;b.push("xAxisRugShow");this.xAxisRugHeight=15;b.push("xAxisRugHeight");this.xAxisRugPosition="bottom";b.push("xAxisRugPosition");this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.xAxis2MaxStrLength=false;this.setMaxX2=null;b.push("setMaxX2");this.setMinX2=null;b.push("setMinX2");this.xAxis2Title=false;b.push("xAxis2Title");this.xAxis2=[];b.push("xAxis2");this.xAxis2TickFormat=false;b.push("xAxis2TickFormat");this.xAxis2Values=[];this.xAxis2ValuesRaw=[];this.xAxis2MinorValues=[];this.xAxis2Show=true;b.push("xAxis2Show");this.xAxis2Ticks=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.yAxisMaxStrLength=false;this.setMaxY=null;b.push("setMaxY");this.setMinY=null;b.push("setMinY");this.yAxisCurrent=0;b.push("yAxisCurrent");this.yAxisTitle=false;b.push("yAxisTitle");this.yAxis2Title=false;b.push("yAxis2Title");this.yAxis=[];b.push("yAxis");this.yAxisTickStyle="solid";b.push("yAxisTickStyle");this.yAxisTickFormat=false;b.push("yAxisTickFormat");this.yAxisTickColor="rgb(204,204,204)";b.push("yAxisTickColor");this.yAxisExact=false;b.push("yAxisExact");this.yAxisValues=[];this.yAxisValuesRaw=[];this.yAxisMinorValues=[];this.yAxisTransform=false;b.push("yAxisTransform");this.yAxisCeilValue=null;b.push("yAxisCeilValue");this.yAxisFloorValue=null;b.push("yAxisFloorValue");this.yAxisTransformTicks=true;b.push("yAxisTransformTicks");this.yAxisShow=true;b.push("yAxisShow");this.yAxis2Show=false;b.push("yAxis2Show");this.yAxisTicks=5;b.push("yAxisTicks");this.yAxisMinorTicks=true;b.push("yAxisMinorTicks");this.yAxisMajorTicks=true;b.push("yAxisMajorTicks");this.yAxisTopMajorTick=true;b.push("yAxisTopMajorTick");this.yAxisBottomMajorTick=true;b.push("yAxisBottomMajorTick");this.yAxisTopBottomTickColor="rgb(204,204,204)";b.push("yAxisTopBottomTickColor");this.yAxisHistogramShow=false;b.push("yAxisHistogramShow");this.yAxisHistogramHeight=80;b.push("yAxisHistogramHeight");this.yAxisRugShow=false;b.push("yAxisRugShow");this.yAxisRugHeight=15;b.push("yAxisRugHeight");this.yAxisRugPosition="left";b.push("yAxisRugPosition");this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.zAxisMaxStrLength=false;this.setMaxZ=null;b.push("setMaxZ");this.setMinZ=null;b.push("setMinZ");this.zAxisCurrent=0;b.push("zAxisCurrent");this.zAxisTitle=false;b.push("zAxisTitle");this.zAxis=[];b.push("zAxis");this.zAxisTickStyle="solid";b.push("zAxisTickStyle");this.zAxisTickFormat=false;b.push("zAxisTickFormat");this.zAxisTickColor="rgb(204,204,204)";b.push("zAxisTickColor");this.zAxisExact=false;b.push("zAxisExact");this.zAxisValues=[];this.zAxisValuesRaw=[];this.zAxisMinorValues=[];this.zAxisTransform=false;b.push("zAxisTransform");this.zAxisCeilValue=null;b.push("zAxisCeilValue");this.zAxisFloorValue=null;b.push("zAxisFloorValue");this.zAxisTransformTicks=true;b.push("zAxisTransformTicks");this.zAxisShow=true;b.push("zAxisShow");this.zAxisTicks=10;this.rAxisAbsMax=null;this.rAxisAbsMin=null;this.rAxisMaxStrLength=false;this.rAxisTickFormat=false;b.push("rAxisTickFormat");this.rAxisTickColor=this.foreground;b.push("rAxisTickColor");this.rAxisValues=[];b.push("rAxisValues");this.rAxisValuesRaw=[];this.rAxisMinorValues=[];b.push("rAxisMinorValues");this.rAxisPercentShow=true;b.push("rAxisPercentShow");this.rAxisShow=true;b.push("rAxisShow");this.rAxisLabelOrientation="perpendicular";b.push("rAxisLabelOrientation");this.rAxisTicks=5;b.push("rAxisTicks");this.rAxisMinorTicks=true;b.push("rAxisMinorTicks");this.rAxisMajorTicks=true;b.push("rAxisMajorTicks");this.axisTickColor=this.foreground;b.push("axisTickColor");this.axisTickThickness=1;b.push("axisTickThickness");this.axisMinMaxTickThickness=1;b.push("axisMinMaxTickThickness");this.axisTickFontStyle="";b.push("axisTickFontStyle");this.axisTickFontSize=12;b.push("axisTickFontSize");this.axisTickScaleFontFactor=1;b.push("axisTickScaleFontFactor");this.axisTitleColor=this.foreground;b.push("axisTitleColor");this.axisTitleFontStyle="";b.push("axisTitleFontStyle");this.axisTitleFontSize=12;b.push("axisTitleFontSize");this.axisTitleScaleFontFactor=1;b.push("axisTitleScaleFontFactor");this.axisExtension=0.1;b.push("axisExtension");this.axisAlgorithm="wilkinson";b.push("axisAlgorithm");this.axisWilkinsonLoose=false;b.push("axisWilkinsonLoose");this.axisCoordinate=false;b.push("axisCoordinate");this.setMax=null;this.setMin=null;this.guides=false;b.push("guides");this.guidesWidth=0.3;b.push("guidesWidth");this.guidesColor="rgb(204,204,204)";b.push("guidesColor");this.blockContrast=false;b.push("blockContrast");this.plotByVariable=false;b.push("plotByVariable");this.is3DPlot=false;b.push("is3DPlot");this.showDataValues=false;b.push("showDataValues");this.binned=false;b.push("binned");this.binAlignment="center";b.push("binAlignment");this.jitter=true;b.push("jitter");this.jitterColumns=7;b.push("jitterColumns");this.objectBorderColor="rgb(0,0,0)";b.push("objectBorderColor");this.objectColorTransparency=1;b.push("objectColorTransparency");this.dotplotOutlineThreshold=500;b.push("dotplotOutlineThreshold");this.lineDecoration="symbol";b.push("lineDecoration");this.lineErrorType="bar";b.push("lineErrorType");this.coordinateLineColor=false;b.push("coordinateLineColor");this.lineType="rect";b.push("lineType");this.tension=0.3;b.push("tension");this.tensionSegments=16;b.push("tensionSegments");this.parallelCoordinates=[];this.boxplotOutliersRatio=8;b.push("boxplotOutliersRatio");this.boxplotWhiskersType="double";b.push("boxplotWhiskersType");this.boxplotType="boxWhiskers";b.push("boxplotType");this.boxplotNotched=false;b.push("boxplotNotched");this.boxplotTransparency=0.5;b.push("boxplotTransparency");this.boxplotColor=false;b.push("boxplotColor");this.boxplotCoef=1.5;b.push("boxplotCoef");this.boxplotHingeFunction="summary";b.push("boxplotHingeFunction");this.showBoxplotOriginalData=false;b.push("showBoxplotOriginalData");this.showViolinBoxplot=false;b.push("showViolinBoxplot");this.violinTrim=true;b.push("violinTrim");this.violinScale="area";b.push("violinScale");this.showBoxplotIfViolin=true;b.push("showBoxplotIfViolin");this.boxplotWidthRatioIfViolin=0.33;b.push("boxplotWidthRatioIfViolin");this.violinTransparency=0.5;b.push("violinTransparency");this.violinColor=false;b.push("violinColor");this.violinBorderColor="rgb(0,0,0)";b.push("violinBorderColor");this.boxplotDataPointTransparency=0.5;b.push("boxplotDataPointTransparency");this.boxplotMedianColor="rgb(0,0,0)";b.push("boxplotMedianColor");this.boxplotMedianWidth=1;b.push("boxplotMedianWidth");this.boxplotMean=false;b.push("boxplotMean");this.boxplotMeanColor="rgb(255,215,0)";b.push("boxplotMeanColor");this.boxplotMeanColorBorder="rgb(255,0,0)";b.push("boxplotMeanColorBorder");this.boxplotConnect=false;b.push("boxplotConnect");this.boxplotConnectWidth=2;b.push("boxplotConnectWidth");this.areaType="normal";b.push("areaType");this.dotplotType="normal";b.push("dotplotType");this.barType="normal";b.push("barType");this.barLollipopFactor=1.5;b.push("barLollipopFactor");this.barLollipopOpen=false;b.push("barLollipopOpen");this.swimHigh=false;b.push("swimHigh");this.swimStart=false;b.push("swimStart");this.swimEnd=false;b.push("swimEnd");this.swimStatus=false;b.push("swimStatus");this.swimHighCap=false;b.push("swimHighCap");this.ganttStart=false;b.push("ganttStart");this.ganttEnd=false;b.push("ganttEnd");this.ganttCompletion=false;b.push("ganttCompletion");this.ganttDependency=false;b.push("ganttDependency");this.ganttDependencyEnd=false;b.push("ganttDependencyEnd");this.ganttDependencyColor=false;b.push("ganttDependencyColor");this.ganttDependencyThickness=false;b.push("ganttDependencyThickness");this.ganttCompletionTransparency=0.5;b.push("ganttCompletionTransparency");this.sankeyNodeWidth=20;b.push("sankeyNodeWidth");this.sankeyIterations=32;this.sankeySource=false;b.push("sankeySource");this.sankeyTarget=false;b.push("sankeyTarget");this.sankeyColor="rgba(150,150,150,0.5)";b.push("sankeyColor");this.sankeyCoordinateColor=false;b.push("sankeyCoordinateColor");this.hierarchy=[];b.push("hierarchy");this.hierarchyVar=false;b.push("hierarchyVar");this.hierarchyVarIndex=0;this.treeNodeSize=20;b.push("treeNodeSize");this.treeLinkColor="rgb(150,150,150)";b.push("treeLinkColor");this.treeLinkWidth=1;b.push("treeLinkWidth");this.treeCircular=false;b.push("treeCircular");this.treeInverted=false;b.push("treeInverted");this.treeVarIndex=0;b.push("treeVarIndex");this.treeNodeId=0;this.colorBy=false;b.push("colorBy");this.colorByShowLegend=true;b.push("colorByShowLegend");this.colorKey=false;b.push("colorKey");this.shapeBy=false;b.push("shapeBy");this.shapeByContinuous=false;b.push("shapeByContinuous");this.shapeByShowLegend=true;b.push("shapeByShowLegend");this.shapeKey=false;b.push("shapeKey");this.shapeByData=false;b.push("shapeByData");this.shapeByShape=false;b.push("shapeByShape");this.sizeBy=false;b.push("sizeBy");this.sizeByContinuous=false;b.push("sizeByContinuous");this.sizeByShowLegend=true;b.push("sizeByShowLegend");this.sizeKey=false;b.push("sizeKey");this.sizeByData=false;b.push("sizeByData");this.outlineBy=false;b.push("outlineBy");this.outlineByShowLegend=true;b.push("outlineByShowLegend");this.outlineByData=false;b.push("outlineByData");this.patternBy=false;b.push("patternBy");this.patternByShowLegend=true;b.push("patternByShowLegend");this.patternKey=false;b.push("patternKey");this.patternByData=false;b.push("patternByData");this.connectBy=false;b.push("connectBy");this.connectByNoColor=false;b.push("connectByNoColor");this.connectByColor="rgb(204,204,204)";b.push("connectByColor");this.connectByWidth=2;b.push("connectByWidth");this.connectByShowLegend=true;b.push("connectByShowLegend");this.connectKey=false;b.push("connectKey");this.connectByData={};this.treemapBy=[];b.push("treemapBy");this.motionBy=false;b.push("motionBy");this.ellipseBy=false;b.push("ellipseBy");this.spiderBy=false;b.push("spiderBy");this.motionWidth=250;b.push("motionWidth");this.motionCurrentColor="rgba(0,0,0,0.3)";b.push("motionCurrentColor");this.motionCurrentFontStyle="";b.push("motionCurrentFontStyle");this.motionCurrentFontSize=60;b.push("motionCurrentFontSize");this.motionCurrentScaleFontFactor=1;b.push("motionCurrentScaleFontFactor");this.scatterType=false;b.push("scatterType");this.scatterAxesEqual=false;b.push("scatterAxesEqual");this.scatterOutlineThreshold=50000;b.push("scatterOutlineThreshold");this.functionIntervals=25;b.push("functionIntervals");this.selectDataMode="area";b.push("selectDataMode");this.selectedBackgroundColor="rgb(255,0,0)";b.push("selectedBackgroundColor");this.selectDataModeDescription=false;b.push("selectDataModeDescription");this.selectedDataPoints=[];b.push("selectedDataPoints");this.selectDataPoint={};this.hideDataPoint={};this.isSelectDataPoints=0;this.contourType="overlay";b.push("contourType");this.contourXBinSize=false;b.push("contourXBinSize");this.contourYBinSize=false;b.push("contourYBinSize");this.contourZBinSize=false;b.push("contourZBinSize");this.isHistogram=false;b.push("isHistogram");this.histogramBarWidth=false;this.histogramBins=false;b.push("histogramBins");this.histogramStagger=false;b.push("histogramStagger");this.showHistogramDensity=false;b.push("showHistogramDensity");this.showFilledHistogramDensity=false;b.push("showFilledHistogramDensity");this.histogramDensityFillTransparency=0.5;b.push("histogramDensityFillTransparency");this.showHistogramMedian=false;b.push("showHistogramMedian");this.histogramMedianLineStyle="dashed";b.push("histogramMedianLineStyle");this.hideHistogram=false;b.push("hideHistogram");this.histogramSizeEstimator="sturges";b.push("histogramSizeEstimator");this.isCreateHistogram=false;this.showScatterDensity=false;b.push("showScatterDensity");this.densityPixels=1000;b.push("densityPixels");this.densityKernel="gaussian";b.push("densityKernel");this.bandwidthRule="nrd0";b.push("bandwidthRule");this.bandwidthCut=3;b.push("bandwidthCut");this.loessDegree=2;b.push("loessDegree");this.loessSteps=30;b.push("loessSteps");this.loessSurfaceSteps=30;b.push("loessSurfaceSteps");this.loessBandwidth=0.8;b.push("loessBandwidth");this.loessSpan=0.8;b.push("loessSpan");this.loessIterations=1;this.loessAccuracy=1e-12;this.showLoessFit=false;b.push("showLoessFit");this.qqDistribution="normal";b.push("qqDistribution");this.qqSamples=10000;b.push("qqSamples");this.qqPoints=100;b.push("qqPoints");this.maxDOENumber=8;b.push("maxDOENumber");this.includeDOE=[];b.push("includeDOE");this.showDOEData=true;b.push("showDOEData");this.scatterPlotMatrix=false;b.push("scatterPlotMatrix");this.scatterPlotMatrixType="both";b.push("scatterPlotMatrixType");this.showScatterPlotMatrixLabels=true;b.push("showScatterPlotMatrixLabels");this.xRotate=45;b.push("xRotate");this.yRotate=0;b.push("yRotate");this.zRotate=0;b.push("zRotate");this.x3DRatio=1;b.push("x3DRatio");this.y3DRatio=1;b.push("y3DRatio");this.z3DRatio=1;b.push("z3DRatio");this.show3DGrid=true;b.push("show3DGrid");this.rotationSensitivity=450;b.push("rotationSensitivity");this.rotationStep=2;b.push("rotationStep");this.perspectiveFactor=2.2;b.push("perspectiveFactor");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.isMultidimensionalData=false;this.heatmapAutoAdjust=false;b.push("heatmapAutoAdjust");this.heatmapCellBox=true;b.push("heatmapCellBox");this.heatmapCellBoxColor="rgb(220,220,220)";b.push("heatmapCellBoxColor");this.heatmapCellBoxWidth=0.5;b.push("heatmapCellBoxWidth");this.heatmapCellBoxColorHighlight="rgb(255,215,0)";b.push("heatmapCellBoxColorHighlight");this.heatmapCellBoxHighlightWidth=1;b.push("heatmapCellBoxHighlightWidth");this.heatmapSmpSeparateBy=false;b.push("heatmapSmpSeparateBy");this.heatmapVarSeparateBy=false;b.push("heatmapVarSeparateBy");this.heatmapSeparatorThickness=2.5;b.push("heatmapSeparatorThickness");this.varTitleLabelPosition="bottom";b.push("varTitleLabelPosition");this.showHeatmapIndicator=true;b.push("showHeatmapIndicator");this.heatmapIndicatorHeight=20;b.push("heatmapIndicatorHeight");this.heatmapIndicatorWidth=160;b.push("heatmapIndicatorWidth");this.adjustAspectRatioHeatmapIndicator=true;b.push("adjustAspectRatioHeatmapIndicator");this.heatmapIndicatorPosition="top";b.push("heatmapIndicatorPosition");this.heatmapIndicatorHistogram=false;b.push("heatmapIndicatorHistogram");this.heatmapIndicatorHistogramColor="rgb(0,255,255)";b.push("heatmapIndicatorHistogramColor");this.isOncoprint=false;this.oncoprintCNA=false;b.push("oncoprintCNA");this.oncoprintMUT=false;b.push("oncoprintMUT");this.oncoprintHeatmapSwitch=false;b.push("oncoprintHeatmapSwitch");this.oncoprintNoAlterations=true;b.push("oncoprintNoAlterations");this.oncoprintColSummary=false;b.push("oncoprintColSummary");this.oncoprintRowSummary=false;b.push("oncoprintRowSummary");this.oncoprintHeatmapSwitch=false;b.push("oncoprintHeatmapSwitch");this.showHeatmapOncoprint=false;b.push("showHeatmapOncoprint");this.oncoprintHeatmapPosition="bottom";b.push("oncoprintHeatmapPosition");this.treemapBorderWidth=3;b.push("treemapBorderWidth");this.treemapBorderColor="rgb(204,204,204)";b.push("treemapBorderColor");this.correlationAxis="samples";b.push("correlationAxis");this.correlationAnchorLegend=false;b.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;b.push("correlationAnchorLegendAlignWidth");this.correlationLabelInterval=1;b.push("correlationLabelInterval");this.correlationType="diamond";b.push("correlationType");this.showVarDendrogram=true;b.push("showVarDendrogram");this.varDendrogramNewick=false;b.push("varDendrogramNewick");this.varDendrogramPosition="top";b.push("varDendrogramPosition");this.colorVarDendrogramBy=false;b.push("colorVarDendrogramBy");this.showSmpDendrogram=true;b.push("showSmpDendrogram");this.smpDendrogramNewick=false;b.push("smpDendrogramNewick");this.smpDendrogramPosition="left";b.push("smpDendrogramPosition");this.colorSmpDendrogramBy=false;b.push("colorSmpDendrogramBy");this.dendrogramHeight=50;b.push("dendrogramHeight");this.dendrogramColor="rgb(0,0,0)";b.push("dendrogramColor");this.distance="euclidian";b.push("distance");this.linkage="complete";b.push("linkage");this.clusterAxis="samples";this.kmeansVarClusters=3;b.push("kmeansVarClusters");this.kmeansSmpClusters=3;b.push("kmeansSmpClusters");this.maxIterations=500;b.push("maxIterations");this.imputeMethod="mean";b.push("imputeMethod");this.samplesClustered=false;b.push("samplesClustered");this.variablesClustered=false;b.push("variablesClustered");this.samplesKmeaned=false;b.push("samplesKmeaned");this.variablesKmeaned=false;b.push("variablesKmeaned");this.vennLegendColors=false;b.push("vennLegendColors");this.vennGroups=4;b.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];b.push("vennCompartments");this.vennColors=[];b.push("vennColors");this.pieType="separated";b.push("pieType");this.pieSegmentPrecision=0;b.push("pieSegmentPrecision");this.pieSegmentSeparation=1;b.push("pieSegmentSeparation");this.pieSegmentLabels="inside";b.push("pieSegmentLabels");this.pieLabelType="percentage";b.push("pieLabelType");this.maxPieSectors=20;b.push("maxPieSectors");this.showPieGrid=true;b.push("showPieGrid");this.showPieValues=true;b.push("showPieValues");this.showPieSampleLabel=true;b.push("showPieSampleLabel");this.startPieSectors=0;b.push("startPieSectors");this.pieInnerRadius=0;b.push("pieInnerRadius");this.pieColors=[];b.push("pieColors");this.circularType="normal";b.push("circularType");this.chordThickness=28;b.push("chordThickness");this.chordColor="source";b.push("chordColor");this.bubbleColor="rgba(150,150,150,0.33)";b.push("bubbleColor");this.circularCenterProportion=0.3;b.push("circularCenterProportion");this.arcSegmentsSeparation=8;b.push("arcSegmentsSeparation");this.circularRotate=0;b.push("circularRotate");this.circularArc=360;b.push("circularArc");this.ringSeparation=5;b.push("ringSeparation");this.ringGraphType=[];b.push("ringGraphType");this.ringGraphWeight=[];b.push("ringGraphWeight");this.arcSegmentsRadius=[];b.push("arcSegmentsRadius");this.ringsOrder=[];b.push("ringsOrder");this.rAxis=false;b.push("rAxis");this.rAxisZero=false;b.push("rAxisZero");this.showCircularConnections=true;b.push("showCircularConnections");this.connections=[];b.push("connections");this.circularLetterSeparationFactor=1.5;b.push("circularLetterSeparationFactor");this.circularConnectionsTransparency=0.5;b.push("circularConnectionsTransparency");this.overlayLevelOrientation="circular";b.push("overlayLevelOrientation");this.smpLabelOrientation="perpendicular";b.push("smpLabelOrientation");this.circularLabelsAlign="outside";b.push("circularLabelsAlign");this.circularScalesAlign="inside";b.push("circularScalesAlign");this.circularAnchorsAlign="inside";b.push("circularAnchorsAlign");this.circularAnchors2Align="outside";b.push("circularAnchors2Align");this.circularDataPosition="distributed";b.push("circularDataPosition");this.circularAnchorLength=15;b.push("circularAnchorLength");this.circularAnchorColor="rgb(0,0,255)";b.push("circularAnchorColor");this.showIdeogram=false;b.push("showIdeogram");this.ideogram="hg19";b.push("ideogram");this.ideogramChromosome="chr";b.push("ideogramChromosome");this.ideogramChromosomePosition="pos";b.push("ideogramChromosomePosition");this.tagCloudTextWeightFactor=1;b.push("tagCloudTextWeightFactor");this.tagCloudTextGridSize=8;b.push("tagCloudTextGridSize");this.tagCloudTextEllipticity=0.65;b.push("tagCloudTextEllipticity");this.tagCloudTextRotateRatio=0.1;b.push("tagCloudTextRotateRatio");this.tagCloudShape=false;b.push("tagCloudShape");this.tagCloudMask=false;b.push("tagCloudMask");this.tagCloudGridPoints=[];this.calculateLayout=true;b.push("calculateLayout");this.networkFreeze=false;b.push("networkFreeze");this.networkFreezeOnLoad=false;b.push("networkFreezeOnLoad");this.preScaleNetwork=false;b.push("preScaleNetwork");this.ignoreEventlessOrder=false;b.push("ignoreEventlessOrder");this.subNetworks=false;this.networkLayoutType="forceDirected";b.push("networkLayoutType");this.networkRoot=false;b.push("networkRoot");this.isNetworkMetrics=false;b.push("isNetworkMetrics");this.showNetworkRadialLayout=false;b.push("showNetworkRadialLayout");this.is3DNetwork=false;b.push("is3DNetwork");this.networkNodesOnTop=true;b.push("networkNodesOnTop");this.moveParentsWithChildren=false;b.push("moveParentsWithChildren");this.highlightNode=[];b.push("highlightNode");this.nodeHighlightColor="rgb(255,0,0)";b.push("nodeHighlightColor");this.selectNode={};this.isSelectNodes=0;this.showNodeNameThreshold=50;b.push("showNodeNameThreshold");this.nodeSize=15;this.edgeThickness=1;this.labelNodePosition="auto";b.push("labelNodePosition");this.nodeFontStyle="";b.push("nodeFontStyle");this.nodeFontSize=15;this.nodeFontColor=this.foreground;b.push("nodeFontColor");this.nodeScaleFontFactor=1;b.push("nodeScaleFontFactor");this.networkVendor=false;b.push("networkVendor");this.attractiveForceFunction="square";b.push("attractiveForceFunction");this.repulsiveForceFunction="square";b.push("repulsiveForceFunction");this.useBarnesHutSimulation=false;b.push("useBarnesHutSimulation");this.networkSpeed=0.1;b.push("networkSpeed");this.networkGravity=0.75;b.push("networkGravity");this.networkSpringLength=35;b.push("networkSpringLength");this.networkSpringCoeff=0.0008;b.push("networkSpringCoeff");this.networkRepulsion=-1;b.push("networkRepulsion");this.networkTheta=0.8;b.push("networkTheta");this.networkDragCoeff=0.09;b.push("networkDragCoeff");this.networkTimeStep=20;b.push("networkTimeStep");this.barnesHutUpdateQueue=[];this.barnesHutNodesCache=[];this.barnesHutNodesCacheCurrent=0;this.colorNodeBy=false;b.push("colorNodeBy");this.shapeNodeBy=false;b.push("shapeNodeBy");this.sizeNodeBy=false;b.push("sizeNodeBy");this.patternNodeBy=false;b.push("patternNodeBy");this.colorEdgeBy=false;b.push("colorEdgeBy");this.sizeEdgeBy=false;b.push("sizeEdgeBy");this.showNetworkCommunities=false;b.push("showNetworkCommunities");this.calculateNetworkCommunities=true;b.push("calculateNetworkCommunities");this.coordinateNetworkConvexHullCommunityColor=false;b.push("coordinateNetworkConvexHullCommunityColor");this.hullScale=1.25;b.push("hullScale");this.networkCommunities=null;this.networkConvexHulls=[];this.genomeTicks=50;b.push("genomeTicks");this.trackNameFontStyle="";b.push("trackNameFontStyle");this.trackNameFontSize=10;b.push("trackNameFontSize");this.trackNameFontColor=this.foreground;b.push("trackNameFontColor");this.trackFillColor=this.background;b.push("trackFillColor");this.trackDirColor=this.foreground;b.push("trackDirColor");this.subtracksMaxDefault=8;b.push("subtracksMaxDefault");this.showFeatureNameThereshold=20;b.push("showFeatureNameThereshold");this.featureNameFontStyle="";b.push("featureNameFontStyle");this.featureNameFontSize=10;b.push("featureNameFontSize");this.featureNameFontColor=this.foreground;b.push("featureNameFontColor");this.featureFillColor=this.background;b.push("featureFillColor");this.featureDirColor=this.foreground;b.push("featureDirColor");this.maxFeatureStringLen=30;b.push("maxFeatureStringLen");this.featureWidthDefault=3;b.push("featureWidthDefault");this.featureHeightDefault=14;b.push("featureHeightDefault");this.featureTraceHeight=40;b.push("featureTraceHeight");this.featureTraceTrim=1;b.push("featureTraceTrim");this.featureTracesShow=true;b.push("featureTracesShow");this.featureQualityHeight=12;b.push("featureQualityHeight");this.featureQualityValues=false;b.push("featureQualityValues");this.featureQualityShow=true;b.push("featureQualityShow");this.featureSignalToNoiseHeight=12;b.push("featureSignalToNoiseHeight");this.featureSignalToNoiseValues=false;b.push("featureSignalToNoiseValues");this.featureSignalToNoiseShow=true;b.push("featureSignalToNoiseShow");this.featureCoordinateHeight=12;b.push("featureCoordinateHeight");this.featureCoordinateShow=true;b.push("featureCoordinateShow");this.featureTranslateHeight=12;b.push("featureTranslateHeight");this.featureTranslateShow=true;b.push("featureTranslateShow");this.featureTypeDefault="line";b.push("featureTypeDefault");this.featureStaggered=false;b.push("featureStaggered");this.sequenceFontStyle="";b.push("sequenceFontStyle");this.sequenceFontSize=10;b.push("sequenceFontSize");this.sequenceFill=false;b.push("sequenceFill");this.sequenceGAPColor="rgb(255,0,255)";b.push("sequenceGAPColor");this.sequenceAColor="rgb(0,103,0)";b.push("sequenceAColor");this.sequenceBColor="rgb(0,0,0)";b.push("sequenceBColor");this.sequenceCColor="rgb(0,0,255)";b.push("sequenceCColor");this.sequenceDColor="rgb(0,0,0)";b.push("sequenceDColor");this.sequenceEColor="rgb(0,0,0)";b.push("sequenceEColor");this.sequenceFColor="rgb(0,0,255)";b.push("sequenceFColor");this.sequenceGColor="rgb(0,0,0)";b.push("sequenceGColor");this.sequenceHColor="rgb(255,0,0)";b.push("sequenceHColor");this.sequenceIColor="rgb(0,103,0)";b.push("sequenceIColor");this.sequenceKColor="rgb(255,0,0)";b.push("sequenceKColor");this.sequenceLColor="rgb(0,103,0)";b.push("sequenceLColor");this.sequenceMColor="rgb(0,103,0)";b.push("sequenceMColor");this.sequenceNColor="rgb(0,0,0)";b.push("sequenceNColor");this.sequencePColor="rgb(255,165,0)";b.push("sequencePColor");this.sequenceQColor="rgb(0,0,0)";b.push("sequenceQColor");this.sequenceRColor="rgb(255,0,0)";b.push("sequenceRColor");this.sequenceSColor="rgb(255,165,0)";b.push("sequenceSColor");this.sequenceTColor="rgb(255,0,0)";b.push("sequenceTColor");this.sequenceUColor="rgb(255,0,0)";b.push("sequenceUColor");this.sequenceVColor="rgb(0,103,0)";b.push("sequenceVColor");this.sequenceWColor="rgb(0,0,255)";b.push("sequenceWColor");this.sequenceXColor="rgb(0,0,0)";b.push("sequenceXColor");this.sequenceYColor="rgb(0,0,255)";b.push("sequenceYColor");this.sequenceZColor="rgb(0,0,0)";b.push("sequenceZColor");this.sequenceStartColor="rgb(0,204,0)";b.push("sequenceStartColor");this.sequenceEndColor="rgb(255,0,0)";b.push("sequenceEndColor");this.wireColor="rgba(204,204,204,0.1)";b.push("wireColor");this.periodTicksLabels=5;b.push("periodTicksLabels");this.genomeResolution="low";this.trackConfigurableProperties=["name","hideName","hideFeatureNames","type","height","fill","outline","hide","connect","subtracksMax","highlight"];b.push("trackConfigurableProperties");this.featureConfigurableProperties=["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"];b.push("featureConfigurableProperties");this.errors=[];this.debug=false;b.push("debug");this.verbose=false;b.push("verbose");this.offline=false;b.push("offline");this.showVersion=true;b.push("showVersion");this.showCode=false;b.push("showCode");this.codeType="params";b.push("codeType");this.disableEvents=false;b.push("disableEvents");this.disableCode=false;b.push("disableCode");this.disableMenu=false;b.push("disableMenu");this.disableToolbar=false;b.push("disableToolbar");this.disableDataTable=false;b.push("disableDataTable");this.disableDataFilters=false;b.push("disableDataFilters");this.disableConfigurator=false;b.push("disableConfigurator");this.disableDataExplorer=false;b.push("disableDataExplorer");this.disableCanvas=false;b.push("disableCanvas");this.disableKeys=false;b.push("disableKeys");this.disableArrowKeys=false;b.push("disableArrowKeys");this.disablePlusMinusKeys=true;b.push("disablePlusMinusKeys");this.disableHelpKeys=true;b.push("disableHelpKeys");this.disableDocument=false;b.push("disableDocument");this.disableWindow=false;b.push("disableWindow");this.resizable=true;b.push("resizable");this.resizableX=true;b.push("resizableX");this.resizableY=true;b.push("resizableY");this.movable=true;b.push("movable");this.maxSubMenus=22;b.push("maxSubMenus");this.showPrimaryMenus=false;b.push("showPrimaryMenus");this.maxItemMenuCheckbox=10;b.push("maxItemMenuCheckbox");this.configuratorWidth=250;b.push("configuratorWidth");this.configuratorExamplesSize=400;b.push("configuratorExamplesSize");this.alignConfiguratorExamples=false;b.push("alignConfiguratorExamples");this.showConfiguratorExamplesOnSelect=false;b.push("showConfiguratorExamplesOnSelect");this.resizeWidthOnLayout=true;b.push("resizeWidthOnLayout");this.resizeHeightOnLayout=true;b.push("resizeHeightOnLayout");this.skipClick=false;this.infoTimeOut=3000;b.push("infoTimeOut");this.infoStartTime=new Date().getTime();this.infoTimeIn=50;b.push("infoTimeIn");this.broadcast=true;b.push("broadcast");this.broadcastType="var";b.push("broadcastType");this.showMousePositionOnDrag=true;b.push("showMousePositionOnDrag");this.toolbarType="over";b.push("toolbarType");this.lazyLoad=false;b.push("lazyLoad");this.showAnimation=false;b.push("showAnimation");this.showTransition=false;b.push("showTransition");this.transitionTime=1000;b.push("transitionTime");this.transitionStep=10;b.push("transitionStep");this.transitionStaggering=10;b.push("transitionStaggering");this.transitionFunction="easeInOutQuad";b.push("transitionFunction");this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.layoutTopology=false;b.push("layoutTopology");this.layoutComb=false;this.layoutAdjust=false;b.push("layoutAdjust");this.layoutCollapse=false;b.push("layoutCollapse");this.layoutType="wrap";b.push("layoutType");this.layoutRemoveEmpty=true;b.push("layoutRemoveEmpty");this.layoutCanvasCompartments=false;b.push("layoutCanvasCompartments");this.layoutBoxLabelColors=[];b.push("layoutBoxLabelColors");this.layoutBoxShow=true;b.push("layoutBoxShow");this.layoutLabelColor="rgb(0,0,0)";b.push("layoutLabelColor");this.layoutLabelBoxThickness=30;b.push("layoutLabelBoxThickness");this.layoutLabelShow=true;b.push("layoutLabelShow");this.layoutConfig=[];b.push("layoutConfig");this.layoutCurrent=0;this.layoutAxis=3;this.imageDir="";b.push("imageDir");this.loadingImage="loading1";b.push("loadingImage");this.remoteService=false;b.push("remoteService");this.remoteServiceType="webService";b.push("remoteServiceType");this.remoteParams={};b.push("remoteParams");this.remoteDirection="next";b.push("remoteDirection");this.remoteAutoPlay=false;b.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;b.push("remoteAutoPlayDelay");this.remoteParamOverride=true;b.push("remoteParamOverride");this.remoteTransitionEffect="slide";b.push("remoteTransitionEffect");this.remoteParentId="";this.remoteDataIndex=0;this.remoteIds=[];this.remoteData=[];this.remoteUpdating=false;this.RdatasetsURL="https://raw.githubusercontent.com/neuhausi/Rdatasets/master/";this.loadRDatasets=false;b.push("loadRDatasets");this.maxDataExplorerEntries=10000;b.push("maxDataExplorerEntries");this.skipConfigurableProperties=true;b.push("skipConfigurableProperties");this.nodesProperties=[];b.push("nodesProperties");this.edgesProperties=[];b.push("edgesProperties");this.featuresProperties=[];b.push("featuresProperties");this.dataFilterWidth=180;b.push("dataFilterWidth");this.filterType="and";b.push("filterType");this.filterSkipNullKeys=false;b.push("filterSkipNullKeys");this.filterSkipNullValues=false;b.push("filterSkipNullValues");this.filterVarBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterVarBy");this.filterSmpBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterSmpBy");this.filterNodeBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterNodeBy");this.filterEdgeBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterEdgeBy");this.filterFeatureBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterFeatureBy");this.filterDataBy={cases:[],comp:[],op:[],type:[],value:[]};b.push("filterDataBy");this.showDataTable=false;b.push("showDataTable");this.dataTableTransposed=true;b.push("dataTableTransposed");this.maxRows=10;b.push("maxRows");this.maxCols=6;b.push("maxCols");this.colWidth=100;b.push("colWidth");this.rowHeight=18;b.push("rowHeight");this.refresehDataTableOnDraw=false;b.push("refresehDataTableOnDraw");this.showDataTableOnSelect=false;b.push("showDataTableOnSelect");this.networkShowDataTable="nodes";b.push("networkShowDataTable");this.colorDataTable=true;b.push("colorDataTable");this.colorDataTableTransparency=0.5;b.push("colorDataTableTransparency");this.startCol=0;this.startRow=0;this.totalCols=null;this.totalRows=null;this.dataTableColumnWidth=[];this.dataTableRowHeight=[]};this.updateTheme=function(b){for(var e in b){if(e=="conditional"){for(var f in b[e]){if(this.isInArray(this.graphType,CanvasXpress.graphTypes[f])){for(var d in b[e][f]){this[d]=b[e][f][d]}}}}else{this[e]=b[e]}}};this.setTheme=function(){if(a&&a.hasOwnProperty("theme")&&a.theme&&CanvasXpress.themes.hasOwnProperty(a.theme)){this.updateTheme(CanvasXpress.themes[a.theme])}};this.resetInitialFontSize=function(){var b=["fontSize","titleFontSize","subtitleFontSize","citationFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","legendFontSize","decorationFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var c=0;c<b.length;c++){this[b[c]]=Number(CanvasXpress.doc.P[b[c]].D)}this.setInitialFonts()};this.setInitialFonts=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendFont=this.legendFontStyle+" "+this.legendFontSize+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+this.decorationFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.setInitialConfig=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var b in this.meta.config.user){if(CanvasXpress.doc.P[b]&&CanvasXpress.doc.P[b].hasOwnProperty("T")){if(CanvasXpress.doc.P[b].T=="integer"||CanvasXpress.doc.P[b].T=="float"){this.meta.config.user[b]=Number(this.meta.config.user[b])}this[b]=this.meta.config.user[b]}else{this[b]=this.meta.config.user[b]}}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(c){if(c){this.meta.config.user=c;for(var b in c){this[b]=c[b]}}};this.getConfig=function(){var g=this;var b={};var c=CanvasXpress.config.sort();var l=function(d){if(g.theme&&CanvasXpress.themes[g.theme]&&CanvasXpress.themes[g.theme].hasOwnProperty(d)){return CanvasXpress.themes[g.theme][d]}else{return CanvasXpress.doc.P[d].D}};var n={colors:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true};if(this.isTransformedData){b.isTransformedData=this.isTransformedData}for(var f=0;f<c.length;f++){var e=c[f];if(CanvasXpress.doc.P[e]&&CanvasXpress.doc.P[e].hasOwnProperty("D")){var h=l(e);if(n[e]){continue}var m=g[e]===undefined?false:g[e];if(typeof(m)=="object"){if(h=="[]"){h=[]}if(h=="{}"){h={}}if(m===null){if(h!="null"){b[e]=m}}else{if(e=="sizes"){if(!this.isSameObject(m,h.map(Number))){b[e]=m}}else{if(e.match("filter")){if(!this.isSameObject(m,this.parseJSON(h.replace(/'/g,'"')))){b[e]=m}}else{if(!this.isSameObject(m,h)){b[e]=m}}}}}else{if(h.toString().match(/false|true|null/)){if(e=="summaryType"&&m=="raw"){continue}else{if(m.toString()!=h.toString()){b[e]=m}}}else{if(m!=h){b[e]=m}}}}}return b};this.getUserConfig=function(){return this.meta.config.user};this.getNewCanvasContext=function(d){var b=this.$(d);if(!b||b.tagName.toLowerCase()!="canvas"){b=this.$cX("canvas",{id:d});window.body.appendChild(b)}return this.get2DCanvasContext(b)};this.setCanvasPixelRatio=function(){var c=window.devicePixelRatio||1;var b=this.get2DCanvasContext(this.$cX("canvas"));var d=b.webkitBackingStorePixelRatio||b.mozBackingStorePixelRatio||b.msBackingStorePixelRatio||b.oBackingStorePixelRatio||b.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=c/d};this.setDPI=function(c,d){c.style.width=c.style.width||c.width+"px";c.style.height=c.style.height||c.height+"px";var h=d/96;var b=parseFloat(c.style.width);var i=parseFloat(c.style.height);var e=c.width/b;var g=h/e;var f=c.cloneNode(false);this.get2DCanvasContext(f).drawImage(c,0,0);var j=this.get2DCanvasContext(c);c.width=Math.ceil(b*h);c.height=Math.ceil(i*h);j.setTransform(g,0,0,g,0,0);j.drawImage(f,0,0);j.setTransform(h,0,0,h,0,0)};this.setCanvas=function(){var f=this.$(this.target);if(f){this.setCanvasPixelRatio();this.checkCanvasXpressOrgSite();this.meta.canvas.ctx=this.get2DCanvasContext(f);this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);if(this.graphType=="Map"){var b=[];if(this.topoJSON&&this.leafletId){var d=this;this.isMap=true;this.initLeaflet();var e=function(){var c=function(g){window[d.leafletId]=d.parseJSON(g);if(d.leafletInit){d.leafletInit()}else{if(d.leafletInitString){d.leafletInitString()}else{d.initializeLeaflet()}}};if(!d.ajaxRequest){d.initRemote(true)}d.ajaxRequest(d.topoJSON,false,c)};onReady(e)}else{alert("Missing topo JSON!!")}}else{this.isMap=false}}};this.get2DCanvasContext=function(b){return b.getContext("2d")};this.getCanvasContext=function(){var b;if(this.isSVG){b=this.meta.canvas.ctx5}else{if(this.isTransitionCanvas){b=this.transitionIter%2?this.meta.canvas.ctx3:this.meta.canvas.ctx4}else{b=this.isHighlightCanvas?this.meta.canvas.ctx2:this.isMapCanvas&&this.leafletLayer?this.meta.leaflet.ctx:this.meta.canvas.ctx}}this.currentCanvasContext=b.canvas.id;return b};this.checkCanvasXpressOrgSite=function(){var g=new RegExp("/www.canvasxpress.org/dist/");var d=window.document.getElementsByTagName("head")[0];for(var b=0;b<d.childNodes.length;b++){var f=d.childNodes[b];if(f.type=="text/javascript"&&g.test(f.src)){CanvasXpress.factory.siteSrc=true}}};this.inititalizeConfig=function(){CanvasXpress.config=[];this.setConfigDefaults();this.setTheme();if(a){for(var c=0;c<CanvasXpress.config.length;c++){var e=CanvasXpress.config[c];var b=CanvasXpress.doc.P[e]?CanvasXpress.doc.P[e].T:false;if(a.hasOwnProperty(e)){if(b=="array"){if(a[e] instanceof Array){this[e]=a[e]}else{this[e]=[a[e]]}}else{this[e]=a[e]}}}}this.setInitialFonts();for(var d in this.url){if(this.hasOwnProperty(d)){this[d]=this.url[d]}}this.setCanvas();CanvasXpress.system.isR=this.isR;CanvasXpress.system.isShiny=window.Shiny?true:false;CanvasXpress.system.isNode=typeof exports==="object"&&typeof module!=="undefined"};this.setFunctionNames("initConfig");this.inititalizeConfig()};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.dateFormat=a;this.setFunctionNames("initDate")};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.getArcTextArea=function(B,A,z,a,C,u,p,v,j,w,d,g){if(B==undefined){B=""}var q=["poly"];var o=this.getFontPt(p);var j=this.measureText(B,p)*(Math.PI*0.5)/a;C=(C+(u/2))-(j/2)%(Math.PI*2);u=C+j;var n=this.traceArc1(A,z,a,C,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.traceArc1(A,z,a-o,C,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.adjustNetworkObjects(q)}else{return q}};this.drawArcText=function(B,z,w,a,C,p,o,q,j,v,g,h){this.functionCallerDraw="drawArcText";if(B==undefined){B=""}var A=this.getCanvasContext();if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.formatNumber(B)}B=B.toString().replace("\x00","");if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.saveCanvas();A.strokeStyle=this.isArray(q)?q[0]:q;A.fillStyle=this.isArray(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.setTextShadow(true);var d=j=="right"?1:-1;var u=this.getFontPt(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.isArray(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.rotateCanvas(C);for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);p+=(n/2)/(a-u)*d;this.rotateCanvas((n/2)/(a-u)*d);if(this.isArray(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.rotateCanvas((n/2+this.circularLetterSeparationFactor)/(a-u)*d)}this.restoreCanvas();this.setTextShadow(false)};this.getTextMultipleArea=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.getFontPt(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.getTextArea(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.drawTextMultiple=function(B,z,u,p,r,w,v,e,h,C,A){this.functionCaller="drawTextMultiple";var j=B.split(/\n/);var d=p;var n=[];if(!d){d=this.font}var o=this.getFontPt(d);var q=u+(j%2?0:o/2)-(j.length*o/2);for(var k=0;k<j.length;k++){this.drawText(j[k],z,q,d,r,w,v,e,h,C,A);q+=o}};this.getTextArea=function(p,n,l,A,C,E,D,g,r,q,k){var j=this;var u=function(b){b.shift();var a=["poly"];a=a.concat(j.rotatePoint(b[0],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[3],n,l,g));a=a.concat(j.rotatePoint(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.isMultipleLines(p)){return this.getTextMultipleArea(p,n,l,A,C,E,D,g,r,q,k)}var F=[];var o=this.measureText(p,A);var v=this.getFontPt(A);var B,e,z,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.measureText(p,A);i++}}if(E=="left"){B=n;z=B+o}else{if(E=="right"){B=n-o;z=n}else{B=n-(o/2);z=n+(o/2)}}if(D=="top"){e=l;d=e+v}else{if(D=="bottom"){e=l-v;d=l}else{e=l-(v/2);d=l+(v/2)}}F=["rect",B,e,z,d];F=g?u(F):F;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?F:this.adjustNetworkObjects(F)}else{return F}};this.drawText=function(v,p,l,j,k,o,n,d,e,z,r){this.functionCallerDraw="drawText";if(v==undefined){v=""}var u=this.getCanvasContext();var i=0;if(v==null){return}if(this.isMultipleLines(v)){return this.drawTextMultiple(v,p,l,j,k,o,n,d,e,z,r)}if(!u){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(p)||isNaN(l)){if(this.debug){alert("Not a valid coordinate ("+p+", "+l+") to draw "+v)}return}if(r){if(p<this.marginLeft+this.offsetX+this.left||p>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(!p){p=0}if(!l){l=0}if(!j){j=this.font}if(!k){k=this.foreground}if(!o){o=this.align}if(!n){n=this.baseline}var q=this.measureText(v,j);var g=this.getFontPt(j);if(e){while(q>e&&i<10){v=v.substring(0,v.length-1);q=this.measureText(v,j);i++}}this.saveCanvas();u.strokeStyle=k;u.fillStyle=k;u.font=j;this.translateCanvas(p,l);u.textAlign=o;u.textBaseline=n;this.setTextShadow(true);if(d){this.rotateCanvas(d)}v=v.toString().replace("\x00","");if(z){u.strokeText(v,0,0)}else{u.fillText(v,0,0)}this.restoreCanvas();this.setTextShadow(false)};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.decapitalize=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.measureTextMultiple=function(e,g){var c=e.split(/\n/);var a=0;var b=this.getCanvasContext();if(!b){return 0}if(!g){g=this.font}b.font=g;for(var d=0;d<c.length;d++){a=Math.max(a,b.measureText(c[d]).width)}return a};this.measureText=function(b,c){var a=this.getCanvasContext();if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.isMultipleLines(b)){CanvasXpress.cacheText[c][b]=this.measureTextMultiple(b,c)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.measureTextWidth=function(b,c){var a=this.isMultipleLines(b);if(a>0){return(this.getFontPt(c)+this.margin)*(a+1)}else{return this.getFontPt(c)}};this.scaleTextToFont=function(b,e,a,c){var d=this.fontStyle+" "+e+"px "+this.fontName;if(b){while(this.measureText(b,d)>a&&e>=this.minTextSize){e-=2;d=this.fontStyle+" "+e+"px "+this.fontName}if(c){while(parseInt(e/1.33)>c-2){e--}d=this.fontStyle+" "+e+"px "+this.fontName}}return d};this.getFontPt=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.wrapText=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.scaleFont=function(a,b){var d=this.getFontPt(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.formatNumber=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.getMaxtTextBySampling=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.getMaxText(g)};this.getMaxText=function(d,h){var g="";var b=0;if(d&&d.length>0){if(!h){h=this.font}for(var e=0;e<d.length;e++){if(d[e]){var j=this.measureText(d[e].toString(),h);if(j>b){g=d[e].toString();b=j}}}}return g};this.shortenText=function(c,b,a){if(!c){return""}c=c.toString();if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.stringToHex=function(c){var b="";for(var a=0;a<c.length;a++){b+=""+c.charCodeAt(a).toString(16)}return b};this.hexToString=function(b){var c="";for(var a=0;a<b.length;a+=2){c+=String.fromCharCode(parseInt(b.substr(a,2),16))}return c};this.sprintf=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")};this.setFunctionNames("initText")};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+":"+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+":"+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"-"+a.getWeek()};this.getYearMonth=function(a){return a.getFullYear()+"-"+a.getMonth()};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.formatDate=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h){var g=Date.parse(h[h.length-1])-Date.parse(h[0]);var d;var b={};var c=[];this.timeValues=[];this.timeValueIndices=[];if(g>this.times.year*2){d="getYear"}else{if(g>this.times.month*2){d="getYearMonth"}else{if(g>this.times.week*2){d="getYearWeek"}else{if(g<this.times.second){d="getMillisecond"}else{if(g<this.times.minute){d="getSecond"}else{if(g<this.times.hour/4){d="getMinuteSecond"}else{if(g<this.times.hour){d="getMinute"}else{if(g<this.times.day/4){d="getHourMinute"}else{if(g<this.times.day){d="getHour"}else{d=false}}}}}}}}}if(d){if(this.timeTicksFirst){for(var a=0;a<h.length;a++){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.push(h[a]);this.timeValueIndices.push(a);b[e]=true}}}else{for(var a=h.length-1;a>=0;a--){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.unshift(h[a]);this.timeValueIndices.unshift(a);b[e]=true}}}}else{for(var a=0;a<h.length;a++){this.timeValues.push(this.dateFormat(h[a],this.timeFormat));this.timeValueIndices.push(a)}}var g=Date.parse(c[c.length-1])-Date.parse(c[c.length-2]);if(d=="getYear"&&g<this.times.month*3){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearMonth"&&g<this.times.week*4){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearWeek"&&g<this.times.day*7){this.timeValues.pop();this.timeValueIndices.pop()}}}for(var a=0;a<c.length;a++){this.timeValues.push(this.dateFormat(c[a],this.timeFormat))}}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w:this.data.y;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.smps.length;c++){e=Date.parse(h.smps[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var f=this.isGroupedData?this.data.w:this.data.y;var a=false;var e=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices.length!=f.smps.length?Date.parse(f.smps[this.smpIndices[b]]):Date.parse(f.smps[b]);if(isNaN(c)){if(this.isExample){e=this.createRandomTimes();return e}else{a=true;break}}else{e.push(new Date(c))}}e.sort(function(g,d){return g-d});return a?false:e};this.setFunctionNames("initTime")};CanvasXpress.prototype.initColor=function(){this.validateColor=function(i,e,f){if(i){i=i.toString();i=i.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(i);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(i);var g=(/^#?([0-9abcdef]{6})/i).exec(i);var a=(/^([0-9abcdef]{6})/i).exec(i);if(CanvasXpress.colorNames.hasOwnProperty(i)){i=this.hexToRgb(CanvasXpress.colorNames[i])}else{if(b!=null){i=b[0]}else{if(d!=null){i=d[0]}else{if(g!=null){i=this.hexToRgb(g[0])}else{if(a!=null){i=this.hexToRgb("#"+a[0])}else{i=false}}}}}}i=i&&e!=null?this.addColorTransparency(i,e):i?i:false;return i&&f?this.rgbToHex(i):i};this.darkenLightenColor=function(j,e){j=this.rgbToHex(j).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{if(b&&b.match(/^rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}}};this.rgbToHsl=function(m){var i=this.colorAsArray(m);var a=i[0]/255;var j=i[1]/255;var n=i[2]/255;var o=Math.max(a,j,n);var e=Math.min(a,j,n);var f,p;var c=(o+e)/2;if(o==e){f=0;p=0}else{var k=o-e;p=c>0.5?k/(2-o-e):k/(o+e);switch(o){case a:f=(j-n)/k+(j<n?6:0);break;case j:f=(n-a)/k+2;break;case n:f=(a-j)/k+4;break}f/=6}return"hsl("+Math.floor(f*100)+","+Math.floor(p*100)+"%,"+Math.floor(c*100)+"%)"};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.hslToRgb=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""));var o=Number(j[0].replace(/\s/g,"").replace("%",""));var f=Number(j[0].replace(/\s/g,"").replace("%)",""));if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.addColorTransparency=function(e,d,b){if(!b||this.theme){e=this.validateColor(e)}if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgba("+a[1]+","+Math.min(d,(a[2]!=null?a[2]:1))+")"}else{return false}};this.removeColorTransparency=function(d,b){if(!b||this.theme){d=this.validateColor(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgb("+a[1]+")"}else{return false}};this.isColorTransparency=function(b){b=this.validateColor(b);if(b){var a=b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null?Number(a[2]):null}};this.isColorTransparent=function(d){d=this.validateColor(d);var b;if(d&&d.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null&&a[2]==0?true:false}else{return false}}};this.combineColors=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.mean(e));var h=parseInt(this.mean(d));var m=parseInt(this.mean(n));if(k.length>0){var o=parseFloat(this.mean(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.colorAsArray=function(f){f=this.validateColor(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.monoColor=function(f,d){var b=this.colorAsArray(f);var e=0.3*b[0]+0.59*b[1]+0.11*b[2];if(d!=null){return"rgba("+e+","+e+","+e+","+d+")"}else{return"rgb("+e+","+e+","+e+")"}};this.blindColor=function(R,H){var q=this.colorAsArray(this.validateColor(R,H));var I=q[0];var P=q[1];var S=q[2];var w=[0.7465,0.2535,1.273463,-0.073894];var z=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(I==0&&P==0&&S==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=w;break;case"deuteranopia":l=z;break;case"tritanopia":l=u;break;case"monochromatic":var R=Math.ceil((I*0.212656+I*0.715158+I*0.072186));return"rgb("+R+","+R+","+R+")"}var E=l[0];var C=l[1];var J=l[2];var y=l[3];var n=1;var x=Math.pow(I,2.2);var A=Math.pow(P,2.2);var B=Math.pow(S,2.2);var i=x*0.412424+A*0.357579+B*0.180464;var h=x*0.212656+A*0.715158+B*0.072185;var f=x*0.019332+A*0.119193+B*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var v=(j-C)/(k-E);var K=j-k*v;var e=(y-K)/(v-J);var a=(v*e)+K;i=e*h/a;f=(1-(e+a))*h/a;var N=0.312713*h/0.329016;var L=0.358271*h/0.329016;var F=N-i;var D=L-f;var G=F*3.24071+D*-0.498571;var M=F*-0.969258+D*0.0415557;var Q=F*0.0556352+D*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var T=((G<0?0:1)-d)/G;var m=((M<0?0:1)-o)/M;var p=((Q<0?0:1)-s)/Q;var O=[(T>1||T<0)?0:T,(m>1||m<0)?0:m,(p>1||m<0)?0:p];O=Math.max.apply(null,O);d=d+(O*G);o=o+(O*M);s=s+(O*Q);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);I=Math.ceil(d);P=Math.ceil(o);S=Math.ceil(s);if(I>255){I-=255}if(P>255){P-=255}if(S>255){S-=255}return"rgb("+I+","+P+","+I+")"};this.disableGradientTransparencyShadow=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.resetGradientTransparencyShadow=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.getGradientColor=function(h){if(h.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var f=Math.floor(parseInt(RegExp.$1)/this.gradientRatio);var e=Math.floor(parseInt(RegExp.$2)/this.gradientRatio);var a=Math.floor(parseInt(RegExp.$3)/this.gradientRatio);var d=RegExp.$4?parseFloat(RegExp.$4):false;if(d){return"rgba("+f+","+e+","+a+","+d+")"}else{return"rgb("+f+","+e+","+a+")"}}else{return false}};this.getGradient=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(f,e,d,c,false,false,true)}else{return this.getLinearGradient(f,e,d,c,b,a,true)}};this.getLinearGradient=function(b,i,a,h,d,c,f){if(!f){this.saveCanvas()}var j=this.getCanvasContext();var e=j.createLinearGradient(b,i,a,h);if(!d){d=this.foreground}if(!c){c=this.getGradientColor(d);e.addColorStop(0,c);e.addColorStop(0.6,d);e.addColorStop(1,d)}else{e.addColorStop(0,d);e.addColorStop(0.3,c);e.addColorStop(1,c)}return e};this.getRadialGradient=function(j,h,a,e,d,c,i){if(!i){this.saveCanvas()}var b=a/5.5;var k=this.getCanvasContext();var f=k.createRadialGradient(j-b,h-b,1,j,h,a);if(!e){e=this.foreground}if(!d){if(this.transparency!=null){d="rgba(0,0,0,"+this.transparency+")"}else{d="rgb(0,0,0)"}}if(!c){c="rgba(0,0,0,0)"}f.addColorStop(0,e);f.addColorStop(1,d);f.addColorStop(1,c);return f};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.getColorNames=function(){return this.sortObject(CanvasXpress.colorNames)};this.getColorSchemes=function(){return this.sortObject(CanvasXpress.colorSchemes)};this.getHexColor=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.rgbToHex(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.getColorForValue=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.setColorForValues=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var y=n.max;var p=n.scol.substring(t,q);var z=n.ecol.substring(t,q);var v=d<s?s:d>y?y:d;var i=y-s;var w=parseInt(p,16);var m=parseInt(z,16);var u=(m-w)/i;var o=Math.round(u*(v-s)+w);var x=o.toString(16);return x.length==1?"0"+x:x};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.hexToRgb("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return c(e)}};this.getColorBrew=function(L,C,F,g,f,c){var h=L||this.colorSpectrum;if(C!=null&&F!=null&&C==F){F+=0.1}var G=C!=null?C:this.minData!=null?this.minData:0;var t=F!=null?F:this.maxData!=null?this.maxData:100;var J=!c&&this.setMinX!=null?this.setMinX:null;var x=!c&&this.setMaxX!=null?this.setMaxX:null;var D,w;var M=[];if(g==null){zero=(G+t)/2}else{zero=g;var D=g-G;var w=t-g;if(D>w){t=g+D}else{G=g-w}}var u=this[this.axisAlgorithm](Math.min(J||G,x||t),Math.max(J||G,x||t),5,this.axisWilkinsonLoose);if(t==Math.abs(G)&&g==0&&u.length%2){u[Math.floor(u.length/2)]=0}var H=(u[u.length-1]-u[0])/(h.length-1);var a=this.getAxisDecimals(u[1]-u[0]);var d=this.getMaxText(u);var I=this.measureText(d.toString(),this.font);var q=u[u.length-1]-u[0];var e=q/this.colorSpectrumNumber;if(f&&f.length>1&&f.length==h.length){for(var E=0;E<f.length;E++){f[E]=Number(f[E])}f=f.sort(function(l,i){return l-i});var y=u[0];var B=Math.ceil((this.colorSpectrumNumber-1)/h.length);for(var E=0;E<f.length;E++){var o=f[E];var K=this.seq(y,o,false,B);M=M.concat(K);var m=M.length-1;y=o+(M[m]-M[m-1])}}else{M=this.seq(u[0],u[u.length-1],false,this.colorSpectrumNumber)}while(M.length<this.colorSpectrumNumber){M.push(u[u.length-1])}var A={scol:this.getHexColor(h[0]),ecol:this.getHexColor(h[1]),min:u[0],max:u[0]+H};var k={spectrum:h,stops:f,z:g,colors:[],legend:[],grads:[A],rmin:G,rmax:t,min:u[0],max:u[u.length-1],range:q,zero:zero,vals:u,incr:H,decs:a,breaks:M,maxLevLen:I,maxLevChr:d.toString().length,maxLevStr:d};for(var E=1;E<h.length-1;E++){A={scol:this.getHexColor(h[E]),ecol:this.getHexColor(h[E+1]),min:u[0]+(H*E),max:u[0]+(H*(E+1))};k.grads.push(A)}var j=u[0];for(var E=0;E<this.colorSpectrumNumber;E++){k.colors.push(this.setColorForValues(k,j));j+=e}for(var E=0;E<this.colorSpectrumNumber;E++){j=M[E];k.legend.push(this.setColorForValues(k,j))}return k};this.setColorBrew=function(d,e){this.setColorSpectrum();if(!this.meta.def.colorBrew||d){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var b=this.meta.def.colorBrew;if(e){if(this.isTransformedData){var c=this.minData;var a=this.maxData;switch(this.isTransformedData){case"log2":c=Math.log(c)/Math.LN2;a=Math.log(a)/Math.LN2;break;case"log10":c=Math.log(c)/Math.LN10;a=Math.log(a)/Math.LN10;break;case"exp2":c=Math.pow(2,c);a=Math.pow(2,a);break;case"exp10":c=Math.pow(10,c);a=Math.pow(10,a);break}if(!this.isNumber(c,true)||!this.isNumber(a,true)){c=this.min(this.data.y.trans);a=this.max(this.data.y.trans)}this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,c,a,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData||b.rmin,this.maxData||b.rmax,this.colorSpectrumZeroValue||b.z,this.colorSpectrumBreaks||b.stops)}}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,b.rmin,b.rmax,b.z,b.stops)}}}}};this.getCustomColorScheme=function(f){if(!f){f=8}var b=this.getKeys(CanvasXpress.colorSchemes[this.colorScheme]);b.sort(function(g,d){return g-d});if(CanvasXpress.colorSchemes[this.colorScheme]){if(CanvasXpress.colorSchemes[this.colorScheme][f]){return CanvasXpress.colorSchemes[this.colorScheme][f]}else{if(f>b[b.length-1]){var e=f-b.length;f--;while(!CanvasXpress.colorSchemes[this.colorScheme][f]){f--}var c=CanvasXpress.colorSchemes[this.colorScheme][f];for(var a=0;a<e;a++){c.push(CanvasXpress.colorSchemes[this.colorScheme][f][a%CanvasXpress.colorSchemes[this.colorScheme][f].length])}return c}else{f++;while(!CanvasXpress.colorSchemes[this.colorScheme][f]){f++}return CanvasXpress.colorSchemes[this.colorScheme][f]}}}else{return this.colors}};this.setColorSpectrum=function(){if(this.blindnessType&&!this.meta.def.colorSpectrum){this.meta.def.colorSpectrum=this.cloneObject(this.colorSpectrum);var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{if(this.meta.def.colorSpectrum&&this.meta.def.blindnessTypeSpectrum!=this.blindnessType){if(this.blindnessType){var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{this.colorSpectrum=this.cloneObject(this.meta.def.colorSpectrum)}}}this.meta.def.blindnessTypeSpectrum=this.blindnessType};this.setColorScheme=function(h){var a=false;var e;if(this.colorScheme=="User"){e=this.cloneObject(this.colors)}else{if(this.colorScheme=="ColorSpectrum"){var g=this.colorSpectrumNumber;this.colorSpectrumNumber=this.graphType=="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var j=this.getColorBrew(this.colorSpectrum,0,this.data.y.vars.length);e=j.colors;this.colorSpectrumNumber=g}else{if(CanvasXpress.colorSchemes[this.colorScheme]){var b;var f=this.getKeys(CanvasXpress.colorSchemes[this.colorScheme]);f.sort(function(k,i){return k-i});f=parseInt(f[f.length-1]);if(h&&h.type=="String"){b=h.levels.length}else{if(this.graphType.match(/Scatter/)){b=this.colorBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorBy)&&this.meta.data.z[this.colorBy].colors?this.meta.data.z[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Venn/)){b=this.vennGroups}else{if(this.graphType.match(/Pie/)){b=this.data.y.vars.length}else{if(this.graphType.match(/Network|Genome|Correlation/)){b=f}else{if(this.graphType=="ParallelCoordinates"){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor){b=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.meta.data.x[this.colorBy].levels?this.meta.data.x[this.colorBy].levels.length:this.data.y.vars.length}else{b=this.data.y.vars.length}}}}}}}}}if(CanvasXpress.colorSchemes[this.colorScheme][b]){e=CanvasXpress.colorSchemes[this.colorScheme][b]}else{if(b>f){b--;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b--}}else{b++;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b++}}e=CanvasXpress.colorSchemes[this.colorScheme][b]}if(this.meta.def.colors){this.meta.def.colors=this.cloneObject(e);a=true}}else{e=CanvasXpress.colorSchemes.Balanced[20]}}}if((this.blindnessType&&!this.meta.def.colors)||a){this.meta.def.colors=this.cloneObject(e);if(this.blindnessType){var d=[];for(var c=0;c<e.length;c++){d.push(this.blindColor(e[c]))}e=d}}else{if(this.meta.def.colors&&this.meta.def.blindnessTypeColors!=this.blindnessType){e=this.cloneObject(this.meta.def.colors);if(this.blindnessType){var d=[];for(var c=0;c<e.length;c++){d.push(this.blindColor(e[c]))}e=d}}}this.meta.def.blindnessTypeColors=this.blindnessType;if(!h){this.colors=e}this.updateMetaDataColors(e,h)};this.validateUserColors=function(){var a=[];for(var b=0;b<this.colors.length;b++){a.push(this.validateColor(this.colors[b]))}if(a.length>0){this.colors=a}};this.setFunctionNames("initColor");this.validateUserColors()};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d){var a=this.getCanvasContext();c=this.validateColor(c);if(this.transparency!=null){c=this.addColorTransparency(c,this.transparency)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true)};this.setClipBoundaries=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left;d=this.marginTop+this.offsetY+this.top;a=this.x;e=this.y}return[b,d,a,e]};this.setClipArea=function(a){var e=this.getCanvasContext();this.saveCanvas();var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=[d,f,c,g]};this.resetClipArea=function(){this.restoreCanvas();this.setClipArea([0,0,0,0]);this.restoreCanvas();this.meta.state.clip=false};this.resetStyle=function(){this.setShadow(false)};this.setShadow=function(c){if(this.showShadow){var a=this.getCanvasContext();var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.lineTo=function(c,h,b,g){if(this.graphType=="Network"){return this.lineRawTo(c,h,b,g)}var f=~~(c+0.5);var a=~~(h+0.5);var d=~~(b+0.5);var j=~~(g+0.5);if(Math.abs(f-d)==1){f=(f+d)/2;d=f}else{f+=0.5;d+=0.5}if(Math.abs(a-j)==1){a=(a+j)/2;j=a}else{a+=0.5;j+=0.5}var i=this.getCanvasContext();if(f==d&&a==j){var e=this.lineThickness/1.5;i.fillRect(f,a,e,e)}else{i.moveTo(f,a);i.lineTo(d,j)}i.stroke()};this.lineRawTo=function(c,e,b,d){var a=this.getCanvasContext();a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.lineToOld=function(c,e,b,d){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}var a=this.getCanvasContext();a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.bitCode=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.intersect=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.lineClip=function(n,l,h){var k,j,d,m;if(!l){l=this.setClipBoundaries();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.bitCode(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.bitCode(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.intersect(k,j,e,l);e=this.bitCode(k,l)}else{j=this.intersect(k,j,d,l);d=this.bitCode(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.polygonClip=function(k,j,c){var h,d,g,a,e;if(!j){j=this.setClipBoundaries();j[2]+=j[0];j[3]+=j[1]}if(c){xy=[];for(var f=1;f<k.length;f+=2){xy.push([k[f],k[f+1]])}}else{xy=k}for(var b=1;b<=8;b*=2){h=[];d=xy[xy.length-1];g=!(this.bitCode(d,j)&b);for(var f=0;f<xy.length;f++){a=xy[f];e=!(this.bitCode(a,j)&b);if(e!==g){h.push(this.intersect(d,a,b,j))}if(e){h.push(a)}d=a;g=e}xy=h;if(!xy.length){break}}if(c){k=["poly"];for(var f=0;f<h.length;f++){k.push(h[f][0]);k.push(h[f][1])}return k}return h};this.lineIntersect=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.setClipBoundaries()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.getLineArea=function(P,D,a,B,af,aa,O,T,Q,ab,ac,ad,R,U,V,E){var W=Math.max(O,this.lineWidthEvent);var S=[];var I=["poly"];P=this.validateBezier(P,D,a,B,af,Q,ab);if(P.match(/error/)){if(this.showErrorBars&&this.isNumeric([D,a,B,af,O])){D=Math.ceil(D);B=Math.ceil(B);a=Math.ceil(a);af=Math.ceil(af);O=Math.ceil(O);var K=O/2;if(O>0){I=["poly",D,a-W,B-W,af-W,B-W,af-K,B+W,af-K,B+W,af+K,B-W,af+K,B-W,af+W,D,a+W]}else{I=["poly",B-W,af+W,B-K,af+W,B-K,af-W,B+K,af-W,B+K,af+W,B+W,af+W,D+W,a,D-W,a]}}else{return false}}else{if(P=="spline"||P=="cardinalSpline"){if(D.length<3){return D.length<2?false:this.getLineArea("line",D[0],a[0],D[1],a[1],aa,O,T,Q,ab,ac,ad,R,U,V)}for(var Z=0;Z<D.length;Z++){I.push(D[Z],a[Z]-W);S.push(a[Z]+W,D[Z])}I=I.concat(S.reverse())}else{if(P=="arch"){if(D.length!=3||a.length!=3){return false}for(var Z=0;Z<D.length;Z++){if(!this.isNumeric([D[Z],a[Z]])){return false}}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="arc"){I=["poly"];S=this.traceArc1(D,a,B,Q,ab,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc1(D,a,B-W,Q,ab);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="quadratic"){var v=this.perpendicularLinePoints(D,a,B,af,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(R))*(R>0?-1:1));var C=this.shortenLine(D,a,B,af,Q,ab,P,R);var x=this.parallelLinePoints(C[0],C[1],v[0],v[1],W);var u=this.parallelLinePoints(v[0],v[1],C[2],C[3],W);S=this.traceQuadraticCurve(x[0],x[1],x[4],x[5],u[4],u[5],0.1,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}var M=[];S=this.traceQuadraticCurve(x[2],x[3],x[6],x[7],u[6],u[7],0.1,true);for(var Z=0;Z<S.length;Z++){M.push(S[Z][1],S[Z][0])}I=I.concat(M.reverse())}else{if(P=="roundLine"){I=["poly",D-W,a,D-W,af+W,B,af+W,B,af-W,D+W,af-W,D+W,a]}else{if(this.isNumeric([D,a,B,af])){var G=this.shortenLine(D,a,B,af,(Q||0),(ab||0),P);D=G[0];a=G[1];B=G[2];af=G[3];if(ac){G=this.clip("line",[D,a,B,af],ad);if(G){D=G[0];a=G[1];B=G[2];af=G[3]}else{return false}}if(R&&this.isArray(R)&&R.length>0){if(this.isNumeric2DArray(R)){if(P.match(/bezier/i)){if(R[0].length==6){var ae=[R[0][0],R[0][1]];for(var Z=0;Z<R.length;Z++){ae=ae.concat(R[Z])}ae.push(R[R.length-1][0],R[R.length-1][1]);var d=this.cloneObject(ae);for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]-W,d[2],d[3]-W,d[4],d[5]-W,d[6],d[7]-W,0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}for(var Y=0;Y<6;Y++){d.shift()}}d=this.cloneObject(ae);var M=[];for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]+W,d[2],d[3]+W,d[4],d[5]+W,d[6],d[7]+W,0.1,true);for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}for(var Y=0;Y<6;Y++){d.shift()}}I=I.concat(M.reverse())}else{if(R.length==4){var x=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);var u=this.parallelLinePoints(R[2][0],R[2][1],R[3][0],R[3][1],W);S=this.traceBezierCurve(x[0],x[1],x[4],x[5],u[0],u[1],u[4],u[5],0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}S=this.traceBezierCurve(x[2],x[3],x[6],x[7],u[2],u[3],u[6],u[7],0.1,true);var M=[];for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}I=I.concat(M.reverse())}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[R.length-1][0],R[R.length-1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{if(R.length>2){I=["poly"];var L=[];for(var Z=0;Z<R.length-1;Z++){L.push([R[Z][0],R[Z][1]])}for(var Z=R.length-1;Z>=1;Z--){L.push([R[Z][0],R[Z][1]])}S=this.enlargePolygon(L,W,1);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{return false}}else{if(P.match(/curved/i)){var z=D==B&&a==af&&E;var o=this.lineMidPoint(D,a,B,af);var N=this.lineLength(D,a,o[0],o[1]);var J=(Q||0)/N;var F=(ab||0)/N;var y=P.match(/curvedcc/i)&&D>B?false:!P.match(/curvedcc/i)&&B>=D?true:false;var l=B>=D?Math.asin((o[1]-a)/N):Math.asin(-(o[1]-a)/N);var X=l+Math.PI;var k=[];if(z){if(l<0){l+=Math.PI*2}var r=E.size*1.25;var H=E.size/1.25;switch(E.pos){case"top":k=[D,a-r,H,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":k=[D+r,a-r,H,Math.PI,Math.PI*0.5,false];break;case"right":k=[D+r,a,H,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":k=[D+r,a+r,H,Math.PI*1.5,Math.PI,false];break;case"bottom":k=[D,a+r,H,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":k=[D-r,a+r,H,0,Math.PI*1.5,false];break;case"left":k=[D-r,a,H,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":k=[D-r,a-r,H,Math.PI*0.5,0,false];break}}else{if(B>=D){k=[o[0],o[1],Math.max(0,N),l-F,X+J,y]}else{k=[o[0],o[1],Math.max(0,N),l+J,X-F,y]}}I=["poly"];S=this.traceArc(k[0],k[1],k[2]+W,k[3],k[4],k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc(k[0],k[1],k[2]-W,k[3],k[4],!k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P.match(/bezier/i)){var h=(D+B)/2;var g=(a+af)/2;if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a-W,D,g-W,B,g-W,B,af-W,0.25,true)}else{S=this.traceBezierCurve(D,a-W,h,a-W,h,af-W,B,af-W,0.25,true)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a+W,D,g+W,B,g+W,B,af+W,0.25)}else{S=this.traceBezierCurve(D,a+W,h,a+W,h,af+W,B,af+W,0.25)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(D==B&&a!=af){I=["poly",D-W,a,D+W,a,B+W,af,B-W,af]}else{if(a==af&&D!=B){I=["poly",D,a-W,B,a-W,B,af+W,D,af+W]}else{var A=this.parallelLinePoints(D,a,B,af,W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}}}}else{return false}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?I:this.adjustNetworkObjects(I)}else{return I}};this.setDashDot=function(c){var a=this.getCanvasContext();var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.resetDashDot=function(){var a=this.getCanvasContext();a.lineCap=this.tempCap;a.setLineDash([])};this.validateBezier=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.drawLine=function(M,z,a,x,ac,V,L,Q,O,X,Y,aa,P,R,S,A){this.functionCallerDraw="drawLine";var B=this.getCanvasContext();this.setDashDot(M);M=this.validateBezier(M,z,a,x,ac,O,X);var d=false;var H=function(){var c=Math.sqrt(Math.pow(x-z,2)+Math.pow(ac-a,2));var b=ac>a?this.roundedPolygonRadius/c:(c-this.roundedPolygonRadius)/c;return[z+(b*(x-z)),a+(b*(ac-a))]};var C=function(b){switch(b){case"arrow":d=0;break;case"square":d=1;break;case"round":d=2;break;case"roundDocked":d=false;break}};if(M.match(/error/)){if(this.showErrorBars&&this.isNumeric([z,a,x,ac,L])){z=Math.ceil(z);x=Math.ceil(x);a=Math.ceil(a);ac=Math.ceil(ac);L=Math.ceil(L);var J=L/2;this.setStyle(V,false,Q);if(!this.isColorTransparent(V)){B.beginPath();this.lineTo(z,a,x,ac);if(Math.abs(L)>this.errorBarsWidth){if(L>0){this.lineTo(x,ac-J,x,ac+J)}else{this.lineTo(x-J,ac,x+J,ac)}}}}this.resetStyle()}else{if(M.match(/spline|cardinalSpline/)){if(z.length<3){return z.length<2?false:this.drawLine("line",z[0],a[0],z[1],a[1],V,L,Q,O,X,Y,aa,P,R,S)}var N=[];var Z=[];var W=0;for(var U=0;U<z.length;U++){if(this.isNumeric([z[U],a[U]])){Z.push(z[U],a[U]);W+=2}else{return}}this.setStyle(V,L,Q);if(!this.isColorTransparent(V)){if(M.match(/spline/)){for(var U=0;U<W-4;U+=2){N=N.concat(this.splineControlPoint(Z[U],Z[U+1],Z[U+2],Z[U+3],Z[U+4],Z[U+5]))}B.beginPath();B.moveTo(Z[0],Z[1]);B.quadraticCurveTo(N[0],N[1],Z[2],Z[3]);for(var U=2;U<W-5;U+=2){B.bezierCurveTo(N[2*U-2],N[2*U-1],N[2*U],N[2*U+1],Z[U+2],Z[U+3])}B.moveTo(Z[W-2],Z[W-1]);B.quadraticCurveTo(N[2*W-10],N[2*W-9],Z[W-4],Z[W-3]);B.stroke()}else{Z=this.curvePoints(Z);B.beginPath();B.moveTo(Z[0],Z[1]);for(var U=2;U<Z.length-1;U+=2){B.lineTo(Z[U],Z[U+1])}B.stroke()}}this.resetStyle()}else{if(M.match(/arch/)){if(z.length!=3||a.length!=3){return false}for(var U=0;U<z.length;U++){if(!this.isNumeric([z[U],a[U]])){return false}}this.setStyle(V,L,Q);if(!this.isColorTransparent(V)){B.beginPath();B.moveTo(z[0],a[0]);B.quadraticCurveTo(z[1],a[1],z[2],a[2]);B.stroke()}this.resetStyle()}else{if(M=="arc"){this.setStyle(V,L,Q);B.beginPath();B.arc(z,a,Math.max(0,x),O,X,false);B.stroke();this.resetStyle()}else{if(M=="quadratic"){this.setStyle(V,L,Q);var r=this.perpendicularLinePoints(z,a,x,ac,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(P))*(P>0?-1:1));var y=this.shortenLine(z,a,x,ac,O,X,M,P);var ab=this.traceQuadraticCurve(y[0],y[1],r[0],r[1],y[2],y[3],0.1,true);B.beginPath();B.moveTo(y[0],y[1]);B.quadraticCurveTo(r[0],r[1],y[2],y[3]);B.stroke();this.resetStyle();if(S){z=ab[9][0];a=ab[9][1];x=y[2];ac=y[3];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){z=ab[1][0];a=ab[1][1];x=y[0];ac=y[1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}else{if(M=="roundLine"){this.setStyle(V,L,Q);B.beginPath();B.moveTo(z,a);if(a>ac){B.lineTo(z,ac+this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ac,z+this.roundedPolygonRadius,ac)}else{B.quadraticCurveTo(z,ac,z-this.roundedPolygonRadius,ac)}}else{B.lineTo(z,ac-this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ac,z-this.roundedPolygonRadius,ac)}else{B.quadraticCurveTo(z,ac,z+this.roundedPolygonRadius,ac)}}B.lineTo(x,ac);B.stroke();this.resetStyle();if(S){C(S);this.drawArrowHead(z,ac,x,ac,V,L,d)}if(R){C(R);this.drawArrowHead(z,ac,x,ac,V,L,d,true)}}else{if(this.isNumeric([z,a,x,ac])){var E=this.shortenLine(z,a,x,ac,(O||0),(X||0),M);z=E[0];a=E[1];x=E[2];ac=E[3];if(Y){E=this.clip("line",[z,a,x,ac],aa);if(E){z=E[0];a=E[1];x=E[2];ac=E[3]}else{return false}}if(P&&this.isArray(P)&&P.length>0){var G=P.length-1;if(this.isNumeric2DArray(P)){this.setStyle(V,L,Q);if(M.match(/bezier/i)){if(!this.isColorTransparent(V)){if(P[0].length==6){B.beginPath();B.moveTo(P[0][0],P[0][1]);for(var U=0;U<P.length;U++){B.bezierCurveTo(P[U][0],P[U][1],P[U][2],P[U][3],P[U][4],P[U][5])}B.stroke();var ab;if(S){ab=this.traceBezierCurve(P[G][0],P[G][1],P[G][0],P[G][1],P[G][2],P[G][3],P[G][4],P[G][5],0.1,true);z=ab[9][0];a=ab[9][1];x=ab[10][0];ac=ab[10][1];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){ab=this.traceBezierCurve(P[0][0],P[0][1],P[0][0],P[0][1],P[0][2],P[0][3],P[0][4],P[0][5],0.1,true);z=ab[1][0];a=ab[1][1];x=ab[0][0];ac=ab[0][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}else{if(P.length==4){B.beginPath();B.moveTo(P[0][0],P[0][1]);B.bezierCurveTo(P[1][0],P[1][1],P[2][0],P[2][1],P[3][0],P[3][1]);B.stroke();var ab=this.traceBezierCurve(P[0][0],P[0][1],P[1][0],P[1][1],P[2][0],P[2][1],P[3][0],P[3][1],0.1,true);if(S){z=ab[9][0];a=ab[9][1];x=P[3][0];ac=P[3][1];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){z=ab[1][0];a=ab[1][1];x=P[1][0];ac=P[1][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}else{B.beginPath();B.moveTo(P[0][0],P[0][1]);this.lineTo(P[G][0],P[G][1]);B.stroke();if(S){z=P[G-1][0];a=P[G-1][1];x=P[G][0];ac=P[G][1];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){z=P[0][0];a=P[0][1];x=P[1][0];ac=P[1][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}}}}else{if(!this.isColorTransparent(V)){B.beginPath();this.lineTo(P[0][0],P[0][1],P[1][0],P[1][1]);for(var U=1;U<G;U++){this.lineTo(P[U][0],P[U][1],P[U+1][0],P[U+1][1])}if(S){z=P[G-1][0];a=P[G-1][1];x=P[G][0];ac=P[G][1];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){z=P[0][0];a=P[0][1];x=P[1][0];ac=P[1][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}}this.resetStyle()}else{return false}}else{if(M.match(/curved/i)){var v=z==x&&a==ac&&A;var l=this.lineMidPoint(z,a,x,ac);var K=this.lineLength(z,a,l[0],l[1]);var I=(O||0)/K;var D=(X||0)/K;var u=M.match(/curvedcc/i)&&z>x?false:!M.match(/curvedcc/i)&&x>=z?true:false;var k=x>=z?Math.asin((l[1]-a)/K):Math.asin(-(l[1]-a)/K);var T=k+Math.PI;var j=[];this.setStyle(V,L,Q);if(!this.isColorTransparent(V)){B.beginPath();if(v){if(k<0){k+=Math.PI*2}if(A.dir){S=false;R=A.end}else{S=A.end;R=false}var o=A.size*1.25;var F=A.size/1.25;switch(A.pos){case"top":j=[z,a-o,F,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":j=[z+o,a-o,F,Math.PI,Math.PI*0.5,false];break;case"right":j=[z+o,a,F,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":j=[z+o,a+o,F,Math.PI*1.5,Math.PI,false];break;case"bottom":j=[z,a+o,F,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":j=[z-o,a+o,F,0,Math.PI*1.5,false];break;case"left":j=[z-o,a,F,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":j=[z-o,a-o,F,Math.PI*0.5,0,false];break}}else{if(x>=z){j=[l[0],l[1],Math.max(0,K),k-D,T+I,u]}else{j=[l[0],l[1],Math.max(0,K),k+I,T-D,u]}}B.arc(j[0],j[1],j[2],j[3],j[4],j[5]);var ab=this.traceArc(j[0],j[1],j[2],j[3],j[4],j[5]);B.stroke()}this.resetStyle();if(S){C(S);z=ab[15][0];a=ab[15][1];x=ab[16][0];ac=ab[16][1];this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){z=ab[1][0];a=ab[1][1];x=ab[0][0];ac=ab[0][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}else{if(M.match(/bezier/i)){var h=(z+x)/2;var g=(a+ac)/2;var ab;this.setStyle(V,L,Q);if(!this.isColorTransparent(V)){B.beginPath();B.moveTo(z,a);if(M.match(/beziery/i)){B.bezierCurveTo(z,g,x,g,x,ac);ab=this.traceBezierCurve(z,a,z,g,x,g,x,ac,0.1,true)}else{B.bezierCurveTo(h,a,h,ac,x,ac);ab=this.traceBezierCurve(z,a,h,a,h,ac,x,ac,0.1,true)}B.stroke()}this.resetStyle();if(S){z=ab[9][0];a=ab[9][1];x=ab[10][0];ac=ab[10][1];C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){x=ab[0][0];ac=ab[0][1];z=ab[1][0];a=ab[1][1];C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}else{this.setStyle(V,L,Q);if(!this.isColorTransparent(V)){B.beginPath();if(M.match(/R$/)||this.useRawLines){this.lineRawTo(z,a,x,ac)}else{this.lineTo(z,a,x,ac)}}this.resetStyle();if(S){C(S);this.drawArrowHead(z,a,x,ac,V,L,d)}if(R){C(R);this.drawArrowHead(z,a,x,ac,V,L,d,true)}}}}}else{this.resetDashDot();return false}}}}}}}this.resetDashDot()};this.drawArrowHead=function(v,c,t,b,u,l,h,e){var q=this.getCanvasContext();var s=function(z,C,f,D){var w=[];for(var A=0;A<z.length;A++){w.push([(z[A][0]*Math.cos(C))-(z[A][1]*Math.sin(C)),(z[A][0]*Math.sin(C))+(z[A][1]*Math.cos(C))])}var B=[];for(var A=0;A<w.length;A++){B.push([w[A][0]+f,w[A][1]+D])}return B};var p=this.arrowPointSize;var d=Math.max((p/2)-1,1);var a=Math.max((p*2/3),1);var n=l?l/2:this.outlineWidth/2;var j=l?l*2:this.outlineWidth*2;var o=h==1?[[-n,-p],[-n,p]]:h==0?[[1.5,-0.5],[-p,-d*l],[-p,d*l]]:false;var m=t-v;var k=b-c;this.setStyle(u,h==1?l+2:l);if(h<2){var g=s(o,Math.atan2(k,m),t,b);q.beginPath();q.moveTo(g[0][0],g[0][1]);for(var r=1;r<g.length;r++){if(!isNaN(g[r][0])&&!isNaN(g[r][1])){q.lineTo(g[r][0],g[r][1])}}if(h==0){if(!isNaN(g[0][0])&&!isNaN(g[0][1])){q.lineTo(g[0][0],g[0][1])}q.closePath();q.fill()}else{q.closePath();q.stroke()}}else{if(h==2){q.beginPath();q.arc(t,b,Math.max(0,d*1.3),0,Math.PI*2,true);q.closePath();q.fill()}else{}}this.resetStyle()};this.createPatterns=function(){var h=function(c){c.strokeStyle="rgb(29,137,182)";var j=[4,6,9,12,16,21,27,14,17,21,26];var l=[27,21,16,12,9,6,4,26,21,17,14];for(var k=0;k<j.length;k++){c.moveTo(j[k],l[k]);c.arc(j[k],l[k],2,0,Math.PI*2)}c.moveTo(3,32);c.arc(3,32,2,Math.PI,0);c.moveTo(13,32);c.arc(13,32,2,Math.PI,0);c.moveTo(32,3);c.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);c.moveTo(32,13);c.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);j=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];l=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var k=0;k<j.length;k++){c.moveTo(j[k][0],l[k][0]);c.lineTo(j[k][1],l[k][1])}c.stroke()};var g=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(3,0);c.arc(3,0,2,Math.PI,0,true);c.moveTo(3,5);c.arc(3,5,2,Math.PI,0);c.moveTo(6,1);c.lineTo(8,4);c.lineTo(10,1);c.moveTo(13,0);c.arc(13,0,2,Math.PI,0,true);c.moveTo(13,5);c.arc(13,5,2,Math.PI,0);c.stroke()};var d=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(0,3);c.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,3);c.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);c.moveTo(1,6);c.lineTo(4,8);c.lineTo(1,10);c.moveTo(0,13);c.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,13);c.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);c.stroke()};var b=this.getCanvasContext();var e;var f=this.$cX("canvas");f.width=5;f.height=5;var a=this.get2DCanvasContext(f);a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(f,"repeat");f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(f,"repeat");a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(f,"repeat");f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(f,"repeat");f.width=5;f.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(f,"repeat");a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(f,"repeat");f.width=5;f.height=16;a.clearRect(0,0,5,16);d(a);CanvasXpress.cachePatterns.membraneTop=b.createPattern(f,"repeat-x");f.width=5;f.height=16;a.clearRect(0,0,5,16);a.translate(5,0);a.scale(-1,1);d(a);CanvasXpress.cachePatterns.membraneBottom=b.createPattern(f,"repeat-x");f.width=16;f.height=5;a.clearRect(0,0,16,5);g(a);CanvasXpress.cachePatterns.membraneRight=b.createPattern(f,"repeat-y");f.width=16;f.height=5;a.clearRect(0,0,16,5);a.translate(0,5);a.scale(1,-1);g(a);CanvasXpress.cachePatterns.membraneLeft=b.createPattern(f,"repeat-y");f.width=32;f.height=32;a.clearRect(0,0,32,32);h(a);CanvasXpress.cachePatterns.membraneTL=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(0,32);a.scale(1,-1);h(a);CanvasXpress.cachePatterns.membraneBL=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,0);a.scale(-1,1);h(a);CanvasXpress.cachePatterns.membraneTR=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,32);a.scale(-1,-1);h(a);CanvasXpress.cachePatterns.membraneBR=b.createPattern(f,"no-repeat")};this.sphere=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.roundedPolygon=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.drawShapeSetShapeStyle=function(j,i,k,d,e,c,b,a,g){var l=this.getCanvasContext();this.saveCanvas();this.translateCanvas(j,i);if(a){this.rotateCanvas(a)}if(this.transparency!=null){e=this.addColorTransparency(e,this.transparency)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.getGradient(0,0,Math.max(Math.abs(k),Math.abs(d)),e)}else{l.fillStyle=this.getGradient(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:if(e.match(/0.1\)$/)&&c.match(/0.1\)$/)){l.globalAlpha=0.1}l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.setShadow(true)};this.drawShapeDraw=function(d,c){var b=this.getCanvasContext();if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.drawShapeFillStroke=function(b,d,c){var a=this.getCanvasContext();if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.drawShapeRestore=function(a,d,c){var b=this.getCanvasContext();b.globalAlpha=1;this.setShadow(false);if(c){}this.restoreCanvas()};this.getShapeArea=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.setClipBoundaries()}switch(v){case"arc2":K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.polygonClip(N.concat(K.reverse()),false,true);break;case"violin":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.traceBezierCurve(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceBezierCurve(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.traceQuadraticCurve(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.traceQuadraticCurve(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"path":N=N.concat(K);break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.getShapeArea("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.getShapeArea("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.getShapeArea("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.getShapeArea("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.getShapeArea("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.getShapeArea("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.adjustNetworkObjects(N)}else{return N}};this.drawShape=function(X,S,R,U,al,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap){this.functionCallerDraw="drawShape";var P,at,j,av,aa,af;var L=this.getCanvasContext();if(ab){switch(ab){case"closed":case"solid":case"open":break;default:var aw=ab;ab="closed";this.drawShape(X,S,R,U,al,am,am,ab,Z,Q,ar,au,Y,ao,V,ap);ab=aw;break}}switch(X){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":var ah=Number.MAX_VALUE;var O=Number.MAX_VALUE*-1;var ag=Number.MAX_VALUE;var M=Number.MAX_VALUE*-1;at=[];P=[];if(S.length==R.length){if(X=="spline"&&S.length<5){return this.drawShape("polygon",S,R,U,al,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap)}if(X=="arch"&&(S.length!=6||R.length!=6||U.length!=4||al.length!=2)){return false}if(X=="bezier"){if(this.isNumeric(S)&&this.isNumeric(R)&&this.isNumeric(al)){for(var ak=0;ak<S.length;ak++){ah=Math.min(ah,S[ak]);O=Math.max(O,S[ak]);ag=Math.min(ag,R[ak]);M=Math.max(M,R[ak]);P.push([S[ak],R[ak]])}S=(ah+O)/2;R=(ag+M)/2;for(var ak=0;ak<P.length;ak++){P[ak][0]-=S;P[ak][1]-=R;at.push(P[ak][0],P[ak][1])}}else{return false}}else{if(X=="confidence"){for(var ak=0;ak<S.length;ak++){if(S[ak][0]!=null&&S[ak][1]!=null&&R[ak][0]!=null&&R[ak][1]!=null&&this.isNumeric([S[ak][0],S[ak][1],R[ak][0],R[ak][1]])){ah=Math.min(ah,Math.min(S[ak][0],S[ak][1]));O=Math.max(O,Math.max(S[ak][0],S[ak][1]));ag=Math.min(ag,Math.min(R[ak][0],R[ak][1]));M=Math.max(M,Math.max(R[ak][0],R[ak][1]));P.push([[S[ak][0],S[ak][1]],[R[ak][0],R[ak][1]]])}}S=(ah+O)/2;R=(ag+M)/2;for(var ak=0;ak<P.length;ak++){P[ak][0][0]-=S;P[ak][0][1]-=S;P[ak][1][0]-=R;P[ak][1][1]-=R;at.push([P[ak][0][0],P[ak][0][1]],[P[ak][1][0],P[ak][1][1]])}}else{if(X=="violin"){if(S[0].length==R[0].length&&S[1].length==R[1].length&&S[0].length==S[1].length){for(var ak=0;ak<S[0].length;ak++){if(this.isNumeric([S[0][ak],S[1][ak],R[0][ak],R[1][ak]])){ah=Math.min(ah,Math.min(S[0][ak],S[1][ak]));O=Math.max(O,Math.max(S[0][ak],S[1][ak]));ag=Math.min(ag,Math.min(R[0][ak],R[1][ak]));M=Math.max(M,Math.max(R[0][ak],R[1][ak]));P.push([[S[0][ak],S[1][ak]],[R[0][ak],R[1][ak]]])}}S=(ah+O)/2;R=(ag+M)/2;for(var ak=0;ak<P.length;ak++){P[ak][0][0]-=S;P[ak][0][1]-=S;P[ak][1][0]-=R;P[ak][1][1]-=R;at.push([P[ak][0][0],P[ak][0][1]],[P[ak][1][0],P[ak][1][1]])}}else{return false}}else{for(var ak=0;ak<S.length;ak++){if(S[ak]&&R[ak]&&this.isNumeric([S[ak],R[ak]])){ah=Math.min(ah,S[ak]);O=Math.max(O,S[ak]);ag=Math.min(ag,R[ak]);M=Math.max(M,R[ak]);P.push([S[ak],R[ak]])}}S=X=="arch"?S[1]:(ah+O)/2;R=X=="arch"?R[1]:(ag+M)/2;for(var ak=0;ak<P.length;ak++){P[ak][0]-=S;P[ak][1]-=R;at.push(P[ak][0],P[ak][1])}}}}}else{return false}break;default:if(this.isNumeric([S,R,U,al])){if(ar){P=this.clip(X,[S,R,U,al],au);if(P){if(P.length==4){U=Math.max(1,P[2]);al=Math.max(1,P[3]);S=P[0]+(U/2);R=P[1]+(al/2)}else{if(P.length==2){S=P[0];R=P[1]}}}else{return false}}else{U=Math.max(1,U);al=Math.max(1,al)}j=U/2;av=al/2;aa=al/U;af=1.5}else{return false}break}switch(X){case"image":if(V&&(CanvasXpress.cacheImages[this.getFileName(V)]||CanvasXpress.images[V])){this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);if(CanvasXpress.images[V]){this.drawImage(CanvasXpress.images[V],-j*this.zoom,-av*this.zoom,U*this.zoom,al*this.zoom,false,false,false,false,am)}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(V)],-j*this.zoom,-av*this.zoom,U*this.zoom,al*this.zoom,false,false,false,false,am)}}else{return this.drawShape("rectangle",S,R,U,al,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",ab,Z,Q,ar,au,Y,ao,V,ap)}break;case"circle":case"sphere":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);if(!this.isColorTransparent(am)||!this.isColorTransparent(ac)){L.beginPath();L.arc(0,0,Math.max(0,U/2),0,Math.PI*2,false);L.closePath();this.drawShapeFillStroke(am,ac,ab)}break;case"arrow":P=[[-j,-av],[j,-av],[j,av],[-j,av]];if(Z){Z=false;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);var D=al/4;L.beginPath();L.moveTo(j-al,-av);L.lineTo(j-al,-av-D);L.lineTo(j,0);L.lineTo(j-al,av+D);L.lineTo(j-al,av);L.lineTo(-j,av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab)}else{this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);var q=U/4;L.beginPath();L.moveTo(-j,-av+U);L.lineTo(-j-q,-av+U);L.lineTo(0,-av);L.lineTo(j+q,-av+U);L.lineTo(j,-av+U);L.lineTo(j,av);L.lineTo(-j,av);L.closePath();this.drawShapeFillStroke(am,ac,ab)}break;case"box":case"rect":P=[[-j,-av],[j,-av],[j,av],[-j,av]];this.drawShapeSetShapeStyle(Math.round(S),Math.round(R),U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(j,-av);L.lineTo(j,av);L.lineTo(-j,av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"rectangle":P=[[-j,-av],[j,-av],[j,av],[-j,av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);if(ab&&ab=="open"){L.strokeRect(-j,-av,U,al)}else{if(ac==am||L.strokeStyle==L.fillStyle){L.fillRect(-j,-av,U,al)}else{L.fillRect(-j,-av,U,al);L.strokeRect(-j,-av,U,al)}}break;case"rect2":return this.drawShape("rectangle",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"rect3":return this.drawShape("rectangle",S,R,U,U/3,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"roundrectt":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av+T);L.lineTo(-j,av);L.lineTo(j,av);L.lineTo(j,-av+T);L.quadraticCurveTo(j,-av,j-T,-av);L.lineTo(-j+T,-av);L.quadraticCurveTo(-j,-av,-j,-av+T);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrectb":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(-j,av-T);L.quadraticCurveTo(-j,av,-j+T,av);L.lineTo(j-T,av);L.quadraticCurveTo(j,av,j,av-T);L.lineTo(j,-av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrectr":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(-j,av);L.lineTo(j-T,av);L.quadraticCurveTo(j,av,j,av-T);L.lineTo(j,-av+T);L.quadraticCurveTo(j,-av,j-T,-av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrectl":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av+T);L.lineTo(-j,av-T);L.quadraticCurveTo(-j,av,-j+T,av);L.lineTo(j,av);L.lineTo(j,-av);L.lineTo(-j+T,-av);L.quadraticCurveTo(-j,-av,-j,-av+T);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrecttr":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(-j,av);L.lineTo(j,av);L.lineTo(j,-av+T);L.quadraticCurveTo(j,-av,j-T,-av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrecttl":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av+T);L.lineTo(-j,av);L.lineTo(j,av);L.lineTo(j,-av);L.lineTo(-j+T,-av);L.quadraticCurveTo(-j,-av,-j,-av+T);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrectbr":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(-j,av);L.lineTo(j-T,av);L.quadraticCurveTo(j,av,j,av-T);L.lineTo(j,-av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrectbl":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al:U;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.lineTo(-j,av-T);L.quadraticCurveTo(-j,av,-j+T,av);L.lineTo(j,av);L.lineTo(j,-av);L.lineTo(-j,-av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrecto":var T=U<al?j:av;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();if(U<al){L.arc(0,-av+T,T,Math.PI,0);L.lineTo(j,av-T);L.arc(0,av-T,T,0,Math.PI);L.lineTo(-j,-av+T)}else{L.arc(-j+T,0,T,Math.PI*0.5,Math.PI*1.5);L.lineTo(j-T,-av);L.arc(j-T,0,T,Math.PI*1.5,Math.PI*0.5);L.lineTo(-j+T,av)}L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"roundrect":case"roundrect2":case"roundrectd":var T=U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius?this.roundedPolygonRadius:U>al?al/4:U/4;if(X=="roundrect2"){T*=4}this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av+T);L.lineTo(-j,av-T);L.quadraticCurveTo(-j,av,-j+T,av);L.lineTo(j-T,av);L.quadraticCurveTo(j,av,j,av-T);L.lineTo(j,-av+T);L.quadraticCurveTo(j,-av,j-T,-av);L.lineTo(-j+T,-av);L.quadraticCurveTo(-j,-av,-j,-av+T);L.closePath();this.drawShapeFillStroke(am,ac,ab);if(X=="roundrectd"&&U>this.roundedPolygonRadius&&al>this.roundedPolygonRadius){U-=this.roundedPolygonRadius;al-=this.roundedPolygonRadius;j=U/2;av=al/2;L.beginPath();L.moveTo(-j,-av+T);L.lineTo(-j,av-T);L.quadraticCurveTo(-j,av,-j+T,av);L.lineTo(j-T,av);L.quadraticCurveTo(j,av,j,av-T);L.lineTo(j,-av+T);L.quadraticCurveTo(j,-av,j-T,-av);L.lineTo(-j+T,-av);L.quadraticCurveTo(-j,-av,-j,-av+T);L.closePath();this.drawShapeFillStroke(am,ac,ab)}break;case"brace":var T=U>al?al/4:U/4;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(-j,-av);L.bezierCurveTo(-j,0,0,0,0,av);L.bezierCurveTo(0,0,j,0,j,-av);this.drawShapeFillStroke(am,ac,ab);break;case"square":P=[[-j,-j],[j,-j],[j,j],[-j,j]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"triangle":if(U==al){return this.drawShape("equilateral",S,R,U,al,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap)}P=[[0,-av],[j,av],[-j,av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"triangle2":if(U==al){return this.drawShape("equilateral2",S,R,U,al,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap)}P=[[0,av],[j,-av],[-j,-av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"equilateral":var T=U*Math.sqrt(3)/6;var g=T/2;var F=Math.sqrt((T*T)-(g*g));P=[[0,-av],[j,av],[-j,av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"equilateral2":var T=U*Math.sqrt(3)/6;var g=T/2;var F=Math.sqrt((T*T)-(g*g));P=[[0,av],[j,-av],[-j,-av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"diamond":case"rhombus":P=[[0,-av],[j,0],[0,av],[-j,0]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"hexagon":var aq=U/3;var v=aq-j;P=[[v,-av],[-v,-av],[j,0],[-v,av],[v,av],[-j,0]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"pentagon":var aq=U/3;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();for(var ak=0;ak<5;ak++){var E=(ak/5)*Math.PI*2+(-Math.PI/2);L.lineTo(Math.cos(E)*aq,Math.sin(E)*aq)}L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"octagon":var ax=U/4;var aj=al/4;P=[[-ax,-av],[ax,-av],[j,-aj],[j,aj],[ax,av],[-ax,av],[-j,aj],[-j,-aj]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"oval":case"ovald":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.saveCanvas();this.scaleCanvas(1,aa);L.beginPath();L.arc(0,0,Math.max(0,U/2),0,Math.PI*2,true);L.closePath();this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab);if(X=="ovald"){U-=this.margin*2;al-=this.margin*2;aa=al/U;this.saveCanvas();this.scaleCanvas(1,aa);L.beginPath();L.arc(0,0,Math.max(0,U/2),0,Math.PI*2,true);L.closePath();this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab)}break;case"oval2":return this.drawShape("oval",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"oval3":return this.drawShape("oval",S,R,U,U/3,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"arc":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.saveCanvas();this.scaleCanvas(1,aa);L.beginPath();L.arc(0,0,Math.max(0,U/2),0,Math.PI,true);if(ab!="open"){L.closePath()}this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab);break;case"arc2":var H=al*Math.cos(Y);var aA=al*Math.sin(Y);var G=al*Math.cos(ao);var ay=al*Math.sin(ao);var C=this.shortenLine(0,0,H,aA,0,U,"line");var A=this.shortenLine(0,0,G,ay,0,U,"line");this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(C[2],C[3]);L.lineTo(H,aA);L.arc(0,0,Math.max(0,al),Y,ao,false);L.lineTo(A[2],A[3]);L.arc(0,0,Math.max(0,al-U),ao,Y,true);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"arc3":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.saveCanvas();this.scaleCanvas(1,aa);L.beginPath();L.arc(0,0,Math.max(0,U/2),0,Math.PI,true);this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab);break;case"arch":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(P[0][0],P[0][1]);L.quadraticCurveTo(P[1][0],P[1][1],P[2][0],P[2][1]);L.arc(0,0,Math.max(0,al[0]),U[3],U[2],true);L.quadraticCurveTo(P[4][0],P[4][1],P[5][0],P[5][1]);L.arc(0,0,Math.max(0,al[1]),U[1],U[0],true);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"path":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P,ab=="open");this.drawShapeFillStroke(am,ac,ab);break;case"roundpolygon":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);P=this.roundedPolygon(P);L.beginPath();for(var ak=0;ak<P.length;ak++){L.arc(P[ak][0],P[ak][1],P[ak][2],P[ak][3],P[ak][4])}L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"polygon":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P,ab=="open");this.drawShapeFillStroke(am,ac,ab);break;case"spline":var W=[];var ae=[];var I=[];ae.push(at.shift());ae.push(at.shift());I.push(at.pop());I.unshift(at.pop());var ad=at.length;for(var ak=0;ak<ad-4;ak+=2){W=W.concat(this.splineControlPoint(at[ak],at[ak+1],at[ak+2],at[ak+3],at[ak+4],at[ak+5]))}this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(ae[0],ae[1]);L.lineTo(at[0],at[1]);L.quadraticCurveTo(W[0],W[1],at[2],at[3]);for(var ak=2;ak<ad-5;ak+=2){L.bezierCurveTo(W[2*ak-2],W[2*ak-1],W[2*ak],W[2*ak+1],at[ak+2],at[ak+3])}L.quadraticCurveTo(W[2*ad-10],W[2*ad-9],at[ad-2],at[ad-1]);L.lineTo(I[0],I[1]);L.lineTo(ae[0],ae[1]);this.drawShapeFillStroke(am,ac,ab);break;case"hull":var ai;var ad=1;var J=[];while(at.length>1){J.push([at.shift(),at.shift()])}var W=this.hullControlPoints(J);var m=[[J[0][0],J[0][1],W[W.length-1][0],W[W.length-1][1],W[0][0],W[0][1],J[1][0],J[1][1]]];for(var ak=1;ak<J.length-1;ak++){m.push([J[ak][0],J[ak][1],W[ad][0],W[ad][1],W[ad+1][0],W[ad+1][1],J[ak+1][0],J[ak+1][1]]);ad+=2}m.push([J[ak][0],J[ak][1],W[ad][0],W[ad][1],W[ad+1][0],W[ad+1][1],J[0][0],J[0][1]]);this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(m[0][0],m[0][1]);for(var ak=0;ak<m.length;ak++){L.bezierCurveTo(m[ak][2],m[ak][3],m[ak][4],m[ak][5],m[ak][6],m[ak][7])}this.drawShapeFillStroke(am,ac,ab);break;case"violin":var ad=at.length;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(at[0][0],at[1][0]);for(var ak=2;ak<ad;ak+=2){L.lineTo(at[ak][0],at[ak+1][0])}L.lineTo(at[ad-2][1],at[ad-1][1]);for(var ak=2;ak<ad;ak+=2){var az=(ad-1)-ak;L.lineTo(at[az-1][1],at[az][1])}L.lineTo(at[0][0],at[1][0]);this.drawShapeFillStroke(am,ac,ab);break;case"confidence":var ad=at.length;var W=[];var N=[];for(var ak=0;ak<ad-4;ak+=2){var az=(ad-1)-ak;W=W.concat(this.splineControlPoint(at[ak][0],at[ak+1][0],at[ak+2][0],at[ak+3][0],at[ak+4][0],at[ak+5][0]));N=N.concat(this.splineControlPoint(at[az-1][1],at[az][1],at[az-3][1],at[az-2][1],at[az-5][1],at[az-4][1]))}this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(at[0][0],at[1][0]);L.quadraticCurveTo(W[0],W[1],at[2][0],at[3][0]);for(var ak=2;ak<ad-5;ak+=2){L.bezierCurveTo(W[2*ak-2],W[2*ak-1],W[2*ak],W[2*ak+1],at[ak+2][0],at[ak+3][0])}L.quadraticCurveTo(W[2*ad-10],W[2*ad-9],at[ad-2][0],at[ad-1][0]);L.lineTo(at[ad-2][1],at[ad-1][1]);L.quadraticCurveTo(N[0],N[1],at[ad-4][1],at[ad-3][1]);for(var ak=2;ak<ad-5;ak+=2){var az=(ad-1)-ak;L.bezierCurveTo(N[2*ak-2],N[2*ak-1],N[2*ak],N[2*ak+1],at[az-3][1],at[az-2][1])}L.quadraticCurveTo(N[2*ad-10],N[2*ad-9],at[0][1],at[1][1]);L.lineTo(at[0][0],at[1][0]);this.drawShapeFillStroke(am,ac,ab);break;case"bezier":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(at[0],at[1]);L.bezierCurveTo(at[2],at[3],at[4],at[5],at[6],at[7]);L.lineTo(at[6],at[7]+al);L.bezierCurveTo(at[4],at[5]+al,at[2],at[3]+al,at[0],at[1]+al);L.lineTo(at[0],at[1]);this.drawShapeFillStroke(am,ac,ab);break;case"ellipse":var a=j*0.5522848;var an=av*0.5522848;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.moveTo(0,av);L.bezierCurveTo(0,av-an,j-a,0,j,0);L.bezierCurveTo(j+a,0,U,av-an,U,av);L.bezierCurveTo(U,av+an,j+a,al,j,al);L.bezierCurveTo(j-a,al,0,av+an,0,av);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"ellipse2":return this.drawShape("ellipse",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"ellipse3":return this.drawShape("ellipse",S,R,U,U/3,am,ac,ab,Z,Q,ar,au,Y,ao,V,ap);break;case"plus":P=[[-af,-av],[af,-av],[af,-af],[j,-af],[j,af],[af,af],[af,av],[-af,av],[-af,af],[-j,af],[-j,-af],[-af,-af],[-af,-av]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"minus":P=[[-j,-af],[j,-af],[j,af],[-j,af],[-j,-af]];this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.drawShapeDraw(P);this.drawShapeFillStroke(am,ac,ab);break;case"mdavid":var aq=U/3;var B=Math.PI/6;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.saveCanvas();this.scaleCanvas(0.8,0.8);this.rotateCanvas(K*0.45);L.beginPath();L.moveTo(aq,0);for(var ak=0;ak<11;ak++){this.rotateCanvas(B);if(ak%2==0){L.lineTo((aq/0.55),0)}else{L.lineTo(aq,0)}}L.closePath();this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab);break;case"star":var k=(U/4);var K=Math.PI/5;this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);this.saveCanvas();this.scaleCanvas(0.7,0.7);this.rotateCanvas(K*0.45);L.beginPath();L.moveTo(k,0);for(var ak=0;ak<9;ak++){this.rotateCanvas(K);if(ak%2==0){L.lineTo((k/0.35),0)}else{L.lineTo(k,0)}}L.closePath();this.restoreCanvas();this.drawShapeFillStroke(am,ac,ab);break;case"pie":if(typeof(Y)=="undefined"){Y=0}if(typeof(ao)=="undefined"){ao=Math.PI*2}this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);L.beginPath();L.arc(0,0,Math.max(0,U/2),Y,ao,false);L.lineTo(0,0);L.closePath();this.drawShapeFillStroke(am,ac,ab);break;case"pie0":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI/5,V,ap);break;case"pie1":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI/3.5,V,ap);break;case"pie2":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI/2,V,ap);break;case"pie3":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI/1.5,V,ap);break;case"pie4":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI,V,ap);break;case"pie5":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI*1.2,V,ap);break;case"pie6":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI*1.4,V,ap);break;case"pie7":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI*1.6,V,ap);break;case"pie8":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI*1.8,V,ap);break;case"pie9":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,0,Math.PI*2,V,ap);break;case"pacman":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,Math.PI*1/4,Math.PI*7/4,V,ap);break;case"pacman2":return this.drawShape("pie",S,R,U,U/2,am,ac,ab,Z,Q,ar,au,Math.PI*5/4,Math.PI*3/4,V,ap);break;case"pch0":this.drawShape("square",S,R,U,U,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch1":this.drawShape("circle",S,R,U,U,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch2":this.drawShape("equilateral",S,R,U,U,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch3":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,"open",false,Q);L.moveTo(0,-av);this.lineTo(0,-av,0,av);L.stroke();L.moveTo(-j,0);this.lineTo(-j,0,j,0);L.stroke();this.drawShapeFillStroke(am,ac,ab);break;case"pch4":this.drawShapeSetShapeStyle(S,R,U,al,am,ac,"open",false,Q);L.moveTo(-j,-av);this.lineTo(-j,-av,j,av);L.stroke();L.moveTo(j,-av);this.lineTo(j,-av,-j,av);L.stroke();this.drawShapeFillStroke(am,ac,ab);break;case"pch5":this.drawShape("diamond",S,R,U,U,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch6":this.drawShape("equilateral2",S,R,U,U,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch7":this.drawShape("pch0",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch4",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch8":this.drawShape("pch3",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch4",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch9":this.drawShape("pch3",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch5",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch10":this.drawShape("pch1",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch3",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch11":this.drawShape("pch2",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch6",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch12":this.drawShape("pch0",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch3",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch13":this.drawShape("pch1",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch4",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch14":this.drawShape("pch0",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);this.drawShape("pch6",S,R,U,al,am,ac,"open",false,Q,ar,au,Y,ao,V,ap);break;case"pch15":case"pch22":this.drawShape("square",S,R,U,U,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch16":case"pch21":this.drawShape("circle",S,R,U,U,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch17":case"pch24":this.drawShape("equilateral",S,R,U,U,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch18":case"pch23":this.drawShape("diamond",S,R,U,U,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch19":this.drawShape("circle",S,R,U+2,U+2,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch20":this.drawShape("circle",S,R,Math.max(2,U-2),Math.max(2,U-2),am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;case"pch25":this.drawShape("equilateral2",S,R,U,U,am||this.foreground,ac,"closed",false,Q,ar,au,Y,ao,V,ap);break;default:this.drawShapeSetShapeStyle(S,R,U,al,am,ac,ab,Z,Q);break}if(X=="box"||X=="rect"){this.drawShapeRestore(Math.round(S),Math.round(R),Z)}else{this.drawShapeRestore(S,R,Z)}};this.imageToCanvas=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.get2DCanvasContext(b);b.ctx.drawImage(a,0,0);return b};this.colorizeImage=function(e,k){var m=this.imageToCanvas(e);var b=k?this.colorAsArray(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.drawImage=function(c,a,p,k,f,b,q,m,d,n){var o=this.getCanvasContext();try{a=parseInt(Math.round(a||0));p=parseInt(Math.round(p||0));k=parseInt(Math.round(k||c.naturalWidth));f=parseInt(Math.round(f||c.naturalHeight));if(b&&q&&m&&d){b=parseInt(Math.round(b));q=parseInt(Math.round(q));m=parseInt(Math.round(m));d=parseInt(Math.round(d));o.drawImage(c,a,p,k,f,b,q,m,d);o.drawImage(this.colorizeImage(c,n),a,p,k,f,b,q,m,d)}else{if(n&&n=="b&w"){o.drawImage(this.colorizeImage(c),a,p,k,f)}else{if(n){o.drawImage(c,a,p,k,f);o.drawImage(this.colorizeImage(c,n),a,p,k,f)}else{o.drawImage(c,a,p,k,f)}}}}catch(j){console.log(j);var g=this;setTimeout(function(){g.draw()},100)}};this.setGlobalCompositionOperation=function(b){if(!CanvasXpress.system.isIE&&b){var a=this.getCanvasContext();a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.rectangleClear=function(a,e,c,d){var b=this.getCanvasContext();b.clearRect(a,e,c,d)};this.translateCanvas=function(a,c){var b=this.getCanvasContext();b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.rotateCanvas=function(b){var a=this.getCanvasContext();a.rotate(b);this.meta.state.rotate[0]+=b};this.scaleCanvas=function(a,c){var b=this.getCanvasContext();b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.saveCanvas=function(){var a=this.getCanvasContext();a.save();this.meta.state.save++;this.meta.state.last={translate:[this.meta.state.translate[0],this.meta.state.translate[1]],scale:[this.meta.state.scale[0],this.meta.state.scale[1]],rotate:[this.meta.state.rotate[0]]}};this.restoreCanvas=function(){var a=this.getCanvasContext();a.restore();this.meta.state.translate[0]=this.meta.state.last.translate[0];this.meta.state.translate[1]=this.meta.state.last.translate[1];this.meta.state.scale[0]=this.meta.state.last.scale[0];this.meta.state.scale[1]=this.meta.state.last.scale[1];this.meta.state.rotate[0]=this.meta.state.last.rotate[0];this.meta.state.save--};this.setFunctionNames("initAttributes")};CanvasXpress.prototype.initRangeAlgorithms=function(){this.heckbert=function(d,k,b){var c=function(i,m){var o;var p=Math.floor(Math.log(i)/Math.LN10);var n=i/Math.pow(10,p);if(m){if(n<1.5){o=1}else{if(n<3){o=2}else{if(n<7){o=5}else{o=10}}}}else{if(n<1){o=1}else{if(n<2){o=2}else{if(n<5){o=5}else{o=10}}}}return o*Math.pow(10,p)};if(d>k){var f=k;d=k;d=f}else{if(k-d<1e-8){k+=0.1}}var j=[];var g=c(k-d,false);var l=c(g/(b-1),true);var a=Math.floor(d/l)*l;var h=Math.ceil(k/l)*l;for(var e=a;e<=h;e+=l){j.push(this.approx(e))}if(j[0]==j[j.length-1]){var j=[];for(var e=a;e<=h;e+=l){j.push(e)}}return j};this.wilkinson=function(c,h,a){var b=function(z,B,A,y){var u=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var w=B-z;var r=A-1;var o=1-Math.abs(A-y)/y;var D=w/r;var t=Math.floor(Math.log(D)/Math.LN10);var E=Math.pow(10,t);var p=null;for(var C=0;C<u.length;C++){var s=u[C]*E;var F=Math.floor(z/s)*s;var n=F+r*s;if(F<=z&&n>=B){var v=1-(C-(F<=0&&n>=0?1:0))/u.length;var q=(B-z)/(n-F);if(q>0.8){var x=o+v+q;if(p==null||x>p.score){p={lmin:F,lmax:n,lstep:s,score:x}}}}}if(!p){p={lmin:z,lmax:B,lstep:1,score:0}}return p};if(c>h){var g=h;c=h;c=g}else{if(h-c<1e-8){h+=0.1}}var j=[];var e=null;var l=[];for(var f=Math.max(Math.floor(a/2),2);f<=Math.ceil(6*a);f++){l.push(f)}for(var f=0;f<l.length;f++){var d=l[f];var m=b(c,h,d,a);if((m!=null&&e==null)||(m&&e&&m.score>e.score)){e=m}}for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(this.approx(f))}if(j[0]==j[j.length-1]){var j=[];for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(f)}}return j};this.wilkinsonExtended=function(a,y,R,C){var A=2.22e-14;var f=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var J=function(c,w,m,g,z,Y){var k=w.length;var s=f(c,w);var Z=(g%Y<A||Y-(g%Y)<A)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+Z};var K=function(s,m,g){var w=m.length;var k=f(s,m);var c=1;return 1-k/(w-1)-g+c};var h=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var r=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var o=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var X=function(g,c){return g>=c?2-(g-1)/(c-1):1};var e=[1,5,2,2.5,4,3];var G=[0.25,0.2,0.5,0.05];var P=e.length;var L={score:-2};var H=[];if(a>y){var l=a;a=y;y=l}else{if(y-a<1e-8){y+=0.1}}if(y-a<A){for(var U=0;U<=R;U++){H.push(a)}return H}var T=1;while(T<Number.POSITIVE_INFINITY){for(var U=0;U<P;U++){var N=e[U];var u=K(N,e,T);if((G[0]*u+G[1]+G[2]+G[3]<L.score)){T=Number.POSITIVE_INFINITY;break}var S=2;while(S<Number.POSITIVE_INFINITY){var p=X(S,R);if((G[0]*u+G[1]+G[2]*p+G[3]<L.score)){break}var E=(y-a)/(S+1)/T/N;var F=Math.ceil(Math.log(E)/Math.LN10);while(F<Number.POSITIVE_INFINITY){var D=T*N*Math.pow(10,F);var B=r(a,y,D*(S-1));if((G[0]*u+G[1]*B+G[2]*p+G[3]<L.score)){break}var v=Math.floor(y/D)*T-(S-1)*T;var O=Math.ceil(a/D)*T;if(v>O){F++;continue}for(var x=v;x<=O;x++){var t=x*(D/T);var M=t+D*(S-1);var d=D;var I=J(N,e,T,t,M,d);var W=h(a,y,t,M);var V=o(S,R,a,y,t,M);var b=G[0]*I+G[1]*W+G[2]*V+G[3];if(b>L.score&&(!C||(t<=a&&M>=y))){L={lmin:t,lmax:M,lstep:d,score:b}}}F++}S++}}T++}for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(this.approx(U))}if(H[0]==H[H.length-1]){var H=[];for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(U)}}return H};this.rPretty=function(o,p,r){if(o>p){var w=p;o=p;o=w}else{if(p-o<1e-8){p+=0.1}}var a,e,b;var l=[];var q=Math.floor(r)-1;var s=Math.floor(q%3);var g=0.75;var v=1.5;var d=0.5+1.5*v;var f=p-o;if(f==0&&p==0){a=1;e=true;b=1}else{a=Math.max(Math.abs(o),Math.abs(p));b=1+d>=1.5*v+0.5?1/(1+v):1.5/1+d;e=f<(a*b*Math.max(1,q)*1e-7*3)}if(e){if(a>10){a=9+a/10}a=a*g;if(s>1){a/=s}}else{a=f;if(q>1){a/=q}}if(a<20*1e-7){a=20*1e-7}var c=Math.pow(10,Math.floor(Math.log(a)/Math.LN10));var j=c;if((2*c)-a<v*(a-j)){j=2*c;if((5*c)-a<d*(a-j)){j=5*c;if((10*c)-a<v*(a-j)){j=10*c}}}var y=Math.floor(o/j+1e-7);var x=Math.ceil(p/j-1e-7);while(y*j>o+(1e-7*j)){y--}while(x*j<p-(1e-7*j)){x++}var t=Math.floor(0.5+x-y);if(t<s){t=s-t;if(y>=0){x+=t/2;y=y-t/2+t%2}else{y-=t/2;x=x+t/2+t%2}q=s}else{q=t}for(var u=y*j;u<=x*j;u+=j){l.push(this.approx(u))}if(l[0]==l[l.length-1]){var l=[];for(var u=y*j;u<=x*j;u+=j){l.push(u)}}return l};this.getAxisDecimals=function(a){a=this.approx(a).toString();return a.indexOf(".")>=0?Math.min(Number(a.length-(a.indexOf(".")+1)),20):0};this.setFunctionNames("initRangeAlgorithms")};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(c,g,h,f,j){this.functionCaller="modifyObjectArray";if(this.isTransition()){return}var e=this[h];if(f){var a={};if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(this.isInArray(d,e)){e=this.removeFromArray(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.draw()}};this.getObjectArray=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.getObjectArrayOrder=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c].toString()]=c}}return d};this.isInArray=function(e,b){if(this.isArray(b)){var c=this.getObjectArray(b);if(this.isArray(e)){var f=e.length;for(var d=0;d<f;d++){if(c.hasOwnProperty(e[d])){return true}}return false}else{return c.hasOwnProperty(e)}}else{return false}};this.intersectArray=function(e,d){var h=[];if(!this.isArray(e)){e=this.toArray(e)}var f=this.getObjectArray(this.toArray(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.removeFromArray=function(e,b){if(this.isArray(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isFunction=function(a){var b={};return a&&b.toString.call(a)==="[object Function]"};this.isArray=function(a){return Array.isArray(a)};this.isObject=function(a){return a instanceof Object};this.isUnique=function(b){return this.getUniqueEls(b).length==b.length};this.isBoolean=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}return true};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(a){return this.isArray(a)?a:this.isObject(a)?Object.keys(a):[]};this.unique=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.getUniqueEls=function(b){var e=b.length;var c={};for(var d=0;d<e;d++){c[b[d]]=true}return this.getKeys(c)};this.getUniqueKeys=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(c){var f=[];var d=this.isArray(c);c=this.toArray(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.zip=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.unzip=function(b,a){return b.map(function(d,c){return d[a]})};this.extend=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.cloneObjectR=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.isArray(c)){return c.map(function(d){return b.isArray(d)?d.slice():b.cloneObjectR(d,a)})}else{if(a){return this.isObject(c)?Object.assign({},c):this.parseJSON(this.stringifyJSON(c))}else{return this.parseJSON(this.stringifyJSON(c))}}};this.cloneObject=function(c){if(this.isR){return this.cloneObjectR(c,true)}if(typeof c!=="object"){return c}if(!c){return c}if(Object.prototype.toString.apply(c)==="[object Array]"){var d=[];var a=c.length;for(var b=0;b<a;b++){d[b]=this.cloneObject(c[b])}return d}var d={};for(b in c){if(c.hasOwnProperty(b)){d[b]=this.cloneObject(c[b])}}return d};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.isNumber=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.toNumber=function(a){if(this.isNumber(a,true)){return a}else{return Number.NaN}};this.isNumeric2DArray=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.isNumber(a[d][b])){return false}}}return true};this.isNumeric=function(b,a,e){if(a){var f=this.smpIndices.length;for(var d=0;d<f;d++){var c=this.smpIndices[d];if(!this.isNumber(b[c])){return false}}}else{if(e){var f=this.varIndices.length;for(var d=0;d<f;d++){var c=this.varIndices[d];if(!this.isNumber(b[c])){return false}}}else{var f=b.length;for(var c=0;c<f;c++){if(!this.isNumber(b[c])){return false}}}}return true};this.isNull=function(b,a,e){if(a){var f=this.smpIndices.length;for(var d=0;d<f;d++){var c=this.smpIndices[d];if(b[c]!=null){return false}}}else{if(e){var f=this.varIndices.length;for(var d=0;d<f;d++){var c=this.varIndices[d];if(b[c]!=null){return false}}}else{var f=b.length;for(var c=0;c<f;c++){if(b[c]!=null){return false}}}}return true};this.isEmpty=function(b,a,e){if(a){var f=this.smpIndices.length;for(var d=0;d<f;d++){var c=this.smpIndices[d];if(b[c]!==""){return false}}}else{if(e){var f=this.varIndices.length;for(var d=0;d<f;d++){var c=this.varIndices[d];if(b[c]!==""){return false}}}else{var f=b.length;for(var c=0;c<f;c++){if(b[c]!==""){return false}}}}return true};this.isDate=function(b,a,f){var d=function(h){if(toString.call(h)==="[object Date]"){return true}if(typeof h.replace==="function"){h.replace(/^\s+|\s+$/gm,"")}var i=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return i.test(h)};if(a){var g=this.smpIndices.length;for(var e=0;e<g;e++){var c=this.smpIndices[e];if(b[c]&&!d(b[c])){return false}}}else{if(f){var g=this.varIndices.length;for(var e=0;e<g;e++){var c=this.varIndices[e];if(b[c]&&!d(b[c])){return false}}}else{var g=b.length;for(var c=0;c<g;c++){if(b[c]&&!d(b[c])){return false}}}}return true};this.padNumber=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.isPivotable=function(){var b=this.data.y.vars.length;var c=this.data.x?this.getKeys(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.pivotMatrix=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.stringRangeSort(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.transposeMatrix=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.filterNumbers=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.isNumber(a[b],c)){d.push(a[b])}}return d};this.cleanArray=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.filterNumbers(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.filterNumbers(d,true)}else{d=this.filterNumbers(b,true)}}return d};this.cleanArrays=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.reverseArray=function(a){tmp=a.reverse();return tmp};this.parseInt=function(a){return((a+0.5)<<1)>>1};this.ungroupGroupedData=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.getIpRangeFromAddressAndNetmask=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.int2Ip=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.ip2Int=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.setFunctionNames("initGeneralUtils")};CanvasXpress.prototype.initPlotUtils=function(){this.drawLayoutCanvasCompartments=function(){this.functionCaller="drawLayoutCanvasCompartments";var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.addToRender(["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"]);this.addToRender(["drawShape","rectangle",(j+this.offsetX)+(g/2),(a+this.offsetY+u)+(this.y/2),g,this.y,false,"blue","open"]);this.addToRender(["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u+this.y)+(p/2),this.x,p,false,"blue","open"]);return;this.addToRender(["drawLine","line",j,0,j,m,n]);this.addToRender(["drawLine","line",o+j,0,o+j,m,n]);this.addToRender(["drawLine","line",0,a,s,a,n]);this.addToRender(["drawLine","line",0,a+i,s,a+i,n]);this.addToRender(["drawLine","line",s-e,0,s-e,m,n]);this.addToRender(["drawLine","line",s-(e+k),0,s-(e+k),m,n]);this.addToRender(["drawLine","line",0,m-q,s,m-q,n]);this.addToRender(["drawLine","line",0,m-(q+f),s,m-(q+f),n]);this.addToRender(["drawLine","line",o+j+g,0,o+j+g,m,n]);this.addToRender(["drawLine","line",0,a+i+u,s,a+i+u,n]);this.addToRender(["drawLine","line",s-(e+k+d),0,s-(e+k+d),m,n]);this.addToRender(["drawLine","line",0,m-(q+f+p),s,m-(q+f+p),n])};this.drawCanvasBox=function(a){this.functionCaller="drawCanvasBox";if(this.canvasBox&&(this.graphType!="Network"||a)){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"]);this.addToRender(["enableGradientTransparencyShadow"])}};this.drawPlotWindow=function(){this.functionCaller="drawPlotWindow";if(this.backgroundType.match("window")){this.addToRender(["disableGradientTransparencyShadow"]);var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(this.backgroundType=="windowSolidGradient"){var c=this.getLinearGradient(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,c,c])}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",a+(this.x/2),b+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,this.backgroundWindow,this.backgroundWindow])}}this.addToRender(["enableGradientTransparencyShadow"])}};this.validateSegregation=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.removeMenus();alert(e);return false}return true};this.checkSegregation=function(){if(!this.isDOE){if(this.validateSegregation()){if(this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.segregateSamples(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.segregateVariables(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.segregateSamplesVariables(true)}else{if(this.segregateSamplesBy.length>0){this.segregateSamples(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.segregateVariables(this.segregateVariablesBy,true)}}}}}}};this.validateOverlays=function(){if(this.smpOverlays.length>0){var a=[];for(var b=0;b<this.smpOverlays.length;b++){if(this.smpOverlays[b]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[b]))){a.push(this.smpOverlays[b])}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var b=0;b<this.varOverlays.length;b++){if(this.varOverlays[b]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[b]))){a.push(this.varOverlays[b])}}this.varOverlays=a}};this.isDotplotGraph=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.isAttributedGraph=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.patternBy};this.isSegregatable=function(){return !this.isTransition()&&!this.isDOE&&!this.isInArray(this.graphType,CanvasXpress.graphTypes.NonSegregatable)};this.validateNetworkDecorations=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}};this.setFunctionNames("initPlotUtils")};CanvasXpress.prototype.initConfigUtils=function(){this.encode=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.decode=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.getFileName=function(a){return a.substring(a.lastIndexOf("/")+1)};this.getTitleSubtitleHeight=function(){var b=0;var a;this.setTitleSubtitleFont();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.getFontPt(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.getFontPt(this.subtitleFont))*a.length}b+=this.margin}return b};this.setTitleSubtitleFont=function(){this.setPropertyFontSize(this.width,"titleFont");this.adjustFont(this.title,"titleFont",this.width);this.setPropertyFontSize(this.width,"subtitleFont");this.adjustFont(this.subtitle,"subtitleFont",this.width)};this.drawTitle=function(){this.functionCaller="drawTitle";this.setTitleSubtitleFont();if(this.title){var a=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var b=this.marginTop+(this.measureTextWidth(this.title,this.titleFont)/2);if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}this.addToRender(["drawText",this.title,a,b,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"]);if(this.subtitle){a=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.addToRender(["drawText",this.subtitle,a,b+(this.getFontPt(this.titleFont)/2)+this.margin+(this.getFontPt(this.subtitleFont)/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"])}}};this.getFontHeight=function(){this.setFont();return this.getFontPt(this.font)};this.setFont=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.setPropertyFontSize=function(h,f,c){if(!h||!f){return}var a=5;var e={titleFont:a+4,subtitleFont:a+2,decorationFont:a,axisTickFont:a,axisTitleFont:a,smpLabelFont:a,smpTitleFont:a,varLabelFont:a,varTitleFont:a,legendFont:a-2,overlayFont:a-6,citationFont:a-10,motionCurrentFont:a+50};var g=f.replace("Font","ScaleFontFactor");this[f+"Size"]=Math.min(Math.max(parseInt((h/30)*this[g])+e[f],this.minTextSize),c||this.maxTextSize);this[f]=this[f+"Style"]+" "+this[f+"Size"]+"px "+this.fontName};this.adjustFont=function(b,c,g){if(b&&c&&g){var e=this.getFontPt(this[c]);var a=this.measureText(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.measureText(b,this[c])}}};this.setAspectRatioProperties=function(){if(this.adjustAspectRatio){var b=this.meta.config.orig;var c=this.meta.config.user;var h=Math.min(this.width,this.height);var g=this.zoomScale?this.zoom:1;var f=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){f.push("heatmapIndicatorHeight");f.push("heatmapIndicatorWidth")}for(var e=0;e<f.length;e++){if(!b[f[e]]){b[f[e]]=this[f[e]]}}for(var e=0;e<f.length;e++){if(!c[f[e]]){this[f[e]]=Number(Math.max(0.5,h*this[f[e]]/833).toFixed(1))}}if(this.layoutValid&&this.graphType.match(/Scatter/)){var a=Math.max(this.layoutRows,this.layoutCols);this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/a).toFixed(1))}}};this.resetAspectRatioProperties=function(){if(this.adjustAspectRatio){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50);return}var a=this.meta.config.orig;var c=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){c.push("heatmapIndicatorHeight");c.push("heatmapIndicatorWidth")}for(var b=0;b<c.length;b++){if(a[c[b]]){this[c[b]]=a[c[b]];delete (a[c[b]])}}}};this.drawCitation=function(){this.functionCaller="drawCitation";if(this.citation){var c=this.width-this.margin;var d=this.height-this.margin;if(this.isMap){c+=parseInt(this.meta.canvas.ctx2.canvas.style.left);d+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}var b=20*this.printMagnification;this.setPropertyFontSize(this.width,"citationFont",b);var a=this.measureText(this.citation,this.citationFont);var e=1;while(a>this.width||e>9){b/=2;this.setPropertyFontSize(this.width,"citationFont",b);a=this.measureText(this.citation,this.citationFont);e++}this.addToRender(["drawText",this.citation,c,d,this.citationFont,this.citationColor,"right","bottom"])}};this.drawCx=function(){var b=this.hexToString("686578546f537472696e67");var e=this[b]("6472617754657874");var c=this[b]("6d657461");if(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]!=null){switch(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]){case 0:return;case 1:var a=this[b]("4e6f7420612076616c696420636f7079206f662063616e766173587072657373");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 2:var a=this[b]("556e737570706f727465642063616e7661735870726573732056657273696f6e");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 3:var a=this[b]("63616e76617358707265737320522076657273696f6e206f6e6c79");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 4:this[e]("CanvasXpress",this.fontSize/2,this.height-(this.fontSize/2),this.font,"rgba(0,0,0,0.1)","left","middle");return;default:return}}};this.getGroupColor=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];this.isGroupedData=false;h=this.getPropertyValue(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.getPropertyValue(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.foreground}}this.isGroupedData=true}else{h=this.getPropertyValue(b,e,"colorBy")}return h};this.drawSelectedBackgroundLabel=function(b,c,a,d){this.functionCaller="drawSelectedBackgroundLabel";if(this.isInSelectedDataPoints(b,c)){if(this.selectDataMode=="name"){if(this.selectDataModeDescription&&this.data.z&&this.data.z[this.selectDataModeDescription]){lab=this.data.z[this.selectDataModeDescription][b]||this.data.y.vars[b]}else{lab=this.data.y.vars[b]}this.addToRender(["drawText",lab,a,d,this.varLabelFont,this.foreground,"center","middle"])}return true}return false};this.drawSelectedBackground=function(g,i,j,a,e,f,c,d,b){this.functionCaller="drawSelectedBackground";if(this.isInSelectedDataPoints(g,i)){if(this.selectDataMode=="area"){this.addToRender(["drawShape",j,a,e,f+5,c+5,this.selectedBackgroundColor,this.foreground,"closed",false,false,false,false,d,b])}return true}return false};this.isSimpleBroadcast=function(){if(this.broadcastType=="var"){if(!this.xAxisIndices&&!this.yAxisIndices){return true}else{if(this.graphType.match(/Scatter/)&&this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length<=1){return true}else{if(this.graphType.match(/Pie/)&&this.xAxisIndices.length<=1){return true}else{return false}}}}else{return false}};this.isInSelectedDataPoints=function(a,c){var e=this.isSimpleBroadcast();if(this.isSelectDataPoints){if(this.graphType=="Scatter2D"&&this.isHistogram){if(this.data.y.histogram[a][c]&&this.data.y.histogram[a][c].length>0){for(var b=0;b<this.data.y.histogram[a][c].length;b++){var d=this.data.y.histogram[a][c][b];if(this.selectDataPoint[d]){if(e){return true}else{if(this.selectDataPoint[d].hasOwnProperty(c)){return true}}}}}}else{if(this.selectDataPoint[a]){if(e){return true}else{if(this.selectDataPoint[a].hasOwnProperty(c)){return true}}}}}return false};this.isVisibleSelectedDataPoint=function(a,b){var c=this.isSimpleBroadcast();if(this.isSelectDataPoints){if(this.hideDataPoint.length>0&&this.hideDataPoint[a]){if(c){return false}else{if(this.hideDataPoint[a].hasOwnProperty(b)){return false}}}}return true};this.getVarColor=function(a,c){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelFontColor};this.getSmpColor=function(c,b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelFontColor};this.getNodeColor=function(c,a){if(this.isArray(this.highlightNode)){for(var b=0;b<this.highlightNode.length;b++){if(this.highlightNode[b]==c){return this.nodeHighlightColor}}}else{if(this.highlightNode==c){return this.nodeHighlightColor}}return this.selectNode.hasOwnProperty(c)?this.nodeHighlightColor:a?a:this.nodeFontColor};this.getTechnicalIndicatorColor=function(a){return this[a.toLowerCase()+"Color"]?this[a.toLowerCase()+"Color"]:"rgb(255,255,0)"};this.getDendrogramColor=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.getVariableIndices(a);if(b>-1){return this.getPropertyValue(b,false,"colorVarDendrogramBy")}}return this.getVarColor(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.getSampleIndices(c);if(b>-1){return this.getPropertyValue(false,b,"colorSmpDendrogramBy")}}return this.getSmpColor(c,true)}};this.isStringOverlays=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.isUniqueFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.isNumericFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.isStringFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.getBestSizes=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.cloneObject(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.isBinConfigurations=function(){for(var a in this.binConfigurations){return true}return false};this.initValidity=function(){var D=this.hexToString("686578546f537472696e67");var G=this[D]("6d657461");var y=this[D]("666163746f7279");var p=this[D]("636c69656e74");var i=this[D]("656e636f6465");var g=this[D]("73797374656d");var E=this[D]("76616c6964");var e=this[D]("74696d65");var H=this[D]("7374617274");var d=this[D]("73697465537263");var F=this[D]("757365724964");var d=this[D]("76657273696f6e");var k=this[D]("68726566");var C=this[D]("69734e6f6465");var B=new RegExp(this[D]("63616e7661737870726573732e6f7267"));var o=new RegExp(this[D]("5e66696c653a"));var A=new RegExp(this[D]("626d732e636f6d"));var j=new RegExp(this[D]("6c6f63616c686f7374"));CanvasXpress[y][p]=this[i]([this[G][e][H],this[F],CanvasXpress[y][d],this[k]].join("::"));this.setPixelImage();if(this[F]==1){if(window.navigator.onLine){if(this[k]&&CanvasXpress[y][d]){CanvasXpress[y][E]=0}else{if(this[k]&&o.test(this[k])){CanvasXpress[y][E]=0}else{if(this[k]&&j.test(this[k])){CanvasXpress[y][E]=0}else{if(this[k]&&!B.test(this[k])){CanvasXpress[y][E]=1}else{CanvasXpress[y][E]=0}}}}}else{CanvasXpress[y][E]=0}}else{if(this[F]==2){if(this.isR){CanvasXpress[y][E]=0}else{CanvasXpress[y][E]=3}}else{if(this[F]==3&&!A.test(this[k])&&!j.test(this[k])&&!o.test(this[k])){CanvasXpress[y][E]=1}else{if(CanvasXpress[g][C]){if(this[F]<5){CanvasXpress[y][E]=4}else{CanvasXpress[y][E]=0}}else{CanvasXpress[y][E]=0}}}}};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.adjustTreemapCoords=function(f,e){if(f){var c=this.treemapBorderWidth?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.setTreemapRowVerticalLayout=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.adjustTreemapCoords(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.adjustTreemapCoords(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c,d)}else{return this.setTreemapRowHorizontalLayout(a,b,c,d)}};this.computeTreemapDimensions=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.adjustTreemapCoords(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f,h)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.setTreemapRowLayout(c,b,f,h);this.computeTreemapDimensions(a,[],g.orientation,g,d.title)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g,a[0].title)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,i,g,d){this.functionCaller="drawCloudTag";var k=this;var m=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.addColorTransparency(g,0);var f=this.get1DLeft();var p=this.get1DTop();while(a--){var n=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.shuffleArray(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.canFitCloudText(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.updateCloudGrid(w,v,e);return true});if(h){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.tryRenderTagCloud=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.setTagCloud(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.getDataAtPos(j,a);var k=this.colorBy?this.getPropertyValue(j,a,"colorBy"):this.foreground;if(!this.drawCloudTag(this.data.y.smps[a],h,k,[j,a])){this.resizeCanvas();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.tryRenderTagCloud(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.getVariableColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getOutlineColor=function(a,c){if((this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)||(this.useOpenShapes&&!c)){return this.removeColorTransparency(a)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var b=this.varIndices.length*this.smpIndices.length;if(b>this.dotplotOutlineThreshold){return a}else{return this.objectBorderColor?this.objectBorderColor:this.removeColorTransparency(a)}}else{return this.objectBorderColor?this.objectBorderColor:this.removeColorTransparency(a)}}};this.getFillColor=function(a,b){return this.addColorTransparency(a,(this.useOpenShapes&&!b)?0:this.objectColorTransparency)};this.getDefaultMetaDataObject=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.setPieData=function(n,q,m){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.sum(n)};var b=this.getCustomColorScheme(n.length);for(var l=0;l<n.length;l++){var h=q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.isNumber(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.drawPie=function(u,h,g,t,I,w){this.functionCaller="drawPie";var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.isNumber(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d,o;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.getFillColor(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))-m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);this.drawSelectedBackground(k>-1?k:u.idso[0],C,"pie",h,g,(t*2)+10,t+10,z,d);if(this.graphType=="Network"){this.addToRender(["drawShape","pie",h,g,(t*2),t,e,e,"closed",false,1,false,false,z,d],I[E],w)}else{if(this.graphType!="Pie"){this.addToRender(["drawShape","pie",h,g,(t*2),t,e,e,"closed",false,1,false,false,z,d],I[E],w)}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.addToRender(["drawShape","pie",h,g,(t*2),t,e,e,"closed",false,1,false,false,z,d],I)}else{this.addToRender(["drawShape","pie",h,g,(t*2),t,e,e,"closed",false,1,false,false,z,d],u.idso)}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.addToRender(["drawText",u.raw[k],F,b,this.axisTickFont,this.axisTickColor,"center","middle"])}else{this.addToRender(["drawText",this.sprintf("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.axisTickFont,this.axisTickColor,"center","middle"])}}G+=v}G=0;d=null;if(u.ids.length>1){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.getFillColor(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))-m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);this.addToRender(["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],false,false,null,true);G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1){this.addToRender(["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"])}}};this.drawBarPlot=function(ad,ac,U,J,G,O,I,D,T,R,ae,Q,ah,S,Z,W,F){this.functionCaller="drawBarPlot";var H,E,ab,M;var C=this;var K=this.variableSpaceFactor/2;var Y=G/2;if(R=="vertical"||this.graphType=="Network"){for(var X=0;X<ad.length;X++){H=((ad[X]-T)*I)-D;var L;var ag=(F&&F.cap&&F.cap[X])||this.barType=="arrow"?"arrow":this.useRoundRectangles&&H>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var B=this.getFillColor(F?F.fill[X]:ae[X]);var af=G-this.variableSpaceFactor>5?this.getOutlineColor(B):B;if(this.isNumber(H,true)){if(H<0){L=this.addToRender(["drawShape",ag,(U+K)+((G-this.variableSpaceFactor)/2),J+(-H/2),G-this.variableSpaceFactor,-H,B,af,Q[X],false,false,Z],ah[X],S)}else{L=this.addToRender(["drawShape",ag,(U+K)+((G-this.variableSpaceFactor)/2),J-(H/2),G-this.variableSpaceFactor,H,B,af,Q[X],false,false,Z],ah[X],S)}ab=J-H;M=U+Y;if(ac[X]&&this.isNumber(ac[X],true)){E=(ac[X]/2)*I;this.addToRender(["drawLine","error",M,ab,M,ab-E,this.errorBarsColor,-Y,"butt"],false,false,L);this.addToRender(["drawLine","error",M,ab,M,ab+E,this.errorBarsColor,-Y,"butt"],false,false,L)}if(F){for(var A in F){if(A!="cap"&&A!="high"&&A!="color"&&A!="fill"){if(F[A][X]){for(var aa=0;aa<F[A][X].length;aa++){var V=((F[A][X][aa][0]-T)*I)-D;var j=((F[A][X][aa][1]-T)*I)-D;var P=(U+K)+((G-this.variableSpaceFactor)/2);this.addToRender(["drawShape",this.shapes[0],P,J-V,G/2,G/2,F.color[A],F.color[A]],false,false,L);if(!this.isNumber(j,true)){j=H-this.margin}else{this.addToRender(["drawShape",this.shapes[1],P,J-j,G/2,G/2,F.color[A],F.color[A]],false,false,L)}this.addToRender(["drawLine","line",P,J-V,P,J-j,F.color[A],this.margin],false,false,L)}}}}}if(this.showDataValues){this.addToRender(["drawText",this.formatNumber(ad[X]),M,J-(H+(this.margin/4)),this.overlayFont,B,"center","bottom"],false,false,L)}}U+=O}}else{for(var X=0;X<ad.length;X++){H=((ad[X]-T)*I)-D;var L;var ag=(F&&F.cap&&F.cap[X])||this.barType=="arrow"?"arrow":!this.useRoundRectangles?"rectangle":W||H<0?"roundrectl":"roundrectr";var B=this.getFillColor(F?F.fill[X]:ae[X]);var af=G-this.variableSpaceFactor>5?this.getOutlineColor(B):B;if(this.isNumber(H,true)){if(H<0){if(W){L=this.addToRender(["drawShape",ag,((U+W)-D)+(-H/2),(J+K)+((G-this.variableSpaceFactor)/2),-H,G-this.variableSpaceFactor,B,af,Q[X],ag=="arrow"?true:false,false,Z],ah[X],S)}else{L=this.addToRender(["drawShape",ag,(U+H)+(-H/2),(J+K)+((G-this.variableSpaceFactor)/2),-H,G-this.variableSpaceFactor,B,af,Q[X],ag=="arrow"?true:false,false,Z],ah[X],S)}}else{if(W){L=this.addToRender(["drawShape",ag,((U+W)-(H+D))+(H/2),(J+K)+((G-this.variableSpaceFactor)/2),H,G-this.variableSpaceFactor,B,af,Q[X],ag=="arrow"?true:false,false,Z],ah[X],S)}else{L=this.addToRender(["drawShape",ag,U+(H/2),(J+K)+((G-this.variableSpaceFactor)/2),H,G-this.variableSpaceFactor,B,af,Q[X],ag=="arrow"?true:false,false,Z],ah[X],S)}}ab=W?(U+W)-(H+D):U+H;M=J+Y;if(ac[X]&&this.isNumber(ac[X],true)){E=(ac[X]/2)*I;this.addToRender(["drawLine","error",ab,M,ab+E,M,this.errorBarsColor,Y,"butt"],false,false,L);this.addToRender(["drawLine","error",ab,M,ab-E,M,this.errorBarsColor,Y,"butt"],false,false,L)}if(F){for(var A in F){if(A!="cap"&&A!="high"&&A!="color"&&A!="fill"){if(F[A][X]){for(var aa=0;aa<F[A][X].length;aa++){var V=((F[A][X][aa][0]-T)*I)-D;var j=((F[A][X][aa][1]-T)*I)-D;var N=(J+K)+((G-this.variableSpaceFactor)/2);this.addToRender(["drawShape",this.shapes[0],U+V,N,G/2,G/2,F.color[A],F.color[A]],false,false,L);if(!this.isNumber(j,true)){j=H-this.margin}else{this.addToRender(["drawShape",this.shapes[1],U+j,N,G/2,G/2,F.color[A],F.color[A]],false,false,L)}this.addToRender(["drawLine","line",U+V,N,U+j,N,F.color[A],this.margin],false,false,L)}}}}}if(this.showDataValues){this.addToRender(["drawText",this.formatNumber(ad[X]),ab+(this.margin/4),M,this.overlayFont,ae[X],"left","middle"],false,false,L)}}J+=O}}};this.drawLinePlot=function(ac,ab,U,N,L,Y,M,T,R,ae,P,O,ag,aa,Z,V,E){this.functionCaller="drawLinePlot";var H=function(){var b=[[],[]];if(R=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var Q,A,y,x,j,ai,ah,ad,I;var K=null;var C=null;var G=L/2;var F=Math.min(10,L/3);var af=P=="open"?ae:this.foreground;var S=ac.length-1;var J=[[],[]];var r=[[],[]];var W=[];var B=this.getVariableIndices(E);if(R=="vertical"){A=U;y=U+Y;if(K==null){K=A}for(var X=1;X<ac.length;X++){Q=X-1;if(this.isObject(M)){j=N-((ac[Q]-M[Q].min)*M[Q].units);ai=N-((ac[X]-M[X].min)*M[X].units)}else{j=N-((ac[Q]-T)*M);ai=N-((ac[X]-T)*M)}if(C==null){C=j}if(this.isNumber(j,true)){if(this.lineDecoration&&O){ad=this.addToRender(["drawShape",O,A,j,F,F,ae,af,P[Q],false,false,Z],ag[Q],aa,I,false,[K,C])}else{ad=this.addToRender(["drawShape","sphere",A,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[Q],false,false,Z],ag[Q],aa,I,false,[K,C])}if(!I){I=ad}if(this.isNumber(ab[Q],true)){ah=(ab[Q]/2)*this.isObject(M)?M[Q].units:M;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,j,A,j+ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I,false,[K,C]);this.addToRender(["drawLine","error",A,j,A,j-ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I,false,[K,C])}else{r[0].push([A,A]);r[1].push([j+ah,j-ah]);W.push([A,j])}}if(this.lineType=="spline"){J[0].push(A);J[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(j,true)&&this.isNumber(ai,true))||ac.length<3){ad=this.addToRender(["drawLine","line",A,j,y,ai,ae,this.lineThickness,"butt",false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C])}else{if(this.lineType=="spline"&&!this.isNumber(ai,true)){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C]);J=[[],[]];K=null;C=null}}if(!I){I=ad}if(r[0].length>0&&!this.isNumber(ai,true)){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}r=[[],[]];W=[]}A+=Y;y+=Y}if(this.isNumber(ai,true)){if(this.lineDecoration&&O){ad=this.addToRender(["drawShape",O,A,ai,F,F,ae,af,P[S],false,false,Z],ag[S],aa,I,false,[K,C])}else{ad=this.addToRender(["drawShape","sphere",A,ai,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[S],false,false,Z],ag[S],aa,I,false,[K,C])}if(!I){I=ad}if(this.isNumber(ab[S],true)){ah=(ab[S]/2)*this.isObject(M)?M[S].units:M;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,ai,A,ai+ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I);this.addToRender(["drawLine","error",A,ai,A,ai-ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I)}else{if(X==ac.length){r[0].push([A,A]);r[1].push([ai+ah,ai-ah]);W.push([A,ai])}}}if(this.lineType=="spline"){J[0].push(A);J[1].push(ai)}}if(this.lineType=="spline"){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,null,false,[K,C])}if(!I){I=ad}if(r[0].length>0){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}}}else{j=N;ai=N+Y;if(C==null){C=j}for(var X=1;X<ac.length;X++){Q=X-1;if(this.isObject(M)){A=V?U+V-((ac[Q]-M[Q].min)*M[Q].units):U+((ac[Q]-M[Q].min)*M[Q].units);y=V?U+V-((ac[X]-M[X].min)*M[X].units):U+((ac[X]-M[X].min)*M[X].units)}else{A=V?U+V-((ac[Q]-T)*M):U+((ac[Q]-T)*M);y=V?U+V-((ac[X]-T)*M):U+((ac[X]-T)*M)}if(K==null){K=A}if(this.isNumber(A,true)){if(this.lineDecoration&&O){this.addToRender(["drawShape",O,A,j,F,F,ae,af,P[Q],false,false,Z],ag[Q],aa,null,false,[K,C])}else{this.addToRender(["drawShape","sphere",A,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[Q],false,false,Z],ag[Q],aa,null,false,[K,C])}if(this.isNumber(ab[Q],true)){x=(ab[Q]/2)*this.isObject(M)?M[Q].units:M;if(this.lineErrorType=="bar"){ad=this.addToRender(["drawLine","error",A,j,A+x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I);if(!I){I=ad}this.addToRender(["drawLine","error",A,j,A-x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I)}else{r[0].push([A+x,A-x]);r[1].push([j,j]);W.push([A,j])}}if(this.lineType=="spline"){J[0].push(A);J[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(A,true)&&this.isNumber(y,true))||ac.length<3){ad=this.addToRender(["drawLine","line",A,j,y,ai,ae,this.lineThickness,"butt",false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C])}else{if(this.lineType=="spline"&&!this.isNumber(y,true)){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C]);J=[[],[]];K=null;C=null}}if(!I){I=ad}if(r[1].length>0&&!this.isNumber(y,true)){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}r=[[],[]];W=[]}j+=Y;ai+=Y}if(this.isNumber(y,true)){if(this.lineDecoration&&O){this.addToRender(["drawShape",O,y,j,F,F,ae,af,P[S],false,false,Z],ag[S],aa,null,false,[K,C])}else{this.addToRender(["drawShape","sphere",y,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[S],false,false,Z],ag[S],aa,null,false,[K,C])}if(this.isNumber(ab[S],true)){x=(ab[S]/2)*this.isObject(M)?M[S].units:M;if(this.lineErrorType=="bar"){ad=this.addToRender(["drawLine","error",y,j,y+x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I);if(!I){I=ad}this.addToRender(["drawLine","error",y,j,y-x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I)}else{r[0].push([y+x,y-x]);r[1].push([j,j]);W.push([y,j])}}if(this.lineType=="spline"){J[0].push(y);J[1].push(j)}}if(this.lineType=="spline"){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,null,false,[K,C])}if(!I){I=ad}if(r[1].length>0){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}}}};this.drawStackedPlot=function(Q,J,C,y,S,E,N,B,s,F,R,D,T,H,K,O){this.functionCaller="drawStackedPlot";var h=C;var x=J;var m=this;var M=function(c,e,b,d,a){return m.processTreemap(c,{width:d,height:a,left:e,top:b})};if(F=="vertical"){C=h-s;for(var L=0;L<Q.length;L++){if(Q[L]>0){var A=E?(Q[L]*100/N[0])*B:Q[L]*B;var I=L==Q.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var r=this.getFillColor(R[L]);var j=y>5?this.getOutlineColor(r):r;if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+(y/2),C-(A/2),y,A,R[L],R[L]],T[L],H)}else{if(S){var G=M(S[L],J,C-A,y,A);this.drawTreemap(G,0,0)}else{this.addToRender(["drawShape",I,J+(y/2),C-(A/2),y,A,r,j,D[L]],T[L],H,null,false,O)}}C-=A}}C=h-s;for(var L=Q.length-1;L>=0;L--){if(Q[L]<0){var A=E?(Q[L]*100/-N[1])*B:Q[L]*B;var I=L>0||!this.useRoundRectangles?"rectangle":"roundrectb";var r=this.getFillColor(R[L]);var j=y>5?this.getOutlineColor(r):r;if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+(y/2),C-(A/2),y,-A,R[L],R[L]],T[L],H)}else{if(S){var G=M(S[L],J,C-A,y,-A);this.drawTreemap(G,0,0)}else{this.addToRender(["drawShape",I,J+(y/2),C-(A/2),y,-A,r,j,D[L]],T[L],H,null,false,O)}}C-=A}}}else{J=x+s;for(var L=0;L<Q.length;L++){if(Q[L]>0){var A=E?(Q[L]*100/N[0])*B:Q[L]*B;var I=L<Q.length-1||!this.useRoundRectangles?"rectangle":K?"roundrectl":"roundrectr";var r=this.getFillColor(R[L]);var j=y>5?this.getOutlineColor(r):r;if(K){if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+K-(A/2),C+(y/2),A,y,R[L],R[L],D[L]],T[L],H)}else{if(S){var G=M(S[L],J+K-A,C,A,y);this.drawTreemap(G,0,0)}else{this.addToRender(["drawShape",I,J+K-(A/2),C+(y/2),A,y,r,j,D[L]],T[L],H,null,false,O)}}J-=A}else{if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+(A/2),C+(y/2),A,y,R[L],R[L],D[L]],T[L],H)}else{if(S){var P=M(S[L],J,C,A,y);this.drawTreemap(P,0,0)}else{this.addToRender(["drawShape",I,J+(A/2),C+(y/2),A,y,r,j,D[L]],T[L],H,null,false,O)}}J+=A}}}J=x+s;for(var L=Q.length-1;L>=0;L--){if(Q[L]<0){var A=E?(Q[L]*100/-N[1])*B:Q[L]*B;var I=L>0||!this.useRoundRectangles?"rectangle":K?"roundrectr":"roundrectl";var r=this.getFillColor(R[L]);var j=y>5?this.getOutlineColor(r):r;if(K){if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+K-(A/2),C+(y/2),-A,y,R[L],R[L],D[L]],T[L],H)}else{if(S){var G=M(S[L],J+K-A,C,-A,y);this.drawTreemap(G,0,0)}else{this.addToRender(["drawShape",I,J+K-(A/2),C+(y/2),-A,y,r,j,D[L]],T[L],H,null,false,O)}}J-=A}else{if(this.graphType=="Network"){this.addToRender(["drawShape",I,J+(A/2),C+(y/2),-A,y,R[L],R[L],D[L]],T[L],H)}else{if(S){var P=M(S[L],J,C,-A,y);this.drawTreemap(P,0,0)}else{this.addToRender(["drawShape",I,J+(A/2),C+(y/2),-A,y,r,j,D[L]],T[L],H,null,false,O)}}J+=A}}}}};this.drawAreaPlot=function(ah,Z,S,Q,ad,T,af,V,J,D,m,X,ae,aj,W,al,ak,M,G){this.functionCaller="drawAreaPlot";var Y=ah.length-1;var aa=ae&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var am=-D*J;var C=m*J;var L=function(b,a){for(var c=a+1;c<ah[b].length;c++){if(ah[b][c]>0){return 1}else{if(ah[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ah[0].length;ac++){A[ac]=af=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ah.length;ac++){var ag=Z;var P=ae?[]:[Z];var N=ae?[]:[S-am];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(!this.isNumber(ah[ac][ab],true)){if(!ae){P.push(ag-T);N.push(S-am)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,S-am)}else{if(D>=0&&Y>0&&af!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var an=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);an.push([N[ac],E[ac]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(aj[Y]),this.getOutlineColor(aj[Y]),W[Y]],al[Y],ak,null,false,S-am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,this.getFillColor(aj[ac]),this.getOutlineColor(aj[ac]),W[ac]],al[ac],ak,null,false,S-am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[ag+T];N=ae?[]:[S-am]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;P.push(ag);if(af&&(af=="stacked"||af=="percent")){if(ah[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ah[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(am)}}}}}else{N.push(S-R)}}ag+=T}if(!ae){P.push(Z+Q);N.push(S-am)}U.push([P,N,aj[ac],W[ac],al[ac]])}}else{for(var ac=0;ac<ah[0].length;ac++){A[ac]=M?Z+M:af=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ah.length;ac++){var ag=S;var P=ae?[]:M?[Z+M]:[Z+am];var N=ae?[]:[S];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(!this.isNumber(ah[ac][ab],true)){if(!ae){P.push(M?Z+M:Z+am);N.push(ag-T)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,Z+am)}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&af!="normal"){N.shift();var F=[];var an=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);an.push([N[ac-1],N[ac-1]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(aj[Y]),this.getOutlineColor(aj[Y]),W[Y]],al[Y],ak,null,false,Z+am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,this.getFillColor(aj[ac]),this.getOutlineColor(aj[ac]),W[ac]],al[ac],ak,null,false,Z+am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[M?Z+M:Z+am];N=ae?[]:[ag+T]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;N.push(ag);if(af&&(af=="stacked"||af=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ah[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ah[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(am)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ag+=T}if(!ae){P.push(M?Z+M:Z+am);N.push(S+ad)}U.push([P,N,aj[ac],W[ac],al[ac]])}}while(Y>=0){var ai,K;var ab=U.pop();if(ae){if(this.lineType=="spline"){this.addToRender(["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var ai=this.addToRender(["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],ab[4],ak,K,false,X=="vertical"?S-am:Z+am);if(K==null){K=ai}}}}else{if(D>=0&&Y>0&&af!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var an=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);an.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],ab[4],ak,null,false,S-am)}else{ab[1].shift();ab[1].pop();var F=[];var an=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);an.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],ab[4],ak,null,false,Z+am)}}else{if(af=="normal"||af=="stacked"){this.addToRender(["drawShape",aa,ab[0],ab[1],this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{if(X=="vertical"){var an=[];for(var ac=1;ac<ab[1].length-1;ac++){an.push([ab[1][ac],ab[1][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],ab[4],ak,null,false,S-am)}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],ab[4],ak,null,false,Z+am)}}}}if(G){var u=this.addColorTransparency(ab[2],0);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){ai=this.addToRender(["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],[ab[4][0],G[ac-1]],false,null,true);if(!ae){if(X=="vertical"){this.addToRender(["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],[ab[4][0],G[ac-1]],false,ai,true)}else{this.addToRender(["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],[ab[4][0],G[ac-1]],false,ai,true)}}}}Y--}};this.drawBoxPlot=function(ao,ae,W,T,Z,V,ad,ab,ap,aa,ar,ak,S){this.functionCaller="drawBoxPlot";var Q=this;var ac=this.segregateSamplesBy.length&&this.isGroupedData&&this.isInArray(this.segregateSamplesBy[0],this.groupingFactors);var B=function(f){var d;if(Q.layoutValid){if(Q.segregateVariablesBy.length>0){d=f}else{if(Q.segregateSamplesBy.length>0){var a=!ac?[Q.data.l.name[Q.layoutCurrent],Q.data.w.glab[f]].join("::"):Q.data.w.labs[f]?Q.data.w.labs[f]:Q.data.w.glab[f];for(var c=0;c<k.g[C].length;c++){if(k.g[C][c].density.name==a){d=c;break}}}}}else{d=Q.grpIndices[f]}return k.g[C][d]};var R=function(a){return ab=="vertical"?W-((a-ad)*V):ae+((a-ad)*V)};var k=this.meta.data.d;var C=this.getVariableIndices(S);var X=this.variableSpaceFactor/2;var ai=T/2;var F=ai/2;var D=F/2;var am=T/this.boxplotOutliersRatio;var E={};var P={};var J=false;var O=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(T-this.variableSpaceFactor)*this.boxplotWidthRatioIfViolin:T-this.variableSpaceFactor;var N=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?T*this.boxplotWidthRatioIfViolin:0;var M=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?N/2:ai;var b=Math.max(1,T/4);if(ab=="vertical"){for(var ah=0;ah<ao.length;ah++){if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ao[ah].length>1){var A=B(ah);if(A){this.drawViolin(A,ae+(T/2),W,T/this.varIndices.length,V,ad,ab,ak[ah],"closed",ar[ah]);if(!this.showBoxplotIfViolin){J=true}}}var Y=ae+ai;var U=[];var x=[];var K=this.showBoxplotOriginalData||this.showViolinBoxplot?ak[ah]:ap[ah];for(var ag=0;ag<5;ag++){U.push(R(ao[ah][ag]));x.push(U[U.length-1].toString())}if(!J){var L=(ae+X)+((T-this.variableSpaceFactor)/2);var al=U[3]+((U[2]-U[3])/2);var aj=O;var aq=U[2]-U[3];var e=this.boxplotNotched?R(ao[ah][7][0]):false;var af=this.boxplotNotched?R(ao[ah][7][1]):false;var H=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(ap[ah]),this.boxplotTransparency):this.getFillColor(ap[ah]);var G=this.getOutlineColor(H);var an,I,n;if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){I=[ae+(T-X-N)-b,ae+X+N,ae+X+N,ae+(T-X-N),ae+(T-X-N),ae+X+N+b,ae+(T-X-N)-b]}else{I=[ae+X+N+b,ae+X+N,ae+X+N,ae+(T-X-N),ae+(T-X-N),ae+(T-X-N)-b,ae+X+N+b]}n=[U[4],e,U[2],U[2],e,U[4],U[4]];an=this.addToRender(["drawShape","polygon",I,n,false,false,H,G,aa[ah]],ar[ah],false,null,false,W);n=[U[4],af,U[3],U[3],af,U[4],U[4]];this.addToRender(["drawShape","polygon",I,n,false,false,H,G,aa[ah]],ar[ah],false,an,false,W)}else{if(this.boxplotType=="range"){an=this.addToRender(["drawLine","line",L,U[1],L,U[0],this.useOpenShapes?G:H,am,"round"],ar[ah],false,null,false,W)}else{an=this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",L,al,aj,aq,H,G,aa[ah]],ar[ah],false,null,false,W)}}if(this.unique(x).length!=1){if(this.boxplotNotched&&this.boxplotType!="range"){this.addToRender(["drawLine","median",ae+X+N+b,U[4],ae+(T-X-N)-b,U[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ar[ah],false,an)}else{if(this.boxplotType=="range"){this.addToRender(["drawShape","sphere",L,U[4],am*2.5,am*2.5,this.useOpenShapes?G:H,this.useOpenShapes?G:H],ar[ah],false,an)}else{this.addToRender(["drawLine","median",ae+X+N,U[4],ae+(T-X-N),U[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ar[ah],false,an)}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.addToRender(["drawLine","line",Y,U[2],Y,U[0],G,false,"butt"],ar[ah],false,an);this.addToRender(["drawLine","line",Y,U[3],Y,U[1],G,false,"butt"],ar[ah],false,an)}else{this.addToRender(["drawLine","error",Y,U[2],Y,U[0],G,-M,"butt"],ar[ah],false,an);this.addToRender(["drawLine","error",Y,U[3],Y,U[1],G,-M,"butt"],ar[ah],false,an)}}}if(this.boxplotMean){this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",Y,R(ao[ah][6]),F,F,this.boxplotMeanColor,this.boxplotMeanColorBorder],ar[ah],false,an,false,W)}if(ao[ah][5]){for(var ag=0;ag<ao[ah][5].length;ag++){this.addToRender(["drawShape","sphere",Y,R(ao[ah][5][ag]),am,am,H,G,aa[ah]],ar[ah],false,an,false,W)}}}if(!E.hasOwnProperty(K)){E[K]=[];P[K]=this.cloneObject(ar[ah])}E[K].push([ae+X+(T/2),U[4]]);ae+=Z}}else{for(var ah=0;ah<ao.length;ah++){if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ao[ah].length>1){var A=B(ah);if(A){this.drawViolin(A,ae,W+(T/2),T/this.varIndices.length,V,ad,ab,ak[ah],"closed",ar[ah]);if(!this.showBoxplotIfViolin){J=true}}}var Y=W+ai;var U=[];var x=[];var K=this.showBoxplotOriginalData||this.showViolinBoxplot?ak[ah]:ap[ah];for(var ag=0;ag<5;ag++){U.push(R(ao[ah][ag]));x.push(U[U.length-1].toString())}if(!J){var L=U[2]+((U[3]-U[2])/2);var al=(W+X)+((T-this.variableSpaceFactor)/2);var aj=U[3]-U[2];var aq=O;var e=this.boxplotNotched?R(ao[ah][7][0]):false;var af=this.boxplotNotched?R(ao[ah][7][1]):false;var H=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(ap[ah]),this.boxplotTransparency):this.getFillColor(ap[ah]);var G=this.getOutlineColor(H);var an,I,n;if(this.boxplotNotched&&this.boxplotType!="range"){I=[U[4],e,U[2],U[2],e,U[4],U[4]];if(this.showViolinBoxplot){n=[W+(T-X-N)-b,W+X+N,W+X+N,W+(T-X-N),W+(T-X-N),W+X+N+b,W+(T-X-N)-b]}else{n=[W+X+N+b,W+X+N,W+X+N,W+(T-X-N),W+(T-X-N),W+(T-X-N)-b,W+X+N+b]}an=this.addToRender(["drawShape","polygon",I,n,false,false,H,G,aa[ah]],ar[ah],false,null,false,W);I=[U[4],af,U[3],U[3],af,U[4],U[4]];this.addToRender(["drawShape","polygon",I,n,false,false,H,G,aa[ah]],ar[ah],false,an,false,W)}else{if(this.boxplotType=="range"){an=this.addToRender(["drawLine","line",U[0],al,U[1],al,this.useOpenShapes?G:H,am,"round"],ar[ah],false,null,false,ae)}else{an=this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",L,al,aj,aq,H,G,aa[ah]],ar[ah],false,null,false,ae)}}if(this.unique(x).length!=1){if(this.boxplotNotched&&this.boxplotType!="range"){this.addToRender(["drawLine","median",U[4],W+X+N+b,U[4],W+(T-X-N)-b,this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ar[ah],false,an)}else{if(this.boxplotType=="range"){this.addToRender(["drawShape","sphere",U[4],al,am*2.5,am*2.5,this.useOpenShapes?G:H,this.useOpenShapes?G:H],ar[ah],false,an)}else{this.addToRender(["drawLine","median",U[4],W+X+N,U[4],W+(T-X-N),this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ar[ah],false,an)}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.addToRender(["drawLine","line",U[2],Y,U[0],Y,G,false,"butt"],ar[ah],false,an);this.addToRender(["drawLine","line",U[3],Y,U[1],Y,G,false,"butt"],ar[ah],false,an)}else{this.addToRender(["drawLine","error",U[2],Y,U[0],Y,G,M,"butt"],ar[ah],false,an);this.addToRender(["drawLine","error",U[3],Y,U[1],Y,G,M,"butt"],ar[ah],false,an)}}}if(this.boxplotMean){this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",R(ao[ah][6]),Y,F,F,this.boxplotMeanColor,this.boxplotMeanColorBorder],ar[ah],false,an,false,ae)}if(ao[ah][5]){for(var ag=0;ag<ao[ah][5].length;ag++){this.addToRender(["drawShape","sphere",R(ao[ah][5][ag]),Y,am,am,H,G,aa[ah]],ar[ah],false,an,false,ae)}}}if(!E.hasOwnProperty(K)){E[K]=[];P[K]=this.cloneObject(ar[ah])}E[K].push([U[4],W+X+(T/2)]);W+=Z}}if(this.boxplotConnect){for(var K in E){if(E[K].length>1){var an=this.addToRender(["drawLine","line",E[K][0][0],E[K][0][1],E[K][1][0],E[K][1][1],K,this.boxplotConnectWidth,"butt"],["Line:",P[K][0],P[K][1]],false);for(var ah=1;ah<E[K].length-1;ah++){this.addToRender(["drawLine","line",E[K][ah][0],E[K][ah][1],E[K][ah+1][0],E[K][ah+1][1],K,this.boxplotConnectWidth,"butt"],["Line:",P[K][0],P[K][1]],false,an)}}}}};this.drawGanttPlot=function(Q,D,S,G,K,B,O,A,J,E,R,T){this.functionCaller="drawGanttPlot";var x=function(a){return K+((a-J)*A)};var w=null;for(var M=0;M<Q.length;M++){var I=x(Q[M][0]);var f=x(Q[M][1]);var y=I+((f-I)/2);var e=B+(O/2);var V=f-I;var s=D[M]?V*D[M]:false;var v=this.getFillColor(R[M]);var g=this.addColorTransparency(v,this.ganttCompletionTransparency);var r=this.getOutlineColor(v);var C=this.addToRender(["drawShape","roundrect",y,e,V,O,g,g,E[M]],T[M],false,w,false,K);if(!w){w=C}if(D[M]){if(D[M]==1){this.addToRender(["drawShape","roundrect",y,e,V,O,v,v,E[M]],T[M],false,w,false,K)}else{this.addToRender(["drawShape","roundrectl",y-((V-s)/2),e,s,O,v,v,E[M]],T[M],false,w,false,K)}}this.addToRender(["drawShape","roundrect",y,e,V,O,false,r,"open"],T[M],false,w,false,K);if(G.length){for(var L=0;L<G.length;L++){var H=x(G[L][0]);this.addToRender(["drawShape","triangle2",H,B,O/3,O/3,v,r],[].concat(T[M].concat(G[L][1])),false,w,false,K)}}if(S[M]){var F=x(S[M][0]);var W=x(S[M][1]);var U=S[M][2]+(O/2);var P=e==U?W:F+((W-F)/2);var n=e==U?U:U+(O/2);var N=y-(V/2);var k=e;this.addToRender(["drawLine",n==k?"line":"roundLine",P,n,N,k,this.getOutlineColor(S[M][4]),S[M][5],"butt",0,0,false,false,false,false,S[M][3]],T[M],false,w,false,K)}}};this.drawViolin=function(j,C,n,G,k,B,z,H,w,s){this.functionCaller="drawViolin";var e=[];var E=[];var b=[];var A=[];var a=[[],[]];var D,d,g,f;switch(this.violinScale){case"area":D=G/j.density.maxY*j.density.maxY/j.scale*0.9;break;case"count":D=G/j.density.maxY*j.density.sumY/j.area*0.9;break;case"width":D=G/j.density.maxY*0.9;break}var r=this.addColorTransparency(this.violinColor||H,this.showBoxplotOriginalData&&!this.violinColor?0:this.violinTransparency);if(this.violinTrim){d=[];for(var F=j.density.trim[0];F<j.density.trim[1];F++){d.push(j.density.xy[F])}}else{d=j.density.xy}if(z=="vertical"){for(var F=0;F<d.length;F++){g=(d[F][1]*D);f=((d[F][0]-B)*k);e.push(C-g);E.push(n-f);b.push(C+g);A.push(n-f);a[0].push(C);a[1].push(n-f)}}else{for(var F=0;F<d.length;F++){g=((d[F][0]-B)*k);f=(d[F][1]*D);e.push(C+g);E.push(n-f);b.push(C+g);A.push(n+f);a[0].push(C+g);a[1].push(n)}}if(e.length>1&&E.length>1){this.addToRender(["drawShape","violin",[e,b],[E,A],false,false,r,this.violinBorderColor,w],s,false,null,false,a)}};this.drawDotPlot=function(ai,ah,Z,R,ad,U,Q,Y,S,W,ak,aa,V,am,O,T,N,H,G){this.functionCaller="drawDotPlot";var M=this;var b=function(){var h=M.jitterColumns%2?M.jitterColumns+2:M.jitterColumns+3;var c=Math.max(ad-M.sizes[0],M.sizes[0])/(h-1);var a=[0];var d=1;for(var e=0;e<h/2;e+=2){a.push(d*-c);a.push(d*c);d++}return a};var F=function(e,a){var h=a[0];var d={n:{},arr:{}};for(var c=0;c<e.length;c++){var k=e[c].toString();if(!d.n.hasOwnProperty(k)){d.n[k]=0;d.arr[k]=[]}d.n[k]++}for(var k in d.n){switch(M.binAlignment){case"bottom":case"right":d.arr[k].push(0);d.n[k]--;while(d.n[k]>0){var j=d.arr[k][0];d.arr[k].unshift(j-h);d.n[k]--}break;case"top":case"left":d.arr[k].push(0);d.n[k]--;while(d.n[k]>0){var j=d.arr[k][d.arr[k].length-1];d.arr[k].push(j+h);d.n[k]--}break;case"center":if(d.n[k]%2){d.arr[k].push(0);d.n[k]--}else{d.arr[k].push(-h/2);d.n[k]--;d.arr[k].push(h/2);d.n[k]--}while(d.n[k]>0){var j=d.arr[k][0];d.arr[k].unshift(j-h);d.n[k]--;j=d.arr[k][d.arr[k].length-1];d.arr[k].push(j+h);d.n[k]--}break}}return d.arr};var B=[];var D=b();var K=this.graphType.match(/Bar/)&&this.barType=="lollipop"?0.5:0;if(W=="vertical"){for(var ac=0;ac<ai.length;ac++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var al=this.binned?F(ai[ac],S[ac]):false;for(var ab=0;ab<ai[ac].length;ab++){var X=this.binned?al[ai[ac][ab].toString()].shift():this.jitter?D[ab%D.length]:0;var g=am?am[ac][ab]:false;var P=R-((ai[ac][ab]-Y)*Q);var I=this.getFillColor(ak[ac][ab]);var J=this.getOutlineColor(I);if(this.isNumber(P,true)){var aj;if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){aj=this.addToRender(["drawShape",V[ac][ab],Z+X,P+(S[ac][ab]*K),S[ac][ab],S[ac][ab],this.background,I,aa[ac][ab],false,2,T],g,O,null,false,R)}else{aj=this.addToRender(["drawShape",V[ac][ab],Z+X,P+(S[ac][ab]*K),S[ac][ab],S[ac][ab],I,J,aa[ac][ab],false,false,T],g,O,null,false,R)}B.push([Z+X,P,S[ac][ab]/2,g]);if(!this.isGroupedData){if(ah[ac]&&ah[ac][ab]&&this.isNumber(ah[ac][ab],true)){var an=(ah[ac][ab]/2)*Q;this.addToRender(["drawLine","error",Z+X,P,Z+X,P+an,I,-ad,"butt",false,false,true],g,false,aj);this.addToRender(["drawLine","error",Z+X,P,Z+X,P-an,I,-ad,"butt",false,false,true],g,false,aj)}}}else{B.push([Z+X,Number.NaN,S[ac][ab]/2,g])}}if(this.showErrorBars&&this.isGroupedData&&ah[ac]&&ah[ac]&&this.isNumber(ah[ac][0],true)&&this.isNumber(ah[ac][1],true)){var P=R-((ah[ac][0]-Y)*Q);var an=(ah[ac][1]/2)*Q;var g=am?[am[ac][0][0],am[ac][0][1],"error"]:false;this.addToRender(["drawShape","diamond",Z,P,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,T],false,false,null,false,false,g);this.addToRender(["drawLine","line",Z,P-an,Z,P+an,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,T],false,false,null,false,false,g)}}Z+=U}}else{for(var ac=0;ac<ai.length;ac++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var al=this.binned?F(ai[ac],S[ac]):false;for(var ab=0;ab<ai[ac].length;ab++){var X=this.binned?al[ai[ac][ab].toString()].shift():this.jitter?D[ab%D.length]:0;var g=am?am[ac][ab]:false;var P=N?Z+N-((ai[ac][ab]-Y)*Q):Z+((ai[ac][ab]-Y)*Q);var I=this.getFillColor(ak[ac][ab]);var J=this.getOutlineColor(I);if(this.isNumber(P,true)){var aj;if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){aj=this.addToRender(["drawShape",V[ac][ab],P-(S[ac][ab]*K),R+X,S[ac][ab],S[ac][ab],this.background,I,aa[ac][ab],false,2,T],g,O,null,false,Z)}else{aj=this.addToRender(["drawShape",V[ac][ab],P-(S[ac][ab]*K),R+X,S[ac][ab],S[ac][ab],I,J,aa[ac][ab],false,false,T],g,O,null,false,Z)}B.push([P,R+X,S[ac][ab]/2,g]);if(!this.isGroupedData){if(ah[ac]&&ah[ac][ab]&&this.isNumber(ah[ac][ab],true)){var an=(ah[ac][ab]/2)*Q;this.addToRender(["drawLine","error",P,R+X,P+an,R+X,I,ad,"butt",false,false,true],g,false,aj);this.addToRender(["drawLine","error",P,R+X,P-an,R+X,I,ad,"butt",false,false,true],g,false,aj)}}}else{B.push([Number.NaN,R+X,S[ac][ab]/2,g])}}}if(this.showErrorBars&&this.isGroupedData&&ah[ac]&&ah[ac]&&this.isNumber(ah[ac][0],true)&&this.isNumber(ah[ac][1],true)){var P=Z+((ah[ac][0]-Y)*Q);var an=(ah[ac][1]/2)*Q;var g=am?[am[ac][0][0],am[ac][0][1],"error"]:false;this.addToRender(["drawShape","diamond",P,R,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,T],false,false,null,false,false,g);this.addToRender(["drawLine","line",P-an,R,P+an,R,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,T],false,false,null,false,false,g)}R+=U}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var x=this.meta.data.x[this.connectBy];var E=0;var ae=this.getKeys(this.connectByData);var f=this.getCustomColorScheme(ae.length);for(var ac in this.connectByData){var aj;var L=null;var ai=this.connectByData[ac];var I=this.connectByNoColor?this.connectByColor:x&&x.type!="Numeric"?x.connects[x.order[ac]%x.connects.length]:f[E%f.length];if(ai.length>1){for(var ab=1;ab<ai.length;ab++){var P=B[ai[ab-1]];var an=B[ai[ab]];aj=this.addToRender(["drawLine","line",P[0],P[1],an[0],an[1],I,this.connectByWidth,"butt",P[2],an[2],T],["Line:"+this.connectBy+" "+ac,P[3][0],P[3][2],an[3][2]],false,L);if(L==null){L=aj}}}E++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(B);if(G){var x=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var ac in this.connectByData){var ai=this.connectByData[ac];if(ai.length>1){for(var aa=0;aa<this.connectByDataVar[0].length;aa++){for(var ab=1;ab<ai.length;ab++){var P=this.connectByDataVar[ai[ab-1]][aa];var an=this.connectByDataVar[ai[ab]][aa];var ag=ac;if(P&&an){var C=this.data.y.vars[P[3][0]];var af=this.data.y.vars[an[3][0]];var A=this.data.y.smps[P[3][(this.isGroupedData?2:1)]];var z=this.data.y.smps[an[3][(this.isGroupedData?2:1)]];if(A==z){ag=C+" - "+af+" ("+A+")"}else{ag=C+" ("+A+") - "+af+" ("+z+")"}}this.addToRender(["drawLine","line",P[0],P[1],an[0],an[1],this.connectByColor,this.connectByWidth,"butt",P[2],an[2],T],["Line:"+this.connectBy+" "+ag])}}}}}}}};this.drawHeatmap=function(H,C,s,j,E,G,K,F,z,J,y){this.functionCaller="drawHeatmap";var n=0;var g=C;var x=1.5;var B=this.meta.vals;if(!B.colors){B.colors={}}for(var D=0;D<H.length;D++){var k=H[D];var I=k==null||!this.isNumber(k,true)?this.missingDataColor:B.colors[k.toString()]?B.colors[k.toString()]:this.getColorForValue(J,k);var A=G?I:this.heatmapCellBoxColor;B.colors[k==null?"null":k.toString()]=I;if(y){I=this.addColorTransparency(I,y)}if(this.graphType=="Network"){if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z[D]],K[D],F)}else{this.addToRender(["drawShape","rectangle",C+(j/2),s+(E/2),j,E,I,I,z[D]],K[D],F)}}else{if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z?z[D]:false],K[D],F)}else{if(D>0&&D<H.length-1){if(n>=0.5){this.addToRender(["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],K[D],F,null,false,[g,s+((E+x)/2),0,E+x]);n=0}}else{this.addToRender(["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],K[D],F,null,false,[g,s+((E+x)/2),0,E+x])}}}if(this.showDataValues){this.addToRender(["drawText",this.formatNumber(k),(C+j)-2,(s+E)-2,this.overlayFont,this.foreground,"right","bottom"])}C+=j;n+=j}};this.drawTreemap=function(B,u,p,C,D){this.functionCaller="drawTreemap";var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){f.functionCaller="drawTreemap";if(c){f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.getOutlineColor(d.color),"open",false,d.outline,C,D],false,false,null,false,r)}else{f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.getFillColor(d.color),f.getOutlineColor(d.color),"closed",false,false,C,D],d.index,false,null,false,r)}if(d.label){var b=f.measureText(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle"])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"])}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle",-Math.PI/2])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2])}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth?1:0;var E=this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.addToRender(["disableGradientTransparencyShadow"]);if(a.coords.border>1){this.addToRender(["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D]);this.addToRender(["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D])}else{if(a.coords.border>0){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}else{if(a.coords.border>-1){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}}}var z=this.measureText(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.addToRender(["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"])}this.addToRender(["enableGradientTransparencyShadow"])}if(a.children){s(a.children)}else{k(a)}}};this.drawSankey=function(b){this.functionCaller="drawSankey";var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.addToRender(["drawShape","bezier",c.plotX,c.plotY,f,c.dy,this.getFillColor(c.color),this.getOutlineColor(c.color),false,c.colors],c.tooltip,false,null,false,[this.left,this.top+this.y/2,f,c.dy])}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.addToRender(["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],e.tooltip,false,null,false,[this.left,this.top+this.y/2,e.dx,e.dy]);this.addToRender(["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2],[e.tooltip[0]+":T"])}};this.drawTree=function(a,f){this.functionCaller="drawTree";if(this.data.tree&&this.data.tree.plot){var k=this.data.tree.plot;var d=this.treeNodeSize/2;var h=this.treeNodeSize/4;var e=a=="vertical"?true:false;var g=this;var j=function(p){var l=e?p.x0:p.y0;var o=e?p.y0:p.x0;if(p.children){for(var m=0;m<p.children.length;m++){j(p.children[m])}if(e){if(p.parent){g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"right","middle",Math.PI/2],["Tree-Text:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"center","bottom"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{g.addToRender(["drawText",p.data.name,l-((g.treeNodeSize/2)+g.margin),o,g.smpLabelFont,g.smpLabelFontColor,"right","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{if(e){g.addToRender(["drawText",p.data.name,l,o+(g.treeNodeSize/2)+g.margin,g.smpLabelFont,g.smpLabelFontColor,"left","middle",Math.PI/2],["Tree-Text-:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l+(g.treeNodeSize/2)+g.margin,o,g.smpLabelFont,g.smpLabelFontColor,"left","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}g.addToRender(["drawShape",p.data.shape,l,o,p.data.size,p.data.size,g.getFillColor(p.data.color),g.treeLinkColor,p.data.pattern,false,g.treeLinkWidth],["Tree-Node:"+p.id],false,null,false,[b,i]);if(p._children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i]);g.addToRender(["drawLine","line",l,o-h,l,o+h,g.foreground],["Tree-Line2:"+p.id],false,null,true,[b,i])}else{if(p.children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i])}}};var c=function(s){if(s.children){for(var m=0;m<s.children.length;m++){c(s.children[m])}}if(s.parent){var l=e?s.x0:s.y0;var r=e?s.y0:s.x0;var o=e?s.parent.x0:s.parent.y0;var q=e?s.parent.y0:s.parent.x0;var p=s._clicked?[o,q,o,q]:[b,i,b,i];g.addToRender(["drawLine","bezier",o,q,l,r,g.treeLinkColor,g.treeLinkWidth,false],[s.parent.id+":"+s.id],false,null,false,p);s._clicked=false}};var b=e?k.x0:k.y0;var i=e?k.y0:k.x0;c(k);if(!f){j(k)}}};this.zoomOncoprintVariables=function(c){this.functionCaller="zoomOncoprintVariables";if(this.isTransition()){return}var b=[];this.setOriginalIndices(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw()};this.setFunctionNames("initConfigUtils")};CanvasXpress.prototype.init3dUtils=function(){this.setTrigonometry=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.set3DRotation=function(){this.setTrigonometry();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.set3DParams=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.get3DTransfrom=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h};this.setFunctionNames("init3dUtils")};CanvasXpress.prototype.initApiUtils=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.hasDecorations=function(){return this.decorations&&(this.decorations.nlfit||this.decorations.line||this.decorations.reg||this.decorations.nor||this.decorations.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.getHeatmapSchemes=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(a){return this.getObjectArray(a?this.highlightVar:this.highlightSmp)};this.modifyOverlaysProperties=function(g){this.functionCaller="modifyOverlaysProperties";if(this.isTransition()){return}var e=[];if(!this.isArray(g)){for(var d=0;d<arguments.length;d++){e.push(this.cloneObject(arguments[d]))}}else{e=this.cloneObject(g)}var b;var c=this;var a=e.shift();var f=this.cloneObject(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.draw()};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesVariablesAsArray=function(){return this.graphType.match(/scatter/i)?this.getSamplesAsArray():this.getVariablesAsArray};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.isBooleanData=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.getKeys(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.getSampleVariableData=function(k,p,n,j,q){var g={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var b={};b[k]={o:{},t:"string"};if(p){b[k]["o"]=this.getObjectArray(this.data.y[k])}else{for(var e=0;e<this[g[k]["idx"]].length;e++){b[k]["o"][this.data.y[k][this[g[k]["idx"]][e]]]=true}}if(j||q){var l=j?this.getVariableIndices(n):this.getSampleIndices(n,true);if(l>-1){b={};b[n]={o:{},t:"numeric"};if(p){var d=this.meta.data.y.range[n];b[n]["o"]={min:d.min,max:d.max}}else{var f=[];if(j){for(var e=0;e<this.smpIndices.length;e++){f.push(this.data.y.data[l][this.smpIndices[e]])}}else{for(var e=0;e<this.varIndices.length;e++){f.push(this.data.y.data[this.varIndices[e]][l])}}var a=this.range(f);b[n]["o"]={min:a[0],max:a[1]}}}}else{if(this.data[g[k]["spc"]]){for(var h in this.data[g[k]["spc"]]){if(n&&h!=n){continue}var d=this.meta.data[g[k]["spc"]][h];b[h]={o:{},t:d.type.toLowerCase()};if(p){if(d.type=="Numeric"){b[h]["t"]="numeric";b[h]["o"]={min:d.rmin,max:d.rmax}}else{b[h]["t"]="string";b[h]["o"]=this.cloneObject(d.levels)}}else{for(var e=0;e<this[g[k]["idx"]].length;e++){var c=this.getMetadataValue(this[g[k]["idx"]][e],g[k]["spc"],h,true);if(!b[h]["o"].hasOwnProperty(c)){b[h]["o"][c]=true}}if(b[h]["t"]=="numeric"){var f=[];for(var c in b[h]["o"]){for(var e=0;e<b[h]["o"][c];e++){f.push(c)}}var a=this.range(f);b[h]["o"]={min:a[0],max:a[1]}}}}}}return b};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFilteredNetworkData=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.getAdditionalData(d,b,this[g+"Properties"])}}this.isBooleanData(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.range(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.getFeatureData=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(b,a){this.functionCaller="clusterSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.clusterVariables=function(b,a){this.functionCaller="clusterVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.kmeansSamples=function(e,d){this.functionCaller="kmeansSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.kmeans();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.isInArray("k-Means-S",this.smpOverlays)){this.smpOverlays.push("k-Means-S")}this.updateMetaData("x","k-Means-S",false,true);this.modifySort("cat","smp","k-Means-S",true)}if(!d){this.draw()}};this.kmeansVariables=function(e,d){this.functionCaller="kmeansVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.kmeans();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.isInArray("k-Means-V",this.varOverlays)){this.varOverlays.push("k-Means-V")}this.updateMetaData("z","k-Means-V",false,true);this.modifySort("cat","var","k-Means-V",true)}if(!d){this.draw()}};this.setFunctions=function(){var a=this.functions;a.push("clusterSamples");a.push("clusterVariables");a.push("transpose");a.push("transform");a.push("hideUnhideSmps");a.push("hideUnhideVars");a.push("desegregateSamples");a.push("segregateSamples");a.push("groupSamples");a.push("ungroupSamples");a.push("desegregateVariables");a.push("segregateVariables");a.push("kmeansSamples");a.push("kmeansVariables");a.push("createContour");a.push("removeContour");a.push("showCodeDiv");a.push("hideCodeDiv");a.push("showInfoDiv");a.push("hideInfoDiv");a.push("updateCodeDiv");a.push("createHistogram");a.push("removeHistogram");a.push("addRegressionLine");a.push("addNormalDistributionLine");a.push("recalculateLayout");a.push("createRandomData");a.push("drawArea");a.push("draw");a.push("reset");a.push("print")};this.initializeApi=function(){this.setFunctions()};this.setFunctionNames("initApiUtils");this.initializeApi()};CanvasXpress.prototype.initDimensionUtils=function(){this.resizeCanvas=function(a,l,e){this.functionCaller="resizeCanvas";var c=this.margin;if(a||l||e){if(l||e){if(l){this.width=l;this.originalWidth=l}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.getTitleSubtitleHeight();this.left=c;this.right=c;this.bottom=c;this.resetRender()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width;this.meta.canvas.ctx.canvas.height=this.height;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width;this.meta.canvas.ctx2.canvas.height=this.height}this.addToRender(["disableGradientTransparencyShadow"]);if(this.backgroundType=="image"){if(this.graphType=="Network"){var k=this.scaleFactorX||1;var j=this.scaleFactorY||1;var b=this.offsetX*k;var o=this.offsetY*j;var i=this.maxX?this.maxX*k:this.maxX;var d=this.maxY?this.maxY*j:this.maxY;var n=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.isInIframe()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.addToRender(["drawShape","image",(i/2)+b,(d/2)+o,i,d,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.maxX,this.maxY,b,o,i,d,n)}}else{this.addToRender(["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage])}}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background])}else{var f=this.getLinearGradient(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,f,f])}}}this.addToRender(["enableGradientTransparencyShadow"])};this.setWidth=function(a,b){this.setDimensions(a,false,b)};this.setHeight=function(b,a){this.setDimensions(false,b,a)};this.getWidth=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.getHeight=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(b,f,e,d,a){this.functionCaller="setDimensions";if(this.isTransition()){return}if(!this.resizable){return}if(b&&f){if(Math.abs(this.width-b)<5&&Math.abs(this.height-f)<5){return}}if(!b||!this.resizableX){b=this.width}if(!f||!this.resizableY){f=this.height}var i=this.meta.canvas.ctx.canvas;b=i.originalWidth=parseInt(b);f=i.originalHeight=parseInt(f);this.clickLayoutNoAnimation(e);if(!this.reproducing){this.removeMotionDiv(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.draw(b,f);this.updateRemoteNavigationWindow();if(d){var g=this;setTimeout(function(){g.resizeViewport()},d)}else{this.resizeViewport()}if(a){a()}};this.initializeDimensions=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)};this.setFunctionNames("initDimensionUtils");this.initializeDimensions()};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.validateLegendPositions=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){if(this.graphType=="Circular"){if(this.legendPosition!="top"){this.legendPosition="right"}}else{if(this.graphType!="Pie"){this.legendPosition="right"}}}}if(this.graphType=="Pie"&&this.layoutValid){this.legendPosition="right"}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid&&!this.getLayoutConfig("legendPosition")){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.setLegendFont=function(){if(this.autoScaleFont){var e=(1-this.percentAspectRatioPlotArea);var b=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var c=this.layoutComb&&this.isDOE?this.layoutHeight:this.height;var a=this.min(b*e,c*e);this.setPropertyFontSize(a/(this.graphType=="Circular"?1.66:1),"legendFont")}else{this.legendFont=this.legendFontStyle+" "+parseInt(this.legendFontSize)+"px "+this.fontName}};this.drawLegendBackgroundBox=function(e,s,p,g,m,o,j,f){this.functionCaller="drawLegendBackgroundBox";var n=this.graphType=="Map"||this.graphType=="Correlation"?false:j?this.decorationsBackgroundColor:this.legendBackgroundColor;var c=f?this.legendBackgroundColor:j?this.decorationsBoxColor:this.legendBoxColor;var q=j?this.decorationsBox:this.legendBox;var k=this.graphType;var u=[0,0,this.width,this.height];var r=this.useRoundRectangles?"roundrect":"rectangle";if(m){if(q&&n&&!f&&k!="Network"){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape",r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u],[-1],o);this.addToRender(["enableGradientTransparencyShadow"])}else{if(n){this.addToRender(["drawShape",r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u],[-1],o)}else{this.addToRender(["drawShape",r,e+(p/2),s+(g/2),p,g,false,"rgba(0,0,0,0)","open",false,false,true,u],[-1],o)}}}else{if(q){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape",r,e+(p/2),s+(g/2),p,g,false,c,"open",false,false,true,u]);this.addToRender(["enableGradientTransparencyShadow"])}}};this.getDiameterLegend=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*12/833).toFixed(1))*this.legendScaleFontFactor};this.setCustomLegendDimensions=function(j){var e=j.text.length;var u=this.getDiameterLegend();var z=j.size;if(z){for(var k=0;k<z.length;k++){if(z[k]){u=Math.max(u,z[k])}}}var y=this.measureText(j.title&&this.showLegendTitle?j.title:"",this.legendFont);var g=this.measureText(this.getMaxText(j.text),this.legendFont);var p=this.getFontPt(this.legendFont);var v=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/v);var b=Math.max(y,(g+u+(this.margin*2))*v);var x=b+(this.margin*(v+2));var o=j.title&&this.showLegendTitle?(a*(Math.max(u,p)+this.margin))+p+(this.margin*2):(a*(Math.max(u,p)+this.margin))+(this.margin*1);this["legend"+j.id+"Width"]=x;this["legend"+j.id+"Height"]=o+this.margin};this.setPropertyLegendDimensions=function(c,n,b){var a=this.decapitalize(c)+"By";if((this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network"))||c=="Sample"){var r,g,o;if(n){r=this[a];if(b.type=="Numeric"&&((c.match(/shape/i)&&!this.shapeByContinuous)||(c.match(/size/i)&&!this.sizeByContinuous))){g=" "+n+" - "+n+" ";if(b){b.maxLevStrMod=g}}else{g=n}o=b&&b.sizes?b.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.x[this[a]].maxLevStrMod||this.meta.data.x[this[a]].maxLevStr;o=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.z[this[a]].maxLevStrMod||this.meta.data.z[this[a]].maxLevStr;o=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){r=this[a];g=this.meta.data.nodes[this[a]].maxLevStr;o=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){r=this[a];g=this.meta.data.edges[this[a]].maxLevStr;o=this.meta.data.edges[this[a]].sizes||this.sizes}else{r=0;g=0;o=this.sizes}}}}}var k=this.getDiameterLegend();if(c=="Size"||c=="SizeNode"||c=="SizeEdge"){for(var h=0;h<this["legend"+c+"sN"];h++){if(o[h]){k=Math.max(k,o[h])}}}else{if(c=="Sample"){r=0;g=this.legendSampleMaxStr}}var j=this.getFontPt(this.legendFont);var t=this.legendColumns>this["legend"+(c=="Outline"?"Color":c)+"sN"]?this["legend"+(c=="Outline"?"Color":c)+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+(c=="Outline"?"Color":c)+"sN"]/t);var q=this.showLegendTitle?this.measureText(r,this.legendFont):0;var s=(this.measureText(g,this.legendFont)+k+(this.margin*2))*t;this["legend"+(c=="Outline"?"Color":c)+"Width"]=Math.max(q,s)+(this.margin*(t+2));this["legend"+(c=="Outline"?"Color":c)+"Height"]=(e*(Math.max(k,j)+this.margin))+(c=="Sample"?0:(this.showLegendTitle?j+(this.margin*5):(this.margin*3)))}};this.setPropertyLegendIndicatorDimensions=function(e,b){var j=this.decapitalize(e)+"By";var d=0;var g=0;var i=this.getFontPt(this.legendFont);if(this[j]||e=="Decoration"){switch(e){case"Color":case"ColorNode":case"ColorEdge":case"Outline":case"Decoration":var a=this.showLegendTitle?this.measureText(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendFont):0;var c=b.maxLevLen;if(this.legendPosition.match(/top|bottom/)){g=this.heatmapIndicatorHeight+(this.margin*4)+(i*2);if(this.showLegendTitle){g+=i+this.margin}d=this.heatmapIndicatorWidth+Math.max(a,c)}else{g=this.heatmapIndicatorWidth+(this.margin*3)+(this.showLegendTitle?(i*2):0);d=this.heatmapIndicatorHeight+(this.margin*4)+Math.max(a,c)}break;case"Shape":case"ShapeNode":case"ShapeEdge":case"Size":case"SizeNode":case"SizeEdge":this.setPropertyLegendDimensions(e,b.maxLevStr,b);return;case"Pattern":case"PatternNode":case"PatternEdge":d=0;g=0;break}}this["legend"+(e=="Outline"?"Color":e)+"Width"]=d;this["legend"+(e=="Outline"?"Color":e)+"Height"]=g};this.setDecorationsLegendDimensions=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;this.legendDecorationMaxLabel=0;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var f=this.getFontPt(this.decorationFont);var h=this.decorations;var b=0;if(h.nlfit){var g=this.measureText(this.sprintf("%96s","X"),this.decorationFont)+(this.margin*5);var a=0;for(var e=0;e<h.nlfit.length;e++){var c=this.measureText(h.nlfit[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight=(h.nlfit.length*f*2)+f+this.margin}if(h.line){var a=0;for(var e=0;e<h.line.length;e++){if(h.line[e].label){var c=this.measureText(h.line[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}}if(a>0){b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.line.length*f*2)+this.margin}}if(h.reg){var g=this.measureText(this.sprintf("%45s","X"),this.decorationFont)+(this.margin*2);var a=0;for(var e=0;e<h.reg.length;e++){var c=this.measureText(h.reg[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.reg.length*f*2)+f+this.margin}if(h.nor){var g=this.measureText(this.sprintf("%30s","X"),this.decorationFont)+(this.margin*1);var a=0;for(var e=0;e<h.nor.length;e++){var c=this.measureText(h.nor[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.nor.length*f*2)+f+this.margin}if(h.area){var a=0;for(var e=0;e<h.area.length;e++){var c=this.measureText(h.area[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.area.length*f*2)+this.margin}if(h.qq){var a=0;for(var e=0;e<h.qq.length;e++){var c=this.measureText(h.qq[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.qq.length*f*2)+this.margin}if(h.cdf){var a=0;for(var e=0;e<h.cdf.length;e++){var c=this.measureText(h.cdf[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.cdf.length*f*2)+this.margin}if(h.kaplanMeier){var a=0;for(var e=0;e<h.kaplanMeier.length;e++){var c=this.measureText(h.kaplanMeier[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.kaplanMeier.length*f*2)-this.margin}this.legendDecorationWidth=b}};this.setOncoprintLegendDimension=function(){this.legendOncoprintWidth=0;this.legendOncoprintHeight=0;this.legendOncoprintColors={};if(this.isOncoprint){var g=this.cloneObject(this.meta.data[this.oncoprintCNA].levels);var h=this.cloneObject(this.meta.data[this.oncoprintCNA].colors);var b=[];g.push("No Alteration");h.push("rgb(220,220,220");for(var e=0;e<g.length;e++){b.push("CNA")}var k=g.length;if(this.oncoprintMUT){g=g.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].levels));h=h.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].colors));for(var e=k;e<g.length;e++){b.push("MUT")}}var j=[];var f=[];for(var e=0;e<g.length;e++){if(g[e]){j.push(g[e]);f.push(b[e]);this.legendOncoprintColors[g[e]]=h[e];if(h[e]=="rgb(220,220,220"){this.legendOncoprintMutations=j.length}}}var d=this.getMaxText(j,this.legendFont);var c=this.measureText(d,this.legendFont);var a=Math.ceil(c+5+(this.margin*8));var h=Math.floor(this.width/a);var l=Math.ceil(j.length/h);this.legendOncoprintWidth=a*h;this.legendOncoprintHeight=((21+this.margin)*l)+this.margin;this.legendOncoprintRows=l;this.legendOncoprintCols=h;this.legendOncoprintLabels=j;this.legendOncoprintObjects=f}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;this.legendSampleMaxStr="";this.legendSampleMaxStrLen=0;this.legendSamplesN=1;var e=this.getFontPt(this.legendFont);var b=0;var h;var f=this.decorations&&this.decorations.kaplanMeier;var c=this.decorations&&this.decorations.qq;var g=this.decorations&&this.decorations.cdf;if(this.graphType.match(/Scatter/)&&!f&&!c&&!g){if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){this.legendSamplesN=this.xAxisIndices.length;for(var d=0;d<this.xAxisIndices.length;d++){var a;if(this.isHistogram){h=this.shortenText(this.xAxis[d],this.maxSmpStringLen)}else{h=this.shortenText(this.xAxis[d],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[d],this.maxSmpStringLen)}a=this.measureText(h,this.legendFont);if(a>b){this.legendSampleMaxStr=h}b=Math.max(a,b)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){this.legendSampleMaxStr=this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen);b=this.measureText(this.legendSampleMaxStr,this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.isHistogram){this.legendSampleMaxStr=this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen);b=this.measureText(this.legendSampleMaxStr,this.legendFont)}else{this.legendSampleMaxStr=this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen);b=this.measureText(this.legendSampleMaxStrr,this.legendFont)}}}}this.legendSampleWidth=(e-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(e+this.margin))+this.margin}else{if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont);this.legendSampleWidth=(e-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(e+this.margin))+this.margin}}this.legendSampleMaxStrLen=b}};this.setVariableLegendDimension=function(){this.legendVariableWidth=0;this.legendVariableHeight=0;var h=this;var g=function(){if(h.isDOE&&h.layoutCurrentDOE){if(h.layoutCurrentDOE){if(h.meta.data.x&&h.meta.data.x.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.x[h.layoutCurrentDOE]}else{if(h.meta.data.z&&h.meta.data.z.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.z[h.layoutCurrentDOE]}}}}return h.meta.data.y};var c=g();var a=this.getFontPt(this.legendFont);if(this.graphType=="Pie"){var b=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var f=this.isDOE&&this.layoutCurrentDOE?this.shortenText(c.maxLevStr,this.maxVarStringLen):this.shortenText(c.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&f.length<5){f=this.shortenText("Other",this.maxVarStringLen)}var e=this.measureText(f,this.legendFont)+a+(this.margin*3);var k=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var j=(1-this.percentAspectRatioPlotArea);this.legendVariableWidth=e>k*j?k*j:this.measureText(f,this.legendFont)+a+(this.margin*5);this.legendVariableHeight=((a+this.margin)*b)+(this.margin*2)}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.data.y.vars.length/this.legendColumns)*a*1.5)+(this.margin*2)}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var o=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var f=this.shortenText(c.maxVarStr,this.maxVarStringLen);this.legendVariableWidth=((o-1)+this.measureText(f,this.legendFont)+(this.margin*3))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*(o+this.margin))+(this.margin*2)}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil((this.xAxisVarIndices.length+this.xAxis2VarIndices.length)/this.legendColumns)*a*1.5)+(this.margin*2)}else{if(!this.colorBy&&(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*a*1.5)+(this.margin*2)}else{if(this.graphType=="Circular"&&!this.showIdeogram){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var i=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(i/this.legendColumns)*a*1.5)+(this.margin*2)}}}}}}};this.setVennLegendDimension=function(){var a=this.data.venn.legend?this.getMaxText(this.data.venn.legend):"N/A";this.legendWidth=this.measureText(a,this.legendFont)+(this.margin*6);this.legendHeight=this.margin+this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)};this.setOverlaysLegendDimensions=function(){var b=this.getFontPt(this.legendFont);var s=this.getDiameterLegend();var k=Math.max(b,s);var d=["varOverlays","smpOverlays"];var e=["varOverlayProperties","smpOverlayProperties"];var y=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legendOverlaysLayout=[];this.legendOverlaysWidth=0;this.legendOverlaysHeight=0;var q=this.margin;var n=this.margin;var a=0;var g=0;var l=0;var B=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)){for(var v=0;v<d.length;v++){if(this[d[v]].length>0&&this[y[v]]){for(var t=0;t<this[d[v]].length;t++){var f=0;var x=0;var p=this[d[v]][t];if(p!="-"){var A=d[v]=="varOverlays"?"z":"x";var r=this.meta.data[A][p];var u=this.measureText(r.maxLevStr,this.legendFont);var z=this.measureText(p,this.legendFont);if(this.graphType=="Circular"||(this[e[v]][p]&&this[e[v]][p].type=="Default"&&this[e[v]][p].showLegend)){B=true;if(r.type=="String"){f=Math.max(z,u+k+(this.margin*3))*this[d[v]+"LegendColumns"];x=((Math.max(b,s)+this.margin)*Math.ceil(r.levels.length/this[d[v]+"LegendColumns"]))+b+(this.margin*3)}else{if(this.overlaysLegendPosition.match(/right/i)){f=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z);x=this.heatmapIndicatorWidth+(this.margin*3)+b}else{f=this.heatmapIndicatorWidth+(this.margin*3)+b;x=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z)}}this["legend"+p+"Width"]=f;this["legend"+p+"Height"]=x;if(this.overlaysLegendPosition.match(/right/i)){if(g+this.margin+x>(this.height-(this.top+this.bottom))){q+=this.margin+f;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(f>a){q+=(f-a);a=f}g+=x;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}else{if(a+this.margin+f>(this.width-(this.left+this.right))){n+=this.margin+x;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(x>g){n+=(x-g);g=x}a+=f;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legendOverlaysWidth=B?q+this.margin:0;this.legendOverlaysHeight=B?g+this.margin:0}else{this.legendOverlaysWidth=B?a+this.margin:0;this.legendOverlaysHeight=B?n+this.margin:0}};this.setLegendDimensions=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legendLayout=[];this.legendWidth=0;this.legendHeight=0;var a=this.margin;var k=this.margin;var b=0;var j=0;var g=0;var e=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample"];for(var c=0;c<e.length;c++){var f=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(e[c]=="Decoration"&&!this.showDecorations){continue}if(f>0){if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[e[c]];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[e[c]];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}for(var c=0;c<this.legend.length;c++){this.legend[c].id="Custom"+c;this.setCustomLegendDimensions(this.legend[c]);var f=this["legendCustom"+c+"Width"];var d=this["legendCustom"+c+"Height"];if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[this.legend[c].id];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[this.legend[c].id];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}}this.legendWidth=b==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:b+this.margin;this.legendHeight=j==0&&k==this.margin?0:this.legendPosition.match(/right|left/i)?j+this.margin:k+this.margin;if(this.legendPositionAuto&&!this.legendInside&&!this.legendPositionTest){if(this.legendPosition.match(/right|left/i)&&this.legendWidth>this.legendHeight*1.5){this.legendPositionTest=true;this.legendPosition="bottom";this.setLegends()}else{if(this.legendPosition.match(/top|bottom/i)&&this.legendHeight>this.legendWidth*1.5){this.legendPositionTest=true;this.legendPosition="right";this.setLegends()}}this.legendPositionTest=false}}};this.setLegends=function(q){var h=this;var g=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Outline"]:["Color","Shape","Size","Pattern","Outline","Connect"];var r=["shapeByData","sizeByData","patternByData","outlineByData"];var n=function(a,o,t,v){var u=o=="Outline"?"Color":o;var s=(h.decapitalize(u)+"s").replace("Node","").replace("Edge","").replace("decorations","colors");delete (h["legend"+u+"sS"]);h["legend"+u+"Meta"]=a;if(t){h["legend"+u+"Meta"].vals=h.rPretty(t[0],t[1],5);h["legend"+u+"Meta"].decs=h.getAxisDecimals(t[1]-t[0]);h["legend"+u+"Meta"].maxLevStr=h.getMaxText(h["legend"+(o=="Outline"?"Color":o)+"Meta"].vals);h["legend"+u+"Meta"].maxLevLen=h.measureText(h["legend"+u+"Meta"].maxLevStr,h.font);h["legend"+u+"Meta"].maxLevChr=h["legend"+u+"Meta"].maxLevStr.toString().length}h["legend"+u+"sMax"]=h["legend"+u+"Meta"].maxLevStr;h["legend"+u+"sN"]=h["legend"+u+"Meta"].vals.length;for(var p=0;p<h["legend"+u+"Meta"].vals.length;p++){h["legend"+u+"s"][h["legend"+u+"Meta"].vals[p].toString()]=u=="Connect"?h.colors[p]:h[s][p]}h.setPropertyLegendIndicatorDimensions(o,h["legend"+u+"Meta"])};var j=function(B,I,x,D,y){var F=0;var v=0;var A=false;var C={};var s={};var a=B[h.decapitalize(D).replace("Node","").replace("Edge","")+"s"]||h[h.decapitalize(D).replace("Node","").replace("Edge","")+"s"];var z=h.isGroupedData&&h.graphType!="Dotplot"&&h.graphType!="Boxplot"&&!h.showBoxplotOriginalData&&h.groupingFactors.length==1;if(I=="x"){var t=h.isGroupedData?h.grpIndices:h.smpIndices;for(var G=0;G<t.length;G++){var u=t[G];if(h.isGroupedData&&(h.graphType=="Dotplot"||h.graphType=="Boxplot"||h.barType=="swimmer"||h.graphType=="Gantt")){h.isGroupedData=false;for(var E=0;E<h.data.w.grps[u].length;E++){var w=h.getMetadataValue(h.data.w.grps[u][E],I,h[x]);s[w]=true}h.isGroupedData=true}else{var w=h.isGroupedData?h.getSmpAnnotations(h[x],h.data.w.grps[G],true):h.getMetadataValue(u,I,h[x]);s[w]=true}}}else{if(I=="z"){for(var G=0;G<h.varIndices.length;G++){var u=h.varIndices[G];var w=h.getMetadataValue(u,I,h[x]);s[w]=true}}else{if(I=="m"){for(var G=0;G<h.varIndices.length;G++){for(var E=0;E<h.smpIndices.length;E++){var w=y[h.varIndices[G]][h.smpIndices[E]];s[w]=true}}}else{if(I=="modified"){B.order={};for(var G=0;G<B.levels.length;G++){s[B.levels[G]]=true;B.order[B.levels[G]]=G}}else{if(I=="nodes"||I=="edges"){B.order={};for(var G=0;G<B.levels.length;G++){s[B.levels[G]]=true;B.order[B.levels[G]]=G}}}}}}s=h.getKeys(s);if(B.type=="Numeric"){if(B.orderS){s.sort(function(l,i){return B.orderS[l]-B.orderS[i]})}else{s.sort(function(l,i){return l-i});B.orderS={};for(var G=0;G<s.length;G++){B.orderS[s[G]]=G}}}else{s.sort(function(l,i){return B.order[l]-B.order[i]})}for(var G=0;G<s.length;G++){var w=s[G]!=null?s[G]:"NA";var H=h.measureText(w,h.legendFont);if(H>F){F=H;h["legend"+D+"sMax"]=w}C[w]=(B.type=="Numeric"?B.orderS[w]:B.order[w])%a.length;h["legend"+D+"s"][w]=a[C[w]];v++}h["legend"+D+"sS"]=s;A=I=="m"||I=="modified"?h["legend"+D+"sMax"]:false;h["legend"+D+"sN"]=v;h["legend"+D+"Meta"]=B;h.setPropertyLegendDimensions(D,A,B)};this.validateLegendPositions();this.setLegendFont();if(this.graphType=="Venn"){this.setVennLegendDimension();return}else{if(this.graphType=="Network"){for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){var d=this.meta.data[e.match("Node")?"nodes":"edges"][this[b]];if(d.type=="Numeric"){n(d,e)}else{j(d,e.match("Node")?"nodes":"edges",b,e)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var d=this.meta.data.decorations;var e="Decoration";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;n(d,e)}}else{if(this.isMultidimensionalData){for(var f=0;f<r.length;f++){if(this.data.y[this[r[f]]]){var c=this.data.y[this[r[f]]];var d=this.meta.data[this[r[f]]];var e=r[f].replace("ByData","");e=this.capitalize(e);var k=this.decapitalize(e);var b=k+"By";this["legend"+(e=="Outline"?"Color":e)+"s"]=[];this["legend"+(e=="Outline"?"Color":e)+"sN"]=0;if(d.type=="Numeric"){n(d,e,[d.min,d.max])}else{j(d,"m",b,e,c)}}}}else{for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(q){continue}if(this[b]){if(this.data.x&&this.data.x.hasOwnProperty(this[b])){var d=this.meta.data.x[this[b]];this[k+"ByType"]="x";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"x",b,e)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[b])){var d=this.meta.data.z[this[b]];this[k+"ByType"]="z";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"z",b,e)}}else{if(this.getSampleIndices(this[b])>-1&&this.meta.data.y.range[this[b]]){var d=this.meta.data;if(d.modified&&d.modified.z&&d.modified.z[this[b]]){d=d.modified.z;if(!d.meta){d.meta={}}d.meta[this[b]]={levels:d[this[b]]};j(d.meta[this[b]],"modified",b,e)}else{d=d.y.range[this[b]];n(d,e,[d.min,d.max])}}else{if(this[b]=="variable"){h["legend"+e+"sN"]=this.varIndices.length}}}}}}}}}this.setDecorationsLegendDimensions();this.setSampleLegendDimension();this.setVariableLegendDimension();this.setOncoprintLegendDimension();this.setOverlaysLegendDimensions();this.setLegendDimensions()};this.addLegend=function(c,b){if(c){if(b){var a=this.findXYCoordinates(b);c.x=a.x;c.y=a.y}this.legend.push(c)}};this.deleteLegend=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.legend.length;a++){if(this.legend[a].id!=c.id){b.push(this.legend[a])}}this.legend=b}};this.drawDecorationData=function(){this.functionCaller="drawDecorationData";this.addToRender(["setClipArea",this.setClipBoundaries()]);var ad=this.marginLeft+this.offsetX+this.left;var Y=this.marginTop+this.offsetY+this.top;var al=this.decorations;if(this.showDecorations&&al){if(this.graphType.match(/Scatter/)){if(al.qq){for(var ah=0;ah<al.qq.length;ah++){var an=al.qq[ah].data;var N=al.qq[ah].color;var aE=al.qq[ah].index;if(this.isInArray(aE,this.smpIndices)){for(var ag=0;ag<this.qqPoints;ag++){var J=ad+(an.x[ag]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(Y+this.y)-(an.y[ag]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.addToRender(["drawShape","circle",J,g,this.dataPointSize,this.dataPointSize,false,N,"open"],["QQ-"+ah+"-"+ag])}this.addToRender(["drawLine","line",ad,Y+this.y,ad+this.x,Y,this.fitLineColor,2])}}}else{if(al.cdf){for(var ah=0;ah<al.cdf.length;ah++){var an=al.cdf[ah].data;var N=al.cdf[ah].color;var aE=al.cdf[ah].index;if(this.isInArray(aE,this.smpIndices)){var aJ=[];var az=[];for(var ag=0;ag<an.x.length;ag++){aJ.push(ad+(an.x[ag]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit));az.push((Y+this.y)-(an.y[ag]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit))}this.addToRender(["drawLine","spline",aJ,az,false,false,N,2],["CDF-"+ah])}}}else{if(al.nlfit){var h,O,f;var G=this.varIndices;var J,g;for(var ah=0;ah<al.nlfit.length;ah++){var aI=[];var aG=[];var N=ah%this.colors.length;var a=Number(this.transformValue(this.yAxisTransform,al.nlfit[ah].param[0]));var aW=Number(this.transformValue(this.yAxisTransform,al.nlfit[ah].param[1]));var aU=Number(al.nlfit[ah].param[2]);var aS=Number(al.nlfit[ah].param[3]);var Z=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[ah];var aJ=this.getDataForSmpGrpAtIndex(Z);if(this.xAxisTransform=="percentile"){h=this.range(aJ);f=h[0];O=h[1]}G.sort(function(i,d){return aJ[i]-aJ[d]});N=al.nlfit[ah].color?al.nlfit[ah].color:this.colors[N];for(var ag=0;ag<G.length;ag++){var C=G[ag];var R=this.getDataAtPos(C,Z);var Q;var M=[];if(R>0){if(ag>0){var aH=G[ag-1];var aK=this.getDataAtPos(aH,Z);if(aK>0){var S=(R-aK)/this.functionIntervals;for(var af=0;af<this.functionIntervals;af++){M.push(aK);aK+=S}}}else{M=[R]}for(var af=0;af<M.length;af++){if(al.nlfit[ah].type=="reg"){Q=a+((aW-a)/(1+aU/(Math.pow(M[af],aS))))}else{Q=a+((aW-a)/(1+(Math.pow((M[af]/aU),aS))))}if(this.xAxisTransform){M[af]=this.xAxisTransform=="percentile"?this.percentile(f,O,M[af]):this.transformValue(this.xAxisTransform,M[af])}J=ad+((M[af]-this.xAxisMin)*this.xAxisUnit);g=(Y+this.y)-((Q-this.yAxisMin)*this.yAxisUnit);aI.push(J);aG.push(g)}}}if(aI.length>0){this.addToRender(["drawShape","path",aI,aG,false,false,N,N,"open",false,false,true],["Decor-Non-Lin-"+ag+"-"+ah]);if(al.nlfit[ah].type=="reg"){Q=a+((aW-a)/(1+aU/(Math.pow(aU,aS))))}else{Q=a+((aW-a)/(1+(Math.pow((aU/aU),aS))))}if(this.xAxisTransform){aU=this.xAxisTransform=="percentile"?this.percentile(f,O,aU):this.transformValue(this.xAxisTransform,aU)}J=ad+((aU-this.xAxisMin)*this.xAxisUnit);g=(Y+this.y)-((Q-this.yAxisMin)*this.yAxisUnit);var aE=this.addToRender(["drawLine","dottedLine",ad,g,J,g,N],["Decor-Non-Lin-EC-h"+ag+"-"+ah]);this.addToRender(["drawLine","dottedLine",J,g,J,(Y+this.y),N],["Decor-Non-Lin-EC-v"+ag+"-"+ah],false,aE)}}}if(al.line){for(var ah=0;ah<al.line.length;ah++){if(al.line[ah].x!=null||al.line[ah].y!=null){var N=al.line[ah].color?al.line[ah].color:this.colors[ah%this.colors.length];var ap=al.line[ah].type?al.line[ah].type:"line";var R=al.line[ah].x!=null?al.line[ah].x:null;var Q=al.line[ah].y!=null?al.line[ah].y:null;var F=al.line[ah].x2!=null?al.line[ah].x2:null;var b=al.line[ah].y2!=null?al.line[ah].y2:null;var T=al.line[ah].width?al.line[ah].width:1;var J,g,H,e;if(R!=null&&Q!=null&&F!=null&&b!=null){J=ad+((R-this.xAxisMin)*this.xAxisUnit);H=ad+((F-this.xAxisMin)*this.xAxisUnit);g=Y+this.y-((Q-this.yAxisMin)*this.yAxisUnit);e=Y+this.y-((b-this.yAxisMin)*this.yAxisUnit);this.addToRender(["drawLine",ap,J,g,H,e,N,T],["Decor-Line-"+ah])}else{if(R!=null){J=ad+((R-this.xAxisMin)*this.xAxisUnit);g=Y;H=J;e=g+this.y;this.addToRender(["drawLine",ap,J,g,H,e,N,T],["Decor-Line-"+ah])}else{if(Q!=null){J=ad;g=Y+this.y-((Q-this.yAxisMin)*this.yAxisUnit);H=J+this.x;e=g;this.addToRender(["drawLine",ap,J,g,H,e,N,T],["Decor-Line-"+ah])}}}}}}if(al.reg){for(var ah=0;ah<al.reg.length;ah++){if(al.reg[ah].slope&&al.reg[ah].intercept){var p=al.reg[ah].fit?al.reg[ah].fit:this.colors[ah%this.colors.length];var N=al.reg[ah].color?al.reg[ah].color:this.colors[ah%this.colors.length];var I=this.addColorTransparency(N,0.3);var m=this.getPropertyValue(ah,false,"patternBy");var am=al.reg[ah].style?al.reg[ah].style:this.fitLineStyle;var aN=Number(al.reg[ah].slope);var aj=Number(al.reg[ah].intercept);var ae=al.reg[ah].id;var K=al.reg[ah].cor;var z="y ~ "+this.formatNumber(aN,this.yAxisDecs+1)+"x + "+this.formatNumber(aj,this.yAxisDecs+1)+" (r = "+this.formatNumber(K,3)+")";var U=al.reg[ah].ci;var L=U.length-1;var J=this.showRegressionFullRange||!U?this.xAxisMin:U[0][0];var g=(aN*J)+aj;var H=this.showRegressionFullRange||!U?this.xAxisMax:U[L][0];var e=(aN*H)+aj;J=ad+(J*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Y+this.y)-(g*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);H=ad+(H*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Y+this.y)-(e*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var aB=this.lineClip([[J,g],[H,e]]);if(aB.length){this.addToRender(["drawLine",am,aB[0][0][0],aB[0][0][1],aB[0][1][0],aB[0][1][1],p,2],["Decor-Reg-"+ah,ae])}if(U){var A=[];var u=[];var av=[];for(var ag=0;ag<U.length;ag++){J=ad+(U[ag][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Y+this.y)-(U[ag][1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);e=(Y+this.y)-(U[ag][2]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);A.push([J,J]);u.push([g,e]);av.push([J,(g+e)/2])}if(this.showConfidenceIntervals){this.addToRender(["drawShape","confidence",A,u,false,false,I,N,m],[z+":Confidence",ae],false,null,false,av)}}}}}if(al.nor){for(var ah=0;ah<al.nor.length;ah++){if(al.nor[ah].mu&&al.nor[ah].sigma){var E=[];var D=[];var aF=[];var J,g;var N=ah%this.colors.length;var aw=al.nor[ah].mu;var ar=al.nor[ah].sigma;var r=al.nor[ah].start?al.nor[ah].start:al.nor[ah].yAxis?this.yAxisMin:this.xAxisMin;var ai=al.nor[ah].end?al.nor[ah].end:al.nor[ah].yAxis?this.yAxisMax:this.xAxisMax;var ay=120;if(r<aw&&aw<ai){var aK,aA,s,c;var S=(aw-r)/ay;var v=ar*ar;var X=v*2;var ak=1/Math.sqrt(2*Math.PI*v);if(al.nor[ah].yAxis){s=al.nor[ah].max?al.nor[ah].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);c=s/ak;aK=r;for(var ag=0;ag<ay-1;ag++){aA=(ak*Math.pow(Math.E,-Math.pow(aK-aw,2)/v));aF.push([aK,aA]);J=ad+(aA*c);g=(Y+this.y)-(aK*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);E.push(J);D.push(g);aK+=S}S=(ai-aw)/ay;aK=aw;for(var ag=0;ag<ay;ag++){aA=(ak*Math.pow(Math.E,-Math.pow(aK-aw,2)/v));aF.push([aK,aA]);J=ad+(aA*c);g=(Y+this.y)-(aK*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);E.push(J);D.push(g);aK+=S}N=al.nor[ah].color?al.nor[ah].color:this.colors[N];this.addToRender(["drawShape","path",E,D,false,false,N,N,"open",false,false,true],["Decor-Nor-"+ah])}else{s=al.nor[ah].max?al.nor[ah].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);c=s/ak;aK=r;for(var ag=0;ag<ay-1;ag++){aA=(ak*Math.pow(Math.E,-Math.pow(aK-aw,2)/v));aF.push([aK,aA]);J=ad+(aK*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Y+this.y)-(aA*c);E.push(J);D.push(g);aK+=S}S=(ai-aw)/ay;aK=aw;for(var ag=0;ag<ay;ag++){aA=(ak*Math.pow(Math.E,-Math.pow(aK-aw,2)/v));aF.push([aK,aA]);J=ad+(aK*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Y+this.y)-(aA*c);E.push(J);D.push(g);aK+=S}N=al.nor[ah].color?al.nor[ah].color:this.colors[N];this.addToRender(["drawShape","path",E,D,false,false,N,N,"open",false,false,true],["Decor-Nor-"+ah])}}}}}if(al.area){for(var ah=0;ah<al.area.length;ah++){if(al.area[ah].type&&al.area[ah].x&&al.area[ah].y&&al.area[ah].width&&al.area[ah].height){if(this.isValidShape(al.area[ah].type)){var J=ad+(al.area[ah].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(Y+this.y)-(al.area[ah].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var N=al.area[ah].color?al.area[ah].color:this.colors[ah%this.colors.length];var q=al.area[ah].width*this.xAxisUnit;var ao=al.area[ah].height*this.yAxisUnit;this.addToRender(["drawShape",al.area[ah].type,J,g,q,ao,N,al.area[ah].outline,al.area[ah].pattern,al.area[ah].rotate],["Decor-Area-"+ah])}}}}if(al.kaplanMeier){var J,g,H,e,aO,aM,ab,aa,N,I,aq,aP,aR,aQ,aD,aE,ac,aV,aT,n,au;for(var ah=0;ah<al.kaplanMeier.length;ah++){aq=[[],[]];aP=[[],[]];aR=[[],[]];N=al.kaplanMeier[ah].color;I=this.addColorTransparency(N,0.3);n=this.getSampleIndices(al.kaplanMeier[ah].time,false,this.isDOE);au=this.getSampleIndices(al.kaplanMeier[ah].censored,false,this.isDOE);ac=this.kaplanMeier(this.getDataForSmpGrpAtIndex(n,al.kaplanMeier[ah].indices),this.getDataForSmpGrpAtIndex(au,al.kaplanMeier[ah].indices));J=ad;g=(Y+this.y)-(this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);H=ad+(Number(ac.time[0])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Y+this.y)-(ac.kaplanMeier[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aM=(Y+this.y)-(ac.upperLimit[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aa=(Y+this.y)-(ac.lowerLimit[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aQ=J;aD=g;aV=e-this.margin;aT=e+this.margin;aE=this.addToRender(["drawLine","line",J,g,H,g,N],["Decor-KM-h-0-"+ah],false,null,false,[aQ,aD,aQ,aD]);this.addToRender(["drawShape","circle",H,e,1,1,N],false,aE,false,[aQ,aD]);this.addToRender(["drawLine","line",H,g,H,e,N],["Decor-KM-v-0-"+ah],false,aE,false,[aQ,aD,aQ,aD]);if(ac.nCensored[0]){this.addToRender(["drawLine","line",H,aV,H,aT,N,2],["Decor-KM-c-0-"+ah],false,aE,false,[aQ,aD,aQ,aD])}aq[0].push(J,H);aq[1].push(aM,aM);aP[0].push(J,H);aP[1].push(aa,aa);for(var ag=1;ag<ac.time.length-1;ag++){J=ad+(Number(ac.time[ag-1])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Y+this.y)-(ac.kaplanMeier[ag]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aO=(Y+this.y)-(ac.upperLimit[ag]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);ab=(Y+this.y)-(ac.lowerLimit[ag]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);H=ad+(Number(ac.time[ag])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Y+this.y)-(ac.kaplanMeier[ag+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aM=(Y+this.y)-(ac.upperLimit[ag+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aa=(Y+this.y)-(ac.lowerLimit[ag+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aV=e-this.margin;aT=e+this.margin;this.addToRender(["drawLine","line",J,g,H,g,N],["Decor-KM-h-"+ag+"-"+ah],false,aE,false,[aQ,aD,aQ,aD]);this.addToRender(["drawShape","circle",H,e,1,1,N],false,aE,false,[aQ,aD]);this.addToRender(["drawLine","line",H,g,H,e,N],["Decor-KM-v-"+ag+"-"+ah],false,aE,false,[aQ,aD,aQ,aD]);if(ac.nCensored[ag]){this.addToRender(["drawLine","line",H,aV,H,aT,N,2],["Decor-KM-c-"+ag+"-"+ah],false,aE,false,[aQ,aD,aQ,aD])}aq[0].push(J,H,H);aq[1].push(aO,aO,aM);aP[0].push(J,H,H);aP[1].push(ab,ab,aa)}J=H;H=ad+(Number(ac.time[ag])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);this.addToRender(["drawLine","line",J,e,H,e,N],["Decor-KM-h-"+ag+"-"+ah],false,aE,false,[aQ,aD,aQ,aD]);aq[0].push(H,H);aq[1].push(aM,aM);aP[0].push(H,H);aP[1].push(aa,aa);if(this.showConfidenceIntervals){aR[0]=aq[0].concat(aP[0].reverse());aR[1]=aq[1].concat(aP[1].reverse());this.addToRender(["drawShape","polygon",aR[0],aR[1],false,false,I,I,"closed"],["Decor-KM-Conf"+ah])}}}}}}else{if(al.line){for(var ah=0;ah<al.line.length;ah++){var J,g,H,e;var at=true;var ap=al.line[ah].type||"line";var B=al.line[ah].color;var W=this.transformValue(this.isTransformedData,al.line[ah].value||0);var o=al.line[ah].label||false;var aC=al.line[ah].width||1;var aL=al.line[ah].align||"left";var ax=al.line[ah].scope||false;if(this.graphOrientation=="vertical"){J=this.marginLeft+this.offsetX+this.left;H=J+this.x;g=this.marginTop+this.offsetY+this.top+this.y-((W-this.xAxisMin)*this.xAxisUnit);e=g;at=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{J=this.marginLeft+this.offsetX+this.left+((W-this.xAxisMin)*this.xAxisUnit);H=J;g=this.marginTop+this.offsetY+this.top;e=g+this.y;at=J<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(at&&ax){if(this.layoutValid){at=false;var V=this.toArray(this.data.l.name[this.layoutCurrent]);for(var ag=0;ag<V.length;ag++){if(ax==V[ag]){at=true}}}}if(at){var P=this.isR?6:3;if(o){if(this.graphOrientation=="vertical"){if(aL=="right"){this.addToRender(["drawText",o,H-this.margin,e-this.margin,this.decorationFont,this.decorationColor,"right","bottom"])}else{if(aL=="center"){this.addToRender(["drawText",o,J+(this.x/2),e-this.margin,this.decorationFont,this.decorationColor,"center","bottom"])}else{this.addToRender(["drawText",o,J+this.margin,e-this.margin,this.decorationFont,this.decorationColor,"left","bottom"])}}}else{if(aL=="right"){this.addToRender(["drawText",o,H+(this.margin*2),e-(this.margin*P),this.decorationFont,this.decorationColor,"left","middle"])}else{if(aL=="center"){this.addToRender(["drawText",o,H+(this.margin*2),g+(this.y/2),this.decorationFont,this.decorationColor,"left","middle"])}else{this.addToRender(["drawText",o,H+(this.margin*2),g+(this.margin*P),this.decorationFont,this.decorationColor,"left","middle"])}}}}this.addToRender(["drawLine",ap,J,g,H,e,B,aC],["Decor-Line"+ah])}}}if(al.marker){this.drawMarkers()}}}this.addToRender(["resetClipArea"])};this.drawOncoprintLegend=function(){this.functionCaller="drawOncoprintLegend";if(this.isOncoprint){var b=(this.width/2)-(this.legendOncoprintWidth/2);var p=this.height-(this.marginBottom+this.legendOncoprintHeight-this.margin);var a=0;var o=this.legendOncoprintWidth/this.legendOncoprintCols;var k=2;this.addToRender(["drawShape","rect",this.width/2,p+(this.legendOncoprintHeight/2)-this.margin,this.legendOncoprintWidth,this.legendOncoprintHeight,this.background,this.background],[-1],["-legend-oncoprint"]);for(var g=0;g<this.legendOncoprintRows;g++){var d=b;for(var e=0;e<this.legendOncoprintCols;e++){if(a<this.legendOncoprintLabels.length){var h=this.legendOncoprintLabels[a];var m=this.legendOncoprintObjects[a];if(a<this.legendOncoprintMutations){this.addToRender(["drawShape","rect",d+2.5,p+10.5,5,21,this.legendOncoprintColors[h]],["Onc-"+h+"-"+m]);d+=5+this.margin;this.addToRender(["drawText",h,d,p+10.5+k,this.legendFont,this.legendColor,"left","middle"]);d+=o}else{this.addToRender(["drawShape","rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"],["Onc-"+h+"-"+m]);this.addToRender(["drawShape","rect",d+2.5,p+10.5,5,7,this.legendOncoprintColors[h]],["Onc-"+h+"-"+m]);d+=5+this.margin;this.addToRender(["drawText",h,d,p+10.5+k,this.legendFont,this.legendColor,"left","middle"]);d+=o}a++}}p+=21+this.margin}}};this.drawSampleLegend=function(b,m){this.functionCaller="drawSampleLegend";var l=b;var d=m;var r=this.getFontPt(this.legendFont);var q=(r-1)/2;m+=this.margin+q;this.drawLegendBackgroundBox(l,d,this.legendSampleWidth,this.legendSampleHeight,true,"-legend-sample");var o=Math.max(this.xAxisIndices.length,this.yAxisIndices.length);for(var f=0;f<o;f++){var c=this.isCreateHistogram&&this.isCreateHistogram[7]?this.isCreateHistogram[8][f]:f%this.colors.length;var p=0;var j=this.getPropertyValue(f,false,"patternBy");var h=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[f];var k=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[f]:this.xAxis[this.xAxisCurrent];var g=this.xAxisIndices.length==this.yAxisIndices.length?"Series:"+this.xAxisIndices[f]+":"+this.yAxisIndices[f]:this.xAxisIndices.length>this.yAxisIndices.length?"Series:"+this.xAxisIndices[f]+":0":"Series:0:"+this.yAxisIndices[f];var n=this.isHistogram?this.shortenText(h,this.maxSmpStringLen):this.shortenText(h,this.maxSmpStringLen)+" vs "+this.shortenText(k,this.maxSmpStringLen);var e=b+q+this.margin;var a=m+q+this.margin;if(this.colorBy){this.addToRender(["drawShape",this.shapes[p],e,m,r-1,r-1,false,this.getFillColor(this.colors[c]),"open"],[g])}else{if(this.isCreateHistogram&&this.isCreateHistogram[7]){this.addToRender(["drawShape",this.shapes[p],e,m,r-1,r-1,this.getFillColor(c),this.getOutlineColor(c),j],[g])}else{this.addToRender(["drawShape",this.shapes[p],e,m,r-1,r-1,this.getFillColor(this.colors[c]),this.getOutlineColor(this.colors[c]),j],[g])}}this.addToRender(["drawText",n,e+q+this.margin,m,this.legendFont,this.legendColor,"left","middle"],[g]);m+=r+this.margin}this.drawLegendBackgroundBox(l,d,this.legendSampleWidth,this.legendSampleHeight)};this.drawVariableLegend=function(E,c){this.functionCaller="drawVariableLegend";var q=E;var G=c;var p=this.getFontPt(this.legendFont);var v=p/2;var a=p*2;var d=p*1.5;var w=0;var k=this;var l=function(i){if(i<k.xAxisVarIndices.length){return k.colors[i%k.colors.length]}else{return k.colors[(i-k.xAxisVarIndices.length)%k.colors.length]}};if(this.legendVariableWidth==0||this.legendVariableHeight==0){return}else{if(this.graphType=="Circular"&&this.circularType=="sunburst"){return}else{if(this.graphType=="Pie"){var D=!this.layoutComb?this.width-(E+(this.margin*1.5)):this.isDOE?this.layoutWidth-((E-this.offsetX)+(this.margin*1.5)):999999;if(this.isDOE&&this.legendVariableWidth>D){this.legendVariableWidth=D}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");E+=v+(this.margin*2);c+=p;for(var A=0;A<this.varPie.ids.length;A++){var f=false;var o=this.varPie.ids[A];var g=this.varPie.cols[A];var s=o>-1?this.shortenText(this.data.y.vars[o],this.maxVarStringLen):"Other";this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"square",E,c,p,p,this.getFillColor(g),this.getOutlineColor(g),"closed"],["PieVar-"+o]);if(D>0){while((this.measureText(s,this.legendFont)+p+(this.margin*3))>D&&s.length>1){s=s.substring(0,s.length-1);f=true}if(f){s=s+"..."}this.addToRender(["drawText",s,E+p,c,this.legendFont,this.legendColor,"left","middle"],["PieVar-"+o])}c+=p+this.margin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.addToRender(["drawText","...",E+p,c,this.legendFont,this.legendColor,"left","bottom"]);break}}else{if(c>this.height){this.addToRender(["drawText","...",E+p,c,this.legendFont,this.legendColor,"left","bottom"]);break}}}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight)}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var z=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],p):p;var F=z/2;var C=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=(this.margin*3);for(var A=0;A<b;A++){for(var u=0;u<this.legendColumns;u++){E=q+(this.margin+(C*u));if(w<this.varIndices.length){var o=this.varIndices[w];var g=this.graphType=="Circular"||(this.colorBy&&this.colorBy=="variable")?w%this.colors.length:0;var r=this.shapeBy&&this.shapeBy=="variable"?w%this.shapes.length:0;var y=this.sizeBy&&this.sizeBy=="variable"?this.sizes[w%this.sizes.length]:z;var n=this.patternBy&&this.patternBy=="variable"?this.patterns[w%this.patterns.length]:this.getPropertyValue(o,false,"patternBy");var m=E+F;var B=c+F;var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(this.colorBy&&this.colorBy!="variable"){this.addToRender(["drawShape",this.shapes[r],m,c,y,y,this.background,this.foreground,n],["Var-"+o])}else{this.addToRender(["drawShape",this.shapes[r],m,c,y,y,this.getFillColor(this.colors[g]),this.getOutlineColor(this.colors[g]),n],["Var-"+o])}this.addToRender(["drawText",s,m+F+this.margin,c,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{break}w++}c+=z+this.margin}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var h=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var C=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(h.length/this.legendColumns);c+=(this.margin*2);for(var A=0;A<b;A++){for(var u=0;u<this.legendColumns;u++){E=q+this.margin+(C*u);if(w<h.length){var o=w<this.xAxisVarIndices.length?this.xAxisVarIndices[w]:this.xAxis2VarIndices[w-this.xAxisVarIndices.length];var g=this.coordinateLineColor?l(w):this.getVariableColor(this.data.y.vars[o]);var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(w<this.xAxisVarIndices.length){this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",E+(p/2),c+(p/2),p,p,this.getFillColor(g),this.getOutlineColor(g),n],["Var-"+o]);this.addToRender(["drawText",s,E+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{this.addToRender(["drawLine","line",E,c+v,E+p,c+v,g],["Var-"+o]);if(this.lineDecoration){}this.addToRender(["drawText",s,E+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot"){this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var C=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=(this.margin*2);for(var A=0;A<b;A++){for(var u=0;u<this.legendColumns;u++){E=q+this.margin+(C*u);if(w<this.varIndices.length){var o=this.varIndices[w];var g=this.getFillColor(this.getVariableColor(this.data.y.vars[o]));var x=this.getOutlineColor(g);var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"){this.addToRender(["drawLine","line",E,c+v,E+p,c+v,g],["Var-"+o]);if(this.lineDecoration){this.addToRender(["drawShape",this.lineDecoration=="symbol"?this.shapes[w%this.shapes.length]:"circle",E+v,c+v,v,v,g,x,n],["Var-"+o])}}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){if(this.shapeBy){this.addToRender(["drawShape",this.shapes[w%this.shapes.length],E+v,c+v,p,p,g,x,n],["Var-"+o])}else{this.addToRender(["drawShape","circle",E+v,c+v,p,p,g,x,n],["Var-"+o])}}else{this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",E+(p/2),c+(p/2),p,p,g,x,n],["Var-"+o]);if(this.graphType=="Boxplot"&&(!this.showBoxplotOriginalData||this.boxplotColor)){this.addToRender(["drawLine","line",E,c+(p/2),E+p,c+(p/2),this.foreground]);this.addToRender(["drawLine","line",E+(p/2),c,E+(p/2),c-this.margin,this.foreground]);this.addToRender(["drawLine","line",E+(p/2),c+p,E+(p/2),c+p+this.margin,this.foreground])}}}this.addToRender(["drawText",s,E+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Circular"&&!this.showIdeogram){var t=this.r/2.7;if(this.legendVariableWidth>t||this.legendVariableHeight>t){}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var e=[];if(this.rAxisIndex>=0){for(var A=0;A<this.varIndices.length;A++){if(A==this.rAxisIndex){continue}e.push(this.varIndices[A])}}else{e=this.varIndices}var C=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(e.length/this.legendColumns);c+=(this.margin*2);for(var A=0;A<b;A++){for(var u=0;u<this.legendColumns;u++){E=q+this.margin+(C*u);if(w<e.length){var o=e[w];var g=this.colors[w%this.colors.length];var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"rectangle",E+(p/2),c+(p/2),p,p,this.getFillColor(g),this.getOutlineColor(g),n],["Var-"+o]);this.addToRender(["drawText",s,E+a,c+v,this.legendFont,this.legendColor,"left","middle"],["VarLbl-"+o])}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,G,this.legendVariableWidth,this.legendVariableHeight)}}}}}}}};this.drawVennLegend=function(){this.functionCaller="drawVennLegend";if(this.showLegend){var j=this.getFontPt(this.legendFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.addToRender(["drawText",a[f]+": ",d,g,this.legendFont,this.legendColor,"left","middle"])}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendFont;if(!this.vennLegendColors){this.addToRender(["drawText",b,c,g,e,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",b,d,g,e,h[f],"left","middle"])}g+=this.margin+j}}};this.drawColorIndicator=function(B,f,o,H,E,g){this.functionCaller="drawColorIndicator";if(g||E||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var r=H||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy;var m=g?"-legend-"+g+"-color":E?"-legend-indicator-color":"-legend-color";var h=g?"overlaysLegendPosition":E?"heatmapIndicatorPosition":"legendPosition";var G=g?g:E?0:this.legendColorWidth?this.legendColorWidth/2:10;var s=B;var F=f;var b=0;var A=this.heatmapIndicatorHeight;var e=this.heatmapIndicatorHeight;var u=o.min;var y=o.max;var a=o.decs;var q=o.vals;var p=this.heatmapIndicatorWidth/(y-u);var D=this.graphType=="Circular"?o:o.colorBrew?o.colorBrew:this.meta.def.colorBrew;var l=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var t=h=="overlaysLegendPosition"&&this[h]=="topRight"?true:false;var d=this.heatmapIndicatorHeight+(this.getFontPt(this.legendFont)*((r)?2:1))+(this.margin*2);if(this[h]&&this[h].toString().match(/top|bottom/)&&!t){this.drawLegendBackgroundBox(s-(this.margin*2),F-this.margin,this.heatmapIndicatorWidth+(this.margin*3)+this.legendFontSize,d,true,"-legend-indicator-color",false,true);if(r){this.addToRender(["drawText",r,B+(this.heatmapIndicatorWidth/2),f,this.legendFont,this.legendColor,"center","top"]);b=this.margin+this.getFontPt(this.legendFont);f+=b}for(var x=0;x<this.colorSpectrumNumber;x++){var n=D.stops&&D.stops.length>0?this.getColorForValue(D,D.breaks[x]):D.legend[x];var C=this.transparency!=null?this.addColorTransparency(n,this.transparency):n;this.addToRender(["drawLine","line",B,f,B,f+e,C,Math.round(l+1.5)]);B+=l}B=s;f+=e+this.margin;if(D.stops&&D.stops.length>0){var z=B+(this.measureText(this.formatNumber(D.breaks[0].toString()),this.legendFont)/2);this.addToRender(["drawText",this.formatNumber(D.breaks[0]),B,f,this.legendFont,this.legendColor,"center","top"]);for(var x=0;x<D.stops.length-1;x++){for(var w=0;w<this.colorSpectrumNumber;w++){if(D.breaks[w]>=D.stops[x]){B=s+(w*l);var k=(this.measureText(this.formatNumber(D.breaks[x].toString()),this.legendFont)/2);if(B-k>z){this.addToRender(["drawText",this.formatNumber(D.stops[x]),B,f,this.legendFont,this.legendColor,"center","top"]);z=B+k}break}}}B=s+(this.colorSpectrumNumber*l);this.addToRender(["drawText",this.formatNumber(D.stops[D.stops.length-1]),B,f,this.legendFont,this.legendColor,"center","top"])}else{this.addToRender(["drawText",this.formatNumber(u),B,f,this.legendFont,this.legendColor,"center","top"]);B=s+(this.heatmapIndicatorWidth/2);this.addToRender(["drawText",this.formatNumber((u+y)/2),B,f,this.legendFont,this.legendColor,"center","top"]);B=s+((this.colorSpectrumNumber-1)*l);this.addToRender(["drawText",this.formatNumber(y),B,f,this.legendFont,this.legendColor,"center","top"])}if(this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram){this.drawHeatmapIndicatorHistogram(s,F+b)}}else{this.drawLegendBackgroundBox(s,F,this.legendColorWidth,this.heatmapIndicatorWidth+(this.margin*3)+this.legendFontSize,true,m,false,true);if(r){this.addToRender(["drawText",r,B+G+this.margin,f,this.legendFont,this.legendColor,"center","top"]);f+=(this.margin*1.5)+this.getFontPt(this.legendFont)}for(var x=0;x<this.colorSpectrumNumber;x++){var C=this.transparency!=null?this.addColorTransparency(D.legend[x],this.transparency):D.legend[x];this.addToRender(["drawLine","line",B,f,B+A,f,C,Math.round(l+1.5)]);f+=l}B+=A;if(r){f=F+(this.margin*1.5)+this.getFontPt(this.legendFont)}else{f=F}for(var x=0;x<q.length;x++){if(q[x]>=u&&q[x]<=y){var e=f+((q[x]-u)*p);this.addToRender(["drawText",this.formatNumber(q[x]),B+this.margin,e,this.legendFont,this.legendColor,"left","middle"])}}}}};this.drawHeatmapIndicatorHistogram=function(x,b){this.functionCaller="drawHeatmapIndicatorHistogram";var w,a;var o=x;var z=b+this.heatmapIndicatorHeight;var y=[];for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!==""&&!isNaN(g)){y.push(g)}}}var k=this.range(y);var r=k[0];var t=k[1];var q=this[this.histogramSizeEstimator](y);var m=Math.ceil((t-r)/q);if(q>1000){m*=q/1000;q=1000}var e=[];for(var u=0;u<q;u++){e[u]=0}for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!==""&&!isNaN(g)){var n=parseInt((g-r)/m);e[n]++}}}r=0;t=0;for(var u=0;u<q;u++){r=Math.min(r,e[u]);t=Math.max(t,e[u])}var l=this.legendFont;var h=this[this.axisAlgorithm](r,t,3,this.axisWilkinsonLoose);var p=this.getMaxText(h);var f=(this.heatmapIndicatorWidth-1)/q;var c=this.heatmapIndicatorHeight/h[h.length-1];if(this.heatmapIndicatorPosition=="topLeft"){l=this.scaleTextToFont(p,this.getFontPt(this.legendFont),this.left-(this.heatmapIndicatorWidth+(this.margin*3)))}for(var u=0;u<h.length;u++){b=(h[u]*c);this.addToRender(["drawLine","line",o-this.margin,z-b,o,z-b,this.foreground]);this.addToRender(["drawText",this.formatNumber(h[u]),o-(this.margin*1.5),z-b,l,this.legendColor,"right","middle"])}b=(e[0]*c);this.addToRender(["drawLine","line",o,z,o,z-b,this.heatmapIndicatorHistogramColor]);for(var u=0;u<q;u++){b=(e[u]*c);this.addToRender(["drawLine","line",o,z-b,o+f,z-b,this.heatmapIndicatorHistogramColor]);if(u<q-1){a=(e[u+1]*c);this.addToRender(["drawLine","line",o+f,z-b,o+f,z-a,this.heatmapIndicatorHistogramColor])}o+=f}this.addToRender(["drawLine","line",o,z-a,o,z,this.heatmapIndicatorHistogramColor])};this.isDrawPropertyLegend=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.getSampleIndices(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])||(this.decorations.length&&this.decorationsType=="heatmap")}else{return(this.outlineBy&&this.isMultidimensionalData)||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.getSampleIndices(this.colorBy)>-1))}}};this.drawColorLegend=function(a,b,d,c){if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}if(this.isDrawPropertyLegend()){if(d.type=="Numeric"&&!d.colorBy){this.drawColorIndicator(a,b,this.isTransformedData&&this.graphType!="Heatmap"?this.getDefaultMetaDataObject():d)}else{this.drawPropertyLegend(c,a,b,d)}}};this.drawShapeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawSizeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPatternLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawConnectLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPropertyLegend=function(f,E,h,t){this.functionCaller="drawPropertyLegend";var n=this;var u=function(){if(n.graphType=="Boxplot"){if(!n.showBoxplotOriginalData&&!n.boxplotColor){return n.useRoundRectangles?"roundrect":"rectangle"}else{return"circle"}}else{return"circle"}};var w=this.decapitalize(f);if(this.isDrawPropertyLegend(w)){var F=f.replace("Node","").replace("Edge","")=="Size"?0:this.getDiameterLegend();if(f.replace("Node","").replace("Edge","")=="Size"){for(var D=0;D<(this.legendSizesN||t.levels.length);D++){F=Math.max(F,t.sizes?t.sizes[D]:this.sizes[D])}}var y=this.getFontPt(this.legendFont);var j=y/2;var b=this.legendColumns>this["legend"+f+"sN"]?this["legend"+f+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+f+"sN"]/b);var o=this["legend"+f+"Width"]/b;var g=h+(this.margin*2)+j;var C=Math.max(F,y);var m=u();var A=0;this.drawLegendBackgroundBox(E,h,this["legend"+f+"Width"],this["legend"+f+"Height"],true,"-legend-"+w);var I=f.replace("Node","").replace("Edge","")=="Color"&&this.outlineBy?this.outlineBy:this[w+"By"];if(this.showLegendTitle){this.addToRender(["drawText",I,E+(this["legend"+f+"Width"]/2),g,this.legendFont,this.legendColor,"center","middle"]);g+=j+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",E,g,E+this["legend"+f+"Width"],g,this.legendBoxColor])}this.enableGradientTransparencyShadow();g+=this.margin+(C/2)}var a=this["legend"+f+"sS"]||this.sortObject(this["legend"+f+"s"]);var H=t.origin?t.origin:this.meta.data.modified?"modified":"y";for(var v=0;v<e;v++){for(var G=0;G<b;G++){var q=E+this.margin+F/2+(o*G);if(A<this["legend"+f+"sN"]){var z=a[A];if(f.replace("Node","").replace("Edge","")=="Color"){var l=t.colorBy&&t.colorBy.hasOwnProperty(z)?this.validateColor(t.colorBy[z]):this.legendColors?this.validateColor(this.legendColors[z]):this.validateColor(t.colors[A]);if(this.graphType=="Boxplot"&&this.showViolinBoxplot){l=this.addColorTransparency(l,this.violinTransparency)}if(this.outlineBy){this.addToRender(["drawShape",m,q,g,F,F,false,this.getFillColor(l),"open",false,2],["Property:"+I+":"+z+":"+H])}else{this.addToRender(["drawShape",m,q,g,F,F,this.getFillColor(l),this.getOutlineColor(l),"closed"],["Property:"+I+":"+z+":"+H])}}else{if(f.replace("Node","").replace("Edge","")=="Shape"){var x=t.shapeBy&&t.shapeBy.hasOwnProperty(z)?t.shapeBy[z]:this.legendShapes?this.legendShapes[z]:t.shapes[A];this.addToRender(["drawShape",x,q,g,F,F,this.background,this.foreground,"closed"],["Property:"+I+":"+z+":"+H])}else{if(f.replace("Node","").replace("Edge","")=="Size"){var B=t.sizeBy&&t.sizeBy.hasOwnProperty(z)?t.sizeBy[z]:this.legendSizes?this.legendSizes[z]:t.sizes[A];if(t.rmax==t.max&&t.rmin==t.min){this.addToRender(["drawShape",m,q,g,B,B,this.background,this.foreground,"closed"],["Property:"+I+":"+z+":"+H])}else{this.addToRender(["drawShape",m,q,g,B,B,this.background,this.foreground,"closed"])}}else{if(f.replace("Node","").replace("Edge","")=="Pattern"){var s=t.patternBy&&t.patternBy.hasOwnProperty(z)?t.patternBy[z]:this.legendPatterns?this.legendPatterns[z]:t.patterns[A];this.addToRender(["drawShape",this.useRoundRectangles?"roundrect":"square",q,g,F,F,this.background,this.foreground,s],["Property:"+I+":"+z+":"+H])}else{if(f=="Connect"){var l=t.connectBy&&t.connectBy.hasOwnProperty(z)?t.connectBy[z]:this.legendConnects?this.legendConnects[z]:t.connects[A];this.addToRender(["drawLine","line",q-(F/2),g,q+(F/2),g,l,this.connectByWidth])}}}}}if(this.graphType=="Boxplot"&&f!="Connect"&&(!this.showBoxplotOriginalData||this.boxplotColor)){var l=t.connectBy&&t.connectBy.hasOwnProperty(z)?t.connectBy[z]:this.legendConnects?this.legendConnects[z]:t.connects[A];this.addToRender(["drawLine","line",q-(F/2),g,q+(F/2),g,this.getOutlineColor(l)]);this.addToRender(["drawLine","line",q,g-(F/2),q,g-((F/2)+this.margin),this.getOutlineColor(l)]);this.addToRender(["drawLine","line",q,g+(F/2),q,g+((F/2)+this.margin),this.getOutlineColor(l)])}if(t.type=="Numeric"&&((f=="Shape"&&!this.shapeByContinuous)||(f=="Size"&&!this.sizeByContinuous))){if(v==0&&G==0){this.addToRender(["drawText","< "+z,q+(C/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],["Property:"+I+":"+z+":"+H])}else{if(v==e-1&&G==b-1){this.addToRender(["drawText",a[A-1]+" - "+z,q+(C/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],["Property:"+I+":"+z+":"+H])}else{var k=Number(z)-(1/Math.pow(10,t.decs));if(Number(k)==Number(a[A-1])){k=Number(z)-(1/Math.pow(10,t.decs+1))}this.addToRender(["drawText",Number(a[A-1])+" - "+k,q+(C/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],["Property:"+I+":"+z+":"+H])}}}else{this.addToRender(["drawText",z,q+(C/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],["Property:"+I+":"+z+":"+H])}}A++}g+=this.margin+C}this.drawLegendBackgroundBox(E,h,this["legend"+f+"Width"],this["legend"+f+"Height"])}};this.drawCustomLegend=function(E,a,j,G,v){this.functionCaller="drawCustomLegend";var y=v.text.length;var A=this.getDiameterLegend();var t=v.size;if(t){for(var B=0;B<t.length;B++){if(t[B]){A=Math.max(A,t[B])}}}var f=this.getFontPt(this.legendFont);var b=f/2;var k=this.legendColumns>y?y:this.legendColumns;var d=Math.ceil(y/k);var l=j/k;var D=a+this.margin+b;var q=Math.max(A,f);var g=0;this.drawLegendBackgroundBox(E,a,j,G,true,"-legend-"+v.id);if(v.title){this.addToRender(["drawText",v.title,E+(j/2),D,this.legendFont,this.legendColor,"center","middle"]);D+=b+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",E,D,E+j,D,this.legendBoxColor])}this.enableGradientTransparencyShadow();D+=this.margin+(q/2)}else{D+=(q/2)-b}var z=false;for(var u=0;u<d;u++){for(var F=0;F<k;F++){var m=E+this.margin+A/2+(l*F);if(g<y){if(v.shape&&v.shape[g]){var p=v.size[g]||A;var F=this.getFillColor(v.shapeColor[g]||this.background);var x=this.getOutlineColor(F);this.addToRender(["drawShape",v.shape[g],m,D,p,p,F,x,"closed"]);z=true}if(v.line&&v.line[g]){var p=v.size[g]||A;var C=p/2;var F=v.lineColor[g]||this.background;var e=v.lineStart&&v.lineStart[g]?v.lineStart[g]:false;var w=v.lineEnd&&v.lineEnd[g]?v.lineEnd[g]:false;this.addToRender(["drawLine",v.line[g],m-C,D,m+C,D,F,false,false,false,false,false,false,false,e,w]);z=true}if(z){this.addToRender(["drawText",v.text[g],m+(q/2)+this.margin,D,this.legendFont,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",v.text[g],m+(j/2),D,this.legendFont,this.legendColor,"center","middle"])}}g++}D+=this.margin+q}this.drawLegendBackgroundBox(E,a,j,G)};this.drawGenericLegend=function(s,p,n,y,q,A,o){this.functionCaller="drawGenericLegend";var u=this.getDiameterLegend();var d=this.getFontPt(this.legendFont);var r=Math.max(u,d);var b=r/2;var e=0;this.drawLegendBackgroundBox(s,p,n,y,true,"-legend");this.addToRender(["drawText",A,s+(n/2),p+this.margin+(d/2),this.legendFont,this.legendColor,"center","middle"]);e=p+d+(this.margin*2);if(this.legendBox){this.addToRender(["drawLine","line",s,e,s+n,e,this.legendBoxColor])}e+=this.margin;if(!o){o=1}var c=n/o;var f=Math.ceil(q.levels.length/o);var g=0;var a=e;var k=q.origin?q.origin:this.meta.data.modified?"modified":"y";for(var x=0;x<f;x++){for(var v=0;v<o;v++){var z=s+this.margin+(c*v);if(g<q.levels.length){var m=q.type=="String"?q.colors[g]:this.getColorForValue(q.colorBrew,q.levels[g]);this.addToRender(["drawShape",this.useRoundRectangles?"rounderect":"square",z+(u/2),a+(r/2),u,u,this.getFillColor(m),this.getOutlineColor(m)],["Property:"+A+":"+q.levels[g]+":"+k]);this.addToRender(["drawText",q.levels[g],z+u+this.margin,a+(r/2),this.legendFont,this.legendColor,"left","middle"],["Property:"+A+":"+q.levels[g]+":"+k])}else{break}g++}a+=r+this.margin}this.drawLegendBackgroundBox(s,p,n,y)};this.drawDecorationLegend=function(e,s){this.functionCaller="drawDecorationLegend";if(this.graphType.match(/Scatter/)){var p,o;var m=this.decorations;var u=this.getFontPt(this.decorationFont);var c=this.measureText(this.sprintf("%15s","X"),this.decorationFont);var r=m.nlfit||m.nor||m.reg?c:0;var n=e+(r?this.legendDecorationMaxLabel+c:this.margin);var a=n;var g=s;var q=g;this.legendDecorationCurX=e;this.legendDecorationCurY=s;this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,true,"-legend-decorations",true);if(m.nlfit){this.addToRender(["drawText","Min",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Max",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","EC50",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","p-Val",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","F-Chg",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nlfit.length;k++){var f=k%this.colors.length;f=m.nlfit[k].color?m.nlfit[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nlfit[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;for(var h=0;h<6;h++){var b=m.nlfit[k].param[h];if(h<2){b=this.transformValue(this.yAxisTransform,b)}else{if(h==2){}}this.addToRender(["drawText",this.formatNumber(b,this.yAxisDecs+1),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin}q+=u+u}}if(m.line){for(var k=0;k<m.line.length;k++){if(m.line[k].label){for(var k=0;k<m.line.length;k++){var f=m.line[k].color?m.line[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.line[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}}if(m.reg){this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Int",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Cor",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.reg.length;k++){var f=m.reg[k].color?m.reg[k].color:this.colors[k%this.colors.length];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.reg[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.reg[k].slope,2),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].intercept,this.yAxisDecs+1),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].cor,3),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.nor){this.addToRender(["drawText","Mu",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Sigma",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nor.length;k++){var f=k%this.colors.length;f=m.nor[k].color?m.nor[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nor[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.nor[k].mu,this.xAxisDecs+1),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.nor[k].sigma,this.xAxisDecs+2),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.area){for(var k=0;k<m.area.length;k++){if(m.area[k].label){var f=m.area[k].color?m.area[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.area[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}if(m.qq){for(var k=0;k<m.qq.length;k++){this.addToRender(["drawText",m.qq[k].label,a,q,this.decorationFont,m.qq[k].color,"left","middle"]);q+=u+u}}if(m.cdf){for(var k=0;k<m.cdf.length;k++){this.addToRender(["drawText",m.cdf[k].label,a,q,this.decorationFont,m.cdf[k].color,"left","middle"]);q+=u+u}}if(m.kaplanMeier){for(var k=0;k<m.kaplanMeier.length;k++){if(m.kaplanMeier[k].label){var f=m.kaplanMeier[k].color?m.kaplanMeier[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.kaplanMeier[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,false,false,true)}};this.resetLegends=function(c){if(c){delete (this.legendDecorationCurX);delete (this.legendDecorationCurY);delete (this.legendDecorationX);delete (this.legendDecorationY)}var a=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample"];for(var b=0;b<a.length;b++){this["legend"+a[b]+"Width"]=0;this["legend"+a[b]+"Height"]=0;if(c){delete (this["legend"+a[b]+"CurX"]);delete (this["legend"+a[b]+"CurY"]);delete (this["legend"+a[b]+"X"]);delete (this["legend"+a[b]+"Y"])}}delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY)};this.getXYLegendCoords=function(B,s,o){var k,g,r;var n=-1;var A=-1;var f=this;var c=this.graphType=="Network"?0:this.offsetX;var b=this.graphType=="Network"?0:this.offsetY;var d=function(){for(var l=0;l<f.legendLayout.length;l++){if(f.legendLayout[l]){for(var h=0;h<f.legendLayout[l].length;h++){if(f.legendLayout[l][h]==B){return[l,h]}}}}return[-1,-1]};if(this.legendLayout){var e=d();n=e[0];A=e[1];if(n>-1&&A>-1){var a=0;var p=0;if(this.legendPosition.match(/right|left/i)){for(var v=0;v<n;v++){var m=0;for(var u=0;u<this.legendLayout[v].length;u++){m=Math.max(m,this["legend"+this.legendLayout[v][u]+"Width"]+this.margin)}a+=m}for(var u=0;u<this.legendLayout[n].length;u++){p+=this["legend"+this.legendLayout[n][u]+"Height"]+this.margin}}else{for(var v=0;v<n;v++){var z=0;for(var u=0;u<this.legendLayout[v].length;u++){z=Math.max(z,this["legend"+this.legendLayout[v][u]+"Height"]+this.margin)}p+=z}for(var u=0;u<this.legendLayout[n].length;u++){a+=this["legend"+this.legendLayout[n][u]+"Width"]+this.margin}}if(this.graphType=="Circular"){k=s;g=o}else{if(this.legendPosition.match(/right|left/i)){o=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginTop+this.layoutTop:A==0?this.marginTop+b+this.top:o;k=s+a+(this.graphType=="Network"?-10:0);r=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(p+this.margin):((this.y-p)/2);g=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.height-p)/2:A==0?this.marginTop+b+this.top+r:o;s=A==this.legendLayout[n].length-1?s+a:s;o=g+this["legend"+this.legendLayout[n][A]+"Height"]+this.margin}else{s=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginLeft+this.layoutLeft:A==0?this.marginLeft+c+this.left:s;k=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.width-a)/2:A==0?this.marginLeft+c+this.left+((this.x-a)/2)+this.margin:s+this.margin;g=o+p;s=k+this["legend"+this.legendLayout[n][A]+"Width"]+this.margin;o=A==this.legendLayout[n].length-1?o+p:o}}}}return[k,g,s,o]};this.getVariableLegendPosition=function(){var c,h;if(this.graphType=="Pie"&&this.layoutValid){if(this.legendPosition=="right"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=(this.height/2)-(this.legendVariableHeight/2)}else{c=(this.width/2)-(this.legendVariableWidth/2);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.graphType=="Circular"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin);return[c,h]}else{if(this.layoutValid&&this.graphType!="Pie"){var d=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);var j=this.legendVariableHeight+this.legendOverlaysHeight+(this.margin*-0.5);var e=this.legendVariableWidth+this.legendOverlaysWidth+(this.margin*-0.5);c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.legendPosition=="left"?this.marginLeft+this.margin:this.marginLeft+this.layoutLeft+(d/2)-(e/2);h=this.legendPosition=="bottom"?this.height-(this.marginBottom+j):this.legendPosition=="top"?this.marginTop+this.margin+this.getTitleSubtitleHeight():this.marginTop+this.layoutTop+(b/2)-(j/2)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legendVariableHeight;var i=this.legendVariableWidth;if(this.legendInside||this.graphType=="Pie"){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(this.graphType=="Pie"?0:(a+this.margin));break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin-(this.graphType=="Pie"?(i+this.margin):0);h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin-(this.graphType=="Pie"?(a+this.margin):0);break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(this.graphType=="Pie"?0:(i+this.margin));h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/top|bottom/i)?this.legendOverlaysHeight:0;var g=this.overlaysLegendPosition.match(/right|left/i)?this.legendOverlaysWidth:0;switch(this.legendPosition){case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;case"top":c=f+(this.x/2)-(i/2);h=this.marginTop+this.offsetY+this.margin+this.getTitleSubtitleHeight();break;case"left":c=this.marginLeft+this.offsetX+this.margin;h=k+(this.y/2)-(a/2);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}}return[c,h]};this.getScatterLegendPosition=function(){var j=0;var h=0;var g=0;var d=0;var a=0;var i=0;var c=this.graphType=="Network"?10:this.offsetX;var b=this.graphType=="Network"?10:this.offsetY;var e=this.marginLeft+c+this.left+this.margin;var k=this.marginTop+b+this.top+this.margin;if(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition"))){if(this.legendPosition=="left"){g=this.marginLeft+this.margin}else{g=this.width+this.margin-(this.marginRight+(this.legendWidth||0))}if(this.legendPosition=="top"){d=this.marginTop+this.margin+this.getTitleSubtitleHeight()}else{d=this.height+this.margin-(this.marginBottom+(this.legendHeight||0))}j=g-(this.legendDecorationWidth+this.margin);h=d-(this.legendDecorationHeight+this.margin)}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"&&this.colorBy){g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendColorWidth+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendColorHeight+this.bottom+this.marginBottom)}else{g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendVariableWidth+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendVariableHeight+this.bottom+this.marginBottom)}}else{if(this.legendInside||this.isQQ||this.isCDF){if(this.legendDecorationWidth>0&&this.legendDecorationHeight>0){var f=this.legendDecorationWidth+(this.margin*2);if(this.isQQ||this.isCDF){j=e+this.x-f;h=k+this.y-(this.legendDecorationHeight+this.margin)}else{switch(this.decorationsPosition){case"bottomRight":j=e+this.x-f;h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"bottom":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"bottomLeft":j=e+this.margin;h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"left":j=e+this.margin;h=k+(this.y/2)-(this.legendDecorationHeight/2);break;case"topLeft":j=e+this.margin;h=k+(this.margin*2);break;case"top":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+(this.margin*2);break;case"topRight":j=e+this.x-f;h=k+(this.margin*2);break;default:j=e+this.x-f;h=k+(this.y/2)-(this.legendDecorationHeight/2);break}}}if(this.legendWidth>0&&this.legendHeight>0){switch(this.legendPosition){case"bottomRight":g=e+this.x-this.legendWidth;d=k+this.y-this.legendHeight;break;case"bottom":g=e+(this.x/2)-(this.legendWidth/2);d=k+this.y-this.legendHeight;break;case"bottomLeft":g=e;d=k+this.y-this.legendHeight;break;case"left":g=e;d=k+(this.y/2)-(this.legendHeight/2);break;case"topLeft":g=e;d=k;break;case"top":g=e+(this.x/2)-(this.legendWidth/2);d=k;break;case"topRight":g=e+this.x-this.legendWidth;d=k;break;default:g=e+this.x-this.legendWidth;d=k+(this.y/2)-(this.legendHeight/2);break}}}else{switch(this.decorationsPosition){case"bottom":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+this.y+this.bottom-this.legendDecorationHeight;break;default:j=e+this.x+this.right-(this.legendDecorationWidth+(this.margin*2));h=k+(this.y/2)-(this.legendDecorationHeight/2);break}a=this.legendPosition==this.decorationsPosition?this.legendDecorationWidth:0;i=this.legendPosition==this.decorationsPosition?this.legendDecorationHeight:0;switch(this.legendPosition){case"bottom":g=e+(this.x/2)-(this.legendWidth/2);d=k+this.y+this.bottom-(this.legendHeight+(i?i+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legendHeight}break;case"top":g=e+(this.x/2)-(this.legendWidth/2);d=this.marginTop+b+this.margin+this.getTitleSubtitleHeight();if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legendHeight}break;case"left":g=this.marginLeft+c+this.margin;d=k+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legendWidth}break;default:g=e+this.x+this.right-(this.legendWidth+a);d=k+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legendWidth}break}}}}return[j,h,g,d]};this.drawIndicator=function(a,b,c){delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY);this.drawColorIndicator(a,b,false,c)};this.drawLegend=function(a){if(this.graphType=="Venn"){this.drawVennLegend()}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"){this.drawScatterLegend(a)}else{if(this.circularType=="bubble"){}else{if(this.showLegend){this.drawOverlaysLegend();var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}}}}else{if(this.graphType=="Network"){this.drawScatterLegend()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.isAttributedGraph()||this.connectBy)&&(this.isInArray(this.graphType,CanvasXpress.graphTypes.AttGraphs)||this.graphType=="Map"))){this.drawScatterLegend(a);if(this.isOncoprint){this.drawOncoprintLegend()}this.drawOverlaysLegend()}else{if(this.graphType=="Pie"&&this.layoutValid&&!this.isDOE){if(this.layoutCurrent==this.data.l.smps.length-1){this.draw1DLegend()}}else{this.draw1DLegend();this.drawOverlaysLegend()}}}}}};this.draw1DLegend=function(){if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&this.isAttributedGraph()))){if(this.isMultidimensionalData||(this.isAttributedGraph()&&this.isInArray(this.graphType,CanvasXpress.graphTypes.AttGraphs))){if(this.isOncoprint){this.drawOncoprintLegend()}this.drawScatterLegend()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.getVariableLegendPosition();var a=c[0];var b=c[1];if(this.legendVariableX&&this.legendVariableY){a=this.legendVariableX;b=this.legendVariableY}this.legendVariableCurX=a;this.legendVariableCurY=b;this.drawVariableLegend(a,b)}}else{if(this.isOncoprint){this.drawOncoprintLegend()}}};this.drawOverlaysLegend=function(){var s,e;if(this.overlaysLegendPosition.match(/right/i)){s=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){s+=(this.y/2)-(this.legendOverlaysHeight/2)}e=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legendOverlaysWidth):this.width-(this.marginRight+this.legendOverlaysWidth)}else{s=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legendOverlaysHeight):this.height-(this.marginBottom+this.legendOverlaysHeight);e=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){e+=(this.x/2)-(this.legendOverlaysWidth/2)}}var v=s;var f=e;for(var k=0;k<this.legendOverlaysLayout.length;k++){var n=this.legendOverlaysLayout[k];var r,b,d,a;var u=mw=0;var p=mh=0;for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];mw=Math.max(u,n[g][2]);mh=Math.max(p,n[g][3])}for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];d=this.meta.data[r][b];u=this["legend"+b+"Width"];p=this["legend"+b+"Height"];a=r=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(d.type=="String"){this.drawGenericLegend(f,v,u,p,d,b,a)}else{this.drawColorIndicator(f,v,d,b,false,u/2)}if(this.overlaysLegendPosition.match(/right/i)){v+=p+this.margin}else{f+=u+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){f+=mw+this.margin;v=s}else{f=e;v+=mh+this.margin}}};this.drawScatterLegend=function(e){var l=this.getScatterLegendPosition();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.layoutValid){if(this.legendDecorationX!=null&&this.legendDecorationY!=null){this.drawDecorationLegend(this.legendDecorationX,this.legendDecorationY)}else{this.drawDecorationLegend(l[0],l[1])}}if(this.graphType.match(/Scatter/)&&(this.isQQ||this.isCDF)){return}if(this.showLegend){var j=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample"];var d=l[2];var n=l[3];for(var f=0;f<j.length;f++){var q=this["legend"+j[f]+"Width"];var g=this["legend"+j[f]+"Height"];var p=this["legend"+j[f]+"X"];var k=this["legend"+j[f]+"Y"];if(q>0){if(e){this.setPropertyLegendDimensions(j[f]);q=this["legend"+j[f]+"Width"];g=this["legend"+j[f]+"Height"]}var c=("draw"+j[f]+"Legend").replace("Node","").replace("Edge","").replace("Decoration","Color");var b=this["legend"+j[f]+"Meta"];var o=this.getXYLegendCoords(j[f],d,n);if(p&&k){this[c](p,k,b,j[f]);this["legend"+j[f]+"CurX"]=p;this["legend"+j[f]+"CurY"]=k}else{this[c](o[0],o[1],b,j[f]);this["legend"+j[f]+"CurX"]=o[0];this["legend"+j[f]+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}for(var f=0;f<this.legend.length;f++){if(this.graphType=="Network"&&!this.showDecorations){continue}var a="Custom"+f;var q=this["legend"+a+"Width"];var g=this["legend"+a+"Height"];var p=this["legend"+a+"X"];var k=this["legend"+a+"Y"];var o=this.getXYLegendCoords(a,d,n);if(p&&k){this.drawCustomLegend(p,k,q,g,this.legend[f]);this["legend"+a+"CurX"]=p;this["legend"+a+"CurY"]=k}else{this.drawCustomLegend(o[0],o[1],q,g,this.legend[f]);this["legend"+a+"CurX"]=o[0];this["legend"+a+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}};this.setMarker=function(f){var j=this;var k=function(q){var p=j.meta.render.objects;for(var m=0;m<p.length;m++){var n=p[m];if(n.type=="Data"&&n.idx){var l=n.idx.join(":");if(l==q||l==q+":false"||l==q+":true"||l==q+":box"){return n}}}return false};var c=function(){if(f.fontSize){return(f.fontStyle||"")+" "+parseInt(f.fontSize)+"px "+j.fontName}else{return j.decorationFont}};var e=this.graphType.match(/Treemap|Stacked/)?true:false;var g=this.isArray(f.variable)?this.getVariableIndices(f.variable):this.getVariableIndices([f.variable]);var h=this.isArray(f.sample)?this.getSampleIndices(f.sample,e):this.getSampleIndices([f.sample],e);var b=g.concat(h).join(":");var a=k(b);var i=a?this.centroidArea(a.area):false;var d=a?a.params[4]:false;if(!f.id){f.id=this.newId(this.target+"-marker-")}f.vi=g;f.si=h;if(!this.isArray(f.variable)){f.variable=[f.variable]}if(!this.isArray(f.sample)){f.sample=[f.sample]}if(!f.type){f.type="line"}f.b=[this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.x,this.y];f.len=this.measureText(f.text,c());f.width=this.measureTextWidth(f.text,c());f.tx=i?i[0]:false;f.ty=i&&f.type!="line"?i[1]-((d/2)+f.width):i?i[1]:false;return f};this.getMarker=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.drawMarkers=function(){this.functionCaller="drawMarkers";var k=this;var j=function(d,c,h){return d.ty>0&&d.ty<k.height&&d.tx>0&&d.tx<k.width};var b=function(){if(e.fontSize){return(e.fontStyle||"")+" "+parseInt(e.fontSize)+"px "+k.fontName}else{return k.decorationFont}};if(this.decorations&&this.decorations.marker){var l=this.decorations.marker;for(var f=0;f<l.length;f++){var e=this.setMarker(l[f]);if(e.tx&&e.ty&&e.b){var p,o;p=e.x?e.b[0]+(e.x*e.b[2]):this.graphOrientation=="vertical"?e.tx:e.tx+this.margin;o=e.y?e.b[1]+(e.y*e.b[3]):this.graphOrientation=="vertical"?e.ty-this.margin:e.ty;if(j(e,p,o)){var q=this.addToRender(["drawText",e.text,p,o,b(e),e.color||this.decorationsColor,e.align,e.baseline],"Marker:"+e.id);var a=this.meta.render.objects[q].area;if(e.type=="line"){var n=e.color||this.decorationsColor;var g;e.curX=p;e.curY=o;if(e.tx<a[1]-e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{if(e.tx>a[3]+e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}else{if(e.ty>a[4]+(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[4]+this.margin,a[3],a[4]+this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[4]+this.margin,n],false,q)}else{if(e.ty<a[2]-(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[2]-this.margin,a[3],a[2]-this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[2]-this.margin,n])}else{if(e.tx<a[1]){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}}}}}}else{e.curX=p;e.curY=o}}}}}};this.setFunctionNames("initLegendUtils")};CanvasXpress.prototype.initFilterUtils=function(){this.handleSelector=function(d){if(!this.hiddenLegends){this.hiddenLegends={}}this.hiddenLegends[d.id]=this.hiddenLegends[d.id]?false:true;var b=!this.hiddenLegends[d.id];var c=this.showTransition;this.showTransition=false;switch(d.type){case"var":this.filterVariables(d.type+"s","exact",(this.isArray(d.name)?d.name:[d.name]),b);break;case"smp":this.filterSamples(d.type+"s","exact",(this.isArray(d.name)?d.name:[d.name]),b);break;case"series":this.filterSamples("smps","exact",(this.isArray(d.name)?d.name:[d.name]),b);break;case"meta":var e=this.meta.data[d.object][d.factor];switch(d.object){case"x":if(e.type=="Numeric"){var f=e.order[d.level];var a=e.vals[f+1]?e.vals[f+1]:Number(d.level)+1;this.filterSamplesByCategory(d.factor,"between",[Number(d.level),Number(d.level)],b)}else{this.filterSamplesByCategory(d.factor,"exact",(this.isArray(d.level)?d.level:[d.level]),b)}break;case"z":if(e.type=="Numeric"){var f=e.order[d.level];var a=e.vals[f+1]?e.vals[f+1]:Number(d.level)+1;this.filterVariablesByCategory(d.factor,"between",[Number(d.level),Number(d.level)],b)}else{this.filterVariablesByCategory(d.factor,"exact",(this.isArray(d.level)?d.level:[d.level]),b)}break;case"modified":if(this.meta.data.modified.x&&this.meta.data.modified.x.meta&&this.meta.data.modified.x.meta[d.factor]){alert("Ooops! Needs to develop this case!")}else{if(this.meta.data.modified.z&&this.meta.data.modified.z.meta&&this.meta.data.modified.z.meta[d.factor]){this.filterUserData("filterSmpBy",d.factor,"exact",[this.meta.data.modified.z.meta[d.factor].order[d.level]],b)}}break}break;case"data":this.filterDataByCategory(d.object,"exact",[d.name],b);break}this.showTransition=c};this.filterVariables=function(d,c,a,b){this.filterUserData("filterVarBy","vars",c,a,b)};this.filterVariablesByCategory=function(d,c,a,b){this.filterUserData("filterVarBy",d,c,a,b)};this.filterSamples=function(d,c,a,b){this.filterUserData("filterSmpBy","smps",c,a,b)};this.filterSamplesByCategory=function(a,d,b,c){this.filterUserData("filterSmpBy",a,d,b,c)};this.filterDataByCategory=function(e,d,a,b){this.filterUserData("filterDataBy",e,d,a,b)};this.filterUserData=function(e,c,f,k,j){this.functionCaller="filterUserData";if(this.isTransition()){return}var b={min:">=",max:"<=",between:"between",like:"like",exact:"exact"};var d=this.ungroupGroupedData();if(j){for(var a=0;a<this[e].comp.length;a++){if(this[e].comp[a]==c&&this[e].op[a]==b[f]&&this[e].cases[a]==false&&this[e].type[a]=="Legend"&&this.isSameObject(this[e].value[a],k)){this[e].comp.splice(a,1);this[e].op.splice(a,1);this[e].cases.splice(a,1);this[e].type.splice(a,1);this[e].value.splice(a,1)}}}else{this[e].comp.push(c);this[e].op.push(b[f]);this[e].cases.push(false);this[e].type.push("Legend");this[e].value.push(k)}this.reset(true,true);this.filterData(d,true,j);if(this.isGroupedData&&this.smpIndices.length>0){this.groupSamples(this.groupingFactors,false,false,true,false,false,d?false:true)}else{this.draw()}};this.filterData=function(C,F,q){if(this.isDOE){return}var w={};var N={};var c={};var H=false;var D=this;var E=function(v,W,h){if(W.hasOwnProperty(v)){return W[v]}else{if(v.match(":::")){var d=v.split(":::");if(h[d[1]]){d[1]=parseInt(d[1]);for(var s=0;s<h[d[1]].length;s++){var k=h[d[1]][s];if(W.hasOwnProperty(k)){W=W[k]}else{return false}}if(W.hasOwnProperty(d[0])){return W[d[0]]}}}return false}};var G=function(X){var Z=D.motionBy?D.seq(0,D.data.y.vars.length-1,1):D.varIndices;var v=[];var a;var p=false;for(var W=0;W<Z.length;W++){var aa=Z[W];var k=false;a=D.filterSmpBy;if(a.comp.length>0){for(var s=0;s<a.comp.length;s++){if(a.comp[s]){if(X&&a.type[s]!="Legend"){continue}var Y=D.getSampleIndices(a.comp[s]);if(Y>=0){p=true;var h=y(D.data.y.data[aa][Y],a.op[s],a.value[s],a.cases[s]);if(D.filterType=="and"&&!X){if(h){k=true}else{k=false;break}}else{if(h){k=true;break}}}}}}a=D.filterVarBy;if(a.comp.length>0){for(var s=0;s<a.comp.length;s++){if(a.comp[s]){if(X&&a.type[s]!="Legend"){continue}var Y=D.getVariableIndices(a.comp[s]);if(Y==-1){p=true;var d=a.comp[s]=="vars"?D.data.y.vars[aa]:D.getMetadataValue(aa,"z",a.comp[s]);var h=y(d,a.op[s],a.value[s],a.cases[s]);if(D.filterType=="and"&&!X){if(h){k=true}else{k=false;break}}else{if(h||k){k=true;break}}}}}}if(k){v.push(aa)}}return p?v:false};var K=function(aa,Z){if(D.isGroupedData&&(!C||Z)){var ac=D.grpIndices;var X=[];var a;var v=false;for(var Y=0;Y<ac.length;Y++){var ad=ac[Y];var p=false;a=D.filterSmpBy;if(a.comp.length>0){for(var W=0;W<a.comp.length;W++){if(a.comp[W]){if(aa&&a.type[W]!="Legend"){continue}v=true;if(a.comp[W]=="smps"){var h=false;for(var s=0;s<D.data.w.grps[ad].length;s++){if(y(D.data.y.smps[D.data.w.grps[ad][s]],a.op[W],a.value[W],a.cases[W])){h=true;break}}if(D.filterType=="and"&&!aa){if(h){p=true}else{p=false;break}}else{if(h||p){p=true;break}}}else{var h=y(D.data.w.factors[a.comp[W]][ad],a.op[W],a.value[W],a.cases[W]);if(D.filterType=="and"&&!aa){if(h){p=true}else{p=false;break}}else{if(h||p){p=true;break}}}}}}if(p){X.push(ad)}}}else{var ac=D.smpIndices;var X=[];var a;var v=false;for(var Y=0;Y<ac.length;Y++){var ad=ac[Y];var p=false;a=D.filterVarBy;if(a.comp.length>0){for(var W=0;W<a.comp.length;W++){if(a.comp[W]){if(aa&&a.type[W]!="Legend"){continue}var ab=D.getVariableIndices(a.comp[W]);if(ab>=0){v=true;var h=y(D.data.y.data[ab][ad],a.op[W],a.value[W],a.cases[W]);if(D.filterType=="and"&&!aa){if(h){p=true}else{p=false;break}}else{if(h){p=true;break}}}}}}a=D.filterSmpBy;if(a.comp.length>0){for(var W=0;W<a.comp.length;W++){if(a.comp[W]){if(aa&&a.type[W]!="Legend"){continue}var ab=D.getSampleIndices(a.comp[W]);if(ab==-1){v=true;var d=a.comp[W]=="smps"?D.data.y.smps[ad]:D.getMetadataValue(ad,"x",a.comp[W],true);var h=y(d,a.op[W],a.value[W],a.cases[W]);if(D.filterType=="and"&&!aa){if(h){p=true}else{p=false;break}}else{if(h||p){p=true;break}}}}}}if(p){X.push(ad)}}}return v?X:false};var y=function(k,v,j,h){if(!v){return true}if(D.filterSkipNullValues&&(k==null||k=="")){return true}if(v==">"){return parseFloat(k)-parseFloat(j)>0}else{if(v==">="){return parseFloat(k)-parseFloat(j)>0||parseFloat(k)-parseFloat(j)==0}else{if(v=="<"){return parseFloat(k)-parseFloat(j)<0}else{if(v=="<="){return parseFloat(k)-parseFloat(j)<0||parseFloat(k)-parseFloat(j)==0}else{if(v=="between"){return(parseFloat(k)-parseFloat(j[0])>0||parseFloat(k)-parseFloat(j[0])==0)&&(parseFloat(k)-parseFloat(j[1])<0||parseFloat(k)-parseFloat(j[1])==0)}else{if(v=="="||v=="=="){return parseFloat(k)-parseFloat(j)==0}else{if(v=="null"){return k==null}else{if(v=="not null"){return k!=null}else{if(v=="exact"){for(var d=0;d<j.length;d++){if(k.toString()==(j[d]+"").toString()){return true}}return false}else{if(v=="like"||v=="not like"){var p=false;if(h){for(var d=0;d<j.length;d++){if((k+"").search(j[d]+"")!=-1||j[d].toString()==k.toString()){p=true;if(v=="like"){break}}}}else{var a=(k+"").toLowerCase();for(var d=0;d<j.length;d++){var s=(j[d]+"").toLowerCase();if(a.search(s)!=-1||a.toString()==s.toString()){p=true;if(v=="like"){break}}}}return v=="like"?p:!p}}}}}}}}}}};var t=function(a){if(!c[a]){c[a]=0}c[a]++};if(this.graphType=="Genome"&&this.filterFeatureBy.comp.length>0){for(var R=0;R<this.filterFeatureBy.comp.length;R++){if(this.filterFeatureBy.comp[R]){for(var Q=0;Q<this.data.tracks.length;Q++){var n=this.data.tracks[Q];var e=n.data;for(var P=0;P<e.length;P++){var z=e[P];if(this.filterSkipNullKeys&&!z.hasOwnProperty(this.filterFeatureBy.comp[R])){continue}var I=E(this.filterFeatureBy.comp[R],z,this.featuresProperties);if(!y(I,this.filterFeatureBy.opp[R],this.filterFeatureBy.value[R],this.filterFeatureBy.cases[R])){z.hide=this.filterType=="and"?true:w[Q+":"+P]?false:true;N[Q+":"+P]=true}else{w[Q+":"+P]=true;if(this.filterType=="or"&&N[Q+":"+P]){z.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.comp.length>0||this.filterEdgeBy.comp.length)){for(var R=0;R<this.filterNodeBy.comp.length;R++){if(this.filterNodeBy.comp[R]){for(var Q=0;Q<this.data.nodes.length;Q++){if(this.filterSkipNullKeys&&!this.data.nodes[Q].hasOwnProperty(this.filterNodeBy.comp[R])){continue}if(this.data.nodes[Q].hide){continue}var I=E(this.filterNodeBy.comp[R],this.data.nodes[Q],this.nodesProperties);if(!y(I,this.filterNodeBy.op[R],this.filterNodeBy.value[R],this.filterNodeBy.cases[R])){this.data.nodes[Q].hide=this.filterType=="and"?true:w[this.data.nodes[Q].id]?false:true;N[this.data.nodes[Q].id]=true}else{w[this.data.nodes[Q].id]=true;if(this.filterType=="or"&&N[this.data.nodes[Q].id]){this.data.nodes[Q].hide=false}}}}}for(var R=0;R<this.filterEdgeBy.comp.length;R++){if(this.filterEdgeBy.comp[R]){for(var Q=0;Q<this.data.edges.length;Q++){var x=this.data.nodes[this.data.nodeIndices[this.data.edges[Q].id1]];var u=this.data.nodes[this.data.nodeIndices[this.data.edges[Q].id2]];var B=x.id+":"+u.id;if(this.filterSkipNullKeys&&!this.data.edges[Q].hasOwnProperty(this.filterEdgeBy.comp[R])){continue}var I=E(this.filterEdgeBy.comp[R],this.data.edges[Q],this.edgesProperties);if(!y(I,this.filterEdgeBy.op[R],this.filterEdgeBy.value[R],this.filterEdgeBy.cases[R])){this.data.edges[Q].hide=this.filterType=="and"?true:w[B]?false:true;N[B]=true}else{w[B]=true;if(this.filterType=="or"&&N[B]){this.data.edges[Q].hide=false}}if(!this.data.edges[Q].hide){t(x.id);t(u.id)}}}}if(this.filterEdgeBy.comp.length>0){for(var R=0;R<this.data.nodes.length;R++){var b=this.data.nodes[R];if(!c[b.id]){b.hide=true}}}}else{if(this.isCreateHistogram&&!F){if(this.filterVarBy.length>0){var U=this.dataStndBy;var S=this.data.y.histogram}}else{if(this.filterDataBy.comp.length>0){var L=[];var f=this.filterDataBy;for(var R=0;R<this.varIndices.length;R++){var I=this.varIndices[R];var T=false;for(var Q=0;Q<this.smpIndices.length;Q++){var J=this.smpIndices[Q];for(var P=0;P<f.comp.length;P++){var r=this.data.y[f.comp[P]][I][J];var o=f.value[P]=="No Alteration"?[""]:f.value[P];var A=y(r,f.op[P],o,f.cases[P]);if(this.filterType=="and"&&!F){if(A){T=true}else{T=false;break}}else{if(A){T=true;break}}}if(T){break}}if(T){L.push(I)}}if(F){for(var R=0;R<L.length;R++){this.hiddenVars[L[R]]=true}}}else{if(this.filterVarBy.comp.length>0||this.filterSmpBy.comp.length>0){var L=G(F);var O=K(F);var m=this.isGroupedData&&this.layoutValid?K(F,true):false;if(F&&L){for(var R=0;R<L.length;R++){this.hiddenVars[L[R]]=true}}else{if(L){this.varIndices=L}}if(this.isGroupedData&&!C){if(F&&O){for(var R=0;R<O.length;R++){this.hiddenGrps[O[R]]=true}}else{if(O){this.grpIndices=O}}}else{if(F&&O){for(var R=0;R<O.length;R++){this.hiddenSmps[O[R]]=true}if(this.graphType.match(/Scatter/)){if(this.axesType=="X"&&this.xAxisIndices.length>1){if(this.hiddenSmps[this.yAxisIndices[0]]){this.hiddenSmps[this.yAxisIndices[0]]=false}}else{if(this.axesType=="Y"&&this.yAxisIndices.length>1){if(this.hiddenSmps[this.xAxisIndices[0]]){this.hiddenSmps[this.xAxisIndices[0]]=false}}}}}else{if(O){this.smpIndices=O}}}if(m){this.hiddenGrpsLayout=[];for(var R=0;R<m.length;R++){this.hiddenGrpsLayout[m[R]]=true}}else{this.hiddenGrpsLayout=false}}else{this.hiddenGrpsLayout=false}}}}}if(this.layoutComb&&!this.graphType.match(/Scatter/)){this.restoreEmptyCompartments();var l=this.getObjectArray(this.varIndices);var g=this.getObjectArray(this.smpIndices);for(var R=0;R<this.data.l.comp.length;R++){var M=this.layoutParams[R];var I=M.startingVarIndices;var J=M.startingSmpIndices;var V=[];if(I){for(var Q=0;Q<I.length;Q++){if(l.hasOwnProperty(I[Q])){V.push(I[Q])}}M.varIndices=V}V=[];if(J){for(var Q=0;Q<J.length;Q++){if(g.hasOwnProperty(J[Q])){V.push(J[Q])}}M.smpIndices=V}}}};this.resetFilters=function(f,b){var e=this;var d=function(g){if(b!=null&&e[g].comp.length>0){e[g].comp.splice(b,1);e[g].op.splice(b,1);e[g].value.splice(b,1);e[g].cases.splice(b,1);e[g].type.splice(b,1)}else{e[g].comp=[];e[g].op=[];e[g].value=[];e[g].cases=[];e[g].type=[]}};var a=f?[f]:["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"];delete (this.hiddenLegends);for(var c=0;c<a.length;c++){d(a[c])}};this.setFunctionNames("initFilterUtils")};CanvasXpress.prototype.initClusterUtils=function(){this.setDendrograms=function(){if(this.smpDendrogramNewick){this.smpDendrogram={};this.parseNewick(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick){this.varDendrogram={};this.parseNewick(this.varDendrogramNewick,"varDendrogram")}};this.parseNewick=function(a,d){var k=this;var w=0;var b=[];var t={};var c=0;var g=0;var u=0;var p=0;var j=[];var z=0;var A=0;this[d+"NodeId"]=0;var q=a.split(/\s*(;|\(|\)|,|:)\s*/);var l=function(D){var x=[];for(var C=0;C<D.length;C++){x.push(D[C].mid)}return k.mean(x)};var o=function(C){if(C.children){C.depth=g++;z=Math.max(z,C.depth);for(var x=0;x<C.children.length;x++){o(C.children[x]);if(C.children[x].children){C.children[x].mid=l(C.children[x].children)}}g--;p++}else{C.depth=g;u++}};var e=function(C){if(C.children){for(var x=0;x<C.children.length;x++){e(C.children[x]);if(C.children[x].children){C.children[x].len=1+z-C.children[x].depth}}}else{C.len=1+z-C.depth}};for(var y=0;y<q.length;y++){if(!w){var h=q[y];switch(h){case"(":var B={};t.children=[B];b.push(t);t=B;break;case",":if(b.length>0){var B={};b[b.length-1].children.push(B);t=B}else{w++}break;case")":t=b.pop();t.nodeId=this[d+"NodeId"]++;break;case":":break;default:var m=q[y-1];if(m==")"||m=="("||m==","){t.name=h;if(h&&!t.children){var s=d=="smpDendrogram"?this.getSampleIndices(h):this.getVariableIndices(h);if(s==-1){s=parseInt(h);t.name=d=="smpDendrogram"?this.data.y.smps[s]:this.data.y.vars[s];t.idx=s}else{t.idx=s}j.push(t.idx);t.ord=c++;t.mid=t.ord}}else{if(m==":"){t.height=parseFloat(h);A++}}}}else{if(w<3){this.parseNewick("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}o(t);e(t);t.max=z+1;t.leafs=u;t.useHeight=A==p;t.mid=l(t.children);t.axis=d;this[d]=t;var r={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":"smpIndicesStart"};if(this[r.show]){var f;if(this[r.strt]<0){if(u!=this.data.y[r.data].length){f="Dude! The length of the "+r.labl+" nodes in the dendrogram ("+u+") is different to that one in the data ("+this.data.y[r.data].length+"). This ain't gonna work!";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{if(u!=this[r.indx].length){f="Ooops! Cannot show dendrogram with "+u+" nodes when only "+this[r.indx].length+" "+r.labl+" are visible.";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{this[r.indx]=j}}}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}};this.writeNewick=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.writeNewick(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+this.sprintf("%.1f",b.height)}return d};this.euclidianDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.pow(b[c]-a[c],2)}f=Math.sqrt(f)}return f};this.manhattanDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.abs(b[c]-a[c])}}return f};this.maxDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f=Math.max(f,Math.abs(b[c]-a[c]))}}return f};this.classifyKmeansVector=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.addVectors=function(c,b,g,f){var e=this.cleanArrays(c,b,g,f);c=e[0];b=e[1];var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a,g,f){var d=this.cleanArrays(b,a,g,f);b=d[0];a=d[1];var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=b[c]*a[c]}}return e};this.multiplyVectorByValue=function(a,d,e,c){a=this.cleanArray(a,e,c);for(var b=0;b<a.length;b++){a[b]*=d}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomCentroids=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.random())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}return h};this.cluster=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var z=this.getDataForClustering();var v=this.getIdsForClustering();var o=[];var e=[];var B=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var u=this.meta.tree;u[this.clusterAxis]=[];for(var y=0;y<z.length;y++){o[y]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length-1;y++){for(var x=y+1;x<z.length;x++){o[x][x]=Number.POSITIVE_INFINITY;o[y][x]=this[this.distance+"Distance"](z[y],z[x]);o[x][y]=o[y][x]}}for(var y=0;y<z.length;y++){e[y]=0;for(var x=0;x<z.length;x++){if(o[y][e[y]]>o[y][x]){e[y]=x}}}for(var y=0;y<z.length;y++){a[y]=[];a[y][0]=this.createClusterNode(v[y],null,null,0,z[y]);B[y]=1}var b=-1;for(var q=0;q<z.length-1;q++){var s=0;for(var y=0;y<z.length;y++){if(o[y][e[y]]<o[s][e[s]]){s=y}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var t=a[r][0];var g=this.getCentroid(f.size,f.centroid,t.size,t.centroid);var A=this.createClusterNode(b,f,t,o[s][r],g);a[s].splice(0,0,A);for(var x=0;x<z.length;x++){if(this.linkage=="single"){if(o[s][x]>o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="complete"){if(o[s][x]<o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="average"){o[x][s]=o[s][x]=((B[s]*o[s][x])+(B[r]*o[r][x]))/(B[s]+B[r])}}}}B[s]+=B[r];o[s][s]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length;y++){o[y][r]=o[r][y]=Number.POSITIVE_INFINITY}for(var x=0;x<z.length;x++){if(e[x]==r){e[x]=s}}for(var x=0;x<z.length;x++){for(var w=0;w<z.length;w++){if(o[w][x]<o[w][e[w]]){e[w]=x}}}h=A;u[this.clusterAxis].push([f.id,t.id,h.dist]);b--}return this.writeNewickCluster(h,true)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewickCluster=function(k,g,j){var h="";var e="";var f=false;if(this.isLeafNode(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.getVariableIndices(k.id):this.getSampleIndices(k.id)}else{h=k.id}}else{var b;var c=this.writeNewickCluster(k.left,g,true);var a=this.writeNewickCluster(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+this.sprintf("%.1f",k.dist)}return h};this.kmeans=function(){var p=this.getDataForClustering();var q=this.createRandomCentroids(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var v=true;while(v){for(var e=0;e<p.length;e++){m[e]=this.classifyKmeansVector(p[e],q)}v=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var u=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}u[f]=h/l.length;if(u[f]!=o[f]){v=true}}q[c]=u;n[c]=l}s++;if(s>this.maxIterations){v=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var t=a[m[e]]+1;if(t>9){m[e]="K"+t}else{m[e]="K-0"+t}}return m};this.setFunctionNames("initClusterUtils")};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){this.functionCaller="sortNetworkIndices";if(this.isTransition()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw()};this.sortOncoprint=function(){if(this.isOncoprint){this.sortIndices("smps","desc",["Altered-Smps"]);this.sortIndices("vars","desc",["Altered-Vars"])}};this.sortIndices=function(d,j,b,c,l,n){var e=this.sortCaseSensitive;var u=function(m,i){if(m==null){m=""}if(i==null){i=""}if(e){return(m.toString()).localeCompare(i.toString())}else{return(m.toString().toLowerCase()).localeCompare(i.toString().toLowerCase())}};var g="";var k;var a=[];var p=this.meta.data;var w=[];for(var r=0;r<this.varIndices.length;r++){w.push(this.varIndices[r])}var v=[];for(var r=0;r<this.smpIndices.length;r++){v.push(this.smpIndices[r])}var s=[];if(this.grpIndices){for(var r=0;r<this.grpIndices.length;r++){s.push(this.grpIndices[r])}}if(b){b=this.toArray(b)}if(c){c=this.toArray(c)}if(l){l=this.toArray(l)}if(!j){j=this.sortDir}if(b&&d=="vars"){for(var r=0;r<b.length;r++){var f=b[r];a.push(this.data.z[f]);g+=p.z[f].type=="Numeric"?"N":"S"}k="varIndices"}else{if(b&&d=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,j,b,c,l,n);this.isGroupedData=true}for(var r=0;r<b.length;r++){var f=b[r];a.push(this.isGroupedData?this.data.w.factors[f]:this.data.x[f]);g+=p.x[f].type=="Numeric"?"N":"S"}k=this.isGroupedData?"grpIndices":"smpIndices"}else{if(n){var r=c?parseInt(this.getVariableIndices(c[0])):parseInt(this.getSampleIndices(l[0]));a.push(this.data.y[n][r]);g="N"}else{if(c){for(var r=0;r<c.length;r++){a.push(this.getDataForSmpGrpAtIndex(c[r]-1,this.varIndices,n));g+="N"}k="varIndices"}else{if(l){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,j,b,c,l,n);this.isGroupedData=true}var x=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:n?this.data.y[n]:this.data.y.data;for(var r=0;r<l.length;r++){a.push(x[l[r]-1]);g+="N"}k=this.isGroupedData?"grpIndices":"smpIndices"}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,j,b,c,l,n);this.isGroupedData=true}a.push(this.isGroupedData?this.data.w.smps:d=="vars"?this.data.y.vars:this.data.y.smps);k=this.isGroupedData?"grpIndices":d=="vars"?"varIndices":"smpIndices";g="S"}}}}}var h=k=="grpIndices"?s:k=="smpIndices"?v:w;var q=Number.MAX_VALUE*-1;switch(g){case"S":h.sort(function(m,i){return u(a[0][m],a[0][i])||(m-i)});break;case"N":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||(m-i)});break;case"SS":h.sort(function(m,i){return u(a[0][m],a[0][i])||u(a[1][m],a[1][i])||(m-i)});break;case"SN":h.sort(function(m,i){return u(a[0][m],a[0][i])||((a[1][m]||q)-(a[1][i]||q))||(m-i)});break;case"NN":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||((a[1][m]||q)-(a[1][i]||q))||(m-i)});break;case"NS":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||u(a[1][m],a[1][i])||(m-i)});break;case"SSS":h.sort(function(m,i){return u(a[0][m],a[0][i])||u(a[1][m],a[1][i])||u(a[2][m],a[2][i])||(m-i)});break;case"SSN":h.sort(function(m,i){return u(a[0][m],a[0][i])||u(a[1][m],a[1][i])||((a[2][m]||q)-(a[2][i]||q))||(m-i)});break;case"SNS":h.sort(function(m,i){return u(a[0][m],a[0][i])||((a[1][m]||q)-(a[1][i]||q))||u(a[2][m],a[2][i])||(m-i)});break;case"NSS":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||u(a[1][m],a[1][i])||u(a[2][m],a[2][i])||(m-i)});break;case"NNN":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||((a[1][m]||q)-(a[1][i]||q))||((a[2][m]||q)-(a[2][i]||q))||(m-i)});break;case"NNS":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||((a[1][m]||q)-(a[1][i]||q))||u(a[2][m],a[2][i])||(m-i)});break;case"NSN":h.sort(function(m,i){return((a[0][m]||q)-(a[0][i]||q))||u(a[1][m],a[1][i])||((a[2][m]||q)-(a[2][i]||q))||(m-i)});break;case"SNN":h.sort(function(m,i){return u(a[0][m],a[0][i])||((a[1][m]||q)-(a[1][i]||q))||((a[2][m]||q)-(a[2][i]||q))||(m-i)});break}if(j!="ascending"&&j!="asc"){h.reverse()}this.sorting=[d,j,b,c,l,n];this[k]=h};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.isAsciiArray=function(a){return !this.isNumeric(a)};this.sortObject=function(b){var a=Object.keys(b);if(this.isAsciiArray(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.stringRangeSort=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort()}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.resetSorting=function(){delete this.sorting};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n};this.setFunctionNames("initSortUtils")};CanvasXpress.prototype.initNumeric=function(){this.numeric=function(s,m){var M=function(S){var U=this.length,T;for(T=0;T<U;++T){if(this[T]===S){return T}}return -1};var p=(Array.prototype.indexOf)?Array.prototype.indexOf:M;var a=function a(S){var V,U;function T(W){var X=[];while(typeof W==="object"){X.push(W.length);W=W[0]}return X}if(typeof S==="object"){V=S[0];if(typeof V==="object"){U=V[0];if(typeof U==="object"){return T(S)}return[S.length,V.length]}return[S.length]}return[]};var D=function(W,T,S){if(typeof S==="undefined"){S=0}var X=W[S],U=Array(X),V;if(S===W.length-1){for(V=X-2;V>=0;V-=2){U[V+1]=T;U[V]=T}if(V===-1){U[0]=T}return U}for(V=X-1;V>=0;V--){U[V]=D(W,T,S+1)}return U};var R=function(Z,Y){var S=function(ap,ao){var aj,ah,af,ad,ac,ab,al,an,ak,ai,ag,am,aq,ae;ad=ap.length;ac=ao.length;ab=ao[0].length;al=Array(ad);for(aj=ad-1;aj>=0;aj--){an=Array(ab);ak=ap[aj];for(af=ab-1;af>=0;af--){ai=ak[ac-1]*ao[ac-1][af];for(ah=ac-2;ah>=1;ah-=2){ag=ah-1;ai+=ak[ah]*ao[ah][af]+ak[ag]*ao[ag][af]}if(ah===0){ai+=ak[0]*ao[0][af]}an[af]=ai}al[aj]=an}return al};var V=function(ac,ad,ab){var af=ac.length,ae;for(ae=af-1;ae>0;--ae){ab[ae]=ac[ae][ad];--ae;ab[ae]=ac[ae][ad]}if(ae===0){ab[0]=ac[0][ad]}};var W=function(am,al){var an=V,ab=al.length,ao=Array(ab);var ae=am.length,ad=al[0].length,ac=new Array(ae),aj;var ag=aa;var ai,ah,af,ak;--ab;--ae;for(ai=ae;ai!==-1;--ai){ac[ai]=Array(ad)}--ad;for(ai=ad;ai!==-1;--ai){an(al,ai,ao);for(ah=ae;ah!==-1;--ah){ak=0;aj=am[ah];ac[ah][ai]=ag(aj,ao)}}return ac};var T=function(ab,ag){var af=ab.length,ae=ag.length,ad;var ac=Array(af);for(ad=af-1;ad>=0;ad--){ac[ad]=aa(ab[ad],ag)}return ac};var U=function(ai,ah){var aq,ap,ao,al,ak,aj,aw,au,at,af,an,ag,ad,ar,ae,ac,ab,am,av;al=ai.length;ak=ah[0].length;aw=Array(ak);for(ao=ak-1;ao>=0;ao--){af=ai[al-1]*ah[al-1][ao];for(ap=al-2;ap>=1;ap-=2){an=ap-1;af+=ai[ap]*ah[ap][ao]+ai[an]*ah[an][ao]}if(ap===0){af+=ai[0]*ah[0][ao]}aw[ao]=af}return aw};var aa=function(ab,ag){var ad,af=ab.length,ae,ac=ab[af-1]*ag[af-1];for(ad=af-2;ad>=1;ad-=2){ae=ad-1;ac+=ab[ad]*ag[ad]+ab[ae]*ag[ae]}if(ad===0){ac+=ab[0]*ag[0]}return ac};var X=a;switch(X(Z).length*1000+X(Y).length){case 2002:if(Y.length<10){return S(Z,Y)}else{return W(Z,Y)}case 2001:return T(Z,Y);case 1002:return U(Z,Y);case 1001:return aa(Z,Y);case 1000:return mulVS(Z,Y);case 1:return mulSV(Z,Y);case 0:return Z*Y;default:throw new Error("dot only works on vectors and matrices")}};var k=function(X){var V,W,U,Y=X.length,S=Array(Y),T;for(V=Y-1;V>=0;V--){T=Array(Y);W=V+2;for(U=Y-1;U>=W;U-=2){T[U]=0;T[U-1]=0}if(U>V){T[U]=0}T[V]=X[V];for(U=V-1;U>=1;U-=2){T[U]=0;T[U-1]=0}if(U===0){T[0]=0}S[V]=T}return S};var C=function(S){var V=Math.min(S.length,S[0].length),U,T=Array(V);for(U=V-1;U>=1;--U){T[U]=S[U][U];--U;T[U]=S[U][U]}if(U===0){T[0]=S[0][0]}return T};var G=function(S){return k(D([S],1))};var I=function(S,Y,V,T,W){if(T===V.length-1){W(S,Y);return}var U,X=V[T];for(U=X-1;U>=0;U--){I(typeof S==="object"?S[U]:S,typeof Y==="object"?Y[U]:Y,V,T+1,W)}};var L=function(S,Z,W,T,X){if(T===W.length-1){return X(S,Z)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;--V){U[V]=L(typeof S==="object"?S[V]:S,typeof Z==="object"?Z[V]:Z,W,T+1,X)}return U};var A=function(S,V,T,W){if(T===V.length-1){W(S);return}var U,X=V[T];for(U=X-1;U>=0;U--){A(S[U],V,T+1,W)}};var H=function(S,W,T,X){if(T===W.length-1){return X(S)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;V--){U[V]=H(S[V],W,T+1,X)}return U};var d=function(){var X=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag[af]}return ae};var Y=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac+ag[af]}return ae};var Z=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag}return ae};var S=arguments.length,V,ab=arguments[0],aa;var T=X,W=Z,U=Y;for(V=1;V!==S;++V){aa=arguments[V];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,W)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab+=aa}}}return ab};var x=function(){var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag[af]}return ae};var T=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac-ag[af]}return ae};var V=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag}return ae};var U=arguments.length,Y,ab=arguments[0],aa;var W=S,Z=V,X=T;for(Y=1;Y!==U;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,W)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,X)}else{ab-=aa}}}return ab};var c=function(){var Z=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag[af]}return ae};var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac*ag[af]}return ae};var ab=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag}return ae};var S=arguments.length,V,Y=arguments[0],X;var T=Z,W=ab,U=aa;for(V=1;V!==S;++V){X=arguments[V];if(typeof Y==="object"){if(typeof X==="object"){Y=L(Y,X,a(Y),0,T)}else{Y=L(Y,X,a(Y),0,W)}}else{if(typeof X==="object"){Y=L(Y,X,a(X),0,U)}else{Y*=X}}}return Y};var K=function(){var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag[af]}return ae};var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac/ag[af]}return ae};var S=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag}return ae};var T=arguments.length,W,Z=arguments[0],Y;var U=aa,X=S,V=ab;for(W=1;W!==T;++W){Y=arguments[W];if(typeof Z==="object"){if(typeof Y==="object"){Z=L(Z,Y,a(Z),0,U)}else{Z=L(Z,Y,a(Z),0,X)}}else{if(typeof Y==="object"){Z=L(Z,Y,a(Y),0,V)}else{Z/=Y}}}return Z};var h=function(){var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag[af]}return ae};var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac!==ag[af]}return ae};var T=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag}return ae};var U=arguments.length,X,aa=arguments[0],Z;var V=ab,Y=T,W=S;for(X=1;X!==U;++X){Z=arguments[X];if(typeof aa==="object"){if(typeof Z==="object"){aa=L(aa,Z,a(aa),0,V)}else{aa=L(aa,Z,a(aa),0,Y)}}else{if(typeof Z==="object"){aa=L(aa,Z,a(Z),0,W)}else{aa=aa!==Z}}}return aa};var u=function(){var T=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var U=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var X=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,Y,ab=arguments[0],aa;var V=T,Z=X,W=U;for(Y=1;Y!==S;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,V)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,W)}else{ab=u(ab,aa)}}}return ab};var w=function(){var X=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah[ag])}return af};var Y=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad,ah[ag])}return af};var aa=function(ad,ah){var ae=ad.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah)}return af};var S=arguments.length,V,ab=arguments[0],Z;var T=X,W=aa,U=Y;for(V=1;V!==S;++V){Z=arguments[V];if(typeof ab==="object"){if(typeof Z==="object"){ab=L(ab,Z,a(ab),0,T)}else{ab=L(ab,Z,a(ab),0,W)}}else{if(typeof Z==="object"){ab=L(ab,Z,a(Z),0,U)}else{ab=w(ab,Z)}}}return ab};var O=function(){var V=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var X=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var Z=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,W,ab=arguments[0],aa;var T=V,Y=Z,U=X;for(W=1;W!==S;++W){aa=arguments[W];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,Y)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab=O(ab,aa)}}}return ab};var q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=-(V[aa])}return Z};if(typeof S!=="object"){return -(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var v=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=(V[aa])}return Z};if(typeof S!=="object"){return(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var y=function(S){var X=function(Y){var Z=Y.length;var ab,aa=Array(Z);var V=Math.abs;for(ab=Z-1;ab!==-1;--ab){aa[ab]=V(Y[ab])}return aa};if(typeof S!=="object"){return y(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var f=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.cos;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return f(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var Q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.exp;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return Q(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var o=function(T){var S=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.log;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof T!=="object"){return o(T)}var W;var U=S;var X=a(T);return H(T,X,0,U)};var r=function(S){var X=function(V){var Z=V.length;var ab,aa=Array(Z);var Y=Math.sin;for(ab=Z-1;ab!==-1;--ab){aa[ab]=Y(V[ab])}return aa};if(typeof S!=="object"){return r(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var F=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.sqrt;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return F(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var J=function(S,Y,V){var X=function(aa){var ae=aa.length;var ad,ac;var ab=0;for(ad=ae-1;ad!==-1;--ad){ac=aa[ad];ab+=ac*ac}return ab};var U=0;if(typeof S!=="object"){T=S;U+=T*T;return U}if(typeof Y==="undefined"){Y=a(S)}if(typeof V==="undefined"){V=0}if(V===Y.length-1){return X(S)}var T;var Z=S.length,W;for(W=Z-1;W!==-1;--W){T=arguments.callee(S[W]);U+=T*T}return U};var t=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=T[W];X[Y-1]=V[W];--W;X=Z[W];X[Y]=T[W];X[Y-1]=V[W]}if(W===0){X=Z[0];X[Y]=T[0];X[Y-1]=V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=V[W];--W;Z[W][0]=V[W]}if(W===0){Z[0][0]=V[0]}}return Z};var n=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W];--W;X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W]}if(W===0){X=Z[0];X[Y]=-T[0];X[Y-1]=-V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=-V[W];--W;Z[W][0]=-V[W]}if(W===0){Z[0][0]=-V[0]}}return Z};var l=function(S){return Math.sqrt(J(S))};var j=function(S,W,V){var T=a(S);function U(X,Z){var ab,Y=W[Z],ac=V[Z]-Y,aa=Array(ac);if(Z===T.length-1){for(ab=ac;ab>=0;ab--){aa[ab]=X[ab+Y]}return aa}for(ab=ac;ab>=0;ab--){aa[ab]=U(X[ab+Y],Z+1)}return aa}return U(S,0)};var e=function(S,X,W,V){var T=a(S);function U(Y,ad,aa){var ab,Z=X[aa],ac=W[aa]-Z;if(aa===T.length-1){for(ab=ac;ab>=0;ab--){Y[ab+Z]=ad[ab]}}for(ab=ac;ab>=0;ab--){U(Y[ab+Z],ad[ab],aa+1)}}U(S,V,0);return S};var i=function(T,ab,aa){var W=ab.length,V=aa.length;var Y,X;var S=Array(W),Z,U;for(Y=W-1;Y!==-1;--Y){S[Y]=Array(V);Z=S[Y];U=T[ab[Y]];for(X=V-1;X!==-1;--X){Z[X]=U[aa[X]]}}return S};var B=function(Z,Y){if(typeof Z==="number"||typeof Y==="number"){return c(Z,Y)}var ac=a(Z),aa=a(Y);if(ac.length!==1||aa.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var U=ac[0],T=aa[0],S=Array(U),ab,W,V,X;for(W=U-1;W>=0;W--){ab=Array(T);X=Z[W];for(V=T-1;V>=3;--V){ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V]}while(V>=0){ab[V]=X*Y[V];--V}S[W]=ab}return S};var g=function g(S,T){this.x=S;this.y=T};g.prototype={};g.prototype.add=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(d(S.x,T.x),d(S.y,T.y))}return new g(d(S.x,T.x),S.y)}if(T.y){return new g(d(S.x,T.x),T.y)}return new g(d(S.x,T.x))};g.prototype.sub=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(S.x,T.x),x(S.y,T.y))}return new g(x(S.x,T.x),S.y)}if(T.y){return new g(x(S.x,T.x),q(T.y))}return new g(x(S.x,T.x))};g.prototype.mul=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(c(S.x,T.x),c(S.y,T.y)),d(c(S.x,T.y),c(S.y,T.x)))}return new g(c(S.x,T.x),c(S.y,T.x))}if(T.y){return new g(c(S.x,T.x),c(S.x,T.y))}return new g(c(S.x,T.x))};g.prototype.reciprocal=function(){if(this.y){var S=d(c(this.x,this.x),c(this.y,this.y));return new g(K(this.x,S),K(q(this.y),S))}return new g(K(1,this.x))};g.prototype.div=function(S){if(!(S instanceof g)){S=new g(S)}if(S.y){return this.mul(S.reciprocal())}if(this.y){return new g(K(this.x,S.x),K(this.y,S.x))}return new g(K(this.x,S.x))};g.prototype.dot=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(R(S.x,T.x),R(S.y,T.y)),d(R(S.x,T.y),R(S.y,T.x)))}return new g(R(S.x,T.x),R(S.y,T.x))}if(T.y){return new g(R(S.x,T.x),R(S.x,T.y))}return new g(R(S.x,T.x))};g.prototype.transpose=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),T(U))}return new g(T(S))};g.prototype.transjugate=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),n(U))}return new g(T(S))};g.prototype.exp=function(){var S=this;var T=Q(S.x);if(S.y){return new g(c(f(S.y),T),c(r(S.y),T))}return new g(T)};g.prototype.conj=function(){var S=this;if(S.y){return new g(S.x,q(S.y))}return new g(S.x)};g.prototype.neg=function(){var S=this;if(S.y){return new g(q(S.x),q(S.y))}return new g(q(S.x))};g.prototype.sin=function(){var S=this;if(S.y){return S.exp().sub(S.neg().exp()).div(new g(0,2))}return new g(r(S.x))};g.prototype.cos=function(){var S=this;if(S.y){return S.exp().add(S.neg().exp()).div(2)}return new g(f(S.x))};g.prototype.abs=function(){var S=this;if(S.y){return new g(F(d(c(S.x,S.x),c(S.y,S.y))))}return new g(y(S.x))};g.prototype.log=function(){var S=this;if(S.y){var T=new g(u(S.y,S.x)),U=S.abs();return new g(o(U.x),T.x)}return new g(o(S.x))};g.prototype.norm2=function(){var S=this;if(S.y){var T=J;return Math.sqrt(T(S.x)+T(S.y))}return l(S.x)};g.prototype.get=function(V){var S=this.x,X=this.y,T=0,U,W=V.length;if(X){while(T<W){U=V[T];S=S[U];X=X[U];T++}return new g(S,X)}while(T<W){U=V[T];S=S[U];T++}return new g(S)};g.prototype.set=function(U,aa){var Y=this.x,W=this.y,T=0,Z,S=U.length,X=aa.x,V=aa.y;if(S===0){if(V){this.y=V}else{if(W){this.y=undefined}}this.x=Y;return this}if(V){if(W){}else{W=D(a(Y),0);this.y=W}while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;W[Z]=V;return this}if(W){while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;if(X instanceof Array){W[Z]=D(a(X),0)}else{W[Z]=0}return this}while(T<S-1){Z=U[T];Y=Y[Z];T++}Z=U[T];Y[Z]=X;return this};g.prototype.getRows=function(W,U){var Z=U-W+1,T;var X=Array(Z),V,S=this.x,Y=this.y;for(T=W;T<=U;T++){X[T-W]=S[T]}if(Y){V=Array(Z);for(T=W;T<=U;T++){V[T-W]=Y[T]}return new g(X,V)}return new g(X)};g.prototype.setRows=function(X,V,T){var U;var Y=this.x,W=this.y,S=T.x,Z=T.y;for(U=X;U<=V;U++){Y[U]=S[U-X]}if(Z){if(!W){W=D(a(Y),0);this.y=W}for(U=X;U<=V;U++){W[U]=Z[U-X]}}else{if(W){for(U=X;U<=V;U++){W[U]=D([S[U-X].length],0)}}}return this};g.prototype.getRow=function(T){var S=this.x,U=this.y;if(U){return new g(S[T],U[T])}return new g(S[T])};g.prototype.setRow=function(U,T){var W=this.x,V=this.y,S=T.x,X=T.y;W[U]=S;if(X){if(!V){V=D(a(W),0);this.y=V}V[U]=X}else{if(V){V=D([S.length],0)}}return this};g.prototype.getBlock=function(W,V){var T=this.x,U=this.y,S=j;if(U){return new g(S(T,W,V),S(U,W,V))}return new g(S(T,W,V))};g.prototype.setBlock=function(Z,Y,U){if(!(U instanceof g)){U=new g(U)}var T=this.x,X=this.y,S=e,W=U.x,V=U.y;if(V){if(!X){this.y=D(a(this),0);X=this.y}S(T,Z,Y,W);S(X,Z,Y,V);return this}S(T,Z,Y,W);if(X){S(X,Z,Y,D(a(W),0))}};g.rep=function(U,T){if(!(T instanceof g)){T=new g(T)}var S=T.x,W=T.y,V=D;if(W){return new g(V(U,S),V(U,W))}return new g(V(U,S))};g.diag=function(T){if(!(T instanceof g)){T=new g(T)}var S=T.x,U=T.y;if(U){return new g(k(S),k(U))}return new g(k(S))};g.eig=function(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return N(this.x)};g.identity=function(S){return new g(G(S))};g.prototype.getDiag=function(){var S=this.x,T=this.y;if(T){return new g(C(S),C(T))}return new g(C(S))};var P=function(S){var T=v(S);var U=S[0]>=0?1:-1;var V=U*l(S);T[0]+=V;var W=l(T);if(W===0){throw new Error("eig: internal error")}return K(T,W)};var b=function(ac){var ag=a(ac);if(ag.length!==2||ag[0]!==ag[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var X=ag[0],aa,Z,Y,ad,af,V=v(ac),U,S,ae,T,ab=G(X),W;for(Z=0;Z<X-2;Z++){ad=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){ad[aa-Z-1]=V[aa][Z]}if(l(ad)>0){af=P(ad);U=j(V,[Z+1,Z],[X-1,X-1]);S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){ae=V[aa];T=S[aa-Z-1];for(Y=Z;Y<X;Y++){ae[Y]-=2*T[Y-Z]}}U=j(V,[0,Z+1],[X-1,X-1]);S=B(R(U,af),af);for(aa=0;aa<X;aa++){ae=V[aa];T=S[aa];for(Y=Z+1;Y<X;Y++){ae[Y]-=2*T[Y-Z-1]}}U=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){U[aa-Z-1]=ab[aa]}S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){W=ab[aa];T=S[aa-Z-1];for(Y=0;Y<X;Y++){W[Y]-=2*T[Y]}}}}return{H:V,Q:ab}};var z=function(af,V){if(typeof V==="undefined"){V=10000}af=v(af);var ah=v(af);var ai=a(af),am=ai[0],ae,ag,av,au,at,ar,X,S,W,aa=G(am),ac,ab,al,ak,aj,aq,ao,an,ap;if(am<3){return{Q:aa,B:[[0,am-1]]}}var aw=2.220446049250313e-16;for(ap=0;ap<V;ap++){for(ao=0;ao<am-1;ao++){if(Math.abs(af[ao+1][ao])<aw*(Math.abs(af[ao][ao])+Math.abs(af[ao+1][ao+1]))){var Z=z(j(af,[0,0],[ao,ao]),V);var Y=z(j(af,[ao+1,ao+1],[am-1,am-1]),V);al=Array(ao+1);for(aq=0;aq<=ao;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=ao;aq++){aa[aq]=ak[aq]}al=Array(am-ao-1);for(aq=ao+1;aq<am;aq++){al[aq-ao-1]=aa[aq]}ak=R(Y.Q,al);for(aq=ao+1;aq<am;aq++){aa[aq]=ak[aq-ao-1]}return{Q:aa,B:Z.B.concat(d(Y.B,ao+1))}}}av=af[am-2][am-2];au=af[am-2][am-1];at=af[am-1][am-2];ar=af[am-1][am-1];S=av+ar;X=(av*ar-au*at);W=j(af,[0,0],[2,2]);if(S*S>=4*X){var U,T;U=0.5*(S+Math.sqrt(S*S-4*X));T=0.5*(S-Math.sqrt(S*S-4*X));W=d(x(R(W,W),c(W,U+T)),k(D([3],U*T)))}else{W=d(x(R(W,W),c(W,S)),k(D([3],X)))}ae=[W[0][0],W[1][0],W[2][0]];ag=P(ae);al=[af[0],af[1],af[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<am;an++){ab[an]-=2*aj[an]}}al=j(af,[0,0],[am-1,2]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<3;an++){ab[an]-=2*aj[an]}}al=[aa[0],aa[1],aa[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ac=aa[aq];aj=ak[aq];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}var ad;for(ao=0;ao<am-2;ao++){for(an=ao;an<=ao+1;an++){if(Math.abs(af[an+1][an])<aw*(Math.abs(af[an][an])+Math.abs(af[an+1][an+1]))){var Z=z(j(af,[0,0],[an,an]),V);var Y=z(j(af,[an+1,an+1],[am-1,am-1]),V);al=Array(an+1);for(aq=0;aq<=an;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=an;aq++){aa[aq]=ak[aq]}al=Array(am-an-1);for(aq=an+1;aq<am;aq++){al[aq-an-1]=aa[aq]}ak=R(Y.Q,al);for(aq=an+1;aq<am;aq++){aa[aq]=ak[aq-an-1]}return{Q:aa,B:Z.B.concat(d(Y.B,an+1))}}}ad=Math.min(am-1,ao+3);ae=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){ae[aq-ao-1]=af[aq][ao]}ag=P(ae);al=j(af,[ao+1,ao],[ad,am-1]);ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ab=af[aq];aj=ak[aq-ao-1];for(an=ao;an<am;an++){ab[an]-=2*aj[an-ao]}}al=j(af,[0,ao+1],[am-1,ad]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=ao+1;an<=ad;an++){ab[an]-=2*aj[an-ao-1]}}al=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){al[aq-ao-1]=aa[aq]}ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ac=aa[aq];aj=ak[aq-ao-1];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};var N=function(ak,W){var T=b(ak);var X=z(T.H,W);var an=ak.length,at,ap,ar=false,ai=X.B,ae=R(X.Q,R(T.H,t(X.Q)));var Z=new g(R(X.Q,T.Q)),ag;var ao=ai.length,aq;var ax,aw,av,au,V,U,S,ad,ac,aj,ah,ab,aa;var ay=Math.sqrt;for(ap=0;ap<ao;ap++){at=ai[ap][0];if(at===ai[ap][1]){}else{aq=at+1;ax=ae[at][at];aw=ae[at][aq];av=ae[aq][at];au=ae[aq][aq];if(aw===0&&av===0){continue}V=-ax-au;U=ax*au-aw*av;S=V*V-4*U;if(S>=0){if(V<0){ad=-0.5*(V-ay(S))}else{ad=-0.5*(V+ay(S))}ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab);aj=(ax-ad)/ab;ah=aw/ab}else{aa=ay(aa);aj=av/aa;ah=(au-ad)/aa}ag=new g([[ah,-aj],[aj,ah]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}else{ad=-0.5*V;ac=0.5*ay(-S);ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab+ac*ac);aj=(ax-ad)/ab;ah=aw/ab;ad=0;ac/=ab}else{aa=ay(aa+ac*ac);aj=av/aa;ah=(au-ad)/aa;ad=ac/aa;ac=0}ag=new g([[ah,-aj],[aj,ah]],[[ad,ac],[ac,-ad]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}}}var Y=Z.dot(ak).dot(Z.transjugate()),an=ak.length,af=g.identity(an);for(aq=0;aq<an;aq++){if(aq>0){for(ap=aq-1;ap>=0;ap--){var al=Y.get([ap,ap]),am=Y.get([aq,aq]);if(h(al.x,am.x)||h(al.y,am.y)){ad=Y.getRow(ap).getBlock([ap],[aq-1]);ac=af.getRow(aq).getBlock([ap],[aq-1]);af.set([aq,ap],(Y.get([ap,aq]).neg().sub(ad.dot(ac))).div(al.sub(am)))}else{af.setRow(aq,af.getRow(ap));continue}}}}for(aq=0;aq<an;aq++){ad=af.getRow(aq);af.setRow(aq,ad.div(ad.norm2()))}af=af.transpose();af=Z.transjugate().dot(af);return{lambda:Y.getDiag(),E:af}};var E=function(ab){var ag=a(ab),ah=Math.abs,V=ag[0],U=ag[1];var T=v(ab),ad,aa;var ac=G(V),S,af;var Z,Y,W,ab;for(Y=0;Y<U;++Y){var X=-1;var ae=-1;for(Z=Y;Z!==V;++Z){W=ah(T[Z][Y]);if(W>ae){X=Z;ae=W}}aa=T[X];T[X]=T[Y];T[Y]=aa;af=ac[X];ac[X]=ac[Y];ac[Y]=af;ab=aa[Y];for(W=Y;W!==U;++W){aa[W]/=ab}for(W=U-1;W!==-1;--W){af[W]/=ab}for(Z=V-1;Z!==-1;--Z){if(Z!==Y){ad=T[Z];S=ac[Z];ab=ad[Y];for(W=Y+1;W!==U;++W){ad[W]-=aa[W]*ab}for(W=U-1;W>0;--W){S[W]-=af[W]*ab;--W;S[W]-=af[W]*ab}if(W===0){S[0]-=af[0]*ab}}}}return ac};switch(s){case"inv":return E(m);case"eig":return N(m)}};this.setFunctionNames("initNumeric")};CanvasXpress.prototype.initjLouvain=function(){this.jLouvain=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q};this.setFunctionNames("initjLouvain")};CanvasXpress.prototype.initConrec=function(){var d=1e-20;var c=function(h,g){var f=h.x-g.x,i=h.y-g.y;return f*f+i*i<d};var e=function(h){var f=h.head;while(f){var g=f.next;f.next=f.prev;f.prev=g;f=g}var g=h.head;h.head=h.tail;h.tail=g};var b=function(f){this.level=f;this.s=null;this.count=0};b.prototype.remove_seq=function(f){if(f.prev){f.prev.next=f.next}else{this.s=f.next}if(f.next){f.next.prev=f.prev}--this.count};b.prototype.addSegment=function(k,j){var p=this.s;var m=null;var l=null;var o=false;var n=false;while(p){if(m==null){if(c(k,p.head.p)){m=p;o=true}else{if(c(k,p.tail.p)){m=p}}}if(l==null){if(c(j,p.head.p)){l=p;n=true}else{if(c(j,p.tail.p)){l=p}}}if(l!=null&&m!=null){break}else{p=p.next}}var i=((m!=null)?1:0)|((l!=null)?2:0);switch(i){case 0:var f={p:k,prev:null};var h={p:j,next:null};f.next=h;h.prev=f;m={head:f,tail:h,next:this.s,prev:null,closed:false};if(this.s){this.s.prev=m}this.s=m;++this.count;break;case 1:var g={p:j};if(o){g.next=m.head;g.prev=null;m.head.prev=g;m.head=g}else{g.next=null;g.prev=m.tail;m.tail.next=g;m.tail=g}break;case 2:var g={p:k};if(n){g.next=l.head;g.prev=null;l.head.prev=g;l.head=g}else{g.next=null;g.prev=l.tail;l.tail.next=g;l.tail=g}break;case 3:if(m===l){var g={p:m.tail.p,next:m.head,prev:null};m.head.prev=g;m.head=g;m.closed=true;break}switch((o?1:0)|(n?2:0)){case 0:e(m);case 1:l.tail.next=m.head;m.head.prev=l.tail;l.tail=m.tail;this.remove_seq(m);break;case 3:e(m);case 2:m.tail.next=l.head;l.head.prev=m.tail;m.tail=l.tail;this.remove_seq(l);break}}};var a=function(f){if(!f){var g=this;g.contours={};this.drawContour=function(j,i,o,n,m,l){var h=g.contours[l];if(!h){h=g.contours[l]=new b(m)}h.addSegment({x:j,y:i},{x:o,y:n})};this.contourList=function(){var m=[];var j=g.contours;for(var n in j){var p=j[n].s;var q=j[n].level;while(p){var o=p.head;var i=[];i.level=q;i.k=n;while(o&&o.p){i.push(o.p);o=o.next}m.push(i);p=p.next}}m.sort(function(k,h){return h.k-k.k});return m}}else{this.drawContour=f}this.h=new Array(5);this.sh=new Array(5);this.xh=new Array(5);this.yh=new Array(5)};a.prototype.contour=function(Q,L,P,r,u,B,A,t,v){var N=this.h,S=this.sh,D=this.xh,U=this.yh;var H=this.drawContour;this.contours={};var q=function(i,h){return(N[h]*D[i]-N[i]*D[h])/(N[h]-N[i])};var R=function(i,h){return(N[h]*U[i]-N[i]*U[h])/(N[h]-N[i])};var l;var g;var f;var s;var C;var E;var O=0;var M=0;var o=0;var n=0;var w=[0,1,1,0];var K=[0,0,1,1];var p=[[[0,0,8],[0,2,5],[7,6,9]],[[0,3,4],[1,3,1],[4,3,0]],[[9,6,7],[5,2,0],[8,0,0]]];for(var I=(u-1);I>=r;I--){for(var J=L;J<=P-1;J++){var V,T;V=Math.min(Q[J][I],Q[J][I+1]);T=Math.min(Q[J+1][I],Q[J+1][I+1]);C=Math.min(V,T);V=Math.max(Q[J][I],Q[J][I+1]);T=Math.max(Q[J+1][I],Q[J+1][I+1]);E=Math.max(V,T);if(E>=v[0]&&C<=v[t-1]){for(var G=0;G<t;G++){if(v[G]>=C&&v[G]<=E){for(var F=4;F>=0;F--){if(F>0){N[F]=Q[J+w[F-1]][I+K[F-1]]-v[G];D[F]=B[J+w[F-1]];U[F]=A[I+K[F-1]]}else{N[0]=0.25*(N[1]+N[2]+N[3]+N[4]);D[0]=0.5*(B[J]+B[J+1]);U[0]=0.5*(A[I]+A[I+1])}if(N[F]>0){S[F]=1}else{if(N[F]<0){S[F]=-1}else{S[F]=0}}}for(F=1;F<=4;F++){l=F;g=0;if(F!=4){f=F+1}else{f=1}s=p[S[l]+1][S[g]+1][S[f]+1];if(s!=0){switch(s){case 1:O=D[l];o=U[l];M=D[g];n=U[g];break;case 2:O=D[g];o=U[g];M=D[f];n=U[f];break;case 3:O=D[f];o=U[f];M=D[l];n=U[l];break;case 4:O=D[l];o=U[l];M=q(g,f);n=R(g,f);break;case 5:O=D[g];o=U[g];M=q(f,l);n=R(f,l);break;case 6:O=D[f];o=U[f];M=q(l,g);n=R(l,g);break;case 7:O=q(l,g);o=R(l,g);M=q(g,f);n=R(g,f);break;case 8:O=q(g,f);o=R(g,f);M=q(f,l);n=R(f,l);break;case 9:O=q(f,l);o=R(f,l);M=q(l,g);n=R(l,g);break;default:break}H(O,o,M,n,v[G],G)}}}}}}}};this.conrec=a;this.setFunctionNames("initConrec")};CanvasXpress.prototype.initMathUtils=function(){this.isNaN=function(a){return isNaN(a)?true:a==Number.POSITIVE_INFINITY?true:a==Number.NEGATIVE_INFINITY?true:false};this.isFinite=function(a){if(this.isArray(a)){for(var b=0;b<a.length;b++){if(!isFinite(a[b])){return false}}return true}else{return isFinite(a)}};this.getPolar=function(b,e,d,c){return{x:b+d*Math.cos(c*Math.PI/180),y:e+d*Math.sin(c*Math.PI/180)}};this.triCube=function(a){return(a=1-a*a*a)*a*a};this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.radians=function(a){return a*Math.PI/180};this.getAngle=function(e,h,c,g,d){var b=(Math.atan2(g-h,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getRadians=function(d,g,c,e){var b=Math.atan2(e-g,c-d);if(b<0){b+=(2*Math.PI)}return b};this.rotatePoint=function(c,i,b,h,d){var g=Math.cos(d)*(c-b)-Math.sin(d)*(i-h)+b;var e=Math.sin(d)*(c-b)+Math.cos(d)*(i-h)+h;return[g,e]};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.lineMidPoint=function(b,d,a,c){return[(b+a)/2,(d+c)/2]};this.getCoordinateAtDistance=function(b,j,a,i,h){var c=a-b;var k=i-j;var e=Math.sqrt(Math.pow(c,2)+Math.pow(k,2));var g=h/e;return[b+(c*g),j+(k*g)]};this.parallelLinePoints=function(t,d,r,b,p){var j=r-t;var i=b-d;var q=this.lineLength(t,d,r,b);var w=j/q;var v=i/q;var u=-v;var s=w;var c=t+p*u;var g=d+p*s;var a=t-p*u;var e=d-p*s;var k=r+p*u;var o=b+p*s;var h=r-p*u;var n=b-p*s;return[c,g,a,e,k,o,h,n]};this.perpendicularLinePoints=function(b,o,a,j,c,g){var h=this.lineLength(b,o,a,j);var p=this.lineMidPoint(b,o,a,j);if(!c){c=h*g}var s=a-p[0];var r=j-p[1];var e=s/h;var d=r/h;var q=-d;var n=e;var k=p[0]+c*q;var i=p[1]+c*n;return[k,i]};this.shortenLine=function(g,p,c,o,t,j,u,a){if(this.isNumeric([g,p,c,o,t,j])){if(u.match(/bezier/i)){if(u.match(/beziery/i)){return o>p?[g,p+t,c,o-j]:[g,p-t,c,o+j]}else{return c>g?[g+t,p,c-j,o]:[g-t,p,c+j,o]}}else{if(u.match(/quadratic/i)){var l=this.lineLength(g,p,c,o);var d=this.perpendicularLinePoints(g,p,c,o,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(a))*(a>0?-1:1));var b=this.traceQuadraticCurve(g,p,d[0],d[1],c,o,t/l,true);var r=this.traceQuadraticCurve(c,o,d[0],d[1],g,p,j/l,true);return[b[1][0],b[1][1],r[1][0],r[1][1]]}else{if(u.match(/curved/i)){return[g,p,c,o]}else{var h=Math.atan2(o-p,c-g);var i=Math.cos(h);var n=Math.sin(h);var k=this.lineLength(g,p,c,o);if(k){while(k<(t+j)){t/=1.1;j/=1.1}g+=i*t;p+=n*t;c-=i*j;o-=n*j}return[g,p,c,o]}}}}};this.traceArc=function(c,b,a,n,h,d){if(n>h){var k=n;n=h;h=k}var l=[];var j=((Math.PI*2)-(h-n))/16;l.push([a*Math.cos(n)+c,a*Math.sin(n)+b]);for(var g=0;g<16;g++){n-=j;l.push([a*Math.cos(n)+c,a*Math.sin(n)+b])}return d?l.reverse():l};this.traceArc1=function(c,b,a,o,i,d){if(o>i){var l=o;o=i;i=l}var n=[];var h=Math.PI;var j=i-o;var g=32;var k=j/g;if(k<1e-9){n.push([a*Math.cos(o)+c,a*Math.sin(o)+b])}else{n.push([a*Math.cos(o)+c,a*Math.sin(o)+b]);o+=k;while(o<i){n.push([a*Math.cos(o)+c,a*Math.sin(o)+b]);o+=k}n.push([a*Math.cos(i)+c,a*Math.sin(i)+b])}return d?n:n.reverse()};this.traceQuadraticCurve=function(n,l,e,c,k,j,b,g){var o=[];b=Math.max(0.01,b);var a=function(i,s,r,q){var p=1-i;return p*p*s+2*p*i*r+i*i*q};var d=function(i){return[a(i,n,e,k),a(i,l,c,j)]};for(var h=0;h<=1;h+=b){o.push(d(h))}return g?o:o.reverse()};this.traceBezierCurve=function(k,j,c,b,n,l,h,g,a,d){var o=[];a=Math.max(0.01,a);for(var e=0;e<=1;e+=a){o.push(this.deCasteljau([[k,j],[c,b],[n,l],[h,g]],e))}return d?o:o.reverse()};this.splineControlPoint=function(e,o,d,n,c,l){var p=Math.sqrt(Math.pow(d-e,2)+Math.pow(n-o,2));var i=Math.sqrt(Math.pow(c-d,2)+Math.pow(l-n,2));var h=this.tension*p/(p+i);var g=this.tension-h;var b=d+h*(e-c);var a=n+h*(o-l);var k=d-g*(e-c);var j=n-g*(o-l);return[b,a,k,j]};this.curvePoints=function(z,l){var a=[];var A=[];var g=this.tension;var h=this.tensionSegments;l=l?l:false;a=z.slice(0);if(l){a.unshift(z[z.length-1]);a.unshift(z[z.length-2]);a.unshift(z[z.length-1]);a.unshift(z[z.length-2]);a.push(z[0]);a.push(z[1])}else{a.unshift(z[1]);a.unshift(z[0]);a.push(z[z.length-2]);a.push(z[z.length-1])}var e,d,c,p,b,n,r,q,o,k,u;for(var w=2;w<(a.length-4);w+=2){for(var v=0;v<=h;v++){c=(a[w+2]-a[w-2])*g;p=(a[w+4]-a[w])*g;b=(a[w+3]-a[w-1])*g;n=(a[w+5]-a[w+1])*g;u=v/h;r=2*Math.pow(u,3)-3*Math.pow(u,2)+1;q=-(2*Math.pow(u,3))+3*Math.pow(u,2);o=Math.pow(u,3)-2*Math.pow(u,2)+u;k=Math.pow(u,3)-Math.pow(u,2);e=r*a[w]+q*a[w+2]+o*c+k*p;d=r*a[w+1]+q*a[w+3]+o*b+k*n;A.push(e);A.push(d)}}return A};this.hullControlPoints=function(g){var c=this;var g;var e=[];var h=0;var b,a;var d=function(r,p,o){var n=function(t,s){var v=s[0]-t[0];var u=s[1]-t[1];return Math.sqrt(v*v+u*u)};var q=n(r,p);var l=n(p,o);var i=c.tension*q/(q+l);var k=[((r[0]-o[0])*i)+p[0],((r[1]-o[1])*i)+p[1]];var j=[p[0]-((r[0]-o[0])*i),(p[1]-(r[1]-o[1])*i)];return[k,j]};for(b=0;b<g.length-2;b++){e.push.apply(e,d(g[b],g[b+1],g[b+2]))}e.push.apply(e,d(g[b],g[b+1],g[0]));e.push.apply(e,d(g[b+1],g[0],g[1]));return e};this.expandPolygon=function(r,y){var b=function(i){var d=Math.sqrt(i.x*i.x+i.y*i.y);return{x:i.x/d,y:i.y/d}};var u=function(d,i){return{x:d.x*i,y:d.y*i}};var n=function(i,d){return i.x*d.x+i.y*d.y};var c=function(d){return{x:d.y,y:-d.x}};var z=function(d){return{x:-d.y,y:d.x}};var x=function(H,G){var i=H[1].x-H[0].x;var F=G[0].x-G[1].x;var D=G[0].x-H[0].x;var d=H[1].y-H[0].y;var E=G[0].y-G[1].y;var p=G[0].y-H[0].y;var I=(F*p-E*D)/(d*F-i*E);return{x:H[0].x+I*(H[1].x-H[0].x),y:H[0].y+I*(H[1].y-H[0].y)}};var B=function(d){return n(c({x:d[1].x-d[0].x,y:d[1].y-d[0].y}),{x:d[2].x-d[1].x,y:d[2].y-d[1].y})>=0};var v=[];var h=B(r)?z:c;for(var w=0;w<r.length;++w){var l=r[(w>0)?w-1:r.length-1];var j=r[w];var g=r[(w<r.length-1)?w+1:0];var o={x:j[0]-l[0],y:j[1]-l[1]};var A={x:g[0]-j[0],y:g[1]-j[1]};var q=u(b(h(o)),y);var C=u(b(h(A)),y);var t={x:l[0]+q.x,y:l[1]+q.y};var k={x:j[0]+q.x,y:j[1]+q.y};var e={x:j[0]+C.x,y:j[1]+C.y};var s={x:g[0]+C.x,y:g[1]+C.y};var a=x([t,k],[e,s]);v.push([a.x,a.y])}return v};this.enlargePolygon=function(u,A,t){var g=function(i,e,d){return((d.x-i.x)*(e.y-i.y))-((e.x-i.x)*(d.y-i.y))};var B=function(p,s){var e=p.vrs[s];var d=p.vrs[(s+1)%p.vrs.length];var i=p.vrs[(s+p.vrs.length-1)%p.vrs.length];return(g(i,d,e)<0)?true:false};var j=function(s){var i=s.v2.x-s.v1.x;var d=s.v2.y-s.v1.y;var p=Math.sqrt(i*i+d*d);return{x:-d/p,y:i/p}};var r=function(d){var i=j(d);return{x:-i.x,y:-i.y}};var b=function(L){var p={vrs:L};var K=[];var F=(L.length>0)?L[0].x:undefined;var v=(L.length>0)?L[0].y:undefined;var s=F;var d=v;for(var G=0;G<p.vrs.length;G++){L[G].label=String(G);L[G].isReflex=B(p,G);var H={v1:L[G],v2:L[(G+1)%L.length],pol:p,index:G};H.outwardNormal=r(H);H.inwardNormal=j(H);K.push(H);var J=L[G].x;var I=L[G].y;F=Math.min(J,F);v=Math.min(I,v);s=Math.max(J,s);d=Math.max(I,d)}p.edges=K;p.minX=F;p.minY=v;p.maxX=s;p.maxY=d;p.closed=true;return p};var n=function(p,i,d){return{v1:{x:p.v1.x+i,y:p.v1.y+d},v2:{x:p.v2.x+i,y:p.v2.y+d}}};var E=function(p,e){var s=(e.v2.y-e.v1.y)*(p.v2.x-p.v1.x)-(e.v2.x-e.v1.x)*(p.v2.y-p.v1.y);if(s==0){return null}var i=((e.v2.x-e.v1.x)*(p.v1.y-e.v1.y)-(e.v2.y-e.v1.y)*(p.v1.x-e.v1.x))/s;var d=((p.v2.x-p.v1.x)*(p.v1.y-e.v1.y)-(p.v2.y-p.v1.y)*(p.v1.x-e.v1.x))/s;if(i<0||d<0||i>1||d>1){return null}return{x:p.v1.x+i*(p.v2.x-p.v1.x),y:p.v1.y+i*(p.v2.y-p.v1.y)}};var c=function(N,G,d,M,H,s){var L=Math.PI*2;var J=Math.atan2(M.y-G.y,M.x-G.x);var F=Math.atan2(H.y-G.y,H.x-G.x);if(J<0){J+=L}if(F<0){F+=L}var I=((J>F)?(J-F):(J+L-F));var e=((s)?-I:L-I)/t;N.push(M);for(var p=1;p<t;++p){var I=J+e*p;var K={x:G.x+Math.cos(I)*d,y:G.y+Math.sin(I)*d};N.push(K)}N.push(H)};var w=[];var x=[];for(var y=0;y<u.length;y++){x.push({x:u[y][0],y:u[y][1]})}var k=b(x);for(var y=0;y<k.edges.length;y++){var z=k.edges[y];var q=z.outwardNormal.x*A;var l=z.outwardNormal.y*A;w.push(n(z,q,l))}x=[];for(var y=0;y<w.length;y++){var h=w[y];var D=w[(y+w.length-1)%w.length];var o=E(D,h);if(o){x.push(o)}else{var C=k.edges[y].v1;c(x,C,A,D.v2,h.v1,false)}}var a=[];for(var y=0;y<x.length;y++){a.push([x[y].x,x[y].y])}return a};this.sample=function(c,h){if(c){if(!h||h<=0){h=c.length}var e,b;var g=c.slice(0);var d=c.length;var a=d-h;while(d-->a){b=Math.floor((d+1)*this.random());e=g[b];g[b]=g[d];g[d]=e}return g.slice(a)}else{return[]}};this.seq=function(h,c,g,a){var d=[];if(h!=null&&c!=null&&(a||g)){var b=c<h;if(c<h){var e=h;h=c;c=e}if(a){a=Math.abs(a);g=(c-h)/(a-1)}else{g=Math.abs(g)}if(g){while(c>=h){d.push(h);h+=g}}if(a){d[a-1]=c}else{if(d[d.length-1]<c){d.push(c)}}}return b?d.reverse():d};this.runif=function(g,e,b){var c=[];if(e!=null&&b!=null){for(var d=0;d<g;d++){c.push(this.randomBetween(e,b))}}else{for(var d=0;d<g;d++){c.push(this.random())}}return c};this.rnorm=function(j,b,d){var h=this;var c=[];if(b==null){b=0}if(d==null){d=1}var g=function(){var k,i;var a=2;while(a>1){k=h.random()*2-1;i=h.random()*2-1;a=k*k+i*i}return b+d*k*Math.sqrt(-2*Math.log(a)/a)};for(var e=0;e<j;e++){c.push(g())}return c};this.percentile2=function(a,g){if(a.length===0){return 0}if(typeof g!=="number"){throw new TypeError("p must be a number")}if(g<=0){return a[0]}if(g>=1){return a[a.length-1]}var c=a.length*g;var b=Math.floor(c);var d=b+1;var e=c%1;if(d>=a.length){return a[b]}else{return a[b]*(1-e)+a[d]*e}};this.percentRank=function(a,c){if(typeof c!=="number"){throw new TypeError("v must be a number")}for(var d=0,b=a.length;d<b;d++){if(c<=a[d]){while(d<b&&c===a[d]){d++}if(d===0){return 0}if(c!==a[d-1]){d+=(c-a[d-1])/(a[d]-a[d-1])}return d/b}}return 1};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.percentile3=function(b){if(b.length===0){return b}var e=this.min(b);var a=this.max(b);var c=a-e;var g=[];for(var d=0;d<b.length;d++){var h=b[d]-e;g.push(h/c)}return g};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.rank2=function(b){var d=b.slice().sort(function(h,g){return h-g});var e=b.slice().map(function(g){return d.indexOf(g)+1});var c={};e.map(function(g){c[g]=c[g]?c[g]++:1});var a=e.map(function(g){return g/c[g]});return a};this.min=function(b,a,g){if(this.isArray(b)){var e=Number.POSITIVE_INFINITY;if(this.isArray(b[0])){for(var d=0;d<b.length;d++){for(var c=0;c<b[d].length;c++){if(this.isNumber(b[d][c],true)){e=Math.min(e,b[d][c])}}}}else{b=this.cleanArray(b,a,g);for(var d=0;d<b.length;d++){if(this.isNumber(b[d],true)){e=Math.min(e,b[d])}}}return e}else{return this.Min(b,a)}};this.max=function(c,b,g){if(this.isArray(c)){var a=Number.NEGATIVE_INFINITY;if(this.isArray(c[0])){for(var e=0;e<c.length;e++){for(var d=0;d<c[e].length;d++){if(this.isNumber(c[e][d],true)){a=Math.max(a,c[e][d])}}}}else{c=this.cleanArray(c,b,g);for(var e=0;e<c.length;e++){if(this.isNumber(c[e],true)){a=Math.max(a,c[e])}}}return a}else{return this.Max(c,b)}};this.sum=function(b,a,h,e,g){b=this.cleanArray(b,a,h);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{if(g){if(b[c]<0){d+=b[c]}}else{d+=b[c]}}}return d};this.sumSquared=function(b,a,g,e){b=this.cleanArray(b,a,g);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]*b[c]}}else{d+=b[c]*b[c]}}return d};this.sumSquaredError=function(b,a,h){b=this.cleanArray(b,a,h);var c=this.mean(b);var g=0;for(var e=0;e<b.length;e++){var d=b[e]-c;g+=d*d}return g};this.mean=function(b,a,e){b=this.cleanArray(b,a,e);var c=0;var g=0;for(var d=0;d<b.length;d++){if(!this.isNaN(b[d])){c+=Number(b[d]);g++}}if(g>0){c/=g}return c};this.range=function(c,b,g){c=this.cleanArray(c,b,g);var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);a=Math.max(c[d],a)}return e==a&&e==0?[0,0.01]:e==a?[Number(e),Number(a)]:[Number(e),Number(a)]};this.median=function(b,a,g){b=this.cleanArray(b,a,g);var e=[];var d=[];var h=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);h++}if(h>0){e[1]=h;d.sort(function(j,i){return j-i});if(h%2){e[0]=d[parseInt(h/2)]}else{e[0]=(d[parseInt((h-1)/2)]+d[h/2])/2}}return e};this.Abs=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(Math.abs(b[c]))}return d};this.square=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(b[c]*b[c])}return d};this.subtractArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]-e)}return b};this.addArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]+e)}return b};this.replaceArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(e)}return b};this.nextSeed=function(a){if(this.randomMethod=="numericalRecipes"){return(a*9301+49297)%233280}else{a=((a+2127912214)+(a<<12))&4294967295;a=((a^3345072700)^(a>>>19))&4294967295;a=((a+374761393)+(a<<5))&4294967295;a=((a+3550635116)^(a<<9))&4294967295;a=((a+4251993797)+(a<<3))&4294967295;a=((a^3042594569)^(a>>>16))&4294967295;return a}};this.random=function(a){if(this.pseudoRandom){this.randomSeed=this.nextSeed(a||this.randomSeed);return this.randomMethod=="numericalRecipes"?this.randomSeed/233280:(this.randomSeed&268435455)/268435456;return}else{return Math.random()}};this.randomBetween=function(c,a,b){return(this.random(b)*(a-c+1))+c};this.randomInt=function(a){return parseInt(this.random(a))};this.randomIntBetween=function(c,a,b){return Math.floor(this.random(b)*(a-c+1))+c};this.sumarizeErrorData=function(b,a,c){if(this.errorBarsType=="standardErrorMean"){return this.meanStandardErrorN(b,a,c)}else{if(this.errorBarsType=="confidenceInterval95"){return this.mean95ConfidenceIntervalN(b,a,c)}else{return this.meanStandardDeviationN(b,a,c)}}};this.meanStandardErrorN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1])/Math.sqrt(c[2]),c[2]]};this.mean95ConfidenceIntervalN=function(b,a,d){var c=this.meanStandardErrorN(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],c[1]*1.96,c[2]]};this.meanStandardDeviationN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1]),c[2]]};this.fivenum=function(a){a.sort(function(i,d){return i-d});var h=a.length;var b=Math.floor((h+3)/2)/2;var g=[1,b,(h+1)/2,h+1-b,h];var e=[];for(var c=0;c<g.length;c++){e.push((a[Math.floor(g[c])-1]+a[Math.ceil(g[c])-1])*0.5)}return e};this.boxplot=function(a,d,c){if(a.length>0){a=this.cleanArray(a,d,c);var e=[];var n=[];var b=this.fivenum(a);var h=this.boxplotHingeFunction=="summary"?this.quantile(a,[0.25,0.75]):[b[1],b[3]];var w=b[0];var s=h[0];var q=b[2];var u=b[2];var p=h[1];var v=b[4];var l=p-s;var r=s-this.boxplotCoef*l;var o=p+this.boxplotCoef*l;var k=(b[3]-b[1])/Math.sqrt(a.length);for(var t=0;t<a.length;t++){if(a[t]<r||a[t]>o){e.push(a[t])}else{n.push(a[t])}}if(e.length>0){var g=this.range(n);w=g[0];v=g[1]}var j=[u-1.58*k,u+1.58*k];return[u,s,q,p,w,v,e,a.length,j]}return[Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN]};this.quantileBin=function(b,a){if(a<b[0]){return 0}else{if(a>=b[0]&&a<b[1]){return 1}else{if(a>=b[1]&&a<b[2]){return 2}else{if(a>=b[2]){return 3}}}}};this.quantile=function(b,c){b=this.cleanArray(b);b=b.slice().sort(function(g,e){return g-e});var d=b.length-1;var a=c||[0.25,0.5,0.75];return a.map(function(k){if(k===0){return b[0]}else{if(k===1){return b[d]}else{var g=1+k*d;var j=Math.floor(g);var i=g-j;var e=b[j-1];return i===0?e:e+i*(b[j]-e)}}})};this.iqr=function(a){var b=this.quantile(a,[0.25,0.75]);return b[1]-b[0]};this.variance=function(e,g,c,a){e=this.cleanArray(e,g,c);var b=e.length;if(b<1){return a?[Number.NaN,Number.NaN,Number.NaN]:Number.NaN}else{if(b==1){return a?[e[0],0,1]:0}else{var k=this.mean(e);var j=0;var d=b;while(--d>=0){if(!this.isNaN(e[d])){var h=e[d]-k;j+=h*h}}if(a){return this.standardDeviationType=="unbiased"?[k,j/(b-1),b]:[k,j/b,b]}else{return this.standardDeviationType=="unbiased"?j/(b-1):j/b}}}};this.deviation=function(b,a,g){b=this.cleanArray(b,a,g);var h=b.length;if(h<1){return[Number.NaN]}else{if(h==1){return[0]}else{var c=this.mean(b);var d=[];for(var e=0;e<h;e++){if(!this.isNaN(b[e])){d[e]=b[e]-c}else{d[e]=NaN}}return d}}};this.standardDeviation=function(b,a,d){var c=this.variance(b,a,d);if(this.isNaN(c)){return c}return Math.sqrt(c)};this.standardError=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return c[1]}return Math.sqrt(c[1])/Math.sqrt(c[2])};this.meanSquaredError=function(b,a,c){b=this.cleanArray(b,a,c);return this.sumSquaredError(this.sumSquaredError(b,a,c))/b.length};this.confidenceInterval95=function(c,b,d){var a=this.standardError(c,b,d);if(this.isNaN(a)){return a}return a*1.96};this.covariance=function(j,h,e,c){var g=this.cleanArrays(j,h,e,c);j=g[0];h=g[1];var o=0;var a=[];var b=0;var l=this.mean(j);var k=this.mean(h);for(var d=0;d<j.length;d++){a[d]=(j[d]-l)*(h[d]-k);o+=a[d];b++}if(b>0){return o/(this.standardDeviationType=="unbiased"?b-1:b)}else{return NaN}};this.correlation=function(c,b,a,e,d){if(d&&d=="spearman"){return this.correlationSpearman(c,b,a,e)}else{return this.correlationPearson(c,b,a,e)}};this.correlationSpearman=function(p,o,j,g){var l=this.cleanArrays(p,o,j,g);p=l[0];o=l[1];var a=p.length;var b=0;var e=this.rank2(p);var c=this.rank2(o);for(var h=0;h<p.length;h++){var k=e[h]-c[h];b+=k*k}return 1-(6*b/(a*(a*a-1)))};this.correlationPearson=function(c,b,a,d){return this.covariance(c,b,a,d)/this.standardDeviation(c,a,d)/this.standardDeviation(b,a,d)};this.regression=function(l,k,h,b,c,n){var g=[];var j=this.cleanArrays(l,k,h,b);l=j[0];k=j[1];for(var e=0;e<l.length;e++){if(!this.isNaN(l[e])&&!this.isNaN(k[e])){g.push([l[e],k[e]])}}var a=this.regressionType+"Regression";var d=this[a](g);return[d.params[0],d.params[1],d.r2,d.confidence]};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(g){var e=this.standardDeviationType;this.standardDeviationType="biased";for(var c=0;c<g.length;c++){var a=this.meanStandardDeviationN(g[c]);for(var b=0;b<g[c].length;b++){g[c][b]=(g[c][b]-a[0])/a[1]}}this.standardDeviationType=e;return g};this.coefficientDetermination=function(j,g){var c=0;for(var b=0;b<j.length;b++){c+=j[b][1]}var k=c/j.length;var e=0;for(var b=0;b<j.length;b++){var h=j[b][1]-k;e+=h*h}var d=0;for(var b=0;b<j.length;b++){var a=j[b][1]-g[b][1];d+=a*a}return 1-(d/e)};this.gaussianElimination=function(p,b){var q=p;var a=p.length-1;var c=[b];for(var h=0;h<a;h++){var l=h;for(var e=h+1;e<a;e++){if(Math.abs(q[h][e])>Math.abs(q[h][l])){l=e}}for(var d=h;d<a+1;d++){var g=q[d][h];q[d][h]=q[d][l];q[d][l]=g}for(var e=h+1;e<a;e++){for(var d=a;d>=h;d--){q[d][e]-=(q[d][h]*q[h][e])/q[h][h]}}}for(var e=a-1;e>=0;e--){var o=0;for(var d=e+1;d<a;d++){o+=q[d][e]*c[d]}c[e]=(q[a][e]-o)/q[e][e]}return c};this.linearRegression=function(x){var c=[0,0,0,0,0];var t=0;var r=Number.NEGATIVE_INFINITY;var o=Number.POSITIVE_INFINITY;for(var l=0;l<x.length;l++){t++;r=Math.max(r,x[l][0]);o=Math.min(o,x[l][0]);c[0]+=x[l][0];c[1]+=x[l][1];c[2]+=x[l][0]*x[l][0];c[3]+=x[l][0]*x[l][1];c[4]+=x[l][1]*x[l][1]}var j=((t*c[2])-(c[0]*c[0]));var a=((t*c[3])-(c[0]*c[1]));var b=j===0?0:a/j;var v=(c[1]/t)-((b*c[0])/t);var q=[];for(var l=0;l<x.length;l++){q[l]=[x[l][0],(x[l][0]*b)+v]}var e=[];var k=0;var w=0;var s=c[0]/t;var h=Math.max(l-2,1);var d=this.seq(o,r,(r-o)/10);var g=this.tinv(1-this.confidenceLevel,h,true);for(var p=0;p<l;p++){k+=Math.pow(x[p][1]-q[p][1],2);w+=Math.pow(x[p][0]-s,2)}k=Math.sqrt(k/h);for(var p=0;p<d.length;p++){var y=-g*k*Math.sqrt((1/l)+Math.pow(d[p]-s,2)/w);var u=b*d[p]+v;e.push([d[p],u+y,u-y,y])}return{predict:q,params:[b,v],r2:this.coefficientDetermination(x,q),confidence:e,string:v===0?"y = "+b+"x":"y = "+b+"x + "+v}};this.exponentialRegression=function(h){var g=[0,0,0,0,0,0];for(var j=0;j<h.length;j++){g[0]+=h[j][0];g[1]+=h[j][1];g[2]+=h[j][0]*h[j][0]*h[j][1];g[3]+=h[j][1]*Math.log(h[j][1]);g[4]+=h[j][0]*h[j][1]*Math.log(h[j][1]);g[5]+=h[j][0]*h[j][1]}var i=((g[1]*g[2])-(g[5]*g[5]));var d=Math.exp(((g[2]*g[3])-(g[5]*g[4]))/i);var c=((g[1]*g[4])-(g[5]*g[3]))/i;var e=[];for(var j=0;j<h.length;j++){e[j]=[h[j][0],d*Math.exp(c*h[j][0])]}return{predict:e,params:[d,c],r2:this.coefficientDetermination(h,e),confidence:false,string:"y = "+d+"e^("+c+"x)"}};this.logarithmicRegression=function(i){var h=[0,0,0,0];var d=i.length;for(var j=0;j<d;j++){h[0]+=Math.log(i[j][0]);h[1]+=i[j][1]*Math.log(i[j][0]);h[2]+=i[j][1];h[3]+=Math.pow(Math.log(i[j][0]),2)}const c=((d*h[1])-(h[2]*h[0]))/((d*h[3])-(h[0]*h[0]));const e=(h[2]-(c*h[0]))/d;var g=[];for(var j=0;j<i.length;j++){g[j]=[i[j][0],e+(c*Math.log(i[j][0]))]}return{predict:g,params:[e,c],r2:this.coefficientDetermination(i,g),confidence:false,string:"y = "+e+" + "+c+"ln(x)"}};this.powerRegression=function(i){var h=[0,0,0,0,0];var d=i.length;for(var j=0;j<d;j++){h[0]+=Math.log(i[j][0]);h[1]+=Math.log(i[j][1])*Math.log(i[j][0]);h[2]+=Math.log(i[j][1]);h[3]+=Math.pow(Math.log(i[j][0]),2)}var c=((d*h[1])-(h[0]*h[2]))/((d*h[3])-Math.pow(h[0],2));var e=Math.exp(((h[2]-(c*h[0]))/d));var g=[];for(var j=0;j<i.length;j++){g[j]=[i[j][0],e*Math.pow(i[j][0],c)]}return{predict:g,params:[e,c],r2:this.coefficientDetermination(i,g),confidence:false,string:"y = "+e+"x^"+c}};this.polynomialRegression=function(q){this.regressionOrder=2;var h=[];var u=[];var x=0;var w=0;var t=q.length;var o=this.regressionOrder+1;for(var r=0;r<o;r++){for(var g=0;g<t;g++){x+=Math.pow(q[g][0],r)*q[g][1]}h.push(x);x=0;var v=[];for(var p=0;p<o;p++){for(var g=0;g<t;g++){w+=Math.pow(q[g][0],(r+p))}v.push(w);w=0}u.push(v)}u.push(h);var e=this.gaussianElimination(u,o);var y=[];for(var d=0;d<q.length;d++){y[d]=[q[d][0],e[0]+(e[1]*Math.pow(q[d][0],e[2]))]}var s="y = ";for(var r=e.length-1;r>=0;r--){if(r>1){s+=e[r]+"x^"+r+" + "}else{if(r===1){s+=e[r]+"x + "}else{s+=e[r]}}}return{predict:y,params:e.reverse(),r2:this.coefficientDetermination(q,y),confidence:false,string:s}};this.checkLoessCache=function(b){var a=this.meta;if(!a.vals.loess){a.vals.loess={}}var c=this.cloneObject(b);c.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);c=c.join(":");return a.vals.loess.hasOwnProperty(c)?a.vals.loess[c]:false};this.loess=function(aa,J,S){var o=this.checkLoessCache(S);if(o){return o}var H=this;var Y=function(d){var k=Math.abs(d);var i=1/(1+k/2);var j=i*Math.exp(-k*k-1.26551223+i*(1.00002368+i*(0.37409196+i*(0.09678418+i*(-0.18628806+i*(0.27886807+i*(-1.13520398+i*(1.48851587+i*(-0.82215223+i*0.17087277)))))))));return d>=0?j:2-j};var n=function(d){if(d>=2){return -100}if(d<=0){return 100}var ac=(d<1)?d:2-d;var k=Math.sqrt(-2*Math.log(ac/2));var y=-0.70711*((2.30753+k*0.27061)/(1+k*(0.99229+k*0.04481))-k);for(var i=0;i<2;i++){var w=Y(y)-ac;y+=w/(1.1283791670955126*Math.exp(-(y*y))-y*w)}return(d<1)?y:-y};var Z=function(i,j,d){var k=Math.sqrt(j);return i-k*Math.sqrt(2)*n(2*d)};var Q=function(d){var y=Math.ceil(0.1*d.length);var k=H.cloneObject(d);k=k.sort(function(i,ac){return i-ac});for(var j=0;j<y;j++){k.shift();k.pop()}var w=H.standardDeviation(k);return function(i){return i.map(function(ac){return ac/w})}};var a=function(j,d){var w=[];for(var k=0;k<j.length;k++){if(H.isArray(j[k])&&H.isArray(d[k])){w.push(a(j[k],d[k]))}else{w.push(j[k]*d[k])}}return w};var q=function(j,ad){var w=function(d,ae,ag){if(ag>1){for(var af=ae;af<j.length;af++){w(a(d,j[af]),af,ag-1)}}else{ac.push(d)}};var ac=[];var y=Array(j[0].length).fill(1);for(var k=0;k<=ad;k++){w(y,0,k+1)}return ac};var p=function(j,i){if(j.length<2){return Math.abs(j[0]-i[0])}else{return Math.sqrt(j.reduce(function(d,k,w){return d+Math.pow(k-i[w],2)},0))}};var R=function(i,d){return i.map(function(j){return d.map(function(k){return p(j,k)})})};var s=function(k,j,i){return k<j?Math.pow(1-Math.pow(k/j,i),i):0};var t=function(k,j,i){return k.map(function(ac){var ae=H.rank(ac);var ad=[];for(var y=0;y<ae.length;y++){ad.push([ac[ae[y]],j[ae[y]]])}var ag=H.sum(j)*i;var d=0;var w=ad.findIndex(function(ah){d+=ah[1];return d>=ag});var af=i>1?ad[ad.length-1][0]*i:ad[w][0];return a(ac.map(function(ah){return s(ah,af,3)}),j)})};var u=function(af,ae){var ad=af.length;var k=af[0].length;var w=ae.length;var ag=ae[0].length;var j=new Array(ad);for(var d=0;d<ad;d++){j[d]=new Array(ag);for(var ac=0;ac<ag;ac++){j[d][ac]=0;for(var y=0;y<k;y++){j[d][ac]+=af[d][y]*ae[y][ac]}}}return j};var h=function(w,k){var d=new Array(w.length);for(var ac=0;ac<d.length;ac++){d[ac]=new Array(w[ac].length);for(var y=0;y<d[ac].length;y++){d[ac][y]=w[ac][y]-k[ac][y]}}return d};var x=function(d){var j=[];for(var k=0;k<d.length;k++){j.push(d[k][0])}return j};var K=function(j,k,w){var ad=a(w,k);var ae=H.transpose(j.map(function(ag){return a(w,ag)}));var ac=u(j,ae);var d=u(j,H.transpose([ad]));var y=u(H.numeric("inv",ac),d);var i=u(H.transpose(y),j);var af=h([k],i);return{beta:y,yhat:i,residuals:af}};var e=function(d){b=[];V=[];P=a(d,M);var i=H.transpose(O);i.forEach(function(k,j){var w=K(ab,I,P[j]);b.push(x(u([k],w.beta)));V.push(w.residuals);var y=H.median(H.Abs(w.residuals[0]));d[j]=w.residuals.map(function(ac){return s(ac,6*y[0],2)})})};this.loessDegree=parseInt(this.loessDegree);if(this.loessDegree<0||this.loessDegree>2){this.loessDegree=2}this.loessBandWidth=Number(this.loessBandwidth);if(this.loessBandwidth<0||this.loessBandwidth>1){this.loessBandwidth=0.8}this.loessSpan=Number(this.loessSpan);if(this.loessSpan<0||this.loessSpan>1){this.loessSpan=0.8}var B=[aa[0]];var v=[this.loessSteps];var I=aa[1];if(aa[2]){B.push(aa[2]);v.push(this.loessSteps)}if(!J){J=Array(aa[0].length).fill(1)}var ab=q(B,this.loessDegree);var c=B.map(Q);var N=B.map(function(i,d){return c[d](i)});var l=this.transposeMatrix(N);var G=[];var L=[];B.forEach(function(ae,af){var d=ae.sort(function(ag,i){return ag-i});var j=d[0];var y=d[d.length-1];var k=(y-j)/(v[af]-1);L.push([]);for(var w=0;w<v[af];w++){L[af].push(j+w*k)}var ac=1;var ad=1;for(var w=af-1;w>=0;w--){ac*=v[w]}for(var w=af+1;w<B.length;w++){ad*=v[w]}G.push([]);for(var w=0;w<ac;w++){G[af]=G[af].concat(L[af].reduce(function(i,ag){return i.concat(Array(ad).fill(ag))},[]))}});var C=this.cloneObject(G);var X=G[0].length;var O=q(C,this.loessDegree);var W=C.map(function(i,d){return c[d](i)});var g=R(this.transpose(W),l);var M=t(g,J,this.loessBandwidth);var b;var V;var P;var E=Array(X).fill(Array(aa[0].length).fill(1));for(var A=0;A<this.loessIterations;A++){e(E)}var z={fitted:x(b),residuals:V,weights:P};(function(){var i=Z(0,1,1-(1-H.loessSpan)/2);var d=P.map(function(ac,k){var w=H.sum(ac);var j=u([ac],H.transpose([ac]));var y=Math.sqrt(u([H.square(V[k][0])],H.transpose([ac]))/(w-j[0]/w));return y*i});Object.assign(z,{halfwidth:d})})();var D=[];if(aa[2]){for(var U=0;U<this.loessSurfaceSteps;U++){var F=[];for(var T=0;T<this.loessSurfaceSteps;T++){F.push(z.fitted[T*this.loessSurfaceSteps+U])}D.push(F)}}if(!this.meta.vals.loess){this.meta.vals.loess={}}var r=this.cloneObject(S);r.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);r=r.join(":");if(aa[2]){this.meta.vals.loess[r]={x:L[0],y:L[1],z:D,c:z.halfwidth}}else{this.meta.vals.loess[r]={x:G[0],y:z.fitted,c:z.halfwidth}}return this.meta.vals.loess[r]};this.errorEllipse=function(a,c,b){if(b){return this.errorEllipse3D(a,c,b)}else{return this.errorEllipse2D(a,c)}};this.errorEllipse2D=function(l,h){var j=this.variance(l,false,false,true);var i=this.variance(h,false,false,true);var k=this.covariance(l,h);var o=[[j[1],k],[k,i[1]]];var p=this.numeric("eig",o);var n=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var g=p.lambda.x[0]>p.lambda.x[1]?0:1;var e=p.lambda.x[0]<p.lambda.x[1]?0:1;var b=j[1]>i[1]?Math.sqrt(p.lambda.x[g])*n:Math.sqrt(p.lambda.x[e])*n;var a=i[1]>j[1]?Math.sqrt(p.lambda.x[g])*n:Math.sqrt(p.lambda.x[e])*n;var c=Math.atan2(p.E.x[g][1],p.E.x[g][0]);if(c<0){c+=Math.PI/2}var d={rx:b,ry:a,cx:j[0],cy:i[0],rot:c};return d};this.errorEllipse3D=function(o,n,k){var r=this.variance(o,false,false,true);var q=this.variance(n,false,false,true);var p=this.variance(k,false,false,true);var c=this.covariance(o,n);var b=this.covariance(o,k);var j=this.covariance(n,k);var v=[[r[1],c,b],[c,q[1],j],[b,j,p[1]]];var l=this.numeric("eig",v);var a=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var g=this.rank(l.lambda.x);var u=g[2];var s=g[1];var t=g[0];var i=Math.sqrt(l.lambda.x[u])*a;var e=Math.sqrt(l.lambda.x[s])*a;var d=Math.sqrt(l.lambda.x[t])*a;var B=Math.atan2(l.E.x[2][u]*-1,l.E.x[1][u]*-1);var A=Math.atan2(l.E.x[2][u]*-1,l.E.x[0][u]*-1);var w=Math.atan2(l.E.x[1][u]*-1,l.E.x[0][u]*-1);if(B<0){}if(A<0){A+=Math.PI/2}if(w<0){}var h={rx:[i],ry:[e],rz:[d],cx:r[0],cy:q[0],cz:p[0],rot:[B,A,w]};return h};this.cdfNormal=function(a,c,b){var a=(a-c)/b;var g=1/(1+0.2315419*Math.abs(a));var h=0.3989423*Math.exp(-a*a/2);var e=h*g*(0.3193815+g*(-0.3565638+g*(1.781478+g*(-1.821256+g*1.330274))));if(a>0){e=1-e}return e};this.cdf=function(b){var a=this.cloneObject(b);a=a.sort(function(h,g){return h-g});var e=[];var d=b.length;for(var c=0;c<d;c++){e.push((c+1)/d)}return{x:a,y:e}};this.qq=function(g){var o=this.mean(g);var b=this.standardDeviation(g);var l;var k=this.cloneObject(g);switch(this.qqDistribution){case"normal":l=this.rnorm(this.qqSamples,o,b);case"uniform":l=this.runif(this.qqSamples)}l=l.sort(function(p,i){return p-i});k=k.sort(function(p,i){return p-i});var e=l.length-1;var a=k.length-1;var n=[];var h=[];for(var d=0;d<this.qqPoints;d++){var j=~~(d*e/this.qqPoints);var c=~~(d*a/this.qqPoints);n.push(l[j]);h.push(k[c])}return{x:n,y:this.percentile3(h)}};this.uniformKernel=function(a){return(a<=1&&a>=-1)?0.5:0},this.triangularKernel=function(a){return(a<=1&&a>=-1)?1-Math.abs(a):0},this.epanechnikovKernel=function(a){return(a<=1&&a>=-1)?0.75*(1-a*a):0},this.quarticKernel=function(a){if(a<=1&&a>=-1){var b=1-a*a;return(15/16)*b*b}else{return 0}},this.triweightKernel=function(a){if(a<=1&&a>=-1){var b=1-a*a;return(35/32)*b*b*b}else{return 0}},this.gaussianKernel=function(a){return 1/Math.sqrt(2*Math.PI)*Math.exp(-0.5*a*a)},this.cosineKernel=function(a){return(a<=1&&a>=-1)?Math.PI/4*Math.cos(Math.PI/2*a):0};this.silvermanRule=function(c){var a=Math.sqrt(this.variance(c));var b=4*Math.pow(a,5);var d=3*c.length;return Math.pow(b/d,0.2)};this.nrd0Rule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 0.9*b*c};this.nrdRule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 1.6*b*c};this.getBandwidthEstimate=function(a){return this[this.bandwidthRule+"Rule"](a)};this.kernelDensityEstimator=function(a,c){var b=this[this.densityKernel+"Kernel"];return function(e,d){return a.map(function(g){var h=-1;var k=0;var j=e.length;while(++h<j){k+=b((g-e[h])/c)}return[g,k/c/j]})}};this.density=function(C,D){var h=this.range(C);var u=h[0];var A=h[1];var s=this.getBandwidthEstimate(C);var t=(u-this.bandwidthCut*s);var d=(A+this.bandwidthCut*s);var w=(d-t)/256;var o=[];for(var p=t;p<d;p+=w){o.push(p)}var B=this.kernelDensityEstimator(o,s);var k=B(C);var g=[];var e=[];var r=0;var c=Infinity;var b=0;var a=this;for(var z=0;z<k.length;z++){if(isNaN(k[z][1])){k[z][1]=0}}for(var z=0;z<k.length;z++){if(k[z][0]>u&&k[z][0]<A){if(g.length==0){t=z;g.push(k[z-1][0]);e.push(k[z-1][1]);b+=k[z-1][1];r=Math.max(r,k[z-1][1]);c=Math.min(c,k[z-1][1])}g.push(k[z][0]);e.push(k[z][1]);b+=k[z][1];r=Math.max(r,k[z][1]);c=Math.min(c,k[z][1])}else{if(k[z][0]>=A){d=z;g.push(k[z][0]);e.push(k[z][1]);b+=k[z][1];r=Math.max(r,k[z][1]);c=Math.min(c,k[z][1]);break}}}var n=this.boxplot(g);var l=this.boxplot(e);var q=[];for(var z=0;z<6;z++){for(var y=0;y<g.length;y++){if(g[y]>=n[z]){q.push(e[y]);break}}}return{range:h,trim:[t,Math.max(t,d)],xy:k,bw:s,quantilesX:n,quantilesY:l,indecesY:q,sumY:b,maxY:r,minY:c,minData:u,maxData:A,globalMaxY:r,histogram:this.hist(C,D),name:D,n:C.length}};this.freedmanDiaconis=function(b,a,c){if(b&&b.length>1){b=this.cleanArray(b,a,c);var d=this.iqr(b);return d==0?1:Math.ceil(2*d*Math.pow(b.length,-1/3))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.sturges=function(b,a,d){if(b&&b.length>1){b=this.cleanArray(b,a,d);var c=this.range(b);return Math.ceil(Math.log(b.length)/Math.LN2)+1}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.scott=function(b,a,e){if(b&&b.length>1){b=this.cleanArray(b,a,e);var c=this.range(b);var d=Math.sqrt(this.vriance(b));return Math.ceil((c[1]-c[0])/(3.5*d*Math.pow(b.length,-1/3)))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.histBin=function(e,d,g,c){var a=Math.floor((e-d)/g);if(e==c[a]&&a>0){a--}return a};this.hist2D=function(k,a,o){if(this.isArray(k)&&this.isArray(k[0])&&k.length>1){var l={count:[],idxs:[],maxY:0};var e=[];for(var h=0;h<k.length;h++){e=e.concat(k[h])}var n=this.hist(e,a);for(var h=0;h<k.length;h++){l.count[h]=[];l.idxs[h]=[];for(var d=0;d<n.count.length;d++){l.count[h][d]=0;l.idxs[h][d]=[]}var c=o||n.breaks[0];for(var d=0;d<k[h].length;d++){var b=k[h][d];var p=this.histBin(b,c,n.size,n.breaks);l.count[h][p]++;l.idxs[h][p].push(d);l.maxY=Math.max(l.maxY,l.count[h][p])}}n.global=l;return n}else{if(this.isArray(k)&&this.isArray(k[0])&&k.length==1){return this.hist(k[0],a)}else{return this.hist(k,a)}}};this.hist=function(j,c){var b=this.range(j);var g=b[0];var o=b[0]==b[1]?b[0]+1:b[1];var d=this[this.histogramSizeEstimator](j);var t=this.rPretty(g,o,Math.max(this.histogramBins||8,d));var p=this.approx(t[1]-t[0]);var n=this.approx(p/2);var e=[];var q=[];var r=[];var k=[];if(t[0]>g){t.unshift(t[0]-p)}if(t[t.length-1]<o){t.push(t[t.length-1]+p)}var l=t.length;for(var h=0;h<l-1;h++){e[h]=0;r[h]=[];q[h]=this.approx(t[h]+n)}for(var h=0;h<j.length;h++){var s=this.histBin(j[h],t[0],p,t);e[s]++;r[s].push(h)}var a=-Infinity;for(var h=0;h<e.length;h++){a=Math.max(a,e[h]);k.push("Bin"+(h+1)+" ("+t[h]+" - "+t[h+1]+")")}return{estimator:d,breaks:t,count:e,mids:q,idxs:r,size:p,half:n,maxY:a,name:c,labels:k}};this.getHistogramBin=function(c,a){var d=a*Math.floor(c/a);return parseFloat(d.toFixed(this.getAxisDecimals(a)))};this.approx=function(g){var e=g;var d=g.toString();var j=d.indexOf("99999");var h=d.indexOf("00000");var i=d.indexOf(".");var b=j>=0&&i<j?j:h>=0?h:null;if(b!=null){e=d.substring(0,b);f=Math.pow(10,e.length-(e.indexOf(".")+1));return Number(Math.round(Number(d)*f)/f)}else{return Number(d)}};this.bezierCalculatePoints=function(h,e){var b=h[0][0];var a=h[0][1];var d=h[1][0];var c=h[1][1];var i=b+(d-b)*e;var g=a+(c-a)*e;return[i,g]};this.deCasteljau=function(e,d){if(d===1){return e[e.length-1]}if(d===0){return e[0]}if(e.length==1){return e[0]}var b=[];for(var c=1,a=e.length;c<a;c++){b.push(this.bezierCalculatePoints([e[c-1],e[c]],d))}return this.deCasteljau(b,d)};this.divideBezierCurve=function(g,e,c,h){c=c||[];h=h||[];c.push(g[0]);h.push(g[g.length-1]);if(g.length===1){return[c,h]}var b=[];for(var d=1,a=g.length;d<a;d++){b.push(this.bezierCalculatePoints([g[d-1],g[d]],e))}return this.divideBezierCurve(b,e,c,h)};this.centroid=function(a){var c=[];if(!a||a.length<2){return[0,0]}else{if(a.length<3||a.length%2){return[a[0],a[1]]}else{while(a.length>1){c.push([a.shift(),a.shift()])}}}var b=c.reduce(function(d,e){return[d[0]+e[0]/c.length,d[1]+e[1]/c.length]},[0,0]);return b};this.centroidArea=function(a){var b=this.cloneObject(a);b.shift();return this.centroid(b)};this.prufer=function(c){var b=[];var e=Array.apply(null,Array(c.length+2)).map(function(a,j){return j});var k=Array.apply(null,Array(1*e.length)).map(function(){return 1});c.map(function(a){k[a]++});for(var g=0;g<c.length;g++){for(var d=0;d<e.length;d++){if(k[e[d]]===1){b.push([c[g],e[d]]);k[c[g]]--;k[e[d]]--;break}}}var h=e.filter(function(a){return k[a]===1});b.push(h);return b};this.probabilityOfZ=function(c){var e=6;var d,a,b;if(c==0){a=0}else{d=0.5*Math.abs(c);if(d>(e*0.5)){a=1}else{if(d<1){b=d*d;a=((((((((0.000124818987*b-0.001075204047)*b+0.005198775019)*b-0.019198292004)*b+0.059054035642)*b-0.151968751364)*b+0.319152932694)*b-0.5319230073)*b+0.797884560593)*d*2}else{d-=2;a=(((((((((((((-0.000045255659*d+0.00015252929)*d-0.000019538132)*d-0.000676904986)*d+0.001390604284)*d-0.00079462082)*d-0.002034254874)*d+0.006549791214)*d-0.010557625006)*d+0.011630447319)*d-0.009279453341)*d+0.005353579108)*d-0.002141268741)*d+0.000535310849)*d+0.999936657524}}}return c>0?((a+1)*0.5):((1-a)*0.5)};this.criticalNormalZ=function(e){var h=6;var c=0.000001;var g=-h;var d=h;var b=0;var a;if(e<0){e=0}if(e>1){e=1}while((d-g)>c){a=this.probabilityOfZ(b);if(a>e){d=b}else{g=b}b=(d+g)*0.5}return b};this.kaplanMeier=function(k,b){var h=this;function l(w,i){firstSecond=h.zip(w,i);firstSecond.sort(function(y,x){return y[1]-x[1]});return h.unzip(firstSecond,0)}function u(w,i){return w-i}var t={times:[],events:[]};for(var q=0;q<k.length;q++){if(!isNaN(k[q])){t.times.push(k[q]);if(this.invertCensored){t.events.push(isNaN(b[q])?1:b[q]?0:1)}else{t.events.push(isNaN(b[q])?0:b[q])}}}k=t.times;b=t.events;var d=this.unique(k).sort(u);var r=new Array(d.length);var a=new Array(d.length);var n=new Array(d.length);var e=new Array(d.length);var v=new Array(d.length);var j=new Array(d.length);var o=new Array(d.length);var p=0;b=l(b,k);k.sort(u);for(var g=0;g<d.length;g++){v[g]=k.length;j[g]=0;o[g]=0;for(var q=0;q<k.length;q++){if(k[q]==d[g]){j[g]+=b[q];o[g]+=!b[q]}else{break}}var s=q;r[g]=(1-j[g]/v[g])*((g==0)?1:r[g-1]);p+=j[g]/(v[g]*(v[g]-j[g]));a[g]=Math.sqrt(p)*r[g];n[g]=Math.sqrt(p);e[g]=Math.sqrt(p)/Math.log(r[g]);b=b.slice(s);k=k.slice(s)}var c=this.kaplanMeierConfidence(r,this.confidenceIntervalType=="log"?n:this.confidenceIntervalType=="loglog"?e:a);return{time:d,nAtRisk:v,nEvents:j,nCensored:o,kaplanMeier:r,greenwoodSE:a,greenwoodSELog:n,greenwoodSELogLog:e,lowerLimit:c[0],upperLimit:c[1]}};this.kaplanMeierConfidence=function(b,g){var h=this.criticalNormalZ(this.confidenceLevel);var j=b.length;var c=new Array(j);var e=new Array(j);for(var d=0;d<j;d++){var a=b[d];if(this.confidenceIntervalType=="log"){a=Math.log(a)}if(this.confidenceIntervalType=="loglog"){a=Math.log(-Math.log(a))}c[d]=a-h*g[d];e[d]=a+h*g[d];if(this.confidenceIntervalType=="log"){c[d]=Math.exp(c[d]);e[d]=Math.exp(e[d])}if(this.confidenceIntervalType=="loglog"){c[d]=Math.exp(-Math.exp(c[d]));e[d]=Math.exp(-Math.exp(e[d]))}c[d]=Math.max(0,c[d]);e[d]=Math.min(1,e[d])}return[c,e]};this.getD3Sankey=function(){var i=function(F,E){return F<E?-1:F>E?1:F>=E?0:NaN};var g=function(J,H){var G=0,I=J.length,E,F=-1;if(H==null){while(++F<I){if(E=+J[F]){G+=E}}}else{while(++F<I){if(E=+H(J[F],F,J)){G+=E}}}return G};var v=function(J,H){var G=-1,I=J.length,F,E;if(H==null){while(++G<I){if((E=J[G])!=null&&E>=E){F=E;break}}while(++G<I){if((E=J[G])!=null&&F>E){F=E}}}else{while(++G<I){if((E=H(J[G],G,J))!=null&&E>=E){F=E;break}}while(++G<I){if((E=H(J[G],G,J))!=null&&F>E){F=E}}}return F};var z=function(F,E){return F=+F,E-=F,function(G){return F+E*G}};var x="$";function k(){}k.prototype=C.prototype={constructor:k,has:function(E){return(x+E) in this},get:function(E){return this[x+E]},set:function(E,F){this[x+E]=F;return this},remove:function(E){var F=x+E;return F in this&&delete this[F]},clear:function(){for(var E in this){if(E[0]===x){delete this[E]}}},keys:function(){var E=[];for(var F in this){if(F[0]===x){E.push(F.slice(1))}}return E},values:function(){var E=[];for(var F in this){if(F[0]===x){E.push(this[F])}}return E},entries:function(){var E=[];for(var F in this){if(F[0]===x){E.push({key:F.slice(1),value:this[F]})}}return E},size:function(){var E=0;for(var F in this){if(F[0]===x){++E}}return E},empty:function(){for(var E in this){if(E[0]===x){return false}}return true},each:function(F){for(var E in this){if(E[0]===x){F(this[E],E.slice(1),this)}}}};function C(E,H){var I=new k;if(E instanceof k){E.each(function(M,L){I.set(L,M)})}else{if(Array.isArray(E)){var G=-1,K=E.length,J;if(H==null){while(++G<K){I.set(G,E[G])}}else{while(++G<K){I.set(H(J=E[G],G,E),J)}}}else{if(E){for(var F in E){I.set(F,E[F])}}}}return I}var B=function(){var I=[],K=[],H,J,G;function F(R,P,N,S){if(P>=I.length){return J!=null?J(R):(H!=null?R.sort(H):R)}var Q=-1,L=R.length,V=I[P++],O,T,M=C(),U,W=N();while(++Q<L){if(U=M.get(O=V(T=R[Q])+"")){U.push(T)}else{M.set(O,[T])}}M.each(function(X,Y){S(W,Y,F(X,P,N,S))});return W}function E(M,N){if(++N>I.length){return M}var O,L=K[N-1];if(J!=null&&N>=I.length){O=M.entries()}else{O=[],M.each(function(Q,P){O.push({key:P,values:E(Q,N)})})}return L!=null?O.sort(function(Q,P){return L(Q.key,P.key)}):O}return G={object:function(L){return F(L,0,t,q)},map:function(L){return F(L,0,u,D)},entries:function(L){return E(F(L,0,u,D),0)},key:function(L){I.push(L);return G},sortKeys:function(L){K[I.length-1]=L;return G},sortValues:function(L){H=L;return G},rollup:function(L){J=L;return G}}};function t(){return{}}function q(E,F,G){E[F]=G}function u(){return C()}function D(G,E,F){G.set(E,F)}var n={};var e=12;var j=5;var o=[1,1];var r=[];var d=[];n.nodeWidth=function(E){if(!arguments.length){return e}e=+E;return n};n.nodePadding=function(E){if(!arguments.length){return j}j=+E;return n};n.nodes=function(E){if(!arguments.length){return r}r=E;return n};n.links=function(E){if(!arguments.length){return d}d=E;return n};n.size=function(E){if(!arguments.length){return o}o=E;return n};n.layout=function(E){c();l();a();h(E);b();w();return n};n.relayout=function(){b();w();return n};n.link=function(){var F=0.5;function E(N){var K=N.source.x+N.source.dx,J=N.target.x,I=z(K,J),H=I(F),G=I(1-F),M=N.source.y+N.sy+N.dy/2,L=N.target.y+N.ty+N.dy/2;return"M"+K+","+M+"C"+H+","+M+" "+G+","+L+" "+J+","+L}E.curvature=function(G){if(!arguments.length){return F}F=+G;return E};return E};function w(){var E=0.5;d.forEach(function(M){var J=M.source.x+M.source.dx,I=M.target.x,H=z(J,I),G=H(E),F=H(1-E),L=M.source.y+M.sy+M.dy/2,K=M.target.y+M.ty+M.dy/2;M.bezier=[[J,G,F,I],[L,L,K,K]]})}function c(){r.forEach(function(E){E.sourceLinks=[];E.targetLinks=[]});d.forEach(function(E){var F=E.source,G=E.target;if(typeof F==="number"){F=E.source=r[E.source]}if(typeof G==="number"){G=E.target=r[E.target]}F.sourceLinks.push(E);G.targetLinks.push(E)})}function l(){r.forEach(function(E){E.value=Math.max(g(E.sourceLinks,s),g(E.targetLinks,s))})}function a(){var F=r,G,E=0;while(F.length){G=[];F.forEach(function(H){H.x=E;H.breadth=E;H.dx=e;H.sourceLinks.forEach(function(I){G.push(I.target)})});F=G;++E}y(E);p((o[0]-e)/(E-1))}function y(E){r.forEach(function(F){if(!F.sourceLinks.length){F.x=E-1}})}function p(E){r.forEach(function(F){F.x*=E})}function h(J){var E=B().key(function(M){return M.x}).sortKeys(i).entries(r).map(function(M){return M.values});H();L();for(var K=1;J>0;--J){F(K*=0.99);L();G(K);L()}function H(){var M=v(E,function(N){return(o[1]-(N.length-1)*j)/g(N,s)});E.forEach(function(N){N.forEach(function(P,O){P.y=O;P.dy=P.value*M})});d.forEach(function(N){N.dy=N.value*M})}function G(N){E.forEach(function(O,P){O.forEach(function(Q){if(Q.targetLinks.length){var R=g(Q.targetLinks,M)/g(Q.targetLinks,s);Q.y+=(R-A(Q))*N}})});function M(O){return A(O.source)*O.value}}function F(N){E.slice().reverse().forEach(function(O){O.forEach(function(P){if(P.sourceLinks.length){var Q=g(P.sourceLinks,M)/g(P.sourceLinks,s);P.y+=(Q-A(P))*N}})});function M(O){return A(O.target)*O.value}}function L(){E.forEach(function(N){var Q,M,P=0,R=N.length,O;N.sort(I);for(O=0;O<R;++O){Q=N[O];M=P-Q.y;if(M>0){Q.y+=M}P=Q.y+Q.dy+j}M=P-j-o[1];if(M>0){P=Q.y-=M;for(O=R-2;O>=0;--O){Q=N[O];M=Q.y+Q.dy+j-P;if(M>0){Q.y-=M}P=Q.y}}})}function I(N,M){return N.y-M.y}}function b(){r.forEach(function(G){G.sourceLinks.sort(E);G.targetLinks.sort(F)});r.forEach(function(H){var I=0,G=0;H.sourceLinks.forEach(function(J){J.sy=I;I+=J.dy});H.targetLinks.forEach(function(J){J.ty=G;G+=J.dy})});function F(H,G){return H.source.y-G.source.y}function E(H,G){return H.target.y-G.target.y}}function A(E){return E.y+E.dy/2}function s(E){return E.value}return n};this.setSankey=function(){var a=this.getD3Sankey();a.nodeWidth(this.sankeyNodeWidth);a.nodePadding(this.margin);a.size([this.x,this.y]);a.nodes(this.data.sankey.nodes);a.links(this.data.sankey.links);a.layout(this.sankeyIterations);this.data.sankey.object=a};this.getD3Tree=function(){var b=this;var n=function(A,z,y){var B=y/(z.i-A.i);z.c-=B;z.s+=y;A.c+=B;z.z+=y;z.m+=y};var g=function(A){var z=0;var D=0;var C=A.children;var B=C.length;var y;while(--B>=0){y=C[B];y.z+=z;y.m+=z;z+=y.s+(D+=y.c)}};var a=function(z,y,A){return z.a.parent===y.parent?z.a:A};var t=function(y){var z=y.children;return z?z[0]:y.t};var x=function(y){var z=y.children;return z?z[z.length-1]:y.t};var e=function(z,y){return z.parent===y.parent?1:2};var j=1;var h=1;var p=null;var i=function(B,z){if(B===z){return B}var A=B.ancestors();var y=z.ancestors();var C=null;B=A.pop();z=y.pop();while(B===z){C=B;B=A.pop();z=y.pop()}return C};var d=function(y){y.data=y.data.data};var k=function(z){var y=0;do{z.height=y}while((z=z.parent)&&(z.height<++y))};var c=function(E,A){var H=new w(E);var F=+E.value&&(H.value=E.value);var C;var y=[H];var z;var G;var D;var B;if(A==null){A=function(I){return I.children}}while(C=y.pop()){if(F){C.value=+C.data.value}if((G=A(C.data))&&(B=G.length)){C.children=new Array(B);for(D=B-1;D>=0;--D){y.push(z=C.children[D]=new w(G[D]));z.parent=C;z.depth=C.depth+1}}}return H.eachBefore(k)};var w=function(y){this.data=y;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=b.treeNodeId++}};w.prototype=c.prototype={constructor:w,count:function(){return this.eachAfter(count)},each:function(E){var B=this;var C;var A=[B];var z,y,D;do{C=A.reverse();A=[];while(B=C.pop()){E(B);z=B.children;if(z){for(y=0,D=z.length;y<D;++y){A.push(z[y])}}}}while(A.length);return this},eachAfter:function(E){var C=this;var y=[C];var B=[];var A,z,D;while(C=y.pop()){B.push(C);A=C.children;if(A){for(z=0,D=A.length;z<D;++z){y.push(A[z])}}}while(C=B.pop()){E(C)}return this},eachBefore:function(C){var B=this;var y=[B];var A,z;while(B=y.pop()){C(B);A=B.children;if(A){for(z=A.length-1;z>=0;--z){y.push(A[z])}}}return this},sum:function(y){return this.eachAfter(function(C){var B=+y(C.data)||0;var A=C.children;var z=A&&A.length;while(--z>=0){B+=A[z].value}C.value=B})},sort:function(y){return this.eachBefore(function(z){if(z.children){z.children.sort(y)}})},path:function(y){var C=this;var B=i(C,y);var A=[C];while(C!==B){C=C.parent;A.push(C)}var z=A.length;while(y!==B){A.splice(z,0,y);y=y.parent}return A},ancestors:function(){var z=this;var y=[z];while(z=z.parent){y.push(z)}return y},descendants:function(){var y=[];this.each(function(z){y.push(z)});return y},leaves:function(){var y=[];this.eachBefore(function(z){if(!z.children){y.push(z)}});return y},links:function(){var y=this;var z=[];y.each(function(A){if(A!==y){z.push({source:A.parent,target:A})}});return z},copy:function(){return c(this).eachBefore(d)}};var r=function(z,y){this._=z;this.parent=null;this.children=null;this.A=null;this.a=this;this.z=0;this.m=0;this.c=0;this.s=0;this.t=null;this.i=y};r.prototype=Object.create(w.prototype);var s=function(z){var y=new r(z,0);var D;var A=[y];var F;var C;var B;var E;while(D=A.pop()){if(C=D._.children){D.children=new Array(E=C.length);for(B=E-1;B>=0;--B){A.push(F=D.children[B]=new r(C[B],B));F.parent=D}}}(y.parent=new r(null,0)).children=[y];return y};function l(D){var F=s(D);F.eachAfter(v),F.parent.m=-F.z;F.eachBefore(q);if(p){D.eachBefore(u)}else{var z=D;var E=D;var y=D;D.eachBefore(function(H){if(H.x<z.x){z=H}if(H.x>E.x){E=H}if(H.depth>y.depth){y=H}});var G=z===E?1:e(z,E)/2;var A=G-z.x;var C=j/(E.x+G+A);var B=h/(y.depth||1);D.eachBefore(function(H){H.x=(H.x+A)*C;H.y=H.depth*B})}return D}function v(z){var B=z.children;var C=z.parent.children;var y=z.i?C[z.i-1]:null;if(B){g(z);var A=(B[0].z+B[B.length-1].z)/2;if(y){z.z=y.z+e(z._,y._);z.m=z.z-A}else{z.z=A}}else{if(y){z.z=y.z+e(z._,y._)}}z.parent.A=o(z,y,z.parent.A||C[0])}function q(y){y._.x=y.z+y.parent.m;y.m+=y.parent.m}function o(J,I,D){if(I){var A=J;var z=J;var C=I;var B=A.parent.children[0];var F=A.m;var E=z.m;var H=C.m;var G=B.m;var y;while(C=x(C),A=t(A),C&&A){B=t(B);z=x(z);z.a=J;y=C.z+H-A.z-F+e(C._,A._);if(y>0){n(a(C,J,D),J,y);F+=y;E+=y}H+=C.m;F+=A.m;G+=B.m;E+=z.m}if(C&&!x(z)){z.t=C;z.m+=H-E}if(A&&!t(B)){B.t=A;B.m+=F-G;D=J}}return D}function u(y){y.x*=j;y.y=y.depth*h}l.separation=function(y){return arguments.length?(e=y,l):e};l.size=function(y){return arguments.length?(p=false,j=+y[0],h=+y[1],l):(p?null:[j,h])};l.nodeSize=function(y){return arguments.length?(p=true,j=+y[0],h=+y[1],l):(p?[j,h]:null)};l.setTree=function(z,y){return c(z,y)};l.collapse=function(y){l.collapseTree(y);l.update(y)};l.expand=function(y){l.expandTree(y);l.update(y)};l.collapseTree=function(y){if(y.children){y._children=y.children;y._children.forEach(l.collapseTree);y.children=null}};l.expandTree=function(y){if(y._children){y.children=y._children;y.children.forEach(l.expandTree);delete y._children}};return l};this.setTree=function(){var b=[];if(this.treeCircular){b=this.x>this.y?[360,this.y/2]:[360,this.x/2]}else{b=[this.graphOrientation=="vertical"?this.x:this.y,this.graphOrientation=="vertical"?this.y:this.x]}var a=function(d,c){return(d.parent==c.parent?1:2)/d.depth};this.data.tree.object=this.treeCircular?this.getD3Tree().size(b).separation(a):this.getD3Tree().size(b);if(!this.data.tree.root){this.data.tree.root=this.getD3Tree().setTree(this.data.tree.data,function(c){return c.children})}this.data.tree.plot=this.data.tree.object(this.data.tree.root);this.data.tree.plot.size=b};this.getD3CirclePack=function(){var n=this;var t=function(M,K){if(M===K){return M}var L=M.ancestors();var J=K.ancestors();var N=null;M=L.pop();K=J.pop();while(M===K){N=M;M=L.pop();K=J.pop()}return N};var q=function(J){J.data=J.data.data};var y=function(K){var J=0;do{K.height=J}while((K=K.parent)&&(K.height<++J))};var o=function(P,L){var S=new H(P);var Q=+P.value&&(S.value=P.value);var N;var J=[S];var K;var R;var O;var M;if(L==null){L=function(T){return T.children}}while(N=J.pop()){if(Q){N.value=+N.data.value}if((R=L(N.data))&&(M=R.length)){N.children=new Array(M);for(O=M-1;O>=0;--O){J.push(K=N.children[O]=new H(R[O]));K.parent=N;K.depth=N.depth+1}}}return S.eachBefore(y)};var H=function(J){this.data=J;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=n.treeNodeId++}};H.prototype=o.prototype={constructor:H,count:function(){return this.eachAfter(count)},each:function(P){var M=this;var N;var L=[M];var K,J,O;do{N=L.reverse();L=[];while(M=N.pop()){P(M);K=M.children;if(K){for(J=0,O=K.length;J<O;++J){L.push(K[J])}}}}while(L.length);return this},eachAfter:function(P){var N=this;var J=[N];var M=[];var L,K,O;while(N=J.pop()){M.push(N);L=N.children;if(L){for(K=0,O=L.length;K<O;++K){J.push(L[K])}}}while(N=M.pop()){P(N)}return this},eachBefore:function(N){var M=this;var J=[M];var L,K;while(M=J.pop()){N(M);L=M.children;if(L){for(K=L.length-1;K>=0;--K){J.push(L[K])}}}return this},sum:function(J){return this.eachAfter(function(N){var M=+J(N.data)||0;var L=N.children;var K=L&&L.length;while(--K>=0){M+=L[K].value}N.value=M})},sort:function(J){return this.eachBefore(function(K){if(K.children){K.children.sort(J)}})},path:function(J){var N=this;var M=t(N,J);var L=[N];while(N!==M){N=N.parent;L.push(N)}var K=L.length;while(J!==M){L.splice(K,0,J);J=J.parent}return L},ancestors:function(){var K=this;var J=[K];while(K=K.parent){J.push(K)}return J},descendants:function(){var J=[];this.each(function(K){J.push(K)});return J},leaves:function(){var J=[];this.eachBefore(function(K){if(!K.children){J.push(K)}});return J},links:function(){var J=this;var K=[];J.each(function(L){if(L!==J){K.push({source:L.parent,target:L})}});return K},copy:function(){return o(this).eachBefore(q)}};var e=null;var u=1;var s=1;var i=function(J){this._=J;this.next=null};var h=function(O){var K;var N=(O=O.slice()).length;var J=null;var M=J;while(N){var L=new i(O[N-1]);if(M){M=M.next=L}else{M=J=L}O[K]=O[--N]}return{head:J,tail:M}};var v=function(J){return I(h(J),[])};var d=function(L,J){var M=J.x-L.x;var K=J.y-L.y;var N=L.r-J.r;return N*N+0.000001>M*M+K*K};var I=function(K,Q){var O;var N=null;var M=K.head;var J;var P;switch(Q.length){case 1:O=A(Q[0]);break;case 2:O=z(Q[0],Q[1]);break;case 3:O=w(Q[0],Q[1],Q[2]);break}while(M){P=M._;J=M.next;if(!O||!d(O,P)){if(N){K.tail=N;N.next=null}else{K.head=K.tail=null}Q.push(P);O=I(K,Q);Q.pop();if(K.head){M.next=K.head;K.head=M}else{M.next=null;K.head=K.tail=M}N=K.tail;N.next=J}else{N=M}M=J}K.tail=N;return O};var A=function(J){return{x:J.x,y:J.y,r:J.r}};var z=function(U,R){var K=U.x;var T=U.y;var M=U.r;var J=R.x;var Q=R.y;var L=R.r;var P=J-K;var S=Q-T;var N=L-M;var O=Math.sqrt(P*P+S*S);return{x:(K+J+P/O*N)/2,y:(T+Q+S/O*N)/2,r:(O+M+L)/2}};var w=function(ai,ag,af){var ae=ai.x;var N=ai.y;var Z=ai.r;var ad=ag.x;var M=ag.y;var X=ag.r;var aa=af.x;var K=af.y;var W=af.r;var al=2*(ae-ad);var P=2*(N-M);var V=2*(X-Z);var am=ae*ae+N*N-Z*Z-ad*ad-M*M+X*X;var aj=2*(ae-aa);var O=2*(N-K);var U=2*(W-Z);var ak=ae*ae+N*N-Z*Z-aa*aa-K*K+W*W;var ah=aj*P-al*O;var ac=(P*ak-O*am)/ah-ae;var Y=(O*V-P*U)/ah;var L=(aj*am-al*ak)/ah-N;var J=(al*U-aj*V)/ah;var T=Y*Y+J*J-1;var S=2*(ac*Y+L*J+Z);var R=ac*ac+L*L-Z*Z;var Q=(-S-Math.sqrt(S*S-4*T*R))/(2*T);return{x:ac+Y*Q+ae,y:L+J*Q+N,r:Q}};var p=function(O,M,K){var J=O.x;var S=O.y;var T=M.r+K.r;var R=O.r+K.r;var U=M.x-J;var Q=M.y-S;var P=U*U+Q*Q;if(P){var N=0.5+((R*=R)-(T*=T))/(2*P);var L=Math.sqrt(Math.max(0,2*T*(R+P)-(R-=P)*R-T*T))/(2*P);K.x=J+N*U+L*Q;K.y=S+N*Q-L*U}else{K.x=J+R;K.y=S}};var a=function(L,J){var M=J.x-L.x;var K=J.y-L.y;var N=L.r+J.r;return N*N-0.000001>M*M+K*K};var C=function(O,K,Q){var M=O._;var J=O.next._;var P=M.r+J.r;var N=(M.x*J.r+J.x*M.r)/P-K;var L=(M.y*J.r+J.y*M.r)/P-Q;return N*N+L*L};var j=function(J){this._=J;this.next=null;this.previous=null};var l=function(R){if(!(P=R.length)){return 0}var W,P,T,X,X,V;var Z=R[0];Z.x=0;Z.y=0;if(!(P>1)){return Z.r}var Y=R[1];Z.x=-Y.r;Y.x=Z.r;Y.y=0;if(!(P>2)){return Z.r+Y.r}p(Y,Z,W=R[2]);var ab=Z.r*Z.r;var N=Y.r*Y.r;var O=W.r*W.r;var S=ab+N+O;var M=ab*Z.x+N*Y.x+O*W.x;var L=ab*Z.y+N*Y.y+O*W.y;var K,J,U,T,Q,X,V;Z=new j(Z);Y=new j(Y);W=new j(W);Z.next=W.previous=Y;Y.next=Z.previous=W;W.next=Y.previous=Z;D:for(var U=3;U<P;++U){p(Z._,Y._,W=R[U]);W=new j(W);T=Y.next;Q=Z.previous;X=Y._.r;V=Z._.r;do{if(X<=V){if(a(T._,W._)){Y=T;Z.next=Y;Y.previous=Z;--U;continue D}X+=T._.r;T=T.next}else{if(a(Q._,W._)){Z=Q;Z.next=Y;Y.previous=Z;--U;continue D}V+=Q._.r;Q=Q.previous}}while(T!==Q.next);W.previous=Z;W.next=Y;Z.next=Y.previous=Y=W;S+=O=W._.r*W._.r;M+=O*W._.x;L+=O*W._.y;ab=C(Z,K=M/S,J=L/S);while((W=W.next)!==Y){if((O=C(W,K,J))<ab){Z=W;ab=O}}Y=Z.next}Z=[Y._];W=Y;while((W=W.next)!==Y){Z.push(W._)}W=v(Z);for(var U=0;U<P;++U){Z=R[U];Z.x-=W.x;Z.y-=W.y}return W.r};var k=function(J){l(J);return J};var G=function(J){return J==null?null:r(J)};var r=function(J){if(typeof J!=="function"){throw new Error}return J};var B=function(){return 0};var g=function(J){return function(){return J}};var F=function(J){return Math.sqrt(J.value)};var G=function(J){return J==null?null:r(J)};var E=function(J){return function(K){if(!K.children){K.r=Math.max(0,+J(K)||0)}}};var c=function(K,J){return function(O){if(M=O.children){var M,L,Q=M.length,N=K(O)*J||0,P;if(N){for(L=0;L<Q;++L){M[L].r+=N}}P=l(M);if(N){for(L=0;L<Q;++L){M[L].r-=N}}O.r=P+N}}};var b=function(J){return function(L){var K=L.parent;L.r*=J;if(K){L.x=K.x+J*L.x;L.y=K.y+J*L.y}}};var x=B;function D(J){J.x=u/2,J.y=s/2;if(e){J.eachBefore(E(e)).eachAfter(c(x,0.5)).eachBefore(b(1))}else{J.eachBefore(E(F)).eachAfter(c(B,1)).eachAfter(c(x,J.r/Math.min(u,s))).eachBefore(b(Math.min(u,s)/(2*J.r)))}return J}D.radius=function(J){return arguments.length?(e=G(J),D):e};D.size=function(J){return arguments.length?(u=+J[0],s=+J[1],D):[u,s]};D.padding=function(J){return arguments.length?(x=typeof J==="function"?J:g(+J),D):x};D.setPack=function(J){return o(J).sum(function(K){return K.size}).sort(function(L,K){return K.value-L.value})};return D};this.setCirclePack=function(){var b=Math.max(this.top,this.right);var a=this.width-(this.right+this.left+this.marginLeft+this.marginRight);var e=this.height-(this.top+this.bottom+this.marginTop+this.marginBottom);var c=a>e?e:a;this.data.bubble.object=this.getD3CirclePack().size([c,c]).padding(2);if(!this.data.bubble.root){this.data.bubble.root=this.getD3CirclePack().setPack(this.data.bubble.data)}this.data.bubble.plot=this.data.bubble.object(this.data.bubble.root);this.data.bubble.plot.diameter=c};this.circularLayout=function(c,g){var e=this;if(c.length>0){var b,h,d;if(g){}else{b=this.x/2;h=this.y/2;d=Math.max(this.x,this.y)}this.calculateCircularLayoutFinalNodePosition(c,b,h,d);var a=function(){if(e.iteration<=15){e.updateCircularLayoutNodePositions(c);e.renderNetwork(false);e.drawNetworkProgressBar("Optimizing ...",e.iteration/15);e.requestAnimationFrame(a)}else{e.finalizeNetworkLayout("circularLayout")}};a()}};this.calculateCircularLayoutFinalNodePosition=function(b,a,h,g){var e=2*Math.PI/b.length;for(var c=0;c<b.length;c++){var d=b[c];if(!d.hide){d.layout.lastPosition.x=a+g+g*Math.sin(c*e);d.layout.lastPosition.y=h+g+g*Math.cos(c*e);d.layout.lastPosition.r=this.networkRadialRadius;d.layout.lastPosition.a=c*e*180/Math.PI;d.radius=this.networkRadialRadius;d.angle=c*e*180/Math.PI}}};this.updateCircularLayoutNodePositions=function(d){var l=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;for(var e=0;e<d.length;e++){var j=d[e].layout;var h=j.lastPosition;var b=h.a*l;var g=h.r*l;var k=this.getPolar(this.networkXCenter,this.networkYCenter,g,b);j.position.x=k.x;j.position.y=k.y}this.updateLayoutNodePositions(d)};this.radialLayout=function(a,d){var c=this;if(a&&a.length){this.calculateRadialLayoutFinalNodePosition(d);this.resetRadialLayoutNodePositions(a);var b=function(){if(c.iteration<15){c.updateRadialLayoutNodePositions(a);c.renderNetwork(false);c.drawNetworkProgressBar("Optimizing ...",c.iteration/15);c.requestAnimationFrame(b)}else{c.finalizeNetworkLayout("radialLayout")}};b()}};this.orderRadialLayout=function(d){var b=this.data.nodeIndices[d];var c=0;for(var a=b;a<this.data.nodes.length;a++){this.data.nodes[a].layout.order=c++}for(var a=0;a<b;a++){this.data.nodes[a].layout.order=c++}};this.updateRadialLayoutNodePositions=function(d){var g=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;var e=1-g;for(var j=0;j<d.length;j++){var h=d[j].layout;var p=h.lastPosition;var l=((e*h.angle)+(g*p.a));var b=((e*h.radius)+(g*p.r));var k=this.getPolar(this.networkXCenter,this.networkYCenter,b,l);d[j].layout.position.x=k.x;d[j].layout.position.y=k.y}this.updateLayoutNodePositions(d)};this.resetRadialLayoutNodePositions=function(a){for(var b=0;b<a.length;b++){var e=a[b].layout;var c=e.lastPosition;if(c.r==0){e.angle=c.a}if(c.r==0){c.a=e.angle}var g=(c.a-e.angle);if(g<0){g+=360}if(g>360){g-=360}if(g>180){g-=360}c.a=e.angle+g}};this.calculateRadialLayoutFinalNodePosition=function(h,d){var q=this;var u=0;var t=[];var p=this.data.nodes[this.data.nodeIndices[h]];var j=p.layout;if(j.hierarchy!="done"){if(!p.hide&&!p.hiddenParent){if(j.children.length>1&&!d){this.orderRadialLayout(h);j.children.sort(function(i,c){var n=q.data.nodes[q.data.nodeIndices[i]].layout;var l=q.data.nodes[q.data.nodeIndices[c]].layout;return n.order-l.order});for(var o=0;o<j.children.length;o++){var e=j.children[o];var v=this.data.nodes[this.data.nodeIndices[e]].layout;if(v.level>j.level){this.calculateRadialLayoutFinalNodePosition(e);t.push(v.angle)}}if(t.length>0){var g=t.length-1;if(t.length==1){u=t[0]}else{if(t[0]>t[g]){u=((t[0]+t[g])%360)/2}else{u=(t[0]+t[g])/2}}}else{this.calculateRadialLayoutFinalNodePosition(h,true)}}else{u=this.networkCurrentAngle;this.networkCurrentAngle=(this.networkCurrentAngle+this.networkAngleStep)}var k=(this.networkDepth-1)-j.level;var s=this.getPolar(this.networkXCenter,this.networkYCenter,this.networkRadialRadius,u);var w=this.shortenLine(this.networkXCenter,this.networkYCenter,s.x,s.y,0,this.networkLevelSize*k,"line");var b=this.lineLength(this.networkXCenter,this.networkYCenter,w[2],w[3]);if(j.level==0){u=0;b=0}j.lastPosition.x=w[2];j.lastPosition.y=w[3];j.lastPosition.r=b;j.lastPosition.a=u%360;j.hierarchy="done";j.angle=u}}};this.forceDirectedLayout=function(b,a){var d=this;if(b&&b.length){var c=function(){var e=d.calculateForcedDirectedLayoutMovement(b,a);var g=e/b.length;if(g>=0.01&&d.iteration<d.maxIterations){d.iteration++;if(d.iteration%2){d.renderNetwork(false)}d.drawNetworkProgressBar("Optimizing ...",d.iteration/d.maxIterations);d.requestAnimationFrame(c)}else{d.finalizeNetworkLayout("forceDirectedLayout")}};c()}};this.calculateForcedDirectedLayoutMovement=function(b,a){if(this.useBarnesHutSimulation||a){this.accumulateForceDirectedLayoutForces();return this.integrateForceDirectedLayout(b)}else{this.setForceDirectedLayoutNodeDisplacement(b);return this.integrateForceDirectedLayoutDisplacement(b)}};this.integrateForceDirectedLayoutDisplacement=function(a){var d=this.averageForceDirectedLayoutMovement(a);var b=a.length;if(b){while(b--){var c=a[b];if(!c.fixed&&this.iteration%2){c.layout.prevPosition.x=c.layout.position.x;c.layout.prevPosition.y=c.layout.position.y}}}this.updateLayoutNodePositions(a);return d*a.length};this.setForceDirectedLayoutNodeDisplacement=function(d){var b={};var j=[];var h=d.length;for(var k=0;k<h;k++){var g=d[k];for(var p=0;p<g.layout.edges.length;p++){var n=g.layout.edges[p];var o=n.id1+":"+n.id2;if(!b.hasOwnProperty(o)){j.push(n);b[o]=true}}if(!g.fixed&&!this.iteration){g.layout.displacement={x:g.x,y:g.y,z:g.z};g.layout.force={x:0,y:0,z:0}}}this.calculateForceDirectedLayoutRepulsiveDisplacement(d);this.calculateForceDirectedLayoutAttractiveDisplacement(d,j);this.applyForceDirectedLayoutDisplacement(d)};this.calculateForceDirectedLayoutRepulsiveDisplacement=function(b){var w=this;var g=b.length;var h=Math.sqrt((g*g)/g+1);var s=function(i){switch(w.repulsiveForceFunction){case"FruchtermanReingold":case"square":return(h*h)/i;case"cubic":return(h*h*h)/i;case"Eades":case"log":return h/Math.log(i);case"pow":return h*Math.pow(2,i);case"sqrt":return h/Math.sqrt(i)}};for(var o=0;o<g;o++){var e=b[o];var c=e.layout.displacement;var r=e.layout.force;if(!e.fixed){for(var n=0;n<g;n++){if(o!=n){var d=b[n];var a=d.layout.displacement;var x=c.x-a.x;var v=c.y-a.y;var u=c.z-a.z;var q=Math.sqrt((x*x)+(v*v)+(u*u))+0.01;var p=s(q);r.x+=x/q*p;r.y+=v/q*p;r.z+=u/q*p}}}}};this.calculateForceDirectedLayoutAttractiveDisplacement=function(j,a){var g=this;var p=j.length;var s=Math.sqrt((p*p)/p+1);var x=function(i){switch(g.attractiveForceFunction){case"FruchtermanReingold":case"square":return(i*i)/s;case"cubic":return(i*i*i)/s;case"Eades":case"log":return i*Math.log(m);case"pow":return i*Math.pow(2,s);case"sqrt":return i/Math.sqrt(s)}};var p=a.length;for(var v=0;v<p;v++){var b=a[v];var u=this.nodes[b.id1];var q=this.nodes[b.id2];var r=u.layout.displacement;var o=q.layout.displacement;var y=u.layout.force;var w=q.layout.force;var e=r.x-o.x;var d=r.y-o.y;var c=r.z-o.z;var h=Math.sqrt((e*e)+(d*d)+(c*c))+0.01;var n=x(h);if(!u.fixed){y.x-=e/h*n;y.y-=d/h*n;y.z-=c/h*n}if(!q.fixed){w.x+=e/h*n;w.y+=d/h*n;w.z+=c/h*n}}};this.applyForceDirectedLayoutDisplacement=function(b){var s=this;var e=b.length;var d=Math.sqrt(e*e)/10;var g=Math.sqrt((e*e)/e+1);for(var h=0;h<e;h++){var p=b[h].layout.displacement;var j=b[h].layout.force;var n=Math.sqrt((p.x*p.x)+(p.y*p.y)+(p.z*p.z));var a=g*this.networkGravity*n*0.01;j.x-=a*p.x/n;j.y-=a*p.y/n;j.z-=a*p.z/n;j.x*=this.networkSpeed;j.y*=this.networkSpeed;j.z*=this.networkSpeed;if(!b[h].fixed){var u=j.x;var r=j.y;var q=j.z;var n=Math.sqrt((u*u)+(r*r)+(q*q));if(n>0){var o=Math.min(d*this.networkSpeed,n);p.x+=u/n*o;p.y+=r/n*o;p.z+=q/n*o}}}for(var h=0;h<e;h++){var c=b[h];var p=b[h].layout.displacement;c.layout.position={x:p.x,y:p.y,z:p.z}}};this.accumulateForceDirectedLayoutForces=function(){var c=this.data.nodes;var b=this.data.edges;var d=c.length;if(d){var a=this.barnesHutInsertBodies(c);while(d--){var e=c[d];if(!e.fixed){e.layout.force={x:0,y:0,z:0};this.barnesHutUpdateBodyForce(e,a);this.updateForceDirectedLayoutDragForce(e)}}}d=b.length;while(d--){this.updateForceDirectedLayoutSpringForce(b[d])}this.updateLayoutNodePositions(c)};this.barnesHutNewNode=function(){this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent]={body:null,quad0:null,quad1:null,quad2:null,quad3:null,quad4:null,quad5:null,quad6:null,quad7:null,mass:0,massX:0,massY:0,left:0,top:0,bottom:0,right:0,back:0,front:0};var a=this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent];++this.barnesHutNodesCacheCurrent;return a};this.barnesHutInsertBodies=function(e,q){var d=this;var a=function(Y){var U=function(y,x){if(x===0){return y.quad0}if(x===1){return y.quad1}if(x===2){return y.quad2}if(x===3){return y.quad3}return null};var T=function(y,x,z){if(x===0){y.quad0=z}else{if(x===1){y.quad1=z}else{if(x===2){y.quad2=z}else{if(x===3){y.quad3=z}}}}};var X=function(ab,aa){var z=Math.abs(ab.x-aa.x);var y=Math.abs(ab.y-aa.y);var x=Math.abs(ab.z-aa.z);return(z<1e-8&&y<1e-8&&x<1e-8)};var Z={stack:[],popIdx:0,isEmpty:function(){return this.popIdx===0},push:function(y,x){this.stack[this.popIdx]={node:y,body:x};++this.popIdx},pop:function(){if(this.popIdx>0){return this.stack[--this.popIdx]}},reset:function(){this.popIdx=0}};Z.reset();Z.push(q,Y);while(!Z.isEmpty()){var B=Z.pop();var R=B.node;var N=B.body;if(!R.body){var K=N.layout.position.x;var I=N.layout.position.y;var H=N.layout.position.z;R.mass=R.mass+N.layout.mass;R.massX=R.massX+N.layout.mass*K;R.massY=R.massY+N.layout.mass*I;R.massZ=R.massZ+N.layout.mass*H;var A=0;var C=R.left;var W=(R.right+C)/2;var P=R.top;var G=(R.bottom+P)/2;var Q=R.back;var F=(R.front-Q)/2;if(this.is3DNetwork){if(K>W){A=A+1;var S=C;C=W;W=W+(W-S)}if(I>G){A=A+2;var i=P;P=G;G=G+(G-i)}if(H>F){A=A+4;var w=Q;Q=F;F=Q+(Q-w)}}else{if(K>W){A=A+1;C=W;W=R.right}if(I>G){A=A+2;P=G;G=R.bottom}}var E=U(R,A);if(!E){E=d.barnesHutNewNode();E.left=C;E.top=P;E.right=W;E.bottom=G;E.back=Q;E.front=F;E.body=N;T(R,A,E)}else{Z.push(E,N)}}else{var M=R.body;R.body=null;if(X(M.layout.position,N.layout.position)){var V=3;while(V>0&&X(M.layout.position,N.layout.position)){var D=d.random();var O=(R.right-R.left)*D;var L=(R.bottom-R.top)*D;var J=(R.front-R.back)*D;M.layout.position.x=R.left+O;M.layout.position.y=R.top+L;M.layout.position.z=R.back+J;V-=1}if(V===0&&X(M.layout.position,N.layout.position)){return}}Z.push(R,M);Z.push(R,N)}}};var v=Number.MAX_VALUE;var c=Number.MAX_VALUE;var p=Number.MAX_VALUE;var u=Number.MIN_VALUE;var b=Number.MIN_VALUE;var n=Number.MIN_VALUE;var s=e.length;var t=s;while(t--){var k=e[t].layout.position.x;var h=e[t].layout.position.y;var g=e[t].layout.position.y;if(k<v){v=k}if(k>u){u=k}if(h<c){c=h}if(h>b){b=h}if(g<p){p=g}if(g>n){n=g}}var o=u-v;var l=b-c;var j=n-p;var r=Math.max(o,Math.max(l,j));if(this.is3DNetwork){u=v+r;b=c+r;n=p+r}else{if(o>l){b=c+o}else{u=v+l}}this.barnesHutNodesCacheCurrent=0;q=this.barnesHutNewNode();q.left=v;q.right=u;q.top=c;q.bottom=b;q.back=p;q.from=n;t=s-1;if(t>=0){q.body=e[t]}while(t--){a(e[t],q)}return q};this.barnesHutUpdateBodyForce=function(k,n){var j=this.barnesHutUpdateQueue;var o;var t;var s;var q;var a;var h=0;var d=0;var b=0;var g=1;var l=0;var e=1;j[0]=n;while(g){var c=j[l];var i=c.body;g-=1;l+=1;var p=(i!==k);if(i&&p){t=i.layout.position.x-k.layout.position.x;s=i.layout.position.y-k.layout.position.y;q=i.layout.position.z-k.layout.position.z;a=Math.sqrt(t*t+s*s+q*q);if(a===0){t=(this.random()-0.5)/50;s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;a=Math.sqrt(t*t+s*s+q*q)}o=this.networkRepulsion*i.layout.mass*k.layout.mass/(a*a*a);h+=o*t;d+=o*s;b+=o*q}else{if(p){t=c.massX/c.mass-k.layout.position.x;s=c.massY/c.mass-k.layout.position.y;q=c.massZ/c.mass-k.layout.position.z;a=Math.sqrt(t*t+s*s+q*q);if(a===0){t=(this.random()-0.5)/50;s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;a=Math.sqrt(t*t+s*s+q*q)}if((c.right-c.left)/a<this.networkTheta){o=this.networkRepulsion*c.mass*k.layout.mass/(a*a*a);h+=o*t;d+=o*s;b+=o*q}else{if(c.quad0){j[e]=c.quad0;g+=1;e+=1}if(c.quad1){j[e]=c.quad1;g+=1;e+=1}if(c.quad2){j[e]=c.quad2;g+=1;e+=1}if(c.quad3){j[e]=c.quad3;g+=1;e+=1}if(this.is3DNetwork){if(c.quad4){j[e]=c.quad4;g+=1;e+=1}if(c.quad5){j[e]=c.quad5;g+=1;e+=1}if(c.quad6){j[e]=c.quad6;g+=1;e+=1}if(c.quad7){j[e]=c.quad7;g+=1;e+=1}}}}}}k.layout.force.x+=h;k.layout.force.y+=d;k.layout.force.z+=b};this.updateLayoutNodePositions=function(a){var b=a.length;while(b--){a[b].x=a[b].layout.position.x;a[b].y=a[b].layout.position.y;a[b].z=a[b].layout.position.z}};this.updateForceDirectedLayoutSpringForce=function(b){var i=this.data.nodes[this.data.nodeIndices[b.id1]];var h=this.data.nodes[this.data.nodeIndices[b.id2]];var c=b.layout.length<0?this.networkSpringLength:b.layout.length;var k=h.layout.position.x-i.layout.position.x;var j=h.layout.position.y-i.layout.position.y;var a=Math.sqrt(k*k+j*j);if(a===0){k=(this.random()-0.5)/50;j=(this.random()-0.5)/50;a=Math.sqrt(k*k+j*j)}var g=a-c;var e=((!b.layout.coeff||b.layout.coeff<0)?this.networkSpringCoeff:b.layout.coeff)*g/a*b.layout.weight;i.layout.force.x+=e*k;i.layout.force.y+=e*j;h.layout.force.x-=e*k;h.layout.force.y-=e*j};this.integrateForceDirectedLayout=function(a){var o=0;var e=0;var n=0;var c=0;var k=a.length;if(k===0){return 0}for(var d=0;d<k;++d){var b=a[d];var g=this.networkTimeStep/b.layout.mass;b.layout.velocity.x+=g*b.layout.force.x;b.layout.velocity.y+=g*b.layout.force.y;var j=b.layout.velocity.x;var h=b.layout.velocity.y;var l=Math.sqrt(j*j+h*h);if(l>1){b.layout.velocity.x=j/l;b.layout.velocity.y=h/l}o=this.networkTimeStep*b.layout.velocity.x;n=this.networkTimeStep*b.layout.velocity.y;b.layout.position.x+=o;b.layout.position.y+=n;e+=Math.abs(o);c+=Math.abs(n)}return(e*e+c*c)/k};this.updateForceDirectedLayoutDragForce=function(a){a.layout.force.x-=this.networkDragCoeff*a.layout.velocity.x;a.layout.force.y-=this.networkDragCoeff*a.layout.velocity.y};this.averageForceDirectedLayoutMovement=function(c){var d=c.length;var b=0;var a=0;while(d--){var g=c[d];var h=g.layout.position;var e=g.layout.prevPosition;b+=Math.abs(h.x-e.x);a+=Math.abs(h.y-e.y)}return Math.sqrt(b*b+a*a)/c.length};this.networkBetweenness=function(c,g){var l=this;var k=[];var h=[];var d={};var n={};var p={};var o={};var a={};var b=function(w){var z=function(s,i){if(n[i]===-1){n[i]=n[s]+1;k.push(i)}if(n[i]===n[s]+1){p[i]+=p[s];d[i].push(s)}};var x=function(B){var A=l.nodes[B].layout.edges;for(var C=0;C<A.length;C++){var D=A[C];var s=D.id1;if(B==s){if(z(B,s)){return true}}}};var u=function(B){var A=l.nodes[B].layout.edges;for(var C=0;C<A.length;C++){var D=A[C];var s=D.id1==B?D.id2:D.id1;if(z(B,s)){return true}}};var y=function(i){if(g){return x(i)}else{return u(i)}};for(var t=0;t<c.length;t++){d[c[t].id]=[];n[c[t].id]=-1;p[c[t].id]=0}n[w]=0;p[w]=1;k.push(w);while(k.length){var r=k.shift();h.push(r);y(r)}};var q=function(){for(var x=0;x<c.length;x++){o[c[x].id]=0}while(h.length){var r=h.pop();var t=(1+o[r])/p[r];var u=d[r];for(var x=0;x<u.length;++x){var s=u[x];o[s]+=p[s]*t}if(r!==e.id){a[r]+=o[r]}}};for(var j=0;j<c.length;j++){var e=c[j].layout;if(!e.metrics){e.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};e.edges=this.edgesForNode(this.data.edges,c[j].id)}a[c[j].id]=0}for(var j=0;j<c.length;j++){var e=c[j];b(e.id);q()}for(var j=0;j<c.length;j++){var e=c[j].layout;e.metrics.betweenness=g?a[c[j].id]:a[c[j].id]/2}};this.networkCloseness=function(b,e){var k=this;var j=[];var l={};var g={};var c;var a=function(r){var w=function(s,i){if(l[i]===-1){l[i]=l[s]+1;j.push(i)}};var t=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1;if(y==s){if(w(y,s)){return true}}}};var q=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1==y?A.id2:A.id1;if(w(y,s)){return true}}};var u=function(i){if(e){return t(i)}else{return q(i)}};for(var p=0;p<b.length;p++){l[b[p].id]=-1}l[r]=0;j.push(r);while(j.length){var o=j.shift();u(o)}};var n=function(){var o=Object.keys(l).map(function(q){return l[q]}).filter(function(q){return q!==-1});var p=o.length;var i=o.reduce(function(r,q){return r+q});if(i>0){g[c]=(p-1)/i}else{g[c]=0}};for(var h=0;h<b.length;h++){var d=b[h].layout;if(!d.metrics){d.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};d.edges=this.edgesForNode(this.data.edges,b[h].id)}g[b[h].id]=0}for(var h=0;h<b.length;h++){var d=b[h];c=b[h].id;a(d.id);n()}for(var h=0;h<b.length;h++){var d=b[h].layout;d.metrics.closeness=g[b[h].id]}};this.networkEccentricity=function(b,g){var k=this;var j=[];var l={};var c={};var d;var a=function(r){var w=function(s,i){if(l[i]===-1){l[i]=l[s]+1;j.push(i)}};var t=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1;if(y==s){if(w(y,s)){return true}}}};var q=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1==y?A.id2:A.id1;if(w(y,s)){return true}}};var u=function(i){if(g){return t(i)}else{return q(i)}};for(var p=0;p<b.length;p++){l[b[p].id]=-1}l[r]=0;j.push(r);while(j.length){var o=j.shift();u(o)}};var n=function(){var i=0;Object.keys(l).forEach(function(o){var p=l[o];if(i<p){i=p}});c[d]=i};for(var h=0;h<b.length;h++){var e=b[h].layout;if(!e.metrics){e.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};e.edges=this.edgesForNode(this.data.edges,b[h].id)}c[b[h].id]=0}for(var h=0;h<b.length;h++){var e=b[h];d=b[h].id;a(e.id);n()}for(var h=0;h<b.length;h++){var e=b[h].layout;e.metrics.eccentricity=c[b[h].id]}};this.networkDegree=function(b,d){for(var c=0;c<b.length;c++){var g=b[c].layout;var a=g.edges||this.edgesForNode(this.data.edges,b[c].id);var e=0;switch(d){case"in":for(var c=0;c<a.length;c++){e+=(a[c].id1==b[c].id)?1:0}break;case"out":for(var c=0;c<a.length;c++){e+=(a[c].id2==b[c].id)?1:0}break;default:e=a.length}g.metrics.degree=e}};this.exposeNetworkMetrics=function(){for(var a=0;a<this.data.nodes.length;a++){var b=this.data.nodes[a];if(b.layout){b.betweenness=b.layout.metrics.betweenness;b.closeness=b.layout.metrics.closeness;b.degree=b.layout.metrics.degree;b.eccentricity=b.layout.metrics.eccentricity}}};this.updateForceDirectedLayoutBoundingBox=function(q,h,y,c,w,a){var A=Number.MAX_VALUE;var d=Number.MAX_VALUE;var z=Number.MIN_VALUE;var b=Number.MIN_VALUE;var v,u,t,s;var x=q.length;if(x===0){return}while(x--){var r=q[x];if(!r.hide){if(r.fixed){r.layout.position.x=r.layout.prevPosition.x;r.layout.position.y=r.layout.prevPosition.y}else{r.layout.prevPosition.x=r.layout.position.x;r.layout.prevPosition.y=r.layout.position.y}if(r.layout.position.x<A){A=r.layout.position.x;v=r}if(r.layout.position.x>z){z=r.layout.position.x;u=r}if(r.layout.position.y<d){d=r.layout.position.y;t=r}if(r.layout.position.y>b){b=r.layout.position.y;s=r}}}h.x1=A;h.x2=z;h.y1=d;h.y2=b;return;var C=v.width?v.width:v.size?(this.nodeSize*v.size*this.scaleFactorX):this.nodeSize*this.scaleFactorX;var B=u.width?u.width:u.size?(this.nodeSize*u.size*this.scaleFactorX):this.nodeSize*this.scaleFactorX;var g=t.height?t.height:t.size?(this.nodeSize*t.size*this.scaleFactorY):this.nodeSize*this.scaleFactorY;var e=s.height?s.height:s.size?(this.nodeSize*s.size*this.scaleFactorY):this.nodeSize*this.scaleFactorY;if(!y){y=this.left}if(!w){w=this.left+this.x}if(!c){c=this.top}if(!a){a=this.top+this.y}C=A-(C/2);B=z+(B/2);g=d-(g/2);e=b+(e/2);var k=w-y;var j=a-c;var n=B-C;var l=e-g;var p=k/n;var o=j/l;var x=q.length;while(x--){var r=q[x];if(!r.hide){r.layout.position.x=(r.layout.position.x-C)*p;r.layout.position.y=(r.layout.position.y-g)*o}if(r.fixed){r.layout.position.x=r.layout.prevPosition.x;r.layout.position.y=r.layout.prevPosition.y}else{r.layout.prevPosition.x=r.layout.position.x;r.layout.prevPosition.y=r.layout.position.y}}h.x1=y;h.x2=w;h.y1=c;h.y2=a};this.setFunctionNames("initMathUtils")};CanvasXpress.prototype.initLayout=function(){this.isValidLayout=function(){var b=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){this.layoutRows=b[0];this.layoutCols=b[1]}else{if(this.layout){this.layoutRows=b[0];this.layoutCols=b[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}}if(!this.scatterPlotMatrix&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var q={};for(var o=0;o<this.data.y.vars.length;o++){if(!q[this.data.y.vars[o]]){q[this.data.y.vars[o]]=[]}q[this.data.y.vars[o]].push(o)}var t={};for(var o=0;o<this.data.y.smps.length;o++){if(!t[this.data.y.smps[o]]){t[this.data.y.smps[o]]=[]}t[this.data.y.smps[o]].push(o)}var s=0;var p=this.layoutTypeVariablesFirst;if(this.layoutType=="wrap"||(this.layoutType=="cols"&&p)||this.layoutType=="rows"&&!p){for(var o=0;o<this.data.l.smps.length;o++){var f=[];var e=this.data.l.smps[o].length;for(var m=0;m<e;m++){for(var h=0;h<t[this.data.l.smps[o][m]].length;h++){f.push(t[this.data.l.smps[o][m]][h])}}for(var m=0;m<this.data.l.vars.length;m++){var d=[];var e=this.data.l.vars[m].length;for(var h=0;h<e;h++){for(var g=0;g<q[this.data.l.vars[m][h]].length;g++){d.push(q[this.data.l.vars[m][h]][g])}}this.data.l.comp[s]=[d,f];s++}}}else{for(var o=0;o<this.data.l.vars.length;o++){var d=[];var e=this.data.l.vars[o].length;for(var m=0;m<e;m++){for(var h=0;h<q[this.data.l.vars[o][m]].length;h++){d.push(q[this.data.l.vars[o][m]][h])}}for(var m=0;m<this.data.l.smps.length;m++){var f=[];var e=this.data.l.smps[m].length;for(var h=0;h<e;h++){for(var g=0;g<t[this.data.l.smps[m][h]].length;g++){f.push(t[this.data.l.smps[m][h]][g])}}this.data.l.comp[s]=[d,f];s++}}}}else{if(this.data.l.vars){if(this.isUnique(this.data.y.smps)){var a={};for(var o=0;o<this.data.y.vars.length;o++){if(!a[this.data.y.vars[o]]){a[this.data.y.vars[o]]=[]}a[this.data.y.vars[o]].push(o)}for(var o=0;o<this.data.l.vars.length;o++){this.data.l.comp[o]=[];var e=this.data.l.vars[o].length;for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.l.vars[o][m]].length;h++){this.data.l.comp[o].push(a[this.data.l.vars[o][m]][h])}}}}}else{for(var o=0;o<this.data.l.ids.length;o++){this.data.l.comp[o]=[];var e=this.data.l.ids[o].length;var a={};for(var m=0;m<this.data.l.ids[o].length;m++){if(!a[this.data.y.vars[this.data.l.ids[o][m]]]){a[this.data.y.vars[this.data.l.ids[o][m]]]=[]}a[this.data.y.vars[this.data.l.ids[o][m]]].push(this.data.l.ids[o][m])}for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.y.vars[this.data.l.ids[o][m]]].length;h++){this.data.l.comp[o].push(a[this.data.y.vars[this.data.l.ids[o][m]]][h])}}}}}}else{if(this.isUnique(this.data.y.smps)){var a={};for(var o=0;o<this.data.y.smps.length;o++){if(!a[this.data.y.smps[o]]){a[this.data.y.smps[o]]=[]}a[this.data.y.smps[o]].push(o)}for(var o=0;o<this.data.l.smps.length;o++){this.data.l.comp[o]=[];var e=this.data.l.smps[o].length;for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.l.smps[o][m]].length;h++){this.data.l.comp[o].push(a[this.data.l.smps[o][m]][h])}}}}}else{for(var o=0;o<this.data.l.ids.length;o++){this.data.l.comp[o]=[];var e=this.data.l.ids[o].length;var a={};for(var m=0;m<this.data.l.ids[o].length;m++){if(!a[this.data.y.smps[this.data.l.ids[o][m]]]){a[this.data.y.smps[this.data.l.ids[o][m]]]=[]}a[this.data.y.smps[this.data.l.ids[o][m]]].push(this.data.l.ids[o][m])}for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.y.smps[this.data.l.ids[o][m]]].length;h++){this.data.l.comp[o].push(a[this.data.y.smps[this.data.l.ids[o][m]]][h])}}}}}}}this.layoutValid=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var r=[];for(var o=0;o<this.data.y.vars.length;o++){r.push(o)}for(var o=0;o<this.data.l.type.length;o++){this.data.l.comp[o]=r}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}if(this.layoutValid){this.meta.config.orig.adjustAspectRatio=this.adjustAspectRatio;this.adjustAspectRatio=true}};this.validateLayoutTopology=function(){var a=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){if(this.layoutRows==a[0]&&this.layoutCols==a[1]){return}}else{if(this.layout){if(this.layoutRows==a[0]&&this.layoutCols==a[1]){return}}}this.isValidLayout();var e=1/this.layoutCols;var d=1/this.layoutRows;for(var b=0;b<this.data.l.comp.length;b++){this.data.l.weight[b]=[e,d]}};this.setLayoutFonts=function(){this.setLegends();if(this.graphType=="Scatter2D"){this.set2DFont()}else{if(this.graphType=="Pie"){this.setPieFont()}else{this.set1DFont()}}};this.getLayoutAxisTitleHeight=function(a){var b=0;if(this.graphType=="Treemap"||this.graphType=="TagCloud"||this.graphType=="Pie"||this.graphType=="Heatmap"){return 0}else{if(this.graphType=="Scatter2D"){if(a){return this.yAxisTitle?this.axisTitleFontSize+(this.margin*2):0}else{return this.xAxisTitle?this.axisTitleFontSize+(this.margin*2):0}}else{if(this.graphOrientation=="vertical"){b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}else{b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}}}return b};this.setLayoutLeft=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}if(!this.layoutAdjust||this.scatterPlotMatrixType.match(/correlation|all/)){a+=this.segregateVariablesBy.length||this.segregateSamplesBy.length?this.get2DYAxisTitleWidth():this.get2DYAxisWidth()}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}else{if(this.graphType=="Heatmap"){a=0}else{if(!this.layoutAdjust){if(this.segregateVariablesBy.length>0){if(this.graphOrientation!="vertical"){a=this.getSampleLabelLength()}else{a=this.getAxisTitleTickLength()}}else{if(this.segregateSamplesBy.length>0){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength()}}}}else{if(this.graphOrientation!="vertical"&&this.segregateVariablesBy.length){a=this.getSampleLabelLength()}}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight()}else{a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}}}}}return a};this.setLayoutRight=function(){var a=0;var b=this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1);if(this.isDOE){a=0}else{if(this.graphType.match(/Scatter/)){if(this.showLegend){a=this.legendPosition=="right"&&this.legendWidth?this.legendWidth+(this.margin*2):this.margin}if(this.scatterPlotMatrix&&this.showScatterPlotMatrixLabels&&this.scatterPlotMatrixType!="first"){a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){a+=this.get2DYAxisWidth(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1){a+=this.get2DYAxisWidth(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="wrap"){a+=this.get2DYAxisWidth(true)}else{if(!this.layoutAdjust){a+=this.get2DYAxisWidth(true)}}}}}}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="right"){a=this.legendVariableWidth}}else{if(this.graphType=="Heatmap"){if(this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1)){a+=this.layoutLabelBoxThickness}else{return 0}}else{if(!this.layoutAdjust){if(this.graphOrientation=="vertical"&&!b){a=this.getAxisTitleTickLength(true)}}else{a=0}if(this.graphOrientation=="vertical"&&!b){a+=this.getLayoutAxisTitleHeight(true)}if(this.showLegend&&this.legendPosition=="right"){a+=this.getLegendWidth("right");if(this.graphOrientation!="vertical"){a+=this.margin}}if(b){a+=this.layoutLabelBoxThickness}}}}}return a};this.setLayoutTop=function(){if(this.isDOE){return 0}var a=this.getTitleSubtitleHeight();var b=this.layoutType=="cols"||(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1);if(this.graphType=="Pie"){a+=this.layoutLabelBoxThickness}else{if(this.graphType=="Scatter2D"){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(this.scatterPlotMatrix&&this.showScatterPlotMatrixLabels&&this.scatterPlotMatrixType!="first"){a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1){a+=this.get2DXAxisHeight(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){a+=this.get2DXAxisHeight(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="wrap"){a+=this.get2DXAxisHeight(true)}else{if(!this.layoutAdjust){a+=this.get2DXAxisHeight(true)}}}}}}else{if(this.graphType!="Heatmap"){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(!this.layoutAdjust){if(this.graphOrientation!="vertical"&&!b){a+=this.getAxisTitleTickLength()}}if(this.graphOrientation!="vertical"&&!b){a+=this.getLayoutAxisTitleHeight()}}if(b){a+=this.layoutLabelBoxThickness}}}return a};this.setLayoutBottom=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(!this.layoutAdjust||this.scatterPlotMatrixType.match(/correlation|all/)){a=this.segregateVariablesBy.length||this.segregateSamplesBy.length?this.get2DXAxisTitleHeight():this.get2DXAxisHeight()}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.legendHeight}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="bottom"){}}else{if(this.graphType=="Heatmap"){a=this.getHeatmapIndicatorHeight()}else{if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a=this.getAxisTitleTickLength(true)}}if(this.graphOrientation=="vertical"){if(this.segregateVariablesBy.length>0){a=this.getSampleLabelLength()}a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}else{a+=this.getLayoutAxisTitleHeight(this.layoutType=="cols"?false:true)}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.getLegendHeight("bottom")}}}}}return a};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.setLayoutDimensions=function(){var c=this.isGroupedData;this.offsetX=0;this.offsetY=0;this.isGroupedData=false;this.setLayoutFonts();this.setLayoutLegendDimensions();this.isGroupedData=c;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom();if(this.layoutCanvasCompartments){var a=this.width-(this.marginLeft+this.layoutLeft+this.marginRight+this.layoutRight);var b=this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom);this.addToRender(["drawShape","rectangle",this.marginLeft+this.layoutLeft+(a/2),this.marginTop+this.layoutTop+(b/2),a,b,false,this.canvasBoxColor,"open"])}};this.setLayoutLegendDimensions=function(){if(this.graphType=="Pie"||this.isDOE){this.setVariableLegendDimension()}else{if(this.graphType=="Scatter2D"||this.isMultidimensionalData||((this.isAttributedGraph()||this.connectBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|Heatmap/))){this.validatePropertyValues(true)}else{this.setVariableLegendDimension()}}};this.drawLabelsTitlesLayout=function(){this.functionCaller="drawLabelsTitlesLayout";var k=0;var f=0;var q=0;var C=0;var D=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.graphType=="Treemap"){return}if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var z,m;var A=0;this.setFont();var s=this.getFontPt(this.font);var d=this.marginTop;var a=this.marginLeft+this.layoutLeft;var n=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var v=0;v<this.layoutRows;v++){z=b*this.layoutParams[A].weight[1];k=(this.marginLeft+this.layoutLeft)-this.margin;d+=z;if(this.showPieGrid){this.addToRender(["drawText",n[v],k,d-((z/2)+(this.margin*0)),this.font,this.foreground,"right","middle"])}for(var u=0;u<this.layoutCols;u++){if(this.xAxis.length<=A){break}m=D*this.layoutParams[A].weight[0];a+=m;f=(this.marginTop+this.layoutTop)-(this.layoutLabelBoxThickness/2);if(v==0){if(this.showPieGrid){this.addToRender(["drawText",u+1,(a+(s/2))-(m/2),f,this.font,this.foreground,"center","bottom"])}}if(this.showPieSampleLabel){this.addToRender(["drawText",this.xAxis[A],a-(m/1.1),d-(z/5),this.legendFont,this.foreground,"center","middle"])}A++}a=this.marginLeft+this.layoutLeft}}else{if(this.graphType=="Scatter2D"){if(this.yAxisTitle){var B=((this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom))/2)+(this.marginTop+this.layoutTop);var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+((this.showLegend&&this.legendPosition=="left"?this.legendWidth:0)-this.margin);this.addToRender(["drawText",this.yAxisTitle,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}if(this.xAxisTitle){var t=0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t+(this.showLegend&&this.legendPosition=="bottom"?this.legendHeight:0);this.addToRender(["drawText",this.xAxisTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}else{if(this.graphType=="Heatmap"){this.draw1DXLayout()}if(this.smpTitle&&this.graphType!="Heatmap"){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="bottom"?this.legendHeight:0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.smpTitleFontSize/2)+t;this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.smpTitleFont,this.smpTitleFontColor,"center","middle"])}else{this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.margin+(this.smpTitleFontSize/2),this.height/2,this.smpTitleFont,this.smpTitleFontColor,"center","middle",-Math.PI/2])}}var g=this.getAxisDescription();var e=this.getAxisDescription(true);if(g!=""&&this.graphType!="Heatmap"&&this.xAxisShow){if(this.graphOrientation=="vertical"){var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+(this.showLegend&&this.legendPosition=="left"?this.legendWidth:0);var B=((this.height-this.layoutTop)/2)+this.layoutTop;this.addToRender(["drawText",g,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}else{var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z;if(this.layoutType=="cols"){z=this.marginTop+this.layoutTop+this.layoutHeight+this.getTitleSubtitleHeight()}else{z=this.margin+(this.axisTitleFontSize/2)+this.getTitleSubtitleHeight()+(this.showLegend&&this.legendPosition=="top"?this.legendHeight:0)}this.addToRender(["drawText",g,this.marginLeft+this.layoutLeft+(m/2),this.marginTop+z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}if(e!=""&&this.graphType!="Heatmap"&&this.xAxis2Show){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="right"?this.legendWidth:0;var p=this.marginRight+this.margin+(this.axisTitleFontSize/2)+t;this.addToRender(["drawText",e,this.width-p,this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",Math.PI/2])}else{var t=this.legendPosition=="bottom"?this.legendHeight:0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t;this.addToRender(["drawText",e,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}}}};this.drawDOELabelsLayout=function(m){this.functionCaller="drawDOELabelsLayout";var g=this.foreground;var j=this.font;var e=this.measureText(m,j);var b=this.getFontPt(j)/2;var l=this.layoutWidth;var d=this.layoutHeight;var k=this.marginLeft+this.offsetX;var i=this.marginTop+this.offsetY;var a=k+l-5;var c=i+d-5;this.addToRender(["drawText",m,k+20,i,j,g,"left","top"]);this.addToRender(["drawLine","line",k+b,i+b,k+15,i+b,g]);this.addToRender(["drawLine","line",k+e+25,i+b,a,i+b,g]);this.addToRender(["drawLine","line",a,i+b,a,c,g]);this.addToRender(["drawLine","line",k+b,c,a,c,g]);this.addToRender(["drawLine","line",k+b,i+b,k+b,c,g])};this.setLayoutWeights=function(){var a=this.data.l.weight;var d=this.layoutParams;var e=this.data.l.comp;if(a){if(this.isDOE||this.scatterPlotMatrix||(this.data.l.vars&&this.data.l.smps)){for(var b=0;b<a.length;b++){d[b].weight=a[b]}}else{if(this.graphType=="Pie"){for(var b=0;b<e.length;b++){d[b].weight=a[b]}}else{for(var b=0;b<a.length;b++){d[b].weight=a[b]}}}}else{if(e){a=[];for(var b=0;b<e.length;b++){a[b]=e.length;d[b].weight=a[b]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setLayoutGraphTypes=function(){var b=this.data.l.type;if(b){for(var a=0;a<b.length;a++){this.layoutParams[a].graphType=b&&b[a]?b[a]:this.graphType}}};this.setLayoutIndices=function(f){if(!this.layoutIndices){for(var d=0;d<this.data.l.comp.length;d++){var a;var b=this.getObjectArray(this.varIndices);var e=this.getObjectArray(this.smpIndices);if(this.data.l.vars&&this.data.l.smps){a=[];var b=this.getObjectArray(this.data.l.comp[d][0]);for(var c=0;c<this.varIndices.length;c++){if(b.hasOwnProperty(this.varIndices[c])){a.push(this.varIndices[c])}}this.layoutParams[d].varIndices=a;a=[];var e=this.getObjectArray(this.data.l.comp[d][1]);for(var c=0;c<this.smpIndices.length;c++){if(e.hasOwnProperty(this.smpIndices[c])){a.push(this.smpIndices[c])}}this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.layoutParams[d].smpIndices)}else{if(this.data.l.comp[d]){a=[];if(this.data.l.vars){var b=this.getObjectArray(this.data.l.comp[d]);for(var c=0;c<this.varIndices.length;c++){if(b.hasOwnProperty(this.varIndices[c])){a.push(this.varIndices[c])}}this.layoutParams[d].varIndices=a;this.layoutParams[d].smpIndices=this.smpIndices;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.smpIndices)}else{var e=this.getObjectArray(this.data.l.comp[d]);for(var c=0;c<this.smpIndices.length;c++){if(e.hasOwnProperty(this.smpIndices[c])){a.push(this.smpIndices[c])}}this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.varIndices,this.layoutParams[d].smpIndices)}}else{if(this.data.l.vars){this.layoutParams[d].varIndices=[];this.layoutParams[d].smpIndices=this.smpIndices}else{this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=[]}}}this.layoutParams[d].varIndicesStart=-1;this.layoutParams[d].smpIndicesStart=-1}for(var d=0;d<this.data.l.type.length;d++){for(var c=0;c<f.length;c++){if(!this.layoutParams[d].hasOwnProperty(f[c])){this.layoutParams[d][f[c]]=this[f[c]]}}}this.layoutIndices=false}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutValidBounds=false;this.layoutCurrent=false;this.layoutComb=false;this.layoutIndices=false;this.layoutRestore=false;this.layout="1X1";this.resetAspectRatioProperties()};this.setDOE=function(){this.oneDPlot(true);this.Scatter2D(true);this.Scatter3D(true);this.Pie(true)};this.resetLayoutRestore=function(){this.layoutRestore=false};this.setLayoutRestore=function(){if(!this.layoutRestore){this.layoutRestore={};var c=["title","subtitle","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","smpTitle","showVariableNames","showSampleNames","showOverlays","showLegend","legendInside","showDecorationsLegend","xAxisShow","xAxis2Show","xAxisS2Show","yAxisShow","yAxisS2Show","xAxisTitle","xAxis2Title","yAxisTitle","legendLayout"];c.push("legendDecorationWidth");c.push("legendDecorationHeight");var a=["Color","Shape","Size","Pattern","Connect","Sample"];for(var b=0;b<a.length;b++){c.push("legend"+a[b]+"s");c.push("legend"+a[b]+"sMax");c.push("legend"+a[b]+"sN");c.push("legend"+a[b]+"sS");c.push("legend"+a[b]+"Width");c.push("legend"+a[b]+"Height")}for(var b=0;b<c.length;b++){this.layoutRestore[c[b]]=this[c[b]]}if(this.isGroupedData&&this.data.w){this.layoutRestore.isGroupedData=this.isGroupedData}}};this.setLayoutParams=function(){if(!this.layoutParams&&this.data.l.comp){this.layoutParams=[];for(var a=0;a<this.data.l.type.length;a++){this.layoutParams[a]={}}}};this.removeEmptyCompartments=function(){if(this.layoutRemoveEmpty&&this.layoutParams&&!this.isDOE){var f={};var d=[];var g=["comp","desc","name","type","vars","smps","weight"];var h=0;for(var c=0;c<g.length;c++){if(this.data.l[g[c]]){f[g[c]]=[]}}for(var c=0;c<this.data.l.weight.length;c++){var b=this.layoutParams[c].varIndices.length;var e=this.layoutParams[c].smpIndices.length;if(b&&e){d.push(this.layoutParams[c]);for(var a=0;a<g.length;a++){if(this.data.l[g[a]]){f[g[a]].push(this.data.l[g[a]][c])}}if(this.data.l.group){f.group=this.data.l.group}h++}}if(h!=this.data.l.weight.length){this.stndByLayoutData={};this.stndByLayoutData.data=this.cloneObject(this.data.l);this.stndByLayoutData.pars=this.cloneObject(this.layoutParams);this.stndByLayoutData.layoutRows=this.layoutRows;this.stndByLayoutData.layoutCols=this.layoutCols;this.stndByLayoutData.layout=this.layout;this.data.l=f;this.layoutParams=d;this.layoutRows=Math.ceil(Math.sqrt(h));this.layoutCols=this.layoutRows*(this.layoutRows-1)>=h?this.layoutRows-1:this.layoutRows;this.layout=this.layoutRows+"X"+this.layoutCols;for(var c=0;c<this.data.l.weight.length;c++){this.data.l.weight[c]=[1/this.layoutCols,1/this.layoutRows]}}}};this.restoreEmptyCompartments=function(){if(this.stndByLayoutData){this.data.l=this.stndByLayoutData.data;this.layoutParams=this.stndByLayoutData.pars;this.layoutRows=this.stndByLayoutData.layoutRows;this.layoutCols=this.stndByLayoutData.layoutCols;this.layout=this.stndByLayoutData.layout;delete (this.stndByLayoutData)}};this.getLayoutAxisSamples=function(c){if(this.data.l.smps){var e={};var b=c=="x"?0:1;for(var d=0;d<this.data.l.smps.length;d++){if(this.data.l.smps[d]&&(this.data.l.smps[d][b]||this.data.l.smps[d][b]==0)){e[this.data.l.smps[d][b]]=true}else{if(this.data.l.smps[d][c+"Axis"]){e[this.data.l.smps[d][c+"Axis"]]=true}}}return this.getKeys(e)}else{if(this[c+"Axis"].length>0){return this[c+"Axis"]}else{return this.data.y.smps}}};this.preCalculateAdjustLayout=function(f){if(this.layoutAdjust&&!this.isDOE&&this.graphType!="Pie"){delete this.xAxisLayoutMaxTickStr;delete this.xAxisLayoutMaxTickStrLength;delete this.xAxis2LayoutMaxTickStr;delete this.xAxis2LayoutMaxTickStrLength;delete this.yAxisLayoutMaxTickStr;delete this.yAxisLayoutMaxTickStrLength;var a=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var g=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;var l=0;for(var e=0;e<this.layoutRows;e++){for(var d=0;d<this.layoutCols;d++){this.layoutCurrent=l;if(this.layoutParams.length<=l){break}if(this.layoutParams[l]){for(var b=0;b<f.length;b++){this[f[b]]=this.layoutParams[l].hasOwnProperty(f[b])?this.layoutParams[l][f[b]]:this[f[b]]}}this.setLayoutGraphDimensions(a,g,l);if(this.graphType.match(/Scatter/)||this.scatterPlotMatrix){this.drawLayoutCompartmentsScatter(a,g,e,d,l)}else{this.drawLayoutCompartmentsOneD(a,g,l)}l++}}this.restoreLayoutParameters();this.title="";this.subtitle=""}};this.drawLayoutCompartments=function(b){this.functionCaller="drawLayoutCompartments";var C=["left","right","top","bottom","x","y","offsetX","offsetY","graphType","summaryType","transformType","smpInfo","varInfo","minData","maxData","xAxisMin","xAxisMax","xAxisRange","xAxis2Min","xAxis2Max","xAxis2Range","yAxisMin","yAxisMax","yAxisRange","zAxisMin","zAxisMax","zAxisRange","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit"];var u=["layoutTop","layoutRight","layoutBottom","layoutLeft","layoutWidth","layoutHeight","layoutValid","layoutComb","offsetX","offsetY"];var f=["weight","graphType","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];if(this.layoutComb){this.validateLayoutTopology();if(this.isDOE){C.push("data");this.setDOE()}this.removeEmptyCompartments();if(this.graphType.match(/Scatter/)){this.xAxisTmp=this.cloneObject(this.xAxis);this.yAxisTmp=this.cloneObject(this.yAxis);this.xAxis=this.getLayoutAxisSamples("x");this.yAxis=this.getLayoutAxisSamples("y");this.initAxes();this.xAxis=this.xAxisTmp;this.yAxis=this.yAxisTmp;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{if(this.data.l&&this.data.l.group){this.groupSamples(this.data.l.group,false,false,true,true);this.meta.data.g=this.data.w;this.initAxes()}else{this.initAxes(true)}}this.setLayoutDimensions();var g=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var z=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;this.setLayoutRestore();this.setLayoutParams();this.title="";this.subtitle="";this.offsetX=this.layoutLeft;this.offsetY=this.graphType=="Pie"?0:this.layoutTop;this.setLayoutWeights();this.setLongestLayoutLabel();this.setLayoutGraphTypes();this.setLayoutIndices(f);this.preCalculateAdjustLayout(f);var B=0;for(var y=0;y<this.layoutRows;y++){for(var v=0;v<this.layoutCols;v++){this.layoutCurrent=B;if(this.isDOE){if(this.dataStndBy.l.smps.length<=B){break}}else{if(this.graphType=="Pie"){if(this.data.l.smps.length<=B){break}}else{if(this.layoutParams.length<=B){break}}}if(this.layoutParams[B]){for(var t=0;t<f.length;t++){this[f[t]]=this.layoutParams[B].hasOwnProperty(f[t])?this.layoutParams[B][f[t]]:this[f[t]]}}this.setLayoutGraphDimensions(g,z,B);if(this.isDOE){this.drawLayoutCompartmentsDOE(g,z,B)}else{if(this.graphType.match(/Scatter/)||(this.graphType.match(/Boxplot/)&&this.scatterPlotMatrix)){this.drawLayoutCompartmentsScatter(g,z,y,v,B)}else{if(this.graphType=="Pie"){this.drawLayoutCompartmentsPie(g,z,B)}else{if(!this.scatterPlotMatrix){this.drawLayoutCompartmentsOneD(g,z,B)}}}}var D={};if(this.layoutConfig[B]){for(var q in this.layoutConfig[B]){D[q]=this.cloneObject(this[q]);this[q]=this.layoutConfig[B][q]}}if(!this.isDOE&&this.varIndices.length>0&&this.smpIndices.length>0){if(this.scatterPlotMatrix){if(this.scatterPlotMatrixType.match(/correlation|all/)){if(v>y){if(this.scatterPlotMatrixType.match(/all/)&&v==this.layoutCols-1){var A=this.data.l.data[B];var n=this.data.l.params[B];if(A&&n){var o={};for(var q in n){o[q]=this[q];this[q]=n[q]}this.initializeData(A);this.initAxes();b.call(this);for(var q in o){this[q]=o[q]}this.switchData(false,true)}}}else{if(v==y||(y==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){var l=y==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/)?v:y;if(B==0){this.removeHistogram(true)}var m=this.data.l.group&&this.meta.data.d.z[this.data.l.group]&&this.meta.data.d.z[this.data.l.group][l]&&this.meta.data.d.z[this.data.l.group][l][this.data.y.smps[this.smpIndices[l]]]?this.meta.data.d.z[this.data.l.group][l][this.data.y.smps[this.smpIndices[l]]]:this.meta.data.d.s[l]?this.meta.data.d.s[l]:false;if(m){this.data.l.data[B]=m.data;for(var q in m.params){this[q]=m.params[q]}if(this.scatterPlotMatrixType.match(/all/)&&v==y){this.hideHistogram=true;this.showHistogramDensity=true}var o=[];for(var q=0;q<u.length;q++){o.push(this[u[q]])}if(this.scatterPlotMatrixType.match(/Histogram|Density|all/)){this.initializeData(m.data)}this.initAxes();b.call(this);this.removeHistogram(true);for(var q=0;q<u.length;q++){this[u[q]]=o[q]}if(this.scatterPlotMatrixType.match(/all/)&&v==y){this.hideHistogram=false;this.showHistogramDensity=false}}else{if(this.scatterPlotMatrixType=="correlation"&&y==0){b.call(this)}}}else{b.call(this)}}}else{b.call(this)}}else{b.call(this)}}if(this.layoutConfig[B]){for(var q in this.layoutConfig[B]){this[q]=D[q]}}for(var t=0;t<C.length;t++){this.layoutParams[B][C[t]]=this.cloneObject(this[C[t]])}if(this.data.w){this.layoutParams[B].w=this.cloneObject(this.data.w)}if(this.layoutCanvasCompartments){this.drawLayoutCanvasCompartments()}if(this.isDOE||this.graphType=="Pie"){}else{if(this.graphType.match(/Scatter/)||(this.graphType.match(/Boxplot/)&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/all/))){if(this.scatterPlotMatrix||this.segregateVariablesBy.length||this.segregateSamplesBy.length){this.drawTrellisLabels(B,y,v,g)}}else{if(!this.layoutAdjust){var e=this.graphOrientation=="vertical"?v:y;var d=this.graphOrientation=="vertical"?this.layoutCols-1:this.layoutRows-1;var r=this.graphOrientation=="vertical"&&(this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1));var a=this.graphOrientation!="vertical"&&(this.layoutType=="cols"||(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1));if(e==0&&this.layoutRestore.xAxisShow&&this.graphType!="Heatmap"&&!a){this.layoutAxis=1;this.xAxisShow=true;this.draw1DXLayout()}if(e==d&&this.layoutRestore.xAxis2Show&&this.graphType!="Heatmap"&&!r){this.layoutAxis=2;this.xAxis2Show=true;this.draw1DXLayout()}}if(this.segregateVariablesBy.length){var s=false;if(this.graphOrientation=="vertical"){if(y==this.layoutRows-1){s=true}else{if(y==this.layoutRows-2&&(B+1+parseInt(this.layoutCols))>this.data.l.weight.length){s=true}}}else{if(v==0){s=true}}if(s){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}}this.drawTrellisLabels(B,y,v)}}this.offsetX+=this.layoutWidth;B++}this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}this.layoutCurrent=false;this.restoreLayoutParameters();if(this.isDOE){this.data=this.dataStndBy;this.graphType=this.data.l.type[0]}else{this.drawTitle();this.drawLabelsTitlesLayout();if(this.showLegend){if(this.isDOE||this.graphType!="Pie"){this.drawLegend(true)}}}if(this.meta.data.g){this.data.w=this.meta.data.g;delete (this.meta.data.g)}else{this.isGroupedData=false}}};this.restoreLayoutParameters=function(){for(var a in this.layoutRestore){this[a]=this.layoutRestore[a]}};this.setLayoutGraphDimensions=function(a,b,d){this.layoutWidth=(this.width-a)*this.layoutParams[d].weight[0];this.layoutHeight=(this.height-b)*this.layoutParams[d].weight[1];this.layoutParams[d].width=this.layoutWidth;this.layoutParams[d].height=this.layoutHeight};this.setLongestLayoutLabel=function(){var a=[];if(this.scatterPlotMatrix){}else{if((this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0)||(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1)){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b][0]);a.push(this.data.l.name[b][1])}}else{if(this.data.l.name){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b])}}}this.longestLayoutLabel=this.getMaxText(a)}};this.setLayoutLabels=function(a){this.layoutLabels=[];if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.layoutLabels.push(this.data.l.name[a][this.graphType=="Scatter2D"?1:0]);this.layoutLabels.push(this.data.l.name[a][this.graphType=="Scatter2D"?0:1])}else{if(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1){this.layoutLabels.push(this.data.l.name[a][this.graphType=="Scatter2D"?0:1]);this.layoutLabels.push(this.data.l.name[a][this.graphType=="Scatter2D"?1:0])}else{if(this.scatterPlotMatrix){}else{this.layoutLabels.push(this.data.l.name[a])}}}};this.drawLayoutCompartmentsDOE=function(a,b,d){this.functionCaller="drawLayoutCompartmentsDOE";this.legendPosition="right";this.graphOrientation="vertical";if(d==0&&this.showDOEData){this.isShowDOEData=true;this.showLegend=this.layoutRestore.showLegend;if(this.graphType.match(/Scatter/i)){this.isHistogram=false;this.xAxis=this.configStndBy.xAxis;this.yAxis=this.configStndBy.yAxis;this.xAxisTitle=this.configStndBy.xAxisTitle;this.yAxisTitle=this.configStndBy.yAxisTitle;this.initAxes();this.initializeData(this.dataStndBy);this.varIndices=this.dataStndBy.l.doe}else{this.initializeData(this.dataStndBy);this.smpIndices=this.dataStndBy.l.doe}this.showLegend=false;if(this.graphType=="Scatter3D"){this.draw3DPlot()}else{if(this.graphType.match(/Scatter/i)){this.draw2DPlot()}else{this.plotByVariable=this.configStndBy.plotByVariable;if(this.configStndBy.groupingFactors.length>0){this.isGroupedData=true;if(this.dataStndBy.y.smps.length!=this.smpIndices.length){this.layoutComb=false;this.groupSamples(this.configStndBy.groupingFactors,false,false,true,true);this.layoutComb=true}this.draw1DPlot();this.isGroupedData=false;this.groupingFactors=[]}else{this.draw1DPlot()}this.plotByVariable=false}}this.showLegend=true;this.isShowDOEData=false}else{this.drawDOELabelsLayout(this.dataStndBy.l.smps[d][0]);this.top=5;this.bottom=5;this.right=5;this.left=5;if(this.dataStndBy.l.type[d]=="Pie"){this.showLegend=false;this.createPie(this.dataStndBy.l.smps[d][0]);this.graphType="Pie";this.layoutCurrentDOE=this.dataStndBy.l.smps[d][0];this.legendBox=false;this.drawPiePlot()}else{if(this.dataStndBy.l.type[d]=="Treemap"){this.createTreemap(this.dataStndBy.l.smps[d][0]);this.graphType="Treemap";this.draw1DPlot()}else{if(this.dataStndBy.l.type[d]=="Scatter2D"){this.createHistogram(this.dataStndBy.l.smps[d][0]);this.graphType="Scatter2D";this.initAxes();this.showLegend=false;this.xAxisTitle="";this.yAxisTitle="";this.draw2DPlot()}}}}};this.drawLayoutCompartmentsScatter=function(a,e,d,b,g){this.functionCaller="drawLayoutCompartmentsScatter";if(this.segregateVariablesBy.length&&this.segregateSamplesBy.length){this.xAxis=[this.data.l.smps[Math.floor(g/this.data.l.smps.length)][0]];this.yAxis=[this.data.l.smps[Math.floor(g/this.data.l.smps.length)][1]];this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(g)}else{if(this.data.l.smps&&this.data.l.smps[g].xAxis&&this.data.l.smps[g].yAxis){this.xAxis=this.data.l.smps[g].xAxis;this.yAxis=this.data.l.smps[g].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{if(!this.scatterPlotMatrix&&this.data.l.smps&&this.data.l.smps[g]){this.xAxis=[this.data.l.smps[g][0]];if(this.isQQ){this.yAxis=[this.data.l.smps[g][0]]}else{this.yAxis=[this.data.l.smps[g][1]]}this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(g)}else{if(this.data.l.vars&&this.data.l.vars[g]){this.setLayoutLabels(g)}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}}}}if(this.layoutAdjust&&this.xAxis&&this.yAxis){this.initAxes();this.layoutAxis=3}else{this.layoutAxis=b==0?2:0;this.layoutAxis=d==this.layoutRows&&this.layoutAxis?3:d==this.layoutRows?1:0}if(this.isQQ){this.setAxes("qq")}else{if(this.isCDF){this.setAxes("cdf")}}if(this.data.l.reg){if(this.data.l.reg[g]){if(this.decorations){delete (this.decorations)}for(var f=0;f<this.data.l.reg[g].length;f++){this.addRegressionDecoration(this.data.l.reg[g][f].reg,this.data.l.reg[g][f].cor,this.data.l.reg[g][f].lab,this.data.l.reg[g][f].col,this.data.l.reg[g][f].fit,this.data.l.reg[g][f].id,this.data.l.reg[g][f].n)}}}this.showLegend=false;this.legendInside=true;this.showDecorationsLegend=true;this.xAxisTitle="";this.yAxisTitle="";if(!this.layoutAdjust||this.scatterPlotMatrixType.match(/correlation|all/)){this.xAxisShow=false;this.yAxisShow=false;this.xAxisS2Show=false;this.yAxisS2Show=false;if(d==0&&b%2>0){this.xAxisS2Show=true}if(d==this.layoutRows-1&&(b%2==0||this.scatterPlotMatrixType.match(/correlation|all/))){this.xAxisShow=true}if(b==0&&(d%2>0||this.scatterPlotMatrixType.match(/correlation|all/))){if(d==0||(d==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){this.yAxisShow=false}else{this.yAxisShow=true}}if(b==this.layoutCols-1&&d%2==0&&!this.scatterPlotMatrixType.match(/correlation|all/)){this.yAxisS2Show=true}}this.xAxisMajorTicks=true;this.yAxisMajorTicks=true;if((d==b&&this.scatterPlotMatrixType.match(/correlation|all/))||(d==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){this.xAxisMajorTicks=false;this.yAxisMajorTicks=false}};this.drawLayoutCompartmentsPie=function(a,b,d){this.functionCaller="drawLayoutCompartmentsPie";this.smpIndices=[this.getSampleIndices(this.data.l.smps[d])];this.showLegend=true};this.drawLayoutCompartmentsOneD=function(b,e,f){this.functionCaller="drawLayoutCompartmentsOneD";this.showLegend=false;this.showOverlays=true;this.isGroupedData=false;this.xAxisTitle=false;this.xAxis2Title=false;this.smpTitle=false;this.adjustAspectRatioXTries=0;this.adjustAspectRatioYTries=0;this.setLayoutLabels(f);if(this.varIndices.length>0&&this.smpIndices.length>0){if(this.data.l.group){var a=this.layoutParams[f].dragged?this.layoutParams[f].grpIndices:false;this.groupSamples(this.data.l.group,false,a,true,true,true);this.layoutParams[f].grpIndices=this.grpIndices;if(this.colorBy&&this.isInArray(this.colorBy,this.groupingFactors)&&this.layoutRestore.showLegend){}if(this.data.w.smps.length==1&&this.graphType!="Heatmap"&&this.isInArray(this.data.l.group,this.segregateSamplesBy)){this.showSampleNames=false}if(this.hiddenGrpsLayout){if(this.hiddenGrps.length==1){if(this.hiddenGrpsLayout[f]){this.hiddenGrps[0]=true}}else{for(var d=0;d<this.hiddenGrps.length;d++){if(this.hiddenGrpsLayout[d]){this.hiddenGrps[d]=true}}}}}else{if(this.smpIndices.length==1&&this.graphType!="Heatmap"){}}if(this.segregateVariablesBy.length>0&&this.graphType!="Heatmap"){this.showSampleNames=false}if(this.layoutAdjust){this.layoutAxis=3;if(this.varIndices.length>0&&this.smpIndices.length>0){this.initAxes()}}else{if(this.graphOrientation=="vertical"){this.xAxisShowLayout=!(f%this.layoutCols)?true:false}else{this.xAxisShowLayout=f<this.layoutCols?true:false;this.xAxis2ShowLayout=f>=this.layoutCols*(this.layoutRows-1)?true:false}this.xAxisShow=false;this.xAxis2Show=false}}};this.drawTrellisLabels=function(R,A,O,S){this.functionCaller="drawTrellisLabels";var n=this;if(this.scatterPlotMatrix){var o=this.yAxisTopBottomTickColor||this.foreground;var L=R==0?this.margin:0;switch(this.scatterPlotMatrixType){case"first":if(this.data.y.smps[R+1]){var P=this.layoutLabelBoxThickness;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr+" & "+this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.8/this.layoutCols,P);if(this.layoutBoxLabelColors[0]){this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,this.layoutBoxLabelColors[0],this.foreground])}else{this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,false,this.foreground,"open"])}this.addToRender(["drawText",this.data.y.smps[0]+" & "+this.data.y.smps[R+1],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),C,this.foreground,"center","middle"])}break;case"both":case"upper":case"lower":case"correlation":if(A==O){var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,this.foreground,"open"]);this.addToRender(["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),C,this.foreground,"center","middle"])}else{if(O>A&&this.scatterPlotMatrixType=="correlation"){var j=this.meta.data.c;var H=this.data.y.smps[this.smpIndices[A]]+"::"+this.data.y.smps[this.smpIndices[O]];var e=this.colorBy&&j.z[this.colorBy]&&j.z[this.colorBy][H]?j.z[this.colorBy][H]:j.s[H]?j.s[H]:false;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.drawPlotWindow();this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"]);if(e){var g=this.y/(e.length+1);for(var K=0;K<e.length;K++){var T=this.formatNumber(e[K].cor,3);var k=e[K].col;var G=(K+1)*g;this.addToRender(["drawText",T,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+G,C,k,"center","middle"])}}}}break;case"correlationHistogram":case"correlationDensity":case"all":if(this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1&&A==this.layoutRows-1){break;this.drawPlotWindow();this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"])}if(this.showScatterPlotMatrixLabels){var P=this.layoutLabelBoxThickness;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.fontSize,Math.min(this.layoutWidth,this.layoutHeight),P);if(A==0){var E=this.data.z&&this.data.z.hasOwnProperty(this.scatterPlotMatrix)?this.scatterPlotMatrix:"Variation";var H=this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1?E:this.data.y.smps[O];this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,false,this.foreground,"open"]);this.addToRender(["drawText",H,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),C,this.foreground,"center","middle"])}if(O==this.layoutCols-1){this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+this.x+(P/2),this.marginTop+this.offsetY+this.top+(this.y/2),P,this.y,false,this.foreground,"open"]);this.addToRender(["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+this.x+(P/2),this.marginTop+this.offsetY+this.top+(this.y/2),C,this.foreground,"center","middle",Math.PI/2])}}else{if(A==O){var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);var P=this.layoutLabelBoxThickness;this.addToRender(["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+P,C,this.foreground,"center","middle"])}}if(O>A){if(this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1){break}var j=this.meta.data.c;var H=this.data.y.smps[this.smpIndices[A]]+"::"+this.data.y.smps[this.smpIndices[O]];var e=this.colorBy&&j.z[this.colorBy]&&j.z[this.colorBy][H]?j.z[this.colorBy][H]:j.s[H]?j.s[H]:false;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.drawPlotWindow();this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"]);if(e){var g=this.y/(e.length+1);for(var K=0;K<e.length;K++){var T=this.formatNumber(e[K].cor,3);var k=e[K].col;var G=(K+1)*g;this.addToRender(["drawText",T,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+G,C,k,"center","middle"])}}}break}}else{if(this.layoutValid&&this.layoutLabelShow){var J=function(){var c=n.marginLeft+n.offsetX;if(n.layoutCollapse||(n.layoutType!="wrap"&&n.graphOrientation=="horizontal"&&!n.graphType.match(/Scatter/))){return c+(n.layoutCollapse?0:n.margin)}else{if(n.graphType=="Scatter2D"&&(n.isQQ||n.isCDF)||n.layoutType!="wrap"){return c+n.margin}else{return c+n.left}}};var a=function(){var c=n.marginTop+n.offsetY;if(n.layoutCollapse||(n.layoutType!="wrap"&&n.graphOrientation=="horizontal"&&!n.graphType.match(/Scatter/))){return c}else{return c+(n.top-(n.layoutLabels.length*Q*(n.layoutType=="wrap"?1:0)))}};var b=function(){var c=n.layoutWidth;if(n.layoutCollapse){return c}else{if(n.graphType=="Scatter2D"){return c-n.margin}else{if(n.layoutType!="wrap"){return c-(n.margin*(n.graphOrientation=="horizontal"?1:2))}else{return c-(n.margin*2)}}}};var v=function(){var c=n.layoutHeight;if(n.layoutCollapse){return c}else{if(n.graphType=="Scatter2D"){return c-n.margin}else{if(n.layoutType!="wrap"){return c-(n.margin*(n.graphOrientation=="horizontal"?1:2))}else{return c-n.margin}}}};var s=this.layoutCollapse||this.layoutType!="wrap";var Q=this.layoutLabelBoxThickness;var I=J()+0.5;var B=a()+0.5;var u=b();var M=v();var F=u/2;var N=this.layoutLabels.length?this.scaleTextToFont(this.longestLayoutLabel,this.fontSize,u,M):this.font;var D=this.layoutBoxShow?this.foreground:"rgba(0,0,0,0)";var p=1;if(this.layoutType=="wrap"){for(var K=0;K<this.layoutLabels.length;K++){if(this.layoutBoxLabelColors[K]){this.addToRender(["drawShape","box",I+(u/2),B+(Q/2)+(Q*K),u,Q,this.layoutBoxLabelColors[K],this.layoutBoxShow?this.foreground:this.layoutBoxLabelColors[K]])}else{this.addToRender(["drawShape","box",I+(u/2),B+(Q/2)+(Q*K),u,Q,this.background,this.background])}}}else{if(this.layoutType=="cols"){if(this.layoutLabels.length>1){}}else{if(this.layoutType=="rows"){if(this.layoutLabels.length>1){}}}}if(n.graphType=="Scatter2D"){if(this.layoutType=="wrap"){this.addToRender(["drawShape","box",I+(u/2),B+(this.layoutLabels.length*Q/2),u,this.layoutLabels.length*Q,false,D,"open",false,p])}}else{this.addToRender(["drawShape","box",I+(u/2),B+(M/2),u,M,false,D,"open"])}if(this.layoutType=="wrap"){for(var K=0;K<this.layoutLabels.length;K++){this.addToRender(["drawText",this.layoutLabels[K],I+F,B+(Q/2)+(Q*K),N,this.layoutLabelColor,"center","middle"]);var r=B+Q+(Q*K);this.addToRender(["drawLine","line",I,r,I+u,r,D])}}else{if(this.layoutType=="cols"){if(A==0){this.addToRender(["drawText",this.layoutLabels[this.layoutLabels.length>1?1:0],I+F,B-(Q/2),N,this.layoutLabelColor,"center","middle"]);this.addToRender(["drawShape","box",I+(u/2),B-(Q/2),u,Q,false,D,"open",false,p],false,false,null,true)}if(this.layoutLabels.length>1&&Number(O)+1==this.layoutCols){this.addToRender(["drawText",this.layoutLabels[0],I+u+(Q/2),B+(M/2),N,this.layoutLabelColor,"center","middle",Math.PI/2]);this.addToRender(["drawShape","box",I+u+(Q/2),B+(M/2),Q,M,false,D,"open",false,p],false,false,null,true)}}else{if(this.layoutType=="rows"){if(Number(O)+1==this.layoutCols){this.addToRender(["drawText",this.layoutLabels[0],I+u+(Q/2),B+(M/2),N,this.layoutLabelColor,"center","middle",Math.PI/2]);this.addToRender(["drawShape","box",I+u+(Q/2),B+(M/2),Q,M,false,D,"open",false,p],false,false,null,true)}if(this.layoutLabels.length>1&&A==0){this.addToRender(["drawText",this.layoutLabels[1],I+F,B-(Q/2),N,this.layoutLabelColor,"center","middle"]);this.addToRender(["drawShape","box",I+(u/2),B-(Q/2),u,Q,false,D,"open",false,p],false,false,null,true)}}}}}}};this.getLayoutConfig=function(a){if(this.layoutValid&&this.layoutConfig&&this.layoutConfig[this.layoutCurrent]&&this.layoutConfig[this.layoutCurrent][a]){return this.layoutConfig[this.layoutCurrent][a]}else{return false}};this.initializeLayout=function(){this.isValidLayout()};this.setFunctionNames("initLayout");this.initializeLayout()};CanvasXpress.prototype.initViewport=function(a){this.setViewport=function(){var d=this.$("container-"+this.target);if(!d){var x=this.$(this.target);var t=x.parentNode;x.className="CanvasXpress";x.style.visibility=this.debug?"visible":"hidden";if(!x.hasAttribute("data-maxWidth")){x.setAttribute("data-maxWidth",x.hasAttribute("width")?Number(x.getAttribute("width")):t.clientWidth)}if(!x.hasAttribute("data-maxHeight")){x.setAttribute("data-maxHeight",x.hasAttribute("height")?Number(x.getAttribute("height")):t.clientHeight)}if(!t.id){t.id="CanvasXpress-ParentNode-"+this.target}if(!CanvasXpress.system.isShiny){t.className="CanvasXpress-ParentNode"}if(!t.style.margin&&!t.style.marginTop&&this.toolbarType.match(/over|fixed/)){t.style.marginTop="36px"}this.targetParentNode=t.id;this.targetParentNodeResponsive=false;this.targetParentNodeAspectRatio=[];var v=x.hasAttribute("data-responsive")?JSON.parse(x.getAttribute("data-responsive")):false;var r=x.hasAttribute("data-aspectRatio")?x.getAttribute("data-aspectRatio"):false;var f=x.hasAttribute("data-resizable")?x.getAttribute("data-resizable"):false;if(f){if(f=="both"){this.resizable=true;this.resizableX=true;this.resizableY=true}else{if(f=="x"||f=="X"){this.resizable=true;this.resizableX=true;this.resizableY=false}else{if(f=="y"||f=="Y"){this.resizable=true;this.resizableX=false;this.resizableY=true}else{if(f=="none"){this.resizable=false;this.resizableX=false;this.resizableY=false}}}}}if(v){this.targetParentNodeResponsive=true;var m=r?r.split(/:/):[];var j=this.getMaxCanvasWidthHeight(x,m);x.width=j[0];x.height=j[1];this.targetParentNodeAspectRatio=[x.width,x.height]}x.width=x.originalWidth=parseInt(x.width);x.height=x.originalHeight=parseInt(x.height);x.style.width=x.width+"px";x.style.height=x.height+"px";var q=this.$cX("canvas",{id:this.target+"-events",className:"CanvasXpress",width:x.width,height:x.height},{position:"absolute",left:0,top:0,visibility:(this.debug?"visible":"hidden")});this.target2=this.target+"-events";var h=this.$cX("canvas",{id:this.target+"-transitions0",className:"CanvasXpress",width:x.width,height:x.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target3=this.target+"-transitions0";var g=this.$cX("canvas",{id:this.target+"-transitions1",className:"CanvasXpress",width:x.width,height:x.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target4=this.target+"-transitions1";var d=this.$cX("div",{id:"container-"+this.target,className:"CanvasXpressContainer"});var u=this.$cX("div",{id:this.leafletId||this.target+"-leafletId",className:"CanvasXpressMap"},{width:x.width+"px",height:x.height+"px"});if(this.isMap&&this.leafletLayer){x.style.position="absolute";x.style.left="0px";x.style.top="0px"}if(a){d.style.display="none"}var z=this.$cX("div",{id:"northest-container-"+this.target,className:"CanvasXpressContainer"},{width:x.width+"px",clear:"left"});var o=this.$cX("div",{id:"northest-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:x.width+"px"});var k=this.$cX("div",{id:"north-container-"+this.target,className:"CanvasXpressContainer"},{width:x.width+"px",height:"0px",clear:"left"});var y=this.$cX("div",{id:"north-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:x.width+"px",height:"0px"});var B=this.$cX("div",{id:"middle-container-"+this.target,className:"CanvasXpressContainer"},{width:x.width+"px",height:x.height+"px",clear:"left"});var n=this.$cX("div",{id:"west-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:x.height+"px",cssFloat:"left"});var A=this.$cX("div",{id:"west-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:x.height+"px"});var e=this.$cX("div",{id:"center-wrapper-"+this.target,className:"CanvasXpressWrapper"});var i=this.$cX("div",{id:"east-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:x.height+"px"});var w=this.$cX("div",{id:"east-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:x.height+"px"});var b=this.$cX("div",{id:"south-container-"+this.target,className:"CanvasXpressContainer"},{width:x.width+"px",height:"0px",clear:"left"});var s=this.$cX("div",{id:"south-wrapper-"+this.target,className:"CanvasXpressWrapper",state:"open"},{width:x.width+"px",height:"0px"});z.appendChild(o);k.appendChild(y);n.appendChild(A);i.appendChild(w);b.appendChild(s);B.appendChild(n);B.appendChild(e);B.appendChild(i);d.appendChild(z);d.appendChild(k);d.appendChild(B);d.appendChild(b);d.appendChild(this.createLoadingTimer());x.parentNode.insertBefore(d,x);e.appendChild(x.parentNode.appendChild(x));if(this.isMap&&this.leafletLayer){x.parentNode.appendChild(u)}x.parentNode.appendChild(q);x.parentNode.appendChild(h);x.parentNode.appendChild(g);this.meta.canvas.ctx2=this.get2DCanvasContext(q);this.meta.canvas.ctx2.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx3=this.get2DCanvasContext(h);this.meta.canvas.ctx3.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx4=this.get2DCanvasContext(g);this.meta.canvas.ctx4.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.getMaxCanvasWidthHeight=function(m,g){var n,j;if(!m){m=this.$(this.target)}if(!g){g=this.targetParentNodeAspectRatio}var e=this.targetParentNode&&this.$(this.targetParentNode)?this.$(this.targetParentNode):false;var o=Number(m.getAttribute("data-maxWidth"));var k=Number(m.getAttribute("data-maxHeight"));if(e){if(e.parentNode){e=e.parentNode}}else{return[o,k]}var b=e.getClientRects();var f=parseInt(getComputedStyle(e).paddingLeft);var i=Number(b[0].width);var d=Number(b[0].height);i=i>o?o:i;d=d>k?k:d;if(g.length==2){g[0]=Number(g[0]);g[1]=Number(g[1]);if(g[0]==g[1]){n=i-(i>=o?0:(f?f*2:0));j=n}else{if(g[0]>g[1]){n=parseInt(i);j=parseInt(n*g[1]/g[0])}else{j=parseInt(d);n=parseInt(j*g[0]/g[1])}}}else{n=i;j=d}return[n,j]};this.createLoadingTimer=function(){var k=this.target+"canvasXpressLoadingTimer";if(this.$(k)){return}var j=this.$(this.target);var h=this.$cX("div",{id:k},{display:"none",position:"absolute",width:"100%",top:parseInt((j.height/2)-100.5)+"px"});var f=this.$cX("div",{className:"counter"});var d=this.$cX("div",{className:"timer"});var b=this.$cX("div",{className:"imer-val-container seconds-single"});for(var e=0;e<10;e++){b.appendChild(this.$cX("div",{className:"timer-val",innerHTML:e}))}d.appendChild(b);f.appendChild(d);h.appendChild(f);var g=this.$cX("div",{className:"sk-fading-circle"});for(var e=1;e<13;e++){g.appendChild(this.$cX("div",{className:"sk-circle"+e+" sk-circle"}))}h.appendChild(g);return h};this.resizeViewportNorth=function(){var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var c=this.$("northest-container-"+this.target);var d=this.$("northest-wrapper-"+this.target);var g=this.$("north-container-"+this.target);var b=this.$("north-wrapper-"+this.target);if(f&&e&&c&&d&&g&&b){c.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";d.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}};this.resizeViewportWest=function(){var e=this.$(this.target+"-cX-Configurator");var b=this.$("west-container-"+this.target);var d=this.$("west-wrapper-"+this.target);if(b&&d){b.style.width="0px";d.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";d.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportEast=function(){var d=this.$(this.target+"-cX-DataFilter");var b=this.$("east-container-"+this.target);var c=this.$("east-wrapper-"+this.target);if(b&&c){b.style.width="0px";c.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";c.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportSouth=function(c){var h=this.$(this.target+"-cX-DataTable");var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var g=this.$("south-container-"+this.target);var b=this.$("south-wrapper-"+this.target);if(h&&f&&e&&g&&b){if(c){g.style.height=parseInt(h.style.height)+"px";b.style.height=parseInt(h.style.height)+"px";g.style.width=parseInt(h.style.width)+"px";b.style.width=parseInt(h.style.width)+"px"}else{g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}}};this.resizeViewport=function(){var d=this.$("middle-container-"+this.target);var b=this.$("east-container-"+this.target);var c=this.$("west-container-"+this.target);if(d&&b&&c){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();d.style.width=(parseInt(c.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(b.style.width)+0)+"px";d.style.height=(this.meta.canvas.ctx.canvas.height+0)+"px"}};this.resizeViewportMiddle=function(b,d){var f=this.$("middle-container-"+this.target);var c=this.$("east-container-"+this.target);var e=this.$("west-container-"+this.target);if(f&&c&&e){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();f.style.width=(parseInt(e.style.width)+b+parseInt(c.style.width)+0)+"px";f.style.height=(d+0)+"px"}};this.resetViewportOverflow=function(c){if(c){var b=this.$(c+"-wrapper-"+this.target);if(b){b.style.overflow="visible"}}};this.initializeViewport=function(){this.setViewport()};this.setFunctionNames("initViewport");this.initializeViewport()};CanvasXpress.prototype.initMenus=function(){this.addMenu=function(A,a,n,b,g,d,t,z){if(this.disableMenu){return}var p;var o;var j=this.$("north-wrapper-"+this.target);var c=this.$("west-container-"+this.target);this.resetLinkDiv();if(j&&c){if(a){o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable",par:n},{left:"0px",top:"0px",zIndex:this.menuIndex++,display:"none"})}else{this.removeMenus();if(b){a=b;g+=c.offsetWidth}else{a=this.setMenu();var v=this.getTargetEvent(A);var B=this.adjustedCoordinates(A,this.isMap?false:v);if(z){g=8;d=8}else{g=B.x+c.offsetWidth;d=B.y}}o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable"},{left:g+"px",top:d+"px",zIndex:this.menuIndex++})}var k=this.$cX("ul",{id:this.newId("-cX-List-"),className:"CanvasXpressList",header:t});p.appendChild(k);j.appendChild(p);var s=this.maxSubMenus;var q=a.length>s?s:a.length;if(a.length>s&&this.graphType!="Network"){k.rawMenu=a;k.rawMenuIndex=0;this.addMenuItemScroller(k,"Top")}for(var r=0;r<q;r++){if(a[r][0]=="-"){this.addMenuItemSep(k)}else{if(a[r][0]=="-text-"){this.addMenuItemText(a[r],k)}else{if(a[r][0]=="-color-"){this.addMenuItemColor(a[r],k)}else{if(a[r][0]=="-slider-"){this.addMenuItemSlider(a[r],k)}else{if(a[r][0]=="-filter-"){this.addMenuItemFilter(a[r],k)}else{this.addMenuItem(a[r],k)}}}}}}if(a.length>s){this.addMenuItemScroller(k,"Bottom")}}return o};this.pageMenuItem=function(e,f){var g,j,a,i;var h=e.rawMenuMatch||e.rawMenu;if(h){var d=e.childNodes.length-2;if(f=="Top"&&e.rawMenuIndex>0){g=e.childNodes[e.childNodes.length-2];j=h[e.rawMenuIndex-1];a=e.childNodes[2];i=true;e.rawMenuIndex--}else{if(f=="Bottom"&&h.length>(e.rawMenuIndex+d)){g=e.childNodes[2];j=h[e.rawMenuIndex+d];a=e.childNodes[e.childNodes.length-1];i=true;e.rawMenuIndex++}}if(i){this.addRemoveItemListeners("removeEvtListener",g);g.parentNode.removeChild(g);if(j[0]=="-"){this.addMenuItemSep(e,a)}else{if(j[0]=="-text-"){this.addMenuItemText(j,e,a)}else{if(j[0]=="-color-"){this.addMenuItemColor(j,e,a)}else{if(j[0]=="-slider-"){this.addMenuItemSlider(j,e,a)}else{if(j[0]=="-filter-"){this.addMenuItemFilter(j,e,a)}else{this.addMenuItem(j,e,a)}}}}}}}};this.filterScrollSearch=function(b){var k=this.$(b);if(k){var c=k.value;var n=new RegExp(k.value,"i");var h=k.parentNode.parentNode;var j=h.rawMenu;var f=[];for(var e=0;e<j.length;e++){if(j[e][0].match(n)){f.push(j[e])}}if(f.length!=j.length){h.rawMenuMatch=f}else{delete (h.rawMenuMatch)}while(h.childNodes.length>0){var d=h.childNodes[0];this.addRemoveItemListeners("removeEvtListener",d);h.removeChild(d)}var m=this.maxSubMenus;var g=f.length>m?m:f.length;h.rawMenuIndex=0;var a=this.addMenuItemScroller(h,"Top",c);for(var e=0;e<g;e++){this.addMenuItem(f[e],h)}this.addMenuItemScroller(h,"Bottom");a.focus();a.value=c}};this.addMenuItemSep=function(d,a){var c=this.$cX("li",{id:this.newId("-cX-List-Item-Sep-"),className:"CanvasXpressListItemSep"});var e=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Sep-"),className:"CanvasXpressListItemTextSep",innerHTML:"&nbsp;"});c.appendChild(e);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addMenuItemScroller=function(c,d){var b=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-"+d),className:"CanvasXpressListItemScroll"+d});var f=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Scroll-"+d),className:"CanvasXpressListItemTextScroll"+d,innerHTML:"&nbsp;"});b.appendChild(f);c.appendChild(b);this.addRemoveItemListeners("addEvtListener",b);if(d=="Top"){var a=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-Search"),className:"CanvasXpressListItemScrollSearch"+d});var e=this.$cX("input",{id:this.newId("-cX-List-Item-Scroll-Search-Input"),className:"CanvasXpressListItemScrollSearch",type:"text",placeholder:" Search menu"});a.appendChild(e);c.appendChild(a);return e}};this.getMenuItemValue=function(d){if(d[2][2]){var c=this.cloneObject(d[2][2]);var b=this;while(c.length>0){var a=c.shift();if(b[a]){b=b[a]}else{return""}}return b!=null?b:""}else{return this[d[2][0]]||""}};this.addMenuItem=function(e,m,j){var h=this.newId("-cX-List-Item-");var f=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:e[2],params:e[3]||[],upload:e[0]&&e[0]=="Load"?true:false,uploadParams:e[0]&&e[0]=="Load Parameters"?true:false});var k;var d={cursor:"grab",cursor:"-moz-grab",cursor:"-webkit-grab"};var r=false;if(e[5]){k=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemAArrow",hidefocus:"true",unselectable:"on",href:"#",menu:h,menuId:"false",menuFunc:e[5],menuParm:e[6],draggable:false},d);r=true}else{k=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#",menuFunc:e[2],menuParm:e[3],draggable:false})}var g=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:e[1]&&CanvasXpress.images[e[1]]?CanvasXpress.images[e[1]]:CanvasXpress.images.canvasXpress,key:e[1]});var p;if(e[0]&&(e[0]=="Load"||e[0]=="Load Parameters")){p=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",draggable:false},{marginRight:0});var n=this.$cX("input",{id:this.newId("-cX-List-Item-Text-File-Upload"),className:"CanvasXpressListItemText",type:"file",draggable:false},{color:"transparent",width:"100px"});p.appendChild(n)}else{p=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",innerHTML:e[0]||"",draggable:false},r?d:false)}var c=this.$cX("span",{className:"CanvasXpressListItemTextShort",innerHTML:e[4]||"",draggable:false});k.appendChild(g);k.appendChild(p);k.appendChild(c);f.appendChild(k);if(j){j.parentNode.insertBefore(f,j)}else{m.appendChild(f)}this.addRemoveItemListeners("addEvtListener",f)};this.addMenuItemText=function(c,m,j){var h=this.newId("-cX-List-Item-Text-");var f=this.newId("-cX-List-Item-Text-Input-");var d=this.getMenuItemValue(c);var e=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:c[1],params:[c[2],f]});var n=this.$cX("input",{id:f,className:"CanvasXpressList",type:"text",value:d},{paddingLeft:"3px",width:"200px"});var k=this.$cX("a",{id:this.newId("-cX-List-Text-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var g=this.$cX("img",{id:this.newId("-cX-List-Text-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"4px"});k.appendChild(g);k.appendChild(n);e.appendChild(k);if(j){j.parentNode.insertBefore(e,j)}else{m.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemColor=function(E,v,L){var m=this.newId("-cX-List-Item-Color-");var n=this.newId("-cX-List-Item-Color-Container-");var g=this.newId("-cX-List-Item-Color-Current-");var B=this.newId("-cX-List-Item-Color-Palete-");var f=this.newId("-cX-List-Item-Color-Palete-Current-");var k=this.newId("-cX-List-Item-Color-Saturation-");var w=this.newId("-cX-List-Item-Color-Saturation-Current-");var N=this[E[2][0]]||"";var G=this.$cX("li",{id:m,className:"CanvasXpressListItem",click:E[1],params:[E[2],g],palete:B,paleteCurrent:f,colorCurrent:g,saturation:k,saturationCurrent:w});var M=this.$cX("a",{id:this.newId("-cX-List-Color-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"},{height:"140px",width:"250px"});var I=this.$cX("img",{id:this.newId("-cX-List-Color-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"2px"});var J=N?this.rgbToHex(this.validateColor(N.replace(/[\'\"]/g,""))):this.foreground;this.colorRGBfromString(J);var t=Math.round(this.colorHSV[0]/6*180);var r=Math.round((1-this.colorHSV[1])*100);var q=Math.round((1-this.colorHSV[2])*100);var K=this.$cX("div",{id:n},{width:"188px",height:"138px",cssFloat:"left"});var C=this.$cX("div",{id:g,parentItem:m,className:"CanvasXpressConfiguratorColor",value:N},{width:"203px",height:"24px",cssFloat:"left",marginBottom:"5px",cursor:"default",lineHeight:"24px"});var D=this.$cX("div",{id:B,parentItem:m,className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var d=this.$cX("div",{id:f,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(t-7)+"px",top:(r-7)+"px",width:"195px",height:"115px"});D.appendChild(d);var A=this.$cX("div",{id:k,parentItem:m,className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",top:"-102px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",clear:"left",cursor:"crosshair"});for(var H=0;H<100;H+=4){var F=this.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});A.appendChild(F)}var e=this.$cX("div",{id:w,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(q-108)+"px",width:"29px",height:"115px"});A.appendChild(e);K.appendChild(C);K.appendChild(D);K.appendChild(A);M.appendChild(I);M.appendChild(K);G.appendChild(M);if(L){L.parentNode.insertBefore(G,L)}else{v.appendChild(G)}this.colorizeCurrentItemColor(G);this.colorizeSaturationItemColor(G);this.addRemoveItemListeners("addEvtListener",G)};this.colorizeCurrentItemColor=function(a){var e=this.$(a.colorCurrent);if(e){var d=this.colorRGBToString();var b=this.hexToRgb("#"+d);e.style.backgroundColor="#"+d;e.innerHTML="&nbsp;&nbsp;"+b;e.style.color=this.complementaryColor(b,true);e.value=b}};this.colorizeSaturationItemColor=function(a){var d=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var f=this.$(a.saturation);if(f&&this.colorHSV){var g=f.childNodes;var b=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(b){for(var e=0;e<g.length-1;e++){g[e].style.backgroundColor=d(b[0],b[1],b[2],e,g.length-1)}}}};this.updateColorItemValue=function(b,c){if(!b){var g=this.getMenuItemComp(c);if(g){b=g[0]}else{return false}}if(this.changingColorItemOn){if(this.changingColorItemOn=="palette"){var a=this.$(b.palete);var h=this.$(b.paleteCurrent);if(a&&h){var j=this.adjustedCoordinates(c,a);if(j){var i=Math.min(Math.max(0,j.x),181);var f=Math.min(Math.max(0,j.y-25),101);h.style.left=(i-7)+"px";h.style.top=(f-7)+"px";this.colorFromHsv(i*6/180,1-f/100,null);this.colorizeCurrentItemColor(b);this.colorizeSaturationItemColor(b)}}}else{var k=this.$(b.saturation);var d=this.$(b.saturationCurrent);if(k&&d){var j=this.adjustedCoordinates(c,k);if(j){var f=Math.min(Math.max(0,j.y-25),101);d.style.top=(f-108)+"px";this.colorFromHsv(null,null,1-f/100);this.colorizeCurrentItemColor(b)}}}}return false};this.endColorItemChange=function(a){this.changingColorItemOn=false};this.addMenuItemSlider=function(q,m,I){var f=this.newId("-cX-List-Item-Slider-");var e=this.newId("-cX-List-Item-Slider-Container-");var E=this.newId("-cX-List-Item-Slider-Table-");var K=q[2][0]||"";var D=this.formatNumber(this.binConfigurations[K]["max"],this.binConfigurations[K]["dec"]);var v=this.$cX("li",{id:f,className:"CanvasXpressListItem",click:q[1],params:[q[2][0],e],slider:K});var J=this.$cX("a",{id:this.newId("-cX-List-Slider-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var H=this.$cX("div",{id:e,className:"CanvasXpressList"});var n=this.$cX("table",{id:E,className:"CanvasXpressListItemTable"},{width:"100%"});var g=this.$cX("tbody");var h=D.length*8;for(var B=0;B<this.binConfigurations[K]["n"];B++){var s=Number(B>0?this.binConfigurations[K]["bins"][B-1]["value"]:this.binConfigurations[K]["min"]);var A=Number(B<this.binConfigurations[K]["n"]-1?this.binConfigurations[K]["bins"][B+1]["value"]:this.binConfigurations[K]["max"]);var k=this.$cX("input",{id:E+"-Range-"+B,className:"CanvasXpressListItem",type:"range",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:false},{width:"120px"});var j=this.$cX("input",{id:E+"-Number-"+B,className:"CanvasXpressListItem",type:"number",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:true},{width:(h+18)+"px",textAlign:"right"});var c=this.$cX("tr");var G=this.$cX("th",{innerHTML:this.binConfigurations[K]["bins"][B]["name"]},{paddingRight:"5px"});var F=this.$cX("td",{id:E+"-Min-"+B,innerHTML:this.formatNumber(s,this.binConfigurations[K]["dec"])},{width:h+"px",textAlign:"right"});var C=this.$cX("td");C.appendChild(k);var z=this.$cX("td",{id:E+"-Max-"+B,innerHTML:this.formatNumber(A,this.binConfigurations[K]["dec"])},{width:h+"px"});var w=this.$cX("td",false,{paddingLeft:"5px"});w.appendChild(j);c.appendChild(G);c.appendChild(F);c.appendChild(C);c.appendChild(z);c.appendChild(w);g.appendChild(c)}n.appendChild(g);H.appendChild(n);H.appendChild(this.$cX("br"));var p=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"4px"});J.appendChild(p);J.appendChild(H);v.appendChild(J);if(I){I.parentNode.insertBefore(v,I)}else{m.appendChild(v)}this.addRemoveItemListeners("addEvtListener",v)};this.updateSliderItemValue=function(h){var a=this.changingSliderItemOn.slider;var g=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var d=this.$(this.changingSliderItemOn.id.replace("-Range-","-Number-"));var f=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Max-"+(g-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g+1)));var i=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Min-"+(g+1)));this.binConfigurations[a]["bins"][g]["value"]=c;if(d){d.value=c}if(f&&j){f.max=c;f.step=(f.max-f.min)/20;j.innerHTML=c}if(b&&i){b.min=c;b.step=(b.max-b.min)/20;i.innerHTML=c}this.applySliderItemValue(a);return false};this.endSliderItemChange=function(g){if(this.changingSliderItemOn.sliderNumber){var a=this.changingSliderItemOn.slider;var f=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var i=this.$(this.changingSliderItemOn.id.replace("-Number-","-Range-"));var d=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Max-"+(f-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f+1)));var h=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Min-"+(f+1)));this.binConfigurations[a]["bins"][f]["value"]=c;if(i){i.value=c}if(d&&j){d.max=c;d.step=(d.max-d.min)/20;j.innerHTML=c}if(b&&h){b.min=c;b.step=(b.max-b.min)/20;h.innerHTML=c}this.applySliderItemValue(a)}this.changingSliderItemOn=false};this.applySliderItemValue=function(f){var a=this.binConfigurations[f]["name"];var e=this.binConfigurations[f]["vi"];this.data.x[a]=[];for(var d=0;d<this.data.y.data[e].length;d++){var b=this.data.y.data[e][d];if(!isNaN(b)&&b!==""&&b!=null){for(var c=0;c<this.binConfigurations[f]["n"];c++){if(b<=this.binConfigurations[f]["bins"][c].value){this.data.x[a][d]=this.binConfigurations[f]["bins"][c].name;break}}}else{this.data.x[a][d]=""}}if(this.isGroupedData){this.ungroupSamples(true)}this.updateData(this.data);this.groupSamples([a]);this.sortSamplesByCategory([a])};this.addMenuItemFilter=function(f,d,a){var e=this.newId("-cX-List-Item-");var c=this.$cX("li",{id:e,className:"CanvasXpressListItem",type:"filter",selector:f[1].id.split(":")[1]});c.appendChild(f[1]);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addRemoveItemListeners=function(b,a){if(!a){return this.removeMenus()}else{if(a.className=="CanvasXpressListItemSep"){return}}var g=a.parentNode.parentNode;var d=false;var h=a.id.match("-cX-List-Item-Color-");if(this.hasClass(g,"draggable")&&!h){this[b](g,"mousedown",this.registerMousemove,d)}if(a.upload){var e=a.childNodes[0].childNodes[1].childNodes[0];this[b](e,"change",this.loadFile,d)}else{if(a.uploadParams){var e=a.childNodes[0].childNodes[1].childNodes[0];this[b](e,"change",this.loadParamsFile,d)}else{this[b](a,"click",this.clickMenuItem,d)}}this[b](a,"mouseover",this.mouseoverMenuItem,d);this[b](a,"mouseout",this.mouseoutMenuItem,d);this[b](a,"mousewheel",this.mousewheelMenuItem,d);this[b](a,"contextmenu",this.contextMenuItem,d);if(a.className.match(/Scroll/)){this[b](a,"mousedown",this.mousedownMenuItem,d);this[b](a,"mouseup",this.mouseupMenuItem,d)}if(a.paleteCurrent&&a.saturation){this[b](a,"mousedown",this.mousedownMenuItemColor,d)}if(a.slider){this[b](a,"mousedown",this.mousedownMenuItemSlider,d)}};this.contextMenuItem=function(a){return function(h){a.cancelEvent(h);var b=a.getTargetEvent(h);var n=a.getMenuItemComp(h);var f=n[1].childNodes[0];var g=n[1].childNodes[1].innerText;var k=n[1].menuFunc;var j=n[1].menuParm;var p=n[1].menuId;var q=n[2].offsetLeft;var l=n[2].offsetTop+n[1].offsetTop;a.removeMenus();var o=[["Pin "+g+" to Toolbar","pin","pinToToolbar",[f,g,k,j,p,false,true]]];var d=a.addMenu(h,o);var c=a.$(d);c.style.left=q+"px";c.style.top=l+"px";c.style.display="block";return false}}(this);this.pinToToolbar=function(c,d,f,e,g,i,h){this.removeMenus();var b=this.$(this.target+"-cX-Toolbar-Custom");if(b){var a=this.target+"-cX-Custom-Toolbar-Menu-"+f;if(!this.$(a)){c.id=a;c.className="CanvasXpressToolbarImage";c.style.width="24px";c.style.height="24px";c.style.cssFloat="left";c.title=d;c.fun=f;c.par=e;c.mid=g||this.newId("-cX-Default-Toolbar-Menu-");if(h){b.insertBefore(c,b.firstChild)}else{b.appendChild(c)}if(!this.disableToolbar){this.addRemoveEvtListener("addEvtListener",c,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("addEvtListener",c,"contextmenu",this.unpinFromToolbar,false)}if(!i){CanvasXpress.stack[this.target].afterRender.push(["addImageToToolbar",[c.key,d,f,e,g]])}}}};this.unpinFromToolbar=function(a){return function(j){a.cancelEvent(j);var c=a.getTargetEvent(j);var g=c.offsetLeft;var h=c.offsetTop;var f=[["Unpin "+c.title+" from Toolbar","unpin","removeImageFromToolbar",[c.id]]];var d=a.addMenu(j,f);var b=a.$(d);b.style.left=g+"px";b.style.top=h+"px";b.style.display="block";return false}}(this);this.addCustomToolbarMenu=function(a){return function(g){a.cancelEvent(g);var d=a.getTargetEvent(g);var h=a[d.fun].apply(a,d.par);if(d.mid){a.removeMenus();var f=a.addMenu(false,h);var b=a.$(f);if(d.id.match(/DataExplorer/)){if(a.menuIndex<10002){a.menuIndex=10002}var j=a.getBoundingClientRect(d);b.style.left=parseInt(j.left)+"px";b.style.top=parseInt(j.top)+"px";b.style.zIndex=a.menuIndex++}else{b.style.left=d.offsetLeft+"px";b.style.top="10px"}b.style.display="block"}}}(this);this.addImageToToolbar=function(h,c,e,d,f,i,g,a){var b;if(a){b=this.$cX("img",{className:"CanvasXpressToolbarImage",src:CanvasXpress.images[h],key:h},a)}else{b=this.$cX("img",{className:"CanvasXpressToolbarImage",src:CanvasXpress.images[h],key:h})}this.pinToToolbar(b,c,e,d,f,i,g)};this.removeImageFromToolbar=function(c,b){var a=this.$(c);if(a&&!this.disableToolbar){this.addRemoveEvtListener("removeEvtListener",a,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("removeEvtListener",a,"contextmenu",this.unpinFromToolbar,false);a.parentNode.removeChild(a);this.removeMenus();if(!b){CanvasXpress.stack[this.target].afterRender.push(["removeImageFromToolbar",[c]])}}};this.removeAllImagesFromToolbar=function(){var a=this.$(this.target+"-cX-Toolbar-Custom");if(a){var b=a.getElementsByTagName("img");while(b.length>0){this.removeImageFromToolbar(b[0].id,true)}}};this.clickMenuItem=function(a){return function(h){a.cancelEvent(h);var b=a.getTargetEvent(h);var m=a.getMenuItemComp(h);if(m&&!/input|textarea|select/i.test(b.tagName)){if(m[0].className.match(/Scroll/)||m[1].className.match(/Scroll/)){var c=m[0].className.match(/Scroll/)?m[0]:m[1];var n=c.parentNode;var j=c.className.match(/ScrollTop/)?"Top":"Bottom";a.pageMenuItem(n,j)}else{var f=[];if(m[0].params){for(var g=0;g<m[0].params.length;g++){if(m[0].params[g]=="event"){f.push(h)}else{if(m[0].params[g]=="component"){f.push(m)}else{f.push(m[0].params[g])}}}}if(a[m[0].click]){a[m[0].click].apply(a,f);var d=m[1].firstChild.key;var o=m[1].firstChild.src;if(d){if(d.match("unchecked")){m[1].firstChild.key="checked";m[1].firstChild.src=CanvasXpress.images.checked}else{if(d.match("checked")){m[1].firstChild.key="unchecked";m[1].firstChild.src=CanvasXpress.images.unchecked}else{if(d.match("eyeClosed")){m[1].firstChild.key="eye2";m[1].firstChild.src=CanvasXpress.images.eye2;m[1].childNodes[1].innerHTML=m[1].childNodes[1].innerHTML.replace("Hide","Show")}else{if(d.match("eye2")){m[1].firstChild.key="eyeClosed";m[1].firstChild.src=CanvasXpress.images.eyeClosed;m[1].childNodes[1].innerHTML=m[1].childNodes[1].innerHTML.replace("Show","Hide")}else{if(d=="lightbulb"){m[1].firstChild.key="lightbulbOff";m[1].firstChild.src=CanvasXpress.images.lightbulbOff}else{if(d=="lightbulbOff"){m[1].firstChild.key="lightbulb";m[1].firstChild.src=CanvasXpress.images.lightbulb}else{if(d=="descending"){m[1].firstChild.key="ascending";m[1].firstChild.src=CanvasXpress.images.ascending;m[0].params[1]="ascending"}else{if(d=="ascending"){m[1].firstChild.key="descending";m[1].firstChild.src=CanvasXpress.images.descending;m[0].params[1]="descending"}else{if(d.match("radioOn")){a.resetRadioMenuItem(m[2].firstChild.childNodes);if(f[1]&&f[1].match(/xAxis|yAxis|zAxis/)){m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}else{m[1].firstChild.key="radioOff";m[1].firstChild.src=CanvasXpress.images.radioOff}}else{if(d.match("radioOff")){a.resetRadioMenuItem(m[2].firstChild.childNodes);m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}}}}}}}}}}}}}return false}else{return false}}}(this);this.resetRadioMenuItem=function(b){for(var c=0;c<b.length;c++){var a=b[c].firstChild.firstChild;if(a&&a.nodeName.match(/img/i)){a.src=CanvasXpress.images.radioOff;a.key="radioOff"}}};this.adjustMenuItemPosition=function(f,p,o){var g,x;var q=this.remoteParentId?this.$(this.remoteParentId):this.$("container-"+this.target);var i=window.innerWidth;var b=window.innerHeight;var u=q.offsetLeft;var k=q.offsetTop;var s=q.clientWidth;var j=q.clientHeight;var a=i-u;var v=f.clientWidth;var n=f.clientHeight;if(p){g=p.offsetLeft+p.offsetWidth-5;if(g+v+5>a){g=p.offsetLeft-v+5}x=p.offsetTop+o.offsetTop}else{g=f.offsetLeft;x=f.offsetTop}f.style.left=g+"px";f.style.top=x+"px"};this.mouseoverMenuItem=function(a){return function(j){var h=a.getMenuItemComp(j);if(!h){return false}if(h[0].className.match(/Scroll/)||h[1].className.match(/Scroll/)){var n=h[0].className.match(/Scroll/)?h[0]:h[1];n.className+="Active";return false}var f=h[2].firstChild.childNodes;a.hideMenusRecursively(f);h[0].className="CanvasXpressListItemActive";if(h[1].menu){var l=a[h[1].menuFunc].apply(a,h[1].menuParm);var g=a.addMenu(false,l,h[1].menu);var b=a.$(g);var k=h[2];b.style.left="0px";b.style.top="0px";b.style.display="block";a.adjustMenuItemPosition(b,k,h[1]);h[1].className="CanvasXpressListItemAArrowActive";h[1].menuId=g}else{h[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutMenuItem=function(a){return function(y){if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}var w,v,u,s,h,g,f,c;var A=a.adjustedCoordinates(y);if(A){var j=a.$("north-container-"+a.target);var k=a.$("west-container-"+a.target);A.x+=k.offsetWidth;A.y+=j.offsetHeight;var n=a.getMenuItemComp(y);if(!n){return false}else{if(n[1]&&n[1].menu){var p=a.$(n[1].menuId);var o=p.firstChild.firstChild;w=p.offsetLeft;h=p.offsetTop;v=w+p.offsetWidth;g=h+p.offsetHeight;if(A.x>=w&&A.x<=v&&A.y>=h&&A.y<=g){return false}a.hideMenu(n,p);if(o&&o.type=="filter"){var z=o.firstChild;if(z.type=="string"){var r=a.$(a.target+":"+o.selector+":cX-DataFilterMask");if(r){a.addRemoveStringDataFilterListeners("removeEvtListener",r)}}else{var q=a.$(a.target+":"+o.selector+":cX-DataFilterMin");var l=a.$(a.target+":"+o.selector+":cX-DataFilterMinLabel");var i=a.$(a.target+":"+o.selector+":cX-DataFilterRange");var t=a.$(a.target+":"+o.selector+":cX-DataFilterMax");var x=a.$(a.target+":"+o.selector+":cX-DataFilterMaxLabel");var b=a.$(a.target+":"+o.selector+":cX-DataFilterScale");if(q&&l&&i&&t&&x&&b){a.addRemoveNumericDataFilterListeners("removeEvtListener",q,t,l,x,b)}}}}else{a.hideMenu(n)}}}return false}}(this);this.mousedownMenuItemColor=function(a){return function(d){var b=a.getTargetEvent(d);var c=a.getMenuItemComp(d);if(!c){return false}else{if(b.id&&b.id.match(/-cX-List-Item-Color-Palete-/)){a.changingColorItemOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentItemColor(c[0]);var f=a.$(c[0].saturationCurrent);if(f){f.style.top="-108px"}}a.updateColorItemValue(c[0],d);a.colorizeSaturationItemColor(c[0])}else{if(b.parentNode.id&&b.parentNode.id.match(/-cX-List-Item-Color-Saturation-/)){a.changingColorItemOn="saturation";a.updateColorItemValue(c[0],d)}}}a.cancelEvent(d);return false}}(this);this.mousedownMenuItemSlider=function(a){return function(b){a.changingSliderItemOn=a.getTargetEvent(b);return false}}(this);this.mousedownMenuItem=function(a){return function(b){a.fastScrollMenuOn=true;a.fastScrollMenu=a.setInterval(function(){a.clickMenuItem(b)},100);return false}}(this);this.mouseupMenuItem=function(a){return function(b){if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}}}(this);this.mousewheelMenuItem=function(a){return function(g){a.cancelEvent(g);var h=0;if(g.wheelDelta){h=g.wheelDelta;if(window.opera){h=-h}}else{if(g.detail){h=-g.detail}}if(h){var b=a.getTargetEvent(g);var f=a.getMenuItemComp(g);if(!f){return false}var c=f[0].parentNode;if(h>0){a.pageMenuItem(c,"Top")}else{a.pageMenuItem(c,"Bottom")}}return false}}(this);this.getMenuItemComp=function(b){var a=this.getTargetEvent(b);while(a&&a.tagName&&!a.tagName.match(/li/i)){a=a.parentNode}return a.parentNode&&a.parentNode.parentNode?[a,a.firstChild,a.parentNode.parentNode]:false};this.hideMenu=function(e,f){if(e){if(e[0].className.match(/Scroll/)||e[1].className.match(/Scroll/)){var g=e[0].className.match(/Scroll/)?e[0]:e[1];g.className=g.className.replace("Active","")}else{if(e[1].menu){e[1].className="CanvasXpressListItemAArrow"}else{e[1].className="CanvasXpressListItemA"}e[0].className="CanvasXpressListItem"}}if(f){var b=f.firstChild.childNodes;for(var d=0;d<b.length;d++){var a=b[d];if(!a.className.match(/Scroll|ItemSep/)){this.addRemoveItemListeners("removeEvtListener",a)}}f.parentNode.removeChild(f)}};this.hideMenusRecursively=function(e){for(var f=0;f<e.length;f++){var c=e[f];if(!c.className.match(/Scroll|ItemSep/)){var d=c.firstChild;var b=d.menu?this.$(d.menuId):false;if(b){this.hideMenusRecursively(b.firstChild.childNodes)}this.hideMenu([c,d],b)}}};this.removeMenus=function(k){var f=[];if(this.skipHeaderMouseout){this.skipHeaderMouseout.className="CanvasXpressTableCellHead";this.skipHeaderMouseout.firstChild.firstChild.className="CanvasXpressTableCellHead";this.skipHeaderMouseout=false}if(!k){var c=this.$("north-wrapper-"+this.target);if(c){var h=c.getElementsByTagName("div");for(var g=0;g<h.length;g++){if(this.hasClass(h[g],"CanvasXpressMenu")){f.unshift(this.$(h[g].id))}}}this.menuIndex=10000}else{f.push(this.$(this.target+"-cX-Menu-"+k))}if(f.length>0){for(g in this.meta.ids){if(g.match(/cX-Menu-|cX-Menu/)){delete (this.meta.ids[g])}}for(var g=0;g<f.length;g++){var a=f[g];var b=a.getElementsByTagName("li");for(var e=0;e<b.length;e++){if(b[e].className!="CanvasXpressListItemSep"){this.addRemoveItemListeners("removeEvtListener",b[e])}}a.parentNode.removeChild(a)}}this.isMenu=false};this.changeTextColorAttributeMenu=function(a,b){return this.isArray(b)?[[a,"changeTextColorAttribute",b]]:[[a,"changeTextColorAttribute",[b]]]};this.getAxisLayoutTypeMenu=function(){var a=[];a.push(["Both panels ",this.scatterPlotMatrixType=="both"?"radioOn":"radioOff","modifyLayoutType",["both"]]);a.push(["Upper panel ",this.scatterPlotMatrixType=="upper"?"radioOn":"radioOff","modifyLayoutType",["upper"]]);a.push(["Lower panel ",this.scatterPlotMatrixType=="lower"?"radioOn":"radioOff","modifyLayoutType",["lower"]]);a.push(["Correlation ",this.scatterPlotMatrixType=="densityCorrelation"?"radioOn":"radioOff","modifyLayoutType",["correlation"]]);a.push(["Correlation - Density ",this.scatterPlotMatrixType=="correlationDensity"?"radioOn":"radioOff","modifyLayoutType",["correlationDensity"]]);a.push(["Correlation - Histogram ",this.scatterPlotMatrixType=="correlationHistogram"?"radioOn":"radioOff","modifyLayoutType",["correlationHistogram"]]);a.push(["All ",this.scatterPlotMatrixType=="all"?"radioOn":"radioOff","modifyLayoutType",["all"]]);a.push(["First ",this.scatterPlotMatrixType=="first"?"radioOn":"radioOff","modifyLayoutType",["first"]]);return a};this.getAxisLayoutMenu=function(){var a=[];var b=false;a.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]]);a.push(["Type","scatterPlotMatrixType",b,b,b,"getAxisLayoutTypeMenu",[]]);return a};this.getAxisSampleMenu=function(c){var d=[];var a=this.getObjectArray(this[c+"Axis"]);for(var b=0;b<this.data.y.smps.length;b++){d.push([this.data.y.smps[b],a[this.data.y.smps[b]]?"checked":"unchecked","changeSampleInAxis",[this.data.y.smps[b],c+"Axis"]])}return d};this.getAxisMenu=function(g,d){var c=g.toUpperCase();var b=d?"2":"";var a=[];var e=false;a.push([this[g+"Axis"+b+"Show"]?"Hide Axis":"Show Axis",this[g+"AxisShow"]?"eyeClosed":"eye2","toggleAttribute",[g+"Axis"+b+"Show"]]);a.push(["Set Min","min",e,e,e,"changeTextColorAttributeMenu",["-text-","setMin"+c+b]]);a.push(["Set Max","max",e,e,e,"changeTextColorAttributeMenu",["-text-","setMax"+c+b]]);a.push(["Transform","function",e,e,e,"getAxisTransformMenu",[g]]);if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){a.push(["Exact Range","exact","toggleAttribute",[g+"AxisExact"]])}a.push(["Format","textFormat",e,e,e,"changeTextColorAttributeMenu",["-text-",g+"Axis"+b+"TickFormat"]]);if(this.graphType.match(/Scatter/)){a.push(["Samples","samples",e,e,e,"getAxisSampleMenu",[g]])}return a};this.getFirstAxisMenu=function(){return[[this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eyeClosed":"eye2","toggleAttribute",["xAxisShow"]]]};this.getSecondAxisMenu=function(){return[[this.xAxis2Show?"Hide Axis":"Show Axis",this.xAxis2Show?"eyeClosed":"eye2","toggleAttribute",["xAxis2Show"]]]};this.getRangeAxisMenu=function(){var a=[];var b=false;a.push(["Set Min","min",b,b,b,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","max",b,b,b,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);return a};this.getAxesMenu=function(){var b=[];var a=false;if(this.graphType=="Scatter2D"){b.push(["X-Axis","axes2DPropertiesX",a,a,a,"getAxisMenu",["x"]]);b.push(["Y-Axis","axes2DPropertiesY",a,a,a,"getAxisMenu",["y"]]);b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);b.push(["Font","font",a,a,a,"getFontStyleMenu",["axisTick"]]);if(this.scatterPlotMatrix){b.push(["Axes Layout","scatterPlotMatrix",a,a,a,"getAxisLayoutMenu",[]])}}else{if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){b.push(["X-Axis","axes3DPropertiesX",a,a,a,"getAxisMenu",["x"]]);b.push(["Y-Axis","axes3DPropertiesY",a,a,a,"getAxisMenu",["y"]]);b.push(["Z-Axis","axes3DPropertiesZ",a,a,a,"getAxisMenu",["z"]]);b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);b.push(["Font","font",a,a,a,"getFontStyleMenu",["axisTick"]])}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){b.push(["First Axis","axes1DPropertiesFirst",a,a,a,"getAxisMenu",["x"]]);b.push(["Second Axis","axes1DPropertiesSecond",a,a,a,"getAxisMenu",["x",true]]);b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);b.push(["Font","font",a,a,a,"getFontStyleMenu",["axisTick"]])}else{b.push(["First Axis","axes1DPropertiesFirst",a,a,a,"getFirstAxisMenu",[]]);b.push(["Second Axis","axes1DPropertiesSecond",a,a,a,"getSecondAxisMenu",[]]);b.push(["Range","range",a,a,a,"getRangeAxisMenu",[]]);b.push(["Format","textFormat",a,a,a,"changeTextColorAttributeMenu",["-text-","xAxisTickFormat"]]);b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);b.push(["Font","font",a,a,a,"getFontStyleMenu",["axisTick"]]);if(this.layoutValid){b.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]])}}}}return b};this.getHeatmapBoxMenu=function(){var b=[];var a=false;b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColor"]]);b.push(["Width","thickness2",a,a,a,"changeTextColorAttributeMenu",["-text-","heatmapCellBoxWidth"]]);b.push([this.heatmapCellBox?"Hide Box":"Show Box",this.heatmapCellBox?"eyeClosed":"eye2","toggleAttribute",["heatmapCellBox"]]);return b};this.getHeatmapHighlightMenu=function(){var a=false;return[["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColorHighlight"]]]};this.getHeatmapVarSmpSeparatorsMenu=function(h,d,j){var e=this.meta.data;var k=[];if(e[h]&&d.length>0){var f={};for(var g=0;g<d.length;g++){var a=d[g];if(e[h][a].type!="Numeric"){f[a]=true}}var b=this.sortObject(f);for(var g=0;g<b.length;g++){k.push([b[g],b[g]==this[j]?"radioOn":"radioOff","changeAttribute",[j,b[g]]])}}return k};this.getHeatmapSeparatorsMenu=function(){var a=[];var b=false;if(this.isStringOverlays("v")){a.push(["Variables","variables",b,b,b,"getHeatmapVarSmpSeparatorsMenu",["z",this.varOverlays,"heatmapVarSeparateBy"]])}if(this.isStringOverlays("s")){a.push(["Samples","samples",b,b,b,"getHeatmapVarSmpSeparatorsMenu",["x",this.smpOverlays,"heatmapSmpSeparateBy"]])}return a};this.getHeatmapMenu=function(){var b=[];var a=false;b.push(["Cell Boxes","square",a,a,a,"getHeatmapBoxMenu",[]]);b.push(["Highlight","heatmapHighlight",a,a,a,"getHeatmapHighlightMenu",[]]);if(this.isStringOverlays()){b.push(["Separators","heatmapSpaceSeparation",a,a,a,"getHeatmapSeparatorsMenu",[]])}if(this.isOncoprint){b.push(["Oncoprint <-> Heatmap","refresh","toggleAttribute",["oncoprintHeatmapSwitch"]]);b.push([this.oncoprintNoAlterations?"Hide No Alterations":"Show No Alterations",this.oncoprintNoAlterations?"eyeClosed":"eye2","toggleAttribute",["oncoprintNoAlterations","modifyOncoprintNoAlterations"]])}return b};this.getPlotAreaMajorTicksMenu=function(a){return[[this[a]?"Hide Major Ticks":"Show Major Ticks",this[a]?"eyeClosed":"eye2","toggleAttribute",[a]]]};this.getPlotAreaMinorTicksMenu=function(a){return[[this[a]?"Hide Minor Ticks":"Show Minor Ticks",this[a]?"eyeClosed":"eye2","toggleAttribute",[a]]]};this.getPlotAreaTickTypeMenu=function(a){var b=[];b.push(["Solid","ticksMajor","changeAttribute",[a,"solid"]]);b.push(["Dotted","ticksTypeDotted","changeAttribute",[a,"dotted"]]);b.push(["Dashed","ticksTypeDashed","changeAttribute",[a,"dashed"]]);return b};this.getPlotAreaGridMenu=function(c){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-",c+"AxisTickColor"]]);if(this.graphType!="Scatter3D"&&!this.is3DPlot){a.push(["Major Ticks","ticksMajor",b,b,b,"getPlotAreaMajorTicksMenu",[c+"AxisMajorTicks"]]);a.push(["Minor Ticks","ticksMinor",b,b,b,"getPlotAreaMinorTicksMenu",[c+"AxisMinorTicks"]]);a.push(["Number","hash",b,b,b,"changeTextColorAttributeMenu",["-text-",c+"AxisTicks"]])}a.push(["Style","ticksType",b,b,b,"getPlotAreaTickTypeMenu",[c+"AxisTickStyle"]]);return a};this.getPlotAreaScatterGridMenu=function(){var a=[];var b=false;if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){a.push(["X-Axis","grid2DX",b,b,b,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","grid2DY",b,b,b,"getPlotAreaGridMenu",["y"]])}else{if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["X-Axis","grid3DX",b,b,b,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","grid3DY",b,b,b,"getPlotAreaGridMenu",["y"]]);a.push(["Z-Axis","grid3DZ",b,b,b,"getPlotAreaGridMenu",["z"]])}}return a};this.getPlotAreaAxisAlgorithmMenu=function(){var a=[];a.push(["Heckbert",this.axisAlgorithm=="heckbert"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","heckbert"]]);a.push(["R Pretty",this.axisAlgorithm=="rPretty"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","rPretty"]]);a.push(["Wilkinson",this.axisAlgorithm=="wilkinson"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinson"]]);a.push(["Wilkinson Extended",this.axisAlgorithm=="wilkinsonExtended"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinsonExtended"]]);return a};this.getPlotAreaBarsTypeMenu=function(){var a=[];a.push(["Standard Deviation",this.errorBarsType=="standardDeviation"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardDeviation"]]);a.push(["Standard Error of Mean",this.errorBarsType=="standardErrorMean"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardErrorMean"]]);a.push(["95% Confidence Interval",this.errorBarsType=="confidenceInterval95"?"radioOn":"radioOff","changeAttribute",["errorBarsType","confidenceInterval95"]]);return a};this.getPlotAreaErrorBarsMenu=function(){var b=[];var a=false;b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","errorBarsColor"]]);b.push(["Thickness","thickness",a,a,a,"changeTextColorAttributeMenu",["-text-","errorBarsThickness"]]);b.push(["Type","Tu",a,a,a,"getPlotAreaBarsTypeMenu",[]]);b.push([this.showErrorBars?"Hide Error Bars":"Show Error Bars",this.showErrorBars?"eyeClosed":"eye2","toggleAttribute",["showErrorBars"]]);return b};this.getPlotAreaOneVariableSpaceMenu=function(){var a=[];a.push(["Farther","farther","setFontAttributeSize",["variableSpaceFactor","increase"]]);a.push(["Closer","closer","setFontAttributeSize",["variableSpaceFactor","decrease"]]);return a};this.getPlotAreaOneSampleWidthMenu=function(){var a=[];a.push(["Wider","wider","setFontAttributeSize",["widthFactor","increase"]]);a.push(["Thinner","thinner","setFontAttributeSize",["widthFactor","decrease"]]);return a};this.getBoxplotMedianMenu=function(){var a=[];var b=false;a.push(["Median Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","boxplotMedianColor"]]);a.push(["Width","thickness",b,b,b,"changeTextColorAttributeMenu",["-text-","boxplotMedianWidth"]]);return a};this.getBoxplotMeanMenu=function(){var a=[];var b=false;a.push(["Mean Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","boxplotMeanColor"]]);a.push(["Mean Border Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","boxplotMeanColorBorder"]]);a.push([this.boxplotMean?"Hide Mean":"Show Mean",this.boxplotMean?"eyeClosed":"eye2","toggleAttribute",["boxplotMean"]]);return a};this.getWhiskersMenu=function(){var a=[];a.push(["Single","whiskersSingle","changeAttribute",["boxplotWhiskersType","single"]]);a.push(["Double","whiskersDouble","changeAttribute",["boxplotWhiskersType","double"]]);return a};this.getBoxplotTypeMenu=function(){var a=[];a.push(["Box and Whiskers",this.boxplotType=="range"?"radioOff":"radioOn","changeAttribute",["boxplotType","boxWhiskers"]]);a.push(["Range",this.boxplotType=="range"?"radioOn":"radioOff","changeAttribute",["boxplotType","range"]]);return a};this.getBinAlignmentMenu=function(){var b=[];b.push(["Left","binAlignmentLeft","changeAttribute",["binAlignment","left"]]);b.push(["Center","binAlignmentCenter","changeAttribute",["binAlignment","center"]]);b.push(["Right","binAlignmentRight","changeAttribute",["binAlignment","right"]]);return b};this.getDataPointsMenu=function(){var b=[];var a=false;b.push(["Jitter","jitter","toggleAttribute",["jitter"]]);b.push(["Binned","binned","toggleAttribute",["binned"]]);b.push(["Bin Aligment","binAlignment",a,a,a,"getBinAlignmentMenu",[]]);if(this.graphType=="Boxplot"){b.push([this.showBoxplotOriginalData?"Hide Data":"Show Data",this.showBoxplotOriginalData?"eyeClosed":"eye2","toggleAttribute",["showBoxplotOriginalData"]])}return b};this.getBoxplotAttributesMenu=function(){var b=[];var c=false;b.push(["Notch","notched","toggleAttribute",["boxplotNotched"]]);b.push(["Whiskers","wishkers",c,c,c,"getWhiskersMenu"]);b.push(["Boxplot Mean","boxplotMean",c,c,c,"getBoxplotMeanMenu",[]]);b.push(["Boxplot Median","boxplotMedian2",c,c,c,"getBoxplotMedianMenu",[]]);return b};this.getViolinTrimMenu=function(){var a=[];a.push(["Trim","violinTrimmed","changeAttribute",["violinTrim",true]]);a.push(["Not Trim","violinUntrimmed","changeAttribute",["violinTrim",false]]);return a};this.getViolinScaleMenu=function(){var a=[];a.push(["Area",this.violinScale=="area"?"radioOn":"radioOff","changeAttribute",["violinScale","area"]]);a.push(["Count",this.violinScale=="count"?"radioOn":"radioOff","changeAttribute",["violinScale","count"]]);a.push(["Width",this.violinScale=="width"?"radioOn":"radioOff","changeAttribute",["violinScale","width"]]);return a};this.getViolinAttributesMenu=function(){var b=[];var c=false;b.push(["Trim","violin2",c,c,c,"getViolinTrimMenu",[]]);b.push(["Scale","scale",c,c,c,"getViolinScaleMenu",[]]);b.push([this.showBoxplotIfViolin?"Hide Boxplot":"Show Boxplot",this.showBoxplotIfViolin?"eyeClosed":"eye2","toggleAttribute",["showBoxplotIfViolin"]]);b.push(["Boxplot ratio","thickness",c,c,c,"changeTextColorAttributeMenu",["-text-","boxplotWidthRatioIfViolin"]]);b.push([this.showViolinBoxplot?"Hide Violin":"Show Violin",this.showViolinBoxplot?"eyeClosed":"eye2","toggleAttribute",["showViolinBoxplot"]]);return b};this.getBoxplotMenu=function(){var a=[];var b=false;a.push(["Type","boxplotType",b,b,b,"getBoxplotTypeMenu",[]]);a.push(["Data Points","showData",b,b,b,"getDataPointsMenu",[]]);a.push(["Attributes","boxplotMedian",b,b,b,"getBoxplotAttributesMenu",[]]);a.push(["Violin Attributes","violin",b,b,b,"getViolinAttributesMenu",[]]);a.push(["Connect Boxplot","connects","toggleAttribute",["boxplotConnect"]]);return a};this.getPlotAreaOneMenu=function(){var b=[];var c=false;b.push(["Axis Algorithm","x",c,c,c,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",c,c,c,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",c,c,c,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeClosed":"eye2","toggleAttribute",["plotBox"]]);if(this.graphType.match(/Bar|Boxplot/)&&this.data.y.vars.length>1){b.push(["Variable Space","spacing",c,c,c,"getPlotAreaOneVariableSpaceMenu",[]])}b.push(["Sample Width","thickness",c,c,c,"getPlotAreaOneSampleWidthMenu",[]]);return b};this.getPlotAreaScatterMenu=function(){var b=[];var c=false;b.push(["Axis Algorithm",this.graphType=="Scatter3D"||this.is3DPlot?"xyz":"xy",c,c,c,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",c,c,c,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",c,c,c,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeClosed":"eye2","toggleAttribute",["plotBox"]]);return b};this.getAxesTitleXMenu=function(){var a=false;return[["Text","normal",a,a,a,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]]]};this.getAxesTitleX2Menu=function(){var a=false;return[["Text","normal",a,a,a,"changeTextColorAttributeMenu",["-text-","xAxis2Title"]]]};this.getAxesTitleYMenu=function(){var a=false;return[["Text","normal",a,a,a,"changeTextColorAttributeMenu",["-text-","yAxisTitle"]]]};this.getAxesTitleZMenu=function(){var a=false;return[["Text","normal",a,a,a,"changeTextColorAttributeMenu",["-text-","zAxisTitle"]]]};this.getAxesTitleMenu=function(){var a=[];var b=false;if(this.graphType.match(/scatter/i)||this.is3DPlot){if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["X-Axis","axes3DTitleX",b,b,b,"getAxesTitleXMenu",[]]);a.push(["Y-Axis","axes3DTitleY",b,b,b,"getAxesTitleYMenu",[]]);a.push(["Z-Axis","axes3DTitleZ",b,b,b,"getAxesTitleZMenu",[]])}else{a.push(["X-Axis","axes2DTitleX",b,b,b,"getAxesTitleXMenu",[]]);a.push(["Y-Axis","axes3DTitleY",b,b,b,"getAxesTitleYMenu",[]])}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){a.push(["First Axis","axes1DTitleFirst",b,b,b,"getAxesTitleXMenu",[]]);a.push(["Second Axis","axes1DTitleSecond",b,b,b,"getAxesTitleX2Menu",[]])}else{a.push(["Text","normal",b,b,b,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]])}}a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","axisTitleColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["axisTitle"]]);return a};this.getTitleMenu=function(){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","titleColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["title"]]);a.push(["Text","normal",b,b,b,"changeTextColorAttributeMenu",["-text-","title"]]);return a};this.getSubtitleMenu=function(){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","subtitleColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["subtitle"]]);a.push(["Text","normal",b,b,b,"changeTextColorAttributeMenu",["-text-","subtitle"]]);return a};this.getTitleSubtitleMenu=function(){var a=[];var b=false;if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["Title","mainScatterTitle",b,b,b,"getTitleMenu",[]]);a.push(["Subtitle","mainScatterSubtitle",b,b,b,"getSubtitleMenu",[]])}else{a.push(["Title",this.graphType=="Heatmap"?"mainHeatmapTitle":"main1DTitle",b,b,b,"getTitleMenu",[]]);a.push(["Subtitle",this.graphType=="Heatmap"?"mainHeatmapSubtitle":"main1DSubtitle",b,b,b,"getSubtitleMenu",[]])}return a};this.getLegendLocationMenu=function(){var a=[];a.push(["Inside Plot","toInside","changeAttribute",["legendInside",true]]);a.push(["Outside Plot","toOutside","changeAttribute",["legendInside",false]]);return a};this.getLegendPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","top","changeAttribute",["legendPosition","top"]]);a.push(["Top Right","topRight","changeAttribute",["legendPosition","topRight"]]);a.push(["Right","right","changeAttribute",["legendPosition","right"]]);a.push(["Bottom Right","bottomRight","changeAttribute",["legendPosition","bottomRight"]]);a.push(["Bottom","bottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["legendPosition","bottomLeft"]]);a.push(["Left","left","changeAttribute",["legendPosition","left"]]);a.push(["Top Left","topLeft","changeAttribute",["legendPosition","topLeft"]])}else{a.push(["Top","top","changeAttribute",["legendPosition","top"]]);a.push(["Bottom","bottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Right","right","changeAttribute",["legendPosition","right"]]);a.push(["Left","left","changeAttribute",["legendPosition","left"]])}return a};this.getLegendBorderMenu=function(){var a=[];var c=false;a.push(["Color","colors",c,c,c,"changeTextColorAttributeMenu",["-color-","legendBoxColor"]]);a.push([this.legendBox?"Hide Border":"Show Border",this.legendBox?"eyeClosed":"eye2","toggleAttribute",["legendBox"]]);return a};this.getLegendMenu=function(){var a=[];var b=false;a.push(["Border","square",b,b,b,"getLegendBorderMenu",[]]);a.push(["Background","background",b,b,b,"changeTextColorAttributeMenu",["-color-","legendBackgroundColor"]]);a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","legendColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["legend"]]);if(this.graphType!="Network"){a.push(["Position",this.legendInside?"toLocation2":"toLocation3",b,b,b,"getLegendPositionMenu",[]]);a.push(["Location","toLocation",b,b,b,"getLegendLocationMenu",[]])}a.push(["Columns","hash",b,b,b,"changeTextColorAttributeMenu",["-text-","legendColumns"]]);if(this.graphType!="Network"){a.push(["Reset Positions","refresh","resetLegendPosition"])}a.push([this.showLegend?"Hide Legend":"Show Legend",this.showLegend?"eyeClosed":"eye2","toggleAttribute",["showLegend"]]);return a};this.getIndicatorPositionMenu=function(){var a=[];a.push(["Right","right","changeAttribute",["heatmapIndicatorPosition","right"]]);a.push(["Top Right","topRight","changeAttribute",["heatmapIndicatorPosition","topRight"]]);a.push(["Top","top","changeAttribute",["heatmapIndicatorPosition","top"]]);a.push(["Top Left","topLeft","changeAttribute",["heatmapIndicatorPosition","topLeft"]]);return a};this.getIndicatorMenu=function(){var a=[];var b=false;a.push(["Position","toLocation2",b,b,b,"getIndicatorPositionMenu",[]]);a.push(["Height","heightness",b,b,b,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorHeight"]]);a.push(["Width","thickness",b,b,b,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorWidth"]]);a.push(["Histogram","indicatorHistogram","toggleAttribute",["heatmapIndicatorHistogram"]]);a.push([this.showHeatmapIndicator?"Hide Indicator":"Show Indicator",this.showHeatmapIndicator?"eyeClosed":"eye2","toggleAttribute",["showHeatmapIndicator"]]);return a};this.getDecorationsBorderMenu=function(){var a=[];var c=false;a.push(["Color","colors",c,c,c,"changeTextColorAttributeMenu",["-color-","decorationsBoxColor"]]);a.push([this.decorationsBox?"Hide Border":"Show Border",this.decorationsBox?"eyeClosed":"eye2","toggleAttribute",["decorationsBox"]]);return a};this.getDecorationsPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","top","changeAttribute",["decorationsPosition","top"]]);a.push(["Top Right","topRight","changeAttribute",["decorationsPosition","topRight"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]]);a.push(["Bottom Right","bottomRight","changeAttribute",["decorationsPosition","bottomRight"]]);a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["decorationsPosition","bottomLeft"]]);a.push(["Left","left","changeAttribute",["decorationsPosition","left"]]);a.push(["Top Left","topLeft","changeAttribute",["decorationsPosition","topLeft"]])}else{a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]])}return a};this.getDecorationsDataMenu=function(){return[[this.showDecorations?"Hide Decorations":"Show Decorations",this.showDecorations?"eyeClosed":"eye2","toggleAttribute",["showDecorations"]]]};this.getDecorationsLegendMenu=function(){return[[this.showDecorationsLegend?"Hide Decorations Legend":"Show Decorations Legend",this.showDecorationsLegend?"eyeClosed":"eye2","toggleAttribute",["showDecorationsLegend"]]]};this.getDecorationsConfidenceLevelMenu=function(){var a=[];var b=[0.5,0.75,0.8,0.85,0.9,0.95,0.99];for(var c=0;c<b.length;c++){a.push([b[c],this.confidenceLevel==b[c]?"radioOn":"radioOff","changeAttribute",["confidenceLevel",b[c]]])}return a};this.getDecorationsConfidenceTypeMenu=function(){var a=[];var c=["ordinary","log","loglog"];for(var b=0;b<c.length;b++){a.push([c[b],this.confidenceIntervalType==c[b]?"radioOn":"radioOff","changeAttribute",["confidenceIntervalType",c[b]]])}return a};this.getDecorationsConfidenceIntervalsMenu=function(){var c=this.decorations;var b=false;var a=[];if(c.reg||c.kaplanMeier){a.push([this.showConfidenceIntervals?"Hide Confidence Intervals":"Show Confidence Intervals",this.showConfidenceIntervals?"eyeClosed":"eye2","toggleAttribute",["showConfidenceIntervals"]])}if(c.kaplanMeier){a.push(["Confidence Level","normalDistribution",b,b,b,"getDecorationsConfidenceLevelMenu",[]]);a.push(["Confidence Type","function",b,b,b,"getDecorationsConfidenceTypeMenu",[]])}return a};this.getKaplanMeierByMenu=function(){var a=[];var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){a.push([c[b],c[b]==this.kaplanMeierBy?"radioOn":"radioOff","changeAttribute",["kaplanMeierBy",c[b],false,"updateKaplanMeier"]])}return a};this.getKaplanMeierMenu=function(){var a=[];var b=false;var c=this.decorations&&this.decorations.kaplanMeier;a.push([c?"Remove Kaplan-Meier Plot":"Create Kaplan-Meier Plot",c?"eyeClosed":"eye2","modifyKaplanMeier"]);a.push(["Invert Censor Value",this.invertCensored?"lightbulb":"lightbulbOff","toggleAttribute",["invertCensored"]]);if(c){a.push(["Confidence Intervals","kaplanMeyerConfidence",b,b,b,"getDecorationsConfidenceIntervalsMenu",[]])}if(this.data.z){a.push(["Kaplan Meier By","kaplanMeyer",b,b,b,"getKaplanMeierByMenu",[]])}return a};this.getDecorationsMenu=function(){var c=this.decorations;var b=false;var a=[];a.push(["Border","square",b,b,b,"getDecorationsBorderMenu",[]]);a.push(["Background","background",b,b,b,"changeTextColorAttributeMenu",["-color-","decorationsBackgroundColor"]]);a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","decorationsColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["decoration"]]);a.push(["Position",this.legendInside?"toInside":"toLocation2",b,b,b,"getDecorationsPositionMenu",[]]);a.push(["Data and Legend","database",b,b,b,"getDecorationsDataMenu",[]]);a.push(["Legend","legendScatter",b,b,b,"getDecorationsLegendMenu",[]]);if(c.reg){a.push(["Confidence Intervals","confidence",b,b,b,"getDecorationsConfidenceIntervalsMenu",[]])}return a};this.getOverlaysMemebersMenu=function(g,b){var f=[];var e={};for(var a=0;a<this[b+"Overlays"].length;a++){e[this[b+"Overlays"][a]]=true}var d=this.sortObject(this.data[g]);for(var a=0;a<d.length;a++){f.push([d[a],e[d[a]]?"checked":"unchecked",b=="var"?"modifyVariableOverlays":"modifySampleOverlays",[d[a]]])}return f};this.getOverlaysLegendMenu=function(g,b){var e=[];var f=this[b+"OverlayProperties"];var d=this.sortObject(this.data[g]);for(var a=0;a<d.length;a++){e.push([d[a],f[d[a]].showLegend?"eyeClosed":"eye2","modifyOverlaysProperties",[false,b+"OverlayProperties",d[a],"showLegend"]])}return e};this.getOverlaysPositionMemberMenu=function(a,b){var c=[];if(a=="var"){c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="horizontal"){c.push(["Left","left","modifyOverlaysProperties",["left",a+"OverlayProperties",b,"position"]]);c.push(["Right","right","modifyOverlaysProperties",["right",a+"OverlayProperties",b,"position"]])}else{c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}}return c};this.getOverlaysPositionMenu=function(h,b){var g=[];var e=false;var d=this.sortObject(this.data[h]);for(var a=0;a<d.length;a++){g.push([d[a],"cog2",e,e,e,"getOverlaysPositionMemberMenu",[b,d[a]]])}return g};this.getOverlaysThicknessMenu=function(h,b){var g=[];var e=false;var d=this.sortObject(this.data[h]);for(var a=0;a<d.length;a++){g.push([d[a],"cog2",e,e,e,"changeTextColorAttributeMenu",["-text-",[e,"modifyOverlaysProperties",[b+"OverlayProperties",d[a],"thickness"]]]])}return g};this.getOverlaysColorSchemesMenu=function(g,f){var e=[];var b=this.meta.data[g];var a=this.getColorSchemes();for(var d=0;d<a.length;d++){e.push([a[d],b[f].spectrum==a[d]?"radioOn":"radioOff","modifyColorProperties",[a[d],f,g]])}return e};this.getOverlaysColorMenu=function(j,d){var h=[];var g=false;var a=this.meta.data[j];var e=this.sortObject(this.data[j]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[j][e[b]])){if(this[d+"OverlayProperties"][e[b]]&&this[d+"OverlayProperties"][e[b]].type&&this[d+"OverlayProperties"][e[b]].type=="Heatmap"){h.push([e[b],"cog2",g,g,g,"getColorSpectrumMenu",[a[e[b]].colorBrew.spectrum,"modifyColorProperties",e[b],j]])}else{h.push([e[b],"cog2",g,g,g,"changeTextColorAttributeMenu",["-color-",[g,"modifyOverlaysProperties",[d+"OverlayProperties",e[b],"color"]]]])}}else{h.push([e[b],"cog2",g,g,g,"getOverlaysColorSchemesMenu",[j,e[b]]])}}return h};this.getOverlaysGraphTypeMenu=function(d,f){var e=[];var b=["Area","AreaLine","Bar","BarLine","Dotplot","DotLine","Heatmap","Line","Pie","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"];var a=["areaGraph","areaLineGraph","barGraph","barLineGraph","dotPlot","dotLineGraph","heatmapGraph","lineGraph","pieChart","stackedGraph","stackedLineGraph","stackedPercentage","stackedPercentageLine","treemapGraph"];for(var c=0;c<b.length;c++){e.push([b[c],a[c],"modifyOverlaysProperties",[b[c],d+"OverlayProperties",f,"type"]])}return e};this.getOverlaysGraphDefaultMenu=function(a,c){var b=[];b.push(["Default","heatmapGraph","modifyOverlaysProperties",["Heatmap",a+"OverlayProperties",c,"type"]]);b.push(["Text","text","modifyOverlaysProperties",["Text",a+"OverlayProperties",c,"type"]]);b.push(["Treemap","treemapGraph","modifyOverlaysProperties",["Treemap",a+"OverlayProperties",c,"type"]]);return b};this.getOverlaysGraphMenu=function(j,d){var h=[];var g=false;var a=this.meta.data[j];var e=this.sortObject(this.data[j]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[j][e[b]])){h.push([e[b],"cog2",g,g,g,"getOverlaysGraphTypeMenu",[d,e[b]]])}else{h.push([e[b],"cog2",g,g,g,"getOverlaysGraphDefaultMenu",[d,e[b]]])}}return h};this.getOverlaysPropertiesMenu=function(e,a){var d=[];var b=false;if(a=="var"){d.push(["Position","topBottom",b,b,b,"getOverlaysPositionMenu",[e,a]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="vertical"){d.push(["Position","leftRight",b,b,b,"getOverlaysPositionMenu",[e,a]])}else{d.push(["Position","topBottom",b,b,b,"getOverlaysPositionMenu",[e,a]])}}d.push(["Thickness","thickness",b,b,b,"getOverlaysThicknessMenu",[e,a]]);d.push(["Color","colors",b,b,b,"getOverlaysColorMenu",[e,a]]);d.push(["Type","graphType",b,b,b,"getOverlaysGraphMenu",[e,a]]);d.push(["Legend",this.graphType=="Heatmap"?"legendHeatmap":"legend1D",b,b,b,"getOverlaysLegendMenu",[e,a]]);return d};this.getLegendOverlaysPositionMenu=function(){var a=[];a.push(["Top Right","topRight","changeAttribute",["overlaysLegendPosition","topRight"]]);a.push(["Right","right","changeAttribute",["overlaysLegendPosition","right"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["overlaysLegendPosition","bottomLeft"]]);a.push(["Bottom","bottom","changeAttribute",["overlaysLegendPosition","bottom"]]);return a};this.getLegendOverlaysMenu=function(a){var b="show"+a+"OverlaysLegend";return[[this[b]?"Hide Legend":"Show Legend",this[b]?"eyeClosed":"eye2","toggleAttribute",[b]]]};this.getOverlaysMenu=function(){var b=[];var a=false;if(this.graphType=="Heatmap"&&this.data.z){b.push(["Variable Overlays","overlaysHeatmapVariables",a,a,a,"getOverlaysMemebersMenu",["z","var"]]);b.push(["Variable Overlays Properties","overlaysHeatmapVariablesProperties",a,a,a,"getOverlaysPropertiesMenu",["z","var"]]);b.push(["Variable Overlays Legend","legendHeatmap",a,a,a,"getLegendOverlaysMenu",["Var"]]);b.push(["-"])}if(this.data.x){b.push(["Sample Overlays",this.graphType=="Heatmap"?"overlaysHeatmapSamples":"overlays1D",a,a,a,"getOverlaysMemebersMenu",["x","smp"]]);b.push(["Sample Overlays Properties",this.graphType=="Heatmap"?"overlaysHeatmapSamplesProperties":"overlays1DProperties",a,a,a,"getOverlaysPropertiesMenu",["x","smp"]]);b.push(["Sample Overlays Legend",this.graphType=="Heatmap"?"legendHeatmap":"legend1D",a,a,a,"getLegendOverlaysMenu",["Smp"]]);b.push(["-"])}b.push(["Overlays Legend Position","toLocation2",a,a,a,"getLegendOverlaysPositionMenu",[]]);b.push(["-"]);b.push(["Label Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","overlayFontColor"]]);b.push(["Label Font","font",a,a,a,"getFontStyleMenu",["overlay"]]);b.push(["Default Thickness","thickness",a,a,a,"changeTextColorAttributeMenu",["-text-","overlaysThickness"]]);if(this.data.x||this.data.z){b.push([this.showOverlays?"Hide Overlays":"Show Overlays",this.showOverlays?"eyeClosed":"eye2","toggleAttribute",["showOverlays"]])}b.push(["More","more","showConfiguratorCategory",["event","Overlays"]]);return b};this.getBinDataPercentileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a]])}}return b};this.getBinDataQuantileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a]])}}return b};this.getBinDataCustomBinMenu=function(b){var c=[];for(var a=2;a<9;a++){c.push([a+" bins","radioOff","binDataCustom",[b,a]])}return c};this.getBinDataCustomMenu=function(){var d=[];var b=false;for(var a=0;a<this.data.y.vars.length;a++){d.push([this.data.y.vars[a],b,b,b,b,"getBinDataCustomBinMenu",[a]])}return d};this.getBinDataMenu=function(){var a=[];var c=false;a.push(["By Percentile Discrete","percentage3",c,c,c,"getBinDataPercentileMenu",[]]);a.push(["By Percentile Continuous","percentage3",c,c,c,"getBinDataPercentileMenu",[true]]);a.push(["By Quantile Discrete","quantiles",c,c,c,"getBinDataQuantileMenu",[]]);a.push(["By Quantile Continuous","quantiles",c,c,c,"getBinDataQuantileMenu",[true]]);a.push(["Custom","custom",c,c,c,"getBinDataCustomMenu",[]]);return a};this.getGroupSamplesMenu=function(){if(this.data.x){var d=[];var b={};var a=this.sortObject(this.data.x);for(var c=0;c<this.groupingFactors.length;c++){b[this.groupingFactors[c]]=true}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","modifySampleGroups",[a[c]]])}return d}else{return false}};this.getSmpLabelHighlightLevelMenu=function(){var c=[];var b={};var d=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<this.highlightSmp.length;a++){b[this.highlightSmp[a]]=true}for(var a=0;a<d.smps.length;a++){c.push([d.smps[a],b[d.smps[a]]?"checked":"unchecked","modifyObjectArray",[d.smps[a],false,"highlightSmp",true,true]])}return c};this.getSmpLabelHighlightMenu=function(){var a=[];var b=false;a.push(["Samples","samples",b,b,b,"getSmpLabelHighlightLevelMenu",[]]);a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","smpHighlightColor"]]);return a};this.getSmpLabelMenu=function(){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","smpLabelFontColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["smpLabel"]]);a.push(["Highlight",this.graphType=="Heatmap"?"sampleLabelsHeatmap":"sampleLabels1D",b,b,b,"getSmpLabelHighlightMenu",[]]);a.push(["Interval","hash",b,b,b,"changeTextColorAttributeMenu",["-text-","smpLabelInterval"]]);a.push(["Rotate","rotateClockwise",b,b,b,"changeTextColorAttributeMenu",["-text-","smpLabelRotate"]]);a.push([this.showSampleNames?"Hide Labels":"Show Labels",this.showSampleNames?"eyeClosed":"eye2","toggleAttribute",["showSampleNames"]]);return a};this.getVarLabelHighlightLevelMenu=function(){var d=[];var c={};var a=this.data.y.vars;for(var b=0;b<this.highlightVar.length;b++){c[this.highlightVar[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","modifyObjectArray",[a[b],false,"highlightVar",true,true]])}return d};this.getVarLabelHighlightMenu=function(){var a=[];var b=false;a.push(["Variables","variables",b,b,b,"getVarLabelHighlightLevelMenu",[]]);a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","varHighlightColor"]]);return a};this.getVarLabelMenu=function(c){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-","varLabelFontColor"]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",["varLabel"]]);a.push(["Highlight","heatmapHighlightVariables",b,b,b,"getVarLabelHighlightMenu",[]]);a.push(["Interval","hash",b,b,b,"changeTextColorAttributeMenu",["-text-","varLabelInterval"]]);a.push(["Rotate","rotateClockwise",b,b,b,"changeTextColorAttributeMenu",["-text-","varLabelRotate"]]);a.push([this.showVariableNames?"Hide Labels":"Show Labels",this.showVariableNames?"eyeClosed":"eye2","toggleAttribute",["showVariableNames"]]);return a};this.getGraphPartMenu=function(c,b){var a=[];var b=false;a.push(["Color","colors",b,b,b,"changeTextColorAttributeMenu",["-color-",c+(b?"FontColor":"Color")]]);a.push(["Font","font",b,b,b,"getFontStyleMenu",[c]]);a.push(["Text","normal",b,b,b,"changeTextColorAttributeMenu",["-text-",c]]);return a};this.getFontStyleMenu=function(c){var b=[];var a="ScaleFontFactor";b.push(["Bigger","increaseFontSize","setFontAttributeSize",[c+a,"increase"]]);b.push(["Smaller","decreaseFontSize","setFontAttributeSize",[c+a,"decrease"]]);b.push(["Normal","normal","setFontAttributeStyle",[c+"FontStyle","normal"]]);b.push(["Bold","bold","setFontAttributeStyle",[c+"FontStyle","bold"]]);b.push(["Italic","italic","setFontAttributeStyle",[c+"FontStyle","italic"]]);return b};this.getDataPointAttributesPropertySampleMenu=function(b){var d=[];var c=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<c.smps.length;a++){d.push([c.smps[a],this[b]==c.smps[a]?"radioOn":"radioOff","changeAttribute",[b,c.smps[a]]])}return d};this.getDataPointAttributesPropertyMenu=function(h){var j=[];var e=false;if(h=="treemapBy"){var a={};var b=this.sortObject(this.data.x);for(var c=0;c<this.treemapBy.length;c++){a[this.treemapBy[c]]=true}for(var c=0;c<b.length;c++){j.push([b[c],a[b[c]]?"checked":"unchecked","modifyTreemapGroups",[b[c]]])}}else{if(this.graphType!="Line"&&this.graphType!="ParallelCoordinates"){var g=this.graphType.match(/scatter/i)||this.graphType=="Map"?this.sortObject(this.data.z):this.sortObject(this.data.x);for(var c=0;c<g.length;c++){j.push([g[c],g[c]==this[h]?"radioOn":"radioOff","changeAttribute",[h,g[c]]])}j.push(["-"])}var c="variable";if(h!="connectBy"){j.push(["Variable",c==this[h]?"radioOn":"radioOff","changeAttribute",[h,c]])}if(((!this.graphType.match(/scatter/i)&&!this.graphType=="Map")||this.graphType=="Dotplot")&&this.data.z){var d=this.sortObject(this.data.z);if(h!="connectBy"||this.graphType=="Dotplot"){j.push(["-"])}for(var c=0;c<d.length;c++){if(h!="connectBy"||this.graphType=="Dotplot"){j.push([d[c],d[c]==this[h]?"radioOn":"radioOff","changeAttribute",[h,d[c]]])}}}if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Map"){j.push(["-"]);j.push(["Sample","samples",e,e,e,"getDataPointAttributesPropertySampleMenu",[h]])}}return j};this.getDataPointAttributesMenu=function(){var a=[];var b=false;if(this.graphType!="Heatmap"){a.push(["Color By","colors",b,b,b,"getDataPointAttributesPropertyMenu",["colorBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||this.graphType=="Tree"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Shape By","shapes",b,b,b,"getDataPointAttributesPropertyMenu",["shapeBy"]]);a.push(["Size By","sizes",b,b,b,"getDataPointAttributesPropertyMenu",["sizeBy"]])}if(!this.graphType.match(/parallelcoordinates|line/i)){a.push(["Pattern By","patterns",b,b,b,"getDataPointAttributesPropertyMenu",["patternBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Connect By","connects",b,b,b,"getDataPointAttributesPropertyMenu",["connectBy"]])}if(this.graphType.match(/stacked/i)&&this.data.x&&this.isGroupedData){a.push(["Treemap By","treemapGraph",b,b,b,"getDataPointAttributesPropertyMenu",["treemapBy"]])}if(this.graphType.match(/scatter/i)){a.push(["Ellipse By","ellipsises",b,b,b,"getDataPointAttributesPropertyMenu",["ellipseBy"]])}return a};this.getDendrogramColorMenu=function(d){var e=[];if(d){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){e.push([c[b],this.colorVarDendrogramBy==c[b]?"radioOn":"radioOff","changeAttribute",["colorVarDendrogramBy",c[b]]])}}else{var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){e.push([a[b],this.colorSmpDendrogramBy==a[b]?"radioOn":"radioOff","changeAttribute",["colorSmpDendrogramBy",a[b]]])}}return e};this.getDendrogramsMenu=function(){var a=[];var b=false;if(this.graphType=="Tree"){a.push(["Radial Layout",this.treeCircular?"checked":"unchecked","toggleAttribute",["treeCircular"]]);a.push(["Inverted Tree",this.treeInverted?"checked":"unchecked","toggleAttribute",["treeInverted"]])}else{if(this.graphType=="Heatmap"){a.push(["Cluster Variable","cluster2","clusterVariables",[true]]);a.push(["K-Means Variable","cluster4","kmeansVariables",[true]]);if(this.varDendrogram){a.push(["Color Variable Cluster By","colors",b,b,b,"getDendrogramColorMenu",[true]]);if(this.showVarDendrogram){a.push(["Hide Dendrogram","eyeClosed","showHideDendrogram",["showVarDendrogram"]])}else{a.push(["Show Dendrogram","eye2","showHideDendrogram",["showVarDendrogram"]])}}a.push(["-"])}a.push(["Cluster Samples","cluster","clusterSamples",[true]]);a.push(["K-Means Samples","cluster3","kmeansSamples",[true]]);if(this.smpDendrogram){a.push(["Color Sample Cluster By","colors",b,b,b,"getDendrogramColorMenu",[]]);if(this.showSmpDendrogram){a.push(["Hide Dendrogram","eyeClosed","showHideDendrogram",["showSmpDendrogram"]])}else{a.push(["Show Dendrogram","eye2","showHideDendrogram",["showSmpDendrogram"]])}}a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Clustering"]])}return a};this.getGraphTypeMenu=function(){var a=[];a.push(["Area","areaGraph","changeAttribute",["graphType","Area"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + A"]);a.push(["Area Line","areaLineGraph","changeAttribute",["graphType","AreaLine"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + F"]);a.push(["Bar","barGraph","changeAttribute",["graphType","Bar"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + B"]);a.push(["Bar Line","barLineGraph","changeAttribute",["graphType","BarLine"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + C"]);a.push(["Boxplot","boxPlot","changeAttribute",["graphType","Boxplot"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + I"]);a.push(["Circular","circularGraph","changeAttribute",["graphType","Circular"]]);a.push(["Correlation","correlationGraph","changeAttribute",["graphType","Correlation"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + X"]);a.push(["Dot Line","dotLineGraph","changeAttribute",["graphType","DotLine"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + E"]);a.push(["Dotplot","dotPlot","changeAttribute",["graphType","Dotplot"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + D"]);a.push(["Heatmap","heatmapGraph","changeAttribute",["graphType","Heatmap"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + H"]);a.push(["Line","lineGraph","changeAttribute",["graphType","Line"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + L"]);a.push(["Pie Chart","pieChart","changeAttribute",["graphType","Pie"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + P"]);if(this.data.y.smps.length>1){a.push(["Scatter 2D","scatter2D","changeAttribute",["graphType","Scatter2D"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + 2"])}if(this.data.y.smps.length>2){a.push(["Scatter Bubble 2D","scatter2DBubble","changeAttribute",["graphType","ScatterBubble2D"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + 4"]);a.push(["Scatter 3D","scatter3D","changeAttribute",["graphType","Scatter3D"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + 3"])}a.push(["Stacked","stackedGraph","changeAttribute",["graphType","Stacked"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + S"]);a.push(["Stacked Line","stackedLineGraph","changeAttribute",["graphType","StackedLine"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + U"]);a.push(["Stacked Percent","stackedPercentage","changeAttribute",["graphType","StackedPercent"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + T"]);a.push(["Stacked Percent Line","stackedPercentageLine","changeAttribute",["graphType","StackedPercentLine"],CanvasXpress.system.shift+" + "+CanvasXpress.system.alt+" + W"]);a.push(["Tag Cloud","wordCloud","changeAttribute",["graphType","TagCloud"]]);a.push(["Parallel Coordinates","lineGraph","changeAttribute",["graphType","ParallelCoordinates"]]);a.push(["Sankey","sankeyDiagram","changeAttribute",["graphType","Sankey"]]);a.push(["Tree","treeGraph","changeAttribute",["graphType","Tree"]]);a.push(["Treemap","treemapGraph","changeAttribute",["graphType","Treemap"]]);return a};this.getGraphOrientationMenu=function(){var a=[];a.push(["Horizontal","graphOrientationHorizontal","changeAttribute",["graphOrientation","horizontal"]]);a.push(["Vertical","graphOrientationVertical","changeAttribute",["graphOrientation","vertical"]]);return a};this.getMarginsMenu=function(){var b=[];var a=false;b.push(["Global","margins",a,a,a,"changeTextColorAttributeMenu",["-text-","margin"]]);b.push(["-"]);b.push(["Bottom","marginBottom",a,a,a,"changeTextColorAttributeMenu",["-text-","marginBottom"]]);b.push(["Left","marginLeft",a,a,a,"changeTextColorAttributeMenu",["-text-","marginLeft"]]);b.push(["Top","marginTop",a,a,a,"changeTextColorAttributeMenu",["-text-","marginTop"]]);b.push(["Right","marginRight",a,a,a,"changeTextColorAttributeMenu",["-text-","marginRight"]]);return b};this.getShadesMenu=function(){var b=[];var a=false;b.push(["Objects","shadow","toggleAttribute",["showShadow"]]);b.push(["Text","shadowText","toggleAttribute",["showTextShadow"]]);b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","shadowColor"]]);b.push(["More","more","showConfiguratorCategory",["event","Shadows"]]);return b};this.getCanvasBorderMenu=function(){var b=[];var a=false;b.push(["Color","colors",a,a,a,"changeTextColorAttributeMenu",["-color-","canvasBoxColor"]]);b.push([this.canvasBox?"Hide Border":"Show Border",this.canvasBox?"eyeClosed":"eye2","toggleAttribute",["canvasBox"]]);return b};this.getGradientsOrientationMenu=function(){var a=[];a.push(["Horizontal","gradientHorizontalLeft","changeAttribute",["gradientOrientation","horizontal"]]);a.push(["Vertical","gradientVerticalTop","changeAttribute",["gradientOrientation","vertical"]]);return a};this.getGradientsTypeMenu=function(){var a=[];a.push(["Linear","gradientVerticalTop","changeAttribute",["gradientType","linear"]]);a.push(["Radial","gradientRadial","changeAttribute",["gradientType","radial"]]);return a};this.getGradientsMenu=function(){var a=[];var b=false;a.push(["Gradient","gradientToggle","toggleAttribute",["gradient"]]);a.push(["Orientation","gradientOrientation",b,b,b,"getGradientsOrientationMenu",[]]);a.push(["Type","gradientType",b,b,b,"getGradientsTypeMenu",[]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Gradients"]]);return a};this.getBackgroundTypeMenu=function(){var a=[];a.push(["Solid","background","changeAttribute",["backgroundType","solid","solid"]]);a.push(["Gradient","background3","changeAttribute",["backgroundType","gradient","gradient"]]);a.push(["Solid Window","background2","changeAttribute",["backgroundType","window","window"]]);a.push(["Solid Window on Gradient","background5","changeAttribute",["backgroundType","windowGradient","windowGradient"]]);a.push(["Gradient Window on Solid","background4","changeAttribute",["backgroundType","windowSolidGradient","windowSolidGradient"]]);return a};this.getBackgroundMenu=function(){var b=[];var a=false;b.push(["Type","backgroundType",a,a,a,"getBackgroundTypeMenu",[]]);b.push(["-"]);b.push(["Background Color","background",a,a,a,"changeTextColorAttributeMenu",["-color-","background"]]);b.push(["Window Color","background2",a,a,a,"changeTextColorAttributeMenu",["-color-","backgroundWindow"]]);b.push(["Gradient Start Color","gradientVerticalTop",a,a,a,"changeTextColorAttributeMenu",["-color-","backgroundGradient1Color"]]);b.push(["Gradient End Color","gradientVerticalBottom",a,a,a,"changeTextColorAttributeMenu",["-color-","backgroundGradient2Color"]]);b.push(["-"]);b.push(["More","more","showConfiguratorCategory",["event","Background"]]);return b};this.getFontsSizeStyleMenu=function(){var a=[];a.push(["Bigger","increaseFontSize","setFontAttributeSize",["fontScaleFontFactor","increase"]]);a.push(["Smaller","decreaseFontSize","setFontAttributeSize",["fontScaleFontFactor","decrease"]]);a.push(["Normal","normal","setFontAttributeStyle",["fontStyle","normal"]]);a.push(["Bold","bold","setFontAttributeStyle",["fontStyle","bold"]]);a.push(["Italic","italic","setFontAttributeStyle",["fontStyle","italic"]]);return a};this.getFontsMenu=function(){var a=[];var b=false;a.push(["Size and Style","font",b,b,b,"getFontsSizeStyleMenu",[]]);a.push(["-"]);a.push(["Architects Daughter",this.fontName=="Architects Daughter"?"radioOn":"radioOff","changeAttribute",["fontName","Architects Daughter","Architects Daughter"]]);a.push(["Arial",this.fontName=="Arial"?"radioOn":"radioOff","changeAttribute",["fontName","Arial","Arial"]]);a.push(["Courier",this.fontName=="Courier"?"radioOn":"radioOff","changeAttribute",["fontName","Courier","Courier"]]);a.push(["Indie Flower",this.fontName=="Indie Flower"?"radioOn":"radioOff","changeAttribute",["fontName","Indie Flower","Indie Flower"]]);a.push(["Roboto",this.fontName=="Roboto"?"radioOn":"radioOff","changeAttribute",["fontName","Roboto","Roboto"]]);a.push(["Ubuntu",this.fontName=="Ubuntu"?"radioOn":"radioOff","changeAttribute",["fontName","Ubuntu","Ubuntu"]]);a.push(["Verdana",this.fontName=="Verdana"?"radioOn":"radioOff","changeAttribute",["fontName","Verdana","Verdana"]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Text"]]);return a};this.getLayoutVarMenu=function(){var d=[];var a={};for(var b=0;b<this.segregateVariablesBy.length;b++){a[this.segregateVariablesBy[b]]=true}if(this.data.z){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","modifyVariableSegregation",[c[b]]])}if(!this.graphType.match(/Scatter/)){d.push(["-"])}}if(!this.graphType.match(/Scatter/)){d.push(["variable",a.variable?"checked":"unchecked","modifyVariableSegregation",["variable"]])}return d};this.getLayoutSmpMenu=function(){var a=[];var d={};for(var c=0;c<this.segregateSamplesBy.length;c++){d[this.segregateSamplesBy[c]]=true}if(this.data.x){var b=this.sortObject(this.data.x);for(var c=0;c<b.length;c++){a.push([b[c],d[b[c]]?"checked":"unchecked","modifySampleSegregation",[b[c]]])}if(!this.graphType.match(/Scatter/)){a.push(["-"])}}if(!this.graphType.match(/Scatter/)){a.push(["sample",d.sample?"checked":"unchecked","modifySampleSegregation",["sample"]])}return a};this.getLayoutMenu=function(){var a=[];var b=false;a.push(["Segregate Samples By","samples",b,b,b,"getLayoutSmpMenu",[]]);a.push(["Segregate Variables By","variables",b,b,b,"getLayoutVarMenu",[]]);return a};this.getSegregationMenu=function(){var c={};var d=[];if(this.isQQ||this.isCDF){d.push(["sample",c.sample?"checked":"unchecked","modifySampleSegregation",["sample"]])}else{if(this.data.z&&!this.scatterPlotMatrix){var e=this.sortObject(this.data.z);for(var b=0;b<this.segregateVariablesBy.length;b++){c[this.segregateVariablesBy[b]]=true}for(var b=0;b<e.length;b++){d.push([e[b],c[e[b]]?"checked":"unchecked","modifyVariableSegregation",[e[b]]])}}if(this.data.x&&!this.scatterPlotMatrix){var a=this.sortObject(this.data.x);for(var b=0;b<this.segregateSamplesBy.length;b++){c[this.segregateSamplesBy[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","modifySampleSegregation",[a[b]]])}}if(!this.graphType.match(/Scatter/)){d.push(["variable",c.variable?"checked":"unchecked","modifyVariableSegregation",["variable"]]);d.push(["sample",c.sample?"checked":"unchecked","modifySampleSegregation",["sample"]])}}if(!this.is3DPlot&&d.length>0){return d}else{return false}};this.getColorSpectrumMenu=function(b,g,m,l,k){var c=[];var a=this.getObjectArray(b);var f=this.getColorNames();for(var e=0;e<f.length;e++){if(a[f[e]]){var h=0;for(var d=0;d<b.length;d++){if(f[e]==b[d]){h=d;break}}if(m&&l){c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e],m,l]])}else{c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e]]])}}else{if(m&&l){c.push([f[e],"unchecked",g,[f[e],m,l]])}else{c.push([f[e],"unchecked",g,[f[e]]])}}}return c};this.getColorSpectrumSchemeMenu=function(e,f){var d=[];var a=this.getColorSchemes();for(var b=0;b<a.length;b++){d.push([a[b],this[e]==a[b]?"radioOn":"radioOff","changeAttribute",["colorSpectrum",[],false,f,a[b]]])}return d};this.getColorSchemeMenu=function(e,f){var d=[];var a=this.getColorSchemes();for(var b=0;b<a.length;b++){d.push([a[b],this[e]==a[b]?"radioOn":"radioOff","changeAttribute",[e,a[b],false,f]])}return d};this.getColorsSpectrumCompMenu=function(){var b=[];var a=false;b.push(["Spectrum By Colors","colors",a,a,a,"getColorSpectrumMenu",[this.colorSpectrum,"modifyColorSpectrum"]]);b.push(["Spectrum By Scheme","palette",a,a,a,"getColorSpectrumSchemeMenu",["colorScheme","modifyColorSpectrumByScheme"]]);b.push(["Spectrum Color Number","hash",a,a,a,"changeTextColorAttributeMenu",["-text-","colorSpectrumTarget"]]);b.push(["Zero-Center","zscore",a,a,a,"changeTextColorAttributeMenu",["-text-",[a,"modifyColorSpectrumZeroValue",[null]]]]);return b};this.getColorBlindTypeMenu=function(){var a=[];a.push(["No Blind Type",!this.blindnessType?"radioOn":"radioOff","changeAttribute",["blindnessType",false]]);a.push(["Protanopia",this.blindnessType=="protanopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","protanopia"]]);a.push(["Deuteranopia",this.blindnessType=="deuteranopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","deuteranopia"]]);a.push(["Tritanopia",this.blindnessType=="tritanopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","tritanopia"]]);a.push(["Monochromatic",this.blindnessType=="monochromatic"?"radioOn":"radioOff","changeAttribute",["blindnessType","monochromatic"]]);return a};this.getColorsMenu=function(){var b=[];var a=false;b.push(["Blind Type","eyeCrossed",a,a,a,"getColorBlindTypeMenu",[]]);b.push(["Scheme","palette",a,a,a,"getColorSchemeMenu",["colorScheme","modifyColorScheme"]]);b.push(["Spectrum","theme",a,a,a,"getColorsSpectrumCompMenu",[]]);return b};this.getResizeMenu=function(){var b=[];var a=false;b.push(["Height","height",a,a,a,"changeTextColorAttributeMenu",["-text-",["height","setHeight"]]]);b.push(["Width","width",a,a,a,"changeTextColorAttributeMenu",["-text-",["width","setWidth"]]]);return b};this.getThemeMenu=function(){var a=[];a.push(["CanvasXpress",this.theme=="cx"?"radioOn":"radioOff","changeTheme",["cx"]]);a.push(["Economist",this.theme=="economist"?"radioOn":"radioOff","changeTheme",["economist"]]);a.push(["GGPlot",this.theme=="ggplot"?"radioOn":"radioOff","changeTheme",["ggplot"]]);a.push(["Gray-Inverse",this.theme=="igray"?"radioOn":"radioOff","changeTheme",["igray"]]);a.push(["Excel",this.theme=="excel"?"radioOn":"radioOff","changeTheme",["excel"]]);a.push(["Paul Tol",this.theme=="paulTol"?"radioOn":"radioOff","changeTheme",["paulTol"]]);a.push(["Solarized",this.theme=="solarized"?"radioOn":"radioOff","changeTheme",["solarized"]]);a.push(["Stata",this.theme=="stata"?"radioOn":"radioOff","changeTheme",["stata"]]);a.push(["Tableau",this.theme=="tableau"?"radioOn":"radioOff","changeTheme",["tableau"]]);a.push(["Wall Street Journal",this.theme=="wallStreetJournal"?"radioOn":"radioOff","changeTheme",["wallStreetJournal"]]);a.push(["-"]);a.push(["None",this.theme=="none"?"radioOn":"radioOff","changeTheme",["none"]]);return a};this.getGeneralMenu=function(){var b=[];var a=false;b.push(["Background","background",a,a,a,"getBackgroundMenu",[]]);b.push(["Border","square",a,a,a,"getCanvasBorderMenu",[]]);b.push(["Color","colors",a,a,a,"getColorsMenu",[]]);b.push(["Font","font",a,a,a,"getFontsMenu",[]]);b.push(["Gradients","gradientVerticalTop",a,a,a,"getGradientsMenu",[]]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){b.push(["Graph Orientation","graphOrientation",a,a,a,"getGraphOrientationMenu",[]])}b.push(["Graph Type","graphType",a,a,a,"getGraphTypeMenu",[]]);if(!this.is3DPlot&&(this.data.x||this.data.z)){b.push(["Layout","segregate",a,a,a,"getLayoutMenu",[]])}b.push(["Margins","margins",a,a,a,"getMarginsMenu",[]]);b.push(["Shadows","shadow",a,a,a,"getShadesMenu",[]]);b.push(["Size","resize",a,a,a,"getResizeMenu",[]]);b.push(["Theme","theme",a,a,a,"getThemeMenu",[]]);b.push(["Transparency","transparency",a,a,a,"changeTextColorAttributeMenu",["-text-","transparency"]]);return b};this.getSwitchSmpToAnnotationMenu=function(){var b=[];for(var a=0;a<this.data.y.smps.length;a++){b.push([this.data.y.smps[a],"radioOff","switchSmpToAnnotation",[this.data.y.smps[a]]])}return b};this.getSwitchAnnotationToSmpMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]]){c.push([b[a],"radioOff","switchAnnotationToSmp",[b[a]]])}}return c};this.getSwitchSmpAnnotationToIdMenu=function(){var c=[];var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){if(this.meta.data.x[a[b]].unique){c.push([a[b],"radioOff","switchSmpAnnotationToId",[a[b]]])}}return c};this.getSwitchVarToAnnotationMenu=function(){var a=[];for(var b=0;b<this.data.y.vars.length;b++){a.push([this.data.y.vars[b],"radioOff","switchVarToAnnotation",[this.data.y.vars[b]]])}return a};this.getSwitchAnnotationToVarMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){if(this.meta.data.x[a[c]]){b.push([a[c],"radioOff","switchAnnotationToVar",[a[c]]])}}return b};this.getSwitchVarAnnotationToIdMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]].unique){c.push([b[a],"radioOff","switchVarAnnotationToId",[b[a]]])}}return c};this.getSwitchSamplesMenu=function(){var a=[];var b=false;a.push(["Sample to Annotation","switchDown",b,b,b,"getSwitchSmpToAnnotationMenu",[]]);if(this.data.z){a.push(["Annotation to Sample","switchUp",b,b,b,"getSwitchAnnotationToSmpMenu",[]])}if(this.data.x&&this.isUniqueFactor("s")){a.push(["Annotation to Id","switch",b,b,b,"getSwitchSmpAnnotationToIdMenu",[]])}a.push(["Create New Sample Id","more","switchSmpIdToAnnotation",[]]);return a};this.getSwitchVariablesMenu=function(){var a=[];var b=false;a.push(["Variable to Annotation","switchDown",b,b,b,"getSwitchVarToAnnotationMenu",[]]);if(this.data.x){a.push(["Annotation to Variable","switchUp",b,b,b,"getSwitchAnnotationToVarMenu",[]])}if(this.data.z&&this.isUniqueFactor("v")){a.push(["Annotation to Id","switch",b,b,b,"getSwitchVarAnnotationToIdMenu",[]])}a.push(["Create New Variable Id","more","switchVarIdToAnnotation",[]]);return a};this.getSwitchMenu=function(){var a=[];var b=false;a.push(["Samples","samples",b,b,b,"getSwitchSamplesMenu",[]]);a.push(["Variables","variables",b,b,b,"getSwitchVariablesMenu",[]]);return a};this.getConvertNumericToStringMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type=="Numeric"){d.push([e[a],"radioOff","switchNumericToString",[e[a],b]])}}return d};this.getConvertStringToNumericMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type!="Numeric"){d.push([e[a],"radioOff","switchStringToNumeric",[e[a],b]])}}return d};this.getConvertVarSmpMenu=function(e,a){var d=[];var b=false;if(this.isNumericFactor(a)){d.push(["Numeric to String","toString",b,b,b,"getConvertNumericToStringMenu",[e,a=="s"]])}if(this.isStringFactor(a)){d.push(["String to Numeric","toNumeric",b,b,b,"getConvertStringToNumericMenu",[e,a=="s"]])}return d};this.getConvertMenu=function(){var b=[];var a=false;if(this.data.x){b.push(["Samples","samples",a,a,a,"getConvertVarSmpMenu",["x","s"]])}if(this.data.z){b.push(["Variables","variables",a,a,a,"getConvertVarSmpMenu",["z","v"]])}return b};this.getTransformPercentMenu=function(){var a=[];a.push(["By Sample","samples","transform",["percentile","samples"]]);a.push(["By Variable","variables","transform",["percentile","variables"]]);return a};this.getTransformZScoreMenu=function(){var a=[];a.push(["By Sample","samples","transform",["zscore","samples"]]);a.push(["By Variable","variables","transform",["zscore","variables"]]);return a};this.getTransformRatioMenu=function(){var b=[];var a=false;b.push(["To Sample","samples",a,a,a,"getTransformRatioSmpMenu",[]]);if(this.data.x&&this.isGroupedData){b.push(["To Group","groups",a,a,a,"getTransformRatioGrpMenu",[]]);if(this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){b.push(["To Level","levels",a,a,a,"getTransformRatioLevMenu",[]])}}return b};this.getTransformRatioLevMenu=function(){var c=[];var a=this.sortObject(this.getObjectArray(this.data.x[this.ratioGroupReference]));for(var b=0;b<a.length;b++){if(a[b]!=null){c.push([a[b],this.ratioLevelReference==a[b]?"radioOn":"radioOff","modifyTransformRatio",["level",a[b]]])}}return c};this.getTransformRatioGrpMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){b.push([a[c],this.ratioGroupReference==a[c]?"radioOn":"radioOff","modifyTransformRatio",["group",a[c]]])}return b};this.getTransformRatioSmpMenu=function(){var c=[];for(var a=0;a<this.data.y.smps.length;a++){var b=this.data.y.smps[a];c.push([b,this.ratioSampleReference==b?"radioOn":"radioOff","modifyTransformRatio",["sample",b]])}return c};this.getTransformMenu=function(){var b=[];var a=false;b.push(["Log Base 2","logarithm2","transform",["log2"]]);b.push(["Log Base 10","logarithm10","transform",["log10"]]);b.push(["Exp Base 2","exponent2","transform",["exp2"]]);b.push(["Exp Base 10","exponent10","transform",["exp10"]]);b.push(["Ceil data","ceil",a,a,a,"changeTextColorAttributeMenu",["-text-",[a,"modifyTransform",["tceil"]]]]);b.push(["Floor data","floor",a,a,a,"changeTextColorAttributeMenu",["-text-",[a,"modifyTransform",["tfloor"]]]]);b.push(["Percentile","percentage3",a,a,a,"getTransformPercentMenu",[]]);b.push(["Z-Score","zscore",a,a,a,"getTransformZScoreMenu",[]]);b.push(["Ratio","ratio",a,a,a,"getTransformRatioMenu",[]]);b.push(["-"]);b.push(["Reset","refresh","transform",["reset"]]);b.push(["-"]);b.push(["Overwrite data","disckette","transform",["save"]]);return b};this.getAxisTransformMenu=function(b){var c=[];b=b.toLowerCase();c.push(["Log Base 2","logarithm2","changeAttribute",[b+"AxisTransform","log2"]]);c.push(["Log Base 10","logarithm10","changeAttribute",[b+"AxisTransform","log10"]]);c.push(["Exp Base 2","exponent2","changeAttribute",[b+"AxisTransform","exp2"]]);c.push(["Exp Base 10","exponent10","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["Percentile","percentage3","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["-"]);c.push(["Reset","refresh","changeAttribute",[b+"AxisTransform",false]]);return c};this.getSortSmpIntensityMenu=function(){var c=[];var a={};if(this.sortingSamples){for(var b=0;b<this.sortingSamples.length;b++){a[this.sortingSamples[b]]=true}}for(var b=0;b<this.data.y.smps.length;b++){c.push([this.data.y.smps[b],a[b+1]?"radioOn":"radioOff","modifySort",["smp","var",this.data.y.smps[b]]])}return c};this.getSortVarIntensityMenu=function(){var c=[];var a={};if(this.sortingVariables){for(var b=0;b<this.sortingVariables.length;b++){a[this.sortingVariables[b]]=true}}for(var b=0;b<this.data.y.vars.length;b++){c.push([this.data.y.vars[b],a[b+1]?"radioOn":"radioOff","modifySort",["var","smp",this.data.y.vars[b]]])}return c};this.getSortSmpCatMenu=function(){var d=[];var b={};var a=this.sortObject(this.data.x);if(this.sortingSampleCategories){for(var c=0;c<this.sortingSampleCategories.length;c++){b[this.sortingSampleCategories[c]]=true}}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","modifySort",["cat","smp",a[c]]])}return d};this.getSortVarCatMenu=function(){var d=[];var a={};var c=this.sortObject(this.data.z);if(this.sortingVariableCategories){for(var b=0;b<this.sortingVariableCategories.length;b++){a[this.sortingVariableCategories[b]]=true}}for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","modifySort",["cat","var",c[b]]])}return d};this.getSortSmpMenu=function(){var a=[];var b=false;a.push(["By Variable Intensity","variables",b,b,b,"getSortVarIntensityMenu",[]]);if(this.data.x){a.push(["By Sample Category","Xu",b,b,b,"getSortSmpCatMenu",[]])}a.push(["By Name","samples","modifySort",["cat","smp","samples"]]);return a};this.getSortVarMenu=function(){var a=[];var b=false;a.push(["By Sample Intensity","samples",b,b,b,"getSortSmpIntensityMenu",[]]);if(this.data.z){a.push(["By Variable Category","zscore",b,b,b,"getSortVarCatMenu",[]])}a.push(["By Name","variables","modifySort",["cat","var","variables"]]);return a};this.getSortMenu=function(){var a=[];var b=false;if(this.sortDir=="ascending"){a.push(["Change Sort","descending","changeAttribute",["sortDir","descending",true,"modifySort",["both"]]])}else{a.push(["Change Sort","ascending","changeAttribute",["sortDir","ascending",true,"modifySort",["both"]]])}a.push(["Case Sensitive",this.sortCaseSensitive?"checked":"unchecked","toggleAttribute",["sortCaseSensitive","modifySort",["both"]]]);a.push(["-"]);a.push(["Sort Samples","samples",b,b,b,"getSortSmpMenu",[]]);a.push(["Sort Variables","variables",b,b,b,"getSortVarMenu",[]]);return a};this.getSliderMenu=function(){var b=[];var a=false;for(var c in this.binConfigurations){b.push([c,a,a,a,a,[["-slider-","changeBin",[c]]]])}return b};this.getPivotMenu=function(){var c=[];if(this.isPivotable()){var a=this.data.x?this.sortObject(this.data.x):[];if(this.data.y.vars.length==3){var d=this.data.y.vars;c.push([d[0]+" as Variables; "+d[1]+" as Samples","radioOff","pivotYY",[d[0],d[1]]]);c.push([d[0]+" as Variables; "+d[2]+" as Samples","radioOff","pivotYY",[d[0],d[2]]]);c.push([d[1]+" as Variables; "+d[0]+" as Samples","radioOff","pivotYY",[d[1],d[0]]]);c.push([d[1]+" as Variables; "+d[2]+" as Samples","radioOff","pivotYY",[d[1],d[2]]]);c.push([d[2]+" as Variables; "+d[0]+" as Samples","radioOff","pivotYY",[d[2],d[0]]]);c.push([d[2]+" as Variables; "+d[1]+" as Samples","radioOff","pivotYY",[d[2],d[1]]])}else{if(this.data.y.vars.length==2){var d=this.data.y.vars;c.push([a[0]+" as Variables; "+d[0]+" as Samples","radioOff","pivotXY",[a[0],d[0]]]);c.push([a[0]+" as Variables; "+d[1]+" as Samples","radioOff","pivotXY",[a[0],d[1]]]);c.push([d[0]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[d[0],a[0]]]);c.push([d[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[d[1],a[0]]])}else{if(a.length==2){c.push([a[0]+" as Variables; "+a[1]+" as Samples","radioOff","pivotXX",[a[0],a[1]]]);c.push([a[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXX",[a[1],a[0]]])}}}for(var b=0;b<a.length;b++){if(this.meta.data.x[a[b]].type=="String"){c.push(["Pivot on "+a[b],"radioOff","pivotX",[a[b]]])}}}return c};this.getRdatasetsMenu=function(){var a=[];if(this.Rdatasets){var c=this.sortObject(this.Rdatasets);c=c.sort(function(e,d){return e.toLowerCase()>d.toLowerCase()});for(var b=0;b<c.length;b++){a.push([c[b],"radioOff","getRLibraryDataSets",[c[b]]])}}return a};this.getRangeMenu=function(){var a=[];var b=false;a.push(["Set Min","min",b,b,b,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","max",b,b,b,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);a.push(["Exact Range","exact","toggleAttribute",["xAxisExact"]]);return a};this.getSummaryTypeMenu=function(){var c=[];var b=["mean","median","min","max","sum"];c.push(["Raw",!this.summaryType||this.summaryType=="raw"?"radioOn":"radioOff","modifySummaryType",["raw"]]);for(var a=0;a<b.length;a++){c.push([this.capitalize(b[a]),this.summaryType==b[a]?"radioOn":"radioOff","modifySummaryType",[b[a]]])}return c};this.getDataMenu=function(){var a=[];var b=false;if(this.isBinConfigurations()){a.push(["Configure Bins","bold",b,b,b,"getSliderMenu",[]])}if(this.data.x||this.data.z){a.push(["Convert Annotations","convert",b,b,b,"getConvertMenu",[]])}if(this.graphType=="Heatmap"){a.push(["Range","range",b,b,b,"getRangeMenu",[]])}a.push(["Summary Type","summary",b,b,b,"getSummaryTypeMenu",[]]);a.push(["Switch Data","switch",b,b,b,"getSwitchMenu",[]]);if(!this.graphType.match(/Scatter/i)){a.push(["Sort","ascending",b,b,b,"getSortMenu",[]])}a.push(["Transform","function",b,b,b,"getTransformMenu",[]]);if(!this.layoutValid){a.push(["Transpose","transpose","transpose"])}if(this.isPivotable()&&!this.isPivot){a.push(["Pivot","pivot",b,b,b,"getPivotMenu",[]])}else{if(this.isPivot){a.push(["Remove Pivot","pivotCrossed","removePivot"])}}if(!this.layoutValid){a.push(["Bin Data","histogram",b,b,b,"getBinDataMenu",[]])}return a};this.getLoessMenu=function(){var a=[];a.push([this.showLoessFit?"Hide Loess Fit":"Show Loess Fit",this.showLoessFit?"eyeClosed":"eye2","toggleAttribute",["showLoessFit"]]);return a};this.getHistogramDensityMenu=function(){var b=["epanechnikov","uniform","triangular","quartic","triweight","gaussian","cosine"];var a=[];for(var c=0;c<b.length;c++){a.push([b[c],b[c]==this.densityKernel?"radioOn":"radioOff","changeAttribute",["densityKernel",b[c],false,"modifyHistogram"]])}return a};this.getHistogramMedianLineStyleMenu=function(){var a=[];a.push(["Solid","lineTypeSolid","changeAttribute",["histogramMedianLineStyle","solid"]]);a.push(["Dotted","lineTypeDotted","changeAttribute",["histogramMedianLineStyle","dotted"]]);a.push(["Dashed","lineTypeDashed","changeAttribute",["histogramMedianLineStyle","dashed"]]);return a};this.getHistogramMenu=function(){var b=[];var a=false;b.push(["Bin Number","hash",a,a,a,"changeTextColorAttributeMenu",["-text-",["histogramBins","modifyHistogram"]]]);b.push(["Density Kernel","fit",a,a,a,"getHistogramDensityMenu",[]]);b.push(["Remove Histogram","histogramCrossed","removeHistogram"]);b.push([this.hideHistogram?"Show Histogram Bars":"Hide Histogram Bars",this.hideHistogram?"eye2":"eyeClosed","toggleAttribute",["hideHistogram"]]);b.push(["Stagger Histograms","histogramStaggered","toggleAttribute",["histogramStagger","modifyHistogram"]]);b.push([this.showHistogramDensity?"Hide Density":"Show Density",this.showHistogramDensity?"eyeClosed":"eye2","toggleAttribute",["showHistogramDensity","modifyHistogram"]]);b.push([this.showFilledHistogramDensity?"Hide Filled Density":"Show Filled Density",this.showFilledHistogramDensity?"eyeClosed":"eye2","toggleAttribute",["showFilledHistogramDensity"]]);b.push(["Fill Transparency","transparency",a,a,a,"changeTextColorAttributeMenu",["-text-","histogramDensityFillTransparency"]]);b.push([this.showHistogramMedian?"Hide Median":"Show Median",this.showHistogramMedian?"eyeClosed":"eye2","toggleAttribute",["showHistogramMedian"]]);b.push(["Median Line Style","lineTypePattern",a,a,a,"getHistogramMedianLineStyleMenu",[]]);return b};this.getDOEMenu=function(){var d=[];var c=this.initialGraphType.match(/Scatter/)?this.getKeys(this.dataStndBy.z):this.getKeys(this.dataStndBy.x);var a=this.getObjectArray(this.includeDOE);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","modifyDOE",[c[b]]])}return d};this.getCorrelationCatMenu=function(f,d){var b=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.isNumeric(this.data[f][e[a]])){b.push([e[a],"radioOff","correlateData",[d,e[a]]])}}return b};this.getCorrelationMenu=function(){var c=[];var b=[];var a=false;if(this.data.y.vars.length>=3){c.push(["Samples","samples","correlateData"])}if(this.data.y.smps.length>=3&&this.data.x&&this.isNumericFactor("s")){c.push(["Sample Annotation","samples",a,a,a,"getCorrelationCatMenu",["x",true]])}if(this.data.y.smps.length>=3){c.push(["Variables","variables","correlateData",[true]])}if(this.data.y.vars.length>=3&&this.data.z&&this.isNumericFactor("v")){c.push(["Variable Annotation","variables",a,a,a,"getCorrelationCatMenu",["z",a]])}return c};this.getMagnificationMenu=function(){var a=[];for(var b=1;b<=10;b++){a.push([(96*b)+" DPI",this.printMagnification==b?"radioOn":"radioOff","changeAttributeNoDraw",["printMagnification",b]])}return a};this.getParametersMenu=function(){var a=[];a.push(["Load Parameters","loadFile",true,[]]);a.push(["Save as JSON","json2","save",[false,"cX-"+this.target+"-param",true]]);return a};this.getReproducibleResearchMenu=function(){var a=[];var b=false;a.push(["Reproducible Research code","RRBW","clickRepResearch",[]]);a.push(["Show JSON code","json","clickShowCode",[]]);a.push(["Show R code","Rcode","clickShowRCode",[]]);a.push(["Show Meta data","codeParams","clickShowMetaCode",[]]);if(!this.motionBy){a.push(["Reproduce","redo","reproduce",[b],CanvasXpress.system.control+" + "+CanvasXpress.system.alt+" + R"]);a.push(["Replay","videoCamera","reproduce",[b,true],CanvasXpress.system.shift+" + "+CanvasXpress.system.control+" + "+CanvasXpress.system.alt+" + R"]);a.push(["Print Sequence","videoFilm","reproduce",[b,b,true],CanvasXpress.system.shift+" + "+CanvasXpress.system.control+" + "+CanvasXpress.system.alt+" + S"])}a.push(["-"]);return a};this.getFileMenu=function(){var a=[];var b=false;a.push(["Save as PNG","camera","print",[],CanvasXpress.system.control+" + P"]);if(!this.graphType.match(/Venn|TagCloud|Map/)){a.push(["Save as SVG","svg","saveSVG",[]])}a.push(["Save as JSON","json2","save",[]]);if(this.editable){a.push(["Edit in JS Fiddle","jsfiddle","editJSFiddle",[]])}a.push(["Print Magnification","zoomIn",b,b,b,"getMagnificationMenu",[]]);a.push(["-"]);a.push(["Reproducible Research","RRColor",b,b,b,"getReproducibleResearchMenu",[]]);if(this.remoteService&&this.remoteServiceType=="webService"){a.push(["Save customizations to server","disckette","saveRemote",["afterRender"]]);a.push(["Clear parameters from server","discketteCrossed","clearRemote",[]])}a.push(["-"]);a.push(["Load","loadFile",true,[]]);if(this.Rdatasets){a.push(["R Datasets","RBW",b,b,b,"getRdatasetsMenu",[]])}a.push(["-"]);a.push(["Parameters","cog",b,b,b,"getParametersMenu",[]]);a.push(["-"]);a.push(["Reset","refresh","masterReset",[],"ESC"]);return a};this.getExploreMenu=function(){var a=this.getObjectArray(CanvasXpress.graphTypes.OneDGraphs);var b=[];if(!this.disableDataFilters){b.push(["Filters","funnel","clickDataFilters",[]])}if(!this.disableDataTable){b.push(["Table","table","clickDataTable",[]])}if(!this.disableDataExplorer){b.push(["Configure","tools","clickDataExplorer",[]])}if(!this.isCorrelate&&!this.isDOE){b.push(["-"]);if(a[this.graphType]&&!this.is3DPlot){if(this.data.x){b.push(["Explore Meta-Data","doe","createDOE"])}}else{if(this.graphType=="Scatter2D"&&!this.isHistogram){if(this.data.z&&!this.scatterPlotMatrix){b.push(["Explore Meta-Data","doe","createDOE"])}}}}if(!this.disableConfigurator){b.push(["-"]);b.push(["Search Parameters","magnifier","addConfiguratorCloseMenus"])}return b};this.getConfigurationMenu=function(){var g=this.decorations;var e=false;var b={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Gantt:true,Heatmap:true,Treemap:true,TagCloud:true,ParallelCoordinates:true,Sankey:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true};var a=[];if(this.isMap||this.graphType=="Tree"){a.push(["Citation","citation1D",e,e,e,"getGraphPartMenu",["citation"]]);a.push(["Legend","legend",e,e,e,"getLegendMenu",[]]);a.push(["Title / Subtitle",this.graphType=="Heatmap"?"titleSubtitleH":"titleSubtitle",e,e,e,"getTitleSubtitleMenu",[]])}else{if(b[this.graphType]&&!this.is3DPlot){if(this.graphType!="Heatmap"){a.push(["Axes","axes1DProperties",e,e,e,"getAxesMenu",[]]);a.push(["Axes Titles","axes1DTitle",e,e,e,"getAxesTitleMenu",[]])}a.push(["Citation",this.graphType=="Heatmap"?"citationHeatmap":"citation1D",e,e,e,"getGraphPartMenu",["citation"]]);a.push(["General",this.graphType=="Heatmap"?"generalHeatmap":"general1D",e,e,e,"getGeneralMenu",[]]);a.push(["Grid","grid1D",e,e,e,"getPlotAreaGridMenu",["x"]]);if(this.graphType!="Heatmap"){if(this.graphType.match(/Dot/)){a.push(["Dotplot","dotPlot",e,e,e,"getDataPointsMenu",[]])}else{if(this.graphType=="Boxplot"){a.push(["Boxplot","boxPlot",e,e,e,"getBoxplotMenu",[]])}}a.push(["Plot Area","plot1D",e,e,e,"getPlotAreaOneMenu",[]]);if(g){a.push(["Decorations",g.marker?"decorationsMarker2D":"decorationsLine1D",e,e,e,"getDecorationsMenu",[]])}a.push(["Legend","legend1D",e,e,e,"getLegendMenu",[]]);if(this.data.x){a.push(["Overlays","overlays1D",e,e,e,"getOverlaysMenu",[]])}}if(this.graphType=="Heatmap"){a.push(["Indicator","indicator",e,e,e,"getIndicatorMenu",[]]);a.push(["Heatmap","heatmapGraph",e,e,e,"getHeatmapMenu",[]]);if(this.data.x||this.data.z){a.push(["Overlays","overlaysHeatmapSamples",e,e,e,"getOverlaysMenu",[]])}}a.push(["Sample Labels",this.graphType=="Heatmap"?"sampleLabelsHeatmap":"sampleLabels1D",e,e,e,"getSmpLabelMenu",[]]);a.push(["Samples Title",this.graphType=="Heatmap"?"sampleTitleHeatmap":"sampleTitle1D",e,e,e,"getGraphPartMenu",["smpTitle",true]]);if(this.graphType=="Heatmap"){a.push(["Variable Labels","variableLabelsHeatmap",e,e,e,"getVarLabelMenu",[]]);a.push(["Variables Title","variableTitleHeatmap",e,e,e,"getGraphPartMenu",["varTitle",true]])}a.push(["Title / Subtitle",this.graphType=="Heatmap"?"mainHeatmapTitleSubtitle":"main1DTitleSubtitle",e,e,e,"getTitleSubtitleMenu",[]])}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["Axes","axes3DProperties",e,e,e,"getAxesMenu",[]]);a.push(["Axes Titles","axes3DTitle",e,e,e,"getAxesTitleMenu",[]]);a.push(["Citation","citationScatter",e,e,e,"getGraphPartMenu",["citation"]]);a.push(["General","general3D",e,e,e,"getGeneralMenu",[]])}else{a.push(["Axes","axes2DProperties",e,e,e,"getAxesMenu",[]]);a.push(["Axes Titles","axes2DTitle",e,e,e,"getAxesTitleMenu",[]]);a.push(["Citation","citationScatter",e,e,e,"getGraphPartMenu",["citation"]]);a.push(["General","general2D",e,e,e,"getGeneralMenu",[]])}a.push(["Grid","gridScatter",e,e,e,"getPlotAreaScatterGridMenu",[]]);a.push(["Plot Area","plotScatter",e,e,e,"getPlotAreaScatterMenu",[]]);if(g){var c=g.nlfit?"nonlinearFit":g.line?"decorationsLine2D2":g.lines?"decorationsLine2D":g.reg?"correlation":g.nor?"fit3":g.area?"fit2":g.qq?"qq":g.cdf?"cumulativeDistribution":g.kaplanMeier?"kaplanMeyer":g.marker?"decorationsMarker2D":e;a.push(["Decorations",c,e,e,e,"getDecorationsMenu",[]])}a.push(["Legend","legendScatter",e,e,e,"getLegendMenu",[]]);a.push(["Title / Subtitle","mainScatterTitleSubtitle",e,e,e,"getTitleSubtitleMenu",[]]);if(this.isSelectDataPoints){a.push(["Show hidden data points","eye","showHideSelectedDataPoint",[e,45],"Ctrl + Insert"]);a.push(["Hide data points","eyeCrossed","showHideSelectedDataPoint",[e,46],"Ctrl + Delete"])}}}}return a};this.getAlignNetworkMenu=function(){var b=[];var a=false;b.push(["Top","alignTop","alignDistributeSelectedNodes",[a,84]]);b.push(["Right","alignRight","alignDistributeSelectedNodes",[a,82]]);b.push(["Bottom","alignBottom","alignDistributeSelectedNodes",[a,66]]);b.push(["Left","alignLeft","alignDistributeSelectedNodes",[a,76]]);return b};this.getDistributeNetworkMenu=function(){var b=[];var a=false;b.push(["Vertically","distributeVertical","alignDistributeSelectedNodes",[a,86]]);b.push(["Horozontally","distributeHorizontal","alignDistributeSelectedNodes",[a,72]]);return b};this.getRotateNetworkMenu=function(){var a=[];a.push(["Clockwise","rotateClockwise","arrowMove",[34]]);a.push(["Clockwise - Animate","rotateClockwise2","arrowMove",[39,true]]);a.push(["Anticlockwise","rotateAnticlockwise","arrowMove",[33]]);a.push(["Anticlockwise - Animate","rotateAnticlockwise2","arrowMove",[37,true]]);return a};this.getOrderNetworkMenu=function(){var a=[];a.push(["Send to back","moveBack","orderNodes",["sendNodeToBack"]]);a.push(["Send backward","moveBackwards","orderNodes",["sendNodeBackward"]]);a.push(["Bring to front","moveFront","orderNodes",["bringNodeToFront"]]);a.push(["Bring forward","moveForwards","orderNodes",["bringNodeForward"]]);return a};this.getNetworkDecorationsPositionMenu=function(){var a=[];a.push(["Center","center","changeAttribute",["decorationsPosition","center"]]);a.push(["Top","top","changeAttribute",["decorationsPosition","top"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]]);a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Left","left","changeAttribute",["decorationsPosition","left"]]);return a};this.getNetworkDecorationAttributesMenu=function(){var d=[];var c=[];var a=this.sortObject(this.meta.data.nodes);var f={x:true,y:true,z:true,width:true,height:true,community:true,decorationsXi:true,decorationsYi:true};for(var e=0;e<a.length;e++){if(this.meta.data.nodes[a[e]].type=="Numeric"&&!f[a[e]]){c.push(a[e])}}var b={};for(var e=0;e<this.decorations.length;e++){b[this.decorations[e]]=true}for(var e=0;e<c.length;e++){d.push([c[e],b[c[e]]?"checked":"unchecked","modifyNetworkDecorations",[c[e]]])}return d};this.getNetworkDecorationsTypeMenu=function(){var a=[];a.push(["Bar","barGraph","changeAttribute",["decorationsType","bar"]]);a.push(["Heatmap","heatmapGraph","changeAttribute",["decorationsType","heatmap"]]);a.push(["Pie Chart","pieChart","changeAttribute",["decorationsType","pie"]]);a.push(["Stacked","stackedGraph","changeAttribute",["decorationsType","stacked"]]);return a};this.getNetworkDecorationsMenu=function(){var b=[];var a=false;b.push(["Attributes","Au",a,a,a,"getNetworkDecorationAttributesMenu",[]]);b.push(["Height","heightness",a,a,a,"changeTextColorAttributeMenu",["-text-","decorationsHeight"]]);b.push(["Width","thickness",a,a,a,"changeTextColorAttributeMenu",["-text-","decorationsWidth"]]);b.push(["Position","toLocation3",a,a,a,"getNetworkDecorationsPositionMenu",[]]);b.push(["Type","graphType",a,a,a,"getNetworkDecorationsTypeMenu",[]]);b.push([this.showDecorations?"Hide Decorations":"Show Decorations",this.showDecorations?"eyeClosed":"eye2","toggleAttribute",["showDecorations"]]);return b};this.getNetworkNodeEdgeAttributesMenu=function(){var a=[];var b=false;a.push(["Nodes","nodes",b,b,b,"getNetworkNodeAttributesMenu",[]]);a.push(["Edges","edges",b,b,b,"getNetworkEdgeAttributesMenu",[]]);return a};this.getNetworkNodeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.nodes);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkNodeAttributesMenu=function(){var a=[];var b=false;a.push(["Color By","colors",b,b,b,"getNetworkNodeAttributesPropertyMenu",["colorNodeBy"]]);a.push(["Shape By","shapes",b,b,b,"getNetworkNodeAttributesPropertyMenu",["shapeNodeBy"]]);a.push(["Size By","sizes",b,b,b,"getNetworkNodeAttributesPropertyMenu",["sizeNodeBy"]]);a.push(["Pattern By","patterns",b,b,b,"getNetworkNodeAttributesPropertyMenu",["patternNodeBy"]]);return a};this.getNetworkEdgeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.edges);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkEdgeAttributesMenu=function(){var a=[];var b=false;a.push(["Color By","colors",b,b,b,"getNetworkEdgeAttributesPropertyMenu",["colorEdgeBy"]]);a.push(["Size By","thickness2",b,b,b,"getNetworkEdgeAttributesPropertyMenu",["sizeEdgeBy"]]);return a};this.setMenu=function(){var a=this.getObjectArray(CanvasXpress.graphTypes.OneDGraphs);var c=this.decorations;var b=false;this.menu=[];if(this.graphType!="Network"){this.menu.push(["File","folder",b,b,b,"getFileMenu",[]]);this.menu.push(["-"]);if(this.graphType!="Map"){this.menu.push(["Explore","magnifier",b,b,b,"getExploreMenu",[]]);this.menu.push(["-"])}}if(this.graphType=="Network"){if(this.isSelectNodes){this.menu.push(["Align","alignBottom",b,b,b,"getAlignNetworkMenu",[]]);this.menu.push(["Distribute","distributeVertical",b,b,b,"getDistributeNetworkMenu",[]]);this.menu.push(["Order","order",b,b,b,"getOrderNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Show conections","network","showHideSelectedDataPoint",[b,36],"Ctrl + Home"]);this.menu.push(["-"]);this.menu.push(["Hide nodes","eyeCrossed","showHideSelectedDataPoint",[b,46],"Ctrl + Delete"]);this.menu.push(["-"]);this.menu.push(["Layout Selected Nodes","refresh","recalculateLayoutSelectedNodes"])}else{this.menu.push(["File","folder",b,b,b,"getFileMenu",[]]);this.menu.push(["-"]);this.menu.push(["Explore","magnifier",b,b,b,"getExploreMenu",[]]);this.menu.push(["-"]);this.menu.push(["Legend","legend",b,b,b,"getLegendMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data Point Properties","colorShapeSize",b,b,b,"getNetworkNodeEdgeAttributesMenu",[]]);this.menu.push(["-"]);this.menu.push(["Decorations","tools",b,b,b,"getNetworkDecorationsMenu",[]]);this.menu.push(["Color","colors",b,b,b,"getColorsMenu",[]]);this.menu.push(["-"]);this.menu.push([this.showNetworkCommunities?"Hide Communities":"Show Communities",this.showNetworkCommunities?"eyeClosed":"eye2","toggleAttribute",["showNetworkCommunities"]]);if(this.showNetworkCommunities&&!this.colorNodeBy){this.menu.push(["Coordinate Convex Hull Color","colorsBW","toggleAttribute",["coordinateNetworkConvexHullCommunityColor"]])}if(!this.isNetworkMetricsDone){this.menu.push(["-"]);this.menu.push(["Calculate Network metrics","nodes","calculateNetworkMetrics",[true]])}this.menu.push(["-"]);if(this.isHiddenNodes){this.menu.push(["Show hidden nodes","eye2","hideUnhideNodes",[],"Ctrl + Insert"]);this.menu.push(["-"])}this.menu.push(["Rotate","rotateAnticlockwise",b,b,b,"getRotateNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Undo","undo","undo",[],"Ctrl + z"]);this.menu.push(["Redo","redo","redo",[],"Ctrl + y"]);this.menu.push(["-"]);this.menu.push(["Redraw","refresh","recalculateLayout"])}}if(this.graphType=="Map"){this.menu.push(["Customize","cog",b,b,b,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.z){this.menu.push(["Color By","colors",b,b,b,"getDataPointAttributesPropertyMenu",["colorBy"]])}}else{if(this.graphType=="Tree"){this.menu.push(["Customize","cog",b,b,b,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.x){this.menu.push(["Data Point Properties","colorShapeSize",b,b,b,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}this.menu.push(["Layout","cluster",b,b,b,"getDendrogramsMenu",[]])}else{if(this.graphType=="Circular"){this.menu.push(["Cluster","cluster",b,b,b,"getDendrogramsMenu",[]]);this.menu.push(["-"])}}}if(this.isDOE){this.menu.push(["Modify Meta-Data Plots","doe",b,b,b,"getDOEMenu",[]]);this.menu.push(["Remove Meta-Data Plots","doeCrossed","removeDOE"]);this.menu.push(["-"])}else{if(a[this.graphType]&&!this.is3DPlot){this.menu.push(["Customize","cog",b,b,b,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",b,b,b,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.graphType=="ParallelCoordinates"||this.graphType=="Line"){this.menu.push(["Data Point Properties","colorShapeSize",b,b,b,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}if((this.data.x||this.data.z)&&this.isRawData){if(this.data.x){this.menu.push(["Group Samples","group",b,b,b,"getGroupSamplesMenu",[]])}if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",b,b,b,"getSegregationMenu",[]])}this.menu.push(["-"])}if(!this.layoutValid&&this.isRawData){this.menu.push(["Cluster","cluster",b,b,b,"getDendrogramsMenu",[]]);this.menu.push(["-"]);if(this.isHistogram){this.menu.push(["Histogram","histogram",b,b,b,"getHistogramMenu",[]])}else{if(!this.isCorrelate&&!this.isHistogram){this.menu.push(["Correlate","correlation",b,b,b,"getCorrelationMenu",[]]);this.menu.push(["Histogram","histogram","createHistogram"])}}}}else{if(this.graphType=="Circular"){this.menu.push(["Data","data",b,b,b,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.data.z){if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",b,b,b,"getSegregationMenu",[]])}this.menu.push(["-"])}}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){this.menu.push(["Customize","cog",b,b,b,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",b,b,b,"getDataMenu",[]]);this.menu.push(["-"]);if(this.graphType=="Scatter2D"){if(this.isHistogram){this.menu.push(["Histogram","histogram",b,b,b,"getHistogramMenu",[]])}else{if(this.isCorrelate){this.menu.push(["Remove Correlation","correlationCrossed","removeCorrelation"])}else{if(this.isQQ){this.menu.push(["Remove QQ plot","qqCrossed","removeQQPlot"])}else{if(this.isCDF){this.menu.push(["Remove CDF plot","cumulativeDistributionCrossed","removeCDFPlot"])}else{if(c&&c.reg){this.menu.push(["Remove Correlation","correlationCrossed","removeCorrelation"])}else{this.menu.push(["Loess","nonLinearFit",b,b,b,"getLoessMenu",[]]);this.menu.push(["Correlate","correlation","correlateData"]);this.menu.push(["Kaplan Meier","kaplanMeyer",b,b,b,"getKaplanMeierMenu",[]]);this.menu.push(["QQ Plot","qq","addQQPlot"]);this.menu.push(["CDF Plot","cumulativeDistribution","addCDFPlot"])}if(!this.scatterPlotMatrix&&!c){this.menu.push(["Create Histogram","histogram","createHistogram"])}}}}}}else{if(this.graphType=="Scatter3D"){this.menu.push(["Loess","nonLinearFit",b,b,b,"getLoessMenu",[]])}}if(this.data.z){this.menu.push(["Data Point Properties","colorShapeSize",b,b,b,"getDataPointAttributesMenu",[]])}if(this.isQQ||this.isCDF||this.data.z&&!this.scatterPlotMatrix&&this.graphType!="Scatter3D"){this.menu.push(["-"]);this.menu.push(["Segregate Data","segregate",b,b,b,"getSegregationMenu",[]])}}}}}return this.menu};this.resetMenus=function(){this.removeMenus()};this.initializeMenus=function(){if(this.showPrimaryMenus){var a=this.setMenu();for(var c=0;c<a.length;c++){var e=a[c];var d=c==0?{marginLeft:"13px"}:false;if(e[5]){this.addImageToToolbar(e[1],e[0],e[5],e[6],false,true,false,d)}}var b=this.$(this.target+"-cX-Toolbar-Custom");if(b){if(b.clientWidth>(this.width*0.8)){this.removeAllImagesFromToolbar()}}}};this.setFunctionNames("initMenus");this.initializeMenus()};CanvasXpress.prototype.initLinks=function(){this.addLinkDiv=function(){if(this.$(this.target+"-cX-Link")){this.resetLinkDiv();return}var b=this.$cX("div",{id:this.target+"-cX-Link",className:"CanvasXpressLink"},{zIndex:10002,display:"none"});var a=this.$cX("ul",{id:this.target+"-cX-Link-Content",className:"CanvasXpressList"});var c=this.$("north-wrapper-"+this.target);if(c){b.appendChild(a);c.appendChild(b)}};this.showLinkDiv=function(J,b,D){var K=this.$(this.target+"-cX-Link-Content");var k=this.$("west-container-"+this.target);var M=false;if(K){this.resetLinkDiv();var L=this.adjustedCoordinates(J);if(L){var h=L.x+k.offsetWidth;var f=L.y;for(var H=0;H<b.length;H++){var o=b[H].url;var C=b[H].name;var r=b[H].title;var E=b[H].icon;var v=b[H].source;var B=b[H].params;if(o){M=true}else{if(v&&this.data.links&&this.data.links[v]){o=this.data.links[v].url;M=true;if(B){for(var G in B){o=o.replace("$"+G+"$",B[G])}}}}var F=this.$cX("li",{className:"CanvasXpressListItem"});var c=r?r:this.data.links&&v&&this.data.links[v]&&this.data.links[v].title?this.data.links[v].title:"";var N=this.$cX("a",{className:"CanvasXpressListItemA",href:o,alt:c,title:c,target:"_blank"});var I=this.$cX("img",{className:"CanvasXpressListIcon",src:E?E:this.data.links&&v&&this.data.links[v]&&this.data.links[v].icon?this.data.links[v].icon:CanvasXpress.images.canvasXpress});var A=this.$cX("span",{className:"CanvasXpressListItemText",innerHTML:C?C:this.data.links&&v&&this.data.links[v]&&this.data.links[v].name?this.data.links[v].name:H});N.appendChild(I);N.appendChild(A);F.appendChild(N);this.addRemoveLinkListeners("addEvtListener",F);K.appendChild(F)}K.parentNode.style.left=h+"px";K.parentNode.style.top=f+"px";K.parentNode.style.display=M?"block":"none"}}};this.addRemoveLinkListeners=function(b,a){if(a){this.addRemoveEvtListener(b,a,"click",this.clickLink,false);this.addRemoveEvtListener(b,a,"mouseover",this.mouseoverLink,false);this.addRemoveEvtListener(b,a,"mouseout",this.mouseoutLink,false)}};this.clickLink=function(a){return function(b){a.resetLinkDiv();return false}}(this);this.mouseoverLink=function(a){return function(c){var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItemActive";b[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutLink=function(a){return function(c){var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItem";b[1].className="CanvasXpressListItemA"}return false}}(this);this.resetLinkDiv=function(){var a=this.$(this.target+"-cX-Link-Content");if(a&&a.childNodes){while(a.childNodes.length>0){this.addRemoveLinkListeners("removeEvtListener",a.childNodes[0]);a.removeChild(a.childNodes[0])}a.parentNode.style.display="none"}};this.resetLinks=function(){this.resetLinkDiv()};this.initializeLinks=function(){if(!this.disableEvents){this.addLinkDiv()}};this.setFunctionNames("initLinks");this.initializeLinks()};CanvasXpress.prototype.initTooltip=function(){this.addTooltipDiv=function(w,v,u,b,f){this.resetInfoSpan();var g=0;var k=this.target+"-cX-TooltipDiv"+g;var A=this.$(this.target+"-cX-Info");if(A&&A.style.display!="none"){v=parseInt(A.style.left);u=parseInt(A.style.top)}var l=this.$(k);while(l){g++;k=this.target+"-cX-TooltipDiv"+g;l=this.$(k)}var p=this.$cX("div",{id:k,className:"CanvasXpressTooltip draggable"},{left:v+"px",top:u+"px"});var r=this.$cX("img",{id:k+"Close",className:"CanvasXpressTooltip",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var h=this.$cX("img",{id:k+"Marker",className:"CanvasXpressTooltip",src:CanvasXpress.images.pencil,obj:f,alt:"Add Marker",title:"Add Marker"});if(!b){b={}}b.clear="both";var a=1;if(b.hasOwnProperty("opacity")){a=b.opacity;delete (b.opacity)}p.style.opacity=a;var z=this.$cX("div",{id:k+"HTML",innerHTML:w||""},b);p.appendChild(r);if(f){p.appendChild(h)}p.appendChild(z);var j=this.$("center-wrapper-"+this.target);j.appendChild(p);return p};this.addMousePositionDiv=function(){var e=this.$(this.target+"-cX-MousePosition");if(e){return}e=this.$cX("div",{id:this.target+"-cX-MousePosition",className:"CanvasXpressMousePosition"},{left:"0px",top:"0px",display:"none"});var b=this.$cX("img",{className:"CanvasXpressMousePosition",src:CanvasXpress.images.add});var c=this.$cX("span",{id:this.target+"-cX-MousePositionCoordinates",className:"CanvasXpressMousePosition",innerHTML:"0, 0"});e.appendChild(b);e.appendChild(c);var a=this.$("center-wrapper-"+this.target);a.appendChild(e)};this.addRemoveTooltipDivsListeners=function(a,b){this.addRemoveEvtListener(a,b,"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,b,"touchstart",this.registerMousemove,false);this.addRemoveEvtListener(a,b.childNodes[0],"click",this.closeTooltipDiv,false);if(b.childNodes[1]&&b.childNodes[0].tagName.toUpperCase()=="IMG"){this.addRemoveEvtListener(a,b.childNodes[1],"click",this.addMarkerTooltipDiv,false)}};this.closeTooltipDiv=function(a){return function(f,h,c){var b=f?(f.target||f.srcElement):false;var g=b?b.parentNode:h?a.$(h):false;if(g){a.addRemoveTooltipDivsListeners("removeEvtListener",g);a.transitionMagic(g,c||"holeOut",function(){g.parentNode.removeChild(g)})}return false}}(this);this.addMarkerTooltipDiv=function(a){return function(c){var b=c.target||c.srcElement;if(b){var g=b.parentNode;var f=b.obj;if(f){a.addMarkerConfigurator(c,f)}}return false}}(this);this.showTooltipDiv=function(g,k,c,b,j,i,f,a){var h;if(j&&i){h=this.addTooltipDiv(k,j,i,b,f);this.addRemoveTooltipDivsListeners("addEvtListener",h)}else{var m=this.$(this.target+"-cX-Info");var l=c?this.regularCoordinates(g,c):this.adjustedCoordinates(g,m);if(l){j=l.x;i=g?l.y:l.y+25;h=this.addTooltipDiv(k,j,i,b,f);this.addRemoveTooltipDivsListeners("addEvtListener",h)}}this.transitionMagic(h,a||"spaceInUp");return h};this.resetTooltipDivs=function(){var c=0;var a=this.target+"-cX-TooltipDiv"+c;var b=this.$(a);while(b){this.addRemoveTooltipDivsListeners("removeEvtListener",b);b.parentNode.removeChild(b);c++;a=this.target+"-cX-TooltipDiv"+c;b=this.$(a)}};this.addInfoSpan=function(){if(this.$(this.target+"-cX-Info")){this.resetInfoSpan();return}var d=this.$("center-wrapper-"+this.target);var b=this.$cX("span",{id:this.target+"-cX-Info",className:"CanvasXpressTooltip"},{display:"none"});var a=this.$cX("div",{id:this.target+"-cX-Info-Left",className:"CanvasXpressTooltipArrowLeft"},{display:"none"});d.appendChild(b);d.appendChild(a)};this.resetInfoSpan=function(g,c){var b=this.$(this.target+"-cX-Info");var d=this.$(this.target+"-cX-Info-Left");if(b&&!this.noInfoSpanReset){var a=new Date().getTime()-this.infoStartTime;if(a>this.infoTimeIn||c){b.style.left="0px";b.style.top="0px";b.style.display="none";d.style.display="none";b.innerHTML=""}}};this.flashESCKey=function(a,b){return this.flashInfoSpan(a||this.width/2,b||this.height/2,"Press 'ESC' key to reset plot",2000)};this.flashInfoSpan=function(l,k,o,d,a){var g=this;if(d){this.noInfoSpanReset=true}var q=new Date().getTime()-this.infoStartTime;var r=this.$(this.target+"-cX-Info");var j=this.$(this.target);var b=j.getClientRects();if(r){r.innerHTML=o;r.style.display="block";var n=parseInt(r.clientWidth);var f=parseInt(r.clientHeight);r.style.left=(l||0)+"px";r.style.top=(k||0)+"px";if(a){for(var e in a){r.style[e]=a[e]}}if(d){this.noInfoSpanReset=true;var m=function(){this.update=function(){var c=new Date().getTime();if(c-g.infoStartTime>d){g.noInfoSpanReset=false;g.resetInfoSpan();clearInterval(h)}};var h=g.setInterval(this.update,d)};m.call()}}};this.showMousePosition=function(g,j){if(j){}else{if(g){j=this.adjustedCoordinates(g)}else{return}}var b=new Date().getTime()-this.infoStartTime;var a=j.x+", "+j.y;var h=this.$(this.target+"-cX-MousePosition");var f=this.$(this.target+"-cX-MousePositionCoordinates");if(h&&f){h.style.left=j.x+"px";h.style.top=j.y+"px";h.style.display="block";f.innerHTML=a;this.mousePositioning=true}};this.resetMousePosition=function(){var b=this.$(this.target+"-cX-MousePosition");var a=this.$(this.target+"-cX-MousePositionCoordinates");if(b&&a){b.style.left="0px";b.style.top="0px";b.style.display="none";a.innerHTML="0, 0";this.mousePositioning=false}};this.showInfoSpan=function(q,l,p,a){if((this.draggingOn||this.remoteUpdating||this.noInfoSpanReset||(this.lassoPoints&&this.lassoPoints.length))&&!a){return}var k=new Date().getTime()-this.infoStartTime;var m=this.$(this.target+"-cX-Info");var n=this.$(this.target+"-cX-Info-Left");var b=window;var v=window.document;if(m&&l&&l!=""&&k>this.infoTimeIn){var u=p?this.regularCoordinates(q,p):this.adjustedCoordinates(q,m);if(u){var i=u.x;var g=q?u.y:u.y+25;if(CanvasXpress.system.isIE){i+=v.body.scrollLeft;g+=v.body.scrollTop}var d;var c;if(q&&q.type=="touchmove"){d=25;c=40}else{d=10;c=20}if(!isNaN(l)){l=l.toString()}if(l.match(/\w/)){m.innerHTML=l;m.style.left=(i+d)+"px";m.style.top=(g-c)+"px";m.style.display="inline";var o=(m.clientHeight/2)+1.5;n.style.left=(i+d+2.5)+"px";n.style.top=(g+o-c)+"px";if(this.isMap){m.style.zIndex=10000}var j=parseInt(m.clientWidth);var o=parseInt(m.clientHeight);if(j<b.innerWidth&&j>(b.innerWidth+b.pageXOffset)-i&&(j+c)<(i-b.pageXOffset)){m.style.left=(i-(j+c))+"px";m.style.left=(i-(parseInt(m.clientWidth)+c))+"px"}if(o<b.innerHeight&&o>(b.innerHeight+b.pageYOffset)-g&&(o-(d*1.5))<(g-b.pageYOffset)){m.style.top=(g-(o-(d*1.5)))+"px";m.style.top=(g-(parseInt(m.clientHeight)-(d*1.5)))+"px"}this.infoStartTime=new Date().getTime();var f=this;var r=function(){this.update=function(){var h=new Date().getTime();if(h-f.infoStartTime>f.infoTimeOut){f.resetInfoSpan();clearInterval(e)}};var e=f.setInterval(this.update,100)};r.call()}}}};this.addMarkerConfigurator=function(Q,H){var y=this.$("center-wrapper-"+this.target);if(y){var F=this.target+"-cX-Marker";if(this.$(F)){this.closeMarkerConfigurator(false,this.$(F))}var O=Q.target||Q.srcElement;var D=O.parentNode;var R=this.adjustedCoordinates(Q);var z=H.y?H.y.vars:H.w.vars;var C=H.y?H.y.smps:H.w.smps;var k=this.graphType.match(/Treemap|Stacked/)?true:false;var I={};var E=false;var A={id:this.newId(this.target+"-marker-"),vi:this.getVariableIndices(z),si:this.getSampleIndices(C,k),variable:z,sample:C,update:false};var L=false;var G=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var N=0;N<G.length;N++){I[G[N]]=""}I.align="center";I.baseline="middle";I.type="line";if(this.decorations&&this.decorations.marker){for(var N=0;N<this.decorations.marker.length;N++){var J=this.decorations.marker[N];if(this.isSameObject(J.variable,z)&&this.isSameObject(J.sample,C)){for(var M=0;M<G.length;M++){I[G[M]]=J[G[M]]}L=true;A.update=true}}}var B=this.$cX("div",{id:F,className:"CanvasXpressMarker draggable",par:D.id,obj:A},{left:R.x+"px",top:(R.y-this.height)+"px",display:"block",position:"relative"});var c=this.$cX("img",{id:F+"ConfiguratorMarkerClose",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var f=this.$cX("div",{id:F+"Container",className:"CanvasXpressDataTableContainer"},{left:"12px"});var d=this.$cX("table",{id:F+"MarkerTable",className:"CanvasXpressDataTable"});var a=this.$cX("tbody");for(var N=0;N<G.length;N++){var b=this.$cX("tr");var q=this.$cX("th",{className:"CanvasXpressTableCellHead"},{height:G[N]=="text"?"64px":"18px",width:"80px",backgroundRepeat:"repeat"});var l=this.$cX("div",{className:"CanvasXpressTableCell",innerHTML:this.capitalize(G[N])},{height:G[N]=="text"?"64px":"18px",width:"80px"});var u=this.$cX("td",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px",border:"1px solid #ccc"});var t=this.$cX("div",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px"});var h;if(G[N]=="text"){h=this.$cX("textarea",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",name:G[N],value:I[G[N]],rows:3},{width:"100%",border:"none"})}else{if(G[N]=="color"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"color",name:G[N],value:I[G[N]]?this.validateColor(I[G[N]],null,true):""},{width:"100%",border:"none"})}else{if(G[N]=="type"){h=this.$cX("select",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",size:1},{width:"100%",border:"none",backgroundColor:"white"});var x=this.$cX("option",{text:"line",value:"line"});try{h.add(x,null)}catch(P){h.add(x)}var g=this.$cX("option",{text:"annotation",value:"annotation"});try{h.add(g,null)}catch(P){h.add(g)}if(I[G[N]]&&I[G[N]]!="line"){h.options[1].selected=true;E=true}}else{if(G[N]=="x"||G[N]=="y"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]?this.sprintf("%.2f",Number(I[G[N]])):0,min:0,max:1,step:0.01},{width:"100%",border:"none"});if(E){h.disabled=true}}else{if(G[N].match(/fontSize/)){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]||12},{width:"100%",border:"none"})}else{h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"text",name:G[N],value:I[G[N]]||""},{width:"100%",border:"none"})}}}}}var r=this.$cX("input",{id:F+"ConfiguratorMarkerRemove",value:"Remove",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"12px",width:"125px",height:"24px"});var K=this.$cX("input",{id:F+"ConfiguratorMarkerAdd",value:L?"Update":"Add",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"24px",width:"125px",height:"24px"});t.appendChild(h);u.appendChild(t);q.appendChild(l);b.appendChild(q);b.appendChild(u);a.appendChild(b)}d.appendChild(a);f.appendChild(d);B.appendChild(c);B.appendChild(f);B.appendChild(r);B.appendChild(K);y.appendChild(B);this.addRemoveMarkerConfiguratorListeners("addEvtListener")}};this.addRemoveMarkerConfiguratorListeners=function(e){var b=this.$(this.target+"-cX-Marker");var h=this.$(this.target+"-cX-MarkerConfiguratorMarkerClose");var g=this.$(this.target+"-cX-MarkerConfiguratorMarkerRemove");var d=this.$(this.target+"-cX-MarkerConfiguratorMarkerAdd");var f=this.$(this.target+"-cX-MarkerConfiguratorMarker-type");if(b&&h&&g&&d&&f){this[e](b,"mousedown",this.registerMousemove,false);this[e](h,"click",this.closeMarkerConfigurator,false);this[e](g,"click",this.removeMarker,false);this[e](d,"click",this.addMarker,false);this[e](f,"change",this.changeTypeMarker,false)}};this.closeMarkerConfigurator=function(a){return function(f,b){var c=f?(f.target||f.srcElement):false;var d=c?a.$(c.parentNode.par):b?a.$(b.par):false;if(d){a.addRemoveTooltipDivsListeners("removeEvtListener",d);d.parentNode.removeChild(d)}if(!b){b=c.parentNode}a.addRemoveMarkerConfiguratorListeners("removeEvtListener",b);b.parentNode.removeChild(b);return false}}(this);this.removeMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj,true);a.closeMarkerConfigurator(c);return false}}(this);this.addMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj);a.closeMarkerConfigurator(c);return false}}(this);this.changeTypeMarker=function(a){return function(d){var c=d.target||d.srcElement;var f=this.value;var b=c.parentNode.parentNode.parentNode.nextElementSibling;var g=b.nextElementSibling;b.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;g.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;return false}}(this);this.modifyMarker=function(e,a){var d=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var b=0;b<d.length;b++){var c=this.$(this.target+"-cX-MarkerConfiguratorMarker-"+d[b]);if(c){e[d[b]]=c.value}}this.updateMarker(e,a)};this.updateMarker=function(e,b){this.functionCaller="updateMarker";if(this.isTransition()){return}if(b){if(e.update){var d=[];for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){continue}d.push(a)}this.decorations.marker=d}else{return false}}else{if(e.update){for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){a.text=e.text;a.color=e.color;a.fontSize=Number(e.fontSize);if(e.fontStyle!=""){a.fontStyle=e.fontStyle}a.align=e.align;a.baseline=e.baseline;a.x=Number(e.x);a.y=Number(e.y);a.type=e.type;break}}}else{if(!this.decorations){this.decorations={}}if(!this.decorations.marker){this.decorations.marker=[]}this.decorations.marker.push({vi:e.vi,si:e.si,variable:e.variable,sample:e.sample,text:e.text,color:e.color,fontSize:Number(e.fontSize),fontStyle:e.fontStyle,align:e.align,baseline:e.baseline,x:Number(e.x),y:Number(e.y),type:e.type})}}this.draw()};this.initializeTooltip=function(){if(!this.disableEvents){this.addInfoSpan();this.addMousePositionDiv()}};this.setFunctionNames("initTooltip");this.initializeTooltip()};CanvasXpress.prototype.initToolbar=function(){this.addToolbarDiv=function(){if(this.$(this.target+"-cX-Toolbar")){return}var h=this.$cX("div",{id:this.target+"-cX-Toolbar",className:"CanvasXpressToolbar"},{position:"absolute",overflow:"hidden",width:this.width+"px",height:(this.toolbarType=="fixed"?"36px":"0px"),top:(this.toolbarType=="fixed"?"-37px":"0px"),right:0,zIndex:(this.graphType=="Map"&&this.leafletLayer?1000:1),backgroundColor:(this.graphType=="Map"&&this.leafletLayer?"rgba(255,255,255,0)":"rgba(255,255,255,0.85)")});var r=this.$cX("div",{id:this.target+"-cX-Toolbar-Custom",className:"CanvasXpressToolbar"},{cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-ToolbarMenu",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.threeBars,alt:"Open menus",title:"Open menus"},{display:"none"});var b=this.$cX("img",{id:this.target+"-cX-ToolbarSave",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.camera,alt:"Save as png",title:"Save as png"});var j=this.$cX("img",{id:this.target+"-cX-ToolbarMove",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.move,alt:"Move Canvas (Grab here)",title:"Move Canvas (Grab here)",draggable:false},{display:(this.movable?"none":"block"),cursor:"move"});var s=this.$cX("img",{id:this.target+"-cX-ToolbarView",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.table,alt:"View table",title:"View table"},{display:(this.graphType.match(/Genome|Map/)||this.disableDataTable?"none":"block")});var k=this.$cX("img",{id:this.target+"-cX-ToolbarLayout",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.funnel,alt:"Explore data",title:"Explore data"},{display:(this.disableDataFilters||this.disableDataTable||this.disableConfigurator?"none":"block")});var g=this.$cX("img",{id:this.target+"-cX-ToolbarLasso",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.lasso,alt:"Lasso Selection",title:"Lasso Selection"},{display:(this.graphType=="Scatter2D"?"block":"none")});var i=this.$cX("img",{id:this.target+"-cX-ToolbarDataExplorer",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.tools,alt:"Configure",title:"Configure"},{display:((this.isMap||this.disableDataExplorer||this.graphType.match(/Genome|Map|Network/))?"none":"block")});var n=this.$cX("img",{id:this.target+"-cX-ToolbarInformation",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.info,alt:"Data Details",title:"Data Details"},{display:(this.info?"block":"none")});var f=this.$cX("img",{id:this.target+"-cX-ToolbarMaxMin",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.maximizeMinimize,alt:"Minimize / Maximize",title:"Minimize / Maximize"},{marginRight:"13px"});h.appendChild(this.beaconImage);h.appendChild(f);h.appendChild(n);h.appendChild(i);h.appendChild(g);h.appendChild(k);h.appendChild(s);h.appendChild(j);h.appendChild(b);h.appendChild(a);h.appendChild(r);var o=this.$("north-wrapper-"+this.target);if(o){o.appendChild(h);this.addRemoveToolbarListeners("addEvtListener")}};this.addRemoveToolbarListeners=function(c){this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMenu"),"click",this.clickMenu,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarSave"),"click",this.print,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMove"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarLayout"),"click",this.clickLayout,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarLasso"),"click",this.clickLasso,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarDataExplorer"),"click",this.clickDataExplorer,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarView"),"click",this.clickView,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarInformation"),"click",this.clickDataDetails,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMaxMin"),"click",this.clickGraphMaxMin,false);var a=this.$(this.target+"-cX-Toolbar-Custom");if(c=="removeEvtListener"&&a){for(var b=0;b<a.childNodes.length;b++){this.addRemoveEvtListener(c,a.childNodes[b],"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener(c,a.childNodes[b],"contextmenu",this.unpinFromToolbar,false)}}};this.backgroundMask=function(a){var b=this.$("container-"+this.target);if(b){if(a){b.style.position="fixed";b.style.left=0;b.style.top=0;b.style.padding="2px";b.style.width=a[0]+"px";b.style.height=a[1]+"px";b.style.zIndex=1000000;b.style.backgroundColor="white"}else{b.style.position="relative";b.style.left="";b.style.top="";b.style.padding="";b.style.width="";b.style.height="";b.style.zIndex="";b.style.backgroundColor=""}}};this.clickMenu=function(a){return function(c,b){if(a.isMenu){a.removeMenus()}else{a.removeMenus();a.addMenu(c,false,false,false,false,false,false,true);a.isMenu=true}}}(this);this.clickLasso=function(a){return function(c,b){a.removeMenus();a.lassoSelected=true}}(this);this.clickLayoutNoAnimation=function(b){if(this.appLayout&&!b){var a=this;this.hideTable(false,function(){a.hideDataFilter();var c=a.$(a.target+"-cX-ToolbarLayout");c.src=CanvasXpress.images.funnel;c.alt="Explore data";c.title="Explore data";a.appLayout=false;a.activeAccordion=false});return false}};this.clickLayoutShowDataFilter=function(d,c,b){var a=this;this.showDataFilter(d,function(){a.moveDataFilter(false,"dock",function(){a.transitionMagic(a.$(a.target+"-cX-DataFilter"),b||"holeIn",c)},d)})};this.clickDataFilters=function(a){return function(g,f,d){a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(g,a.$(a.target+"-cX-ToolbarLayout"),function(){a.clickDataFilters(g,f)})}else{if(a.appLayoutDataTable){a.clickDataTable(g,function(){a.clickLayout(g,a.$(a.target+"-cX-ToolbarLayout"),f)})}else{var c=a.dataFilterWidth+10;a.appLayoutDataFilter=a.appLayoutDataFilter?false:true;if(a.appLayoutDataFilter){a.setDimensions(a.width-c,a.height,true);a.resizeWidthOnLayoutActive=c;a.resizeDataFilterHeight();a.clickLayoutShowDataFilter(g,f)}else{var b=function(){a.hideDataFilter(g,function(){a.resizeViewportMiddle(a.width+c,a.height);a.setDimensions(a.width+c,a.height,true,250);a.resizeWidthOnLayoutActive=false;if(f){f(g)}},brc)};if(a.activeAccordion){a.activateAccordion(false,a.activeAccordion.previousSibling,b)}else{b()}}}}}else{a.showDataFilter(g,function(){a.transitionMagic(a.$(a.target+"-cX-DataFilter"),d||"holeIn",f)})}return false}}(this);this.clickLayoutShowDataTable=function(h,d,g,b,c){this.updateDataTable(false,false,true);if(!this.dataTableLastState||(this.dataTableLastState&&this.dataTableLastState!="docked")){this.moveDataTableDiv("dockMagic")}var a=this.getDataFilterState();var f=this.$("middle-container-"+this.target);if(!g){g=parseInt(f.style.width)+(a=="docked"?(this.dataFilterWidth+6):0)-(this.appLayoutDataTable?17:-1)}if(!b){b=this.dataTableLastHeight||parseInt(this.dataTableTarget.style.height)}this.dataTableTarget=this.$(this.target+"-cX-DataTable");this.updateDataTableResizerDiv(false,g,b);this.endDataTableResizerDiv(true);this.transitionMagic(this.$(this.target+"-cX-DataTable"),c||"holeIn",d)};this.clickDataTable=function(a){return function(f,d,c){a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(f,a.$(a.target+"-cX-ToolbarLayout"),function(){a.clickDataTable(f,d)})}else{if(a.appLayoutDataFilter){a.clickDataFilters(f,function(){a.clickLayout(f,a.$(a.target+"-cX-ToolbarLayout"),d)})}else{a.setDataTableDimensions();var b=a.dataTableLastHeight?a.dataTableLastHeight+6:a.dataTableRowsHeight+81;a.appLayoutDataTable=a.appLayoutDataTable?false:true;if(a.appLayoutDataTable){a.setDimensions(a.width,a.height-b,true);a.resizeHeightOnLayoutActive=true;a.clickLayoutShowDataTable(f,d)}else{a.hideTable(f,function(){a.setDimensions(a.width,a.height+b,true,250);a.resizeHeightOnLayoutActive=false;if(d){d(f)}})}}}}else{a.updateDataTable(false,false,true);a.transitionMagic(a.$(a.target+"-cX-DataTable"),c||"holeIn",d)}return false}}(this);this.clickView=function(a){return function(i,c,h){if(a.view=="canvas"){var f=a.isGroupedData?a.cloneObject(this.groupingFactors):false;a.removeMenus();a.skipRender=true;if(!i){a.meta.canvas.ctx.canvas.style.opacity=0}a.hideToolbar();a.disableToolbar=true;if(f){a.ungroupSamples(true)}var d=a.$(a.target+"-cX-DataTable");a.dataTableTarget=d;a.updateDataTable(false,false,i);a.viewTable=[d.clientWidth,d.clientHeight,f];a.updateDataTableResizerDiv(false,a.width,a.height);a.endDataTableResizerDiv(i);d=a.$(a.target+"-cX-DataTable");d.style.top=-(a.height+3)+"px";d.style.left=0;a.view="table";var b=a.$(a.target+"-cX-DataTableToolbar");b.className="CanvasXpressDataTableToolbar";if(i){a.transitionMagic(a.meta.canvas.ctx.canvas,h||"holeOut",function(){a.meta.canvas.ctx.canvas.style.opacity=0},1000);a.transitionMagic(a.$(a.target+"-cX-DataTable"),c||"swashIn",function(){a.modifyDataTableToolbarView()},1000)}}else{var f=a.viewTable[2];a.removeMenus();a.skipRender=false;a.disableToolbar=false;a.showDataTable=false;if(f){a.groupSamples(f,false,false,false,true)}if(i){a.draw();a.transitionMagic(a.meta.canvas.ctx.canvas,c||"swashIn",function(){a.meta.canvas.ctx.canvas.style.opacity=1});a.view="canvas";a.hideTable(i,function(){var g=a.$(a.target+"-cX-DataTable");a.dataTableTarget=g;a.updateDataTableResizerDiv(false,a.viewTable[0],a.viewTable[1]);var e=a.$(a.target+"-cX-DataTableToolbar");e.className="CanvasXpressDataTableToolbar draggable";a.viewTable=false},h||"holeOut")}else{var d=a.$(a.target+"-cX-DataTable");a.dataTableTarget=d;a.updateDataTableResizerDiv(false,a.viewTable[0],a.viewTable[1]);a.endDataTableResizerDiv();a.updateDataTable();a.moveDataTableDiv("hide");a.hideUnhideDataTable(true);a.resetDataTable(true);a.meta.canvas.ctx.canvas.style.opacity=1;var b=a.$(a.target+"-cX-DataTableToolbar");b.className="CanvasXpressDataTableToolbar draggable";a.draw();a.view="canvas";a.viewTable=false}}a.modifyDataTableToolbarView();return false}}(this);this.clickLayout=function(a){return function(i,c,g){if(!c){if(i){c=i.target||i.srcElement}else{c=a.$(a.target+"-cX-ToolbarLayout")}}if(a.appLayoutDataTable){a.clickDataTable(i,function(){a.clickDataFilters(i,g)})}else{if(a.appLayoutDataFilter){a.clickDataFilters(i,function(){a.clickDataTable(i,g)})}else{a.appLayout=a.appLayout?false:true;c.src=CanvasXpress.images.funnel;c.alt="Explore data";c.title="Explore data";if(a.resizeHeightOnLayout){a.setDataTableDimensions()}if(a.appLayout){var d=a.width;var b=a.dataFilterWidth+10;var f=a.dataTableLastHeight?a.dataTableLastHeight+6:a.dataTableRowsHeight+81;if(a.resizeWidthOnLayout&&a.width-b>=b*1.3){if(a.resizeHeightOnLayout&&a.height-f>=f*1){a.setDimensions(a.width-b,a.height-f,true);a.resizeWidthOnLayoutActive=b;a.resizeHeightOnLayoutActive=f}else{a.setDimensions(a.width-b,a.height,true);a.resizeWidthOnLayoutActive=b}}else{if(a.resizeHeightOnLayout&&a.height-f>=f*1){a.setDimensions(a.width,a.height-f,true);a.resizeHeightOnLayoutActive=f}}a.resizeDataFilterHeight();a.hideToolbar(1);a.clickLayoutShowDataFilter(i);a.clickLayoutShowDataTable(i,function(){if(g){g(i)}},d-3)}else{a.hideToolbar(1);a.hideTable(i);a.hideDataFilter(i,function(){var e=function(){a.resizeWidthOnLayoutActive=false;a.resizeHeightOnLayoutActive=false;a.updateRemoteNavigationWindow(function(){if(g){g(i)}})};if(a.resizeWidthOnLayoutActive){if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height+a.resizeHeightOnLayoutActive,true,false,e)}else{a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height,true,false,e)}}else{if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width,a.height+a.resizeHeightOnLayoutActive,true,false,e)}}})}}}return false}}(this);this.clickDataExplorer=function(a){return function(c,b){a.removeMenus();a.addDataExplorer();a.transitionMagic(a.$(a.target+"-cX-DataExplorer"),b||"holeIn");return false}}(this);this.clickDataDetails=function(a){return function(g,f){if(!g){g=window.event}a.removeMenus();var h=window.document;var b=h.body.scrollLeft;var i=h.body.scrollTop;var c={width:"auto",height:"auto",maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left",opacity:0};a.showTooltipDiv(g,a.info,false,c,20,20,false,f||"holeIn");return false}}(this);this.clickRepResearch=function(a){return function(h,m,c){if(!h){h=window.event}a.removeMenus();var i=window.document;var l=i.body.scrollLeft;var k=i.body.scrollTop;var g=a.prettyColoredJSON(CanvasXpress.stack[a.target],null,true);var b='<pre class="CanvasXpressCodeContent">'+g+"</pre>\n";var f="<code> "+b.replace(/\n/g,"</code>\n<code> ")+"</code>";var o={width:"auto",height:"auto",maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left",opacity:0};a.showTooltipDiv(h,f,false,o,20,20,false,c||"holeIn");return false}}(this);this.clickShowCode=function(a){return function(c,d,b){if(!c){c=window.event}a.removeMenus();a.showCodeDiv(c,b);return false}}(this);this.clickShowRCode=function(a){return function(c,b){if(!c){c=window.event}a.removeMenus();a.showRCodeDiv(c,b);return false}}(this);this.clickShowMetaCode=function(a){return function(c,b){if(!c){c=window.event}a.removeMenus();a.showMetaCodeDiv(c,b);return false}}(this);this.moveCanvasXpressContainer=function(e){if(e){if(this.maximized){var b=this.$(this.target+"-CanvasXpressAnchor");if(b){b.parentNode.insertBefore(e,b);b.parentNode.removeChild(b)}}else{var c=window.document;var b=this.$cX("div",{id:this.target+"-CanvasXpressAnchor"});e.parentNode.insertBefore(b,e);c.body.insertBefore(e,c.body.firstElementChild)}}};this.clickGraphMaxMin=function(a){a.functionCaller="clickGraphMaxMin";return function(g,i){if(a.appLayout||a.appLayoutDataTable||a.appLayoutDataFilter){if(a.appLayout){a.clickLayout(g,a.$(a.target+"-cX-ToolbarLayout"),a.clickGraphMaxMin)}else{if(a.appLayoutDataTable){a.clickDataTable(g,a.clickGraphMaxMin)}else{if(a.appLayoutDataFilter){a.clickDataFilters(g,a.clickGraphMaxMin)}}}}else{var j=a.remoteService?a.$(a.remoteParentId+"-canvasXpressRemoteWindow"):a.$("container-"+a.target);var d=a.$(a.target+"-cX-Toolbar");var h=a.$(a.target+"-cX-ToolbarMaxMin");var f=window.innerWidth;var c=window.innerHeight;var b=window.document;if(j&&d&&h){a.moveCanvasXpressContainer(j);if(a.maximized){if(a.toolbarType=="fixed"){d.style.top="-37px"}a.backgroundMask();h.alt="Maximize";h.title="Maximize";h.src=CanvasXpress.images.maximizeMinimize;a.setDimensions(a.maximized[0],a.maximized[1]);j.style.left=a.maximized[2];j.style.top=a.maximized[3];b.documentElement.style.overflowX=a.maximized[4];b.documentElement.style.overflowY=a.maximized[5];a.maximized=false;a.resizeDataFilterHeight()}else{if(a.toolbarType=="fixed"){d.style.top="0px"}a.backgroundMask([f,c]);h.alt="Minimize";h.title="Minimize";h.src=CanvasXpress.images.maximizeMinimize;a.maximized=i||[a.width,a.height,j.style.left,j.style.top,b.body.style.overflowX,b.body.style.overflowY];b.documentElement.style.overflowX="hidden";b.documentElement.style.overflowY="hidden";a.setDimensions(f-4,c-4);a.resizeDataFilterHeight()}a.hideToolbar(1)}}return false}}(this);this.showToolbar=function(e){if(!this.disableToolbar&&!this.dataTableMaximized){var b=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);var a=this.$(this.target+"-cX-ToolbarMove");if(b&&parseInt(b.style.height)==0&&d&&a){a.style.display=this.movable&&!this.maximized?"block":"none";if(this.toolbarType=="fixed"){b.style.height="36px";b.style.top="-37px"}else{this.resizeMove(b,0,(this.maximized?0:this.toolbarType=="over"?-37:0),this.width,36,250);if(e){var c=this;setTimeout(function(){c.hideToolbar(e)},e)}}}}};this.hideToolbar=function(e,a){if(this.toolbarType!="fixed"){var b=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);if(b&&parseInt(b.style.height)==36&&d){this.resizeMove(b,0,0,this.width,0,500,a)}else{if(e&&b&&parseInt(b.style.height)>0){var c=this;setTimeout(function(){c.hideToolbar(e,a)},e)}}}};this.isToolbar=function(c){var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(d>0&&d<36&&a>0&&a<this.width){this.showToolbar()}else{if(d>36&&d<this.height&&a>0&&a<this.width&&this.toolbarType!="fixed"){this.hideToolbar()}}}};this.initializeToolbar=function(){if(!this.disableEvents&&!this.disableToolbar){this.addToolbarDiv()}};this.setFunctionNames("initToolbar");this.initializeToolbar()};CanvasXpress.prototype.initConfigurator=function(){this.addConfigurator=function(a){return function(ab,C,K,J){var w=false;if(a.disableConfigurator&&!ab.ctrlKey){return}var ae=a.$(a.target+"-cX-Configurator");if(ae){w=true;if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ae;a.activeTarget.style.zIndex=10001}var E="Search property or function";a.configuringOn=true;if(C){if(a.isArray(C)){C=a.isNumber(C[0])?C[0]:Number(C[0].replace("-lab",""))}if(a.graphType=="Network"){a.configuringNetwork=C;if(a.data.nodes.length>C){E="Configure "+(a.data.nodes[C].label||a.data.nodes[C].name||a.data.nodes[C].id)}else{var A=a.data.edges[C-a.data.nodes.length];var G=a.data.nodes[a.data.nodeIndices[A.id1]];var F=a.data.nodes[a.data.nodeIndices[A.id2]];E="Configure "+(G.label||G.name||G.id)+" - "+(F.label||G.name||F.id)}}else{if(a.graphType=="Genome"){a.configuringGenome=C;E="Configure track "+C}}}var B=K!=null&&J!=null?{x:K,y:J}:ab?a.adjustedCoordinates(ab):{x:20,y:20};if(B){K=B.x;J=B.y;if(w){ae.style.left=K+"px";ae.style.top=J+"px";return}else{ae=a.$cX("div",{id:a.target+"-cX-Configurator",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:K+"px",top:J+"px",padding:"10px",position:"absolute",zIndex:10001,opacity:0})}var Y=a.$cX("div",{id:a.target+"-cX-ConfiguratorKeyText"},{display:"block",marginBottom:"5px",width:a.configuratorWidth+"px",height:"24px"});var Z=a.$cX("span",{id:a.target+"-cX-ConfiguratorKeyTextSpan",className:"CanvasXpressConfigurator",innerHTML:E});var H=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyMenu",className:"CanvasXpressConfigurator",src:CanvasXpress.images.list,alt:"Open menus",title:"Open menus"});var aa=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeySearch",className:"CanvasXpressConfigurator",src:CanvasXpress.images.magnifier,alt:"Browse properties by category",title:"Browse properties by category"});var W=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var X=a.$cX("input",{id:a.target+"-cX-ConfiguratorKey",className:"CanvasXpressConfigurator",type:"text"},{display:"block",width:a.configuratorWidth+"px"});var V=a.$cX("select",{id:a.target+"-cX-ConfiguratorCategories",className:"CanvasXpressConfigurator",size:5},{display:"none",width:a.configuratorWidth+"px"});var P=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsText",innerHTML:"Select property"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var O=a.$cX("select",{id:a.target+"-cX-ConfiguratorSugestions",className:"CanvasXpressConfigurator",size:10},{display:"none",width:a.configuratorWidth+"px"});var ad=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsDescription"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px",minHeight:"56px",overflow:"auto"});var M=a.$cX("div",{id:a.target+"-cX-ConfiguratorValueText",innerHTML:"Current value"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var ag=a.$cX("div",{id:a.target+"-cX-ConfiguratorSeeAlso"},{display:"none",width:a.configuratorWidth+"px",minHeight:"20px",overflow:"auto"});var L=a.$cX("input",{id:a.target+"-cX-ConfiguratorValue",className:"CanvasXpressConfigurator",type:"text"},{display:"none",width:a.configuratorWidth+"px"});var D=a.$cX("input",{id:a.target+"-cX-ConfiguratorApply",value:"Apply",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var af=a.$cX("input",{id:a.target+"-cX-ConfiguratorButton",value:"Draw",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var Q=a.$cX("img",{id:a.target+"-cX-ConfiguratorOptionsClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var I=a.$cX("div",{id:a.target+"-cX-ConfiguratorOptions",className:"CanvasXpressConfigurator draggable"},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var S=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorCurrent",className:"CanvasXpressConfiguratorColor"},{width:"181px",height:"24px",cssFloat:"left",cursor:"default",lineHeight:"24px"});var R=a.$cX("img",{id:a.target+"-cX-ConfiguratorColorClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var U=a.$cX("div",{id:a.target+"-cX-ConfiguratorColor",className:"CanvasXpressConfigurator draggable"},{width:"212px",cursor:"move",display:"none",padding:"10px",position:"absolute"});var N=a.$cX("div",{id:a.target+"-cX-ConfiguratorExample",className:"CanvasXpressConfiguratorExample draggable"},{width:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px",cursor:"move",display:"none",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"35px"});var ac=a.$cX("span",{id:a.target+"-cX-ConfiguratorExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var t=a.$cX("img",{id:a.target+"-cX-ConfiguratorExampleClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var h=a.$cX("div",{id:a.target+"-cX-ConfiguratorExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{maxWidth:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px"});Y.appendChild(Z);Y.appendChild(W);Y.appendChild(aa);Y.appendChild(H);I.appendChild(window.document.createTextNode("Select option ..."));I.appendChild(Q);I.appendChild(a.$cX("br"));U.appendChild(S);U.appendChild(R);U.appendChild(a.$cX("br"));N.appendChild(ac);N.appendChild(t);N.appendChild(a.$cX("br"));N.appendChild(h);ae.appendChild(Y);ae.appendChild(X);ae.appendChild(V);ae.appendChild(P);ae.appendChild(O);ae.appendChild(ad);ae.appendChild(ag);ae.appendChild(M);ae.appendChild(L);ae.appendChild(D);ae.appendChild(af);ae.appendChild(I);ae.appendChild(U);ae.appendChild(N);var T=a.$("west-wrapper-"+a.target);if(T){T.appendChild(ae);if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ae;a.addRemoveConfiguratorListeners("addEvtListener");if(a.configuringNetwork||a.configuringGenome){a.selectConfig(false,true)}this.transitionMagic(ae,"swashIn",function(){X.focus()})}}}}(this);this.addConfiguratorCloseMenus=function(a){return function(d,c,b,f){a.removeMenus();a.addConfigurator(d,c,b,f)}}(this);this.addRemoveConfiguratorListeners=function(y){var u=this.$(this.target+"-cX-Configurator");var h=this.$(this.target+"-cX-ConfiguratorCategories");var A=this.$(this.target+"-cX-ConfiguratorSugestions");var w=this.$(this.target+"-cX-ConfiguratorApply");var v=this.$(this.target+"-cX-ConfiguratorButton");var j=this.$(this.target+"-cX-ConfiguratorKeyClose");var k=this.$(this.target+"-cX-ConfiguratorKeySearch");var g=this.$(this.target+"-cX-ConfiguratorKeyMenu");var r=this.$(this.target+"-cX-ConfiguratorOptions");var a=this.$(this.target+"-cX-ConfiguratorOptionsClose");var e=this.$(this.target+"-cX-ConfiguratorColor");var d=this.$(this.target+"-cX-ConfiguratorColorClose");var o=this.$(this.target+"-cX-ConfiguratorExample");var x=this.$(this.target+"-cX-ConfiguratorExampleClose");if(u&&h&&A&&v&&w&&j&&k&&g&&r&&a&&e&&d&&o&&x){this[y](u,"mousedown",this.registerMousemove,false);this[y](h,"change",this.changeCategory,false);this[y](h,"click",this.changeCategory,false);this[y](A,"change",this.clickSuggestions,false);this[y](A,"click",this.clickSuggestions,false);this[y](w,"click",this.clickApplyConfigurator,false);this[y](v,"click",this.clickConfigurator,false);this[y](g,"click",this.clickMenuDropDown,false);this[y](k,"click",this.clickSearch,false);this[y](j,"click",this.closeConfigurator,false);this[y](r,"mousedown",this.registerMousemove,false);this[y](a,"click",this.closePropertyOptions,false);this[y](e,"mousedown",this.registerMousemove,false);this[y](d,"click",this.closePropertyColor,false);this[y](o,"mousedown",this.registerMousemove,false);this[y](x,"click",this.closePropertyExample,false)}};this.getConfigurableProperties=function(){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return this.getNodeConfigurableProperties(this.configuringNetwork)}else{return this.getEdgeConfigurableProperties(this.configuringNetwork-this.data.nodes.length)}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return this.featureConfigurableProperties}else{if(this.configuringGenome.match(/track/)){return this.trackConfigurableProperties}else{this.configuringGenome=false}}}}var c=[];for(var b in CanvasXpress.doc.P){if(!CanvasXpress.doc.P[b].Z){var a=this.getGraphTypes(CanvasXpress.doc.P[b],true);if(a.hasOwnProperty(this.graphType)){c.push(b)}}}return c};this.getConfigurableObjectDoc=function(a){return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false};this.selectConfig=function(D,F){var z=this.$(this.target+"-cX-ConfiguratorKey");var q=this.$(this.target+"-cX-ConfiguratorSugestionsText");var n=this.$(this.target+"-cX-ConfiguratorSugestions");var E=this.$(this.target+"-cX-ConfiguratorSugestionsDescription");var l=this.$(this.target+"-cX-ConfiguratorValueText");var H=this.$(this.target+"-cX-ConfiguratorSeeAlso");var j=this.$(this.target+"-cX-ConfiguratorValue");var f=this.$(this.target+"-cX-ConfiguratorApply");var G=this.$(this.target+"-cX-ConfiguratorButton");var B=this.$(this.target+"-cX-ConfiguratorValueHREF");var m=window.document.activeElement;var y=this.getConfigurableProperties();var w=[];if(this.getKeyCode(D)==13){this.resetOptionColorExamples();if(n&&j&&j.value){var g=false;for(var A=0;A<y.length;A++){if(n.value==y[A]){g=true;break}}if(g){this.clickConfigurator(D,n,j)}else{this.resetConfigurator(D)}}}else{if(z&&m.id==z.id||F){this.resetOptionColorExamples();for(var A=0;A<y.length;A++){if(y[A].toLowerCase().indexOf(z.value.toLowerCase())>=0){w.push(y[A])}}if(w.length>0&&q&&n&&E&&l&&H&&j&&G&&f){this.resetSugestions();w.sort();if(!this.configuringNetwork&&!this.configuringGenome){for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}else{for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}n.options[0].selected=true;this.setConfiguratorPropertyValue(n,E,l,H,j);q.innerHTML="Select property ("+w.length+")";q.style.display="block";n.style.display="block";E.style.display="block";l.style.display="block";H.style.display="block";j.style.display="block";G.style.display="block";f.style.display="block"}else{z.value=z.value.slice(0,z.value.length-1)}}else{if(j&&m.id==j.id){this.resetOptionColorExamples();if(B&&B.innerHTML=="color"){B.style.color=j.value?this.rgbToHex(this.validateColor(j.value.replace(/[\'\"]/g,""))):this.foreground}}else{if(this.remoteService){this.resetOptionColorExamples();this.selectDataSet(D)}}}}return false};this.clickSearch=function(a){return function(G){a.configuringNetwork=false;a.configuringGenome=false;a.resetOptionColorExamples();var E=a.$(a.target+"-cX-ConfiguratorKeyTextSpan");var C=a.$(a.target+"-cX-ConfiguratorKey");var A=a.$(a.target+"-cX-ConfiguratorCategories");var w=a.$(a.target+"-cX-ConfiguratorSugestionsText");var t=a.$(a.target+"-cX-ConfiguratorSugestions");var H=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var q=a.$(a.target+"-cX-ConfiguratorValueText");var J=a.$(a.target+"-cX-ConfiguratorSeeAlso");var p=a.$(a.target+"-cX-ConfiguratorValue");var I=a.$(a.target+"-cX-ConfiguratorButton");var c=a.$(a.target+"-cX-ConfiguratorApply");var h=a.$(a.target+"-cX-ConfiguratorOptions");var y=a.$(a.target+"-cX-ConfiguratorColor");var B=a.getKeys(CanvasXpress.doc.M).sort();var j=[];if(C&&C.style.display=="none"){if(E){E.innerText="Search property or function"}if(A){A.style.display="none"}C.value="";C.style.display="block"}else{if(E){for(var D=0;D<B.length;D++){if(CanvasXpress.doc.M[B[D]].U){var f=a.getGraphTypes({M:B[D]},true);if(f.hasOwnProperty(a.graphType)){j.push(B[D])}}else{j.push(B[D])}E.innerText="Select category ("+j.length+")"}}if(C){C.style.display="none"}if(A){a.resetCategories();for(var D=0;D<j.length;D++){var x=a.$cX("option",{text:j[D],value:j[D]});try{A.add(x,null)}catch(F){A.add(x)}}A.style.display="block"}}if(w&&t&&H&&q&&J&&p&&I&&c&&h&&y){w.style.display="none";t.style.display="none";H.style.display="none";q.style.display="none";J.style.display="none";p.style.display="none";I.style.display="none";c.style.display="none";h.style.display="none";y.style.dysplay="none"}return false}}(this);this.clickMenuDropDown=function(a){return function(b){a.closeConfigurator(b);a.addMenu(b,false,false,false,8,8);return false}}(this);this.closeConfigurator=function(a){return function(b){a.resetViewportOverflow("west");a.resetConfigurator(b);return false}}(this);this.changeCategory=function(a){return function(F,C,H){a.resetOptionColorExamples();var B=a.$(a.target+"-cX-ConfiguratorCategories");var t=a.$(a.target+"-cX-ConfiguratorSugestionsText");var q=a.$(a.target+"-cX-ConfiguratorSugestions");var G=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var l=a.$(a.target+"-cX-ConfiguratorValueText");var J=a.$(a.target+"-cX-ConfiguratorSeeAlso");var k=a.$(a.target+"-cX-ConfiguratorValue");var f=a.$(a.target+"-cX-ConfiguratorApply");var I=a.$(a.target+"-cX-ConfiguratorButton");var g=a.$(a.target+"-cX-ConfiguratorOptions");var A=a.$(a.target+"-cX-ConfiguratorColor");var h=CanvasXpress.doc.M;if(H){B.value=H}if(B&&B.value&&t&&q&&G&&l&&J&&k&&I&&g&&A){var w=h[B.value].P.sort();a.resetSugestions();for(var D=0;D<w.length;D++){if(H&&w[D]==H){C=D}var y=a.$cX("option",{text:w[D],value:w[D]});try{q.add(y,null)}catch(E){q.add(y)}}q.options[C||0].selected=true;t.innerHTML="Select property ("+w.length+")";a.setConfiguratorPropertyValue(q,G,l,J,k);t.style.display="block";q.style.display="block";G.style.display="block";l.style.display="block";J.style.display="block";k.style.display="block";f.style.display="block";I.style.display="block";g.style.display="none";A.style.display="none"}return false}}(this);this.hideCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");var b=this.$(this.target+"-cX-ConfiguratorKeyTextSpan");var c=this.$(this.target+"-cX-ConfiguratorKeySearch");var e=this.$(this.target+"-cX-ConfiguratorKeyDock");if(a&&b&&c&&e){a.style.display="none";b.innerHTML="";c.style.display="none";e.style.display="none"}};this.resetCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.clickSuggestions=function(a){return function(b){a.resetOptionColorExamples();a.setConfiguratorPropertyValue();return false}}(this);this.setConfiguratorPropertyValue=function(l,e,j,g,h){if(!l){l=this.$(this.target+"-cX-ConfiguratorSugestions")}if(!e){e=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!j){j=this.$(this.target+"-cX-ConfiguratorValueText")}if(!g){g=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(!h){h=this.$(this.target+"-cX-ConfiguratorValue")}var k;var f=this.$(this.target+"-cX-ConfiguratorOptions");var c=this.getConfigurableObjectDoc(l.value);h.value="";h.style.readonly=false;if(this.configuringNetwork){if(typeof(this[l.value])=="function"){h.style.disabled="disabled";h.style.readonly=false}else{if(this.configuringNetwork<this.data.nodes.length){k=this.data.nodes[this.configuringNetwork][l.value]}else{k=this.data.edges[this.configuringNetwork-this.data.nodes.length][l.value]}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){k=this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][l.value]}else{if(this.configuringGenome.match(/:/)){k=parseInt(this.configuringGenome.split(":")[1]);k=this.data.tracks[b[k].track].data[b[k].index][l.value]}else{k=parseInt(this.configuringGenome.replace("track-",""));k=this.data.tracks[b[k].track][l.value]}}}else{if(typeof(this[l.value])=="function"){j.innerHTML="Current&nbsp;value&nbsp;[&nbsp;<i>function</i>&nbsp;]&nbsp;"+this[l.value].length+"&nbsp;parameter(s)";if(this[l.value].length==0){h.style.disabled="disabled";h.style.readonly=false}}else{k=this[l.value]}}}h.value=k?this.stringifyJSON(k):"";this.addPropertyDescription(e,c,l.value);this.addPropertySeeAlsoLinks(g,c);this.addPropertyOptions(j,f,c,l.value,k);if(this.showConfiguratorExamplesOnSelect){this.resetPropertyExample();this.clickExamplePropertyDescription(false,l.value)}};this.resetSugestions=function(){var a=this.$(this.target+"-cX-ConfiguratorSugestions");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.addPropertyDescription=function(l,f,e){var n=f&&f.C?f.C:"";var g=f&&f.M?f.M:"";var t=f&&f.H?true:false;this.resetPropertyDescription(l);var a=this.$cX("i",{innerHTML:e});var u=this.$cX("span",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan",className:"CanvasXpressConfigurator",prop:e,innerHTML:" : "+n});var j=this.$cX("i",{innerHTML:g});var k=this.$cX("a",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionExample",href:"javascript:void(0)",alt:"Show examples",title:"Show examples"});var r=this.$cX("span",false,{className:"CanvasXpressConfigurator"});k.appendChild(a);r.appendChild(window.document.createTextNode("Description [ "));r.appendChild(j);r.appendChild(window.document.createTextNode(" ]"));l.appendChild(r);l.appendChild(this.$cX("br"));l.appendChild(t?k:a);l.appendChild(u);this.addEvtListener(k,"click",this.clickExamplePropertyDescription,false)};this.resetPropertyDescription=function(b,a){if(!b){b=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(b){if(!a){a=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionExample")}if(a){this.removeEvtListener(a,"click",this.clickExamplePropertyDescription,false)}while(b.childNodes.length>0){var e=b.childNodes[0];b.removeChild(e)}}};this.getGraphTypes=function(e,c){var a=[];if(e.U){for(var b=0;b<e.U.length;b++){var d=e.U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{if(CanvasXpress.doc.M[e.M].U){for(var b=0;b<CanvasXpress.doc.M[e.M].U.length;b++){var d=CanvasXpress.doc.M[e.M].U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{a=["Bar"]}}return c?this.getObjectArray(a):this.getUniqueEls(a).sort()};this.getExamplesDocObject=function(c,v){var h=[];if(c){var g=this.getConfigurableObjectDoc(c);var w=this.getGraphTypes(g);for(var n=0;n<g.H.length;n++){if(g.H[n].match(/^\{\[/)){var s=[];var a=g.H[n]=="{[*]}"||g.H[n].match(/^\{\[.+?\]\}[^,]/)||g.H[n].match(/^\{\[.+\]\}[^,]$/)?{}:this.parseJSON(String(g.H[n].replace(/^\{\[.+?\],/,"{")));var e=a.data?this.getDataSet(a.data):false;var l=a.skipExample?this.getObjectArray(a.skipExample):{};var q=a.functions?a.functions:false;if(e){delete (a.data)}if(l){delete (a.skipExample)}if(q){delete (a.functions)}if(g.H[n].match(/^\{\[[^\*].+\]/)){s=g.H[n].replace(/"/g,"");s=s.split("]")[0].replace("{[","").split(",")}else{if(g.T=="option"){s=g.O}else{if(g.T=="boolean"){s=[true,false]}else{if(g.T=="color"){s=["rgb(255,125,51)","rgb(51,255,125)","rgb(125,51,255)"];s.unshift(g.D)}else{if(g.T=="float"){s=g.D=="null"?[null,0.5]:[parseFloat(g.D),Math.max(parseFloat(g.D)*2,1)]}else{if(g.T=="integer"){s=g.D==0?[0,1]:[parseInt(g.D),parseInt((parseInt(g.D)*2)+0.5)]}}}}}}if(s.length>8){s=this.sample(s,8)}for(var m=0;m<s.length;m++){if(l.hasOwnProperty(s[m])){continue}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+String(s[m]).replace(/\s/m,"-")+"-"+n;var k=this.cloneObject(a);if(s[m]=="null"||s[m]==null){k[c]=null}else{k[c]=g.T=="integer"||g.T=="float"?Number(s[m]):s[m];if(k[c]=="false"){k[c]=false}else{if(k[c]=="true"){k[c]=true}}}if(!k.graphType){k.graphType=w[2]||w[0]}if(q){h.push([b,e,k,q])}else{h.push([b,e,k])}}}else{var m=this.parseJSON(String(g.H[n]));var t=m.data?this.getDataSet(m.data):false;var r=m.functions?m.functions:false;if(t){delete (m.data)}if(r){delete (m.functions)}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+n;if(!m.graphType){m.graphType=w[2]||w[0]}if(r){h.push([b,t,m,r])}else{h.push([b,t,m])}}}}return h};this.clickExamplePropertyDescription=function(a){return function(x,q,B){a.resetPropertyExample();var d=function(){if(a.graphType!=l){l=a.graphType;A=a.getDataSet()}return A};var w=B?a.$(q+"-cX-API-Example"):a.$(a.target+"-cX-ConfiguratorExample");var f=B?a.$(q+"-cX-API-ExampleSpan"):a.$(a.target+"-cX-ConfiguratorExampleSpan");var o=B?a.$(q+"-cX-API-ExampleContent"):a.$(a.target+"-cX-ConfiguratorExampleContent");var l=a.graphType;var A=a.getDataSet();if(w&&f&&o){w.style.display="block";if(!q){q=this.firstChild.innerHTML}var g=a.getExamplesDocObject(q);f.innerHTML=q;for(var t=0;t<g.length;t++){var r=g[t][0];var u=g[t][2];a.graphType=u.graphType;var n=g[t][1]?this.cleanData(a.cloneObject(g[t][1])):this.cleanData(d());var h=g[t][3];var y=a.$cX("canvas",{id:r,width:B?500:a.configuratorExamplesSize,height:B?500:a.configuratorExamplesSize});o.appendChild(y);if(!u.title){if(u[q]!=null){if(this.isArray(u[q])){u.title=q+" : "+u[q].join(",")}else{if(this.isObject(u[q])){u.title=q+" : Object"}else{u.title=q+" : "+u[q]}}}else{u.title=q+" : null"}}var k=new CanvasXpress(r,n,u);if(h){for(var s=0;s<h.length;s++){if(h[s].match(/:/)){var b=h[s].split(":");k[b.shift()].apply(k,b)}else{k[h[s]]()}}}}if(!B){if(a.alignConfiguratorExamples||a.configuratorLastState=="docked"){var m=a.$(a.target+"-cX-Configurator");w.style.left=m.offsetWidth+"px";w.style.top="-1px";w.style.height=(m.clientHeight-45)+"px";o.style.maxHeight=(m.clientHeight-45)+"px";a.removeClass(w,"draggable")}else{var z=a.adjustedCoordinates(x,w);w.style.left=z.x+"px";w.style.top=z.y+"px";delete (w.style.height);o.style.Maxheight="500px";a.addClass(w,"draggable")}}}}}(this);this.addPropertySeeAlsoLinks=function(f,j){this.resetPropertySeeAlsoLinks(f);var h=window.document;var e=this.$cX("span",false,{className:"CanvasXpressConfigurator"});e.appendChild(h.createTextNode("See Also: "));f.appendChild(e);if(j&&j.S){for(var g=0;g<j.S.length;g++){var k=this.$cX("a",{href:"javascript:void(0)",innerHTML:j.S[g]});this.addEvtListener(k,"click",this.clickPropertySeeAlsoLinks,false);f.appendChild(k);if(g<j.S.length-1){f.appendChild(h.createTextNode(", "))}}}};this.clickPropertySeeAlsoLinks=function(a){return function(h){var f=a.$(a.target+"-cX-ConfiguratorKey");var b=a.$(a.target+"-cX-ConfiguratorCategories");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var c=h.target||h.srcElement;if(b&&b.style.display=="block"){var l=CanvasXpress.doc.P[c.innerHTML];var j=CanvasXpress.doc.M[l.M].P.sort();b.value=l.M;for(i=0;i<j.length;i++){if(j[i]==c.innerHTML){a.changeCategory(h,i);return false}}a.changeCategory(h)}else{if(f){f.value=c.innerHTML;a.selectConfig(h,true)}}return false}}(this);this.resetPropertySeeAlsoLinks=function(b){if(!b){b=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(b&&b.childNodes){while(b.childNodes.length>0){var d=b.childNodes[0];if(d.nodeName.toLowerCase()=="a"){this.removeEvtListener(d,"click",this.clickPropertySeeAlsoLinks,false)}b.removeChild(d)}}};this.addPropertyOptions=function(x,p,f,g,w){this.resetPropertyOptions(x,p);var s=window.document;var q=this.$cX("span",false,{className:"CanvasXpressConfigurator"});var l=this.$cX("i");q.appendChild(s.createTextNode("Current value"));if(f&&f.T&&(f.T=="option"||f.T=="array"||f.T=="boolean")){var y=this.$cX("div",{id:this.target+"-cX-ConfiguratorOptionsContainer",className:"CanvasXpressConfiguratorOptions"});var r=this.$cX("a",{href:"javascript:void(0)",innerHTML:f.T,alt:"Modify property",title:"Modify property"});this.addEvtListener(r,"click",this.clickPropertyOptions,false);q.appendChild(s.createTextNode(" ["));l.appendChild(r);q.appendChild(s.createTextNode(" "));q.appendChild(l);q.appendChild(s.createTextNode(" ]"));if(f.T=="array"){var n=f.X?this[f.X]():f.O?f.O:[];var m=this.getObjectArray(w);if(n.length>0){for(var h=0;h<n.length;h++){var g=this.$cX("input",{type:"checkbox",value:n[h],checked:m.hasOwnProperty(n[h])?true:false},{marginLeft:"0px"});this.addEvtListener(g,"change",this.updatePropertyValue,false);y.appendChild(s.createTextNode((h+1)+". "));y.appendChild(g);y.appendChild(s.createTextNode(n[h]));y.appendChild(this.$cX("br"))}}else{y.appendChild(this.$cX("br"));y.appendChild(s.createTextNode("This array is user defined"));y.appendChild(this.$cX("br"))}}else{var n=f.T=="boolean"?["true","false"]:f.X?this[f.X]():f.O?f.O:[];if(f.X&&f.O){n=n.concat(f.O)}for(var h=0;h<n.length;h++){var g=this.$cX("a",{href:"javascript:void(0)",innerHTML:n[h],alt:"Modify property",title:"Modify property"},{padding:"2px"});this.addEvtListener(g,"click",this.updatePropertyValue,false);y.appendChild(s.createTextNode((h+1)+". "));y.appendChild(g);y.appendChild(this.$cX("br"))}}p.appendChild(y)}else{if(f&&f.T){q.appendChild(s.createTextNode(" ["));if(f.T=="color"){var n;if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){n=this.data.nodes[this.configuringNetwork][g]}else{n=this.data.edges[this.configuringNetwork-this.data.nodes.length][g]}}else{if(this.configuringGenome){var e=this.subtracksInfo;if(!isNaN(this.configuringGenome)){n=this.data.tracks[e[this.configuringGenome].track].data[e[this.configuringGenome].index]}else{if(this.configuringGenome.match(/:/)){n=parseInt(this.configuringGenome.split(":")[1]);n=this.data.tracks[e[n].track].data[e[n].index]}else{n=parseInt(this.configuringGenome.replace("track-",""));n=this.data.tracks[e[n].track]}}}else{n=this[g]}}var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueHREF",href:"javascript:void(0)",innerHTML:f.T,alt:"Modify color",title:"Modify color"},{color:n?this.rgbToHex(this.validateColor(n)):this.foreground});this.addEvtListener(r,"click",this.addPropertyColor,false);l.appendChild(r)}else{l.appendChild(s.createTextNode(f.T))}q.appendChild(s.createTextNode(" "));q.appendChild(l);q.appendChild(s.createTextNode(" ]"))}}x.appendChild(q)};this.clickPropertyOptions=function(a){return function(b){var c=a.$(a.target+"-cX-ConfiguratorOptions");if(c){c.style.display="block";c.style.left=b.layerX+"px";c.style.top=b.layerY+"px"}return false}}(this);this.closePropertyOptions=function(a){return function(b){a.handleHideDiv(a.target+"-cX-ConfiguratorOptions")}}(this);this.resetPropertyOptions=function(a,e,b){if(!a){a=this.$(this.target+"-cX-ConfiguratorValueText")}if(!e){e=this.$(this.target+"-cX-ConfiguratorOptions")}if(a&&a.childNodes&&!b){while(a.childNodes.length>0){var f=a.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.clickPropertyOptions,false)}a.removeChild(f)}}if(e){var d=this.$(this.target+"-cX-ConfiguratorOptionsContainer");if(d){while(d.childNodes.length>0){var f=d.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.updatePropertyValue,false)}else{if(f.nodeName.toLowerCase()=="input"&&f.type=="checkbox"){this.removeEvtListener(f,"change",this.updatePropertyValue,false)}}d.removeChild(f)}e.removeChild(d)}e.style.display="none"}};this.closePropertyExample=function(a){return function(b){a.handleHideDiv(a.target+"-cX-ConfiguratorExample");a.resetPropertyExample()}}(this);this.resetPropertyExample=function(a){var b=this.$(this.target+"-cX-ConfiguratorExample");if(b){this.destroyInDOM(b.getElementsByTagName("canvas"));if(!a){b.style.display="none"}}};this.addPropertyColor=function(a){return function(j){var d=a.$(a.target+"-cX-ConfiguratorColor");var t=a.$(a.target+"-cX-ConfiguratorValue");if(d&&t){var g=t.value?a.rgbToHex(a.validateColor(t.value.replace(/[\'\"]/g,""))):a.foreground;a.colorRGBfromString(g);var r=Math.round(a.colorHSV[0]/6*180);var q=Math.round((1-a.colorHSV[1])*100);var m=Math.round((1-a.colorHSV[2])*100);var l=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorContainer"},{width:"210px",height:"101px",marginTop:"7px"});var b=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPalette",className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var o=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPaletteCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(r-7)+"px",top:(q-7)+"px",width:"195px",height:"115px"});b.appendChild(o);var w=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturation",className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",cursor:"crosshair"});for(var f=0;f<100;f+=4){var u=a.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});w.appendChild(u)}var k=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturationCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(m-108)+"px",width:"29px",height:"115px"});w.appendChild(k);l.appendChild(b);l.appendChild(w);d.appendChild(l);a.colorizeCurrentColorDiv();a.colorizeSaturationColorDiv();a.addEvtListener(b,"mousedown",a.registerPalette,false);a.addEvtListener(w,"mousedown",a.registerSaturation,false);d.style.display="block";d.style.left=j.layerX+"px";d.style.top=j.layerY+"px"}return false}}(this);this.registerPalette=function(a){return function(b){a.changingColorOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentColorDiv();var c=a.$(a.target+"-cX-ConfiguratorColorSaturationCurrent");if(c){c.style.top="-108px"}}a.updateColorValue(b);a.colorizeSaturationColorDiv();return false}}(this);this.registerSaturation=function(a){return function(b){a.changingColorOn="saturation";a.updateColorValue(b);return false}}(this);this.updateColorValue=function(g){if(this.changingColorOn){if(this.changingColorOn=="palette"){var f=this.$(this.target+"-cX-ConfiguratorColorPalette");var b=this.$(this.target+"-cX-ConfiguratorColorPaletteCurrent");if(f&&b){var d=this.adjustedCoordinates(g,f);if(d){var a=Math.min(Math.max(0,d.x),181);var j=Math.min(Math.max(0,d.y),101);b.style.left=(a-7)+"px";b.style.top=(j-7)+"px";this.colorFromHsv(a*6/180,1-j/100,null);this.colorizeCurrentColorDiv();this.colorizeSaturationColorDiv()}}}else{var c=this.$(this.target+"-cX-ConfiguratorColorSaturation");var h=this.$(this.target+"-cX-ConfiguratorColorSaturationCurrent");if(c&&h){var d=this.adjustedCoordinates(g,c);if(d){var j=Math.min(Math.max(0,d.y),101);h.style.top=(j-108)+"px";this.colorFromHsv(null,null,1-j/100);this.colorizeCurrentColorDiv()}}}}};this.colorizeCurrentColorDiv=function(){var f=this.$(this.target+"-cX-ConfiguratorColorCurrent");var a=this.$(this.target+"-cX-ConfiguratorValue");var d=this.$(this.target+"-cX-ConfiguratorValueHREF");if(f&&a&&d){var e=this.colorRGBToString();var b=this.hexToRgb("#"+e);f.style.backgroundColor="#"+e;f.innerHTML="&nbsp;&nbsp;"+b;f.style.color=this.complementaryColor(b,true);a.value='"'+b+'"';d.style.color="#"+e}};this.colorizeSaturationColorDiv=function(){var b=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var e=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(e&&this.colorHSV){var f=e.childNodes;var a=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(a){for(var d=0;d<f.length-1;d++){f[d].style.backgroundColor=b(a[0],a[1],a[2],d,f.length-1)}}}};this.endColorChange=function(a){this.changingColorOn=false};this.closePropertyColor=function(a){return function(b){a.handleHideDiv(a.target+"-cX-ConfiguratorColor");a.resetPropertyColor()}}(this);this.resetPropertyColor=function(){var c=this.$(this.target+"-cX-ConfiguratorColor");var b=this.$(this.target+"-cX-ConfiguratorColorPalette");var a=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(c&&b&&a){if(c&&c.childNodes){while(c.childNodes.length>3){c.removeChild(c.childNodes[3])}this.removeEvtListener(b,"mousedown",this.registerPalette,false);this.removeEvtListener(a,"mousedown",this.registerSaturation,false)}c.style.display="none"}};this.updatePropertyValue=function(a){return function(h){var f=a.$(a.target+"-cX-ConfiguratorValue");var j=a.$(a.target+"-cX-ConfiguratorOptions");var d=h.target||h.srcElement;if(d.nodeName.toLowerCase()=="input"){var b=[];for(var g=0;g<d.parentNode.childNodes.length;g++){var k=d.parentNode.childNodes[g];if(k.checked){b.push(k.value)}}f.value=b.length>0?'["'+b.join('", "')+'"]':"[]"}else{if(f&&j){if(d.innerHTML=="true"){f.value=d.innerHTML}else{if(d.innerHTML=="false"){f.value=d.innerHTML}else{if(d.innerHTML=="null"){f.value=d.innerHTML}else{f.value='"'+d.innerHTML+'"'}}}j.style.display="none"}}return false}}(this);this.clickApplyConfigurator=function(a){return function(b){return a.clickConfigurator(b,false,false,true)}}(this);this.clickConfigurator=function(a){return function(g,d,c,b){if(!d){d=a.$(a.target+"-cX-ConfiguratorSugestions")}if(!c){c=a.$(a.target+"-cX-ConfiguratorValue")}if(d&&c){var f=a.getConfigurableObjectDoc(d.value);if(c.value){var h=a.parseJSON(c.value);if(f.T=="color"&&!a.validateColor(h)){alert('"'+h+'" is NOT a valid color');return false}}}a.updateClickConfigurator(g,d.value,c.value,b);return false}}(this);this.updateClickConfigurator=function(g,m,k,j){this.functionCaller="updateClickConfigurator";if(this.isTransition()){return}if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){if(typeof(this[m])=="function"){this[m](this.data.nodes[this.configuringNetwork])}else{this.data.nodes[this.configuringNetwork][m]=this.parseJSON(k)}}else{if(typeof(this[m])=="function"){this[m](this.data.edges[this.configuringNetwork-this.data.nodes.length])}else{this.data.edges[this.configuringNetwork-this.data.nodes.length][m]=this.parseJSON(k)}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][m]=this.parseJSON(k)}else{if(this.configuringGenome.match(/:/)){var h=parseInt(this.configuringGenome.split(":")[1]);this.data.tracks[b[h].track].data[b[h].index][m]=this.parseJSON(k)}else{var h=parseInt(this.configuringGenome.replace("track-",""));this.data.tracks[h][m]=this.parseJSON(k)}}}else{if(typeof(this[m])=="function"){if(this[m].length>0&&k){var c=this.parseJSON(k);this[m](c)}else{this[m]()}this.resetConfigurator(g);return false}else{if(m=="summaryType"&&this.isGroupedData&&this[m]!=this.parseJSON(k)){var l=this.groupingFactors;this.ungroupSamples(true);this[m]=this.parseJSON(k);this.meta.config.user[m]=this[m];this.groupSamples(l,false,false,false,true)}else{this[m]=this.parseJSON(k);this.meta.config.user[m]=this[m]}}}}if(!j){this.resetConfigurator(g)}var d=m.match(/filter(.+)By/);if(d){this.reset();this.filterData()}this.resetPropertyExample();this.draw()};this.handleHideDiv=function(a){var b=this.$(a);if(b){b.style.display="none"}return false};this.resetOptionColorExamples=function(){this.resetPropertyOptions(false,false,true);this.resetPropertyColor();this.resetPropertyExample()};this.resetConfigurator=function(a){if(this.configuringOn&&this.configuringOn!="docked"){var b=this.$(this.target+"-cX-Configurator");this.resetOptionColorExamples();this.resetPropertyDescription();this.resetPropertySeeAlsoLinks();this.configuratorLastState=false;this.configuringOn=false;this.configuringNetwork=false;this.configuringGenome=false;this.addRemoveConfiguratorListeners("removeEvtListener");this.transitionMagic(b,"holeOut",function(){b.parentNode.removeChild(b)})}};this.setFunctionNames("initConfigurator")};CanvasXpress.prototype.initCodeInfo=function(){this.addInfoCodeDiv=function(){if(this.$(this.target+"-cX-Code")){return}var g=this.$cX("div",{id:this.target+"-cX-Code",className:"CanvasXpressCode draggable"},{left:"25px",top:"-"+(this.height-25)+"px",display:"none"});var h=this.$cX("img",{id:this.target+"-cX-CodeCloseImage",className:"CanvasXpressCode",src:CanvasXpress.images.cancel,alt:"Close Code",title:"Close Code"});var e=this.$cX("img",{id:this.target+"-cX-CodePrettyImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeIndent,alt:"Pretty Code",title:"Pretty Code"});var d=this.$cX("img",{id:this.target+"-cX-CodeCompactImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeCompact,alt:"Compact Code",title:"Compact Code"});var b=this.$cX("img",{id:this.target+"-cX-CodeParamsImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeParams,alt:"Params Code",title:"Params Code"});var j=this.$cX("img",{id:this.target+"-cX-CodeSelectImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeSelect,alt:"Select Code",title:"Select Code"});var f=this.$cX("div",{id:this.target+"-cX-CodeContainer",className:"CanvasXpressCodeContainer"});var a=this.$("north-wrapper-"+this.target);var k=this.$("south-wrapper-"+this.target);if(a){a.appendChild(f)}if(k){g.appendChild(h);g.appendChild(e);g.appendChild(d);g.appendChild(b);g.appendChild(j);g.appendChild(f);k.appendChild(g);this.addRemoveCodeListeners("addEvtListener")}};this.addRemoveCodeListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-Code"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCloseImage"),"click",this.clickCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodePrettyImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCompactImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeParamsImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeSelectImage"),"click",this.clickSelectCode,false)};this.clickCode=function(a){return function(b){a.hideCodeDiv(b);return false}}(this);this.clickChangeCode=function(a){return function(c){var b=a.getTargetEvent(c);switch(b.id){case a.target+"-cX-CodePrettyImage":a.codeType="pretty";break;case a.target+"-cX-CodeCompactImage":a.codeType="compact";break;case a.target+"-cX-CodeParamsImage":a.codeType="params";break;default:break}a.updateCodeDiv();return false}}(this);this.clickSelectCode=function(a){return function(d){var b;var c=a.$(a.target+"-cX-CodeContent");if(c){if(document.selection){b=document.body.createTextRange();b.moveToElementText(c);b.select()}else{if(window.getSelection()){b=document.createRange();b.selectNode(c);window.getSelection().removeAllRanges();window.getSelection().addRange(b)}}}return false}}(this);this.clearCodeDiv=function(){var b=this.$(this.target+"-cX-Code");var a=this.$(this.target+"-cX-CodeContent");if(b&&a){a.parentNode.removeChild(a);b.style.display="none"}};this.getDataJSON=function(b){var a={x:true,y:true,z:true,venn:true,nodes:true,edges:true,tracks:true};var d={sankey:true,tree:true,bubble:true,gantt:true};var f={};for(var c in this.data){if(a.hasOwnProperty(c)){f[c]=this.cloneObject(this.data[c],true)}}return b?this.prettyJSON(f,null,true):this.stringifyJSON(f)};this.getConfigJSON=function(a){return a?this.prettyJSON(this.getConfig(),null,