% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_behaviour.R
\name{get_self_report_pa_score}
\alias{get_self_report_pa_score}
\title{Compute a score for a response to the self-reported physical activity question.}
\usage{
get_self_report_pa_score(x = NA)
}
\arguments{
\item{x}{A numeric (integer) vector representing the self-reported physical activity question (valid values are integers between 0 and 7).}
}
\value{
Returns a numeric (integer) vector with values between 0 and 5 (if valid) or NA (if not valid).
}
\description{
This function computes a score (\code{self_report_pa_score}) for a response to "During the past week (7 days), on how many days were you physically active for
a total of at least 60 minutes per day? (all the time you spent in activities that increased your heart rate and made you breathe hard)?" in
\href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute the daily
behaviour domain score (\code{db_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_self_report_pa_score(c(1, 8, 3, 4, 5, 2, 7))

# [1]  0 NA  2  3  4  1  5

}
