% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{one_doublet_diff_var_clust}
\alias{one_doublet_diff_var_clust}
\title{Generate Doublets with Different Variance Clusters and Noise}
\usage{
one_doublet_diff_var_clust(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates data with one set of doublets (pairs of clusters) having
clusters with different variance, along with added background noise.
}
\examples{

# Generate doublets with different variance clusters and noise with custom parameters
set.seed(20240412)
data <- one_doublet_diff_var_clust(
  n = 260, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
