% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circulars.R
\name{three_circulars}
\alias{three_circulars}
\title{Generate Three Circular Clusters with Noise}
\usage{
three_circulars(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the three circular clusters with added noise.
}
\description{
This function generates three circular clusters in 4D space with added noise dimensions.
}
\examples{
set.seed(20240412)
circular_clusters_data <- three_circulars(
  n = 300, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
