% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangular.R
\name{tri_3d}
\alias{tri_3d}
\title{Generate Triangular 3D Datasets with Noise}
\usage{
tri_3d(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the triangular 3D datasets with added noise.
}
\description{
This function generates triangular 3D datasets with added noise dimensions.
}
\examples{
set.seed(20240412)
triangular_3d_data <- tri_3d(
  n = 100, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
