% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_curve.R
\name{two_scurve_hole}
\alias{two_scurve_hole}
\title{Generate Two S-Curve Data with Noise}
\usage{
two_scurve_hole(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the two S-curve datasets with added noise.
}
\description{
This function generates two S-curve data with noise.
}
\examples{

# Generate two S-curve data with noise with custom parameters
set.seed(20240412)
data <- two_scurve_hole(
  n = 200, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
