% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carfima.sim.R
\name{carfima.sim}
\alias{carfima.sim}
\title{Simulating a CARFIMA(p,H,q) time series}
\usage{
carfima.sim(parameter, time, ar.p, ma.q)
}
\arguments{
\item{parameter}{A vector of length \eqn{p+q+2} for the generative values of the model parameters; 
\eqn{p} values of \eqn{\alpha_j}'s, \eqn{q} values of \eqn{\beta_j}'s, \eqn{H} and \eqn{\sigma}.}

\item{time}{A vector for the \eqn{k} observation times, either regularly or irregularly spaced.}

\item{ar.p}{A scalar for the order of the AR model.}

\item{ma.q}{A scalar for the order of the MA model.}
}
\value{
The outcome of \code{carfima.sim} is a vector for \eqn{k} simulated data following a \code{CARFIMA(p,H,q)} 
model given the values for the model parameters and observation times.
}
\description{
The function \code{carfima.sim} produces discrete time series data that follow a \code{CARFIMA(p,H,q)} model 
given the values for the model parameters and observation times.
}
\section{Details}{

This function produces simulated discrete time series data following a \code{CARFIMA(p,H,q)} model given the 
values for the model parameters and observation times. It first derives a \eqn{k}-dimensional multivariate 
Gaussian distribution whose mean set to a vector of zeroes, where \eqn{k} is the number of observations. 
The covariance matrix is then filled with \eqn{Cov(Y_{t_i}, Y_{t_j})} and its closed-form formula is 
specified in Theorem 1(b) and 1(c) of Tsai and Chan (2005).
}

\examples{
##### Irregularly spaced observation time generation.
##### For CRAN testing, time is set to be very short.

length.time <- 10
time.temp <- rexp(length.time, rate = 2)
time <- rep(NA, length.time + 1)
time[1] <- 0
for (i in 2 : (length.time + 1)) {
  time[i] <- time[i - 1] + time.temp[i - 1]
}
time <- time[-1]

##### Data genration for CARFIMA(1, H, 0) based on the observation times. 

parameter <- c(-0.4, 0.75, 0.2) 
# AR parameter alpha = -0.4
# Hurst parameter = 0.75
# process uncertainty sigma = 0.2
y <- carfima.sim(parameter = parameter, time = time, ar.p = 1, ma.q = 0)  

 
}
\references{
\insertRef{tsai_maximum_2005}{carfima}
}
