% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prebuild.R
\name{prebuild}
\alias{prebuild}
\title{Prepare for Building the Package Source}
\usage{
prebuild(pkgroot = ".", what = c("register_calls", "documentation"))
}
\arguments{
\item{pkgroot}{The root directory of the package.}

\item{what}{A character vector indicating the desired action. If it contains
\code{"register_calls"}, the function (re)generates Rust code. If it
contains \code{"documentation"}, the function (re)generates documentation.}
}
\value{
\code{NULL}, invisibly.
}
\description{
This function generates documentation and/or Rust registration code,
depending on the value of \code{what}.
}
\details{
If a package's usage of \code{\link[base:CallExternal]{base::.Call()}} changes, rerun this function to
update the \code{src/rust/src/registration.rs} file.

Likewise, if a package's documentation changes, run this function to generate
documentation using \code{\link[roxygen2:roxygenize]{roxygen2::roxygenise()}} and then automatically move it
from \code{man} to \code{man}. When the source package is installed,
examples in the documentation are adjusted according based on whether the
Rust can be compiled at that time. Lines in the examples that start with
\verb{#' # R_CARGO} are deleted if Rust can be compiled, otherwise, the line
is preserved (with \verb{# R_CARGO} itself removed).
}
