% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lookAhead}
\alias{lookAhead}
\title{Look Ahead to Select Next Item}
\usage{
lookAhead(catObj, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{item}{A numeric indicating the question item the respondent is currently answering.}
}
\value{
A function \code{lookAhead} returns a list of one element named \code{estimates}, which is itself a data frame.
The the first column of the data frame is the possible response option to the question the respondent
is currently answering and the second column is the next item that should be asked given each response.
}
\description{
Selects the next item that would be asked for all possible response options to the question the respondent is currently answering.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## What should be asked next if respondent is currently answering item 6
lookAhead(ltm_cat, 6)

## Loading grm Cat object
data(grm_cat)

## Store example answers
setAnswers(grm_cat) <- c(4,3,5,1,1, rep(NA, 13))

## What should be asked next if respondent is currently answering item 6
lookAhead(grm_cat, 6)


}
\seealso{
\code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
