% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{toWideMatrix}
\alias{toWideMatrix}
\title{Converts 3d array of CATA data to a wide 2d matrix format}
\usage{
toWideMatrix(X)
}
\arguments{
\item{X}{three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) where values are \code{0} (not checked) 
or \code{1} (checked)}
}
\value{
A matrix with \code{J} products in rows and \code{I} 
assessors * \code{M} attributes in columns
}
\description{
Converts a three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) to a two-dimensional matrix
(\code{J} products, (\code{I} assessors, \code{M} attributes))
}
\examples{
data(bread)

# convert CATA results from the first 10 consumers and the first 4 attributes
# to a wide matrix
toWideMatrix(bread$cata[1:10,,1:4])
}
