% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catching-n-plans.R
\name{with_ordered_handlers}
\alias{with_ordered_handlers}
\title{Establish handlers on the stack (in order)}
\usage{
with_ordered_handlers(.expr, ...)
}
\arguments{
\item{.expr}{An expression to execute in a context where new handlers are established.}

\item{\dots}{Named handlers. These should be functions of one argument. These handlers are treated as exiting by default. Use \code{\link[rlang:calling]{rlang::calling()}} to specify a calling handler. These dots support \link[rlang:tidy-dots]{tidy dots} features and are passed to \code{\link[rlang:as_function]{rlang::as_function()}} to enable the formula shortcut for lambda functions.}
}
\description{
\strong{Note}: \code{with_ordered_handlers()} is \emph{not} designed to play nice with the rest of the catchr framework, and is exported as a utility function users might find useful elsewhere. Do not consider this a stable part of the API.

\code{with_ordered_handlers()} is inspired by \code{rlang}'s \code{\link[rlang:with_handlers]{rlang::with_handlers()}} function, which essentially lets you handle conditions in ways that don't stop the evaluation ("calling" handlers) and ways that will immediately break out of the evaluation ("exiting" handlers) in a single function.

However, \code{with_handlers} does not check handlers in the order they are inputted (at least, in rlang 0.3.0), as \code{\link[base:withCallingHandlers]{base::withCallingHandlers()}} and \code{\link[base:tryCatch]{base::tryCatch()}} do: all exiting handlers are checked first, then all calling handlers. \code{with_ordered_handlers()} makes sure all handlers are checked in the order they are input into the function, regardless of exiting/calling status.
}
\examples{
# Although set first, 'condition' never gets to catch the condition
rlang::with_handlers(warning("woops!"),
              condition = rlang::calling(function(x) print("CONDITION")),
              warning = rlang::exiting(function(x) { print("WARNING")}))

# Should print for both
with_ordered_handlers(warning("woops!"),
              condition = rlang::calling(function(x) print("CONDITION")),
              warning = rlang::exiting(function(x) { print("WARNING")}))
}
