% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_greta.R
\name{dag_greta}
\alias{dag_greta}
\title{Generate a representive sample of the posterior distribution}
\usage{
dag_greta(graph, mcmc = TRUE, meaningfulLabels = TRUE, ...)
}
\arguments{
\item{graph}{a graph object of class \code{causact_graph} representing a complete and conistent specification of a joint distribution.}

\item{mcmc}{a logical value indicating whether to sample from the posterior distribution.  When \code{mcmc=FALSE}, the greta code is printed to the console, but not executed.  The user can cut and paste the code to another script for running line-by-line.  This option is most useful for debugging purposes. When \code{mcmc=TRUE}, the code is executed and outputs a dataframe of posterior draws.}

\item{meaningfulLabels}{a logical value indicating whether to replace the indexed variable names in \code{draws} with abbreviated names representing the factor value corresponding to the index.  This argument is treated as \code{TRUE} regardless of user input.  The ability to retain numerical indexing will be in a subsequent release.}

\item{...}{additional arguments to be passed onto \code{greta::mcmc()}.}
}
\value{
If \code{mcmc=TRUE}, returns a dataframe of posterior distribution samples corresponding to the input `causact_graph`.  Each column is a parameter and each row a draw from the posterior sample output.  If \code{mcmc=FALSE}, running \code{dag_greta} returns a character string of code that would help the user create three objects representing the posterior distribution:
\enumerate{
\item \code{draws}:  An mcmc.list object containing raw output from the HMCMC sampler used by \code{greta}.
\item \code{drawsDF}:  A wide data frame with all latent variables as columns and all draws as rows.  This data frame is useful for calculations based on the posterior
\item \code{tidyDrawsDF}:  A long data frame with each draw represented on one line.  This data frame is useful for plotting posterior distributions.
}
}
\description{
The input graph object should be of class \code{causact_graph} and created using \code{dag_create()}.  The specification of a completely consistent joint distribution is left to the user.  Helpful error messages are scheduled for future versions of the \code{causact} package.
}
\examples{
library(greta)
graph = dag_create() \%>\%
  dag_node("Get Card","y",
           rhs = bernoulli(theta),
           data = carModelDF$getCard) \%>\%
  dag_node(descr = "Card Probability by Car",label = "theta",
           rhs = beta(2,2),
           child = "y") \%>\%
  dag_node("Car Model","x",
           data = carModelDF$carModel,
           child = "y") \%>\%
  dag_plate("Car Model","x",
            data = carModelDF$carModel,
            nodeLabels = "theta")

graph \%>\% dag_render()
gretaCode = graph \%>\% dag_greta(mcmc=FALSE)
\dontrun{
## default functionality returns a data frame
# below requires Tensorflow installation
drawsDF = graph \%>\% dag_greta()
drawsDF \%>\% dagp_plot()
}
}
