% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_patients.R
\name{.get_clinical_pat_by_list_item}
\alias{.get_clinical_pat_by_list_item}
\title{Get clinical data by attribute, study ID and patient ID}
\usage{
.get_clinical_pat_by_list_item(
  study_id = NULL,
  patient_id = NULL,
  clinical_attribute = NULL,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{patient_id}{a cBioPortal patient_id}

\item{clinical_attribute}{one or more clinical attributes for your study.
If none provided, will return all attributes available for studies}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
a dataframe of a specific clinical attribute
}
\description{
Get clinical data by attribute, study ID and patient ID
}
\examples{
\dontrun{
.get_clinical_pat_by_list_item(study_id = "msk_impact_2017",
 patient_id = "P-0001453",
  base_url = 'www.cbioportal.org/api')
  }

}
\keyword{internal}
