% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_asymp.R
\name{test_asymp}
\alias{test_asymp}
\title{Asymptotic test}
\usage{
test_asymp(Y, X, Z = NULL, space_y = FALSE, number_y = length(unique(Y)))
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expression for a given gene from \code{n} samples (or cells).}

\item{X}{a data frame of numeric or factor vector(s) of size \code{n}
containing the variable(s) to be tested (the condition(s))}

\item{Z}{a data frame of numeric or factor vector(s) 
of size \code{n} containing the covariate(s)}

\item{space_y}{a logical flag indicating whether the y thresholds are spaced. 
When \code{space_y} is \code{TRUE}, a regular sequence between the minimum and 
the maximum of the observations is used. Default is \code{FALSE}.}

\item{number_y}{an integer value indicating the number of y thresholds (and therefore
the number of regressions) to perform the test. Default is \code{length(Y)}.}
}
\value{
A data frame with the following elements:
\itemize{
  \item \code{raw_pval} contains the raw p-values for a given gene.
  \item \code{Stat} contains the test statistic for a given gene.
}
}
\description{
Asymptotic test
}
\examples{

X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
res_asymp <- test_asymp(Y,data.frame(X=X))
}
