% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_ccdf.R
\name{weights_ccdf}
\alias{weights_ccdf}
\title{Computation of weights for CCDF, used in permut function when \code{dist_permuations} is specified.}
\usage{
weights_ccdf(Y, X, Z = NULL)
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expressions from \code{n} samples (or cells).}

\item{X}{a numeric or factor vector(s) of size \code{n}
containing the variable to be tested (the condition to be tested). 
Multiple variables are not allowed}

\item{Z}{a numeric vector of size \code{n}
containing the covariate.
Multiple variables are not allowed}
}
\value{
\code{w} a vector of weights
}
\description{
Computation of weights for CCDF, used in permut function when \code{dist_permuations} is specified.
}
\examples{

X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
res_asymp <- weights_ccdf(Y,X)
}
\keyword{internal}
