% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{angleCells}
\alias{angleCells}
\title{Angle between Two Tracks}
\usage{
angleCells(X, cellids, degrees = TRUE)
}
\arguments{
\item{X}{a tracks object}

\item{cellids}{a vector of two indices specifying the tracks to get steps from.}

\item{degrees}{logical; should angle be returned in degrees instead of radians? (defaults to \code{TRUE})}
}
\value{
A single angle.
}
\description{
Compute the angle between the displacement vectors of two tracks in the dataset.
}
\examples{
## Find the angle between the tracks with ids 1 and 2
angleCells( TCells, c("1","2") )
}
\seealso{
\code{\link{distanceCells}} to compute the minimum distance between the tracks,
and \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
