% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtracks.R
\name{selectSteps}
\alias{selectSteps}
\title{Get Single Steps Starting at a Specific Time from a Subset of Tracks}
\usage{
selectSteps(X, trackids, t)
}
\arguments{
\item{X}{Tracks object to obtain subtracks from}

\item{trackids}{Character vector with the ids of tracks of interest}

\item{t}{Timepoint at which the subtracks should start}
}
\value{
A \emph{tracks} object is returned which contains all the extracted steps.
}
\description{
Obtain all single steps starting at a given timepoint t from a subset of tracks of interest.
}
\examples{
## Get and plot all steps starting at the third timepoint in tracks 1 and 3 of
## the T cell dataset
subT <- selectSteps( TCells, c("1","5"), timePoints(TCells)[3] )
plot( subT )

}
\seealso{
\code{\link{subtracks}} to extract all subtracks of a given length,
\code{\link{prefixes}} to extract all subtracks of a given length starting
from the first coordinate in each track, \code{\link{subtracksByTime}} to
extract all subtracks of a given length starting at some fixed timepoint, and
\code{\link{timePoints}} to return all timepoints occurring in the dataset.
}
