% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_functions.r
\name{ca}
\alias{ca}
\title{Create Cellular Automaton}
\usage{
ca(wolframrule, initialstate, steps = 100, ncols = 101, wrap = TRUE)
}
\arguments{
\item{wolframrule}{integer identifying the algorithm according to Wolfram numbering}

\item{initialstate}{a vector setting up the initial state}

\item{steps}{integer spacifying for how long to run the algorithm}

\item{ncols}{how many columns to have. If `initialstate` is specified, `ncols` is
calculated as `length(initialstate)`. If `initialstate` is not specified,
it is defined as a 1 in the middle of zeros. For instance, with the
default `ncols = 11`, the `initialstate` is a vector of 5 zeros, 1,
and another 5 zeros.}

\item{wrap}{boolean, default is TRUE. Whether it uses a circular wrap at the
end and beginning of lines. If FALSE it puts empty slots on the first
and last columns.}
}
\value{
an object of class `c("cellular_automaton", "matrix")`
}
\description{
Create Cellular Automaton
}
\examples{
# Wolfram's rule 30
ca(30)

# Wolfram's rule 126 with a random initial state
ca(126,
   initialstate = sample(c(0, 1), size = 100, replace = TRUE),
   steps = 100)

}
\references{
<https://en.wikipedia.org/wiki/Cellular_automaton>
}
\author{
Adapted from code by Nicola Procopio
}
