% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_functions.r
\name{plot.cellular_automata}
\alias{plot.cellular_automata}
\title{Plot a cellular automaton}
\usage{
\method{plot}{cellular_automata}(
  x,
  time_flow = "down",
  circle = FALSE,
  title = paste("Rule: ", attr(x, "wolfram_rule")),
  animate = FALSE,
  ...
)
}
\arguments{
\item{x}{A cellular automaton, usually previously defined by `ca()`.}

\item{time_flow}{String: "down" (default) or "up". Whether time flow is
represented as going from top-to-bottom or bottom-to-top.}

\item{circle}{Whether to make the plot circular. Default is FALSE.}

\item{title}{Title of the plot. Use `NULL` to remove.}

\item{animate}{Whether to return a gganimate object instead of a static
ggplot. Default FALSE.}

\item{...}{Not used (included for consistency with the `plot` generic).}
}
\value{
A ggplot of the visual representation of the cellular automaton,
       or a gganimate object.
}
\description{
Plot a cellular automaton
}
\examples{
ca(30) |> plot()
ca(30, ncols = 100, steps = 100) |> plot()
ca(45, ncols = 100, steps = 100) |> plot()
ca(86, ncols = 100, steps = 100) |> plot()

# use a random initial state
ca(126,
   initialstate = sample(c(0, 1), size = 100, replace = TRUE),
   steps = 100) |>
 plot()

}
