% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntROC.R
\name{IntROC}
\alias{IntROC}
\title{Time-dependent ROC curve estimation for interval-censored survival data}
\usage{
IntROC(L, R, M, t, U = NULL, method = "emp", method2 = "pa", dist = "weibull",
        bw = NULL, ktype = "normal", len = 151, B = 0, alpha = 0.05, plot = "TRUE")
}
\arguments{
\item{L}{The numericvector of left limit of observed time. For left censored observations \code{L == 0}.}

\item{R}{The numericvector of right limit of observed time. For right censored observation \code{R == inf}.}

\item{M}{The numeric vector of marker values.}

\item{t}{A scaler time point used to calculate the ROC curve.}

\item{U}{The numeric vector of cutoff values.}

\item{method}{The method of ROC curve estimation. The possible options are "\code{emp}" empirical metod; "\code{untra}" smooth without boundary correction and "\code{tra}" is smooth ROC curve estimation with boundary correction. The default is the "\code{emp}" empirical method.}

\item{method2}{A character indication type of modeling. This include nonparametric \code{"np"}, parmetric \code{"pa"} and semiparametric \code{"sp"}. The default is the "\code{np}" parametric with weibull distribution.}

\item{dist}{A character incating the type of distribution for parametric model. This includes are \code{"exponential"}, \code{"weibull"}, \code{"gamma"}, \code{"lnorm"}, \code{"loglogistic"} and \code{"generalgamma"}.}

\item{bw}{A character string specifying the bandwidth estimation method. The possible options are "\code{NR}" for the normal reference, the plug-in "\code{PI}" and the cross-validation "\code{CV}". The default is the "\code{NR}" normal reference method. It is also possible to use a numeric value.}

\item{ktype}{A character string giving the type kernel distribution to be used for smoothing the ROC curve: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". By default, the "\code{normal}" kernel is used.}

\item{len}{The length of the grid points for ROC estimation. Default is \code{151}.}

\item{B}{The number of bootstrap samples to be used for variance estimation. The default is \code{0}, no variance estimation.}

\item{alpha}{The significance level. The default is \code{0.05}.}

\item{plot}{The logigal parameter to see the ROC curve plot. Default is \code{TRUE}.}
}
\value{
Returns the following items:

\code{ROC     } The vector of estimated ROC values. These will be numeric numbers between zero

\code{        } and one.

\code{U       } The vector of grid points used.

\code{AUC      } A data frame of dimension \eqn{1 \times 4}. The columns are: AUC, standard error of AUC, the lower

\code{         }               and upper limits of bootstrap CI.

\code{bw       } The computed value of bandwidth. For the empirical method this is always \code{NA}.

\code{Dt      } The vector of estimated event status.

\code{M       } The vector of Marker values.
}
\description{
This function computes the time-dependent ROC curve for interval censored survival data using the cumulative sensitivity and dynamic specificity definitions.
 The ROC curves can be either empirical (non-smoothed) or smoothed with/without boundary correction. It also calculates the time-dependent AUC.
}
\details{
This function implments time-dependent ROC curve and the corresponding AUC using the model-band and nonparametric for the estimation of conditional survival function. The empirical (non-smoothed) ROC estimate and the smoothed ROC estimate with/without boundary correction can be obtained using this function.
The smoothed ROC curve estimators require selecting a bandwidth parametr for smoothing the ROC curve. To this end, three data-driven methods: the normal reference "\code{NR}", the plug-in "\code{PI}" and the cross-validation "\code{CV}" were implemented.
See Beyene and El Ghouch (2020) for details.
}
\examples{
library(cenROC)

data(hds)

IntROC(L=hds$L, R=hds$R, M=hds$M, t=2)$AUC

}
\references{
Beyene, K. M. and El Ghouch A. (2020). Time-dependent ROC curves estimator for interval-censored survival data.
}
