% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlquery.r
\name{censys_query}
\alias{censys_query}
\title{Issue SQL Queries against the Censys API}
\usage{
censys_query(sql)
}
\arguments{
\item{sql}{SQL query string}
}
\value{
API call result (invisibly)
}
\description{
The Query API allows executing SQL queries against our daily snapshots and raw data
analogous to the Query web interface. Queries are executed asynchronously. You must
first start a job, then check its status. Once a job has completed, you can view
paginated results using the get results endpoint. Jobs typically require 15-30
seconds to execute; results can be viewed for 24 hours after the job completed.
Ddefinition endpoints are also exposed where you can list the series and view series
details (i.e., list tables and schema).
}
\details{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\examples{
\dontrun{
q <- censys_query("SELECT p443.https.tls.cipher_suite.name, count(ip) FROM ipv4
                   WHERE p443.https.tls.validation.browser_trusted=true
                   GROUP BY p443.https.tls.cipher_suite.name;")
censys_get_job_status(q$job_id)
censys_get_job_result(q$job_id)
}
}
\references{
Censys SQL query syntax: \url{https://censys.io/query};
            API doc: \url{https://www.censys.io/api/v1/docs/search}
}

