% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.const}
\alias{cg.const}
\title{Add Constant}
\arguments{
\item{value}{numeric vector or array, value of the node (optional).}

\item{name}{character scalar, name of the node (optional). In case argument \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg.node, constant.
}
\description{
Add a constant node to the graph.
}
\details{
\code{$const(value, name)}
}
\note{
Constants are ignored when differentiating a graph. The intended use of constants is that they are given a fixed value. However, it is still possible to change the value of constants when evaluating or differentiating a graph (see \link[cgraph]{run} and \link[cgraph]{gradients} for more details).

The name of the constant node cannot be 'grad' as this is a reserved word.

There is a wrapper function \link[cgraph]{const} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a constant with value 1 and name 'c' to the graph.
x$const(1, name = "c")

}
\author{
Ron Triepels
}
