% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chattr-use.R
\name{chattr_use}
\alias{chattr_use}
\title{Sets the LLM model to use in your session}
\usage{
chattr_use(x = NULL, ...)
}
\arguments{
\item{x}{A pre-determined provider/model name, an \code{ellmer} \code{Chat} object,
or the path to a YAML file that contains a valid \code{chattr} model specification.
The value 'test' is also acceptable, but it is meant for package examples,
and internal testing. See 'Details' for more information.}

\item{...}{Default values to modify.}
}
\value{
It returns console messages to allow the user select the model to
use.
}
\description{
Sets the LLM model to use in your session
}
\details{
The valid pre-determined provider/models values are: 'databricks-dbrx',
'databricks-meta-llama31-70b', 'databricks-mixtral8x7b', 'gpt41-mini',
'gpt41-nano', 'gpt41', 'gpt4o', and 'ollama'.

If you need a provider, or model, not available as a pre-determined value,
create an \code{ellmer} chat object and pass that to \code{chattr_use()}. The list of
valid models are found here: https://ellmer.tidyverse.org/index.html#providers
\subsection{Set a default}{

You can setup an R \code{option} to designate a default provider/model connection.
To do this, pass an \code{ellmer} connection command you wish to use
in the \code{.chattr_chat} option, for example: \code{options(.chattr_chat = ellmer::chat_anthropic())}.
If you add that code to  your \emph{.Rprofile}, \code{chattr} will use that as the default
model and settings to use every time you start an R session. Use the
\code{usethis::edit_r_profile()} command to easily edit your \emph{.Rprofile}.
}
}
\examples{
\dontrun{

# Use a valid provider/model label
chattr_use("gpt41-mini")

# Pass an `ellmer` object
my_chat <- ellmer::chat_anthropic()
chattr_use(my_chat)
}

}
