% Generated by roxygen2 (4.0.2): do not edit by hand
\name{checkString}
\alias{assertString}
\alias{checkString}
\alias{testString}
\title{Check if an argument is a string}
\usage{
checkString(x, na.ok = FALSE)

assertString(x, na.ok = FALSE, .var.name)

testString(x, na.ok = FALSE)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertString} throws an error message,
 \code{testString} returns \code{FALSE} and \code{checkString} returns
 a string with the error message.
}
\description{
A string a scalar character vector.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testString("a")
testString(letters)
}
\seealso{
Other scalars: \code{\link{assertCount}},
  \code{\link{checkCount}}, \code{\link{testCount}};
  \code{\link{assertFlag}}, \code{\link{checkFlag}},
  \code{\link{testFlag}}; \code{\link{assertInt}},
  \code{\link{checkInt}}, \code{\link{testInt}};
  \code{\link{assertNumber}}, \code{\link{checkNumber}},
  \code{\link{testNumber}}; \code{\link{assertPercentage}},
  \code{\link{checkPercentage}},
  \code{\link{testPercentage}};
  \code{\link{assertScalarNA}},
  \code{\link{checkScalarNA}}, \code{\link{testScalarNA}};
  \code{\link{assertScalar}}, \code{\link{checkScalar}},
  \code{\link{testScalar}}
}

