% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFlag.r
\name{checkFlag}
\alias{assertFlag}
\alias{assert_flag}
\alias{checkFlag}
\alias{expect_flag}
\alias{testFlag}
\alias{test_flag}
\title{Check if an argument is a flag}
\usage{
checkFlag(x, na.ok = FALSE)

assertFlag(x, na.ok = FALSE, add = NULL, .var.name)

assert_flag(x, na.ok = FALSE, add = NULL, .var.name)

testFlag(x, na.ok = FALSE)

test_flag(x, na.ok = FALSE)

expect_flag(x, na.ok = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertFlag}/\code{assert_flag}
 throws an error message, \code{testFlag}/\code{test_flag}
 returns \code{FALSE},
 and \code{checkFlag} returns a string with the error message.
 The function \code{expect_flag} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
A flag is defined as single logical value.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testFlag(TRUE)
testFlag(1)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkInt}}, \code{\link{checkNumber}},
  \code{\link{checkScalarNA}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}

