% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMatrix.R
\name{checkMatrix}
\alias{checkMatrix}
\alias{check_matrix}
\alias{assertMatrix}
\alias{assert_matrix}
\alias{testMatrix}
\alias{test_matrix}
\alias{expect_matrix}
\title{Check if an argument is a matrix}
\usage{
checkMatrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

check_matrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

assertMatrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_matrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testMatrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

test_matrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE
)

expect_matrix(
  x,
  mode = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  min.rows = NULL,
  max.rows = NULL,
  min.cols = NULL,
  max.cols = NULL,
  nrows = NULL,
  ncols = NULL,
  row.names = NULL,
  col.names = NULL,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{mode}{[\code{character(1)}]\cr
Storage mode of the array. Arrays can hold vectors, i.e. \dQuote{logical},
\dQuote{integer}, \dQuote{integerish}, \dQuote{double}, \dQuote{numeric}, \dQuote{complex},
\dQuote{character} and \dQuote{list}. You can also specify \dQuote{atomic}
here to explicitly prohibit lists. Default is \code{NULL} (no check).
If all values of \code{x} are missing, this check is skipped.}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are matrices with only missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{max.rows}{[\code{integer(1)}]\cr
Maximum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{max.cols}{[\code{integer(1)}]\cr
Maximum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to test for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertMatrix}/\code{assert_matrix} return 
 \code{x} invisibly, whereas
 \code{checkMatrix}/\code{check_matrix} and 
 \code{testMatrix}/\code{test_matrix} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertMatrix}/\code{assert_matrix}
 throws an error message, 
 \code{testMatrix}/\code{test_matrix}
 returns \code{FALSE},
 and \code{checkMatrix}/\code{check_matrix} 
 return a string with the error message.
 The function \code{expect_matrix} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a matrix
}
\examples{
x = matrix(1:9, 3)
colnames(x) = letters[1:3]
testMatrix(x, nrows = 3, min.cols = 1, col.names = "named")
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomic}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkInteger}()},
\code{\link{checkIntegerish}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}

Other compound: 
\code{\link{checkArray}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDataTable}()},
\code{\link{checkTibble}()}
}
\concept{basetypes}
\concept{compound}
